from django.contrib.auth.models import Permission
from django.db import models

# Create your models here.
from Subscriber.models import User


class Intensity(models.Model):
    intensity = models.IntegerField(null=True,blank=True)
    maxValue = models.IntegerField()
    medValue = models.IntegerField()
    minValue = models.IntegerField()

class Inol(models.Model):
    maxInol = models.FloatField()
    modInol = models.FloatField()
    minInol = models.FloatField()

class ExerciseCategory(models.Model):
    ACTIVE = 1
    INACTIVE = 0
    CHOICES = (
        (ACTIVE, ('User active in Category')),
        (INACTIVE, ('User does not active in Category'))
    )
    categoryName = models.CharField(max_length=200, null=True)
    status = models.SmallIntegerField(CHOICES, default=1)
    createdBy = models.ForeignKey(User,null = True, on_delete=models.CASCADE, related_name='Category')
    modifiedBy = models.ForeignKey(User, null =True, on_delete=models.CASCADE, related_name='Categories')
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class ExerciseType(models.Model):
    ACTIVE = 1
    INACTIVE = 0
    CHOICES = (
        (ACTIVE, ('User active in ExerciseType')),
        (INACTIVE, ('User does not does not active in ExerciseType'))
    )
    exerciseTypeName = models.CharField(max_length=100, blank=False)
    exerciseTypeCode = models.CharField(max_length=50, blank=False)
    exerciseTypeStatus = models.SmallIntegerField(choices=CHOICES,default=1)
    exerciseTypeDesc = models.TextField(blank=True, null=True)
    exerciseCategory = models.ForeignKey(ExerciseCategory, null=True, blank=True, on_delete=models.CASCADE)
    equipment = models.TextField(blank=True,null=True)
    createdBy = models.ForeignKey(User,null = True, on_delete=models.CASCADE, related_name='extype')
    modifiedBy = models.ForeignKey(User, null =True, on_delete=models.CASCADE, related_name='extypeMod')
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class Videos(models.Model):
    ACTIVE = 1
    INACTIVE = 0
    CHOICES = (
        (ACTIVE, ('User active in Videos')),
        (INACTIVE, ('User does not does not active in Videos'))
    )
    videoLink = models.CharField(max_length=255,null=True,blank=True)
    createdBy = models.ForeignKey(User,null = True, on_delete=models.CASCADE, related_name='videoCreator')
    modifiedBy = models.ForeignKey(User, null =True, on_delete=models.CASCADE, related_name='videoModifier')
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)
    videosStatus = models.SmallIntegerField(CHOICES, default=1)
    youtubeUrl = models.BooleanField(default=True)

class PlanPurposes(models.Model):
    GoalName = models.CharField(max_length=200)
    parentGoalName = models.ForeignKey('self',null=True, on_delete=models.CASCADE)
    createdBy = models.ForeignKey(User, null=True, on_delete=models.CASCADE, related_name='PP')
    modifiedBy = models.ForeignKey(User, null=True, on_delete=models.CASCADE, related_name='PP1')
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class PlanAbilities(models.Model):
    ability = models.CharField(max_length=200)
    desc = models.TextField(blank=True, null=True)
    createdBy = models.ForeignKey(User, null=True, on_delete=models.CASCADE, related_name='Ability')
    modifiedBy = models.ForeignKey(User, null=True, on_delete=models.CASCADE, related_name='Ability1')
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class Exercise(models.Model):
    ACTIVE = 1
    INACTIVE = 0
    CHOICES = (
        (ACTIVE, ('User active in Exercise')),
        (INACTIVE, ('User does not does not active in Exercise'))
    )
    exerciseName = models.CharField(max_length=100, blank=False)
    exerciseCode = models.CharField(max_length=50, blank=False)
    exerciseStatus = models.SmallIntegerField(CHOICES,default=1)
    exerciseDesc = models.TextField(blank=True, null=True)
    equipment = models.TextField(blank=True,null=True)
    video = models.ForeignKey(Videos,blank=True, null=True, related_name='exVideo', on_delete=models.CASCADE)
    derivedFrom = models.IntegerField(default=0, blank=True, null=True)
    derivedFormula = models.CharField(max_length=255, blank=True, null=True)
    workFormula = models.FloatField(blank=True,null=True)
    exerciseType = models.ForeignKey(ExerciseType, blank=True, null=True, on_delete=models.CASCADE)
    olympicLift = models.IntegerField(default=0)
    olympicParent = models.IntegerField(default=0)
    olympicFormula = models.FloatField(default=1)
    exIcon = models.CharField(max_length=255,null=True)
    preExInstructions = models.TextField(null=True)
    postExInstructions = models.TextField(null=True)
    accessLevel = models.SmallIntegerField(default=0)
    weightExists = models.BooleanField(default=False)
    distanceExists = models.BooleanField(default=False)
    timeExists = models.BooleanField(default=False)
    repsExists = models.BooleanField(default=False)
    exAbilities = models.TextField(null=True)
    setInstructions = models.TextField(null=True)
    speedExists = models.BooleanField(default=False)
    heightExists = models.BooleanField(default=False)
    timeShortest = models.BooleanField(null=True)
    createdBy = models.ForeignKey(User,null = True, on_delete=models.CASCADE, related_name='ex')
    modifiedBy = models.ForeignKey(User, null =True, on_delete=models.CASCADE, related_name='exMod')
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)
    exOrder = models.IntegerField(null=True)

class NewExercise(models.Model):
    ACTIVE = 1
    INACTIVE = 0
    CHOICES = (
        (ACTIVE, ('User active in Exercise')),
        (INACTIVE, ('User does not does not active in Exercise'))
    )
    exerciseName = models.CharField(max_length=100, blank=False)
    exerciseStatus = models.SmallIntegerField(CHOICES,default=1)
    exerciseDesc = models.TextField(blank=True, null=True)
    equipment = models.TextField(blank=True,null=True)
    video = models.CharField(max_length=100,blank=True, null=True)
    thumb_image=models.CharField(max_length=100,blank=True,null=True)
    cover_image=models.CharField(max_length=100,blank=True,null=True)
    stressFactor = models.FloatField(blank=True,null=True)
    exCoeffiecient = models.FloatField(blank=True,null=True)
    exIcon = models.CharField(max_length=255,null=True)
    exGroup = models.CharField(max_length=255,null=True)
    exMainGroup = models.CharField(max_length=255,null=True)
    flowType = models.CharField(max_length=255,null=True)
    preExInstructions = models.TextField(null=True)
    postExInstructions = models.TextField(null=True)
    accessLevel = models.SmallIntegerField(default=0)
    weightExists = models.BooleanField(default=False)
    distanceExists = models.BooleanField(default=False)
    timeExists = models.BooleanField(default=False)
    repsExists = models.BooleanField(default=False)
    setInstructions = models.TextField(null=True)
    speedExists = models.BooleanField(default=False)
    heightExists = models.BooleanField(default=False)
    timeShortest = models.BooleanField(null=True)
    createdBy = models.ForeignKey(User,null = True, on_delete=models.CASCADE, related_name='newEx')
    modifiedBy = models.ForeignKey(User, null =True, on_delete=models.CASCADE, related_name='newExMod')
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)
    distanceFactor=models.FloatField(blank=True,null=True)

class AdvExercises(models.Model):
    exercise = models.ForeignKey(Exercise, on_delete=models.CASCADE)
    straightActivity = models.BooleanField(null=True)
    complexActivity = models.BooleanField(null=True)
    complexMethod = models.TextField(null=True)
    complexInstructions = models.TextField(null=True)
    complexRounds = models.IntegerField(default=0)
    maxWeight = models.BooleanField(null=True)
    maxReps = models.BooleanField(null=True)
    maxTime = models.BooleanField(null=True)
    maxDistance  = models.BooleanField(null=True)
    maxSpeed = models.BooleanField(null=True)
    maxHeight = models.BooleanField(null=True)
    tmaxReps = models.FloatField(null=True)
    tmaxWeight = models.FloatField(null=True)
    tmaxDistance  = models.FloatField(null=True)
    tmaxTime = models.FloatField(null=True)
    tmaxSpeed = models.FloatField(null=True)
    tmaxHeight = models.FloatField(null=True)
    parentExercise = models.ForeignKey(Exercise,null=True,related_name='peX', on_delete=models.CASCADE)
    tmaxTestInst = models.TextField(null=True)
    exPurpose = models.TextField(null=True)

class ExcerciseTypeVideos(models.Model):
    ACTIVE = 1
    INACTIVE = 0
    CHOICES = (
        (ACTIVE, ('User active in ExcerciseTypeVideos')),
        (INACTIVE, ('User does not does not active in ExcerciseTypeVideos'))
    )
    excerciseType = models.ForeignKey(ExerciseType,null=True,blank=True, on_delete=models.CASCADE)
    video = models.ForeignKey(Videos,null=True,blank=True, on_delete=models.CASCADE)
    createdBy = models.ForeignKey(User,null = True, on_delete=models.CASCADE, related_name='extypevideo')
    modifiedBy = models.ForeignKey(User, null =True, on_delete=models.CASCADE, related_name='extypevideoMod')
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)
    excerciseStatus = models.SmallIntegerField(CHOICES, default=1)

class ExcerciseVideos(models.Model):
    ACTIVE = 1
    INACTIVE = 0
    CHOICES = (
        (ACTIVE, ('User active in ExcerciseVideos')),
        (INACTIVE, ('User does not does not active in ExcerciseVideos'))
    )
    excercise = models.ForeignKey(Exercise,null=True,blank=True, on_delete=models.CASCADE)
    video = models.ForeignKey(Videos,null=True,blank=True, on_delete=models.CASCADE)
    createdBy = models.ForeignKey(User,null = True, on_delete=models.CASCADE, related_name='exvideo')
    modifiedBy = models.ForeignKey(User, null =True, on_delete=models.CASCADE, related_name='exvideoMod')
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)
    excerciseVideosStatus = models.SmallIntegerField(CHOICES, default=1)

class ProgramType(models.Model):
    ACTIVE = 1
    INACTIVE = 0
    CHOICES = (
        (ACTIVE, ('User active in ProgramType')),
        (INACTIVE, ('User does not does not active in ProgramType'))
    )
    programTypeName = models.CharField(max_length=150, blank=False)
    createdBy = models.ForeignKey(User,null = True, on_delete=models.CASCADE, related_name='video_creator')
    modifiedBy = models.ForeignKey(User, null =True, on_delete=models.CASCADE, related_name='video_modifier')
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)
    programTypeStatus = models.SmallIntegerField(CHOICES, default=1)

    def __str__(self):
        return self.programTypeName

class Goals(models.Model):
    ACTIVE = 1
    INACTIVE = 0
    CHOICES = (
        (ACTIVE, ('User active in Goals')),
        (INACTIVE, ('User does not does not active in Goals'))
    )
    goalName = models.CharField(max_length=100,null=True,blank=True)
    goalStatus = models.SmallIntegerField(CHOICES, default=1)
    parentGoal = models.ForeignKey('self', null=True, blank=True, related_name='pa_goal', on_delete=models.CASCADE)
    createdBy = models.ForeignKey(User,null = True, on_delete=models.CASCADE, related_name='goal')
    modifiedBy = models.ForeignKey(User, null =True, on_delete=models.CASCADE, related_name='goalMod')
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class InolRange(models.Model):
    ACTIVE = 1
    INACTIVE = 0
    CHOICES = (
        (ACTIVE, ('User active in InolRange')),
        (INACTIVE, ('User does not does not active in InolRange'))
    )
    level = models.IntegerField(null=True,blank=True)
    minValue = models.IntegerField(null=True,blank=True)
    maxValue = models.IntegerField(null=True,blank=True)
    avgValue = models.IntegerField(null=True,blank=True)
    stressValue = models.IntegerField(null=True,blank=True)
    createdBy = models.ForeignKey(User,null = True, on_delete=models.CASCADE, related_name='Inol')
    modifiedBy = models.ForeignKey(User, null =True, on_delete=models.CASCADE, related_name='InolMod')
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)
    inolRangeStatus = models.SmallIntegerField(CHOICES, default=1)

class Roles(models.Model):
    ACTIVE = 1
    INACTIVE = 0
    CHOICES = (
        (ACTIVE, ('User active in Roles')),
        (INACTIVE, ('User does not does not active in Roles'))
    )
    role = models.CharField(max_length=30)
    roleStatus = models.SmallIntegerField(CHOICES, default=1)
    createdBy = models.ForeignKey(User,null = True, on_delete=models.CASCADE, related_name='Roal')
    modifiedBy = models.ForeignKey(User, null =True, on_delete=models.CASCADE, related_name='RoalModifier')
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class UserRoles(models.Model):
    ACTIVE = 1
    INACTIVE = 0
    CHOICES = (
        (ACTIVE, ('User active in UserRoles')),
        (INACTIVE, ('User does not does not active in UserRoles'))
    )
    roles = models.ForeignKey(Roles, on_delete=models.CASCADE)
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    userStatus = models.SmallIntegerField(CHOICES, default=1)
    createdBy = models.ForeignKey(User,null = True, on_delete=models.CASCADE, related_name='UserRoal')
    modifiedBy = models.ForeignKey(User, null =True, on_delete=models.CASCADE, related_name='UserRoalModifier')
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class rolepermissions(models.Model):
    ACTIVE = 1
    INACTIVE = 0
    CHOICES = (
        (ACTIVE, ('User active in rolepermissions')),
        (INACTIVE, ('User does not active in rolepermissions'))
    )
    permissionStatus = models.SmallIntegerField(CHOICES, default=1)
    roles = models.ForeignKey(Roles, on_delete=models.CASCADE)
    permissions = models.ForeignKey(Permission, on_delete=models.CASCADE)

class protocols(models.Model):
    protocolName = models.CharField(max_length=100, null=True, blank=True)
    protocolType = models.CharField(max_length=100, null=True, blank=True)
    protocolMethod = models.CharField(max_length=100, null=True, blank=True)
    protocolLevel = models.CharField(max_length=100, null=True, blank=True)
    createdBy = models.ForeignKey(User,null = True, on_delete=models.CASCADE, related_name='proto')
    modifiedBy = models.ForeignKey(User, null =True, on_delete=models.CASCADE, related_name='protoMod')
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class Country(models.Model):
    ACTIVE = 1
    INACTIVE = 0
    CHOICES = (
        (ACTIVE, ('User active in Country')),
        (INACTIVE, ('User does not active in Country'))
    )
    name = models.CharField(max_length=200, null=True)
    countryStatus = models.SmallIntegerField(CHOICES, default=1)
    dialCode = models.CharField(max_length = 15, null = True)
    countryCode = models.CharField(max_length = 10, null = True)
    createdBy = models.ForeignKey(User,null = True, on_delete=models.CASCADE, related_name='Country')
    modifiedBy = models.ForeignKey(User, null =True, on_delete=models.CASCADE, related_name='Countries')
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class State(models.Model):
    ACTIVE = 1
    INACTIVE = 0
    CHOICES = (
        (ACTIVE, ('User active in State')),
        (INACTIVE, ('User does not active in State'))
    )
    country = models.ForeignKey(Country, on_delete=models.CASCADE)
    name = models.CharField(max_length=200, null=True)
    stateStatus = models.SmallIntegerField(CHOICES, default=1)
    createdBy = models.ForeignKey(User,null = True, on_delete=models.CASCADE, related_name='State')
    modifiedBy = models.ForeignKey(User, null =True, on_delete=models.CASCADE, related_name='States')
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class PartnerType(models.Model):
    partnerTypeName = models.CharField(max_length=200)
    partnerTypeCode = models.CharField(max_length=10)
    createdBy = models.ForeignKey(User, null=True, on_delete=models.CASCADE, related_name='PT')
    modifiedBy = models.ForeignKey(User, null=True, on_delete=models.CASCADE, related_name='PT1')
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class PriceMapping(models.Model):
    inr = models.FloatField()
    usd = models.FloatField()


class Partners(models.Model):
    partnerName = models.CharField(max_length=200,null=True)
    partnerImage = models.CharField(max_length=200,null=True)
    partnerLink = models.TextField(null=True)
    createdBy = models.ForeignKey(User, null=True, on_delete=models.CASCADE, related_name='Pa')
    modifiedBy = models.ForeignKey(User, null=True, on_delete=models.CASCADE, related_name='Pa1')
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class PriceConversion(models.Model):
    inrValue = models.FloatField()
    usdValue = models.FloatField()

class AppVersion(models.Model):
    version = models.CharField(max_length=20)
    deviceType = models.CharField(max_length=20,null=True)
    
class TrainingLevel(models.Model):
    trainingLevel = models.CharField(max_length=150, blank=False)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)
    status = models.SmallIntegerField(default=1)

class TmaxLookup(models.Model):
    excercise = models.ForeignKey(Exercise, on_delete=models.CASCADE)
    bodyWeight = models.IntegerField()
    gender = models.IntegerField()
    trainingLevel= models.ForeignKey(TrainingLevel, on_delete=models.CASCADE)
    weight = models.FloatField()

class FullMeals(models.Model):
    FullMeals=models.TextField(blank=True,null=True)

class Science(models.Model):
    name=models.CharField(max_length=250,null=True)
    blog_link=models.CharField(max_length=250,null=True)
    status=models.BooleanField(default=False)
