# Generated by Django 4.1.5 on 2023-04-08 12:39

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('Subscriber', '0001_initial'),
        ('auth', '0012_alter_user_first_name_max_length'),
    ]

    operations = [
        migrations.CreateModel(
            name='AppVersion',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('version', models.CharField(max_length=20)),
                ('deviceType', models.CharField(max_length=20, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Country',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200, null=True)),
                ('countryStatus', models.SmallIntegerField(default=1, verbose_name=((1, 'User active in Country'), (0, 'User does not active in Country')))),
                ('dialCode', models.CharField(max_length=15, null=True)),
                ('countryCode', models.CharField(max_length=10, null=True)),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
                ('createdBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='Country', to='Subscriber.user')),
                ('modifiedBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='Countries', to='Subscriber.user')),
            ],
        ),
        migrations.CreateModel(
            name='Exercise',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('exerciseName', models.CharField(max_length=100)),
                ('exerciseCode', models.CharField(max_length=50)),
                ('exerciseStatus', models.SmallIntegerField(default=1, verbose_name=((1, 'User active in Exercise'), (0, 'User does not does not active in Exercise')))),
                ('exerciseDesc', models.TextField(blank=True, null=True)),
                ('equipment', models.TextField(blank=True, null=True)),
                ('derivedFrom', models.IntegerField(blank=True, default=0, null=True)),
                ('derivedFormula', models.CharField(blank=True, max_length=255, null=True)),
                ('workFormula', models.FloatField(blank=True, null=True)),
                ('olympicLift', models.IntegerField(default=0)),
                ('olympicParent', models.IntegerField(default=0)),
                ('olympicFormula', models.FloatField(default=1)),
                ('exIcon', models.CharField(max_length=255, null=True)),
                ('preExInstructions', models.TextField(null=True)),
                ('postExInstructions', models.TextField(null=True)),
                ('accessLevel', models.SmallIntegerField(default=0)),
                ('weightExists', models.BooleanField(default=False)),
                ('distanceExists', models.BooleanField(default=False)),
                ('timeExists', models.BooleanField(default=False)),
                ('repsExists', models.BooleanField(default=False)),
                ('exAbilities', models.TextField(null=True)),
                ('setInstructions', models.TextField(null=True)),
                ('speedExists', models.BooleanField(default=False)),
                ('heightExists', models.BooleanField(default=False)),
                ('timeShortest', models.BooleanField(null=True)),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
                ('exOrder', models.IntegerField(null=True)),
                ('createdBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='ex', to='Subscriber.user')),
            ],
        ),
        migrations.CreateModel(
            name='ExerciseCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('categoryName', models.CharField(max_length=200, null=True)),
                ('status', models.SmallIntegerField(default=1, verbose_name=((1, 'User active in Category'), (0, 'User does not active in Category')))),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
                ('createdBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='Category', to='Subscriber.user')),
                ('modifiedBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='Categories', to='Subscriber.user')),
            ],
        ),
        migrations.CreateModel(
            name='FullMeals',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('FullMeals', models.TextField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Inol',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('maxInol', models.FloatField()),
                ('modInol', models.FloatField()),
                ('minInol', models.FloatField()),
            ],
        ),
        migrations.CreateModel(
            name='Intensity',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('intensity', models.IntegerField(blank=True, null=True)),
                ('maxValue', models.IntegerField()),
                ('medValue', models.IntegerField()),
                ('minValue', models.IntegerField()),
            ],
        ),
        migrations.CreateModel(
            name='PriceConversion',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('inrValue', models.FloatField()),
                ('usdValue', models.FloatField()),
            ],
        ),
        migrations.CreateModel(
            name='PriceMapping',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('inr', models.FloatField()),
                ('usd', models.FloatField()),
            ],
        ),
        migrations.CreateModel(
            name='Roles',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('role', models.CharField(max_length=30)),
                ('roleStatus', models.SmallIntegerField(default=1, verbose_name=((1, 'User active in Roles'), (0, 'User does not does not active in Roles')))),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
                ('createdBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='Roal', to='Subscriber.user')),
                ('modifiedBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='RoalModifier', to='Subscriber.user')),
            ],
        ),
        migrations.CreateModel(
            name='Science',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=250, null=True)),
                ('blog_link', models.CharField(max_length=250, null=True)),
                ('status', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='TrainingLevel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('trainingLevel', models.CharField(max_length=150)),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
                ('status', models.SmallIntegerField(default=1)),
            ],
        ),
        migrations.CreateModel(
            name='Videos',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('videoLink', models.CharField(blank=True, max_length=255, null=True)),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
                ('videosStatus', models.SmallIntegerField(default=1, verbose_name=((1, 'User active in Videos'), (0, 'User does not does not active in Videos')))),
                ('youtubeUrl', models.BooleanField(default=True)),
                ('createdBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='videoCreator', to='Subscriber.user')),
                ('modifiedBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='videoModifier', to='Subscriber.user')),
            ],
        ),
        migrations.CreateModel(
            name='UserRoles',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('userStatus', models.SmallIntegerField(default=1, verbose_name=((1, 'User active in UserRoles'), (0, 'User does not does not active in UserRoles')))),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
                ('createdBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='UserRoal', to='Subscriber.user')),
                ('modifiedBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='UserRoalModifier', to='Subscriber.user')),
                ('roles', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='utility.roles')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='Subscriber.user')),
            ],
        ),
        migrations.CreateModel(
            name='TmaxLookup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('bodyWeight', models.IntegerField()),
                ('gender', models.IntegerField()),
                ('weight', models.FloatField()),
                ('excercise', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='utility.exercise')),
                ('trainingLevel', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='utility.traininglevel')),
            ],
        ),
        migrations.CreateModel(
            name='State',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200, null=True)),
                ('stateStatus', models.SmallIntegerField(default=1, verbose_name=((1, 'User active in State'), (0, 'User does not active in State')))),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
                ('country', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='utility.country')),
                ('createdBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='State', to='Subscriber.user')),
                ('modifiedBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='States', to='Subscriber.user')),
            ],
        ),
        migrations.CreateModel(
            name='rolepermissions',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('permissionStatus', models.SmallIntegerField(default=1, verbose_name=((1, 'User active in rolepermissions'), (0, 'User does not active in rolepermissions')))),
                ('permissions', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='auth.permission')),
                ('roles', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='utility.roles')),
            ],
        ),
        migrations.CreateModel(
            name='protocols',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('protocolName', models.CharField(blank=True, max_length=100, null=True)),
                ('protocolType', models.CharField(blank=True, max_length=100, null=True)),
                ('protocolMethod', models.CharField(blank=True, max_length=100, null=True)),
                ('protocolLevel', models.CharField(blank=True, max_length=100, null=True)),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
                ('createdBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='proto', to='Subscriber.user')),
                ('modifiedBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='protoMod', to='Subscriber.user')),
            ],
        ),
        migrations.CreateModel(
            name='ProgramType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('programTypeName', models.CharField(max_length=150)),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
                ('programTypeStatus', models.SmallIntegerField(default=1, verbose_name=((1, 'User active in ProgramType'), (0, 'User does not does not active in ProgramType')))),
                ('createdBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='video_creator', to='Subscriber.user')),
                ('modifiedBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='video_modifier', to='Subscriber.user')),
            ],
        ),
        migrations.CreateModel(
            name='PlanPurposes',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('GoalName', models.CharField(max_length=200)),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
                ('createdBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='PP', to='Subscriber.user')),
                ('modifiedBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='PP1', to='Subscriber.user')),
                ('parentGoalName', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='utility.planpurposes')),
            ],
        ),
        migrations.CreateModel(
            name='PlanAbilities',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ability', models.CharField(max_length=200)),
                ('desc', models.TextField(blank=True, null=True)),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
                ('createdBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='Ability', to='Subscriber.user')),
                ('modifiedBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='Ability1', to='Subscriber.user')),
            ],
        ),
        migrations.CreateModel(
            name='PartnerType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('partnerTypeName', models.CharField(max_length=200)),
                ('partnerTypeCode', models.CharField(max_length=10)),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
                ('createdBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='PT', to='Subscriber.user')),
                ('modifiedBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='PT1', to='Subscriber.user')),
            ],
        ),
        migrations.CreateModel(
            name='Partners',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('partnerName', models.CharField(max_length=200, null=True)),
                ('partnerImage', models.CharField(max_length=200, null=True)),
                ('partnerLink', models.TextField(null=True)),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
                ('createdBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='Pa', to='Subscriber.user')),
                ('modifiedBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='Pa1', to='Subscriber.user')),
            ],
        ),
        migrations.CreateModel(
            name='NewExercise',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('exerciseName', models.CharField(max_length=100)),
                ('exerciseStatus', models.SmallIntegerField(default=1, verbose_name=((1, 'User active in Exercise'), (0, 'User does not does not active in Exercise')))),
                ('exerciseDesc', models.TextField(blank=True, null=True)),
                ('equipment', models.TextField(blank=True, null=True)),
                ('video', models.CharField(blank=True, max_length=100, null=True)),
                ('thumb_image', models.CharField(blank=True, max_length=100, null=True)),
                ('cover_image', models.CharField(blank=True, max_length=100, null=True)),
                ('stressFactor', models.FloatField(blank=True, null=True)),
                ('exCoeffiecient', models.FloatField(blank=True, null=True)),
                ('exIcon', models.CharField(max_length=255, null=True)),
                ('exGroup', models.CharField(max_length=255, null=True)),
                ('exMainGroup', models.CharField(max_length=255, null=True)),
                ('flowType', models.CharField(max_length=255, null=True)),
                ('preExInstructions', models.TextField(null=True)),
                ('postExInstructions', models.TextField(null=True)),
                ('accessLevel', models.SmallIntegerField(default=0)),
                ('weightExists', models.BooleanField(default=False)),
                ('distanceExists', models.BooleanField(default=False)),
                ('timeExists', models.BooleanField(default=False)),
                ('repsExists', models.BooleanField(default=False)),
                ('setInstructions', models.TextField(null=True)),
                ('speedExists', models.BooleanField(default=False)),
                ('heightExists', models.BooleanField(default=False)),
                ('timeShortest', models.BooleanField(null=True)),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
                ('distanceFactor', models.FloatField(blank=True, null=True)),
                ('createdBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='newEx', to='Subscriber.user')),
                ('modifiedBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='newExMod', to='Subscriber.user')),
            ],
        ),
        migrations.CreateModel(
            name='InolRange',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('level', models.IntegerField(blank=True, null=True)),
                ('minValue', models.IntegerField(blank=True, null=True)),
                ('maxValue', models.IntegerField(blank=True, null=True)),
                ('avgValue', models.IntegerField(blank=True, null=True)),
                ('stressValue', models.IntegerField(blank=True, null=True)),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
                ('inolRangeStatus', models.SmallIntegerField(default=1, verbose_name=((1, 'User active in InolRange'), (0, 'User does not does not active in InolRange')))),
                ('createdBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='Inol', to='Subscriber.user')),
                ('modifiedBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='InolMod', to='Subscriber.user')),
            ],
        ),
        migrations.CreateModel(
            name='Goals',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('goalName', models.CharField(blank=True, max_length=100, null=True)),
                ('goalStatus', models.SmallIntegerField(default=1, verbose_name=((1, 'User active in Goals'), (0, 'User does not does not active in Goals')))),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
                ('createdBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='goal', to='Subscriber.user')),
                ('modifiedBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='goalMod', to='Subscriber.user')),
                ('parentGoal', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='pa_goal', to='utility.goals')),
            ],
        ),
        migrations.CreateModel(
            name='ExerciseType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('exerciseTypeName', models.CharField(max_length=100)),
                ('exerciseTypeCode', models.CharField(max_length=50)),
                ('exerciseTypeStatus', models.SmallIntegerField(choices=[(1, 'User active in ExerciseType'), (0, 'User does not does not active in ExerciseType')], default=1)),
                ('exerciseTypeDesc', models.TextField(blank=True, null=True)),
                ('equipment', models.TextField(blank=True, null=True)),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
                ('createdBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='extype', to='Subscriber.user')),
                ('exerciseCategory', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='utility.exercisecategory')),
                ('modifiedBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='extypeMod', to='Subscriber.user')),
            ],
        ),
        migrations.AddField(
            model_name='exercise',
            name='exerciseType',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='utility.exercisetype'),
        ),
        migrations.AddField(
            model_name='exercise',
            name='modifiedBy',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='exMod', to='Subscriber.user'),
        ),
        migrations.AddField(
            model_name='exercise',
            name='video',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='exVideo', to='utility.videos'),
        ),
        migrations.CreateModel(
            name='ExcerciseVideos',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
                ('excerciseVideosStatus', models.SmallIntegerField(default=1, verbose_name=((1, 'User active in ExcerciseVideos'), (0, 'User does not does not active in ExcerciseVideos')))),
                ('createdBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='exvideo', to='Subscriber.user')),
                ('excercise', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='utility.exercise')),
                ('modifiedBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='exvideoMod', to='Subscriber.user')),
                ('video', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='utility.videos')),
            ],
        ),
        migrations.CreateModel(
            name='ExcerciseTypeVideos',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
                ('excerciseStatus', models.SmallIntegerField(default=1, verbose_name=((1, 'User active in ExcerciseTypeVideos'), (0, 'User does not does not active in ExcerciseTypeVideos')))),
                ('createdBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='extypevideo', to='Subscriber.user')),
                ('excerciseType', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='utility.exercisetype')),
                ('modifiedBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='extypevideoMod', to='Subscriber.user')),
                ('video', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='utility.videos')),
            ],
        ),
        migrations.CreateModel(
            name='AdvExercises',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('straightActivity', models.BooleanField(null=True)),
                ('complexActivity', models.BooleanField(null=True)),
                ('complexMethod', models.TextField(null=True)),
                ('complexInstructions', models.TextField(null=True)),
                ('complexRounds', models.IntegerField(default=0)),
                ('maxWeight', models.BooleanField(null=True)),
                ('maxReps', models.BooleanField(null=True)),
                ('maxTime', models.BooleanField(null=True)),
                ('maxDistance', models.BooleanField(null=True)),
                ('maxSpeed', models.BooleanField(null=True)),
                ('maxHeight', models.BooleanField(null=True)),
                ('tmaxReps', models.FloatField(null=True)),
                ('tmaxWeight', models.FloatField(null=True)),
                ('tmaxDistance', models.FloatField(null=True)),
                ('tmaxTime', models.FloatField(null=True)),
                ('tmaxSpeed', models.FloatField(null=True)),
                ('tmaxHeight', models.FloatField(null=True)),
                ('tmaxTestInst', models.TextField(null=True)),
                ('exPurpose', models.TextField(null=True)),
                ('exercise', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='utility.exercise')),
                ('parentExercise', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='peX', to='utility.exercise')),
            ],
        ),
    ]
