from django.db import models

# Create your models here.
from Subscriber.models import User

class Admin(models.Model):
    email = models.EmailField()
    username = models.CharField(max_length=100,null=True,blank=True)
    password = models.CharField(max_length=255,null=True)
    first_name = models.CharField(max_length=50,null=True)
    middle_name = models.CharField(max_length=50,null=True)
    last_name = models.CharField(max_length=50,null=True)
    is_active = models.SmallIntegerField(default=1)
    createdBy = models.ForeignKey(User,related_name="admincreated", on_delete=models.CASCADE)
    updatedBy = models.ForeignKey(User,related_name = "adminupdated", on_delete=models.CASCADE)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)
