from django.db import models

# Create your models here.
from Plan.models import Plan
from Subscriber.models import User
from Userplan.models import UserPlan

class Order(models.Model):
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    status = models.IntegerField(default=0)
    totalAmount = models.CharField(max_length=155)
    transation_id = models.CharField(max_length=155)
    paymentDate = models.DateTimeField(blank=True, null=True)
    payFrom = models.DateTimeField(blank=True, null=True)
    payTo = models.DateTimeField(blank=True, null=True)

class OrderDetail(models.Model):
    order = models.ForeignKey(Order, on_delete=models.CASCADE)
    forUser = models.ForeignKey(User, on_delete=models.CASCADE,related_name='orderdetail_for')
    payeeid = models.ForeignKey(User, on_delete=models.CASCADE,related_name='orddet_payee')
    plan = models.ForeignKey(Plan, on_delete=models.CASCADE,related_name='orderedplan',null=True)
    userplan = models.ForeignKey(UserPlan, on_delete=models.CASCADE,related_name='ordereduserplan',null=True)
    totalAmount = models.CharField(max_length=155)

class PlatFormCharges(models.Model):
    order = models.ForeignKey(Order, on_delete=models.CASCADE,related_name='plat_order')
    forUser = models.ForeignKey(User, on_delete=models.CASCADE,related_name='plat_for')
    payeeid = models.ForeignKey(User, on_delete=models.CASCADE,related_name='plat_payee')
    amount = models.CharField(max_length=155)
    payFrom = models.DateTimeField(blank=True, null=True)
    payTo = models.DateTimeField(blank=True, null=True)

class CoachCharges(models.Model):
    order = models.ForeignKey(Order, on_delete=models.CASCADE,related_name='coach_order')
    forUser = models.ForeignKey(User, on_delete=models.CASCADE,related_name='coach_for')
    payeeid = models.ForeignKey(User, on_delete=models.CASCADE,related_name='coach_payee')
    amount = models.CharField(max_length=155)
    payFrom = models.DateTimeField(blank=True, null=True)
    payTo = models.DateTimeField(blank=True, null=True)

class TransactionHistory(models.Model):
    paidBy = models.ForeignKey(User, on_delete=models.CASCADE,related_name='paidBy')
    userplan = models.ForeignKey(UserPlan, on_delete=models.CASCADE,related_name='UserPlan',null=True)
    paidTo = models.CharField(max_length=155,blank=True, null=True)
    purpose = models.CharField(max_length=155)
    amount = models.FloatField()
    transation_id = models.CharField(max_length=155)
    createdDate = models.DateTimeField(auto_now_add=True)
