import json
import re
from datetime import datetime
import base64
import collections

from django.core.mail import EmailMultiAlternatives
from django.forms import model_to_dict
from django.http import HttpResponse
from django.shortcuts import render
from django.template.loader import render_to_string
from django.views.decorators.cache import never_cache
from django.http import JsonResponse
try: # for pip >= 10
    from pip._internal.req.req_install import logger
except ImportError: # for pip <= 9.0.3
    from pip.req.req_install import logger

#from psycopg2._json import Json
from rest_framework.decorators import api_view, authentication_classes
from StratFit import settings
from Plan.models import Plan, DraftedPlan, SelectedAbilities, PlanGoals,PlanShortUrls
from StratFitOrganization.models import Organization
from Subscriber.Authentication import SessionAuthentication, IsAuthenticated, StartFitSessionUtil
from Subscriber.models import User, SocialProfile
from partner.models import PlanMonetization, AgentPlanMonetization, AgentPlanProposals
from Subscriber.views import exceptionMail
from utility.views import officeMail

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def partnerAcceptedProposal(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    acceptdata = json.loads(request.body.decode('utf-8'))
    req = acceptdata
    url = "partner/acceptuserproposal/"
    try:
        if username != None:
            acceptdata = json.loads(request.body.decode('utf-8'))
            print(acceptdata)
            if acceptdata['license_id'] == "3":
                planType = "White-Label"
            else:
                planType = "Co-Brand"
            pmId = acceptdata['planMontId']
            pmVal = PlanMonetization.objects.get(pk = pmId)
            pmVal.planType = planType
            pmVal.save()
            planVal = Plan.objects.get(id = acceptdata['plan_id'])

            apm = AgentPlanMonetization.objects.create(
                planMonetization_id = pmId,
                plan_id_id=acceptdata['plan_id'],
                proposer_id_id = user,
                proposal = acceptdata['royalty'],
                counterProposal = acceptdata['royalty'],
                proposerstate = 1,
                coachstate = 1,
                proposalstate = 1
            )
            apm.save()
            agentplanmonetization_id = apm.id

            pacptdata2 = AgentPlanProposals.objects.create(
                agentplan_id = agentplanmonetization_id,
                message = "Accepted Coach proposal",
                user_id = user,
                receiver_id = acceptdata['coach_id']
            )
            pacptdata2.save()
            #print('----royalty saved into plan table 002----')
            planid = acceptdata['plan_id']
            introyalty = 100-int(re.search(r'\d+', acceptdata['royalty']).group())
            royalty = introyalty
            licencePolicy = acceptdata['license_id']

            planid = planid
            plandata2 = Plan.objects.get(id=planid)
            plandata2.royalty = royalty
            plandata2.licencePolicy = planType
            plandata2.proposedState = 1
            plandata2.save()


            uid = user
            rid = acceptdata['coach_id']
            planName = planVal.planName
            createduplicateinf(planid,user,uid,licencePolicy)
            dealclosedconfirmation(uid, rid, planName,acceptdata['royalty'],licencePolicy)
            return JsonResponse({"success":True,"message": "status changed"})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getTotalLicensePlans(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    req = "GET"
    url = "gettotal/licenseplans/"
    try:
        #print(user)
        if username != None:
            directselldata = PlanMonetization.objects.select_related('Plan__id','User__id').values('id','plan_id_id','plan_id_id__planName','plan_id_id__planStatus','plan_id_id__price','license_id','royalty','template','templateContent','coach_id_id','coach_id_id__first_name','coach_id_id__last_name','coach_id_id__username','coach_id_id__email','plan_id_id__planDescription','coach_id__avatar','plan_id_id__ability','plan_id_id__programType__programTypeName','plan_id_id__duration_weeks','plan_id_id__createdBy_id','plan_id_id__originalPlanner_id').filter(license_id = 1,plan_id_id__planStatus=1,plan_id_id__activationStatus=1)#.exclude(coach_id_id = user)
            directsellArr =[]
            for dt in directselldata:
                planObj = dict(dt)
                planurls = PlanShortUrls.objects.filter(plan_id=planObj['plan_id_id']).values()
                if planurls.exists():
                    for val in planurls:
                        valObj = dict(val)
                        urlVal = valObj['longUrl'].split('/')
                        urlVal1 = urlVal[6].split('=')
                        urlVal2 = urlVal1[1].split('&')
                        planObj[urlVal2[0]] = valObj['shortUrl']
                if planObj['plan_id_id__createdBy_id'] == planObj['plan_id_id__originalPlanner_id']:
                    if planObj['plan_id_id__programType__programTypeName'] == "STARTER":
                        planObj['plan_id_id__programType__programTypeName'] = "BEGINNER"
                        print("TESTING HERE")

                    planAbilityVal = SelectedAbilities.objects.select_related('PlanAbilities').filter(plan_id=planObj['plan_id_id']).values(
                        'ability_id__ability')
                    abilities = ''
                    for val in planAbilityVal:
                        valObj = dict(val)
                        abilities += ", " + valObj['ability_id__ability']
                    if abilities != '':
                        planAbilities = abilities[1:]
                    else:
                        planAbilities = ""

                    planPurposesVal = PlanGoals.objects.select_related('PlanPurposes').filter(plan_id = planObj['plan_id_id']).values('planGoal_id__GoalName')
                    purposes = ''
                    for val in planPurposesVal:
                        valObj = dict(val)
                        purposes += ", "+valObj['planGoal_id__GoalName']
                    if purposes != '':
                        planGoals = purposes[1:]
                    else:
                        planGoals = ""
                    planObj['plan_id_id__ability'] = planAbilities

                    secret_code_plain = planObj ['plan_id_id__planName'] + '#' + str(planObj ['plan_id_id'])
                    secret_code_encode = base64.b64encode(secret_code_plain.encode('ascii'))
                    encodedVal = str(secret_code_encode).split("'")
                    planObj['encodedurl'] = encodedVal[1]

                    if planObj['royalty'] != None and planObj['royalty'] != '' and planObj['royalty'] != '0' and planObj['royalty'] != 0:
                        planObj['offerPrice'] = str((100-int(planObj['royalty'][:-1])))+"%"
                    else:
                        planObj['offerPrice'] = planObj['royalty']
                    draftedPlans = DraftedPlan.objects.filter(planId_id = planObj['plan_id_id'],status = 1).values('planId_id','planJson','protocolJson')
                    if draftedPlans.exists():
                        for df in draftedPlans:
                            draftData = dict(df)
                            planObj['planJson'] = draftData['planJson']
                            #dataObj['protocolJson'] = draftData['protocolJson']
                    else:
                        planObj['planJson'] = ''
                    directsellArr.append(planObj)

            cobranddata = PlanMonetization.objects.select_related('Plan__id','User__id').values('id','plan_id_id','plan_id_id__planName','plan_id_id__programType__programTypeName','plan_id_id__planGoal__goalName','plan_id_id__planStatus','plan_id_id__price','license_id','royalty','template','templateContent','coach_id_id__first_name','coach_id_id','coach_id_id__last_name','coach_id_id__username','coach_id_id__email','plan_id_id__planDescription','coach_id__avatar','plan_id_id__ability','plan_id_id__programType__programTypeName','plan_id_id__duration_weeks','plan_id_id__createdBy_id','plan_id_id__originalPlanner_id','plan_id_id__planLogo').filter(license_id = 2,plan_id_id__planStatus=1,plan_id_id__activationStatus=1)#.exclude(coach_id_id = user)
            cobranddataArr =[]
            for dt in cobranddata:
                planObj = dict(dt)
                if planObj['plan_id_id__planLogo'] != None and planObj['plan_id_id__planLogo'] !='':
                    planObj['plan_id_id__planLogo'] = settings.S3URL + planObj['plan_id_id__planLogo']
                planurls = PlanShortUrls.objects.filter(plan_id=planObj['plan_id_id']).values()
                if planurls.exists():
                    for val in planurls:
                        valObj = dict(val)
                        urlVal = valObj['longUrl'].split('/')
                        urlVal1 = urlVal[6].split('=')
                        urlVal2 = urlVal1[1].split('&')
                        planObj[urlVal2[0]] = valObj['shortUrl']
                if planObj['plan_id_id__createdBy_id'] == planObj['plan_id_id__originalPlanner_id']:
                    if planObj['plan_id_id__programType__programTypeName'] == "STARTER":
                        planObj['plan_id_id__programType__programTypeName'] = "BEGINNER"
                        print("TESTING HERE")

                    planAbilityVal = SelectedAbilities.objects.select_related('PlanAbilities').filter(plan_id=planObj['plan_id_id']).values(
                        'ability_id__ability')
                    abilities = ''
                    for val in planAbilityVal:
                        valObj = dict(val)
                        abilities += ", " + valObj['ability_id__ability']
                    if abilities != '':
                        planAbilities = abilities[1:]
                    else:
                        planAbilities = ""

                    planPurposesVal = PlanGoals.objects.select_related('PlanPurposes').filter(plan_id = planObj['plan_id_id']).values('planGoal_id__GoalName')
                    purposes = ''
                    for val in planPurposesVal:
                        valObj = dict(val)
                        purposes += ", "+valObj['planGoal_id__GoalName']
                    if purposes != '':
                        planGoals = purposes[1:]
                    else:
                        planGoals = ""
                    planObj['plan_id_id__planGoal__goalName'] = planGoals
                    planObj['plan_id_id__ability'] = planAbilities

                    secret_code_plain = planObj ['plan_id_id__planName'] + '#' + str(planObj ['plan_id_id'])
                    secret_code_encode = base64.b64encode(secret_code_plain.encode('ascii'))
                    encodedVal = str(secret_code_encode).split("'")
                    planObj['encodedurl'] = encodedVal[1]

                    if planObj['royalty'] != None and planObj['royalty'] != '' and planObj['royalty'] != '0' and planObj['royalty'] != 0:
                        planObj['offerPrice'] = str((100-int(planObj['royalty'][:-1])))+"%"
                    else:
                        planObj['offerPrice'] = planObj['royalty']
                    draftedPlans = DraftedPlan.objects.filter(planId_id = planObj['plan_id_id'],status = 1).values('planId_id','planJson','protocolJson')
                    if draftedPlans.exists():
                        for df in draftedPlans:
                            draftData = dict(df)
                            planObj['planJson'] = draftData['planJson']
                            #dataObj['protocolJson'] = draftData['protocolJson']
                    else:
                        planObj['planJson'] = ''
                    cobranddataArr.append(planObj)

            whitebranddata = PlanMonetization.objects.select_related('Plan__id','User__id').values('id','plan_id_id','plan_id_id__planName','plan_id_id__planGoal__goalName','plan_id_id__planStatus','plan_id_id__price','license_id','royalty','template','templateContent','coach_id_id__first_name','coach_id_id','coach_id_id__last_name','coach_id_id__username','coach_id_id__email','plan_id_id__planDescription','coach_id__avatar','plan_id_id__ability','plan_id_id__duration_weeks','plan_id_id__programType__programTypeName','plan_id_id__createdBy_id','plan_id_id__originalPlanner_id','plan_id_id__planLogo').filter(license_id = 3,plan_id_id__planStatus=1,plan_id_id__activationStatus=1)#.exclude(coach_id_id = user)
            whitebranddataArr =[]
            for dt in whitebranddata:
                planObj = dict(dt)
                if planObj['plan_id_id__planLogo'] != None and planObj['plan_id_id__planLogo'] !='':
                    planObj['plan_id_id__planLogo'] = settings.S3URL + planObj['plan_id_id__planLogo']
                planurls = PlanShortUrls.objects.filter(plan_id=planObj['plan_id_id']).values()
                if planurls.exists():
                    for val in planurls:
                        valObj = dict(val)
                        urlVal = valObj['longUrl'].split('/')
                        urlVal1 = urlVal[6].split('=')
                        urlVal2 = urlVal1[1].split('&')
                        planObj[urlVal2[0]] = valObj['shortUrl']
                if planObj['plan_id_id__createdBy_id'] == planObj['plan_id_id__originalPlanner_id']:
                    if planObj['plan_id_id__programType__programTypeName'] == "STARTER":
                        planObj['plan_id_id__programType__programTypeName'] = "BEGINNER"
                        print("TESTING HERE")

                    planAbilityVal = SelectedAbilities.objects.select_related('PlanAbilities').filter(plan_id=planObj['plan_id_id']).values(
                        'ability_id__ability')
                    abilities = ''
                    for val in planAbilityVal:
                        valObj = dict(val)
                        abilities += ", " + valObj['ability_id__ability']
                    if abilities != '':
                        planAbilities = abilities[1:]
                    else:
                        planAbilities = ""

                    planPurposesVal = PlanGoals.objects.select_related('PlanPurposes').filter(plan_id = planObj['plan_id_id']).values('planGoal_id__GoalName')
                    purposes = ''
                    for val in planPurposesVal:
                        valObj = dict(val)
                        purposes += ", "+valObj['planGoal_id__GoalName']
                    if purposes != '':
                        planGoals = purposes[1:]
                    else:
                        planGoals = ""
                    planObj['plan_id_id__planGoal__goalName'] = planGoals
                    planObj['plan_id_id__ability'] = planAbilities

                    secret_code_plain = planObj ['plan_id_id__planName'] + '#' + str(planObj ['plan_id_id'])
                    secret_code_encode = base64.b64encode(secret_code_plain.encode('ascii'))
                    encodedVal = str(secret_code_encode).split("'")
                    planObj['encodedurl'] = encodedVal[1]

                    if planObj['royalty'] != None and planObj['royalty'] != '' and planObj['royalty'] != '0' and planObj['royalty'] != 0:
                        planObj['offerPrice'] = str((100-int(planObj['royalty'][:-1])))+"%"
                    else:
                        planObj['offerPrice'] = planObj['royalty']
                    draftedPlans = DraftedPlan.objects.filter(planId_id = planObj['plan_id_id'],status = 1).values('planId_id','planJson','protocolJson')
                    if draftedPlans.exists():
                        for df in draftedPlans:
                            draftData = dict(df)
                            planObj['planJson'] = draftData['planJson']
                            #dataObj['protocolJson'] = draftData['protocolJson']
                    else:
                        planObj['planJson'] = ''
                    whitebranddataArr.append(planObj)

            prodata = AgentPlanMonetization.objects.select_related('PlanMonetization__id','User_id').values('id','planMonetization_id','plan_id_id','proposer_id_id','proposer_id_id__first_name','proposalstate').filter(proposer_id_id = user)
            proArr = collections.defaultdict(list)
            for dt in prodata:
                proObj = dict(dt)
                proArr[proObj['planMonetization_id']].append(proObj)

            return JsonResponse({"success":True,"directSelling":directsellArr,"coBranding":cobranddataArr,"whiteBranding":whitebranddataArr,"proposedData":proArr})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg":str(e)})
@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getcoachlicenseplans(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    req = "GET"
    url = "partner/getcoachlicenseplans/"
    try:
        #print(user)
        if username != None:
            directselldata = PlanMonetization.objects.select_related('Plan__id','User__id').values('id','plan_id_id','plan_id_id__planName','plan_id_id__price','license_id','royalty','template','templateContent','coach_id_id','coach_id_id__first_name','coach_id_id__last_name','coach_id_id__username','coach_id_id__email','plan_id_id__planDescription').filter(license_id = 1,coach_id_id =user,plan_id_id__planStatus=1)
            directsellArr =[]
            for dt in directselldata:
                planObj = dict(dt)

                secret_code_plain = planObj ['plan_id_id__planName'] + '#' + str(planObj ['plan_id_id'])
                secret_code_encode = base64.b64encode(secret_code_plain.encode('ascii'))
                encodedVal = str(secret_code_encode).split("'")
                planObj['encodedurl'] = encodedVal[1]

                directsellArr.append(planObj)

            cobranddata = PlanMonetization.objects.select_related('Plan__id','User__id').values('id','plan_id_id','plan_id_id__planName','plan_id_id__price','license_id','royalty','template','templateContent','coach_id_id__first_name','coach_id_id','coach_id_id__last_name','coach_id_id__username','coach_id_id__email','plan_id_id__planDescription').filter(license_id = 2,coach_id_id =user,plan_id_id__planStatus=1)
            cobranddataArr =[]
            for dt in cobranddata:
                planObj = dict(dt)

                secret_code_plain = planObj ['plan_id_id__planName'] + '#' + str(planObj ['plan_id_id'])
                secret_code_encode = base64.b64encode(secret_code_plain.encode('ascii'))
                encodedVal = str(secret_code_encode).split("'")
                planObj['encodedurl'] = encodedVal[1]

                cobranddataArr.append(planObj)

            whitebranddata = PlanMonetization.objects.select_related('Plan__id','User__id').values('id','plan_id_id','plan_id_id__planName','plan_id_id__price','license_id','royalty','template','templateContent','coach_id_id__first_name','coach_id_id','coach_id_id__last_name','coach_id_id__username','coach_id_id__email','plan_id_id__planDescription').filter(license_id = 3,coach_id_id =user,plan_id_id__planStatus=1)
            whitebranddataArr =[]
            for dt in whitebranddata:
                planObj = dict(dt)

                secret_code_plain = planObj ['plan_id_id__planName'] + '#' + str(planObj ['plan_id_id'])
                secret_code_encode = base64.b64encode(secret_code_plain.encode('ascii'))
                encodedVal = str(secret_code_encode).split("'")
                planObj['encodedurl'] = encodedVal[1]

                whitebranddataArr.append(planObj)

            prodata = AgentPlanMonetization.objects.select_related('PlanMonetization__id','User_id','Plan__id').values('id','planMonetization_id','plan_id_id','proposer_id_id','proposer_id_id__first_name','proposal','counterProposal','proposerstate','coachstate','proposalstate','plan_id_id__price')
            proArr = collections.defaultdict(list)
            for dt in prodata:
                proObj = dict(dt)
                proArr[proObj['planMonetization_id']].append(proObj)

            pprodata = AgentPlanMonetization.objects.select_related('PlanMonetization__id', 'Plan__id','User__id').values('id', 'planMonetization_id','plan_id_id', 'plan_id_id__planName','plan_id_id__planDescription','plan_id_id__price','proposer_id_id','proposer_id_id__first_name','proposal', 'counterProposal','proposerstate','coachstate','proposalstate','planMonetization_id__planType','planMonetization_id__license_id','planMonetization_id__royalty','planMonetization_id__template','planMonetization_id__templateContent','planMonetization_id__coach_id_id','planMonetization_id__coach_id_id__first_name').filter(planMonetization_id__license_id__in=[2,3], proposer_id_id=user)
            pproArr = []
            for dt in pprodata:
                pppObj = dict(dt)
                pproArr.append(pppObj)
            return JsonResponse({"success":True,"directSelling":directsellArr,"coBranding":cobranddataArr,"whiteBranding":whitebranddataArr,"proposalinfo":proArr,"yourproposedplans":pproArr})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getusersocialinfo(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user=username['id']
    userdata = json.loads(request.body.decode('utf-8'))
    req=userdata
    url="partner/getusersocialinfo"
    try:
        if username != None:
            print(userdata)
            if 'userid' in userdata and userdata['userid']!='':
                prosocialinf = SocialProfile.objects.values('id','user_id','socailName','socialUrl').filter(user_id = userdata['userid'])
                socialArr =[]
                for sdt in prosocialinf:
                    socailObj = dict(sdt)
                    socialArr.append(socailObj)
                return JsonResponse({"success":True,"socialinfo":socialArr})
            else:
                return JsonResponse({"success":False,"message":"problem with fetching data"})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getPartnerProposedPlans(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    req = "GET"
    url = "partner/getpartnerproposedplans/"
    try:
        print(user,'=========')
        if username != None:
            pppdata = AgentPlanMonetization.objects.select_related('PlanMonetization__id','Plan__id','User__id').values('id','planMonetization_id','plan_id_id','plan_id_id__planName','plan_id_id__planDescription','plan_id_id__price','proposer_id_id','proposer_id_id__first_name','proposal','counterProposal','proposerstate','coachstate','proposalstate','planMonetization_id__planType','planMonetization_id__license_id','planMonetization_id__royalty','planMonetization_id__template','planMonetization_id__templateContent','planMonetization_id__coach_id_id','planMonetization_id__coach_id_id__first_name').filter(planMonetization_id__license_id = 2,proposer_id_id = user)
            pppArr = []
            for dt in pppdata:
                pppObj = dict(dt)
                if pppObj['proposalstate'] == 1 and pppObj['coachstate'] ==1:
                    planDetails = Plan.objects.filter(createdBy_id = pppObj['proposer_id_id'],originalPlanId_id =  pppObj['plan_id_id']).values()
                    if planDetails.exists():
                        for plan in planDetails:
                            planObj = dict(plan)

                            secret_code_plain = planObj ['planName'] + '#' + str(planObj ['id'])
                            secret_code_encode = base64.b64encode(secret_code_plain.encode('ascii'))
                            encodedVal = str(secret_code_encode).split("'")
                            pppObj['encodedurl'] = encodedVal[1]

                            if planObj['planStatus'] == 1:
                                pppObj['progress'] = "Plan Published"
                            else:
                                pppObj['progress'] = "Plan in Drafts"
                    else:
                        pppObj['progress'] = "Deal Closed"
                else:
                    pppObj['progress'] = "Plan Under Negotiation"
                pppArr.append(pppObj)

            wldata = AgentPlanMonetization.objects.select_related('PlanMonetization__id','Plan__id','User__id').values('id','planMonetization_id','plan_id_id','plan_id_id__planName','plan_id_id__planDescription','plan_id_id__price','proposer_id_id','proposer_id_id__first_name','proposal','counterProposal','proposerstate','coachstate','proposalstate','planMonetization_id__planType','planMonetization_id__license_id','planMonetization_id__royalty','planMonetization_id__template','planMonetization_id__templateContent','planMonetization_id__coach_id_id','planMonetization_id__coach_id_id__first_name').filter(planMonetization_id__license_id = 3,proposer_id_id = user)
            wlArr = []
            for dt in wldata:
                wlObj = dict(dt)
                if wlObj['proposalstate'] == 1 and wlObj['coachstate'] == 1:
                    planDetails = Plan.objects.filter(createdBy_id=wlObj['proposer_id_id'],originalPlanId_id=wlObj['plan_id_id']).values()
                    if planDetails.exists():
                        for plan in planDetails:
                            planObj = dict(plan)

                            secret_code_plain = planObj ['planName'] + '#' + str(planObj ['id'])
                            secret_code_encode = base64.b64encode(secret_code_plain.encode('ascii'))
                            encodedVal = str(secret_code_encode).split("'")
                            planObj['encodedurl'] = encodedVal[1]

                            if planObj['planStatus'] == 1:
                                wlObj['progress'] = "Plan Published"
                            else:
                                wlObj['progress'] = "Drafted Plan"
                    else:
                        wlObj['progress'] = "Deal Closed"
                else:
                    wlObj['progress'] = "Negotiation In Progress "
                wlArr.append(wlObj)

            return JsonResponse({"cobrand":pppArr,"whitelab":wlArr})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def checkingusersocialprofile(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    socialinfo = json.loads(request.body.decode('utf-8'))
    req=socialinfo
    url="partner/checkingusersocialprofile"
    try:
        if username != None:
            verifysocial = SocialProfile.objects.values('id','socailName','socialUrl').filter(user_id = socialinfo['loginuserid'])
            for dt in verifysocial:
                type = dt['socailName']
                url = dt['socialUrl']
                if type !='' and url !='':
                    return JsonResponse({"success":True,"status":"complte","message": "your profile is complete"})
            else:
                return JsonResponse({"success":False,"status":"incomplte","message": "your social profile is incomplete "})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg":str(e)})


@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def createuserproposals(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    loginusername = username['first_name']
    proposalinfo = json.loads(request.body.decode('utf-8'))
    print(proposalinfo)
    req = proposalinfo
    url = "partner/createuserproposals/"
    try:
        if username != None:
            proposaldata = AgentPlanMonetization.objects.create(
                planMonetization_id = proposalinfo['pdata']['id'],
                plan_id_id = proposalinfo['pdata']['plan_id_id'],
                proposer_id_id = user,
                proposal = proposalinfo['pdata']['royalty'],
                counterProposal = proposalinfo['pinfo']['myproposal'],
            )
            proposaldata.save()
            agentPlan_id = proposaldata.id
            agentdata = AgentPlanProposals.objects.create(
                agentplan_id = agentPlan_id,
                #message = proposalinfo['pinfo']['message'],
                message = "Counter Offer" + ' '+ proposalinfo['pinfo']['myproposal'],
                user_id = user,
                receiver_id = proposalinfo['pdata']['coach_id_id'],
            )
            agentdata.save()
            proposeType = AgentPlanMonetization.objects.select_related('PlanMonetization').filter(id=proposaldata.id).values('planMonetization__license_id')
            for val in proposeType:
                value = dict(val)
            licenseType = value['planMonetization__license_id']
            if licenseType =="3":
                lismsg = "would like to resell the plan under their own branding (white-label)"
            else:
                lismsg = "would like to Co-brand with you."
            subject = "Plan Proposal"
            to_email = proposalinfo['pdata']['coach_id_id__email']
            #to_email = 'nnarendra57@gmail.com'
            ctx = {
                'coachName':  proposalinfo['pdata']['coach_id_id__first_name'],
                'planName': proposalinfo['pdata']['plan_id_id__planName'],
                'proposedUserName': loginusername,
                'initialroyalty': proposalinfo['pdata']['royalty'],
                'offeringroyalty': proposalinfo['pinfo']['myproposal'],
                'lismsg':lismsg
            }
            message = render_to_string('planproposal.html', ctx)
            officeMail(subject, message, to_email)
            return JsonResponse({"success":True,"message": "your proposal sent successfully"})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def acceptUserProposal(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    acceptdata = json.loads(request.body.decode('utf-8'))
    req = acceptdata
    url = "partner/acceptuserproposal/"
    try:
        if username != None:
            acceptdata = json.loads(request.body.decode('utf-8'))
            print(acceptdata)
            checkingpartner = False
            checkingcoachproposal = False
            if 'acptdata' in acceptdata and acceptdata['status'] == True and acceptdata['cpstatus'] ==True:
                #print('+++++++++varma+++++')
                apm_id = acceptdata['acptdata']['agentplan_id']
                partner_id = acceptdata['receiver_id']
                agentpm = AgentPlanMonetization.objects.get(pk = apm_id)
                agentpm.proposerstate = 1
                agentpm.counterProposal = acceptdata['acptdata']['agentplan_id__counterProposal']
                agentpm.save()
                apmonte_id = agentpm.id

                cacptdata = AgentPlanProposals.objects.create(
                    agentplan_id = acceptdata['acptdata']['agentplan_id'],
                    message = "accepted your proposal",
                    #message = acceptdata['received_user'] +' '+"accepted your proposal",
                    user_id = user,
                    receiver_id = acceptdata['receiver_id']
                )
                cacptdata.save()
                cstate1 = AgentPlanMonetization.objects.get(pk = apmonte_id)
                if cstate1.coachstate == 1 and cstate1.proposerstate == 1:
                    cstate1.proposalstate =1
                    cstate1.save()
                    planid = cstate1.plan_id_id
                    plandata1 = Plan.objects.get(id = planid)
                    plandata1.royalty = acceptdata['acptdata']['agentplan_id__counterProposal']
                    plandata1.licencePolicy = acceptdata['acptdata']['agentplan_id__planMonetization_id__planType']
                    plandata1.proposedState = 1
                    plandata1.save()
                    #print('----royalty saved into plan table 000----')
                    checkingpartner = True
                    if checkingpartner == True:
                        user = partner_id
                        uid = acceptdata['acptdata']['user_id']
                        #print(uid,'====uid')
                        rid = acceptdata['acptdata']['receiver_id']
                        planName = acceptdata['acptdata']['agentplan_id__plan_id_id__planName']
                        createduplicateinf(planid, user,uid,plandata1.licencePolicy)
                        dealclosedconfirmation(uid, rid, planName,plandata1.royalty,plandata1.licencePolicy)
            ## coach accepted partner proposal
            if 'acptdata' in acceptdata and acceptdata['status'] == True and acceptdata['cpstatus'] ==False:
                #print('------here 11')
                apm_id = acceptdata['acptdata']['agentplan_id']
                partner_id = acceptdata['receiver_id']
                agentpm = AgentPlanMonetization.objects.get(pk = apm_id)
                agentpm.coachstate = 1 #coach accept
                agentpm.counterProposal = acceptdata['acptdata']['agentplan_id__counterProposal']
                agentpm.save()
                apmonte_id = agentpm.id

                cacptdata = AgentPlanProposals.objects.create(
                    agentplan_id = acceptdata['acptdata']['agentplan_id'],
                    message = "accepted your proposal",
                    #message = acceptdata['received_user'] +' '+"accepted your proposal",
                    user_id = user,
                    receiver_id = acceptdata['receiver_id']
                )
                cacptdata.save()
                cstate1 = AgentPlanMonetization.objects.get(pk = apmonte_id)
                if cstate1.coachstate == 1 and cstate1.proposerstate == 1:
                    cstate1.proposalstate =1
                    cstate1.save()
                    planid = cstate1.plan_id_id
                    plandata2 = Plan.objects.get(id = planid)
                    plandata2.royalty = acceptdata['acptdata']['agentplan_id__counterProposal']
                    plandata2.licencePolicy = acceptdata['acptdata']['agentplan_id__planMonetization_id__planType']
                    plandata2.proposedState = 1
                    plandata2.save()
                    #print('----royalty saved into plan table 001----')
                    checkingpartner = True
                    if checkingpartner == True:
                        user = partner_id
                        uid = acceptdata['acptdata']['user_id']
                        #print(uid,'====uid')
                        rid = acceptdata['acptdata']['receiver_id']
                        planName = acceptdata['acptdata']['agentplan_id__plan_id_id__planName']
                        createduplicateinf(planid, user,uid,plandata2.licencePolicy)
                        dealclosedconfirmation(uid, rid, planName,plandata2.royalty,plandata2.licencePolicy)

            ## coach rejected partner proposal
            elif 'acptdata' in acceptdata and acceptdata['status'] == False:
                #print('---coach rejected partner proposal---')
                apmid2 = acceptdata['acptdata']['agentplan_id']
                agentpm2 = AgentPlanMonetization.objects.get(pk = apmid2)
                agentpm2.coachstate = 0 #coach reject
                agentpm2.counterProposal = acceptdata['acptdata']['agentplan_id__counterProposal']
                agentpm2.save()

                cdata2 = AgentPlanProposals.objects.create(
                    agentplan_id = acceptdata['acptdata']['agentplan_id'],
                    message = "rejected your proposal",
                    #message = acceptdata['received_user'] +' '+"rejected your proposal",
                    user_id = user,
                    receiver_id = acceptdata['receiver_id']
                )
                cdata2.save()
            ### partner accepted coach proposal
            elif 'partnerAcptData' in acceptdata and acceptdata['acceptstatus'] == True:
                agentpm_id = acceptdata['partnerAcptData']['agentplan_id']
                apm = AgentPlanMonetization.objects.get(pk = agentpm_id)
                apm.proposerstate = 1 #partner accept
                apm.counterProposal = acceptdata['partnerAcptData']['agentplan_id__counterProposal']
                apm.save()
                agentplanmonetization_id = apm.id

                pacptdata2 = AgentPlanProposals.objects.create(
                    agentplan_id = acceptdata['partnerAcptData']['agentplan_id'],
                    message = "accepted your proposal",
                    #message = acceptdata['partnername']+' '+"accepted your proposal",
                    user_id = user,
                    receiver_id = acceptdata['receiver_id']
                )
                pacptdata2.save()

                pstate = AgentPlanMonetization.objects.get(pk = agentplanmonetization_id)
                if pstate.coachstate == 1 and pstate.proposerstate == 1:
                    pstate.proposalstate =1
                    pstate.save()
                    planid = pstate.plan_id_id
                    plandata = Plan.objects.get(id = planid)
                    plandata.royalty = acceptdata['partnerAcptData']['agentplan_id__counterProposal']
                    plandata.licencePolicy = acceptdata['partnerAcptData']['agentplan_id__planMonetization_id__planType']
                    plandata.proposedState = 1
                    plandata.save()
                    #print('----royalty saved into plan table 002----')
                    uid = acceptdata['partnerAcptData']['user_id']
                    rid = acceptdata['partnerAcptData']['receiver_id']
                    planName = acceptdata['partnerAcptData']['agentplan_id__plan_id_id__planName']
                    createduplicateinf(planid,user,uid,plandata.licencePolicy)
                    dealclosedconfirmation(uid, rid, planName,plandata.royalty,plandata.licencePolicy)
            ### partner rejected coach proposal
            elif 'acceptstatus' in acceptdata and acceptdata['acceptstatus'] == False:
                #print('---partner rejected coach proposal---')
                apid = acceptdata['partnerAcptData']['agentplan_id']
                apmdata = AgentPlanMonetization.objects.get(pk = apid)
                apmdata.proposerstate =0 #partner reject
                apmdata.save()

                rdata2 = AgentPlanProposals.objects.create(
                    agentplan_id = acceptdata['partnerAcptData']['agentplan_id'],
                    message = "rejected your proposal",
                    #message = acceptdata['partnername']+' '+"rejected your proposal",
                    user_id = user,
                    receiver_id = acceptdata['receiver_id']
                )
                rdata2.save()

            return JsonResponse({"success":True,"message": "status changed"})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg":str(e)})

def createduplicateinf(planid,user,uid,licencePolicy):
    #print(planid,'planid')
    #print(user,'user')
    whitelabel = False
    if licencePolicy =="3" or licencePolicy =="White-Label":
        whitelabel = True
        print("HERE IN TESTING")
    userVal = User.objects.get(id=uid)
    userType = userVal.userType
    if userType == 6:
        orgName = Organization.objects.get(id = userVal.organization_id)
        username = orgName.gymName
    else:
        username = userVal.first_name
    plandata = Plan.objects.get(id = planid)
    dupplan = Plan.objects.create(
        programType = plandata.programType,
        planName = username+" - "+plandata.planName,
        planDescription = plandata.planDescription,
        planStatus = 0,
        planGoal_id = plandata.planGoal_id,
        price = plandata.price,
        ability = plandata.ability,
        num_of_periods = plandata.num_of_periods,
        num_of_sessions = plandata.num_of_sessions,
        goals = plandata.goals,
        licencePolicy = plandata.licencePolicy ,
        duration_weeks = plandata.duration_weeks,
        originalPlanId_id = plandata.originalPlanId_id,
        originalPlanner_id = plandata.originalPlanner_id,
        royalty = plandata.royalty,
        proposedState =1,
        createdBy_id = user,
        modifiedBy_id = user,
    )
    dupplan.save()
    if whitelabel == True or dupplan.licencePolicy == "White-Label":
        updatePlan = Plan.objects.get(id=dupplan.id)
        updatePlan.planDescription = ""
        updatePlan.price = 0
        updatePlan.save()
    lastid = dupplan.id
    originalPlanID = dupplan.originalPlanId_id
    getPlanAbilities = SelectedAbilities.objects.filter(plan_id = originalPlanID).values()
    for ab in getPlanAbilities:
        abObj = dict(ab)
        createabilitites = SelectedAbilities.objects.create(
            ability_id=abObj['ability_id'],
            plan_id=lastid,
            createdBy_id=user,
            modifiedBy_id=user
        )
        createabilitites.save()
    getPurposes = PlanGoals.objects.filter(plan_id = originalPlanID).values()
    for go in getPurposes:
        goalObj = dict(go)
        saveGoals = PlanGoals.objects.create(
            planGoal_id=goalObj['planGoal_id'],
            plan_id=lastid,
            createdBy_id=user,
            modifiedBy_id=user
        )
        saveGoals.save()
    draftedplan = DraftedPlan.objects.get(planId_id = planid)
    planinfo = draftedplan.planJson
    #print(planinfo,"ISSUE in planJSON ")
    #planjson = planinfo.replace("'", '"')
    publishplanjson = json.loads(planinfo)
    publishplanjson['PlanInfo']['id']=lastid
    periodInfo = publishplanjson['PeriodDetails']
    for dt in periodInfo:
        dt['PeriodInfo']['plan_id'] = lastid

    projsoninfo = draftedplan.protocolJson
    protocolsinf = projsoninfo.replace("'", '"')
    protocolInfo = json.loads(protocolsinf)
    skipjson = protocolInfo['skip']
    regjson = protocolInfo['regression']
    projson = protocolInfo['progression']
    for data1 in skipjson:
        data1['plan_id'] = lastid
    for data2 in regjson:
        data2['plan_id'] = lastid
    for data3 in projson:
        data3['plan_id'] = lastid

    dupdraftedplan = DraftedPlan.objects.create(
        planId_id = lastid,
        planJson = json.dumps(publishplanjson),
        protocolJson = json.dumps(protocolInfo),
        status = 0,
        createdBy_id = user,
        modifiedBy_id = user,
    )
    dupdraftedplan.save()

def dealclosedconfirmation(uid, rid, planName,royalty,licencePolicy):
    pname = planName
    if royalty.isdigit():
        rolayltyPercent = royalty
    else:
        rolayltyPercent = int(re.search(r'\d+',royalty).group())
    royaltyPrice = 100 - int(rolayltyPercent)
    royalty1 = str(royaltyPrice)+" %"
    print(planName,"1234567")
    if licencePolicy == "2":
        licencePolicy = "Co-Brand"
    else:
        licencePolicy = "White Label"
    userData = User.objects.get(id = uid)
    if userData.userType ==3:
        coachName = userData.first_name
        partner = User.objects.get(id = rid)
        partnerName = partner.first_name
        subject = "Deal Status"
        to_email = userData.email
        ctx = {
            'planName': pname,
            'sender': coachName,
            'partner': partnerName,
            'royalty': royaltyPrice,
            'liscencePolicy': licencePolicy
        }
        message = render_to_string('dealclosedconfirmation.html', ctx)
        officeMail(subject, message, to_email)
    else:
        partnerName = userData.first_name
        partner = User.objects.get(id=rid)
        coachName = partner.first_name
        subject = "Deal Status"
        to_email = userData.email
        ctx = {
            'planName': pname,
            'sender': partnerName,
            'partner': coachName,
            'royalty': royaltyPrice,
            'liscencePolicy': licencePolicy
        }
        message = render_to_string('dealclosedconfirmation.html', ctx)
        officeMail(subject, message, to_email)
    userData1 = User.objects.get(id=rid)
    if userData1.userType == 3:
        coachName = userData1.first_name
        partner = User.objects.get(id=rid)
        partnerName = partner.first_name
        subject = "Deal Status"
        to_email = userData1.email
        ctx = {
            'planName': pname,
            'sender': coachName,
            'partner': partnerName,
            'royalty': royaltyPrice,
            'liscencePolicy': licencePolicy
        }
        message = render_to_string('dealclosedconfirmation.html', ctx)
        officeMail(subject, message, to_email)
    else:
        partnerName = userData1.first_name
        partner = User.objects.get(id=rid)
        coachName = partner.first_name
        subject = "Deal Status"
        to_email = userData1.email
        ctx = {
            'planName': pname,
            'sender': partnerName,
            'partner': coachName,
            'royalty': royaltyPrice,
            'liscencePolicy': licencePolicy
        }
        message = render_to_string('dealclosedconfirmation.html', ctx)
        officeMail(subject, message, to_email)
    '''parnerId = User.objects.get(id = pid)
    partnerName = parnerId.first_name
    liscencePolicy = licencePolicy
    royaltyPrice = royalty
    #print(ids,'+++ids')
    for dt in ids:
        uobj = User.objects.get(id = dt)
        subject = "Deal Status"
        to_email = uobj.email
        ctx = {
            'planName': pname,
            'sender' : sentusername,
            'partner' : partnerName,
            'royalty' : royaltyPrice,
            'liscencePolicy':liscencePolicy
        }
        message = render_to_string('dealclosedconfirmation.html', ctx)
        officeMail(subject, message, to_email)'''

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def replyuserproposals(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    rplyinfo = json.loads(request.body.decode('utf-8'))
    req = rplyinfo
    url = "partner/replyuserproposals/"
    try:
        #print(rplyinfo)
        if username != None:
            #updating counter proposal info
            if 'pdata' in rplyinfo:
                agentplandata = AgentPlanMonetization.objects.get(pk = rplyinfo['pdata']['agentplan_id'])
                agentplandata.counterProposal = rplyinfo['pdata']['rplymessage']
                agentplandata.save()

            if 'partnername' in rplyinfo and rplyinfo['partnername'] !='':
                print('=========partnername')
                pdata = AgentPlanProposals.objects.create(
                    agentplan_id = rplyinfo['pdata']['agentplan_id'],
                    message = "Counter Offer "+' '+ rplyinfo['pdata']['rplymessage'],
                    #message = rplyinfo['partnername'] +' ' +"offering"+' '+ rplyinfo['pdata']['rplymessage'],
                    user_id = user,
                    receiver_id = rplyinfo['receiver_id']
                )
                pdata.save()
            elif 'received_user' in rplyinfo and rplyinfo['received_user'] !='' and 'cpstate' in rplyinfo and rplyinfo['cpstate'] ==True:
                print('------------------------narendra')
                cpdata = AgentPlanProposals.objects.create(
                    agentplan_id = rplyinfo['pdata']['agentplan_id'],
                    message = "Counter Offer" + ' ' + rplyinfo['pdata']['rplymessage'],
                    user_id = user,
                    receiver_id = rplyinfo['receiver_id']
                )
                cpdata.save()

            elif 'received_user' in rplyinfo and rplyinfo['received_user'] != '' and 'cpstate' in rplyinfo and rplyinfo['cpstate'] ==False:
                print('=========received_user')
                rdata = AgentPlanProposals.objects.create(
                    agentplan_id = rplyinfo['pdata']['agentplan_id'],
                    message = "Offer Price"+' '+ rplyinfo['pdata']['rplymessage'],
                    #message = rplyinfo['received_user'] +' ' +"asking"+' '+ rplyinfo['pdata']['rplymessage'],
                    user_id = user,
                    receiver_id = rplyinfo['receiver_id']
                )
                rdata.save()
            return JsonResponse({"success":True,"message": "message sent successfully"})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getCoachReplyData(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    coachdata = json.loads(request.body.decode('utf-8'))
    req = coachdata
    url = "partner/getcoachreplydata/"
    try:
        #print(coachdata['msgdata']['id'])
        if username != None:
            loggedInUser_id = username['id']
            allMessages = AgentPlanProposals.objects.select_related('AgentPlanMonetization__id','User__id','Plan__id').values('id','agentplan_id','message','user_id','user_id__first_name','user_id__avatar','receiver_id','receiver_id__first_name','receiver_id__avatar','agentplan_id__plan_id_id','agentplan_id__plan_id_id__planName','agentplan_id__proposer_id','agentplan_id__proposal','agentplan_id__counterProposal','agentplan_id__proposerstate','agentplan_id__coachstate','agentplan_id__proposalstate','agentplan_id__planMonetization_id__planType','createdDate','agentplan_id__plan_id__price').filter(agentplan_id=coachdata['msgdata']['id']).order_by('createdDate')
            allMsgArr =[]
            for dt in allMessages:
                msgObj = dict(dt)
                if msgObj['message'] == "Accepted Coach proposal":
                    msgObj['message1'] = "Deal Closed"
                    msgObj['agentplan_id__proposal1'] = 100 - int(re.search(r'\d+', msgObj['agentplan_id__proposal']).group())
                    msgObj['agentplan_id__counterProposal1'] = 100-int(re.search(r'\d+', str(msgObj['agentplan_id__counterProposal'])).group())
                    allMsgArr.append(msgObj)
                else:
                    msgObj['agentplan_id__proposal1'] = 100-int(re.search(r'\d+', msgObj['agentplan_id__proposal']).group())
                    if msgObj['user_id'] == loggedInUser_id:
                        if msgObj['message'] == "rejected your proposal":
                            msgObj['message1'] = "Declined"
                            msgObj['agentplan_id__counterProposal1'] = int(re.search(r'\d+', str(msgObj['agentplan_id__counterProposal'])).group())
                        elif msgObj['message'] == "accepted your proposal":
                            msgObj['message1'] = "Accepted"
                            msgObj['agentplan_id__counterProposal1'] = int(re.search(r'\d+', str(msgObj['agentplan_id__counterProposal'])).group())
                        else:
                            msgObj['agentplan_id__counterProposal2'] = 100 - int(re.search(r'\d+', msgObj['agentplan_id__counterProposal']).group())
                            msgObj['agentplan_id__counterProposal1'] = int(re.search(r'\d+', str(msgObj['agentplan_id__counterProposal2'])).group())
                            msgObj['message1'] = "Coach says: "+"My offer on base price " + ' ' + str(int(re.search(r'\d+', msgObj['message']).group())) +"%"+" : "+str(100-int(re.search(r'\d+', msgObj['message']).group()))+"%"+" for Coach and Partner respectively"
                            #msgObj['message'] = "My" + ' ' + msgObj['message']
                    else:
                        if msgObj['message'] == "rejected your proposal":
                            msgObj['message1'] = msgObj['user_id__first_name'] + " Declined your proposal"
                        elif msgObj['message'] == "accepted your proposal":
                            msgObj['message1'] = msgObj['user_id__first_name'] + " Accepted your proposal"
                        else:
                            msgObj['agentplan_id__counterProposal2'] = 100 - int(re.search(r'\d+', msgObj['agentplan_id__counterProposal']).group())
                            msgObj['agentplan_id__counterProposal1'] = int(re.search(r'\d+', str(msgObj['agentplan_id__counterProposal2'])).group())
                            msgObj['message1'] = "Partner says: "+msgObj['user_id__first_name'] + ' ' + "Counter offer on base price "+ str(int(re.search(r'\d+', msgObj['message']).group()))+"%"+" : "+str(100-int(re.search(r'\d+', msgObj['message']).group()))+"%"+" for Coach and Partner respectively"
                            #msgObj['message'] = msgObj['user_id__first_name'] + ' ' + msgObj['message']
                    #msgObj['message'] = msgObj['user_id__first_name'] + ' ' + msgObj['message']
                    msgObj['createdDate'] = msgObj['createdDate']. strftime("%Y-%m-%d %H:%M:%S")
                    allMsgArr.append(msgObj)
            return JsonResponse({"messages":allMsgArr})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getPartnerReplyData(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    partnerdata = json.loads(request.body.decode('utf-8'))
    req = partnerdata
    url = "partner/getpartnerreplydata/"
    try:
        #print(partnerdata,'============')
        if username != None:
            loggedInUser_id = username['id']
            allMessages = AgentPlanProposals.objects.select_related('AgentPlanMonetization__id','User__id','Plan__id').values('id','agentplan_id','message','user_id','user_id__first_name','user_id__avatar','receiver_id','receiver_id__first_name','receiver_id__avatar','agentplan_id__plan_id_id','agentplan_id__plan_id_id__planName','agentplan_id__proposer_id','agentplan_id__proposal','agentplan_id__counterProposal','agentplan_id__proposerstate','agentplan_id__coachstate','agentplan_id__proposalstate','agentplan_id__planMonetization_id__planType','createdDate','agentplan_id__plan_id__price').filter(agentplan_id=partnerdata['pinfo_id']['id']).order_by('createdDate')
            allMsgArr =[]
            for dt in allMessages:
                msgObj = dict(dt)
                if msgObj['message'] == "Accepted Coach proposal":
                    msgObj['message1'] = "Deal Closed"
                    msgObj['agentplan_id__proposal1'] = 100 - int(re.search(r'\d+', msgObj['agentplan_id__proposal']).group())
                    msgObj['agentplan_id__counterProposal1'] = int(re.search(r'\d+', str(msgObj['agentplan_id__counterProposal'])).group())
                    allMsgArr.append(msgObj)
                else:
                    msgObj['agentplan_id__proposal1'] = 100-int(re.search(r'\d+', msgObj['agentplan_id__proposal']).group())
                    if msgObj['user_id'] == loggedInUser_id:
                        if msgObj['message'] == "rejected your proposal":
                            msgObj['message1'] = "Declined"
                            msgObj['agentplan_id__counterProposal1'] = int(re.search(r'\d+', str(msgObj['agentplan_id__counterProposal'])).group())
                        elif msgObj['message'] == "accepted your proposal":
                            msgObj['message1'] = "Accepted"
                            msgObj['agentplan_id__counterProposal1'] = int(re.search(r'\d+', str(msgObj['agentplan_id__counterProposal'])).group())
                        else:
                            msgObj['agentplan_id__counterProposal2'] = 100-int(re.search(r'\d+', msgObj['agentplan_id__counterProposal']).group())
                            msgObj['agentplan_id__counterProposal1'] = int(re.search(r'\d+', str(msgObj['agentplan_id__counterProposal2'])).group())
                            msgObj['message1'] ="Partner says: "+ "My Counter offer on base price" + ' ' +str(int(re.search(r'\d+', msgObj['message']).group()))+"%"+" : "+str(100-int(re.search(r'\d+', msgObj['message']).group()))+"%"+' '+"for Coach and Partner respectively"
                    else:
                        if msgObj['message'] == "rejected your proposal":
                            msgObj['message1'] = msgObj['user_id__first_name']+" Declined your proposal"
                        elif msgObj['message'] == "accepted your proposal":
                            msgObj['message1'] = msgObj['user_id__first_name']+" Accepted your proposal"
                        else:
                            msgObj['agentplan_id__counterProposal2'] = 100-int(re.search(r'\d+', msgObj['agentplan_id__counterProposal']).group())
                            msgObj['agentplan_id__counterProposal1'] = int(re.search(r'\d+', str(msgObj['agentplan_id__counterProposal2'])).group())
                            msgObj['message1'] = "Coach says: "+msgObj['user_id__first_name'] +" offer on base price "+' ' + str(int(re.search(r'\d+', msgObj['message']).group()))+"%"+" : "+str(100-int(re.search(r'\d+', msgObj['message']).group()))+"%"+' '+"for Coach and Partner respectively"
                            #msgObj['message'] = msgObj['user_id__first_name'] + ' ' + msgObj['message']
                    msgObj['createdDate'] = msgObj['createdDate']. strftime("%Y-%m-%d %H:%M:%S")
                    allMsgArr.append(msgObj)
            return JsonResponse({"totalmsgs":allMsgArr})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg":str(e)})

