from django.db import models

# Create your models here.
from Plan.models import Plan
from Subscriber.models import User


class PlanMonetization(models.Model):
    plan_id = models.ForeignKey(Plan, related_name='plan_id', on_delete=models.CASCADE)
    planType = models.CharField(max_length=150 , blank=True, null=True)
    license_id = models.CharField(max_length=150, blank=True, null=True)
    royalty = models.CharField(max_length=150, blank=True, null=True)
    template = models.CharField(max_length=150, blank=True, null=True)
    templateContent = models.CharField(max_length=150, blank=True, null=True)
    coach_id = models.ForeignKey(User, related_name='user_id', on_delete=models.CASCADE)
    coupon = models.CharField(max_length=250, blank=True, null=True)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class AgentPlanMonetization(models.Model):
    planMonetization = models.ForeignKey(PlanMonetization, related_name='PlanMonetization_id', on_delete=models.CASCADE)
    plan_id = models.ForeignKey(Plan, related_name='plan', on_delete=models.CASCADE)
    proposer_id = models.ForeignKey(User, related_name='proposer_id', on_delete=models.CASCADE)
    proposal = models.CharField(max_length=150, blank=True,  null=True)
    counterProposal = models.CharField(max_length=150, blank=True,  null=True)
    proposerstate = models.IntegerField(default=0)
    coachstate = models.IntegerField(default=0)
    proposalstate = models.IntegerField(default=0)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class AgentPlanProposals(models.Model):
    agentplan = models.ForeignKey(AgentPlanMonetization, related_name='AgentPlanMonetization', on_delete=models.CASCADE)
    message = models.TextField()
    user = models.ForeignKey(User, related_name='creator_id', on_delete=models.CASCADE)
    receiver = models.ForeignKey(User, related_name='receiver_id', on_delete=models.CASCADE)
    messageState = models.IntegerField(default=0)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)
