from datetime import datetime, timedelta, time
import json
import base64
import collections
from random import choice

from dateutil.relativedelta import relativedelta
from django.core.mail import EmailMultiAlternatives
from django.db.models import Count, Sum
from django.forms import model_to_dict
from django.shortcuts import render
import concurrent.futures
import threading
# Create your views here.
from django.template.loader import render_to_string
from django.views.decorators.cache import never_cache
from django.http import JsonResponse, HttpResponse
try: # for pip >= 10
    from pip._internal.req.req_install import logger
except ImportError: # for pip <= 9.0.3
    from pip.req.req_install import logger
from rest_framework.decorators import api_view, authentication_classes

from StratFit import settings
from Subscriber.Authentication import SessionAuthentication, IsAuthenticated, StartFitSessionUtil
from Subscriber.models import UserReferral, User
from campaign.models import CampaignFeed, CampaignLikes, CampaignComments, CampaignAdvertisements, BaahubaliHistory, \
    BaahubaliPromoVideos,Feedback
from django.core.cache import caches, cache

from utility.views import officeMail


def gettagname(request):
    tagdata = CampaignFeed.objects.values('tagName').filter(status=1).annotate(dcount = Count('tagName'))
    tagArr = []
    for dt in tagdata:
        tagObj = dict(dt)
        if tagObj['tagName'] !='' and tagObj['tagName'] != None:
            tagObj['unique']=tagObj['tagName'].replace(" ", "_")
        tagArr.append(tagObj)
    return JsonResponse({"success":True,"tagNames":tagArr})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getuserpostdata(request):
    stratsessionutil = StartFitSessionUtil()
    data = json.loads(request.body.decode('utf-8'))
    shareArr =[]
    shareinfo = CampaignFeed.objects.select_related('User__id', 'Plan__id', 'UserPlan__id', 'Exercise__id').values('id','user_id','user_id__first_name','user_id__avatar','plan_id','plan_id__planName','feed','orm','avgWeight','tonnage','work','calories','tagName','totalReps','intensity','videoUrl','imageUrl','exerciseName','createdDate','status','videoType').filter(status=1, user_id=data['userId']).order_by('-id')
    for dt3 in shareinfo:
        shareObj = dict(dt3)
        shareObj['createdDate'] = shareObj['createdDate'].strftime("%Y-%m-%d")
        likeslist = {}
        if request.META.get('HTTP_AUTHORIZATION') is not None:
            user = stratsessionutil.get_user_insession(request)
            userid = user['id']
            mylikesObj = CampaignLikes.objects.select_related('CampaignFeed__id').filter(campaignfeed_id=shareObj['id'], user_id=userid).count()
            if mylikesObj > 0:
                #print('++++True +++')
                shareObj['disableLike'] = True
            else:
                #print('++++False +++')
                shareObj['disableLike'] = False
        cmntsCnt = CampaignComments.objects.select_related('CampaignFeed__id').filter(campaignfeed_id=shareObj['id']).count()
        shareObj['totalcomments'] = cmntsCnt
        bhistory = BaahubaliHistory.objects.select_related('CampaignFeed__id').filter(campaignfeed_id=shareObj['id']).count()
        shareObj['baahubalihistory'] = bhistory
        likesCnt = CampaignLikes.objects.values('campaignfeed_id', 'likeType', 'point').filter(campaignfeed_id=shareObj['id']).annotate(totalpoint=Sum('point'))
        for likesdt in likesCnt:
            likesObj = dict(likesdt)
            likeslist[likesObj['likeType']] = {'totalpoints': likesObj['totalpoint'],'campaignfeed_id': likesObj['campaignfeed_id']}
            shareObj['points'] = likeslist
        shareArr.append(shareObj)
    return JsonResponse({"success": True, "campaignData": shareArr})

def LoadCampaignData(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        cache = caches['default']
        cdata = CampaignFeed.objects.select_related('User__id','Plan__id','UserPlan__id','Exercise__id').values('id','user_id','user_id__first_name','user_id__avatar','plan_id','plan_id__planName','feed','orm','avgWeight','tonnage','work','calories','tagName','totalReps','intensity','videoUrl','imageUrl','exerciseName','createdDate','status','videoType','exercise_id').exclude(company_id = 2).filter(status =1).order_by('-id')[:500]
        CampaignArr =[]
        tagNameInfo = collections.defaultdict(list)
        for dt in cdata:
            cObj = dict(dt)
            if cObj['plan_id'] !='' and cObj['plan_id'] != None:
                secret_code_plain = cObj['plan_id__planName'] + '#' + str(cObj['plan_id'])
                secret_code_encode = base64.b64encode(secret_code_plain.encode('ascii'))
                encodedVal = str(secret_code_encode).split("'")
                cObj['encodedurl'] = encodedVal[1]
            cObj['createdDate'] = cObj['createdDate']. strftime("%Y-%m-%d")
            cObj['disableLike'] = False
            likeslist = {}
            cmntsCnt = CampaignComments.objects.select_related('CampaignFeed__id').filter(campaignfeed_id = cObj['id']).count()
            cObj['totalcomments'] = cmntsCnt
            bhistory = BaahubaliHistory.objects.select_related('CampaignFeed__id').filter(campaignfeed_id = cObj['id']).count()
            cObj['baahubalihistory'] = bhistory
            likesCnt = CampaignLikes.objects.values('campaignfeed_id', 'likeType', 'point').filter(campaignfeed_id=cObj['id']).annotate(totalpoint=Sum('point'))
            for likesdt in likesCnt:
                likesObj = dict(likesdt)
                likeslist[likesObj['likeType']] = {'totalpoints':likesObj['totalpoint'],'campaignfeed_id':likesObj['campaignfeed_id']}
                cObj['points'] = likeslist
            CampaignArr.append(cObj)
            tagNameInfo[cObj['tagName']].append(cObj)
        cache.set("CampaignArr", CampaignArr, settings.SESSION_VALIDITY)
        cache.set("tagNameInfo", tagNameInfo, settings.SESSION_VALIDITY)

        getcmnts = CampaignComments.objects.select_related('CampaignFeed__id','User__id').values('id','campaignfeed_id','comment','user_id','user_id__first_name','user_id__avatar','createdDate').filter(campaignfeed_id__status =1).order_by('-id')#[:5]
        getcmntArr = []
        totalcmntsData = collections.defaultdict(list)
        for dt in getcmnts:
            cmntObj = dict(dt)
            cmntObj['createdDate'] = cmntObj['createdDate']. strftime("%Y-%m-%d")
            getcmntArr.append(cmntObj)
            totalcmntsData[cmntObj['campaignfeed_id']].append(cmntObj)
        cache.set("totalcmntsData", totalcmntsData, settings.SESSION_VALIDITY)

        adsdata = CampaignAdvertisements.objects.select_related('User__id').values('id','image','url','status','createdBy_id__first_name','createdDate').order_by('-id')[:5]
        advertisementsArr = []
        for dt in adsdata:
            adsObj = dict(dt)
            adsObj['createdDate'] = adsObj['createdDate']. strftime("%Y-%m-%d")
            advertisementsArr.append(adsObj)
        cache.set("advertisementsArr", advertisementsArr, settings.SESSION_VALIDITY)
        return JsonResponse({"campaigndata":CampaignArr,"commentsdata":totalcmntsData, "tagnamesdata":tagNameInfo, "advertisements":advertisementsArr})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getcampaignpost(request):
    stratsessionutil = StartFitSessionUtil()
    cinfo = json.loads(request.body.decode('utf-8'))
    try:
        cache = caches['default']
        loaddata = cache.get("CampaignArr")
        if loaddata is None:
            cache.delete('CampaignArr')
            loaddata = LoadCampaignData(request)
        tagFeedCnt = {}
        tagloaddata = cache.get("tagNameInfo")
        if tagloaddata is not None:
            for tag in tagloaddata:
                tagFeedCnt[tag] = len(tagloaddata[tag])
                print(tag)
            tagFeedCnt['All'] = len(loaddata)
        if cinfo['tagName'] != 'All':
            tagname = cinfo['tagName']
            cache = caches['default']
            tagloaddata = cache.get("tagNameInfo")
            print(tagloaddata)
            if tagloaddata is not None:
                print("COMING FROM CACHE")
                if tagname in tagloaddata:
                    jsonloaddata = tagloaddata[tagname]
                    total = len(jsonloaddata)
                    if cinfo['end'] >= len(tagloaddata[tagname]):
                        cinfo['end'] = len(tagloaddata[tagname])
                        searchData = tagloaddata[tagname]
                    else:
                        searchData = tagloaddata[tagname]
                    sendData = []
                    if cinfo['end'] != 0:
                        for num in range(0, cinfo['end']):
                            cObj = searchData[num]
                            cObj['disableLike'] = False
                            if request.META.get('HTTP_AUTHORIZATION') is not None:
                                user = stratsessionutil.get_user_insession(request)
                                userid = user['id']
                                mylikesObj = CampaignLikes.objects.select_related('CampaignFeed__id').filter(campaignfeed_id=cObj['id'], user_id=userid).count()
                                if mylikesObj > 0:
                                    cObj['disableLike'] = True
                                else:
                                    cObj['disableLike'] = False
                            sendData.append(cObj)
                        return JsonResponse({"success": True, "campaignData": sendData, "totalfeed": total,"feedCount":tagFeedCnt, "msg": "From Cache"})
                    else:
                        if searchData is not None:
                            for cObj in searchData:
                                if request.META.get('HTTP_AUTHORIZATION') is not None:
                                    user = stratsessionutil.get_user_insession(request)
                                    userid = user['id']
                                    mylikesObj = CampaignLikes.objects.select_related('CampaignFeed__id').filter(
                                        campaignfeed_id=cObj['id'], user_id=userid).count()
                                    if mylikesObj > 0:
                                        cObj['disableLike'] = True
                                    else:
                                        cObj['disableLike'] = False
                                sendData.append(cObj)
                            return JsonResponse({"success": True, "campaignData": sendData, "totalfeed": total,"feedCount":tagFeedCnt, "msg": "From Cache"})
                else:
                    return JsonResponse({"success":True,"campaignData":'',"totalfeed":0,"feedCount":tagFeedCnt})
            else:
                print('+++coming from server++++')
                cdata = CampaignFeed.objects.select_related('User__id', 'Plan__id', 'UserPlan__id','Exercise__id').values('id', 'user_id','user_id__first_name','user_id__avatar', 'plan_id','plan_id__planName', 'feed', 'orm', 'avgWeight', 'tonnage', 'work','calories', 'tagName', 'totalReps','intensity', 'videoUrl', 'imageUrl','exerciseName', 'createdDate','status', 'videoType','exercise_id').filter(tagName=cinfo['tag'], status=1)
                capArr = []
                for dt in cdata:
                    cObj = dict(dt)
                    cObj['createdDate'] = cObj['createdDate'].strftime("%Y-%m-%d")
                    cObj['disableLike'] = True
                    likesCnt = CampaignLikes.objects.select_related('CampaignFeed__id').filter(
                        campaignfeed_id=cObj['id']).count()
                    cObj['totalLikes'] = likesCnt
                    if request.META.get('HTTP_AUTHORIZATION') is not None:
                        user = stratsessionutil.get_user_insession(request)
                        userid = user['id']
                        mylikesObj = CampaignLikes.objects.select_related('CampaignFeed__id').filter(
                            campaignfeed_id=cObj['id'], user_id=userid).count()
                        if mylikesObj > 0:
                            cObj['disableLike'] = True
                        else:
                            cObj['disableLike'] = False
                    cmntsCnt = CampaignComments.objects.select_related('CampaignFeed__id').filter(
                        campaignfeed_id=cObj['id']).count()
                    cObj['totalcomments'] = cmntsCnt
                    capArr.append(cObj)
                totalcapArr = len(capArr)
                return JsonResponse({"success": True, "campaignData": capArr, "totalfeed": totalcapArr,"feedCount":tagFeedCnt})
        else:
            total = len(loaddata)
            print('----getting feed data from cache1-----')
            sendData = []
            if cinfo['end'] > len(loaddata):
                cinfo['end'] = len(loaddata)
            if cinfo['end'] !=0:
                for num in range(0,cinfo['end']):
                    cObj = loaddata[num]
                    if request.META.get('HTTP_AUTHORIZATION') is not None:
                        user = stratsessionutil.get_user_insession(request)
                        userid = user['id']
                        mylikesObj = CampaignLikes.objects.select_related('CampaignFeed__id').filter(campaignfeed_id = cObj['id'], user_id = userid).count()
                        if mylikesObj > 0:
                            cObj['disableLike'] = True
                        else:
                            cObj['disableLike'] = False
                    sendData.append(cObj)
                return JsonResponse({"success":True,"campaignData":sendData,"totalfeed":total,"feedCount":tagFeedCnt, "msg":"From Cache"})
            else:
                print("+++++++coming into else block+++++++++")
                for cObj in loaddata:
                    if request.META.get('HTTP_AUTHORIZATION') is not None:
                        user = stratsessionutil.get_user_insession(request)
                        userid = user['id']
                        mylikesObj = CampaignLikes.objects.select_related('CampaignFeed__id').filter(campaignfeed_id = cObj['id'], user_id = userid).count()
                        if mylikesObj > 0:
                            cObj['disableLike'] = True
                        else:
                            cObj['disableLike'] = False
                    sendData.append(cObj)
                return JsonResponse({"success":True,"campaignData":sendData,"totalfeed":total,"feedCount":tagFeedCnt, "msg":"From Cache"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def searchtagname(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        taginfo = json.loads(request.body.decode('utf-8'))
        tagname = taginfo['tag']
        cache = caches['default']
        loaddata = cache.get("tagNameInfo")
        if loaddata is not None:
            jsonloaddata = loaddata["baahubali"]
            total = len(jsonloaddata)
            if tagname in loaddata:
                return JsonResponse({"success":True,"campaignData":loaddata[tagname],"totalfeed":total})
            else:
                return JsonResponse({"success":True,"campaignData":'',"totalfeed":total})
        else:
            #print('+++coming from server++++')
            cdata = CampaignFeed.objects.select_related('User__id','Plan__id','UserPlan__id','Exercise__id').values('id','user_id','user_id__first_name','user_id__avatar','plan_id','plan_id__planName','feed','orm','avgWeight','tonnage','work','calories','tagName','totalReps','intensity','videoUrl','imageUrl','exerciseName','createdDate','status','videoType','exercise_id').filter(tagName = taginfo['tag'],status =1)
        capArr =[]
        for dt in cdata:
            cObj = dict(dt)
            cObj['createdDate'] = cObj['createdDate']. strftime("%Y-%m-%d")
            cObj['disableLike'] = True
            likesCnt = CampaignLikes.objects.select_related('CampaignFeed__id').filter(campaignfeed_id = cObj['id']).count()
            cObj['totalLikes'] = likesCnt
            if request.META.get('HTTP_AUTHORIZATION') is not None:
                user = stratsessionutil.get_user_insession(request)
                userid = user['id']
                mylikesObj = CampaignLikes.objects.select_related('CampaignFeed__id').filter(campaignfeed_id = cObj['id'], user_id = userid).count()
                if mylikesObj > 0:
                    cObj['disableLike'] = True
                else:
                    cObj['disableLike'] = False
            cmntsCnt = CampaignComments.objects.select_related('CampaignFeed__id').filter(campaignfeed_id = cObj['id']).count()
            cObj['totalcomments'] = cmntsCnt
            capArr.append(cObj)
        totalcapArr = len(capArr)
        return JsonResponse({"success":True,"campaignData":capArr,"totalfeed":totalcapArr})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg":str(e)})

def filtertagnames(request):
    try:
        tdata = json.loads(request.body.decode('utf-8'))
        tag = CampaignFeed.objects.values('tagName').filter(tagName__istartswith = tdata['tagname'],status=1).distinct()
        tagArr = []
        for dt in tag:
            tagObj = dict(dt)
            tagObj['unique']=tagObj['tagName'].replace(" ", "_")
            tagArr.append(tagObj)
        return JsonResponse({"success":True,"tagNames":tagArr})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def savecampaignpost(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        userid = username['id']
        postinfo = json.loads(request.body.decode('utf-8'))
        #print(postinfo)
        if 'tagname' in postinfo['campInfo'] and postinfo['campInfo']['tagname'] != '':
            tagName = postinfo['campInfo']['tagname']
        else:
            tagName = "baahubali"
        if username != None:
            if 'campInfo' in postinfo:
                cdata = CampaignFeed.objects.create(
                    user_id = userid,
                    tagName = tagName
                )
                cdata.feed = postinfo['campInfo']['composeMsg']
                if 'titleMsg' in postinfo['campInfo'] and postinfo['campInfo']['titleMsg'] !='':
                    cdata.title = postinfo['campInfo']['titleMsg']
                if 'url' in postinfo['campInfo'] and postinfo['campInfo']['url'] !='':
                    if 'http' in postinfo['campInfo']['url']:
                        cdata.websiteUrl = postinfo['campInfo']['url']
                    else:
                        cdata.websiteUrl = "http://"+postinfo['campInfo']['url']
                cdata.save()
                lastfeedid = cdata.id
                cache.delete('CampaignArr')
                loaddata = LoadCampaignData(request)
                loadfeeddata = cache.get("CampaignArr")
                return JsonResponse({"success":True,"message": "Post Shared successfully",'feedid':lastfeedid})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def updatecampaignfeed(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        user = stratsessionutil.get_user_insession(request)
        pinfo = json.loads(request.body.decode('utf-8'))
        #print(pinfo)
        if user != None:
            if 'postid' in pinfo:
                print('+++ if condition +++')
                cdata = CampaignFeed.objects.get(id = pinfo['postid'])
                cdata.feed = pinfo['postfeed']
                cdata.save()
                cache.delete('CampaignArr')
                loaddata = LoadCampaignData(request)
                loadfeeddata = cache.get("CampaignArr")
                return JsonResponse({"success":True,"message":"Post updated successfully","campaignData":loadfeeddata})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def deletecampaignpost(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        user = stratsessionutil.get_user_insession(request)
        postdata = json.loads(request.body.decode('utf-8'))
        #print(postdata)
        if user != None:
            if 'postid' in postdata:
                postid = postdata['postid']
                feed = CampaignFeed.objects.get(id = postid)
                feed.status = 0
                feed.save()
                cache.delete('CampaignArr')
                loaddata = LoadCampaignData(request)
                loadfeeddata = cache.get("CampaignArr")
                return JsonResponse({"success":True,"message":"Post deleted successfully","campaignData":loadfeeddata})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def sharecampaignpost(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        user = stratsessionutil.get_user_insession(request)
        userid = user['id']
        postinfo = json.loads(request.body.decode('utf-8'))
        #print(postinfo)
        if user != None:
            cdata = CampaignFeed.objects.create(
                user_id = userid,
            )
            cdata.plan_id = postinfo['plan_id']
            cdata.exercise_id = postinfo['exerciseName_id']
            cdata.session_id = postinfo['session_id']
            cdata.feed = postinfo['exerciseName']
            cdata.orm = postinfo['StatsessionDetails']['orm']
            cdata.avgWeight = postinfo['StatsessionDetails']['avgWeight']
            cdata.tonnage = postinfo['StatsessionDetails']['totalTonnage']
            cdata.tagName = postinfo['exerciseName']
            cdata.work = postinfo['StatsessionDetails']['totalWork']
            cdata.calories = postinfo['StatsessionDetails']['calories']
            cdata.totalReps = postinfo['StatsessionDetails']['repsDone']
            cdata.intensity = postinfo['StatsessionDetails']['intensity']
            cdata.exerciseName = postinfo['exerciseName']
            cdata.save()
            lastfeedid = cdata.id
            binfo =  BaahubaliHistory.objects.values('id','orm','avgWeight').order_by('-id')[:1]
            if len(binfo) == 0:
                bdata = BaahubaliHistory.objects.create(
                    campaignfeed_id = lastfeedid,
                    exercise_id = postinfo['exerciseName_id'],
                    orm = postinfo['StatsessionDetails']['orm'],
                    avgWeight = postinfo['StatsessionDetails']['avgWeight'],
                    user_id = userid
                )
                bdata.save()
            else:
                for dt in binfo:
                    bObj = dict(dt)
                    orm = bObj['orm']
                    if float(postinfo['StatsessionDetails']['orm']) > orm:
                        bdata = BaahubaliHistory.objects.create(
                            campaignfeed_id = lastfeedid,
                            exercise_id = postinfo['exerciseName_id'],
                            orm = postinfo['StatsessionDetails']['orm'],
                            avgWeight = postinfo['StatsessionDetails']['avgWeight'],
                            user_id = userid
                        )
                        bdata.save()
            return JsonResponse({"success":True,"message": "Post Shared Successfully"})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def uploadimage(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        user = stratsessionutil.get_user_insession(request)
        imginfo = json.loads(request.body.decode('utf-8'))
        if user != None:
            if 'image' in  imginfo:
                print('++++++++imageUpload+++++++++++++')
                img = CampaignFeed.objects.get(id = imginfo['fid'])
                img.imageUrl = imginfo['image']
                img.save()
                cache.delete('CampaignArr')
                loaddata = LoadCampaignData(request)
                loadfeeddata = cache.get("CampaignArr")
                return JsonResponse({"success":True,"message":"Image Uploaded successfully","campaignData":loadfeeddata})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def videoupload(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        vidinfo = json.loads(request.body.decode('utf-8'))
        print(vidinfo)
        if username != None:
            if 'video' in  vidinfo:
                #print('++++++++videoUpload+++++++++++++')
                video = CampaignFeed.objects.get(id = vidinfo['fid'])
                video.videoUrl = vidinfo['video']
                video.save()
                cache.delete('CampaignArr')
                loaddata = LoadCampaignData(request)
                loadfeeddata = cache.get("CampaignArr")
                return JsonResponse({"success":True,"message":"Video Uploaded successfully","campaignData":loadfeeddata})
            elif 'youtubeurl' in vidinfo:
                video = CampaignFeed.objects.get(id=vidinfo['fid'])
                video.videoType = "youtube"
                video.videoUrl = vidinfo['youtubeurl']
                video.save()
                cache.delete('CampaignArr')
                loaddata = LoadCampaignData(request)
                loadfeeddata = cache.get("CampaignArr")
                return JsonResponse({"success": True, "message": "Video Uploaded successfully", "campaignData": loadfeeddata})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def savelikes(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        userid = username['id']
        cpdata = json.loads(request.body.decode('utf-8'))
        #print(cpdata)
        if username != None:
            existdata = CampaignLikes.objects.filter(user_id = userid ,campaignfeed_id = cpdata['likesdata']['id']).values('id')
            if existdata.exists():
                return JsonResponse({"success":False,"message":"Liked"})
            else:
                cdata = CampaignLikes.objects.create(
                    campaignfeed_id = cpdata['likesdata']['id'],
                    user_id = userid
                )
                cdata.save()
                cache.delete('CampaignFeedData')
                loaddata = LoadCampaignData(request)
                return JsonResponse({"success":True,"message":"Liked"})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def savepoints(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        userid = username['id']
        pointsdata = json.loads(request.body.decode('utf-8'))
        print(pointsdata)
        if username != None:
            existdata = CampaignLikes.objects.values('id','campaignfeed_id','likeType','point','user_id').filter(campaignfeed_id = pointsdata['postid'],user_id = userid)
            if existdata.exists():
                print('==============exists=============')
                return JsonResponse({"success":False,"message":"already liked"})
            else:
                print(('====create========'))
                cdata = CampaignLikes.objects.create(
                    campaignfeed_id = pointsdata['postid'],
                    likeType = pointsdata['liketype'],
                    point = pointsdata['pointvalue'],
                    user_id = userid
                )
                cdata.save()
                cache.delete('CampaignFeedData')
                loaddata = LoadCampaignData(request)
                return JsonResponse({"success":True,"message":"like saved"})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def savecomments(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        userid = username['id']
        cmmtsdata = json.loads(request.body.decode('utf-8'))
        #print(cmmtsdata)
        arr = []
        if username != None:
            cmnt = CampaignComments.objects.create(
                user_id = userid,
                campaignfeed_id = cmmtsdata['postfeedId'],
                comment = cmmtsdata['comment']
            )
            cmnt.save()
            usercomments = User.objects.get(id=userid)
            if usercomments.avatar != None and usercomments.avatar !='':
                usercomments.avatar = settings.S3URL + str(usercomments.avatar)
            else:
                usercomments.avatar = 'http://stratfit.net/assets/images/user.png'
            arr.append({"id": usercomments.id, "firstName": usercomments.first_name, "lname": usercomments.last_name, "avatar":usercomments.avatar , "commentId":cmnt.id,"comments": cmnt.comment})
            cache.delete('totalcmntsData')
            loaddata = LoadCampaignData(request)
            return JsonResponse({"success":True,"message":"comment saved","details":arr})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def editpostcomments(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        user = stratsessionutil.get_user_insession(request)
        editdata = json.loads(request.body.decode('utf-8'))
        #print(editdata)
        if user != None:
            if 'postId' in editdata:
                postid = editdata['postId']
                cmnt = CampaignComments.objects.get(id = editdata['commentId'])
                cmnt.comment = editdata['cmnt']
                cmnt.save()
                cache.delete('totalcmntsData')
                loaddata = LoadCampaignData(request)
                loadcmnts = cache.get("totalcmntsData")
                return JsonResponse({"success":True,"message":"comment updated","campaignCmnts":loadcmnts[postid]})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def deletecomment(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        user = stratsessionutil.get_user_insession(request)
        cmtdata = json.loads(request.body.decode('utf-8'))
        #print(cmtdata)
        if user != None:
            if 'postid' in cmtdata:
                postid = cmtdata['postid']
                cmnt = CampaignComments.objects.get(id = cmtdata['commentid'])
                cmnt.delete()
                cache.delete('totalcmntsData')
                loaddata = LoadCampaignData(request)
                loadcmnts = cache.get("totalcmntsData")
                return JsonResponse({"success":True,"message":"comment deleted","campaignCmnts":loadcmnts[postid]})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg":str(e)})

def getcomments(request):
    try:
        cmmtsinfo = json.loads(request.body.decode('utf-8'))
        #print(cmmtsinfo)
        postfeedid = cmmtsinfo['feedpostid']
        cache = caches['default']
        loaddata = cache.get("totalcmntsData")
        print(loaddata)
        if loaddata is not None:
            if postfeedid in loaddata:
                print('----getting from cache-----')
                return JsonResponse({"campaignCmnts":loaddata[postfeedid]})
            else:
                return JsonResponse({"campaignCmnts": ''})
        else:
            print('----server call-----')
            cmnt = CampaignComments.objects.select_related('CampaignFeed__id','User__id').values('id','campaignfeed_id','comment','user_id','user_id__first_name','user_id__avatar','createdDate').filter(campaignfeed_id = cmmtsinfo['feedpostid']).order_by('-id')#[:5]
            cmntArr = []
            for dt in cmnt:
                cmntObj = dict(dt)
                cmntObj['createdDate'] = cmntObj['createdDate']. strftime("%Y-%m-%d %H:%M:%S")
                cmntArr.append(cmntObj)
            return JsonResponse({"campaignCmnts":cmntArr})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def createadvertisements(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        userid = username['id']
        advdata = json.loads(request.body.decode('utf-8'))
        #print(advdata)
        if username != None:
        #if 'advurl' in advdata:
            if 'http://' in advdata['advurl']:
                adsurl = advdata['advurl']
                print(adsurl,'++if')
            else:
                adsurl = "http://"+advdata['advurl']
                print(adsurl,'++else')
            ads = CampaignAdvertisements.objects.create(
                image = advdata['advimage'],
                url = adsurl,
                status =1,
                createdBy_id = userid
            )
            ads.save()
            cache.delete('advertisementsArr')
            loaddata = LoadCampaignData(request)
            load_adsdata = cache.get('advertisementsArr')
            return JsonResponse({"success":True,"message":"advertisement saved","adsdata":load_adsdata})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg":str(e)})


def getadvertisements(request):
    try:
        cache = caches['default']
        loaddata = cache.get('advertisementsArr')
        if loaddata is not None:
            return JsonResponse({"success":True,"adsdata":loaddata})
        else:
            adsdata = CampaignAdvertisements.objects.select_related('User__id').values('id','image','url','status','createdBy_id__first_name','createdDate')
            adsArr = []
            for dt in adsdata:
                adsObj = dict(dt)
                adsObj['createdDate'] = adsObj['createdDate']. strftime("%Y-%m-%d")
                adsArr.append(adsObj)
            return JsonResponse({"success":True,"adsdata":adsArr})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def userReferral(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        user = stratsessionutil.get_user_insession(request)
        fname = user['first_name']
        uref = json.loads(request.body.decode('utf-8'))
        uEmail = uref['refemail']
        if user != None:
            randomnumber=[]
            check = UserReferral.objects.filter(user_id = user['id']).values('referralCode','user_id')
           
            def store2(check):
                if check.exists():
                    print('++if condition+++')
                    for dt in check:
                        randcode = dt['referralCode']
                        randomnumber.append(randcode)
                    #sendreferralemail(randcode, uEmail, fname)
                    return(randomnumber)
                else:
                    print('++else condition+++')
                    sevendays = datetime.today()+ relativedelta(days =+7)
                    randomCode = ''.join(choice('0123456789') for i in range(6))
                    randcode = str(randomCode)
                    userref = UserReferral.objects.create(
                        user_id = user['id'],
                        referralCode = randcode,
                        status = 1,
                        expiryDate = sevendays
                    )
                    userref.save()
                    print('+++code saved++++')
                    randomnumber.append(randcode)
                    return randomnumber
            def mail2(rand,uEmail,fname):
                randcode=rand   
                sendreferralemail(randcode, uEmail, fname)
            with concurrent.futures.ThreadPoolExecutor() as executor:
                future=executor.submit(store2,check)
                rand=future.result()
            t2=threading.Thread(target=mail2,args=(rand,uEmail,fname,))
            t2.start()
            #t2.join()    
            return JsonResponse({"success":True,"message":"Thank you for referring your friend."})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg":str(e)})

def sendreferralemail(randcode, uEmail, fname):
    try:
        subject = "Invitation to Stratfit Strength Coach App"
        to_email = uEmail
        ctx={
            'referred_user':fname,
            'referralcode':randcode
        }
        message = render_to_string('referral.html',ctx)
        officeMail(subject, message,to_email)
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getreferralcode(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        user = stratsessionutil.get_user_insession(request)
        if user != None:
            check = UserReferral.objects.select_related('User__id').filter(user_id = user['id']).values('referralCode','user_id','user_id__first_name')
            if check.exists():
                #refArr = []
                for dt in check:
                    refcode = dt['referralCode']
                    #refObj = dict(dt)
                    #refArr.append(refObj)
                return JsonResponse({"success":True,"referralinfo":refcode})
            else:
                return JsonResponse({"success":False,"referralinfo":''})
        else:
            return JsonResponse({"success":False,"message": "user logged out","referralinfo":''})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def baahubaliVideos(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        user = stratsessionutil.get_user_insession(request)
        userid = user['id']
        viddata = json.loads(request.body.decode('utf-8'))
        print(viddata)
        if user != None:
            if 'promovideo' in viddata:
                print('++++++++if condition++++++')
                vid = BaahubaliPromoVideos.objects.create(
                    videoUrl = viddata['promovideo'],
                    user_id = userid
                )
                vid.save()
                return JsonResponse({"success":True,"message":"Video uploaded successfully"})
            elif 'youtubelink' in viddata:
                print('++++++++else if condition++++++')
                vid2 = BaahubaliPromoVideos.objects.create(
                    videoUrl=viddata['youtubelink'],
                    videoType="youtube",
                    user_id=userid
                )
                vid2.save()
                return JsonResponse({"success": True, "message": "Video uploaded successfully"})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg":str(e)})

def getBaahubaliVideos(request):
    try:
        vidinfo = BaahubaliPromoVideos.objects.values('id','videoUrl','user_id','videoType').order_by('-id')[:5]
        vidArr = []
        for dt in vidinfo:
            vidObj = dict(dt)
            vidArr.append(vidObj)
        return JsonResponse({"success":True,"baahuabalivideos":vidArr})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg":str(e)})

'''@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def baahubalipoints(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        user = stratsessionutil.get_user_insession(request)
        data = json.loads(request.body.decode('utf-8'))
        print(data)
        if user != None:
            pinfo = BaahubaliPoints.objects.create(
                campaignfeed_id = data['pid'],
                pointsScored = data['points'],
                user_id = user['id']
            )
            if data['points'] == 1:
                pinfo.pointValue = 10
            elif data['points'] == 2:
                pinfo.pointValue = 7
            elif data['points'] == 3:
                pinfo.pointValue = 4
            elif data['points'] == 4:
                pinfo.pointValue = -1
            pinfo.save()
            return JsonResponse({"success":True,"mesage":"point saved"})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg":str(e)})'''

def savefeedback(request):
    data = json.loads(request.body.decode('utf-8'))
    print(data)
    inf=[]
    if data!=None:
        
        def store1(data):
            
            pinfo = Feedback.objects.create(
                name = data['name'],
                email = data['email'],
                feedback  = data['feedback']
            )
            if 'org' in data and data['org'] != '':
                pinfo.organization = data['org']
            if 'number' in data and data['number'] != '':
                pinfo.phone_num = data['number']
            pinfo.save()
            
            inf.append(pinfo)
            return inf
        def mail1(info,data): 
            pinfo=info[0] 
            
            subject = "Feedback"
            #to_email = "info@stratfit.co"
            to_email = data['email']
            ctx = {
                'first_name':pinfo.name,
                'email': pinfo.email
            }
            message = render_to_string('feedback.html', ctx)
            officeMail(subject, message, to_email)
            return message
        with concurrent.futures.ThreadPoolExecutor() as executor:
            future=executor.submit(store1,data)
            info=future.result()
        t2=threading.Thread(target=mail1,args=(info,data,))
        t2.start()
        #t2.join()    
        return JsonResponse({"success":True,"message":"Thank you for your feedback"})
    else:
        return JsonResponse({"success":False,"message":"please enter valid data"})
@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getfeedback(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    print(username)
    try:
        #user = username['id']
        #print(user)
        if username != None:
            if 'rows' in request.POST and request.POST['rows'] != '':
                rows = int(request.POST['rows'])
            else:
                rows = 50

            if 'page' in request.POST and request.POST['page'] != '':
                page = int(request.POST['page'])
            else:
                page = 1
            offset = (page - 1) * rows
            tot = page * rows
            userpage = Feedback.objects.values('id','name','email','feedback','organization').order_by('-id')
            userarry = []
            total = len(userpage)
            data = userpage[offset:tot]
            for dt in data:
                #print(dt)
                dataObj = dict(dt)
                print(dataObj)
                userarry.append(dataObj )
            return JsonResponse({"success": True, "details": userarry,"total":total})
        else:
            return JsonResponse({"success": False,"message":"User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})


@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def feedbacksearch(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    feedInfo = json.loads(request.body.decode('utf-8'))
    try:
        if username != None:
            print(feedInfo)
            if 'rows' in feedInfo and 'rows' != '':
                rows = int(feedInfo['rows'])
            else:
                rows = 50
            if 'page' in feedInfo and 'page' != '':
                page = int(feedInfo['page'])
            else:
                page = 1
            offset = (page - 1) * rows
            tot = page * rows
            #excfilter = ExerciseType.objects.all().order_by('-modifiedDate')
            feedFilter =Feedback.objects.values('id','email','feedback','organization','name').order_by('-id')
            #print(exeinfo['excdata']['exerciseCategory'],'+++++++++++++')
            print(feedInfo)
            if 'feedData' in feedInfo !='':
                if 'name' in feedInfo['feedData']  and feedInfo['feedData']['name'] !='':
                    print("came IN to hereee",feedInfo['feedData']['name'])
                    feedFilter = feedFilter.filter(name__icontains = feedInfo['feedData']['name'])
                if 'email' in feedInfo['feedData']  and feedInfo['feedData']['email'] !='':
                    print("This Came IN here",feedInfo['feedData']['email'])
                    feedFilter = feedFilter.filter(email__icontains = feedInfo['feedData']['email'])
            dataArr = list()
            total = len(feedFilter)
            totaldata = feedFilter[offset:tot]
            for dt in totaldata:
                dataObj = dict(dt)
                dataArr.append(dataObj)
                print(dataArr)
            return JsonResponse({"success": True, "details": dataArr,"total":total})
        else:
            return JsonResponse({"success": False,"message":"logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})


def getPostsData(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        cdata = CampaignFeed.objects.select_related('User__id','Plan__id','UserPlan__id','Exercise__id').values('id','user_id','user_id__first_name','user_id__avatar','plan_id','plan_id__planName','feed','orm','avgWeight','tonnage','work','calories','tagName','totalReps','intensity','videoUrl','imageUrl','exerciseName','createdDate','status','videoType','websiteUrl','title').filter(status =1,tagName="stratfitpost").order_by('-id')
        CampaignArr =[]
        for dt in cdata:
            cObj = dict(dt)
            cObj['createdDate'] = cObj['createdDate']. strftime("%Y-%m-%d")
            CampaignArr.append(cObj)
        return JsonResponse({"campaigndata":CampaignArr})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg":str(e)})