from django.db import models

# Create your models here.
from Plan.models import Plan, PlanSession
from Subscriber.models import User
from Userplan.models import UserPlan
from utility.models import Exercise
from Company.models import Company


class CampaignFeed(models.Model):
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    plan = models.ForeignKey(Plan, null=True, blank=True, on_delete=models.CASCADE)
    userPlan = models.ForeignKey(UserPlan, null=True, blank=True, on_delete=models.CASCADE)
    exercise = models.ForeignKey(Exercise, null=True, blank=True, on_delete=models.CASCADE)
    exerciseName = models.CharField(max_length=155, null=True, blank=True)
    session = models.ForeignKey(PlanSession, null=True, blank=True, on_delete=models.CASCADE)
    feed = models.TextField(null=True, blank=True)
    orm = models.FloatField(null=True, blank=True)
    avgWeight = models.FloatField(null=True, blank=True)
    tonnage = models.FloatField(null=True, blank=True)
    work = models.FloatField(null=True, blank=True)
    calories = models.FloatField(null=True, blank=True)
    videoType = models.CharField(max_length=50, null=True, blank=True)
    videoUrl = models.TextField(null=True, blank=True)
    imageUrl =  models.TextField(null=True, blank=True)
    tagName =  models.CharField(max_length=150, null=True, blank=True)
    totalReps =  models.IntegerField(null=True, blank=True)
    intensity =  models.IntegerField(null=True, blank=True)
    status = models.IntegerField(default=1)
    company = models.ForeignKey(Company,default=1, on_delete=models.CASCADE)
    title = models.CharField(max_length=155,null=True,blank=True)
    websiteUrl = models.TextField(null=True,blank=True)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class campaignImages(models.Model):
    imageUrl =  models.TextField(null=True, blank=True)
    campaign = models.ForeignKey(CampaignFeed, on_delete=models.CASCADE)

class campaignVideos(models.Model):
    videoType = models.CharField(max_length=50, null=True, blank=True)
    videoUrl =  models.TextField(null=True, blank=True)
    campaign = models.ForeignKey(CampaignFeed, on_delete=models.CASCADE)

class BaahubaliHistory(models.Model):
    campaignfeed =  models.ForeignKey(CampaignFeed , related_name='cb_feedid', on_delete=models.CASCADE)
    user = models.ForeignKey(User,related_name='cb_uid', on_delete=models.CASCADE)
    exercise = models.ForeignKey(Exercise, null=True, blank=True, on_delete=models.CASCADE)
    orm = models.FloatField(null=True, blank=True)
    avgWeight = models.FloatField(null=True, blank=True)

class CampaignLikes(models.Model):
    campaignfeed = models.ForeignKey(CampaignFeed, related_name='cl_feedid', on_delete=models.CASCADE)
    likeType = models.CharField(max_length=20, null=True, blank=True)
    point = models.IntegerField(null=True, blank=True)
    user = models.ForeignKey(User,related_name='cl_uid', on_delete=models.CASCADE)
    createdDate = models.DateTimeField(auto_now_add=True)

class CampaignComments(models.Model):
    campaignfeed = models.ForeignKey(CampaignFeed, related_name='cc_feedid', on_delete=models.CASCADE)
    comment = models.TextField()
    user = models.ForeignKey(User,related_name='cc_uid', on_delete=models.CASCADE)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class CampaignAdvertisements(models.Model):
    image = models.TextField(null=True, blank=True)
    url = models.TextField(null=True, blank=True)
    status = models.IntegerField(default=0)
    createdBy = models.ForeignKey(User,related_name='cadv_uid', on_delete=models.CASCADE)
    createdDate = models.DateTimeField(auto_now_add=True)

class BaahubaliPromoVideos(models.Model):
    user = models.ForeignKey(User,related_name='bp_uid', on_delete=models.CASCADE)
    videoUrl = models.TextField(null=True, blank=True)
    videoType = models.CharField(max_length=30, null=True, blank=True)

class Feedback(models.Model):
    name =  models.CharField(max_length=100,null=True)
    email = models.CharField(max_length=100)
    phone_num = models.CharField(max_length=50,null=True)
    organization = models.CharField(max_length=100,null=True)
    feedback = models.TextField()
    createdDate = models.DateTimeField(auto_now_add=True)
