from django.conf import settings
from django.db import models
from Subscriber.models import User
from Plan.models import PlanPeriods,PlanExcercise,PlanMesocycle,Microcycle,PlanSession,PlanSets,Plan
from utility.models import Videos, Exercise, NewExercise
# Create your models here.

class UserPlan(models.Model):
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    plan = models.ForeignKey(Plan, on_delete=models.CASCADE)
    status=models.IntegerField(blank=False,default = 1)
    startDate = models.DateTimeField(blank=True, null=True)
    dayOff = models.IntegerField(default=0, blank=True, null=True)
    endDate = models.DateTimeField(blank=True, null=True)
    renewalDate = models.DateTimeField(blank=True, null=True)
    nextRenewalDate = models.DateTimeField(blank=True,null=True)
    seasonDate = models.DateTimeField(blank=True,null=True)
    microcyclecount = models.IntegerField(blank=True, null=True)
    freetrail = models.BooleanField(blank=True, null=True)
    deviceDate = models.DateTimeField(null=True)
    createdDate = models.DateTimeField(auto_now_add=True)
    updatedDate = models.DateTimeField(auto_now=True)

class UserTestPlan(models.Model):
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    plan = models.ForeignKey(Plan, on_delete=models.CASCADE)
    userplan = models.ForeignKey(UserPlan, on_delete=models.CASCADE)
    exerciseId = models.ForeignKey(NewExercise, default=1, on_delete=models.CASCADE)
    exerciseName = models.CharField(max_length=150, blank=False)
    workWeight = models.IntegerField(blank=False)
    tmax = models.IntegerField(null=True, blank=True)
    workoutTestDate = models.DateTimeField(blank=False)
    updateTmax = models.IntegerField(null=True, blank=True)
    updateType = models.IntegerField(null=True, blank=True)
    createdDate = models.DateTimeField(auto_now_add=True)
    updatedDate = models.DateTimeField(auto_now=True)

class UserPlanCycle(models.Model):
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    plan = models.ForeignKey(Plan, on_delete=models.CASCADE)
    userplan = models.ForeignKey(UserPlan, on_delete=models.CASCADE)
    BP_missed = models.BooleanField(blank=True, null=True)
    BP_recovered = models.BooleanField(blank=True, null=True)
    BP_progressed = models.BooleanField(blank=True, null=True)
    SQAT_missed = models.BooleanField(blank=True, null=True)
    SQAT_recovered = models.BooleanField(blank=True, null=True)
    SQAT_progressed = models.BooleanField(blank=True, null=True)
    OP_missed = models.BooleanField(blank=True, null=True)
    OP_recovered = models.BooleanField(blank=True, null=True)
    OP_progressed = models.BooleanField(blank=True, null=True)
    DL_missed = models.BooleanField(blank=True, null=True)
    DL_recovered = models.BooleanField(blank=True, null=True)
    DL_progressed = models.BooleanField(blank=True, null=True)
    createdDate = models.DateTimeField(auto_now_add=True)
    updatedDate = models.DateTimeField(auto_now=True)

class UserExercise(models.Model):
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    plan = models.ForeignKey(Plan, on_delete=models.CASCADE)
    userplan = models.ForeignKey(UserPlan, on_delete=models.CASCADE)
    exerciseId = models.ForeignKey(Exercise, default=1, on_delete=models.CASCADE)
    period = models.ForeignKey(PlanPeriods, related_name="exercisePeriod", on_delete=models.CASCADE)
    mesocycle = models.ForeignKey(PlanMesocycle, related_name="exerciseMeso", on_delete=models.CASCADE)
    microcycle = models.ForeignKey(Microcycle, related_name="exerciseMicro", on_delete=models.CASCADE)
    session = models.ForeignKey(PlanSession, on_delete=models.CASCADE)
    planexercise = models.ForeignKey(PlanExcercise, null=True, blank=True, on_delete=models.CASCADE)
    exerciseDate = models.DateTimeField(auto_now_add=True)
    exerciseName = models.CharField(max_length=25, blank=True, null=True)
    nextExerciseName = models.ForeignKey(Exercise, null=True,related_name="nextEx", on_delete=models.CASCADE)
    exerciseWorkWeight = models.CharField(max_length=10, blank=False)
    missed = models.BooleanField(blank=True, null=True)
    recovered = models.BooleanField(blank=True, null=True)
    progressed = models.BooleanField(blank=True, null=True)
    regressed = models.BooleanField(blank=True, null=True)
    tMax = models.IntegerField(blank=True, null=True)
    Inol = models.IntegerField(blank=True, null=True)
    intensity = models.IntegerField(blank=True, null=True)
    totalReps = models.IntegerField(blank=True, null=True)
    totalSets = models.IntegerField(blank=True, null=True)
    userSession = models.IntegerField(blank=False,default=0)
    createdDate = models.DateTimeField(auto_now_add=True)
    advTime = models.FloatField(null=True)
    advDistance = models.IntegerField(null=True)
    speed = models.FloatField(null=True,blank=True)
    height = models.FloatField(null=True,blank=True)
    exSkip = models.BooleanField(default = False)

class UserSets(models.Model):
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    plan = models.ForeignKey(Plan, on_delete=models.CASCADE)
    userplan = models.ForeignKey(UserPlan, null=True, blank=True, on_delete=models.CASCADE)
    period = models.ForeignKey(PlanPeriods, related_name="setPeriod", on_delete=models.CASCADE)
    mesocycle = models.ForeignKey(PlanMesocycle, related_name="setMeso", on_delete=models.CASCADE)
    microcycle = models.ForeignKey(Microcycle, related_name="setMicro", on_delete=models.CASCADE)
    session = models.ForeignKey(PlanSession, related_name="setSession", on_delete=models.CASCADE)
    planexercise = models.ForeignKey(PlanExcercise, null=True, blank=True, on_delete=models.CASCADE)
    planset = models.ForeignKey(PlanSets, null=True, blank=True, on_delete=models.CASCADE)
    userexercise = models.ForeignKey(UserExercise, on_delete=models.CASCADE)
    setDate = models.DateTimeField(null=True, blank=True)
    setExercise = models.CharField(max_length=25, null=True, blank=True)
    exercise = models.ForeignKey(Exercise, null=True, blank=True, on_delete=models.CASCADE)
    setNumber = models.SmallIntegerField(blank=False)
    totalReps = models.IntegerField(blank=False)
    setIntensity = models.IntegerField(blank=True,null=True, default=100)
    setWorkWeight = models.IntegerField(blank=True, null=True, default=0)
    createdDate = models.DateTimeField(auto_now_add=True)
    advTime = models.FloatField(null=True)
    advDistance = models.IntegerField(null=True)
    sessionStatus = models.IntegerField(default=1)
    speed = models.FloatField(null=True,blank=True)
    height = models.FloatField(null=True,blank=True)
    setStatus = models.SmallIntegerField(null=True)
    setSkip = models.BooleanField(default = False)

class UserSetVideos(models.Model):
    video = models.ForeignKey(Videos,null=True,blank=True, on_delete=models.CASCADE)
    set = models.ForeignKey(UserSets, on_delete=models.CASCADE)
    createdBy = models.ForeignKey(User, related_name='setvideo', on_delete=models.CASCADE)
    modifiedBy = models.ForeignKey(User, related_name='setvideoMod', on_delete=models.CASCADE)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class RegressionRules(models.Model):
    min_rep = models.IntegerField()
    max_rep = models.IntegerField()
    startWeight = models.IntegerField()
    absoluteWeight = models.IntegerField()
    percentWeight = models.IntegerField()
    setPlan = models.BooleanField(default=False)
    setStart = models.IntegerField()
    setEnd = models.IntegerField()
    setIncreament = models.IntegerField()
    repsPerSet = models.IntegerField()
    sessionRepeat = models.IntegerField(null=True)

class Gymuserplans(models.Model):
    plan = models.ForeignKey(Plan, related_name='gym_planid', on_delete=models.CASCADE)
    user = models.ForeignKey(User, related_name='gym_userid', on_delete=models.CASCADE)
    price = models.CharField(max_length=50,null=True,blank=True)
    status = models.SmallIntegerField(default=0)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class Mealplans(models.Model):
    user = models.ForeignKey(User, related_name='meal_userid', on_delete=models.CASCADE)
    mealJson = models.TextField(blank=True,null=True)
    createdDate = models.DateField(auto_now_add=True)
