from django.shortcuts import render

# Create your views here.
import urllib
from urllib.parse import parse_qs
import collections
from django.core.mail import EmailMultiAlternatives
from django.db import connection
from django.forms import model_to_dict
from django.forms.models import model_to_dict
from django.http import JsonResponse, HttpResponse
from django.shortcuts import render
from django.template import Context
from django.template.loader import render_to_string, get_template
try: # for pip >= 10
    from pip._internal.req.req_install import logger
except ImportError: # for pip <= 9.0.3
    from pip.req.req_install import logger

# Create your views here.
import time
import json
from datetime import datetime, timedelta
from django.db.models import Max
from rest_framework import status
from django.utils import timezone
import concurrent.futures
import threading
from Program.models import Plan,Plan_Period, Plan_Mesocycle, Plan_Microcycles, Plan_Sessions, PlanProtocol,SelectedAbilities, PlanGoals,PlanVideos,Plan_Actions
from StratFit import settings
from Subscriber.models import User, FitnessProfile,UserPlateWeight
from Subscriber.serializers import AuthResponseSerializer
from rest_framework.decorators import api_view, authentication_classes, permission_classes
from rest_framework.response import Response
from Subscriber.Authentication import StartFitAuthentication,SessionAuthentication,StartFitSessionUtil, AuthResponse,IsAuthenticated
from django.views.decorators.cache import never_cache
from .models import UserPlan, UserTestPlan,  UserPlanCycle,  Mealplans, UserActions
from payment.models import TransactionHistory
from utility.models import ExerciseType, NewExercise, Videos, PriceMapping, PriceConversion, AdvExercises,FullMeals
from datetime import date
from dateutil.relativedelta import relativedelta
from Subscriber.views import exceptionMail
from utility.views import officeMail


@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def ionicuserplancheck(request):
    stratsessionutil = StartFitSessionUtil()
    user = stratsessionutil.get_user_insession(request)
    userid = user['id']
    try:
        checkplan = UserPlan.objects.filter(user_id = userid,status=1).values()
        userplansCount = UserPlan.objects.filter(user_id  = userid).count()
        if checkplan.exists():
            for val in checkplan:
                valObj = dict(val)
                if valObj['freetrail'] ==1:
                    freeTrail = True
                else:
                    freeTrail = False
            return JsonResponse({"success": True,"message":"User Program Already Exists","freeTrail":freeTrail,"count":userplansCount})
        else:
            return JsonResponse({"success": False, "message": "No Program","count":userplansCount})
    except Exception as e:
        logger.error("error")
        return JsonResponse({"msg": str(e)})


@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def ionicupdatestartdate(request):
    stratsessionutil = StartFitSessionUtil()
    user = stratsessionutil.get_user_insession(request)
    userid = user['id']
    planInfo = json.loads(request.body.decode('utf-8'))
    print(planInfo)
    try:
        if user != None:
            startdate = datetime.strptime(planInfo['startdate'], "%Y-%m-%d %H:%M:%S")
            print(startdate)
            one_months = startdate + relativedelta(days=+28)
            nextRenewalDate = one_months.strftime("%Y-%m-%d")
            plan = UserPlan.objects.values('id','startDate','plan_id','nextRenewalDate','seasonDate','dayOff','microcyclecount').filter(user_id=userid,plan_id=planInfo['planid'])
            if plan.exists():
                for dt in plan:
                    planinf = dict(dt)
                    plan = UserPlan.objects.get(id = planinf['id'])
                    plan.startDate = startdate
                    plan.nextRenewalDate = nextRenewalDate
                    if 'dayoff' in planInfo:
                        plan.dayOff = planInfo['dayoff']
                    if 'seasonDate' in planInfo:
                        plan.seasonDate = planInfo['seasonDate']
                    if 'microcycleid' in planInfo:
                        plan.microcyclecount = planInfo['microcycleid']
                    if 'deviceDate' in planInfo and planInfo['deviceDate'] != '':
                        plan.deviceDate = planInfo['deviceDate']
                    plan.save()
            return JsonResponse({"success": True, "message": "User Program updated successfully","data": {"startDate": startdate,"nextRenewalDate": nextRenewalDate, "planId": planinf['plan_id'], "microcycleid": planinf['microcyclecount']}})
        else:
            return JsonResponse({"success": False, "message":"User logged out"})
    except Exception as e:
        logger.error("error")
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def ionicgetuserplandata(request):
    stratsessionutil = StartFitSessionUtil()
    user = stratsessionutil.get_user_insession(request)
    userid = user['id']
    #planInfo = json.loads(request.body.decode('utf-8'))
    try:
        if user != None:
            plan = UserPlan.objects.values('id','startDate','plan_id','nextRenewalDate','dayOff').filter(user_id=userid,status=1)
            planArr=[]
            for dt in plan:
                planObj =  dict(dt)
                planObj['startDate'] = planObj['startDate'].strftime("%Y-%m-%d")
                planObj['nextRenewalDate'] = planObj['nextRenewalDate'].strftime("%Y-%m-%d")
                planArr.append(planObj)
            return JsonResponse({"success": True, "plandata": planArr})
        else:
            return JsonResponse({"success": False, "message":"User logged out"})
    except Exception as e:
        logger.error("error")
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def ioniccheckstartdate(request):
    stratsessionutil = StartFitSessionUtil()
    user = stratsessionutil.get_user_insession(request)
    userid = user['id']
    try:
        if user != None:
            plan = UserPlan.objects.values('id','startDate','plan_id','status').filter(user_id=userid,status__in=[1,3])
            pArr=[]
            for dt in plan:
                pObj = dict(dt)
                if pObj['startDate'] !='' and pObj['startDate'] is not None:
                    pObj['startDate'] = pObj['startDate'].strftime("%Y-%m-%d")
                pArr.append(pObj)
            return JsonResponse({"success": True, "plandata": pArr})
        else:
            return JsonResponse({"success": False, "message":"User logged out"})
    except Exception as e:
        logger.error("error")
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def ionicUpdateRenewalDate(request):
    stratsessionutil = StartFitSessionUtil()
    user = stratsessionutil.get_user_insession(request)
    userid = user['id']
    planInfo = json.loads(request.body.decode('utf-8'))
    try:
        if user != None:
            if 'plancomplete' in planInfo and planInfo['plancomplete'] == True:
                print('inside exists')
                plancmplt = UserPlan.objects.filter(user_id=userid, plan_id=planInfo['planid'],status=1).values('id','status')
                print(plancmplt,'->>')
                if plancmplt.exists():
                    for dt in plancmplt:
                        plan1 = dict(dt)
                        uplaninfo = UserPlan.objects.get(id=plan1['id'])
                        uplaninfo.status = 2
                        if 'deviceDate' in planInfo and planInfo['deviceDate'] != '':
                            uplaninfo.deviceDate = planInfo['deviceDate']
                        uplaninfo.save()
                    todayDay = date.today().strftime("%w")
                    offDay = int(str(todayDay))-1
                    print(offDay)
                    if(offDay < 0):
                        offDay = 6
                    todayDate = date.today().strftime("%Y-%m-%d")
                    one_months = date.today() + relativedelta(days=+28)
                    nextRenewalDate = one_months.strftime("%Y-%m-%d")
                    print("here i am")
                    userplanDetails = UserPlan.objects.create(
                        user_id = userid,
                        plan_id = planInfo['planid'],
                        renewalDate = todayDate + ' 00:00:00',
                        startDate = todayDate + ' 00:00:00',
                        nextRenewalDate = nextRenewalDate + ' 00:00:00',
                        status = 1,
                        freetrail = False,
                        dayOff = offDay
                    )
                    if 'deviceDate' in planInfo and planInfo['deviceDate'] != '':
                        userplanDetails.deviceDate = planInfo['deviceDate']
                    userplanDetails.save()
                    if 'transactionId' in planInfo and planInfo['transactionId'] != None:
                        transactions = TransactionHistory.objects.filter(transation_id= planInfo['transactionId']).values()
                        for tra in transactions:
                            traobj = dict(tra)
                            traid = traobj['id']
                        updatetransactions = TransactionHistory.objects.get(pk = traid)
                        updatetransactions.userplan_id = userplanDetails.id
                        updatetransactions.save()

                    PlanDetails = UserPlan.objects.filter(user=userid).filter(status__in=[1, 3]).values()
                    plans = []
                    tmaxArr = []
                    for dt in PlanDetails:
                        planObj = dict(dt)
                        downloadUsers = UserPlan.objects.filter(plan_id=planObj['plan_id']).count()
                        userCurrency = User.objects.get(id = userid)
                        planInfos = Plan.objects.select_related('Goals__id', 'ProgramType__id', 'User__id').filter(id=planObj['plan_id']).values('id', 'planName', 'createdBy__first_name','createdBy__last_name', 'price', 'duration_weeks', 'ability','planGoal__goalName', 'planDescription','programType__programTypeName', 'planStatus','num_of_periods', 'num_of_sessions', 'goals', 'planPhoto','programType_id','createdBy_id','licencePolicy','originalPlanner_id','iosPrice','iosStatus','indianIosPrice','indianPrice','createdBy__avatar')
                        for dtp in planInfos:
                            planInfo1 = dict(dtp)
                            if planInfo1['licencePolicy'] == "3" or planInfo1['licencePolicy'] == "White-Label":
                                partnerName = User.objects.get(id=planInfo1['createdBy_id'])
                                planInfo1['planDescription'] = str(planInfo1['planDescription']) + "<br><h6>Copyright &copy; 2017 " + str(str(partnerName.first_name) + " " + str(partnerName.last_name)) + ". All rights reserved.</h6>"
                            else:
                                coachName = User.objects.get(id=planInfo1['originalPlanner_id'])
                                planInfo1['planDescription'] = str(planInfo1['planDescription']) + "<br><h6>Copyright &copy; 2017 " + str(str(coachName.first_name) + " " + str(coachName.last_name)) + ". All rights reserved.</h6>"
                            
                            planInfo1['genWarmupVideo'] = 'ztxEOSIcMc4'
                            planInfo1['cooldownVideo'] = '2esZzqjO5Cc'
                            planInfo1['planUsers'] = downloadUsers
                            if int(planInfo1['price']) == 0:
                                planInfo1['price'] = "Free"
                            else:
                                if userCurrency.currencyType == "INR":
                                    if user['userCountry'] == 88:
                                        planInfo1['price'] = (planInfo1['indianPrice'])
                                        planInfo1['planPrice'] = planInfo1['indianPrice']
                                        planInfo1['iosPrice'] = planInfo1['indianIosPrice']
                                    else:
                                        planInfo1['price'] = (planInfo1['price'])
                                        planInfo1['planPrice'] = planInfo1['price']
                                else:
                                    if user['userCountry'] == 88:
                                        planInfo1['price'] = planInfo1['indianPrice']
                                        planInfo1['planPrice'] = planInfo1['indianPrice']
                                        planInfo1['iosPrice'] = planInfo1['indianIosPrice']
                                    else:
                                        planInfo1['price'] = planInfo1['price']
                                        planInfo1['planPrice'] = planInfo1['price']
                                if float(planInfo1['price']) == 0:
                                    planInfo1['price'] = "Free"
                        planObj['info'] = planInfo1
                        exercisesObj = Plan_Actions.objects.select_related('NewExercise').filter(plan_id=planObj['plan_id']).values('exercise_id', 'exercise_id__exerciseName', 'exercise_id__exerciseDesc', 'exercise_id__equipment', 'exercise_id__video','exercise_id__thumb_image','exercise_id__cover_image').distinct()
                        planExs = []
                        for ex in exercisesObj:
                            exObj = dict(ex)
                            planExs.append(exObj)
                        planObj['exercises'] = planExs
                        plans.append(planObj)
                    tmaxDetails = UserTestPlan.objects.filter(user=userid).values('createdDate', 'exerciseId_id','exerciseId_id__exerciseName','exerciseName','exerciseId_id__exerciseDesc', 'exerciseId_id__equipment', 'exerciseId_id__video','exerciseId_id__thumb_image','exerciseId_id__cover_image', 'id', 'plan_id','tmax', 'updateTmax', 'updateType', 'updatedDate','user_id', 'userplan_id','workWeight', 'workoutTestDate')
                    if tmaxDetails.exists():
                        for dt in tmaxDetails:
                            dataTmaxObj = dict(dt)
                            tmaxArr.append(dataTmaxObj)
                    return JsonResponse({"success": True, "message": "Program renewed successfully","data": {"startDate": todayDate, "plans": plans,"renewalDate": todayDate,"nextRenewalDate": nextRenewalDate, "exercises":tmaxArr}})
            else:
                startdate = datetime.strptime(planInfo['startdate'], "%Y-%m-%d %H:%M:%S")
                one_months = startdate + relativedelta(days=+28)
                nextRenewalDate = one_months.strftime("%Y-%m-%d")
                plan = UserPlan.objects.values('id', 'startDate', 'plan_id', 'nextRenewalDate').filter(user_id=userid, plan_id=planInfo['planid'])
                if plan.exists():
                    for dt in plan:
                        planinf = dict(dt)
                        plan = UserPlan.objects.get(id=planinf['id'])
                        plan.nextRenewalDate = nextRenewalDate
                        plan.save()
                        userplanId = plan.id
                    if 'transactionId' in planInfo and planInfo['transactionId'] != None:
                        transactions = TransactionHistory.objects.filter(transation_id= planInfo['transactionId']).values()
                        for tra in transactions:
                            traobj = dict(tra)
                            traid = traobj['id']
                        updatetransactions = TransactionHistory.objects.get(pk = traid)
                        updatetransactions.userplan_id = userplanId
                        updatetransactions.save()
                return JsonResponse({"success": True, "message": "Program renewed successfully","data": {"nextRenewalDate": nextRenewalDate}})

        else:
            return JsonResponse({"success": False, "message": "User logged out"})
    except Exception as e:
        logger.error("error")
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def createUserPlan(request):
    #user = request.session['user_id']
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    planInfo = json.loads(request.body.decode('utf-8'))
    planID = planInfo['plan_id']
    req = planInfo
    url = "userprogram/createuserplan/"
    try:
        activeuser={}
        obj=[]
        activeuser['planid']=planID
        
        if username != None:
            userCurrency = User.objects.get(id=user)
            currencyValues = PriceConversion.objects.get(id=1)
            inrValue = currencyValues.inrValue
            planexist = UserPlan.objects.filter(user_id = user,plan_id = planInfo['plan_id'],status__in = [1,3]).values('id')
            if planexist.exists():
                return JsonResponse({"success":False,"message":"User Program Already Exists"})
            else:
                def activeplan(user):    
                    UserPlan.objects.filter(user_id = user, status = 3).update(status=2)
                    planActive = UserPlan.objects.filter(user_id = user,status = 1).values('id')
                    if planActive.exists():
                        statusCode = 3
                        freetrail = False
                    else:
                        statusCode = 3
                        freetrail = True
                    renewalDate = date.today().strftime("%Y-%m-%d")
                    activeuser['renewal']=renewalDate
                    d = datetime.now()
                    checkplanOffDay = UserPlan.objects.filter(user_id = user, status = 1,nextRenewalDate__gte=d).values()
                    if checkplanOffDay.exists():
                        for rd in checkplanOffDay:
                            rdObj = dict(rd)
                            offDay = rdObj['dayOff']
                        next_monday = next_weekday(d, offDay-1) # 0 = Monday, 1=Tuesday, 2=Wednesday...
                        one_months = next_monday + relativedelta(days=+28)
                        #nextMondayStr = next_monday.strftime("%Y-%m-%d")
                        nextMondayStr = date.today().strftime("%Y-%m-%d")
                        activeuser['offDay'] = offDay
                        
                        activeuser['nextMonday']=nextMondayStr
                    else:
                        offDayCalc = date.today().strftime("%w")
                        offDay = int(str(offDayCalc))-1
                        one_months = date.today() + relativedelta(days=+28)
                        nextMondayStr = date.today().strftime("%Y-%m-%d")
                        activeuser['offDay']=offDay
                        activeuser['nextMonday']=nextMondayStr
                    
                    nextRenewalDate = one_months.strftime("%Y-%m-%d")
                    activeuser['nextrenewal']=nextRenewalDate
                    userplanDetails = UserPlan.objects.create(
                            user_id=user,
                            plan_id=planInfo['plan_id'],
                            renewalDate = renewalDate + ' 00:00:00',
                            nextRenewalDate = nextRenewalDate + ' 00:00:00',
                            startDate = nextMondayStr + ' 00:00:00',
                            status = statusCode,
                            freetrail = freetrail,
                            dayOff = offDay
                    )

                    if 'deviceDate' in planInfo and planInfo['deviceDate'] != '':
                        userplanDetails.deviceDate = planInfo['deviceDate']
                    #userplanDetails.startDate = planInfo['start_date']
                    userplanDetails.save()
                    if 'transactionId' in planInfo and planInfo['transactionId'] != None:
                        transactions = TransactionHistory.objects.filter(transation_id= planInfo['transactionId']).values()
                        for tra in transactions:
                            traobj = dict(tra)
                            traid = traobj['id']
                        updatetransactions = TransactionHistory.objects.get(pk = traid)
                        updatetransactions.userplan_id = userplanDetails.id
                        updatetransactions.save()
                    platesArr = [50, 30, 20, 15, 10, 7.5, 5, 2.5, 1]
                    barbellArr = [10, 15, 20]
                    extigwts = UserPlateWeight.objects.filter(user_id=user).values()
                    if extigwts.exists():
                        print("value Already eXists")
                    else:
                        idx = -1
                        idx1 = -1
                        for wt in platesArr:
                            idx = idx + 1
                            wtinf = UserPlateWeight.objects.create(
                                user_id=user,
                                weight=wt,
                                count=4,
                                barbell=0,
                                index=idx,
                                status=1
                            )
                            wtinf.save()
                        for val in barbellArr:
                            idx1 = idx1 + 1
                            wtinf = UserPlateWeight.objects.create(
                                user_id=user,
                                weight=val,
                                count=1,
                                barbell=1,
                                index=idx1,
                                status=1
                            )
                            wtinf.save()
                    planinf = UserPlan.objects.select_related('Plan__id').filter(plan__id = planInfo['plan_id']).values('plan_id__planName')
                    for data in planinf:
                        planname = data['plan_id__planName']
                    instanceSub = User.objects.get(id=user)
                    subject = "Plan Subscription"
                    to_email = instanceSub.email
                    ctx={
                        'first_name':instanceSub.first_name,
                        'planname':planname
                    }
                    message = render_to_string('subscribeplan.html',ctx)
                    #officeMail(subject, message, to_email)
                    #print("User Plan entered")
                    activeuser['subject']=subject
                    activeuser['message']=message
                    activeuser['to_email']=to_email
                    obj.append(activeuser)
                    
                    UserPlan.objects.filter(user_id = user, status = 1).update(status=2)
                    PlanDetails = UserPlan.objects.filter(user = user).filter(status__in = [1,3]).values()
                    plans = []
                    for dt in PlanDetails:
                        planObj = dict(dt)
                        downloadUsers = UserPlan.objects.filter(plan_id=planObj['plan_id']).count()
                        planInfos = Plan.objects.select_related('Goals__id','ProgramType__id','User__id').filter(id=planObj['plan_id']).values('id', 'planName', 'createdBy__first_name', 'createdBy__last_name', 'price', 'duration_weeks', 'ability', 'planGoal__goalName', 'planDescription','programType__programTypeName','planStatus','num_of_periods','num_of_sessions','goals','planPhoto','programType_id', 'createdBy__avatar','createdBy_id','licencePolicy','originalPlanner_id','iosPrice','iosStatus','indianIosPrice','indianPrice')
                        for dtp in planInfos:
                            planInfo1 = dict(dtp)
                            if 'deviceType' in planInfo and planInfo['deviceType'] =='ios':
                                if userCurrency.currencyType == "INR":
                                    highestPrice = Plan.objects.filter(activationStatus=1 , planStatus=1).all().aggregate(Max('iosPrice'))['iosPrice__max']
                                    if username['userCountry'] == 88:
                                        planInfo1['price'] = planInfo1['indianIosPrice']
                                        planInfo1['iosPrice'] = planInfo1['indianIosPrice']
                                        planInfo1['planPrice'] = planInfo1['indianIosPrice']
                                    else:
                                        planInfo1['price'] = planInfo1['iosPrice']
                                        planInfo1['planPrice'] = planInfo1['iosPrice']
                                    if int(planInfo1['price']) == 0:
                                        planInfo1['price'] = "Free"
                                else:
                                    highestPriceVal = Plan.objects.filter(activationStatus=1 , planStatus=1).all().aggregate(Max('iosPrice'))['iosPrice__max']
                                    highestVal = PriceMapping.objects.get(inr=highestPriceVal)
                                    highestPrice = highestVal.usd
                                    if username['userCountry'] == 88:
                                        usdValue = PriceMapping.objects.values().filter(inr=planInfo1['indianIosPrice'])
                                    else:
                                        usdValue = PriceMapping.objects.values().filter(inr=planInfo1['iosPrice'])
                                    for usd in usdValue:
                                        usdObj = dict(usd)
                                        dollarVal = usdObj['usd']
                                    planInfo1['price'] = dollarVal
                                    if username['userCountry'] == 88:
                                        planInfo1['iosPrice'] = planInfo1['indianIosPrice']
                                    if int(planInfo1['price']) == 0:
                                        planInfo1['price'] = "Free"
                            else:
                                if int(planInfo1['price']) == 0:
                                    planInfo1['price'] = "Free"
                                else:
                                    if userCurrency.currencyType == "INR":
                                        if username['userCountry'] == 88:
                                            planInfo1['price'] = planInfo1['indianPrice']
                                            planInfo1['planPrice'] = planInfo1['price']
                                        else:
                                            planInfo1['price'] = planInfo1['price']
                                            planInfo1['planPrice'] = planInfo1['price']
                                    else:
                                        if username['userCountry'] == 88:
                                            planInfo1['price'] = planInfo1['indianPrice']
                                            planInfo1['planPrice'] = planInfo1['price']
                                        else:
                                            planInfo1['price'] = planInfo1['price']
                                    if float(planInfo1['price']) == 0:
                                        planInfo1['price'] = "Free"
                            planVideos=PlanVideos.objects.filter(plan_id=planInfo1['id']).values('video')
                            if planVideos.exists():
                                for dt in planVideos:
                                    videos=dict(dt)
                                    planInfo1['videos'] =dt['video'] 
                                    print("fvgdhj",dt['video'])  
                                print(planVideos,"gggggggggggggggg")
                            else:
                                planInfo1['videos']=" "    

                            planAbilityVal = SelectedAbilities.objects.select_related('PlanAbilities').filter(plan_id=planInfo1['id']).values('ability_id__ability')
                            abilities = ''
                            for val in planAbilityVal:
                                valObj = dict(val)
                                abilities += ", " + valObj['ability_id__ability']
                            if abilities != '':
                                planAbilities = abilities[1:]
                            else:
                                planAbilities = ""

                            planPurposesVal = PlanGoals.objects.select_related('PlanPurposes').filter(plan_id=planInfo1['id']).values('planGoal_id__GoalName')
                            purposes = ''
                            for val in planPurposesVal:
                                valObj = dict(val)
                                purposes += ", " + valObj['planGoal_id__GoalName']
                            if purposes != '':
                                planGoals = purposes[1:]
                            else:
                                planGoals = ""
                            planInfo1['ability'] = planAbilities
                            planInfo1['goals'] = planGoals
                            if planInfo1['licencePolicy'] == "3" or planInfo1['licencePolicy'] == "White-Label":
                                partnerName = User.objects.get(id=planInfo1['createdBy_id'])
                                planInfo1['planDescription'] = str(planInfo1['planDescription']) + "<br><h6>Copyright &copy; 2017 " + str(str(partnerName.first_name) + " " + str(partnerName.last_name)) + ". All rights reserved.</h6>"
                            else:
                                coachName = User.objects.get(id=planInfo1['originalPlanner_id'])
                                planInfo1['planDescription'] = str(planInfo1['planDescription']) + "<br><h6>Copyright &copy; 2017 " + str(str(coachName.first_name) + " " + str(coachName.last_name)) + ". All rights reserved.</h6>"
                            
                            planInfo1['genWarmupVideo'] = 'ztxEOSIcMc4'
                            planInfo1['cooldownVideo'] = '2esZzqjO5Cc'
                            planInfo1['planUsers'] = downloadUsers
                        planObj['info'] = planInfo1
                        plans.append(planObj)
                        
                        activeuser['plans']=plans
                        
                    
                    
                    return activeuser
                def mail(obj):    
                    subject=obj['subject']
                    message=obj['message']
                    to_email=obj['to_email']
                    officeMail(subject,message,to_email)
                    return activeuser
                    
               
            with concurrent.futures.ThreadPoolExecutor() as executor:
                future=executor.submit(activeplan,user)
                obj=future.result()
            t2=threading.Thread(target=mail,args=(obj,))
            t2.start()
            
            return JsonResponse({"success": True, "message": "User Program Saved Successfully" ,"data":{"startDate":activeuser['nextMonday'],"plans":activeuser['plans'],"renewalDate":activeuser['renewal'],"nextRenewalDate":activeuser['nextrenewal'],"freeTrail":False,"planId":activeuser['planid'],"dayoff":activeuser['offDay']}})

    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg": str(e)})

def next_weekday(d, weekday):
    days_ahead = weekday - d.weekday()
    if days_ahead < 0: # Target day already happened this week
        days_ahead += 8
    return d + timedelta(days=days_ahead)

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def subscriptionreminder(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    req="GET"
    url="userplan/subscriptionreminder"
    try:
        #print(user)
        if username != None:
            planobj = UserPlan.objects.filter(user_id = user,status=1).values('id','plan_id','nextRenewalDate')
            for dt in planobj:
                dataObj = dict(dt)
                plan_id = dataObj['plan_id']
                oneweek = dataObj['nextRenewalDate'] - relativedelta(days = 7)
                beforeoneweek = (oneweek. strftime("%Y-%m-%d"))
                #print(beforeoneweek)
                planinf = UserPlan.objects.select_related('Plan__id').filter(plan__id = plan_id, user_id = user, status=1).values('plan_id__planName')
                for data in planinf:
                   planname = data['plan_id__planName']
                   #print(planname)
                todaydate = date.today().strftime("%Y-%m-%d")
                #print(todaydate)
                if todaydate == beforeoneweek:
                    #print("----after if condition-----")
                    subject = "Subscription reminder"
                    to_email = username['email']
                    ctx={
                        'first_name':username['first_name'],
                        'plan_name':planname
                    }
                    message = render_to_string('subscriptionreminder.html',ctx)
                    officeMail(subject, message, to_email)
                    return JsonResponse({"success":True, "message":"Subscription reminder email sent successfully"})
            return JsonResponse({"success":True, "message":"Nothing happens"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg": str(e)})

def reminder(request):
    todaydate = datetime.today()+relativedelta(days = 7)
    planobj = UserPlan.objects.filter(nextRenewalDate = datetime.date(todaydate)).select_related('User__id','Plan__id').values('id','plan_id','nextRenewalDate','user_id__id','user_id__organization','plan_id__planName','user_id__email','user_id__first_name','user_id__userType')
    for dt in planobj:
        dataObj = dict(dt)
        plan_id = dataObj['plan_id']
        oneweek = dataObj['nextRenewalDate'] - relativedelta(days = 7)
        beforeoneweek = (oneweek.strftime("%Y-%m-%d"))
        planname = dataObj['plan_id__planName']
        #print(planname)
        todaydate = date.today().strftime("%Y-%m-%d")
        #print(todaydate)
        if dataObj['user_id__userType'] != 7:
            #print("----after if condition-----")
            subject = "Subscription reminder"
            to_email = dataObj['user_id__email']
            ctx={
                'first_name':dataObj['user_id__first_name'],
                'plan_name':planname
            }
            message = render_to_string('subscriptionreminder.html',ctx)
            officeMail(subject, message, to_email)
        else:
            organizations = set()
            userArr = []
            organizations.add(dataObj['user_id__organization'])
            orgAdminArr = []
            for org in organizations:
                userArr.append({"name":dataObj['user_id__first_name'],"email":dataObj['user_id__email']})
                orgAdminValues = User.objects.filter(organization = org['user_id__organization'],userType = 6).values('first_name','email','id')
                for orgs in orgAdminValues:
                    orgAdmin = orgs['email']
                    orgfirstname = orgs['first_name']
                    orgAdminArr.append({'email':orgAdmin,'firstName':orgfirstname})
            for orgVal in orgAdminArr:
                subject = "Subscription reminder for Gym Users"+str(userArr)
                to_email = orgVal['email']
                ctx={
                    'first_name':orgVal['first_name'],
                    'plan_name':planname
                }
                message = render_to_string('subscriptionreminder.html',ctx)
                officeMail(subject, message, to_email)
    return JsonResponse({"success":True, "message":"Subscription reminder email sent successfully"})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def renewUserPlan(request):
    #user = request.session['user_id']
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    planInfo = json.loads(request.body.decode('utf-8'))
    req =planInfo
    url = "userplan/renewuserplan/"
    try:
        if username != None:
            num_of_microcycles = 0
            plancomplete = False
            planexist = UserPlan.objects.filter(user_id = user,plan_id = planInfo['plan_id'],status=1).values()
            if planexist.exists():
                for val in planexist:
                    valObj = dict(val)
                    startDate = valObj['startDate']
                    today = datetime.now(timezone.utc)
                    diffDate = today - startDate
                    diffDays = diffDate.days
                    num_of_microcycles = abs(diffDays/7)
                microcycles  = Plan_Microcycles.objects.select_related('Plan_Mesocycle','Plan_Period').filter(mesocycle_id__period_id__plan_id = planInfo['plan_id']).values().count()
                if num_of_microcycles >= microcycles:
                    plancomplete = True
                if plancomplete == False:
                    planObj = UserPlan.objects.get(user_id = user,plan_id = planInfo['plan_id'],status=1)
                    renewalDate = date.today().strftime("%Y-%m-%d")
                    print(renewalDate)
                    one_months = date.today() + relativedelta(days=+28)
                    #nextRenewalDate = one_months.strftime("%Y-%m-%d")
                    planObj.renewalDate = renewalDate + ' 00:00:00'
                    planObj.nextRenewalDate = one_months.strftime("%Y-%m-%d") + ' 00:00:00'
                    planObj.save()
                    if 'transactionId' in planInfo and planInfo['transactionId'] != None:
                        transactions = TransactionHistory.objects.filter(transation_id= planInfo['transactionId']).values()
                        for tra in transactions:
                            traobj = dict(tra)
                            traid = traobj['id']
                        updatetransactions = TransactionHistory.objects.get(pk = traid)
                        updatetransactions.userplan_id = planObj.id
                        updatetransactions.save()
                else:
                    planObj = UserPlan.objects.get(user_id=user, plan_id=planInfo['plan_id'], status=1)
                    planObj.status = 2
                    planObj.save()
                    todayDay = date.today().strftime("%w")
                    renewalDate = date.today().strftime("%Y-%m-%d")
                    offDay = int(str(todayDay)) - 1
                    print(offDay)
                    if (offDay < 0):
                        offDay = 6
                    todayDate = date.today().strftime("%Y-%m-%d")
                    one_months = date.today() + relativedelta(days=+28)
                    nextRenewalDate = one_months.strftime("%Y-%m-%d")
                    print("here i am")
                    userplanDetails = UserPlan.objects.create(
                        user_id=user,
                        plan_id=planInfo['plan_id'],
                        renewalDate=todayDate + ' 00:00:00',
                        startDate=todayDate + ' 00:00:00',
                        nextRenewalDate=nextRenewalDate + ' 00:00:00',
                        status=1,
                        freetrail=False,
                        dayOff=offDay
                    )
                    if 'deviceDate' in planInfo and planInfo['deviceDate'] != '':
                        userplanDetails.deviceDate = planInfo['deviceDate']
                    userplanDetails.save()
                    if 'transactionId' in planInfo and planInfo['transactionId'] != None:
                        transactions = TransactionHistory.objects.filter(transation_id= planInfo['transactionId']).values()
                        for tra in transactions:
                            traobj = dict(tra)
                            traid = traobj['id']
                        updatetransactions = TransactionHistory.objects.get(pk = traid)
                        updatetransactions.userplan_id = userplanDetails.id
                        updatetransactions.save()
                PlanDetails = UserPlan.objects.filter(user = user).filter(status__in = [1,3]).values()
                plans = []
                for dt in PlanDetails:
                    planObj = dict(dt)
                    plans.append(planObj)
                return JsonResponse({"success": True, "message": "User Program renewed Successfully", "data":{"startDate":renewalDate, "plans":plans, "renewalDate":renewalDate, "nextRenewalDate":one_months, "freeTrial":False, "planId":planInfo['plan_id']}})
            else:
                return JsonResponse({"message":"Please provide Program"})
        else:
            return JsonResponse({"success":False,"message":"User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def userPlans(request):
    #user = request.session['user_id']
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    url = "userplan/userplans/"
    try:
        if username != None:
            PlanDetails = UserPlan.objects.filter(user = user).filter(status__in = [1,3]).values()
            plans = []
            for dt in PlanDetails:
                planObj = dict(dt)
                plans.append(planObj)
            return JsonResponse({"success": True, "data":{"plans":plans}})
        else:
            return JsonResponse({"success": False,"message":"User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, '', url, str(e))
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def updateDayOff(request):
    #user = request.session['user_id']
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    url = "userplan/userplans/"
    try:
        if username != None:
            PlanDetails = UserPlan.objects.filter(user = user).filter(status = 1).values('id')
            if PlanDetails.exists():
                planObj = UserPlan.objects.filter(user = user).filter(status = 1)
                offDayCalc = date.today().strftime("%w")
                offDay = int(str(offDayCalc))-1
                if offDay<0:
                    offDay = 6
                planObj.dayOff = offDay
                planObj.save()
            return JsonResponse({"success": True, "message": "Offday changed successfully","dayOff":offDay})
        else:
            return JsonResponse({"success": False,"message":"User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, '', url, str(e))
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def cancelUserPlan(request):
    #user = request.session['user_id']
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    planInfo = json.loads(request.body.decode('utf-8'))
    req = planInfo
    url = "userplan/canceluserplan/"
    try:
        if username != None:
            planexist = UserPlan.objects.filter(user_id = user,plan_id = planInfo['plan_id'],status=1).values('id')
            if planexist.exists():
                planObj = UserPlan.objects.get(user_id = user,plan_id = planInfo['plan_id'],status=1)
                renewalDate = date.today().strftime("%Y-%m-%d")
                print(renewalDate)
                one_months = date.today() + relativedelta(months=+1)
                nextRenewalDate = one_months.strftime("%Y-%m-%d")
                planObj.status = 2
                planObj.save()
                return JsonResponse({"success": True, "message": "User Program Cancelled Successfully"})
            else:
                return JsonResponse({"success":False,"message":"No Program has been Subscribed"})
        else:
            return JsonResponse({"success": False,"message":"User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def activateUserPlan(request):
    #user = request.session['user_id']
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    planInfo = json.loads(request.body.decode('utf-8'))
    req = planInfo
    url = "userplan/activateuserplan/"
    try:
        if username != None:
            planexist = UserPlan.objects.filter(user_id = user,plan_id = planInfo['plan_id'],status__in=[3]).values('id')
            if planexist.exists():
                PrePlanObj = UserPlan.objects.filter(user_id = user, status=1).values()
                print(PrePlanObj ,"zfsdfsdfs")
                if PrePlanObj.exists():
                    for pl in PrePlanObj:
                        plObj=dict(pl)
                        plId = plObj['id']
                        updateplanObj = UserPlan.objects.get(id = plId) 
                        updateplanObj.status = 2
                        updateplanObj.save()
                planObj = UserPlan.objects.get(user_id = user,plan_id = planInfo['plan_id'],status__in=[1,3])
                renewalDate = date.today().strftime("%Y-%m-%d")
                if 'firstPlan' in planInfo:
                    planObj.startDate = date.today().strftime("%Y-%m-%d")
                    renewDays = date.today() + relativedelta(days=+28)
                    renewDate = renewDays.strftime("%Y-%m-%d")
                    planObj.nextRenewalDate = renewDate 
                print(renewalDate)

                one_months = date.today() + relativedelta(months=+1)
                nextRenewalDate = one_months.strftime("%Y-%m-%d")
                if 'offDay' in planInfo and 'offDay'!=None:
                    offDay=planInfo['offDay']
                else:    
                    offDayCalc = date.today().strftime("%w")
                    offDay = int(str(offDayCalc))-1
                    if offDay<0:
                        offDay = 6
                planObj.dayOff = offDay
                planObj.status = 1
                if 'deviceDate' in planInfo and planInfo['deviceDate'] != '':
                    planObj.deviceDate = planInfo['deviceDate']
                planObj.save()
                return JsonResponse({"success": True, "message": "User Program Activated Successfully","startDate":renewalDate,"nextRenewalDate":renewDate,"dayOff":offDay})
            else:
                planVal = UserPlan.objects.filter(user_id = user,plan_id = planInfo['plan_id'],status =1).values()
                if planVal.exists():
                    for val in planVal:
                        valObj = dict(val)
                        userplanId = valObj['id']
                    planObj = UserPlan.objects.get(user_id=user, plan_id=planInfo['plan_id'], status__in=[1, 3])
                    renewalDate = date.today().strftime("%Y-%m-%d")
                    if 'firstPlan' in planInfo:
                        planObj.startDate = date.today().strftime("%Y-%m-%d")
                        renewDays = date.today() + relativedelta(days=+28)
                        renewDate = renewDays.strftime("%Y-%m-%d")
                        planObj.nextRenewalDate = renewDate
                    else:
                        renewDate = planObj.nextRenewalDate
                    print(renewalDate)
                    one_months = date.today() + relativedelta(months=+1)
                    nextRenewalDate = one_months.strftime("%Y-%m-%d")
                    if 'offDay' in planInfo and planInfo['offDay']!=None:
                        offDay=planInfo['offDay']
                    else:
                        offDayCalc = date.today().strftime("%w")
                        offDay = int(str(offDayCalc))-1
                        if offDay<0:
                            offDay = 6
                            
                    planObj.dayOff = offDay
                    planObj.status = 1
                    if 'deviceDate' in planInfo and planInfo['deviceDate'] != '':
                        planObj.deviceDate = planInfo['deviceDate']
                    planObj.save()
                    userplanVal = UserPlan.objects.get(id = userplanId)
                    return JsonResponse({"success": True, "message": "User Program Already Activated","startDate":renewalDate,"nextRenewalDate":renewDate,"dayOff":offDay})
                else:
                    return JsonResponse({"success": True, "message": "No Active Plan"})
        else:
            return JsonResponse({"success": False, "message":"User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def UserPlanSeasonDate(request):
    #user = request.session['user_id']
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    planInfo = json.loads(request.body.decode('utf-8'))
    req = planInfo
    url = "userplan/userplanseasondate/"
    try:
        if username != None:
            planexist = UserPlan.objects.filter(user_id = user,plan_id = planInfo['plan_id'],status=1).values('id')
            if planexist.exists():
                planObj = UserPlan.objects.get(user_id = user,plan_id = planInfo['plan_id'],status=1)
                if 'season_date' in planInfo:
                    if planInfo['season_date'] != '':
                        planObj.seasonDate = planInfo['season_date'] + ' 00:00:00'
                planObj.microcyclecount = planInfo['microcyclecount']
                planObj.save()
                return JsonResponse({"success": True, "message": "Season Date Set Successfully", "seasonMicroCycleID":9})
        else:
            return JsonResponse({"success": False, "message":"User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def createUserTest(request):
    #user = request.session['user_id']
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    testInfo = json.loads(request.body.decode('utf-8'))
    req = testInfo
    url = "userplan/createtest/"
    try:
        if username != None:
            if "exercise_id" in testInfo:
                exId = testInfo['exercise_id']
            else:
                exerciseDetails = NewExercise.objects.values('exerciseName','id','exerciseCode')
                for val in exerciseDetails:
                    obj = dict(val)
                    print(obj)
                    if testInfo['exerciseName'] == obj['exerciseName'] or testInfo['exerciseName'] == obj['exerciseCode']:
                        exId = obj['id']
            userplanpage = UserPlan.objects.filter(user_id=user, status=1).values('plan_id','id')
            today = datetime.now().date().strftime("%Y-%m-%d")
            for dt in userplanpage:
                dataObj = dict(dt)
                #print(dataObj)
            userTestPlanDetails = UserTestPlan.objects.create(
                user_id=user,
                plan_id =dataObj['plan_id'],
                userplan_id=dataObj['id'],
                exerciseName=testInfo['exerciseName'],
                workWeight=testInfo['workWeight'],
                updateTmax=testInfo['workWeight'],
                workoutTestDate=today,
                exerciseId_id = exId
            )
            userTestPlanDetails.save()
            return JsonResponse({"success": True, "message": "User Test Program Saved Successfully"})
        else:
            return JsonResponse({"success": False, "message":"User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def createUserTestNew(request):
    #user = request.session['user_id']
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    testInfos = json.loads(request.body.decode('utf-8'))
    req=testInfos
    url="userplan/createtestnew"
    try:
        print(testInfos['tmaxDetails'])
        if username != None:
            for testInfo in testInfos['tmaxDetails']:
                if "exercise_id" in testInfo:
                    exId = testInfo['exercise_id']
                else:
                    exerciseDetails = NewExercise.objects.values('exerciseName','id','exerciseCode')
                    for val in exerciseDetails:
                        obj = dict(val)
                        print(obj)
                        if testInfo['exerciseName'] == obj['exerciseName'] or testInfo['exerciseName'] == obj['exerciseCode']:
                            exId = obj['id']
                userplanpage = UserPlan.objects.filter(user_id=user, status=1).values('plan_id','id')
                today = datetime.now().date().strftime("%Y-%m-%d")
                print(today)
                for dt in userplanpage:
                    dataObj = dict(dt)
                    #print(dataObj)
                tmaxExist = UserTestPlan.objects.filter(exerciseId_id = exId, user_id = user).values()
                if tmaxExist.exists():
                    tmaxObj = UserTestPlan.objects.get(user_id = user, exerciseId_id = exId)
                    tmaxObj.plan_id = dataObj['plan_id']
                    tmaxObj.userplan_id = dataObj['id']
                    tmaxObj.exerciseName = testInfo['exerciseName']
                    tmaxObj.workWeight = testInfo['workWeight']
                    tmaxObj.updateTmax = testInfo['workWeight']
                    tmaxObj.workoutTestDate = timezone.now()
                    tmaxObj.save()
                else:
                    userTestPlanDetails = UserTestPlan.objects.create(
                        user_id=user,
                        plan_id =dataObj['plan_id'],
                        userplan_id=dataObj['id'],
                        exerciseName=testInfo['exerciseName'],
                        workWeight=testInfo['workWeight'],
                        updateTmax=testInfo['workWeight'],
                        workoutTestDate=timezone.now(),
                        exerciseId_id = exId
                    )
                    userTestPlanDetails.save()
            return JsonResponse({"success": True, "message": "User Test Program Saved Successfully"})
        else:
            return JsonResponse({"success": True, "meaasge": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg": str(e)})


@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def userTestExercise(request):
    #user = request.session['user_id']
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    req = "GET"
    url = "userplan/userTestExercise/"
    try:
        if username != None:
            userplanpage = UserPlan.objects.filter(user_id=user,status=1).values('plan_id','id')
            for dt in userplanpage:
                dataObj = dict(dt)
            planID = dataObj['plan_id']
            userTestPlanDetails = UserTestPlan.objects.filter(user_id=user).values('id','exerciseName', 'exerciseId_id','workWeight','updateTmax')
            dataArr = []
            count = len(userTestPlanDetails)
            for dt in userTestPlanDetails:
                dataObj = dict(dt)
                dataObj['tmaxValue'] = dataObj['workWeight']
                dataArr.append(dataObj)
            exArr = []
            planObj = Plan.objects.get(id=planID)
            exercises = PlanExcercise.objects.select_related('Exercise__id','PlanSession','Microcycle','PlanMesocycle','PlanPeriods','Plan').filter(session_id__microcycle_id__mesocycle_id__period_id__plan= planObj.id).values('exerciseName__id','exerciseName__exerciseName').order_by('exerciseName__id').order_by('id')[:2]
            for ex in exercises:
                exObj = dict(ex)
                if exObj['exerciseName__id'] == 1:
                    exArr.append(exObj)
                elif exObj['exerciseName__id']==2:
                    exArr.append(exObj)
                #print(exArr,"exercises")
            mainEx = NewExercise.objects.select_related('Videos__id').filter(id__in=[1,2]).values('exerciseName', 'exerciseDesc', 'equipment', 'video_id', 'video__videoLink')
            mainExArr = []
            for mex in mainEx:
                mexObj = dict(mex)
                mainExArr.append(mexObj)
            return JsonResponse({"success": True, "programType":planObj.programType_id, "count": count,"isTmaxSet":True,"tmaxDetails":dataArr,"exArr":exArr,"mainExArr":mainExArr})
        else:
            return JsonResponse({"success": False,"message":"User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg": str(e)})


@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def checktoTestPlan(request):
    #user = request.session['user_id']
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    req = "GET"
    url = "userplan/userTestExercise/"
    try:
        username = stratsessionutil.get_user_insession(request)
        # planInfo = json.loads(request.body.decode('utf-8'))
        user = username['id']
        if username != None:
            userplanId = UserPlan.objects.filter(user_id=user).values('createdDate', 'plan_id','id')
            if userplanId.exists():
                for va1 in userplanId:
                    obj = dict(va1)
                    print(obj)
                plancyclecompleted = UserPlanCycle.objects.filter(user_id = user,BP_missed=True,SQAT_missed=True,OP_missed=True,DL_missed =True,userplan_id =obj['id']).values('BP_missed','SQAT_missed','OP_missed','DL_missed')
                print(plancyclecompleted,"here")
                if plancyclecompleted.exists():
                    completeuserplan = UserPlan.objects.filter(user_id=user).values('id')
                    for up in completeuserplan:
                        updetails = dict(up)
                        upId = updetails['id']
                        updateuserplan = UserPlan.objects.get(id=upId)
                        updateuserplan.status = 2
                        print("in here in updating the userplan")
                        updateuserplan.save()
                    print("here In the Completion Of Excersice")
                    return JsonResponse({"success":False,"message":"Your Starter Program Got Completed","CompletedStatus":True})
                else:
                    userplanpage = UserPlan.objects.filter(user_id=user)
                    today = datetime.now().date().strftime("%Y-%m-%d")
                    time_threshold = date.today()
                    if userplanpage.exists():
                        userplanpage = userplanpage.values('createdDate', 'plan_id','id')
                        for dt in userplanpage:
                            dataObj = dict(dt)
                            print(dataObj)
                            dataObj['createdDate'] = dataObj['createdDate'].strftime("%Y-%m-%d")
                        print(dataObj['createdDate'])
                        if today >= dataObj['createdDate']:
                            usertestpage = UserTestPlan.objects.filter(user_id=user, plan_id=dataObj['plan_id'],userplan_id =dataObj['id']).values('createdDate')
                            if usertestpage.exists():
                                if len(usertestpage) >= 2:
                                    for dt in usertestpage:
                                        TestPObj = dict(dt)
                                        TestPObj['testDate'] = TestPObj['createdDate'].strftime("%Y-%m-%d")
                                        d1 = datetime.strptime(today, "%Y-%m-%d")
                                        d2 = datetime.strptime(TestPObj['testDate'], "%Y-%m-%d")
                                        d4 = d1 + timedelta(days=2)
                                        difDays = abs((d2 - d1).days)
                                    #if difDays > 2:
                                    userexcersisepage = UserExercise.objects.filter(user_id=user, plan_id=dataObj['plan_id'],userplan_id =dataObj['id'],createdDate__lt = today + ' 00:00:00')
                                    if userexcersisepage.exists():
                                        sessDetails = UserSession.objects.filter(user_id=user,plan_id=dataObj['plan_id'],userplan_id =dataObj['id']).values('createdDate')
                                        for ses in sessDetails:
                                            sessVal = dict(ses)
                                        sessVal['testDate'] = sessVal['createdDate'].strftime("%Y-%m-%d")
                                        sessd1 = datetime.strptime(today, "%Y-%m-%d")
                                        sessd2 = datetime.strptime(sessVal['testDate'], "%Y-%m-%d")
                                        sessd3 = sessd2 + timedelta(days=2)
                                        sessdifDays = abs((sessd2 - sessd1).days)
                                        if sessdifDays>=2 or sessdifDays ==0:
                                            sessionInfo = UserExercise.objects.filter(user_id = user,plan_id=dataObj['plan_id'],userplan_id =dataObj['id'],createdDate__lt=time_threshold-timedelta(days=1)).aggregate(Max('userSession'))
                                            print(sessionInfo['userSession__max'],"0987654321")
                                            #print(sessionInfo['createdDate__max'],"12345678")
                                            planId = dataObj['plan_id']
                                            userpId = dataObj['id']
                                            userexcersises = UserExercise.objects.filter(user_id=user,plan_id=planId,userplan_id =userpId,createdDate__lt=time_threshold-timedelta(days=1),userSession = sessionInfo['userSession__max']).values('exerciseName','totalReps', 'totalSets', 'nextExerciseName', 'missed', 'exerciseDate','plan', 'user', 'exerciseWorkWeight','createdDate','recovered','progressed').order_by('createdDate')
                                            print(userexcersises,"PREVIOUS EXERCISES")
                                            #testArr = []
                                            mainArr = []
                                            for dt in userexcersises:
                                                dataObj = dict(dt)
                                                #TestPObj = dict(dt)
                                                dataObj['testDate'] = dataObj['createdDate'].strftime("%Y-%m-%d")
                                                d1 = datetime.strptime(today, "%Y-%m-%d")
                                                d2 = datetime.strptime(dataObj['testDate'], "%Y-%m-%d")
                                                d3 = d2 + timedelta(days=2)
                                                print(dataObj['exerciseName'])
                                                nextCheck = True
                                                nextScheck = True
                                                cycleDetails = UserPlanCycle.objects.filter(user_id=user,plan_id=planId,userplan_id =userpId).values('BP_progressed','SQAT_progressed','OP_progressed','DL_progressed','OP_missed','DL_missed','updatedDate')
                                                if cycleDetails.exists():
                                                    for val in cycleDetails:
                                                        value = dict(val)
                                                    cycvalue = value['updatedDate'].strftime("%Y-%m-%d")
                                                    today = datetime.now().date().strftime("%Y-%m-%d")
                                                    todayDone = UserExercise.objects.filter(user_id=user,plan_id=planId,userplan_id =userpId,exerciseName = dataObj['exerciseName'], createdDate__gt = today + ' 00:00:00',totalSets = 3).values()
                                                    if todayDone.exists():
                                                        print(dataObj['exerciseName'] + ' Exists')
                                                    else:
                                                        if dataObj['exerciseName'] == "BENCH PRESS" and value['BP_progressed'] == True:
                                                            print("in Here1")
                                                            dataObj['exerciseName'] = str("OLYMPIC PRESS")
                                                            excersiceworkweight2 = UserExercise.objects.filter(user_id=user,plan_id=planId,userplan_id =userpId,exerciseName=dataObj['exerciseName']).values('exerciseName','totalReps', 'totalSets', 'nextExerciseName', 'missed', 'exerciseDate','plan', 'user', 'exerciseWorkWeight','createdDate','recovered','progressed').order_by('-id')[:1]
                                                            if excersiceworkweight2.exists():
                                                                for ww2 in excersiceworkweight2:
                                                                    workW2 = dict(ww2)
                                                                dataObj['exerciseWorkWeight'] = workW2['exerciseWorkWeight']
                                                                dataObj['missed'] = workW2['missed']
                                                                dataObj['totalReps'] = workW2['totalReps']
                                                                dataObj['totalSets'] = workW2['totalSets']
                                                                dataObj['recovered'] = workW2['recovered']
                                                                dataObj['progressed'] = workW2['progressed']
                                                            nextCheck = False
                                                        if dataObj['exerciseName'] == "OLYMPIC PRESS" and nextCheck != False:
                                                            print("in Here2")
                                                            dataObj['exerciseName'] = str("BENCH PRESS")
                                                            excersiceworkweight = UserExercise.objects.filter(user_id=user,plan_id=planId,userplan_id =userpId,exerciseName=dataObj['exerciseName']).values('exerciseName','totalReps', 'totalSets', 'nextExerciseName', 'missed', 'exerciseDate','plan', 'user', 'exerciseWorkWeight','createdDate','recovered','progressed').order_by('-id')[:1]
                                                            for ww in excersiceworkweight:
                                                                workW = dict(ww)
                                                            dataObj['exerciseWorkWeight'] = workW['exerciseWorkWeight']
                                                            dataObj['missed'] = workW['missed']
                                                            dataObj['totalReps'] = workW['totalReps']
                                                            dataObj['totalSets'] = workW['totalSets']
                                                            dataObj['recovered'] = workW['recovered']
                                                            dataObj['progressed'] = workW['progressed']
                                                        if dataObj['exerciseName'] == "SQUAT" and value['SQAT_progressed'] == True:
                                                            print("IN HEre3")
                                                            dataObj['exerciseName'] = str("DEAD LIFT")
                                                            excersiceworkweight4 = UserExercise.objects.filter(user_id=user,plan_id=planId,userplan_id =userpId,exerciseName=dataObj['exerciseName']).values('exerciseName','totalReps', 'totalSets', 'nextExerciseName', 'missed', 'exerciseDate','plan', 'user', 'exerciseWorkWeight','createdDate','recovered','progressed').order_by('-id')[:1]
                                                            if excersiceworkweight4.exists():
                                                                for ww4 in excersiceworkweight4:
                                                                    workW4 = dict(ww4)
                                                                dataObj['exerciseWorkWeight'] = workW4['exerciseWorkWeight']
                                                                dataObj['missed'] = workW4['missed']
                                                                dataObj['totalReps'] = workW4['totalReps']
                                                                dataObj['totalSets'] = workW4['totalSets']
                                                                dataObj['recovered'] = workW4['recovered']
                                                                dataObj['progressed'] = workW4['progressed']
                                                            nextScheck = False
                                                        if dataObj['exerciseName'] == "DEAD LIFT" and nextScheck != False:
                                                            print("IN HEre4")
                                                            dataObj['exerciseName'] = str("SQUAT")
                                                            excersiceworkweight1 = UserExercise.objects.filter(user_id=user,plan_id=planId,userplan_id =userpId,exerciseName=dataObj['exerciseName']).values('exerciseName','totalReps', 'totalSets', 'nextExerciseName', 'missed', 'exerciseDate','plan', 'user', 'exerciseWorkWeight','createdDate','recovered','progressed').order_by('-id')[:1]
                                                            for ww1 in excersiceworkweight1:
                                                                workW1 = dict(ww1)
                                                            dataObj['exerciseWorkWeight'] = workW1['exerciseWorkWeight']
                                                            dataObj['missed'] = workW1['missed']
                                                            dataObj['totalReps'] = workW1['totalReps']
                                                            dataObj['totalSets'] = workW1['totalSets']
                                                            dataObj['recovered'] = workW1['recovered']
                                                            dataObj['progressed'] = workW1['progressed']
                                                print(dataObj['exerciseName'])
                                                difDays = abs((d2 - d1).days)
                                                print(difDays,"difference")
                                                if difDays >=2:
                                                    if dataObj['missed'] == True or dataObj['totalReps'] < 15 or dataObj['totalSets'] < 3:
                                                        if dataObj['totalReps'] >=9 and dataObj['totalReps'] <15:
                                                            #testExcersice = "OP"
                                                            #testArr.append({"name": testExcersice})
                                                            name = dataObj['exerciseName']
                                                            workweight = int(dataObj['exerciseWorkWeight'])
                                                            set = 3
                                                            reps = 15
                                                            repsPerSet = 5
                                                            exTypeDetails = ExerciseType.objects.values('exerciseTypeName','exerciseTypeCode','excercisetypevideos','exerciseTypeDesc','equipment')
                                                            #dataArr = []
                                                            print(dataObj)
                                                            for dt in exTypeDetails:
                                                                dataObj1 = dict(dt)
                                                                if dataObj['exerciseName'] == dataObj1['exerciseTypeName']:
                                                                    mainArr.append({"name": name, "workWeight": workweight, "sets": set, "reps": reps,"reps_sets": repsPerSet,"exCode": dataObj1['exerciseTypeCode'], "exVideo": dataObj1['excercisetypevideos'], "exDesc": dataObj1['exerciseTypeDesc'],"exEquip": dataObj1['equipment']})
                                                                    print("JUST MISSED CASE")
                                                        elif dataObj['totalReps'] < 9 and dataObj['totalSets']==3:
                                                            #testExcersice = "OP"
                                                            #testArr.append({"name": testExcersice})
                                                            #dataObj = dict(dt)
                                                            name = dataObj['exerciseName']
                                                            workweight = int(dataObj['exerciseWorkWeight']) -5
                                                            set = 3
                                                            reps = 15
                                                            repsPerSet = 5
                                                            exTypeDetails = ExerciseType.objects.values('exerciseTypeName','exerciseTypeCode','excercisetypevideos','exerciseTypeDesc','equipment')
                                                            #dataArr = []
                                                            for dt in exTypeDetails:
                                                                dataObj1 = dict(dt)
                                                                if dataObj['exerciseName'] == dataObj1['exerciseTypeName']:
                                                                    mainArr.append({"name": name, "workWeight": workweight, "sets": set, "reps": reps,"reps_sets": repsPerSet,"exCode": dataObj1['exerciseTypeCode'], "exVideo": dataObj1['excercisetypevideos'], "exDesc": dataObj1['exerciseTypeDesc'],"exEquip": dataObj1['equipment']})
                                                            #mainArr.append({"name": name, "workWeight": workweight, "sets": set, "reps": reps, "reps_sets": repsPerSet})
                                                            print("BADLY MISSED CASE")
                                                        elif dataObj['totalReps'] < 9 and dataObj['totalSets']<3:
                                                            #testExcersice = "OP"
                                                            #testArr.append({"name": testExcersice})
                                                            #dataObj = dict(dt)
                                                            name = dataObj['exerciseName']
                                                            workweight = int(dataObj['exerciseWorkWeight'])
                                                            set = 3
                                                            reps = 15
                                                            repsPerSet = 5
                                                            exTypeDetails = ExerciseType.objects.values('exerciseTypeName','exerciseTypeCode','excercisetypevideos','exerciseTypeDesc','equipment')
                                                            #dataArr = []
                                                            for dt in exTypeDetails:
                                                                dataObj1 = dict(dt)
                                                                if dataObj['exerciseName'] == dataObj1['exerciseTypeName']:
                                                                    mainArr.append({"name": name, "workWeight": workweight, "sets": set, "reps": reps,"reps_sets": repsPerSet,"exCode": dataObj1['exerciseTypeCode'], "exVideo": dataObj1['excercisetypevideos'], "exDesc": dataObj1['exerciseTypeDesc'],"exEquip": dataObj1['equipment']})
                                                        elif dataObj['missed'] == True and dataObj['recovered'] == True and dataObj['progressed'] == True:
                                                            print("Check where I am")
                                                            if dataObj['nextExerciseName'] == "OLYMPIC PRESS":
                                                                name = dataObj['nextExerciseName']
                                                                workweight = round(int(dataObj['exerciseWorkWeight']) * 0.64)
                                                            elif dataObj['nextExerciseName'] == "DEAD LIFT":
                                                                name = dataObj['nextExerciseName']
                                                                workweight = round(int(dataObj['exerciseWorkWeight']) * 1.1)
                                                            else:
                                                                name = dataObj['exerciseName']
                                                                workweight = int(dataObj['exerciseWorkWeight']) + 5
                                                            set = 3
                                                            reps = 15
                                                            repsPerSet = 5
                                                            exTypeDetails = ExerciseType.objects.values('exerciseTypeName','exerciseTypeCode','excercisetypevideos','exerciseTypeDesc','equipment')
                                                            #dataArr = []
                                                            for dt in exTypeDetails:
                                                                dataObj1 = dict(dt)
                                                                if dataObj['exerciseName'] == dataObj1['exerciseTypeName']:
                                                                    mainArr.append({"name": name, "workWeight": workweight, "sets": set, "reps": reps,"reps_sets": repsPerSet,"exCode": dataObj1['exerciseTypeCode'], "exVideo": dataObj1['excercisetypevideos'], "exDesc": dataObj1['exerciseTypeDesc'],"exEquip": dataObj1['equipment']})

                                                        elif dataObj['missed'] == True and dataObj['totalReps'] == 15:
                                                            print(dataObj['missed'],"IN here TO test")
                                                            name = dataObj['exerciseName']
                                                            workweight = int(dataObj['exerciseWorkWeight']) + 5
                                                            set = 3
                                                            reps = 15
                                                            repsPerSet = 5
                                                            exTypeDetails = ExerciseType.objects.values('exerciseTypeName','exerciseTypeCode','excercisetypevideos','exerciseTypeDesc','equipment')
                                                            #dataArr = []
                                                            for dt in exTypeDetails:
                                                                dataObj1 = dict(dt)
                                                                if dataObj['exerciseName'] == dataObj1['exerciseTypeName']:
                                                                    mainArr.append({"name": name, "workWeight": workweight, "sets": set, "reps": reps,"reps_sets": repsPerSet,"exCode": dataObj1['exerciseTypeCode'], "exVideo": dataObj1['excercisetypevideos'], "exDesc": dataObj1['exerciseTypeDesc'],"exEquip": dataObj1['equipment']})
                                                    elif dataObj['totalSets'] <3:
                                                        name = dataObj['exerciseName']
                                                        workweight = int(dataObj['exerciseWorkWeight'])
                                                        set = 3
                                                        reps = 15
                                                        repsPerSet = 5
                                                        exTypeDetails = ExerciseType.objects.values('exerciseTypeName','exerciseTypeCode','excercisetypevideos','exerciseTypeDesc','equipment')
                                                        #dataArr = []
                                                        for dt in exTypeDetails:
                                                            dataObj1 = dict(dt)
                                                            if dataObj['exerciseName'] == dataObj1['exerciseTypeName']:
                                                                mainArr.append({"name": name, "workWeight": workweight, "sets": set, "reps": reps,"reps_sets": repsPerSet,"exCode": dataObj1['exerciseTypeCode'], "exVideo": dataObj1['excercisetypevideos'], "exDesc": dataObj1['exerciseTypeDesc'],"exEquip": dataObj1['equipment']})
                                                    else:
                                                        name = dataObj['exerciseName']
                                                        workweight = int(dataObj['exerciseWorkWeight']) + 5
                                                        set = 3
                                                        reps = 15
                                                        repsPerSet = 5
                                                        exTypeDetails = ExerciseType.objects.values('exerciseTypeName','exerciseTypeCode','excercisetypevideos','exerciseTypeDesc','equipment')
                                                        #dataArr = []
                                                        for dt in exTypeDetails:
                                                            dataObj1 = dict(dt)
                                                            if dataObj['exerciseName'] == dataObj1['exerciseTypeName']:
                                                                mainArr.append({"name": name, "workWeight": workweight, "sets": set, "reps": reps,"reps_sets": repsPerSet,"exCode": dataObj1['exerciseTypeCode'], "exVideo": dataObj1['excercisetypevideos'], "exDesc": dataObj1['exerciseTypeDesc'],"exEquip": dataObj1['equipment']})
                                                #mainArr.append({"name": name, "workWeight": workweight, "sets": set, "reps": reps,"reps_sets": repsPerSet})
                                                #return JsonResponse({"success": True, "meaasge": "User ExcersiseDetails", "status": 4, "main": mainArr})
                                                else:
                                                    if abs((d2 - d1).days) ==0:
                                                        message ="Your session is over. <br/> Next workout will start on "+str(d3.strftime("%Y-%m-%d"))
                                                    else:
                                                        message = "Break day. <br/> Your next workout will start on "+str(d3.strftime("%Y-%m-%d"))
                                                    return JsonResponse({"success": True, "message": message, "status": 2,"mainArr":mainArr})
                                            # excersicArr = []
                                            # workout = {"workout":[{"exercisename":"BP", "workweight":100},{"exercisename":"Squat", "workweight":100}]}
                                            # excersicArr.append(workout)
                                            todayDate = datetime.now().date()
                                            todaySessionObj = UserSession.objects.filter(createdDate__gte = todayDate)
                                            completedArr = {}
                                            print(todaySessionObj)
                                            if todaySessionObj.exists():
                                                todaysexersises = UserExercise.objects.filter(user_id=user,plan_id=obj['plan_id'],userplan_id = obj['id'],createdDate__gte = todayDate).values('exerciseName','totalReps', 'totalSets', 'nextExerciseName', 'missed', 'exerciseDate','plan', 'user', 'exerciseWorkWeight','createdDate','recovered','progressed').order_by('createdDate')
                                                print(todaysexersises,"TODAYS EXERCISES")
                                                for ux in todaysexersises:
                                                    uxe = dict(ux)
                                                    if uxe['totalSets'] <3 or len(todaysexersises)<=2:
                                                        print(uxe['exerciseName'])
                                                        if uxe['exerciseName'] == 'BENCH PRESS':
                                                            completedExName = uxe['exerciseName'] = "bp"
                                                        elif uxe['exerciseName'] == 'SQUAT':
                                                            completedExName = uxe['exerciseName'] = "sq"
                                                        elif uxe['exerciseName'] == 'OLYMPIC PRESS':
                                                            completedExName = uxe['exerciseName'] = "op"
                                                        elif uxe['exerciseName'] == 'DEAD LIFT':
                                                            completedExName = uxe['exerciseName'] = "dl"
                                                        completedSets = uxe['totalSets']
                                                        completedReps = uxe['totalReps']
                                                        completeJson =json.dumps({"completedSets": completedSets,"completedReps":completedReps})
                                                        completedArr[completedExName] = json.loads(completeJson)
                                                    else:
                                                        mainArr =[]
                                            return JsonResponse({"success": True, "message":"Your next workout will start on "+str(sessd3.strftime("%Y-%m-%d")), "status": 4, "main": mainArr,"completedJson":completedArr})
                                        else:
                                            if abs((sessd2 - sessd1).days) ==0:
                                                message ="Your session is over. <br/> Next workout will start on "+str(sessd3.strftime("%Y-%m-%d"))
                                            else:
                                                message = "Break day. <br/> Your next workout will start on "+str(sessd3.strftime("%Y-%m-%d"))
                                            return JsonResponse({"success": True, "message": message, "status": 2})
                                    else:
                                        session1 = UserTestPlan.objects.values("exerciseName", "workWeight").filter(user_id=user)
                                        mainArr = []
                                        for dt in session1:
                                            dataObj1 = dict(dt)
                                            name = dataObj1['exerciseName']
                                            workweight = int(dataObj1['workWeight']) + 5
                                            set = 3
                                            reps = 15
                                            repsPerSet = 5

                                            exTypeDetails = ExerciseType.objects.values('exerciseTypeName','exerciseTypeCode','excercisetypevideos','exerciseTypeDesc','equipment')
                                            #dataArr = []
                                            for dt in exTypeDetails:
                                                dataObj = dict(dt)
                                                if dataObj1['exerciseName'] == dataObj['exerciseTypeName']:
                                                    mainArr.append({"name": name, "workWeight": workweight, "sets": set, "reps": reps,"reps_sets": repsPerSet,"exCode": dataObj['exerciseTypeCode'], "exVideo": dataObj['excercisetypevideos'], "exDesc": dataObj['exerciseTypeDesc'],"exEquip": dataObj['equipment']})
                                        todayDate = datetime.now().date()
                                        todaySessionObj = UserSession.objects.filter(createdDate__gte = todayDate)
                                        completedArr = {}
                                        print(todaySessionObj)
                                        if todaySessionObj.exists():
                                            todaysexersises = UserExercise.objects.filter(user_id=user,plan_id=obj['plan_id'],userplan_id = obj['id'],createdDate__gte = todayDate).values('exerciseName','totalReps', 'totalSets', 'nextExerciseName', 'missed', 'exerciseDate','plan', 'user', 'exerciseWorkWeight','createdDate','recovered','progressed').order_by('createdDate')
                                            print(todaysexersises,"TODAYS EXERCISES")
                                            for ux in todaysexersises:
                                                uxe = dict(ux)
                                                if uxe['totalSets'] <3 or len(todaysexersises)<=2:
                                                    print(uxe['exerciseName'])
                                                    if uxe['exerciseName'] == 'BENCH PRESS':
                                                        completedExName = uxe['exerciseName'] = "bp"
                                                    elif uxe['exerciseName'] == 'SQUAT':
                                                        completedExName = uxe['exerciseName'] = "sq"
                                                    elif uxe['exerciseName'] == 'OLYMPIC PRESS':
                                                        completedExName = uxe['exerciseName'] = "op"
                                                    elif uxe['exerciseName'] == 'DEAD LIFT':
                                                        completedExName = uxe['exerciseName'] = "dl"
                                                    completedSets = uxe['totalSets']
                                                    completedReps = uxe['totalReps']
                                                    completeJson =json.dumps({"completedSets": completedSets,"completedReps":completedReps})
                                                    completedArr[completedExName] = json.loads(completeJson)
                                                else:
                                                    mainArr =[]

                                        return JsonResponse({"success": True, "message": "Your next workout will start on "+str(d4.strftime("%Y-%m-%d")), "status": 4,"main": mainArr,"completedJson":completedArr})
                                    #else:
                                        #return JsonResponse({"success": True, "meaasge": "It's Your Rest Day", "status": 2})
                                else:
                                    return JsonResponse({"success": True, "message": "User Is ready for the testPlan", "status": 3})
                            else:
                                excersicArr = []
                                workout = {"workout": [{"exercisename": "BP"}, {"exercisename": "Squat"}]}
                                excersicArr.append(workout)
                                return JsonResponse({"success": True, "message": "User Is ready for the testPlan", "status": 3,
                                                     "WorkOut": excersicArr})
                        else:
                            return JsonResponse({"success": True, "message": "Please Check Excersise StartDate", "status": 2})
                    else:
                        return JsonResponse({"success": True, "message": "Please Subscribe for a Plan", "status": 1})
                        # return JsonResponse({"success": True,"message":"User Plan Saved Successfully"})
            else:
                return JsonResponse({"success": True, "message": "Please Subscribe for a Plan", "status": 1})
        else:
            return JsonResponse({"success": False, "message":"User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def createExcersiseSession(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    excersiseInfo = json.loads(request.body.decode('utf-8'))
    req = excersiseInfo
    url = "userplan/userTestExercise/"
    try:
        if username != None:
            today = datetime.now().date().strftime("%Y-%m-%d")
            userplanpage = UserPlan.objects.filter(user_id=user,status=1).values('plan_id','id')
            for dt in userplanpage:
                plan = dict(dt)
            if excersiseInfo['exercise']['currentSet'] == 1:
                exsessionInfo = UserExercise.objects.filter(user_id = user,plan_id=plan['plan_id'],userplan_id=plan['id']).aggregate(Max('userSession'),Max('createdDate'))
                if exsessionInfo['userSession__max'] != None:
                    exsessionInfo['createdDate__max'] = exsessionInfo['createdDate__max'].strftime("%Y-%m-%d")
                    d1 = datetime.strptime(today, "%Y-%m-%d")
                    d2 = datetime.strptime(exsessionInfo['createdDate__max'], "%Y-%m-%d")
                    if d1!= d2:
                        sessId = exsessionInfo['userSession__max']+1
                    else:
                        sessId = exsessionInfo['userSession__max']
                else:
                    sessId = 1
                ExersiceDetails = UserExercise.objects.create(
                    user_id=user,
                    plan_id=plan['plan_id'],
                    userplan_id=plan['id'],
                    exerciseName=excersiseInfo['exercise']['name'],
                    totalReps=excersiseInfo['exercise']['completedSetsReps'],
                    totalSets=excersiseInfo['exercise']['currentSet'],
                    exerciseWorkWeight=excersiseInfo['exercise']['workWeight'],
                    period_id = 1,
                    mesocycle_id = 1,
                    microcycle_id = 1,
                    session_id = 1,
                    userSession = sessId,
                    exerciseId_id = excersiseInfo['exercise']['exId']
                )
                ExersiceDetails.save()
                lastExId = ExersiceDetails.id
                exId = ExersiceDetails.exerciseId_id
                exName = ExersiceDetails.exerciseName
                exSet = ExersiceDetails.totalSets
                totalReps = ExersiceDetails.totalReps
            else:
                ExerciseInfo = UserExercise.objects.filter(exerciseId_id = excersiseInfo['exercise']['exId'],user_id = user,plan_id =  plan['plan_id'],userplan_id=plan['id']).values('id','totalReps','totalSets','exerciseName','exerciseId_id').last()
                lastExId = ExerciseInfo['id']
                exId = ExerciseInfo['exerciseId_id']
                exName = ExerciseInfo['exerciseName']
                exId = ExerciseInfo['exerciseId_id']
                totalReps = ExerciseInfo['totalReps'] + int(excersiseInfo['exercise']['reps_sets_done'])
                totalSets = ExerciseInfo['totalSets'] + 1
                exerciseObj = UserExercise.objects.get(id = lastExId)
                exerciseObj.totalReps = totalReps
                exerciseObj.totalSets = totalSets
                exerciseObj.save()
            SetDetails = UserSets.objects.create(
                user_id=user,
                plan_id=plan['plan_id'],
                period_id = 1,
                mesocycle_id = 1,
                microcycle_id = 1,
                session_id = 1,
                exercise_id =1,
                userexercise_id = lastExId,
                setExercise = exName,
                setNumber = excersiseInfo['exercise']['currentSet'],
                totalReps = excersiseInfo['exercise']['completedSetsReps']
            )
            SetDetails.save()
            exDetails = PlanExcercise.objects.select_related('PlanSession__id','Microcycle__id','PlanMesocycle__id','PlanPeriods__id','Plan__id').filter(session__microcycle__mesocycle__period__plan = plan['plan_id']).values('exerciseName','transitExercise').order_by('id')
            ex1 = exDetails[0]
            print(exDetails,ex1['exerciseName'],"dataBaseIds")
            exercise1 =ex1['exerciseName']
            exercise3 = ex1['transitExercise']
            ex2 = exDetails[1]
            exercise2 = ex2['exerciseName']
            exercise4 = ex2['transitExercise']
            if excersiseInfo['exercise']['currentSet'] >= 3:
                if totalReps < 15:
                    exerciseMissed = UserExercise.objects.get(id = lastExId)
                    exerciseMissed.missed = 1
                    exerciseMissed.save()
                    planCyclevalues = UserPlanCycle.objects.filter(user_id = user,plan_id =  plan['plan_id'],userplan_id=plan['id']).values('id')
                    if planCyclevalues.exists():
                        for pd in planCyclevalues:
                            plandata = dict(pd)
                            plancycleId = plandata['id']
                        planCycle = UserPlanCycle.objects.get(id = plancycleId)
                        planCycle.user_id = user
                        planCycle.plan_id = plan['plan_id']
                        planCycle.userplan_id = plan['id']
                        if exerciseMissed.exerciseId_id == exercise1:
                            planCycle.BP_missed =1
                        elif exerciseMissed.exerciseId_id == exercise2:
                            planCycle.SQAT_missed = 1
                        elif exerciseMissed.exerciseId_id == exercise3:
                            planCycle.OP_missed = 1
                        elif exerciseMissed.exerciseId_id == exercise4:
                            planCycle.DL_missed = 1
                        planCycle.save()
                    else:
                        plancycleDetails = UserPlanCycle.objects.create(
                            user_id = user,
                            plan_id = plan['plan_id'],
                            userplan_id = plan['id']
                        )
                        if exerciseMissed.exerciseId_id == exercise1:
                            plancycleDetails.BP_missed =1
                        elif exerciseMissed.exerciseId_id == exercise2:
                            plancycleDetails.SQAT_missed = 1
                        elif exerciseMissed.exerciseId_id == exercise3:
                            plancycleDetails.OP_missed = 1
                        elif exerciseMissed.exerciseId_id == exercise4:
                            plancycleDetails.DL_missed = 1
                        plancycleDetails.save()
                ExercisePreviousInfoObj = UserExercise.objects.filter(exerciseId_id = excersiseInfo['exercise']['exId'],user_id = user,plan_id =plan['plan_id'],userplan_id=plan['id']).values('id','missed','recovered','progressed','exerciseWorkWeight','exerciseName','regressed').exclude(regressed=True).order_by('-exerciseDate')
                planCyclevalues = UserPlanCycle.objects.filter(user_id = user).values('id')
                for pcdata in planCyclevalues:
                    plandata = dict(pcdata)
                    plancycleId = plandata['id']
                print("here Iam In the Previous Excersice",ExercisePreviousInfoObj)
                if ExercisePreviousInfoObj:
                    print(ExercisePreviousInfoObj[1],"here I Come")
                    ExercisePreviousInfo = ExercisePreviousInfoObj[1]
                    missedFlag = ExercisePreviousInfo['missed']
                    print(missedFlag,"missed Values")
                    recoveredFlag = ExercisePreviousInfo['recovered']
                    progressedFlag = ExercisePreviousInfo['progressed']
                    preWorkWeight = ExercisePreviousInfo['exerciseWorkWeight']
                    print(preWorkWeight,"prevWW")
                    print(totalReps,int(excersiseInfo['exercise']['workWeight']),missedFlag,"CHECKING THE CONDITIONS")
                    if totalReps == 15 and missedFlag == True and int(excersiseInfo['exercise']['workWeight']) == int(preWorkWeight):
                        print("in HERE TO RECOVER")
                        exerciseRecovered = UserExercise.objects.get(id = lastExId)
                        print(exerciseRecovered,"IN HERE")
                        exerciseRecovered.missed = 1
                        exerciseRecovered.recovered = 1
                        exerciseRecovered.save()
                        plancycleRecovery = UserPlanCycle.objects.get(id = plancycleId)
                        if exerciseRecovered.exerciseId_id == exercise1:
                            plancycleRecovery.BP_recovered =1
                        elif exerciseRecovered.exerciseId_id == exercise2:
                            plancycleRecovery.SQAT_recovered = 1
                        elif exerciseRecovered.exerciseId_id == exercise3:
                            plancycleRecovery.OP_recovered = 1
                        elif exerciseRecovered.exerciseId_id == exercise4:
                            plancycleRecovery.DL_recovered = 1
                        plancycleRecovery.save()
                    elif totalReps == 15 and missedFlag == True and int(excersiseInfo['exercise']['workWeight']) < int(preWorkWeight):
                        print("in HERE TO Update")
                        exerciseUpdate = UserExercise.objects.get(id = lastExId)
                        print(exerciseUpdate,"IN HERE")
                        exerciseUpdate.missed = 1
                        exerciseUpdate.regressed = 1
                        exerciseUpdate.save()
                    elif totalReps == 15 and missedFlag == True and recoveredFlag == True and int(excersiseInfo['exercise']['workWeight']) > int(preWorkWeight):
                        exerciseProgressed = UserExercise.objects.get(id = lastExId)
                        exerciseProgressed.progressed = 1
                        exerciseProgressed.recovered = 1
                        exerciseProgressed.missed = 1
                        cyclevalue = UserPlanCycle.objects.filter(user_id = user,plan_id = plan['plan_id'],userplan_id=plan['id']).values('BP_progressed','SQAT_progressed')
                        for cv in cyclevalue:
                            cyc = dict(cv)
                        if excersiseInfo['exercise']['exId'] == exercise1:
                            if cyc['BP_progressed'] == True:
                                exerciseProgressed.nextExerciseName_id = ''
                            else:
                                exerciseProgressed.nextExerciseName_id = exercise3
                        elif excersiseInfo['exercise']['exId'] == exercise2:
                            if cyc['SQAT_progressed'] == True:
                                exerciseProgressed.nextExerciseName_id = ''
                            else:
                                exerciseProgressed.nextExerciseName_id = exercise4
                        exerciseProgressed.save()
                        plancycleProgress = UserPlanCycle.objects.get(id = plancycleId)
                        if exerciseProgressed.exerciseId_id == exercise1:
                            plancycleProgress.BP_progressed =1
                        elif exerciseProgressed.exerciseId_id == exercise2:
                            plancycleProgress.SQAT_progressed = 1
                        elif exerciseProgressed.exerciseId_id == exercise3:
                            plancycleProgress.OP_progressed = 1
                        elif exerciseProgressed.exerciseId_id == exercise4:
                            plancycleProgress.DL_progressed = 1
                        plancycleProgress.save()
                plancyclecompleted = UserPlanCycle.objects.filter(user_id = user).values('BP_missed','SQAT_missed','OP_missed','DL_missed')
                if plancyclecompleted.exists():
                    for cyclce in plancyclecompleted:
                        cycles = dict(cyclce)
                    if cycles['BP_missed'] == True and cycles['SQAT_missed'] ==True and cycles['OP_missed'] == True and cycles['DL_missed'] == True:
                        print("here In the Completion Of Excersice")
                        return JsonResponse({"success":False,"message":"Your Starter Program Got Completed"})
            return JsonResponse({"success":True,"message":"records Inserted Sucessfully"})
        else:
            return JsonResponse({"success": False, "message": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def testForTestProgram(request):
    #user = request.session['user_id']
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    excersiseInfo = json.loads(request.body.decode('utf-8'))
    req = excersiseInfo
    url = "userplan/testforTest/"
    try:
        print(excersiseInfo['strength'])
        if username != None:
            gender = FitnessProfile.objects.get(user_id=user)
            #print(gender.gender)
            if gender.gender == 1:
                if int(excersiseInfo['strength'])==1:
                    workWeight = int(excersiseInfo['workWeight'])+20
                elif excersiseInfo['strength']==2:
                    workWeight = int(excersiseInfo['workWeight'])+10
                return JsonResponse({"success": True, "ww":workWeight})
            elif gender.gender ==2:
                if int(excersiseInfo['strength'])==1:
                    workWeight = int(excersiseInfo['workWeight'])+10
                elif excersiseInfo['strength']==2:
                    workWeight = int(excersiseInfo['workWeight'])+5
                return JsonResponse({"success": True, "ww":workWeight})
        else:
            return JsonResponse({"success": False,"message":"User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg": str(e)})


@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def completedExcerciseDetails(request):
    #user = request.session['user_id']
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    req = "GET"
    url = "userplan/exercisedetails/"
    try:
        if username !='':
            userplanpage = UserPlan.objects.filter(user_id=user).values('plan_id','id')
            for dt in userplanpage:
                plan = dict(dt)
            uservalues = UserExercise.objects.select_related('utility_exercise__id').filter(user_id = user,plan_id = plan['plan_id'],userplan_id = plan['id']).values('exerciseName','exerciseId__exerciseName','exerciseWorkWeight','totalReps','id')
            dataArr = []
            benchpressArr = []
            squatArr = []
            olympicpressArr = []
            deadliftArr = []
            for dt1 in uservalues:
                dataObj = dict(dt1)
                if dataObj['exerciseId__exerciseName'] == "BENCH PRESS":
                    orm = float(float(int(dataObj['exerciseWorkWeight'])*0.0333))+int(dataObj['exerciseWorkWeight'])
                    totalTonnage = float(float(dataObj['exerciseWorkWeight'])*int(dataObj['totalReps']))/1000
                    avgwt = float(totalTonnage*1000)/int(dataObj['totalReps'])
                    relavgwt = avgwt/orm
                    totalwork = 0.28*9.8*int(dataObj['exerciseWorkWeight'])*int(dataObj['totalReps'])
                    cal = totalwork * 0.238902957619
                    dataObj['orm'] = orm
                    dataObj['totalTonnage'] = totalTonnage
                    dataObj['avgWt'] = avgwt
                    dataObj['relavgwt'] = relavgwt
                    dataObj['totalwork'] = totalwork
                    dataObj['cal'] = cal
                    benchpressArr.append(dataObj)
                elif dataObj['exerciseId__exerciseName'] == "SQUAT":
                    orm = float(float(int(dataObj['exerciseWorkWeight'])*0.0333))+int(dataObj['exerciseWorkWeight'])
                    totalTonnage = float(float(dataObj['exerciseWorkWeight'])*int(dataObj['totalReps']))/1000
                    avgwt = float(totalTonnage*1000)/int(dataObj['totalReps'])
                    relavgwt = avgwt/orm
                    totalwork = 0.22*9.8*int(dataObj['exerciseWorkWeight'])*int(dataObj['totalReps'])
                    cal = totalwork * 0.238902957619
                    dataObj['orm'] = orm
                    dataObj['totalTonnage'] = totalTonnage
                    dataObj['avgWt'] = avgwt
                    dataObj['relavgwt'] = relavgwt
                    dataObj['totalwork'] = totalwork
                    dataObj['cal'] = cal
                    squatArr.append(dataObj)
                elif dataObj['exerciseId__exerciseName'] == "OLYMPIC PRESS":
                    orm = float(float(int(dataObj['exerciseWorkWeight'])*0.0333))+int(dataObj['exerciseWorkWeight'])
                    totalTonnage = float(float(dataObj['exerciseWorkWeight'])*int(dataObj['totalReps']))/1000
                    avgwt = float(totalTonnage*1000)/int(dataObj['totalReps'])
                    relavgwt = avgwt/orm
                    totalwork = 0.29*9.8*int(dataObj['exerciseWorkWeight'])*int(dataObj['totalReps'])
                    cal = totalwork * 0.238902957619
                    dataObj['orm'] = orm
                    dataObj['totalTonnage'] = totalTonnage
                    dataObj['avgWt'] = avgwt
                    dataObj['relavgwt'] = relavgwt
                    dataObj['totalwork'] = totalwork
                    dataObj['cal'] = cal
                    olympicpressArr.append(dataObj)
                elif dataObj['exerciseId__exerciseName'] == "DEAD LIFT":
                    orm = float(float(int(dataObj['exerciseWorkWeight'])*0.0333))+int(dataObj['exerciseWorkWeight'])
                    totalTonnage = float(float(dataObj['exerciseWorkWeight'])*int(dataObj['totalReps']))/1000
                    avgwt = float(totalTonnage*1000)/int(dataObj['totalReps'])
                    relavgwt = avgwt/orm
                    totalwork = 0.31*9.8*int(dataObj['exerciseWorkWeight'])*int(dataObj['totalReps'])
                    cal = totalwork * 0.238902957619
                    dataObj['orm'] = orm
                    dataObj['totalTonnage'] = totalTonnage
                    dataObj['avgWt'] = avgwt
                    dataObj['relavgwt'] = relavgwt
                    dataObj['totalwork'] = totalwork
                    dataObj['cal'] = cal
                    deadliftArr.append(dataObj)
                #dataArr.append(dataObj)
                else:
                    return JsonResponse({"success": True,"message":"Exercise does not found"})
            print(dataArr)
            return JsonResponse({"success":True,"bench":benchpressArr,"squat":squatArr,"olympic":olympicpressArr,"deadlift":deadliftArr})
        else:
            return JsonResponse({"success":False,"message":"User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def excersiceTypeDetails(request):
    #user = request.session['user_id']
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        if username != None:
            x= connection.cursor()
            exTypeDetails = "SELECT * FROM utility_exercise WHERE exerciseStatus = 1"
            x.execute(exTypeDetails)
            resultQuery = dictfetchall(x)
            dataArr = []
            defaultExArr = []
            skilArr = []
            for dt in resultQuery:
                dataObj = dict(dt)
                videoId = dataObj['video_id']
                videos = Videos.objects.filter(id = videoId).values()
                for val in videos:
                    valObj = dict(val)
                    if dataObj['accessLevel'] == 0:
                        dataArr.append({"exName": dataObj['exerciseName'], "exCode": dataObj['exerciseCode'], "id": dataObj['id'], "exDesc": dataObj['exerciseDesc'],"exEquip": dataObj['equipment'],"exVideos":valObj['videoLink'],"olympicLift":dataObj['olympicLift'],"preExInstructions":dataObj['preExInstructions'],"postExInstructions":dataObj['postExInstructions'],"accessLevel":dataObj['accessLevel'],"weightExists":dataObj['weightExists'],"distanceExists":dataObj['distanceExists'],"timeExists":dataObj['timeExists'],"repsExists":dataObj['repsExists'],"exAbilities":dataObj['exAbilities'],"setInstructions":dataObj['setInstructions']})
                    elif dataObj['exAbilities'] == 'Skill':
                        skilArr.append({"exName": dataObj['exerciseName'], "exCode": dataObj['exerciseCode'], "id": dataObj['id'], "exDesc": dataObj['exerciseDesc'],"exEquip": dataObj['equipment'],"exVideos":valObj['videoLink'],"olympicLift":dataObj['olympicLift'],"preExInstructions":dataObj['preExInstructions'],"postExInstructions":dataObj['postExInstructions'],"accessLevel":dataObj['accessLevel'],"weightExists":dataObj['weightExists'],"distanceExists":dataObj['distanceExists'],"timeExists":dataObj['timeExists'],"repsExists":dataObj['repsExists'],"exAbilities":dataObj['exAbilities'],"setInstructions":dataObj['setInstructions'],"skill":True})
                    else:
                        string = ''
                        dataObj['tmax']= {}
                        advExDetails = AdvExercises.objects.get(exercise_id = dataObj['id'])
                        if advExDetails:
                            if advExDetails.maxWeight == True:
                                string += ", Weight"
                            if advExDetails.maxReps == True:
                                string += ", Reps"
                            if advExDetails.maxTime == True:
                                string += ", Time"
                            if advExDetails.maxDistance == True:
                                string += ", Distance"
                            if advExDetails.maxSpeed == True:
                                string += ", Speed"
                            if advExDetails.maxHeight == True:
                                string += ", Height"
                            string = string[2:]
                            dataObj['tmax'] = {"weight":advExDetails.maxWeight,"reps":advExDetails.maxReps,"time":advExDetails.maxTime,"distance":advExDetails.maxDistance,"speed":advExDetails.maxSpeed,"height":advExDetails.maxHeight}
                        defaultExArr.append({"exName": dataObj['exerciseName'], "exCode": dataObj['exerciseCode'], "id": dataObj['id'], "exDesc": dataObj['exerciseDesc'],"exEquip": dataObj['equipment'],"exVideos":valObj['videoLink'],"olympicLift":dataObj['olympicLift'],"preExInstructions":dataObj['preExInstructions'],"postExInstructions":dataObj['postExInstructions'],"accessLevel":dataObj['accessLevel'],"weightExists":dataObj['weightExists'],"distanceExists":dataObj['distanceExists'],"timeExists":dataObj['timeExists'],"repsExists":dataObj['repsExists'],"exAbilities":dataObj['exAbilities'],"setInstructions":dataObj['setInstructions'],"dependencies":string,"speedExists":dataObj['speedExists'],"heightExists":dataObj['heightExists'],"tmax":dataObj['tmax']})
            return JsonResponse({"success":True,"defaultExArr":dataArr,"exArr":defaultExArr,"skillArr":skilArr})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@never_cache
def excersiceTypeDetailsPDC(request):
	x= connection.cursor()
	exTypeDetails = "SELECT * FROM utility_exercise WHERE exerciseStatus = 1"
	x.execute(exTypeDetails)
	resultQuery = dictfetchall(x)
	dataArr = []
	defaultExArr = []
	skilArr = []
	for dt in resultQuery:
		dataObj = dict(dt)
		videoId = dataObj['video_id']
		videos = Videos.objects.filter(id = videoId).values()
		for val in videos:
			valObj = dict(val)
			if dataObj['accessLevel'] == 0:
				dataArr.append({"exName": dataObj['exerciseName'], "exCode": dataObj['exerciseCode'], "id": dataObj['id'], "exDesc": dataObj['exerciseDesc'],"exEquip": dataObj['equipment'],"exVideos":valObj['videoLink'],"olympicLift":dataObj['olympicLift'],"preExInstructions":dataObj['preExInstructions'],"postExInstructions":dataObj['postExInstructions'],"accessLevel":dataObj['accessLevel'],"weightExists":dataObj['weightExists'],"distanceExists":dataObj['distanceExists'],"timeExists":dataObj['timeExists'],"repsExists":dataObj['repsExists'],"exAbilities":dataObj['exAbilities'],"setInstructions":dataObj['setInstructions']})
			elif dataObj['exAbilities'] == 'Skill':
				skilArr.append({"exName": dataObj['exerciseName'], "exCode": dataObj['exerciseCode'], "id": dataObj['id'], "exDesc": dataObj['exerciseDesc'],"exEquip": dataObj['equipment'],"exVideos":valObj['videoLink'],"olympicLift":dataObj['olympicLift'],"preExInstructions":dataObj['preExInstructions'],"postExInstructions":dataObj['postExInstructions'],"accessLevel":dataObj['accessLevel'],"weightExists":dataObj['weightExists'],"distanceExists":dataObj['distanceExists'],"timeExists":dataObj['timeExists'],"repsExists":dataObj['repsExists'],"exAbilities":dataObj['exAbilities'],"setInstructions":dataObj['setInstructions'],"skill":True})
			else:
				string = ''
				dataObj['tmax']= {}
				advExDetails = AdvExercises.objects.get(exercise_id = dataObj['id'])
				if advExDetails:
					if advExDetails.maxWeight == True:
						string += ", Weight"
					if advExDetails.maxReps == True:
						string += ", Reps"
					if advExDetails.maxTime == True:
						string += ", Time"
					if advExDetails.maxDistance == True:
						string += ", Distance"
					if advExDetails.maxSpeed == True:
						string += ", Speed"
					if advExDetails.maxHeight == True:
						string += ", Height"
					string = string[2:]
					dataObj['tmax'] = {"weight":advExDetails.maxWeight,"reps":advExDetails.maxReps,"time":advExDetails.maxTime,"distance":advExDetails.maxDistance,"speed":advExDetails.maxSpeed,"height":advExDetails.maxHeight}
				defaultExArr.append({"exName": dataObj['exerciseName'], "exCode": dataObj['exerciseCode'], "id": dataObj['id'], "exDesc": dataObj['exerciseDesc'],"exEquip": dataObj['equipment'],"exVideos":valObj['videoLink'],"olympicLift":dataObj['olympicLift'],"preExInstructions":dataObj['preExInstructions'],"postExInstructions":dataObj['postExInstructions'],"accessLevel":dataObj['accessLevel'],"weightExists":dataObj['weightExists'],"distanceExists":dataObj['distanceExists'],"timeExists":dataObj['timeExists'],"repsExists":dataObj['repsExists'],"exAbilities":dataObj['exAbilities'],"setInstructions":dataObj['setInstructions'],"dependencies":string,"speedExists":dataObj['speedExists'],"heightExists":dataObj['heightExists'],"tmax":dataObj['tmax']})
	return JsonResponse({"success":True,"defaultExArr":dataArr,"exArr":defaultExArr,"skillArr":skilArr})

@api_view(['GET', 'POST'])
@never_cache
def newexcersiceTypeDetailsPDC(request):
	x= connection.cursor()
	exTypeDetails = "SELECT * FROM utility_newexercise WHERE exerciseStatus = 1"
	x.execute(exTypeDetails)
	resultQuery = dictfetchall(x)
	dataArr = []
	defaultExArr = []
	skilArr = []
	for dt in resultQuery:
		dataObj = dict(dt)
		#videoId = dataObj['video_id']
		if dataObj['accessLevel'] == 0:
			dataArr.append({"exName": dataObj['exerciseName'], "id": dataObj['id'], "exDesc": dataObj['exerciseDesc'],"exEquip": dataObj['equipment'],"preExInstructions":dataObj['preExInstructions'],"postExInstructions":dataObj['postExInstructions'],"accessLevel":dataObj['accessLevel'],"weightExists":dataObj['weightExists'],"distanceExists":dataObj['distanceExists'],"timeExists":dataObj['timeExists'],"repsExists":dataObj['repsExists'],"setInstructions":dataObj['setInstructions'],"stressFactor":dataObj['stressFactor'], "exCoeffiecient":dataObj['exCoeffiecient'], "exGroup":dataObj['exGroup'], "exMainGroup":dataObj['exMainGroup'], "flowType":dataObj['flowType'],"distanceFactor":dataObj['distanceFactor'],"ExerciseCoverImage":dataObj['cover_image'],"ExerciseThumbImage":dataObj['thumb_image'],"ExerciseVideo":dataObj['video']})
		else:
			skilArr.append({"exName": dataObj['exerciseName'], "id": dataObj['id'], "exDesc": dataObj['exerciseDesc'],"exEquip": dataObj['equipment'],"preExInstructions":dataObj['preExInstructions'],"postExInstructions":dataObj['postExInstructions'],"accessLevel":dataObj['accessLevel'],"weightExists":dataObj['weightExists'],"distanceExists":dataObj['distanceExists'],"timeExists":dataObj['timeExists'],"repsExists":dataObj['repsExists'],"setInstructions":dataObj['setInstructions'],"stressFactor":dataObj['stressFactor'], "exCoeffiecient":dataObj['exCoeffiecient'], "exGroup":dataObj['exGroup'], "exMainGroup":dataObj['exMainGroup'], "flowType":dataObj['flowType'],"distanceFactor":dataObj['distanceFactor'],"ExerciseCoverImage":dataObj['cover_image'],"ExerciseThumbImage":dataObj['thumb_image'],"ExerciseVideo":dataObj['video'],"skill":True})
	return JsonResponse({"success":True,"defaultExArr":dataArr,"exArr":defaultExArr,"skillArr":skilArr})

@api_view(['GET', 'POST'])
@never_cache
def Fooditems(request):
    food=json.loads(request.body.decode('utf-8'))
    print(food)
    Fullmeals=FullMeals.objects.create(FullMeals=food)
    return JsonResponse({"success":True})



@api_view(['GET', 'POST'])
@never_cache
def getFoodItems(request):
    
    return JsonResponse({"mealData":[{"id":1,"name":"Apple","calories":72,"fat":0.23,"carbs":19.06,"protien":0.36, "fatPercent":3,"carbPercent":95,"proteinPercent":2},
	{"id":2,"name":"Banana","calories":89,"fat":0.33,"carbs":22.84,"protien":1.09, "fatPercent":3,"carbPercent":93,"proteinPercent":4},
	{"id":3,"name":"Mango","calories":135,"fat":0.56,"carbs":35.19,"protien":1.06, "fatPercent":3,"carbPercent":94,"proteinPercent":3},
	{"id":4,"name":"Papaya - One Cup Mashed","calories":90,"fat":0.32,"carbs":22.56,"protien":1.40, "fatPercent":3,"carbPercent":91,"proteinPercent":6},
	{"id":5,"name":"Carrot","calories":30,"fat":0.32,"carbs":22.56,"protien":1.4, "fatPercent":3,"carbPercent":91,"proteinPercent":6},
	{"id":6,"name":"Cucumber","calories":45,"fat":0.33,"carbs":10.93,"protien":1.96, "fatPercent":5,"carbPercent":80,"proteinPercent":14},
 	{"id":7,"name":"Tea - with milk and sugar","calories":30,"fat":0.82,"carbs":4.97,"protien":0.93, "fatPercent":24,"carbPercent":64,"proteinPercent":12},
	{"id":8,"name":"Roti","calories":106,"fat":0.52,"carbs":22.32,"protien":3.84, "fatPercent":4,"carbPercent":82,"proteinPercent":14},
	{"id":9,"name":"Naan","calories":137,"fat":5.1,"carbs":18.8,"protien":3.74, "fatPercent":34,"carbPercent":55,"proteinPercent":11},
	{"id":10,"name":"Rajma","calories":333,"fat":0.83,"carbs":60.01,"protien":23.58, "fatPercent":2,"carbPercent":70,"proteinPercent":28},
	{"id":11,"name":"Paratha","calories":260,"fat":8.99,"carbs":38.94,"protien":5.16, "fatPercent":31,"carbPercent":61,"proteinPercent":8},
	{"id":12,"name":"Ladys Finger - 100gms","calories":26,"fat":0.2,"carbs":4.5,"protien":1.5, "fatPercent":7,"carbPercent":70,"proteinPercent":23},
	{"id":13,"name":"Rice - 1 cup","calories":204,"fat":0.44,"carbs":44.08,"protien":4.2, "fatPercent":2,"carbPercent":89,"proteinPercent":9},
	{"id":14,"name":"Chicken Breast","calories":282,"fat":6.09,"carbs":0,"protien":30.76, "fatPercent":21,"carbPercent":0,"proteinPercent":79},
	{"id":15,"name":"Mutton/Lamb chop 200gms","calories":342,"fat":26.56,"carbs":0,"protien":24.01, "fatPercent":71,"carbPercent":0,"proteinPercent":29},
	{"id":16,"name":"Chicken Shawarma","calories":517,"fat":6.31,"carbs":76.55,"protien":35.83, "fatPercent":11,"carbPercent":60,"proteinPercent":28},
	{"id":17,"name":"Egg","calories":74,"fat":4.97,"carbs":0.38,"protien":6.29, "fatPercent":63,"carbPercent":2,"proteinPercent":35},
	{"id":18,"name":"Chicken Biryani","calories":348,"fat":9.82,"carbs":48.07,"protien":15.9, "fatPercent":26,"carbPercent":56,"proteinPercent":18},
	{"id":19,"name":"Vegitable Biryani","calories":318,"fat":6.19,"carbs":57.17,"protien":7.75, "fatPercent":18,"carbPercent":73,"proteinPercent":10},
	{"id":20,"name":"Dal - 1 cup","calories":198,"fat":6.32,"carbs":26.18,"protien":10.36, "fatPercent":28,"carbPercent":52,"proteinPercent":20},
  {"id":21,"name":"Whole Wheat Bread - 1 slice","calories":69,"fat":1.18,"carbs":12.91,"protien":2.72, "fatPercent":14,"carbPercent":71,"proteinPercent":15}],"success":True})












'''SINDHU CHANGES'''
@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getPlanDatesStatus(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    print(username)
    user = username['id']
    req = "GET"
    url = "userplan/getPlanDates/"
    print(user)
    try:
        if username != None:
            activeplan =UserPlan.objects.select_related('Plan__id').filter(user_id=user, status = 1).values('id','startDate','endDate','status','plan_id__planName','plan_id')
            previousplan =UserPlan.objects.select_related('Plan__id').filter(user_id=user, status = 2).values('id','startDate','endDate','status','plan_id__planName','plan_id')
            for dt in activeplan:
                dataObj =dict(dt)
            for dat in previousplan:
                dataObj1 = dict(dat)
            return JsonResponse({"success": True, "ActivePlanDetails": dataObj,"PreviousPlanDetails":dataObj1 })
        else:
            return JsonResponse({"success":False,"message":"User logged out"})
    except Exception as e:
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def checkToPlanBuilder(request):
    #user = request.session['user_id']
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    req = "GET"
    url = "userplan/getPlanDates/"
    try:
        if username != None:
            userplanId = UserPlan.objects.filter(user_id=user).values('createdDate', 'plan_id','id')
            if userplanId.exists():
                for va1 in userplanId:
                    obj = dict(va1)
                    #print(obj)
                protocolDetails = PlanProtocol.objects.filter(plan_id = obj['plan_id']).values('exercise','values','protocol')
                #print(protocolDetails,"protocols")
                progressionvalues = []
                regressionvalues  = []
                for pt in protocolDetails:
                    protoObj = dict(pt)
                    print(protoObj['protocol'],"protoId")
                    rulevalues = protoObj['values'].replace("'", '"')
                    rules = json.loads(rulevalues)
                    if protoObj['protocol'] == 9:
                        values = protoObj['values'].replace("'", '"')
                        regressionvalues = json.loads(values)
                        #print(regressionvalues)
                    elif protoObj['protocol'] == 6:
                        values = protoObj['values'].replace("'", '"')
                        progressionvalues = json.loads(values)
                        #print(progressionvalues)
                plancyclecompleted = UserPlanCycle.objects.filter(user_id = user,BP_missed=True,SQAT_missed=True,OP_missed=True,DL_missed =True,userplan_id =obj['id']).values('BP_missed','SQAT_missed','OP_missed','DL_missed')
                #print(plancyclecompleted,"here")
                if plancyclecompleted.exists():
                    return JsonResponse({"success":False,"message":"Your Starter Program Got Completed","CompletedStatus":True})
                else:
                    userplanpage = UserPlan.objects.filter(user_id=user,status =1)
                    today = datetime.now().date().strftime("%Y-%m-%d")
                    #print(today)
                    if userplanpage.exists():
                        userplanpage = userplanpage.values('createdDate', 'plan_id','id')
                        for dt in userplanpage:
                            dataObj = dict(dt)
                            #print(dataObj)
                            dataObj['createdDate'] = dataObj['createdDate'].strftime("%Y-%m-%d")
                        planId = dataObj['plan_id']
                        userpId = dataObj['id']
                        exDetails = PlanExcercise.objects.select_related('PlanSession__id','Microcycle__id','PlanMesocycle__id','PlanPeriods__id','Plan__id').filter(session__microcycle__mesocycle__period__plan = planId).values('exerciseName','transitExercise','transitExercise__exerciseName','exerciseName__exerciseName').order_by('id')
                        ex1 = exDetails[0]
                        #print(exDetails,ex1['exerciseName'],"dataBaseIds")
                        exercise1 =ex1['exerciseName']
                        ex1Name = ex1['exerciseName__exerciseName']
                        ex3Name = ex1['transitExercise__exerciseName']
                        exercise3 = ex1['transitExercise']
                        ex2 = exDetails[1]
                        exercise2 = ex2['exerciseName']
                        ex2Name = ex2['exerciseName__exerciseName']
                        ex4Name = ex2['transitExercise__exerciseName']
                        exercise4 = ex2['transitExercise']
                        #print(dataObj['createdDate'])
                        #if today >= dataObj['createdDate'] :
                        usertestpage = UserTestPlan.objects.filter(user_id=user, plan_id=dataObj['plan_id'],userplan_id =dataObj['id']).values('createdDate')
                        time_threshold = date.today()
                        if usertestpage.exists():
                            if len(usertestpage) >= 2:
                                for dt in usertestpage:
                                    TestPObj = dict(dt)
                                    TestPObj['testDate'] = TestPObj['createdDate'].strftime("%Y-%m-%d")
                                    d1 = datetime.strptime(today, "%Y-%m-%d")
                                    d2 = datetime.strptime(TestPObj['testDate'], "%Y-%m-%d")
                                    d3 = d2 + timedelta(days=2)
                                    difDays = abs((d2 - d1).days)
                                #if difDays > 2:
                                userexcersisepage = UserExercise.objects.filter(user_id=user, plan_id=planId,userplan_id =userpId,createdDate__lt = today + ' 00:00:00')
                                if userexcersisepage.exists():
                                        sessDetails = UserExercise.objects.filter(user_id=user,plan_id=planId,userplan_id =userpId).values('createdDate').last()
                                        sessDetails['testDate'] = sessDetails['createdDate'].strftime("%Y-%m-%d")
                                        sessd1 = datetime.strptime(today, "%Y-%m-%d")
                                        sessd2 = datetime.strptime(sessDetails['testDate'], "%Y-%m-%d")
                                        sessd3 = sessd2 + timedelta(days=2)
                                        sessdifDays = abs((sessd2 - sessd1).days)
                                        if sessdifDays>=2 or sessdifDays ==0:
                                            sessionInfo = UserExercise.objects.filter(user_id = user,plan_id=dataObj['plan_id'],userplan_id =dataObj['id'],createdDate__lt=time_threshold-timedelta(days=1)).aggregate(Max('userSession'))
                                            print(sessionInfo['userSession__max'],"0987654321")
                                            #print(sessionInfo['createdDate__max'],"12345678")
                                            userexcersises = UserExercise.objects.select_related('exerciseId__id').filter(user_id=user,plan_id=planId,userplan_id =userpId,createdDate__lt=time_threshold-timedelta(days=1),userSession = sessionInfo['userSession__max']).values('exerciseName','totalReps', 'totalSets', 'nextExerciseName', 'missed', 'exerciseDate','plan', 'user', 'exerciseWorkWeight','createdDate','recovered','progressed','exerciseId__exerciseCode','exerciseId__excercisevideos','exerciseId__exerciseDesc','exerciseId__equipment','exerciseId','exerciseId__exerciseName').order_by('createdDate')
                                            print(userexcersises,"PREVIOUS EXERCISES")
                                            #testArr = []
                                            mainArr = []
                                            for dt in userexcersises:
                                                dataObj = dict(dt)
                                                #TestPObj = dict(dt)
                                                planExDetails = PlanExcercise.objects.select_related('Exercise__id').filter(session__microcycle__mesocycle__period__plan = planId,exerciseName_id = dataObj['exerciseId']).values('exerciseName_id__exerciseName','exerciseName_id','status','num_of_sets','totalInol','intensity','id','num_of_reps','extra_set')
                                                for se in planExDetails:
                                                    setVal = dict(se)
                                                    num_of_sets = setVal['num_of_sets']
                                                    reps_per_set = setVal['num_of_reps']
                                                    num_of_reps = num_of_sets*reps_per_set
                                                dataObj['testDate'] = dataObj['createdDate'].strftime("%Y-%m-%d")
                                                d1 = datetime.strptime(today, "%Y-%m-%d")
                                                d2 = datetime.strptime(dataObj['testDate'], "%Y-%m-%d")
                                                d3 = d2 + timedelta(days=2)
                                                #print(dataObj['exerciseName'],)
                                                nextCheck = True
                                                nextScheck = True
                                                cycleDetails = UserPlanCycle.objects.filter(user_id=user,plan_id=planId,userplan_id =userpId).values('BP_progressed','SQAT_progressed','OP_progressed','DL_progressed','OP_missed','DL_missed','updatedDate')
                                                if cycleDetails.exists():
                                                    for val in cycleDetails:
                                                        value = dict(val)
                                                    cycvalue = value['updatedDate'].strftime("%Y-%m-%d")
                                                    today = datetime.now().date().strftime("%Y-%m-%d")
                                                    todayDone = UserExercise.objects.filter(user_id=user,plan_id=planId,userplan_id =userpId,exerciseName = dataObj['exerciseName'], createdDate__gt = today + ' 00:00:00',totalSets = 3).values()
                                                    if todayDone.exists():
                                                        print(dataObj['exerciseName'] + ' Exists')
                                                    else:
                                                        if dataObj['exerciseId'] == exercise1 and value['BP_progressed'] == True:
                                                            print("in Here1")
                                                            excersiceworkweight2 = UserExercise.objects.filter(user_id=user,plan_id=planId,userplan_id =userpId,exerciseId=exercise3).values('exerciseName','totalReps', 'totalSets', 'nextExerciseName', 'missed', 'exerciseDate','plan', 'user', 'exerciseWorkWeight','createdDate','recovered','progressed','exerciseId').order_by('-id')[:1]
                                                            if excersiceworkweight2.exists():
                                                                dataObj['exerciseId'] = exercise3
                                                                dataObj['exerciseName'] = ex3Name
                                                                for ww2 in excersiceworkweight2:
                                                                    workW2 = dict(ww2)
                                                                dataObj['exerciseWorkWeight'] = workW2['exerciseWorkWeight']
                                                                dataObj['missed'] = workW2['missed']
                                                                dataObj['totalReps'] = workW2['totalReps']
                                                                dataObj['totalSets'] = workW2['totalSets']
                                                                dataObj['recovered'] = workW2['recovered']
                                                                dataObj['progressed'] = workW2['progressed']
                                                                dataObj['exerciseId'] = workW2['exerciseId']
                                                            nextCheck = False
                                                        if dataObj['exerciseId'] == exercise3 and nextCheck != False:
                                                            print("in Here2")
                                                            excersiceworkweight = UserExercise.objects.filter(user_id=user,plan_id=planId,userplan_id =userpId,exerciseId=exercise1).values('exerciseName','totalReps', 'totalSets', 'nextExerciseName', 'missed', 'exerciseDate','plan', 'user', 'exerciseWorkWeight','createdDate','recovered','progressed','exerciseId').order_by('-id')[:1]
                                                            if excersiceworkweight.exists():
                                                                dataObj['exerciseId'] = exercise1
                                                                dataObj['exerciseName'] = ex1Name
                                                                for ww in excersiceworkweight:
                                                                    workW = dict(ww)
                                                                dataObj['exerciseWorkWeight'] = workW['exerciseWorkWeight']
                                                                dataObj['missed'] = workW['missed']
                                                                dataObj['totalReps'] = workW['totalReps']
                                                                dataObj['totalSets'] = workW['totalSets']
                                                                dataObj['recovered'] = workW['recovered']
                                                                dataObj['progressed'] = workW['progressed']
                                                                dataObj['exerciseId'] = workW['exerciseId']
                                                        if dataObj['exerciseId'] == exercise2 and value['SQAT_progressed'] == True:
                                                            print("IN HEre3")
                                                            excersiceworkweight4 = UserExercise.objects.filter(user_id=user,plan_id=planId,userplan_id =userpId,exerciseId=exercise4).values('exerciseName','totalReps', 'totalSets', 'nextExerciseName', 'missed', 'exerciseDate','plan', 'user', 'exerciseWorkWeight','createdDate','recovered','progressed','exerciseId').order_by('-id')[:1]
                                                            if excersiceworkweight4.exists():
                                                                dataObj['exerciseId'] = exercise4
                                                                dataObj['exerciseName'] = ex4Name
                                                                for ww4 in excersiceworkweight4:
                                                                    workW4 = dict(ww4)
                                                                dataObj['exerciseWorkWeight'] = workW4['exerciseWorkWeight']
                                                                dataObj['missed'] = workW4['missed']
                                                                dataObj['totalReps'] = workW4['totalReps']
                                                                dataObj['totalSets'] = workW4['totalSets']
                                                                dataObj['recovered'] = workW4['recovered']
                                                                dataObj['progressed'] = workW4['progressed']
                                                                dataObj['exerciseId'] = workW4['exerciseId']
                                                            nextScheck = False
                                                        if dataObj['exerciseId'] == exercise4 and nextScheck != False:
                                                            print("IN HEre4")
                                                            excersiceworkweight1 = UserExercise.objects.filter(user_id=user,plan_id=planId,userplan_id =userpId,exerciseId=exercise2).values('exerciseName','totalReps', 'totalSets', 'nextExerciseName', 'missed', 'exerciseDate','plan', 'user', 'exerciseWorkWeight','createdDate','recovered','progressed','exerciseId').order_by('-id')[:1]
                                                            if excersiceworkweight1.exists():
                                                                dataObj['exerciseId'] = exercise2
                                                                dataObj['exerciseName'] = ex2Name
                                                                for ww1 in excersiceworkweight1:
                                                                    workW1 = dict(ww1)
                                                                dataObj['exerciseWorkWeight'] = workW1['exerciseWorkWeight']
                                                                dataObj['missed'] = workW1['missed']
                                                                dataObj['totalReps'] = workW1['totalReps']
                                                                dataObj['totalSets'] = workW1['totalSets']
                                                                dataObj['recovered'] = workW1['recovered']
                                                                dataObj['progressed'] = workW1['progressed']
                                                                dataObj['exerciseId'] = workW1['exerciseId']
                                                print(dataObj['exerciseName'])
                                                difDays = abs((d2 - d1).days)
                                                print(difDays,"difference")
                                                if difDays >=2:
                                                    if dataObj['missed'] == True or dataObj['totalReps'] < int(num_of_reps) or dataObj['totalSets'] <int(num_of_sets):
                                                        print(regressionvalues,"in here for testing")
                                                        for reg in regressionvalues:
                                                            if int(reg['tmaxpercent']) == 0:
                                                                regtmaxValue = int(reg['tmaxvalue'])
                                                            elif int(reg['tmaxpercent']) == 1:
                                                                regtmaxValue = int(dataObj['exerciseWorkWeight'])*(int(reg['tmaxvalue'])/100)
                                                            if dataObj['totalReps'] >=reg['minReps'] and dataObj['totalReps'] <=reg['maxReps']:
                                                                #testExcersice = "OP"
                                                                #testArr.append({"name": testExcersice})
                                                                name = dataObj['exerciseName']
                                                                workweight = int(dataObj['exerciseWorkWeight']) - regtmaxValue
                                                                set = num_of_sets
                                                                reps = num_of_reps
                                                                repsPerSet = reps_per_set
                                                                mainArr.append({"name": name, "workWeight": round(workweight), "sets": set, "reps": reps,"reps_sets": repsPerSet,"exCode": dataObj['exerciseId__exerciseCode'], "exVideo": dataObj['exerciseId__excercisevideos'], "exDesc": dataObj['exerciseId__exerciseDesc'],"exEquip": dataObj['exerciseId__equipment'],"exId":dataObj['exerciseId']})
                                                                print("JUST MISSED CASE")
                                                            elif dataObj['missed'] == True and dataObj['recovered'] == True and dataObj['progressed'] == True and dataObj['nextExerciseName'] !=None:
                                                                print("Check where I am")
                                                                print(dataObj['nextExerciseName'])
                                                                if dataObj['exerciseId'] ==exercise1 and dataObj['nextExerciseName'] ==exercise3:
                                                                    name = ex3Name
                                                                    dataObj['exerciseId'] = exercise3
                                                                    workweight = round(int(dataObj['exerciseWorkWeight']) * 0.64)
                                                                elif dataObj['exerciseId'] == exercise2 and dataObj['nextExerciseName'] ==exercise4:
                                                                    name = ex4Name
                                                                    dataObj['exerciseId'] = exercise4
                                                                    workweight = round(int(dataObj['exerciseWorkWeight']) * 1.1)
                                                                #else:
                                                                    #name = dataObj['exerciseName']
                                                                    #workweight = int(dataObj['exerciseWorkWeight']) + 5
                                                                set = num_of_sets
                                                                reps = num_of_reps
                                                                repsPerSet = reps_per_set
                                                                mainArr.append({"name": name, "workWeight": round(workweight), "sets": set, "reps": reps,"reps_sets": repsPerSet,"exCode": dataObj['exerciseId__exerciseCode'], "exVideo": dataObj['exerciseId__excercisevideos'], "exDesc": dataObj['exerciseId__exerciseDesc'],"exEquip": dataObj['exerciseId__equipment'],"exId":dataObj['exerciseId']})

                                                            elif dataObj['missed'] == True and dataObj['totalReps'] == 15:
                                                                print(dataObj['missed'],"IN here TO test")
                                                                name = dataObj['exerciseName']
                                                                workweight = int(dataObj['exerciseWorkWeight']) + protmaxValue
                                                                set = num_of_sets
                                                                reps = num_of_reps
                                                                repsPerSet = reps_per_set
                                                                mainArr.append({"name": name, "workWeight": round(workweight), "sets": set, "reps": reps,"reps_sets": repsPerSet,"exCode": dataObj['exerciseId__exerciseCode'], "exVideo": dataObj['exerciseId__excercisevideos'], "exDesc": dataObj['exerciseId__exerciseDesc'],"exEquip": dataObj['exerciseId__equipment'],"exId":dataObj['exerciseId']})
                                                                print(mainArr,"hjsjs")
                                                    elif dataObj['totalSets'] <3:
                                                        name = dataObj['exerciseName']
                                                        workweight = int(dataObj['exerciseWorkWeight'])
                                                        set = num_of_sets
                                                        reps = num_of_reps
                                                        repsPerSet = reps_per_set
                                                        mainArr.append({"name": name, "workWeight": round(workweight), "sets": set, "reps": reps,"reps_sets": repsPerSet,"exCode": dataObj['exerciseId__exerciseCode'], "exVideo": dataObj['exerciseId__excercisevideos'], "exDesc": dataObj['exerciseId__exerciseDesc'],"exEquip": dataObj['exerciseId__equipment'],"exId":dataObj['exerciseId']})
                                                    else:
                                                        for pro in progressionvalues:
                                                            if int(reg['tmaxpercent']) == 0:
                                                                protmaxValue = int(reg['tmaxvalue'])
                                                            elif int(reg['tmaxpercent']) == 1:
                                                                protmaxValue = int(dataObj['exerciseWorkWeight'])*(int(reg['tmaxvalue'])/100)
                                                            #protmaxValue = int(pro['tmaxvalue'])
                                                            name = dataObj['exerciseName']
                                                            workweight = int(dataObj['exerciseWorkWeight']) + protmaxValue
                                                            set = num_of_sets
                                                            reps = num_of_reps
                                                            repsPerSet = reps_per_set
                                                            mainArr.append({"name": name, "workWeight": round(workweight), "sets": set, "reps": reps,"reps_sets": repsPerSet,"exCode": dataObj['exerciseId__exerciseCode'], "exVideo": dataObj['exerciseId__excercisevideos'], "exDesc": dataObj['exerciseId__exerciseDesc'],"exEquip": dataObj['exerciseId__equipment'],"exId":dataObj['exerciseId']})
                                                    #mainArr.append({"name": name, "workWeight": workweight, "sets": set, "reps": reps,"reps_sets": repsPerSet})
                                                    #return JsonResponse({"success": True, "meaasge": "User ExcersiseDetails", "status": 4, "main": mainArr})
                                                else:
                                                    if abs((d2 - d1).days) ==0:
                                                        message ="Your session is over. <br/> Next workout will start on "+str(d3.strftime("%Y-%m-%d"))
                                                    else:
                                                        message = "Break day. <br/> Your next workout will start on "+str(d3.strftime("%Y-%m-%d"))
                                                    return JsonResponse({"success": True, "message": message, "status": 2,"mainArr":mainArr})
                                            # excersicArr = []
                                            # workout = {"workout":[{"exercisename":"BP", "workweight":100},{"exercisename":"Squat", "workweight":100}]}
                                            # excersicArr.append(workout)
                                            todayDate = datetime.now().date()
                                            #todaySessionObj = UserSession.objects.filter(createdDate__gte = todayDate)
                                            completedArr = {}
                                            #print(todaySessionObj)
                                            #if todaySessionObj.exists():
                                            todaysexersises = UserExercise.objects.filter(user_id=user,plan_id=obj['plan_id'],userplan_id = obj['id'],createdDate__gte = todayDate).values('exerciseName','totalReps', 'totalSets', 'nextExerciseName', 'missed', 'exerciseDate','plan', 'user', 'exerciseWorkWeight','createdDate','recovered','progressed','exerciseId').order_by('createdDate')
                                            print(todaysexersises,"TODAYS EXERCISES")
                                            if todaysexersises.exists():
                                                for ux in todaysexersises:
                                                    uxe = dict(ux)
                                                    if uxe['totalSets'] <3 or len(todaysexersises)<=2:
                                                        print(uxe['exerciseName'])
                                                        if uxe['exerciseId'] == exercise1:
                                                            completedExName = uxe['exerciseName'] = "bp"
                                                        elif uxe['exerciseId'] == exercise2:
                                                            completedExName = uxe['exerciseName'] = "sq"
                                                        elif uxe['exerciseId'] == exercise3:
                                                            completedExName = uxe['exerciseName'] = "op"
                                                        elif uxe['exerciseId'] ==exercise4:
                                                            completedExName = uxe['exerciseName'] = "dl"
                                                        completedSets = uxe['totalSets']
                                                        completedReps = uxe['totalReps']
                                                        completeJson =json.dumps({"completedSets": completedSets,"completedReps":completedReps})
                                                        completedArr[completedExName] = json.loads(completeJson)
                                                    else:
                                                        mainArr =[]
                                            return JsonResponse({"success": True, "message":"Your next workout will start on "+str(sessd3.strftime("%Y-%m-%d")), "status": 4, "main": mainArr,"completedJson":completedArr})
                                        else:
                                            if abs((sessd2 - sessd1).days) ==0:
                                                message ="Your session is over. <br/> Next workout will start on "+str(sessd3.strftime("%Y-%m-%d"))
                                            else:
                                                message = "Break day. <br/> Your next workout will start on "+str(sessd3.strftime("%Y-%m-%d"))
                                            return JsonResponse({"success": True, "message": message, "status": 2})
                                else:
                                    session1 = UserTestPlan.objects.select_related('Exercise__id').values("exerciseName", "workWeight","exerciseId","exerciseId__exerciseName","exerciseId__exerciseCode","exerciseId__excercisevideos","exerciseId__exerciseDesc","exerciseId__equipment").filter(user_id=user)
                                    mainArr = []
                                    for dt in session1:
                                        dataObj = dict(dt)
                                        planExDetails = PlanExcercise.objects.select_related('Exercise__id').filter(session__microcycle__mesocycle__period__plan = planId,exerciseName_id = dataObj['exerciseId']).values('exerciseName_id__exerciseName','exerciseName_id','status','num_of_sets','totalInol','intensity','id','num_of_reps','extra_set')
                                        for se in planExDetails:
                                            setVal = dict(se)
                                            if setVal['extra_set'] >0:
                                                num_of_sets = setVal['num_of_sets']-1
                                            else:
                                                num_of_sets = setVal['num_of_sets']
                                            reps_per_set = setVal['num_of_reps']
                                            num_of_reps = num_of_sets*reps_per_set
                                            extra_set = setVal['extra_set']
                                        name = dataObj['exerciseId__exerciseName']
                                        workweight = int(dataObj['workWeight']) + 5
                                        set = num_of_sets
                                        reps = num_of_reps
                                        repsPerSet = reps_per_set
                                        mainArr.append({"name": name, "workWeight": workweight, "sets": set, "reps": reps,"reps_sets": repsPerSet,"exCode": dataObj['exerciseId__exerciseCode'], "exVideo": dataObj['exerciseId__excercisevideos'], "exDesc": dataObj['exerciseId__exerciseDesc'],"exEquip": dataObj['exerciseId__equipment'],"exId":dataObj['exerciseId']})

                                    todayDate = datetime.now().date()
                                    completedArr = []
                                    todaysexersises = UserExercise.objects.filter(user_id=user,plan_id=obj['plan_id'],userplan_id = obj['id'],createdDate__gte = todayDate).values('exerciseName','totalReps', 'totalSets', 'nextExerciseName', 'missed', 'exerciseDate','plan', 'user', 'exerciseWorkWeight','createdDate','recovered','progressed','exerciseId').order_by('createdDate')
                                    print(todaysexersises,"TODAYS EXERCISES")
                                    if todaysexersises.exists():
                                        for ux in todaysexersises:
                                            uxe = dict(ux)
                                            if uxe['totalSets'] <3 or len(todaysexersises)<=2:
                                                '''print(uxe['exerciseName'])
                                                if uxe['exerciseId'] == exercise1:
                                                    completedExName = uxe['exerciseName'] = "bp"
                                                elif uxe['exerciseId'] == exercise2:
                                                    completedExName = uxe['exerciseName'] = "sq"
                                                elif uxe['exerciseId'] == exercise3:
                                                    completedExName = uxe['exerciseName'] = "op"
                                                elif uxe['exerciseName'] == exercise4:
                                                    completedExName = uxe['exerciseName'] = "dl"'''
                                                completedSets = uxe['totalSets']
                                                completedReps = uxe['totalReps']
                                                completeJson =json.dumps({"completedSets": completedSets,"completedReps":completedReps})
                                                completedArr.append(completeJson)
                                            else:
                                                mainArr =[]

                                    return JsonResponse({"success": True, "message": "Your next workout will start on "+str(d3.strftime("%Y-%m-%d")), "status": 4,"main": mainArr,"completedJson":completedArr})
                                #else:
                                    #return JsonResponse({"success": True, "meaasge": "It's Your Rest Day", "status": 2})
                            else:
                                return JsonResponse({"success": True, "meaasge": "User Is ready for the testPlan", "status": 3})
                        else:
                            excersicArr = []
                            workout = {"workout": [{"exercisename": "BP"}, {"exercisename": "Squat"}]}
                            excersicArr.append(workout)
                            return JsonResponse({"success": True, "meaasge": "User Is ready for the testPlan", "status": 3,
                                                 "WorkOut": excersicArr})
                        #else:
                            #return JsonResponse({"success": True, "meaasge": "Please Check Excersise StartDate", "status": 2})
                    else:
                        return JsonResponse({"success": True, "meaasge": "Please Subscribe for a Plan", "status": 1})
                        #return JsonResponse({"success": True,"message":"User Plan Saved Successfully"})

            else:
                return JsonResponse({"success": True, "meaasge": "Please Subscribe for a Plan", "status": 1})
        else:
            return JsonResponse({"success": True, "meaasge": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def excerciseDetailsJson(request):
    #user = request.session['user_id']
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        userInfo = json.loads(request.body.decode('utf-8'))
        user = username['id']
        combo = False
        if username !='':
            userplanpage = UserPlan.objects.filter(user_id=user).values('plan_id','id')
            if userplanpage.exists():
                uservalues = UserExercise.objects.select_related('utility_exercise__id').filter(user_id = user).values('exerciseName','exerciseWorkWeight','totalReps','id','exerciseId','exerciseId__exerciseName','session_id','totalSets','intensity','exerciseId__workFormula').order_by('id','exerciseId')
                if 'exId' in userInfo and userInfo['exId'] !=0 and userInfo['exId'] !="0":
                    uservalues = uservalues.filter(exerciseId_id=userInfo['exId'])
                    combo = True
                if 'planId' in userInfo and userInfo['planId'] !=0 and userInfo['planId'] !="0":
                    uservalues = uservalues.filter(plan_id=userInfo['planId'])
                    combo = True
                if 'from_date' in userInfo and userInfo['from_date'] !=False and userInfo['from_date'] !=None:
                    uservalues = uservalues.filter(exerciseDate__gte=userInfo['from_date'])
                    combo = True
                if 'to_date' in userInfo and userInfo['to_date'] !=False and userInfo['to_date'] !=None:
                    uservalues = uservalues.filter(exerciseDate__lte=userInfo['to_date'])
                    combo = True
                if uservalues.exists():
                    exerciseDetails = collections.defaultdict(list)
                    actualExData = []
                    bpArr = []
                    sqArr = []
                    opArr = []
                    dlArr = []
                    for dt1 in uservalues:
                        dataObj = dict(dt1)
                        orm = float(float(int(dataObj['exerciseWorkWeight'])*0.0333))+int(dataObj['exerciseWorkWeight'])
                        totalTonnage = float(float(dataObj['exerciseWorkWeight'])*int(dataObj['totalReps']))/1000
                        #avgwt = float(totalTonnage*1000)/int(dataObj['totalReps'])
                        #relavgwt = avgwt/orm
                        if dataObj['totalReps'] != 0:
                            avgwt = float(totalTonnage*1000)/int(dataObj['totalReps'])
                        else:
                            avgwt = 0
                        if orm != 0:
                            relavgwt = avgwt/orm
                        else:
                            relavgwt = 0

                        totalwork = dataObj['exerciseId__workFormula']*9.8*int(dataObj['exerciseWorkWeight'])*int(dataObj['totalReps'])
                        cal = totalwork * 0.238902957619
                        dataObj['orm'] = orm
                        dataObj['totalTonnage'] = totalTonnage
                        dataObj['avgWt'] = avgwt
                        dataObj['relavgwt'] = relavgwt
                        dataObj['totalwork'] = totalwork
                        dataObj['cal'] = cal
                        dataObj['sessionDetails'] = {"orm": dataObj['orm'], "totalTonnage": dataObj['totalTonnage'],
                                                     "avgWt": dataObj['avgWt'], "relavgwt": dataObj['relavgwt'],
                                                     "totalwork": dataObj['totalwork'], "cal": dataObj['cal'],
                                                     "exId": dataObj['exerciseId'],
                                                     "exName": dataObj['exerciseId__exerciseName'],"totalSets":dataObj['totalSets'],"intensity":dataObj['intensity'],"workweight":dataObj['exerciseWorkWeight'],"totalReps":dataObj['totalReps'],"sessionId":dataObj['session_id']}
                        bpArr.append(dataObj['sessionDetails'])
                        exerciseDetails[dataObj['exerciseId__exerciseName']].append(dataObj['sessionDetails'])
                    '''for dt in exerciseDetails:
                        actualExData.append(exerciseDetails[dt])'''
                    return JsonResponse({"success":True,"exerciseDetails":exerciseDetails})
                else:
                    return JsonResponse({"success":False,"message":"No Exercise detail","combo":combo})
            else:
                return JsonResponse({"success":False,"message":"No Plan"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def customerEexcerciseDetailsJson(request):
    #user = request.session['user_id']
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        userInfo = json.loads(request.body.decode('utf-8'))
        user = userInfo['user_id']
        #user = username['id']
        if username !='':
            userplanpage = UserPlan.objects.filter(user_id=user, status=1).values('plan_id','id')
            if userplanpage.exists():
                for dt in userplanpage:
                    plan = dict(dt)
                uservalues = UserExercise.objects.select_related('utility_exercise__id','User__id').filter(user_id = user).values('exerciseName','exerciseWorkWeight','totalReps','id','exerciseId','exerciseId__exerciseName','session_id','totalSets','intensity','exerciseId__workFormula','user_id__first_name').order_by('id','exerciseId')
                username = ''
                if uservalues.exists():
                    exerciseDetails = collections.defaultdict(list)
                    actualExData = []
                    bpArr = []
                    sqArr = []
                    opArr = []
                    dlArr = []
                    for dt1 in uservalues:
                        dataObj = dict(dt1)
                        username = dataObj['user_id__first_name']
                        orm = float(float(int(dataObj['exerciseWorkWeight'])*0.0333))+int(dataObj['exerciseWorkWeight'])
                        totalTonnage = float(float(dataObj['exerciseWorkWeight'])*int(dataObj['totalReps']))/1000
                        #avgwt = float(totalTonnage*1000)/int(dataObj['totalReps'])
                        #relavgwt = avgwt/orm
                        if dataObj['totalReps'] != 0:
                            avgwt = float(totalTonnage*1000)/int(dataObj['totalReps'])
                        else:
                            avgwt = 0
                        if orm != 0:
                            relavgwt = avgwt/orm
                        else:
                            relavgwt = 0

                        totalwork = dataObj['exerciseId__workFormula']*9.8*int(dataObj['exerciseWorkWeight'])*int(dataObj['totalReps'])
                        cal = totalwork * 0.238902957619
                        dataObj['orm'] = orm
                        dataObj['totalTonnage'] = totalTonnage
                        dataObj['avgWt'] = avgwt
                        dataObj['relavgwt'] = relavgwt
                        dataObj['totalwork'] = totalwork
                        dataObj['cal'] = cal
                        dataObj['sessionDetails'] = {"orm": dataObj['orm'], "totalTonnage": dataObj['totalTonnage'],
                                                     "avgWt": dataObj['avgWt'], "relavgwt": dataObj['relavgwt'],
                                                     "totalwork": dataObj['totalwork'], "cal": dataObj['cal'],
                                                     "exId": dataObj['exerciseId'],
                                                     "exName": dataObj['exerciseId__exerciseName'],"totalSets":dataObj['totalSets'],"intensity":dataObj['intensity'],"workweight":dataObj['exerciseWorkWeight'],"totalReps":dataObj['totalReps'],"sessionId":dataObj['session_id']}
                        bpArr.append(dataObj['sessionDetails'])
                        exerciseDetails[dataObj['exerciseId__exerciseName']].append(dataObj['sessionDetails'])
                    '''for dt in exerciseDetails:
                        actualExData.append(exerciseDetails[dt])'''
                    return JsonResponse({"success":True,"exerciseDetails":exerciseDetails,"username":username})
                else:
                    return JsonResponse({"success":False,"message":"No Exercise detail"})
            else:
                return JsonResponse({"success":False,"message":"No Program"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def todyasexcerciseDetailsJson(request):
    #user = request.session['user_id']
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        user = username['id']
        if username !='':
            today = date.today().strftime("%Y-%m-%d")
            userplanpage = UserPlan.objects.filter(user_id=user, status=1).values('plan_id','id')
            if userplanpage.exists():
                for dt in userplanpage:
                    plan = dict(dt)
                uservalues = UserExercise.objects.select_related('utility_exercise__id').filter(user_id = user,plan_id = plan['plan_id'],userplan_id = plan['id'],createdDate__gt=today + ' 00:00:00', createdDate__lt=today + ' 23:59:59').values('exerciseName','exerciseWorkWeight','totalReps','id','exerciseId','exerciseId__exerciseName','session_id','totalSets','intensity').order_by('id','exerciseName')
                if uservalues.exists():
                    print(uservalues)
                    print(today,"todaysDate")
                    exerciseDetails = {}
                    actualExData = []
                    bpArr = []
                    sqArr = []
                    opArr = []
                    dlArr = []
                    for dt1 in uservalues:
                        dataObj = dict(dt1)
                        if dataObj['exerciseId__exerciseName'] == "BENCH PRESS":
                            #print(dataObj['createdDate'],"createdDate")
                            orm = float(float(int(dataObj['exerciseWorkWeight'])*0.0333))+int(dataObj['exerciseWorkWeight'])
                            totalTonnage = float(float(dataObj['exerciseWorkWeight'])*int(dataObj['totalReps']))/1000
                            avgwt = float(totalTonnage*1000)/int(dataObj['totalReps'])
                            relavgwt = avgwt/orm
                            totalwork = 0.28*9.8*int(dataObj['exerciseWorkWeight'])*int(dataObj['totalReps'])
                            cal = totalwork * 0.238902957619
                            dataObj['orm'] = orm
                            dataObj['totalTonnage'] = totalTonnage
                            dataObj['avgWt'] = avgwt
                            dataObj['relavgwt'] = relavgwt
                            dataObj['totalwork'] = totalwork
                            dataObj['cal'] = cal
                            dataObj['sessionDetails'] = {"orm": dataObj['orm'], "totalTonnage": dataObj['totalTonnage'],
                                                         "avgWt": dataObj['avgWt'], "relavgwt": dataObj['relavgwt'],
                                                         "totalwork": dataObj['totalwork'], "cal": dataObj['cal'],
                                                         "exId": dataObj['exerciseId'],
                                                         "exName": dataObj['exerciseId__exerciseName'],"totalSets":dataObj['totalSets'],"intensity":dataObj['intensity'],"workweight":dataObj['exerciseWorkWeight'],"totalReps":dataObj['totalReps'],"sessionId":dataObj['session_id']}
                            bpArr.append(dataObj['sessionDetails'])
                            exerciseDetails[dataObj['exerciseId__exerciseName']] = {"exId": dataObj['exerciseId'], "exName": dataObj['exerciseId__exerciseName'],
                                 "sessionDetails": bpArr}
                        elif dataObj['exerciseId__exerciseName'] == "SQUAT":
                            orm = float(float(int(dataObj['exerciseWorkWeight'])*0.0333))+int(dataObj['exerciseWorkWeight'])
                            totalTonnage = float(float(dataObj['exerciseWorkWeight'])*int(dataObj['totalReps']))/1000
                            avgwt = float(totalTonnage*1000)/int(dataObj['totalReps'])
                            relavgwt = avgwt/orm
                            totalwork = 0.22*9.8*int(dataObj['exerciseWorkWeight'])*int(dataObj['totalReps'])
                            cal = totalwork * 0.238902957619
                            dataObj['orm'] = orm
                            dataObj['totalTonnage'] = totalTonnage
                            dataObj['avgWt'] = avgwt
                            dataObj['relavgwt'] = relavgwt
                            dataObj['totalwork'] = totalwork
                            dataObj['cal'] = cal
                            dataObj['sessionDetails'] = {"orm": dataObj['orm'], "totalTonnage": dataObj['totalTonnage'],
                                                         "avgWt": dataObj['avgWt'], "relavgwt": dataObj['relavgwt'],
                                                         "totalwork": dataObj['totalwork'], "cal": dataObj['cal'],
                                                         "exId": dataObj['exerciseId'],
                                                         "exName": dataObj['exerciseId__exerciseName'],"totalSets":dataObj['totalSets'],"intensity":dataObj['intensity'],"workweight":dataObj['exerciseWorkWeight'],"totalReps":dataObj['totalReps'],"sessionId":dataObj['session_id']}
                            sqArr.append(dataObj['sessionDetails'])
                            exerciseDetails[dataObj['exerciseId__exerciseName']] = {"exId": dataObj['exerciseId'], "exName": dataObj['exerciseId__exerciseName'], "sessionDetails": sqArr}
                        elif dataObj['exerciseId__exerciseName'] == "OLYMPIC PRESS":
                            orm = float(float(int(dataObj['exerciseWorkWeight'])*0.0333))+int(dataObj['exerciseWorkWeight'])
                            totalTonnage = float(float(dataObj['exerciseWorkWeight'])*int(dataObj['totalReps']))/1000
                            avgwt = float(totalTonnage*1000)/int(dataObj['totalReps'])
                            relavgwt = avgwt/orm
                            totalwork = 0.29*9.8*int(dataObj['exerciseWorkWeight'])*int(dataObj['totalReps'])
                            cal = totalwork * 0.238902957619
                            dataObj['orm'] = orm
                            dataObj['totalTonnage'] = totalTonnage
                            dataObj['avgWt'] = avgwt
                            dataObj['relavgwt'] = relavgwt
                            dataObj['totalwork'] = totalwork
                            dataObj['cal'] = cal
                            dataObj['sessionDetails'] = {"orm": dataObj['orm'], "totalTonnage": dataObj['totalTonnage'],
                                                         "avgWt": dataObj['avgWt'], "relavgwt": dataObj['relavgwt'],
                                                         "totalwork": dataObj['totalwork'], "cal": dataObj['cal'],
                                                         "exId": dataObj['exerciseId'],
                                                         "exName": dataObj['exerciseId__exerciseName'],"totalSets":dataObj['totalSets'],"intensity":dataObj['intensity'],"workweight":dataObj['exerciseWorkWeight'],"totalReps":dataObj['totalReps'],"sessionId":dataObj['session_id']}
                            opArr.append(dataObj['sessionDetails'])
                            exerciseDetails[dataObj['exerciseId__exerciseName']] = {"exId": dataObj['exerciseId'], "exName": dataObj['exerciseId__exerciseName'], "sessionDetails": opArr}
                        elif dataObj['exerciseId__exerciseName'] == "DEAD LIFT":
                            orm = float(float(int(dataObj['exerciseWorkWeight'])*0.0333))+int(dataObj['exerciseWorkWeight'])
                            totalTonnage = float(float(dataObj['exerciseWorkWeight'])*int(dataObj['totalReps']))/1000
                            avgwt = float(totalTonnage*1000)/int(dataObj['totalReps'])
                            relavgwt = avgwt/orm
                            totalwork = 0.31*9.8*int(dataObj['exerciseWorkWeight'])*int(dataObj['totalReps'])
                            cal = totalwork * 0.238902957619
                            dataObj['orm'] = orm
                            dataObj['totalTonnage'] = totalTonnage
                            dataObj['avgWt'] = avgwt
                            dataObj['relavgwt'] = relavgwt
                            dataObj['totalwork'] = totalwork
                            dataObj['cal'] = cal
                            dataObj['sessionDetails'] = {"orm": dataObj['orm'], "totalTonnage": dataObj['totalTonnage'],"avgWt": dataObj['avgWt'], "relavgwt": dataObj['relavgwt'],"totalwork": dataObj['totalwork'], "cal": dataObj['cal'],"exId": dataObj['exerciseId'],"exName": dataObj['exerciseId__exerciseName'],"totalSets":dataObj['totalSets'],"intensity":dataObj['intensity'],"workweight":dataObj['exerciseWorkWeight'],"totalReps":dataObj['totalReps'],"sessionId":dataObj['session_id']}
                            dlArr.append(dataObj['sessionDetails'])
                            exerciseDetails[dataObj['exerciseId__exerciseName']] = {"exId": dataObj['exerciseId'], "exName": dataObj['exerciseId__exerciseName'],"sessionDetails":dlArr}
                    for dt in exerciseDetails:
                        actualExData.append(exerciseDetails[dt])
                    return JsonResponse({"success":True,"exerciseDetails":actualExData})
                else:
                    return JsonResponse({"success":False,"message":"No Exercise detail"})
            else:
                return JsonResponse({"success":False,"message":"No Program"})
        else:
            return JsonResponse({"success": False,"message":"User Logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})



@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def createUserSetData(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    setInfoObj = json.loads(request.body.decode('utf-8'))
    req = setInfoObj
    url = "userprogram/createsetdetails/"
    try:
        if username !='':
            setArr = []
            setInfos = setInfoObj['set_details']
            for setInfo in setInfos:
                userPlanObj = UserPlan.objects.get(plan_id = setInfo['plan_id'], user_id=user, status = 1)
                userPlanID = userPlanObj.id
                planID = userPlanObj.plan_id
                print(planID)
                SetDetails = UserActions.objects.create(
                    user_id=user,
                    plan_id=planID,
                    userplan_id = userPlanID,
                    planaction_id = setInfo['setId'],
                    actionDate = setInfo['setCompletedDate'],
                    exercise_id = setInfo['exId'],
                    totalReps = setInfo['totalReps'],
                    actionWorkWeight = setInfo['workweight'],
                    actionTmax = setInfo['tmax']
                )
                if 'status' in setInfo and setInfo['status'] != None and setInfo['status'] != '' and setInfo['status'] != 'null':
                    SetDetails.setStatus = setInfo['status']
                if 'intensity' in setInfo and setInfo['intensity'] != None and setInfo['intensity'] != '' and setInfo['intensity'] != 'null':
                    SetDetails.actionIntensity = setInfo['intensity']
                SetDetails.save()
                setArr.append(SetDetails.id)
            return JsonResponse({"success":True,"message":"Set data entered successfully","sets":setArr})
        else:
            return JsonResponse({"success":False,"message":"User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg": str(e)})

def dictfetchall(cursor):
    "Return all rows from a cursor as a dict"
    columns = [col[0] for col in cursor.description]
    return [
        dict(zip(columns, row))
        for row in cursor.fetchall()
    ]

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def userLastSessionID(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    req = "GET"
    url = "userplan/userLastSession/"
    try:
        if username !='':
            userplanpage = UserPlan.objects.filter(user_id=user, status=1).values('plan_id','id')
            if userplanpage.exists():
                for dt in userplanpage:
                    plan = dict(dt)
                #lastSessionObj = UserExercise.objects.filter(user_id = user,userplan_id = plan['id']).values('session_id','plan_id').last()
                lastSetObj = UserSets.objects.filter(user_id = user, userplan_id = plan['id']).values('planset_id', 'session_id', 'plan_id').last()
                '''if lastSessionObj.exists():
                    print('Here I am')
                    for dt1 in lastSessionObj:
                        session = dict(dt1)'''
                if lastSetObj is None:
                    return JsonResponse({"success":False,"message":"No Program data"})
                else:
                    return JsonResponse({"success":True,"data":{"plan_id":lastSetObj['plan_id'], "session_id":lastSetObj['session_id'], "set_id":lastSetObj['planset_id']}})
                '''else:
                    return JsonResponse({"success":False,"message":"No Exercise Today"})'''
            else:
                return JsonResponse({"success":False,"message":"No Active Program"})
        else:
            return JsonResponse({"success":False,"message":"User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def deleteUserData(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    req = "GET"
    url = "userplan/deleteUserData/"
    try:
        if username !='':
            x = connection.cursor()
            foreignKeyChecks = "set foreign_key_checks = 0"
            x.execute(foreignKeyChecks)
            usersetdata = "delete from Userplan_usersets where user_id ="+str(user)
            x.execute(usersetdata)
            userexData = "delete from Userplan_userexercise where user_id ="+str(user)
            x.execute(userexData)
            setforeignkeychecks = "set foreign_key_checks = 1"
            x.execute(setforeignkeychecks)
            return JsonResponse({"success":True,"message":"Data deleted"})
        else:
            return JsonResponse({"success":False,"message":"User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def updateTmaxData(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    planInfo = json.loads(request.body.decode('utf-8'))
    req = planInfo
    url = "userplan/updateTmaxData/"
    try:
        if username !='':
            userplanpage = UserPlan.objects.filter(user_id=user, status=1).values('plan_id','id')
            if userplanpage.exists():
                for dt in userplanpage:
                    plan = dict(dt)
                print(plan['id'])
                testplanData = UserTestPlan.objects.filter(user_id = user, exerciseId_id = planInfo['exercise_id']).values()
                print(testplanData,"lllll")
                if testplanData.exists():
                    testplanData = UserTestPlan.objects.get(user_id = user, exerciseId_id = planInfo['exercise_id'])
                    testplanData.updateTmax = planInfo['updateTmax']
                    #testplanData.updateType = planInfo['updateType']
                    testplanData.save()
                else:
                    today = datetime.today()
                    exerciseData = NewExercise.objects.get(id = planInfo['exercise_id'])
                    createTplan = UserTestPlan.objects.create(
                        user_id = user,
                        plan_id = plan['plan_id'],
                        userplan_id = plan['id'],
                        exerciseId_id = planInfo['exercise_id'],
                        exerciseName = exerciseData.exerciseName,
                        workWeight = planInfo['updateTmax'],
                        tmax = planInfo['updateTmax'],
                        updateTmax = planInfo['updateTmax'],
                        workoutTestDate = today
                    )
                    createTplan.save()
                testplanDataU = UserTestPlan.objects.filter(user_id = user, exerciseId_id = planInfo['exercise_id']).values('exerciseId_id', 'updateTmax')
                testPlanObj = {}
                for dt in testplanDataU:
                    dta = dict(dt)
                    testPlanObj[dta['exerciseId_id']] = dta
                return JsonResponse({"success":True,"message":"Tmax Updated", "data":testPlanObj})
            else:
                testplanData = UserTestPlan.objects.filter(user_id = user, exerciseId_id = planInfo['exercise_id']).values()
                print(testplanData,"lllll")
                if testplanData.exists():
                    testplanData = UserTestPlan.objects.get(user_id = user, exerciseId_id = planInfo['exercise_id'])
                    testplanData.updateTmax = planInfo['updateTmax']
                    #testplanData.updateType = planInfo['updateType']
                    testplanData.save()
                else:
                    print("hereeeeeeee")
                    today = datetime.today()
                    exerciseData = NewExercise.objects.get(id = planInfo['exercise_id'])
                    createTplan = UserTestPlan.objects.create(
                        user_id = user,
                        plan_id = '99999',
                        userplan_id = '99999',
                        exerciseId_id = planInfo['exercise_id'],
                        exerciseName = exerciseData.exerciseName,
                        workWeight = planInfo['updateTmax'],
                        tmax = planInfo['updateTmax'],
                        updateTmax = planInfo['updateTmax'],
                        workoutTestDate = today
                    )
                    createTplan.save()
                testplanDataU = UserTestPlan.objects.filter(user_id = user, exerciseId_id = planInfo['exercise_id']).values('exerciseId_id', 'updateTmax')
                testPlanObj = {}
                for dt in testplanDataU:
                    dta = dict(dt)
                    testPlanObj[dta['exerciseId_id']] = dta
                return JsonResponse({"success":True,"message":"Tmax Updated", "data":testPlanObj})
                #return JsonResponse({"success":False,"message":"No Program"})
        else:
            return JsonResponse({"success":False,"message":"User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def updateBulkTmaxDataOld(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    planInfo = json.loads(request.body.decode('utf-8'))
    req = planInfo
    url = "userplan/updateBulkTmaxData/"
    try:
        if username !='':
            userplanpage = UserPlan.objects.filter(user_id=user, status=1).values('plan_id','id')
            if(len(userplanpage) == 0):
                userplanpage = UserPlan.objects.filter(user_id=user, status=3).values('plan_id','id')
            if userplanpage.exists():
                for dt in userplanpage:
                    plan = dict(dt)
                print(plan['id'])
                today = datetime.today()
                for tmax in planInfo['tmaxData']:
                    testplanData = UserTestPlan.objects.filter(user_id = user, exerciseId_id = tmax['id']).values()
                    print(testplanData,"lllll")
                    if testplanData.exists():
                        for val in testplanData:
                            valObj = dict(val)
                            testPlanID = valObj['id']
                            updateTplan = UserTestPlan.objects.get(pk = testPlanID)
                            updateTplan.updateTmax = tmax['updatetmax']
                            updateTplan.save()
                    else:
                        createTplan = UserTestPlan.objects.create(
                            user_id = user,
                            plan_id = plan['plan_id'],
                            userplan_id = plan['id'],
                            exerciseId_id = tmax['id'],
                            exerciseName = tmax['exerciseName'],
                            workWeight = tmax['updatetmax'],
                            tmax = tmax['updatetmax'],
                            updateTmax = tmax['updatetmax'],
                            workoutTestDate = today
                        )
                        createTplan.save()
                        print(tmax['id'],"123445")
                return JsonResponse({"success":True,"message":"Tmax Updated"})
            else:
                return JsonResponse({"success":False,"message":"No Program"})
        else:
            return JsonResponse({"success":False,"message":"User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def updateBulkTmaxData(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    planInfo = json.loads(request.body.decode('utf-8'))
    req = planInfo
    url = "userplan/updateBulkTmaxData/"
    try:
        if username !='':
            userplanpage = UserPlan.objects.filter(user_id=user, status=1).values('plan_id','id')
            if(len(userplanpage) == 0):
                userplanpage = UserPlan.objects.filter(user_id=user, status=3).values('plan_id','id')
            if userplanpage.exists():
                for dt in userplanpage:
                    plan = dict(dt)
                print(plan['id'])
                today = datetime.today()
                for tmax in planInfo['tmaxData']:
                    testplanData = UserTestPlan.objects.filter(user_id = user, exerciseId_id = tmax['id']).values()
                    print(testplanData,"lllll")
                    if testplanData.exists():
                        for val in testplanData:
                            valObj = dict(val)
                            testPlanID = valObj['id']
                            updateTplan = UserTestPlan.objects.get(pk = testPlanID)
                            updateTplan.updateTmax = tmax['updatetmax']
                            updateTplan.save()
                    else:
                        createTplan = UserTestPlan.objects.create(
                            user_id = user,
                            plan_id = plan['plan_id'],
                            userplan_id = plan['id'],
                            exerciseId_id = tmax['id'],
                            exerciseName = tmax['exerciseName'],
                            workWeight = tmax['updatetmax'],
                            tmax = tmax['updatetmax'],
                            updateTmax = tmax['updatetmax'],
                            workoutTestDate = today
                        )
                        createTplan.save()
                        print(tmax['id'],"123445")
                return JsonResponse({"success":True,"message":"Tmax Updated"})
            else:
                today = datetime.today()
                print("ghegegeg")
                for tmax in planInfo['tmaxData']:
                    testplanData = UserTestPlan.objects.filter(user_id = user, exerciseId_id = tmax['id']).values()
                    print(testplanData,"lllll")
                    if testplanData.exists():
                        for val in testplanData:
                            valObj = dict(val)
                            testPlanID = valObj['id']
                            updateTplan = UserTestPlan.objects.get(pk = testPlanID)
                            updateTplan.updateTmax = tmax['updatetmax']
                            updateTplan.save()
                    else:
                        createTplan = UserTestPlan.objects.create(
                            user_id = user,
                            plan_id = '9999',
                            userplan_id = '9999',
                            exerciseId_id = tmax['id'],
                            exerciseName = tmax['exerciseName'],
                            workWeight = tmax['updatetmax'],
                            tmax = tmax['updatetmax'],
                            updateTmax = tmax['updatetmax'],
                            workoutTestDate = today
                        )
                        createTplan.save()
                        print(tmax['id'],"123445")
                return JsonResponse({"success":True,"message":"Tmax Updated"})
                #return JsonResponse({"success":False,"message":"No Program"})
        else:
            return JsonResponse({"success":False,"message":"User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getUpdatedTmaxData(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    req = "GET"
    url = "userplan/getUpdatedTmaxData/"
    try:
        if username !='':
            userplanpage = UserPlan.objects.filter(user_id=user, status=1).values('plan_id','id')
            if userplanpage.exists():
                for dt in userplanpage:
                    plan = dict(dt)
                testplanData = UserTestPlan.objects.filter(userplan_id = plan['id'], user_id = user).values('exerciseId_id', 'updateTmax','exerciseName')
                testPlanObj = {}
                for dt in testplanData:
                    dta = dict(dt)
                    testPlanObj[dta['exerciseId_id']] = dta
                return JsonResponse({"success":True, "data":testPlanObj})
            else:
                return JsonResponse({"success":False,"message":"No Program"})
        else:
            return JsonResponse({"success":False,"message":"User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getNextSessionData(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    userID = username['id']
    user=userID
    req="GET"
    url="userplan/getNextSessionData"
    try:
        if username !='':
            userplanpage = UserPlan.objects.filter(user_id=userID, status=1).values('plan_id','id')
            if userplanpage.exists():
                for dt in userplanpage:
                    plan = dict(dt)
                userSetData = UserSets.objects.filter(userplan_id = plan['id']).last()
                testPlanObj = {}
                today = datetime.now().date()
                lastSetDate = userSetData.setDate.date()
                print(today)
                print(lastSetDate)
                delta = lastSetDate - today
                diffDays = delta.days
                print(diffDays)
                numMondays = num_mondays_between(lastSetDate, today)
                print(numMondays)
                todayNumber = date.today().weekday() + 1
                print(todayNumber)
                userSetMicroCycle = userSetData.microcycle_id
                nextMicroCycle = userSetMicroCycle + numMondays
                x = connection.cursor()
                sessionSql = "SELECT * FROM Plan_plansession WHERE microcycle_id = " + str(nextMicroCycle)
                x.execute(sessionSql)
                resultQuery = dictfetchall(x)
                for dt in resultQuery:
                    sessObj = dict(dt)
                    todayNumber = todayNumber - sessObj['restTime']
                    if todayNumber <= 0:
                        break
                return JsonResponse({"success":True, "data":sessObj})
            else:
                return JsonResponse({"success":False,"message":"No Program"})
        else:
            return JsonResponse({"success":False,"message":"User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg": str(e)})

def num_mondays_between( start, end):

   num_weeks, remainder = divmod( (end-start).days, 7)

   if start.weekday() == 0:  # start is monday
       # one monday for each week between plus start
       return num_weeks + 1
   elif ( 7 - start.weekday() ) <= remainder:
       # the closer start is to a monday, a smaller remainder has a monday
       return num_weeks + 1
   else:
       return num_weeks

@never_cache
def plansubscriptions(request):
    dataArr = []
    users = User.objects.values('id','date_joined','username')
    for dt in users:
        data = dict(dt)
        data['num_of_registrations']  = len(users)
    #registraionsPerDay.append({"num_of_registrations": data['num_of_registrations']})
    userplans = UserPlan.objects.values('id','createdDate')
    for plan in userplans:
        planObj = dict(plan)
        planObj['num_of_plansubscriptions'] = len(userplans)
    #subscriptionsPerDay.append({"num_of_plansubscriptions": planObj['num_of_plansubscriptions']})
    userTmax = UserTestPlan.objects.values('user','createdDate')
    for tmax in userTmax:
        tmaxObj = dict(tmax)
        tmaxObj['num_of_tmaxtests'] = len(userTmax)
    #tmaxPerDay.append({"num_of_tmaxtests": tmaxObj['num_of_tmaxtests']})
    dataArr.append({"num_of_registrations": data['num_of_registrations'],"num_of_plansubscriptions": planObj['num_of_plansubscriptions'],"num_of_tmaxtests": tmaxObj['num_of_tmaxtests']})
    #print(dataArr)
    return JsonResponse({"success":True,"details":dataArr})


@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def createUserTestingData(request):
    #user = request.session['user_id']
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    #testInfos = json.loads(request.body.decode('utf-8'))
    #req=testInfos
    url="userplan/createUserTestingData"
    try:
        if username != None:
            userplanpage = UserPlan.objects.select_related('Plan__id','ProgramType__id').filter(user_id = user,status = 1).values('plan_id', 'id','plan_id__programType')
            if userplanpage.exists():
                for dt in userplanpage:
                    dataObj = dict(dt)
                planID = dataObj['plan_id']
                programType = dataObj['plan_id__programType']
                if programType == 1:
                    userTestPlanDetails = UserTestPlan.objects.filter(user_id=user).values('id', 'exerciseName','exerciseId_id', 'workWeight','updateTmax')
                    dataArr = []
                    count = len(userTestPlanDetails)
                    for dt in userTestPlanDetails:
                        dataObj = dict(dt)
                        dataObj['tmaxValue'] = dataObj['workWeight']
                        dataArr.append(dataObj)
                    exArr = []
                    planObj = Plan.objects.get(id=planID)
                    exercises = PlanExcercise.objects.select_related('Exercise__id', 'Plan_Sessions', 'Plan_Microcycles','Plan_Mesocycle', 'Plan_Period', 'Plan').filter(session_id__microcycle_id__mesocycle_id__period_id__plan=planObj.id).values('exerciseName__id','exerciseName__exerciseName').order_by('exerciseName__id').order_by('id')[:2]
                    for ex in exercises:
                        exObj = dict(ex)
                        if exObj['exerciseName__id'] == 1:
                            exArr.append(exObj)
                        elif exObj['exerciseName__id'] == 2:
                            exArr.append(exObj)
                            # print(exArr,"exercises")
                    mainEx = NewExercise.objects.select_related('Videos__id').filter(id__in=[1, 2]).values('exerciseName','exerciseDesc','equipment','video_id', 'video__videoLink')
                    mainExArr = []
                    for mex in mainEx:
                        mexObj = dict(mex)
                        mainExArr.append(mexObj)
                    return JsonResponse(
                        {"success": True, "programType": planObj.programType_id, "count": count, "isTmaxSet": True,"tmaxDetails": dataArr, "exArr": exArr, "mainExArr": mainExArr})
                else:
                    print("Testing Advanced Plan Details")
                    return JsonResponse({"success":False,"status":2})
            else:
                return JsonResponse({"success": True, "message": "Please Subscribe to a Plan"})
        else:
            return JsonResponse({"success": True, "meaasge": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, 'GET', url, str(e))
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def creatingTmax(request):
    #user = request.session['user_id']
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    testInfos = json.loads(request.body.decode('utf-8'))
    req=testInfos
    url="userplan/creatingTmax"
    try:
        #print(testInfos['tmaxDetails'])
        if username != None:
            userplanpage = UserPlan.objects.filter(user_id=user, status=1).values('plan_id','id')
            today = datetime.now().date().strftime("%Y-%m-%d")
            print(today)
            for dt in userplanpage:
                dataObj = dict(dt)
                planId = dataObj['plan_id']
                #print(dataObj)
            planExerciseDetails = PlanExcercise.objects.select_related('PlanSession','Microcycle','PlanMesocycle','PlanPeriods','Plan','Exercise').filter(session_id__microcycle_id__mesocycle_id__period_id__plan_id__id = planId).values('exerciseName_id__id','exerciseName_id__exerciseName','exerciseName_id__workFormula')
            for ex in planExerciseDetails:
                exObj = dict(ex)
                exName = exObj['exerciseName_id__exerciseName']
                exId = exObj['exerciseName_id__id']
                exFormula = exObj['exerciseName_id__workFormula']
                print(exObj['exerciseName_id__workFormula'])
                tmaxExist = UserTestPlan.objects.filter(exerciseId_id = exId, user_id = user).values()
                if tmaxExist.exists():
                    tmaxObj = UserTestPlan.objects.get(user_id = user, exerciseId_id = exId)
                    tmaxObj.plan_id = planId
                    tmaxObj.userplan_id = dataObj['id']
                    tmaxObj.exerciseName = exName
                    tmaxObj.workWeight = testInfos['workWeight']
                    tmaxObj.updateTmax = testInfos['workWeight']
                    tmaxObj.workoutTestDate = timezone.now()
                    tmaxObj.save()
                else:
                    userTestPlanDetails = UserTestPlan.objects.create(
                        user_id=user,
                        plan_id =dataObj['plan_id'],
                        userplan_id=dataObj['id'],
                        exerciseName=exName,
                        workWeight=int(testInfos['workWeight']),
                        updateTmax=round(int(testInfos['workWeight'])*int(exFormula)),
                        workoutTestDate=timezone.now(),
                        exerciseId_id = exId
                    )
                    userTestPlanDetails.save()
            return JsonResponse({"success": True, "message": "User Test Program Saved Successfully"})
        else:
            return JsonResponse({"success": True, "meaasge": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getUpdatedTmax(request):
    #user = request.session['user_id']
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    url="userplan/getUpdatedTmax"
    try:
        if username != None:
            tmaxArr = []
            tmaxExist = UserTestPlan.objects.filter(user_id = user).values('exerciseId_id', 'exerciseName', 'updateTmax')
            if tmaxExist.exists():
                for tmax in tmaxExist:
                    tmaxObj = dict(tmax)
                    tmaxArr.append(tmaxObj)
                return JsonResponse({"success":True,"details":tmaxArr})
            else:
                return JsonResponse({"success":False,"message":"you do not have any updated values"})
        else:
            return JsonResponse({"success": True, "meaasge": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, "GET", url, str(e))
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def appAnalytics(request):
    # user = request.session['user_id']
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        userInfo = json.loads(request.body.decode('utf-8'))
        user = username['id']
        combo = False
        x = connection.cursor()
        if username != '':
            userplanpage = UserPlan.objects.filter(user_id=user,status =1).values('plan_id', 'id').last()
            if userplanpage:
                uservalues ="SELECT `Userplan_userexercise`.`exerciseName`, `Userplan_userexercise`.`exerciseWorkWeight`, `Userplan_userexercise`.`totalReps`, `Userplan_userexercise`.`id`, `Userplan_userexercise`.`exerciseId_id`, `utility_exercise`.`exerciseName`, `Userplan_userexercise`.`session_id`, `Userplan_userexercise`.`totalSets`, `Userplan_userexercise`.`intensity`, `utility_exercise`.`workFormula`, `Userplan_userexercise`.`microcycle_id` FROM `Userplan_userexercise`  INNER JOIN `utility_exercise` ON (`Userplan_userexercise`.`exerciseId_id` = `utility_exercise`.`id`) WHERE (`Userplan_userexercise`.`plan_id` = "+str(userplanpage['plan_id'])+" AND `Userplan_userexercise`.`user_id` = "+str(user)+" ) ORDER BY id DESC"
                if 'micro' in userInfo and userInfo['micro'] != 0 and userInfo['micro'] != "0" and userInfo['micro'] != None:
                    uservalues ="SELECT `Userplan_userexercise`.`exerciseName`, `Userplan_userexercise`.`exerciseWorkWeight`, `Userplan_userexercise`.`totalReps`, `Userplan_userexercise`.`id`, `Userplan_userexercise`.`exerciseId_id`, `utility_exercise`.`exerciseName`, `Userplan_userexercise`.`session_id`, `Userplan_userexercise`.`totalSets`, `Userplan_userexercise`.`intensity`, `utility_exercise`.`workFormula`, `Userplan_userexercise`.`microcycle_id` FROM `Userplan_userexercise`  INNER JOIN `utility_exercise` ON (`Userplan_userexercise`.`exerciseId_id` = `utility_exercise`.`id`) WHERE (`Userplan_userexercise`.`plan_id` = "+str(userplanpage['plan_id'])+" AND `Userplan_userexercise`.`user_id` = "+str(user)+") GROUP BY `Userplan_userexercise`.`microcycle_id`,`Userplan_userexercise`.`exerciseId_id`  DESC"
                x.execute(uservalues)
                resultQuery = dictfetchall(x)
                if resultQuery:
                    exerciseDetails = collections.defaultdict(list)
                    actualExData = []
                    bpArr = []
                    sqArr = []
                    opArr = []
                    dlArr = []
                    for dt1 in resultQuery:
                        dataObj = dict(dt1)
                        orm = float(float(int(dataObj['exerciseWorkWeight']) * 0.0333)) + int(
                            dataObj['exerciseWorkWeight'])
                        totalTonnage = float(float(dataObj['exerciseWorkWeight']) * int(dataObj['totalReps'])) / 1000
                        # avgwt = float(totalTonnage*1000)/int(dataObj['totalReps'])
                        # relavgwt = avgwt/orm
                        if dataObj['totalReps'] != 0:
                            avgwt = float(totalTonnage * 1000) / int(dataObj['totalReps'])
                        else:
                            avgwt = 0
                        if orm != 0:
                            relavgwt = avgwt / orm
                        else:
                            relavgwt = 0

                        totalwork = dataObj['workFormula'] * 9.8 * int(dataObj['exerciseWorkWeight']) * int(
                            dataObj['totalReps'])
                        cal = totalwork * 0.238902957619
                        dataObj['orm'] = orm
                        dataObj['totalTonnage'] = totalTonnage
                        dataObj['avgWt'] = avgwt
                        dataObj['relavgwt'] = relavgwt
                        dataObj['totalwork'] = totalwork
                        dataObj['cal'] = cal
                        dataObj['sessionDetails'] = {"orm": dataObj['orm'], "totalTonnage": dataObj['totalTonnage'],"avgWt": dataObj['avgWt'], "relavgwt": dataObj['relavgwt'],"totalwork": dataObj['totalwork'], "cal": dataObj['cal'],"exId": dataObj['exerciseId_id'],"exName": dataObj['exerciseName'],"totalSets": dataObj['totalSets'],"intensity": dataObj['intensity'],"workweight": dataObj['exerciseWorkWeight'],"totalReps": dataObj['totalReps'],"sessionId": dataObj['session_id'],"micro_id":dataObj['microcycle_id']}
                        bpArr.append(dataObj['sessionDetails'])
                        exerciseDetails[dataObj['exerciseName']].append(dataObj['sessionDetails'])
                    '''for dt in exerciseDetails:
                        actualExData.append(exerciseDetails[dt])'''
                    return JsonResponse({"success": True, "exerciseDetails": exerciseDetails})
                else:
                    return JsonResponse({"success": False, "message": "No Exercise detail", "combo": combo})
            else:
                return JsonResponse({"success": False, "message": "No Plan"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def addMealHistory(request):
    # user = request.session['user_id']
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        mealInfo = json.loads(request.body.decode('utf-8'))
        user = username['id']
        print(mealInfo)
        if username != '':
            if 'id' in mealInfo:
                print("id exists")
                mealDetails = Mealplans.objects.filter(id = mealInfo['id'])
                if mealDetails.exists():
                    mealDetailsObj = Mealplans.objects.get(id = mealInfo['id'])
                    mealDetailsObj.mealJson = json.dumps(mealInfo['mealJson'])
                    mealDetailsObj.save()
                    return JsonResponse({"success":True,"message":"Meal updated successfully"})
            else:
                meal = Mealplans.objects.create(
                    mealJson = json.dumps(mealInfo['mealJson']),
                    user_id = user
                )
                meal.save()
                return JsonResponse({"success":True,"message":"Meal Saved Successfully"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getMealHistory(request):
    # user = request.session['user_id']
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        mealInfo = json.loads(request.body.decode('utf-8'))
        user = username['id']
        meals = []
        print(mealInfo)
        if username != '':
            mealDetails = Mealplans.objects.filter(user_id = user, createdDate = mealInfo['mealDate']).values()
            if mealDetails.exists():
                print(mealDetails)
                for meal in mealDetails:
                    mobj = dict(meal)
                    meals.append(mobj)
                return JsonResponse({"success":True,"meals":meals})
            return JsonResponse({"success":True,"meals":meals})
        return JsonResponse({"success":False,"msg":"User not found"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})








        