from django.db import models

# Create your models here.
from django.conf import settings
from django.db import models
from Subscriber.models import User
from Program.models import Plan_Period,Plan_Mesocycle,Plan_Microcycles,Plan_Sessions,Plan,Plan_Actions
from utility.models import Videos, Exercise, NewExercise
# Create your models here.

class UserPlan(models.Model):
    user = models.ForeignKey(User,related_name='planprog',on_delete=models.CASCADE)
    plan = models.ForeignKey(Plan,related_name='planprog',on_delete=models.CASCADE)
    status=models.IntegerField(blank=False,default = 1)
    startDate = models.DateTimeField(blank=True, null=True)
    dayOff = models.IntegerField(default=0, blank=True, null=True)
    endDate = models.DateTimeField(blank=True, null=True)
    renewalDate = models.DateTimeField(blank=True, null=True)
    nextRenewalDate = models.DateTimeField(blank=True,null=True)
    seasonDate = models.DateTimeField(blank=True,null=True)
    microcyclecount = models.IntegerField(blank=True, null=True)
    freetrail = models.BooleanField(blank=True, null=True)
    deviceDate = models.DateTimeField(null=True)
    createdDate = models.DateTimeField(auto_now_add=True)
    updatedDate = models.DateTimeField(auto_now=True)

class UserTestPlan(models.Model):
    user = models.ForeignKey(User,related_name='plansprog',on_delete=models.CASCADE)
    plan = models.ForeignKey(Plan,related_name='plaprog',on_delete=models.CASCADE, blank=True, null=True)
    userplan = models.ForeignKey(UserPlan,related_name='planuser',on_delete=models.CASCADE, blank=True, null=True)
    exerciseId = models.ForeignKey(NewExercise, default=1,related_name='plaexercise',on_delete=models.CASCADE)
    exerciseName = models.CharField(max_length=150, blank=False)
    workWeight = models.IntegerField(blank=False)
    tmax = models.IntegerField(null=True, blank=True)
    workoutTestDate = models.DateTimeField(blank=False)
    updateTmax = models.IntegerField(null=True, blank=True)
    updateType = models.IntegerField(null=True, blank=True)
    createdDate = models.DateTimeField(auto_now_add=True)
    updatedDate = models.DateTimeField(auto_now=True)

class UserPlanCycle(models.Model):
    user = models.ForeignKey(User,related_name='plcycle',on_delete=models.CASCADE)
    plan = models.ForeignKey(Plan,related_name='plancycle',on_delete=models.CASCADE)
    userplan = models.ForeignKey(UserPlan,related_name='plancycle',on_delete=models.CASCADE)
    BP_missed = models.BooleanField(blank=True, null=True)
    BP_recovered = models.BooleanField(blank=True, null=True)
    BP_progressed = models.BooleanField(blank=True, null=True)
    SQAT_missed = models.BooleanField(blank=True, null=True)
    SQAT_recovered = models.BooleanField(blank=True, null=True)
    SQAT_progressed = models.BooleanField(blank=True, null=True)
    OP_missed = models.BooleanField(blank=True, null=True)
    OP_recovered = models.BooleanField(blank=True, null=True)
    OP_progressed = models.BooleanField(blank=True, null=True)
    DL_missed = models.BooleanField(blank=True, null=True)
    DL_recovered = models.BooleanField(blank=True, null=True)
    DL_progressed = models.BooleanField(blank=True, null=True)
    createdDate = models.DateTimeField(auto_now_add=True)
    updatedDate = models.DateTimeField(auto_now=True)




class RegressionRules(models.Model):
    min_rep = models.IntegerField()
    max_rep = models.IntegerField()
    startWeight = models.IntegerField()
    absoluteWeight = models.IntegerField()
    percentWeight = models.IntegerField()
    setPlan = models.BooleanField(default=False)
    setStart = models.IntegerField()
    setEnd = models.IntegerField()
    setIncreament = models.IntegerField()
    repsPerSet = models.IntegerField()
    sessionRepeat = models.IntegerField(null=True)

class Gymuserplans(models.Model):
    plan = models.ForeignKey(Plan, related_name='gymplanid',on_delete=models.CASCADE)
    user = models.ForeignKey(User, related_name='gymuserid',on_delete=models.CASCADE)
    price = models.CharField(max_length=50,null=True,blank=True)
    status = models.SmallIntegerField(default=0)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class Mealplans(models.Model):
    user = models.ForeignKey(User, related_name='mealuserid',on_delete=models.CASCADE)
    mealJson = models.TextField(blank=True,null=True)
    createdDate = models.DateField(auto_now_add=True)

class UserActions(models.Model):
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    plan = models.ForeignKey(Plan, on_delete=models.CASCADE)
    userplan = models.ForeignKey(UserPlan, null=True, blank=True, on_delete=models.CASCADE)
    planaction = models.ForeignKey(Plan_Actions, null=True, blank=True, on_delete=models.CASCADE)
    actionDate = models.DateTimeField(null=True, blank=True)
    exercise = models.ForeignKey(NewExercise, null=True, blank=True, on_delete=models.CASCADE)
    totalReps = models.IntegerField(blank=False)
    actionIntensity = models.IntegerField(blank=True,null=True, default=100)
    actionWorkWeight = models.IntegerField(blank=True, null=True, default=0)
    actionTmax = models.IntegerField(blank=True, null=True, default=0)
    createdDate = models.DateTimeField(auto_now_add=True)
    advTime = models.FloatField(null=True)
    advDistance = models.IntegerField(null=True)
    sessionStatus = models.IntegerField(default=1)
    speed = models.FloatField(null=True,blank=True)
    height = models.FloatField(null=True,blank=True)
    actionStatus = models.SmallIntegerField(null=True)
    actionSkip = models.BooleanField(default = False)
