import os
from django.contrib.auth.models import AbstractBaseUser, BaseUserManager, Permission, User
#from django.core.files.storage import FileSystemStorage
from django.db import models
from django.contrib import admin
from django.utils.translation import gettext_lazy as _
from Company.models import Company

# Create your models here.
from StratFitOrganization.models import Organization, OrganizationAdress,CampainUrls

class SubscriberManager(BaseUserManager):
    def create_user(self, email, password=None, **kwargs):
        if not email:
            raise ValueError('Users must have a valid email address.')

        if not kwargs.get('username'):
            raise ValueError('Users must have a valid username.')

        subscriber = self.model( email=self.normalize_email(email), username=kwargs.get('username'))
        #print(kwargs.get('campaign_id'))

        subscriber.set_password(password)
        subscriber.save()

        return subscriber

    def create_superuser(self, email, password, **kwargs):
        subscriber = self.create_user(email, password, **kwargs)

        subscriber.is_admin = True
        subscriber.is_staff = True
        subscriber.save()

        return subscriber

class User(AbstractBaseUser):
    userType = models.SmallIntegerField(default=2)
    first_name = models.CharField(max_length=50)
    middle_name = models.CharField(max_length=50,null=True,blank=True)
    last_name = models.CharField(max_length=50)
    email = models.EmailField(unique=True)
    username = models.CharField(max_length=50)
    #gender = models.SmallIntegerField(choices=GENDER_TYPE_CHOICES,null=True,blank=True)
    #dob = models.DateField(null=True)
    avatar = models.CharField(max_length=150 ,null=True, blank=True)
    userCover = models.CharField(max_length=150 ,null=True, blank=True)
    phone = models.BigIntegerField(null=True,blank=True)
    phoneCode = models.CharField(max_length=100,null=True,blank=True)
    qualification = models.CharField(max_length=255,null=True,blank=True)
    reference = models.CharField(max_length=50,null=True,blank=True)
    affiliator = models.IntegerField(null=True,blank=True)
    fitnessUserAgentShare = models.FloatField(null=True,blank=True)
    trainerAgentShare = models.FloatField(null=True,blank=True)
    gymAgentShare = models.FloatField(null=True,blank=True)
    secretCode = models.CharField(max_length=255, null=True, blank=True)
    otp = models.CharField(max_length=10, null=True, blank=True)
    is_superuser = models.SmallIntegerField(default=0)
    date_joined = models.DateTimeField(auto_now_add = True)
    updatedDate = models.DateTimeField(auto_now=True)
    is_stuff = models.SmallIntegerField(default=0)
    is_active = models.SmallIntegerField(default=1)
    unSubscribe = models.SmallIntegerField(default=0)
    referUser = models.ForeignKey('self',null=True,related_name='referuid', on_delete=models.CASCADE)
    organization = models.ForeignKey(Organization,default=1, blank=True, null=True, on_delete=models.CASCADE)
    organizationAddress = models.ForeignKey(OrganizationAdress, blank=True, null=True, on_delete=models.CASCADE)
    currencyType = models.CharField(max_length=10,default="INR")
    ip = models.CharField(max_length=255,null=True)
    deviceType = models.CharField(max_length=255,null=True)
    userPrivacy = models.BooleanField(default=True)
    company = models.ForeignKey(Company,default=True, on_delete=models.CASCADE)
    createdBy = models.ForeignKey('self',null=True,related_name="usercreated", on_delete=models.CASCADE)
    modifiedBy = models.ForeignKey('self',null=True,related_name="userupdated", on_delete=models.CASCADE)
    cardio_minutes = models.IntegerField(null=True, blank=True)
    cardio_method = models.CharField(null=True, blank=True,max_length=45)

    objects = SubscriberManager()

    USERNAME_FIELD = 'username'
    REQUIRED_FIELDS = ['username', 'expiration_date']

    def __get_full_name__(self):
        return ' '.join([self.first_name, self.last_name])

    def __get_short_name__(self):
        return self.first_name

    def get_short_name(self):
        return self.first_name

    def has_perm(self, perm, obj=None):
        return True

    def has_module_perms(self, app_label):
        return True

    def is_staff(self):
        return self.is_admin

    def is_authenticated(self):
        """
        Always return True. This is a way to tell if the user has been
        authenticated in templates.
        """
        return True

class UserAddress(models.Model):
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    address1 = models.TextField(null=True,blank=True)
    address2 = models.TextField(null=True,blank=True)
    town = models.CharField(max_length=255,null=True,blank=True)
    city = models.CharField(max_length=255,null=True,blank=True)
    state = models.CharField(max_length=255,null=True,blank=True)
    country = models.IntegerField(null=True,blank=True)
    zipCode = models.CharField(max_length=50,null=True,blank=True)
    timeZone = models.CharField(max_length=155,null=True,blank=True)
    createdDate = models.DateTimeField(auto_now_add=True)
    updatedDate = models.DateTimeField(auto_now=True)

class UserPhoto(models.Model):
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    photoname = models.TextField(null=True,blank=True)
    photo = models.ImageField(upload_to='static', null=True, blank=True)
    photoType = models.SmallIntegerField(null=True)
    createdDate = models.DateTimeField(auto_now_add=True)
    updatedDate = models.DateTimeField(auto_now=True)

class FitnessProfile(models.Model):
    GENDER_MALE = 1
    GENDER_FEMALE = 2
    GENDER_TYPE_CHOICES = (
        (GENDER_MALE, _('Male')),
        (GENDER_FEMALE, _('Female'))
    )
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    trainingLevel = models.IntegerField(default=2)
    gender = models.SmallIntegerField(choices=GENDER_TYPE_CHOICES,null=True,blank=True)
    #age = models.IntegerField(null=True)
    dob = models.DateField(null=True)
    height = models.FloatField(null=True,blank=True)
    heightUnit = models.CharField(max_length=25,null=True)
    weight = models.FloatField(null=True,blank=True)
    weightUnit = models.CharField(max_length=25,null=True)
    createdDate = models.DateTimeField(auto_now_add=True)
    updatedDate = models.DateTimeField(auto_now=True)

class trainerProfile(models.Model):
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    aboutTrainer = models.TextField(blank=True,null=True)
    specializations = models.TextField(blank=True,null=True)
    accreditations = models.TextField(blank=True,null=True)
    strengthBP = models.IntegerField(blank=True, null=True)
    status = models.BooleanField(default=False)
    strengthSQAT = models.IntegerField(blank=True, null=True)
    strengthOP = models.IntegerField(blank=True, null=True)
    strengthDL = models.IntegerField(blank=True, null=True)
    plansPublished = models.IntegerField(default=0)
    trainerVerification = models.BooleanField(default=False)
    trainerLikes = models.IntegerField(default=0)
    trainerCover = models.CharField(max_length=255,null=True)
    secretCode = models.CharField(max_length=255, null=True, blank=True)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class trainerVideos(models.Model):
    trainer = models.ForeignKey(User, on_delete=models.CASCADE)
    videoLink = models.CharField(max_length=255)
    status = models.BooleanField(default=True)
    createdDate = models.DateTimeField(auto_now_add=True)

class trainerClients(models.Model):
    trainer = models.ForeignKey(User, related_name='trainer_id', on_delete=models.CASCADE)
    client = models.ForeignKey(User, related_name='client_id', on_delete=models.CASCADE)
    createdDate = models.DateTimeField(auto_now_add=True)

class goals(models.Model):
    level= models.IntegerField(blank=True, null=True, default=0)
    purpose=models.CharField(max_length=255,null=True)
    user=models.ForeignKey(User, on_delete=models.CASCADE)

class Userfollow(models.Model):
    followingUser = models.ForeignKey(User, related_name='Following_User_id', on_delete=models.CASCADE)
    followerUser = models.ForeignKey(User, related_name='Follower_User_id', on_delete=models.CASCADE)
    status = models.SmallIntegerField(default=1)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class Userfriends(models.Model):
    STRATFIT_USER = 1
    NONSTRATFIT_USER = 2
    USER_TYPE_CHOICES = (
        (STRATFIT_USER, _('User Exists in Stratfit')),
        (NONSTRATFIT_USER, _('User does not exist in Stratfit'))
    )
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    name = models.CharField(max_length=200, blank=True, null=True)
    email = models.CharField(max_length=200, blank=True, null=True)
    status = models.SmallIntegerField(choices=USER_TYPE_CHOICES,null=True,blank=True)

'''class trainerRating(models.Model):
    trainer = models.ForeignKey(User, related_name='rating_trainer_id')
    user = models.ForeignKey(User, related_name='user_id')
    rating = models.FloatField()
    createdDate = models.DateTimeField(auto_now_add=True)'''

class Invitations(models.Model):
    name = models.CharField(max_length=100)
    email = models.EmailField()
    secretCode = models.CharField(max_length=255, null=True, blank=True)
    userType = models.IntegerField(default=3)

class SocialProfile(models.Model):
    user = models.ForeignKey(User,related_name='scuser',blank=True, null=True, on_delete=models.CASCADE)
    socailName = models.CharField(max_length=150)
    socialUrl = models.TextField(blank=True, null=True)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now_add=True)

class OrganizationSocialProfile(models.Model):
    user = models.ForeignKey(User,related_name='org_user',null=True, on_delete=models.CASCADE)
    organization = models.ForeignKey(Organization,related_name='orguser', on_delete=models.CASCADE)
    socailName = models.CharField(max_length=150)
    socialUrl = models.TextField(blank=True, null=True)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now_add=True)

class AccountDetails(models.Model):
    status = models.SmallIntegerField(default=0)
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    default = models.BooleanField(default=False)
    bankName = models.CharField(max_length=144)
    accountHolderName = models.CharField(max_length=155)
    accountNumber = models.CharField(max_length=50)
    ifscCode = models.CharField(max_length=50)
    swiftCode = models.CharField(max_length=50,null=True)
    idProof = models.CharField(max_length=255)
    bankAdress = models.CharField(max_length=255,null=True)
    country = models.IntegerField(null=True, blank=True)
    state = models.CharField(max_length=255,null=True)
    city = models.CharField(max_length=255,null=True)
    zipcode = models.CharField(max_length=255,null=True)

class UserReferral(models.Model):
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    referralCode = models.CharField(max_length=60)
    status = models.IntegerField(default=0)
    createdDate = models.DateTimeField(auto_now_add=True)
    expiryDate = models.DateTimeField(blank=True,null=True)


class UserLikes(models.Model):
    user = models.ForeignKey(User, related_name='ul_user', on_delete=models.CASCADE)
    likedUser = models.ForeignKey(User, related_name='lkd_user', on_delete=models.CASCADE)
    createdDate = models.DateTimeField(auto_now_add=True)

class UserPlateWeight(models.Model):
    user = models.ForeignKey(User, related_name='pl_user', on_delete=models.CASCADE)
    weight = models.FloatField(null=True, blank=True)
    count = models.FloatField(null=True, blank=True)
    barbell = models.IntegerField(null=True, blank=True)
    status = models.IntegerField(default=1)
    index = models.IntegerField(null=True)

class UsersValidSessions(models.Model):
    user = models.ForeignKey(User, related_name='sess_user', on_delete=models.CASCADE)
    sessionToken = models.TextField()

class CampaignDetails(models.Model):
    user = models.ForeignKey(User, related_name='camp_user',null=True, blank=True, on_delete=models.CASCADE)
    campaign = models.ForeignKey(CampainUrls, on_delete=models.CASCADE)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class News_letter(models.Model):
    news_letter_email=models.EmailField(unique=True)
    subscriber_status=models.IntegerField(default=1) 
