# Generated by Django 4.1.5 on 2023-04-08 12:39

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('StratFitOrganization', '0001_initial'),
        ('Company', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Invitations',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('email', models.EmailField(max_length=254)),
                ('secretCode', models.CharField(blank=True, max_length=255, null=True)),
                ('userType', models.IntegerField(default=3)),
            ],
        ),
        migrations.CreateModel(
            name='News_letter',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('news_letter_email', models.EmailField(max_length=254, unique=True)),
                ('subscriber_status', models.IntegerField(default=1)),
            ],
        ),
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('userType', models.SmallIntegerField(default=2)),
                ('first_name', models.CharField(max_length=50)),
                ('middle_name', models.CharField(blank=True, max_length=50, null=True)),
                ('last_name', models.CharField(max_length=50)),
                ('email', models.EmailField(max_length=254, unique=True)),
                ('username', models.CharField(max_length=50)),
                ('avatar', models.CharField(blank=True, max_length=150, null=True)),
                ('userCover', models.CharField(blank=True, max_length=150, null=True)),
                ('phone', models.BigIntegerField(blank=True, null=True)),
                ('phoneCode', models.CharField(blank=True, max_length=100, null=True)),
                ('qualification', models.CharField(blank=True, max_length=255, null=True)),
                ('reference', models.CharField(blank=True, max_length=50, null=True)),
                ('affiliator', models.IntegerField(blank=True, null=True)),
                ('fitnessUserAgentShare', models.FloatField(blank=True, null=True)),
                ('trainerAgentShare', models.FloatField(blank=True, null=True)),
                ('gymAgentShare', models.FloatField(blank=True, null=True)),
                ('secretCode', models.CharField(blank=True, max_length=255, null=True)),
                ('otp', models.CharField(blank=True, max_length=10, null=True)),
                ('is_superuser', models.SmallIntegerField(default=0)),
                ('date_joined', models.DateTimeField(auto_now_add=True)),
                ('updatedDate', models.DateTimeField(auto_now=True)),
                ('is_stuff', models.SmallIntegerField(default=0)),
                ('is_active', models.SmallIntegerField(default=1)),
                ('unSubscribe', models.SmallIntegerField(default=0)),
                ('currencyType', models.CharField(default='INR', max_length=10)),
                ('ip', models.CharField(max_length=255, null=True)),
                ('deviceType', models.CharField(max_length=255, null=True)),
                ('userPrivacy', models.BooleanField(default=True)),
                ('company', models.ForeignKey(default=True, on_delete=django.db.models.deletion.CASCADE, to='Company.company')),
                ('createdBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='usercreated', to='Subscriber.user')),
                ('modifiedBy', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='userupdated', to='Subscriber.user')),
                ('organization', models.ForeignKey(blank=True, default=1, null=True, on_delete=django.db.models.deletion.CASCADE, to='StratFitOrganization.organization')),
                ('organizationAddress', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='StratFitOrganization.organizationadress')),
                ('referUser', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='referuid', to='Subscriber.user')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='UsersValidSessions',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sessionToken', models.TextField()),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='sess_user', to='Subscriber.user')),
            ],
        ),
        migrations.CreateModel(
            name='UserReferral',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('referralCode', models.CharField(max_length=60)),
                ('status', models.IntegerField(default=0)),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('expiryDate', models.DateTimeField(blank=True, null=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='Subscriber.user')),
            ],
        ),
        migrations.CreateModel(
            name='UserPlateWeight',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('weight', models.FloatField(blank=True, null=True)),
                ('count', models.FloatField(blank=True, null=True)),
                ('barbell', models.IntegerField(blank=True, null=True)),
                ('status', models.IntegerField(default=1)),
                ('index', models.IntegerField(null=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='pl_user', to='Subscriber.user')),
            ],
        ),
        migrations.CreateModel(
            name='UserPhoto',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('photoname', models.TextField(blank=True, null=True)),
                ('photo', models.ImageField(blank=True, null=True, upload_to='static')),
                ('photoType', models.SmallIntegerField(null=True)),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('updatedDate', models.DateTimeField(auto_now=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='Subscriber.user')),
            ],
        ),
        migrations.CreateModel(
            name='UserLikes',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('likedUser', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='lkd_user', to='Subscriber.user')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='ul_user', to='Subscriber.user')),
            ],
        ),
        migrations.CreateModel(
            name='Userfriends',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=200, null=True)),
                ('email', models.CharField(blank=True, max_length=200, null=True)),
                ('status', models.SmallIntegerField(blank=True, choices=[(1, 'User Exists in Stratfit'), (2, 'User does not exist in Stratfit')], null=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='Subscriber.user')),
            ],
        ),
        migrations.CreateModel(
            name='Userfollow',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.SmallIntegerField(default=1)),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
                ('followerUser', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='Follower_User_id', to='Subscriber.user')),
                ('followingUser', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='Following_User_id', to='Subscriber.user')),
            ],
        ),
        migrations.CreateModel(
            name='UserAddress',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('address1', models.TextField(blank=True, null=True)),
                ('address2', models.TextField(blank=True, null=True)),
                ('town', models.CharField(blank=True, max_length=255, null=True)),
                ('city', models.CharField(blank=True, max_length=255, null=True)),
                ('state', models.CharField(blank=True, max_length=255, null=True)),
                ('country', models.IntegerField(blank=True, null=True)),
                ('zipCode', models.CharField(blank=True, max_length=50, null=True)),
                ('timeZone', models.CharField(blank=True, max_length=155, null=True)),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('updatedDate', models.DateTimeField(auto_now=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='Subscriber.user')),
            ],
        ),
        migrations.CreateModel(
            name='trainerVideos',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('videoLink', models.CharField(max_length=255)),
                ('status', models.BooleanField(default=True)),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('trainer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='Subscriber.user')),
            ],
        ),
        migrations.CreateModel(
            name='trainerProfile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('aboutTrainer', models.TextField(blank=True, null=True)),
                ('specializations', models.TextField(blank=True, null=True)),
                ('accreditations', models.TextField(blank=True, null=True)),
                ('strengthBP', models.IntegerField(blank=True, null=True)),
                ('status', models.BooleanField(default=False)),
                ('strengthSQAT', models.IntegerField(blank=True, null=True)),
                ('strengthOP', models.IntegerField(blank=True, null=True)),
                ('strengthDL', models.IntegerField(blank=True, null=True)),
                ('plansPublished', models.IntegerField(default=0)),
                ('trainerVerification', models.BooleanField(default=False)),
                ('trainerLikes', models.IntegerField(default=0)),
                ('trainerCover', models.CharField(max_length=255, null=True)),
                ('secretCode', models.CharField(blank=True, max_length=255, null=True)),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='Subscriber.user')),
            ],
        ),
        migrations.CreateModel(
            name='trainerClients',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('client', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='client_id', to='Subscriber.user')),
                ('trainer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='trainer_id', to='Subscriber.user')),
            ],
        ),
        migrations.CreateModel(
            name='SocialProfile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('socailName', models.CharField(max_length=150)),
                ('socialUrl', models.TextField(blank=True, null=True)),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now_add=True)),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='scuser', to='Subscriber.user')),
            ],
        ),
        migrations.CreateModel(
            name='OrganizationSocialProfile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('socailName', models.CharField(max_length=150)),
                ('socialUrl', models.TextField(blank=True, null=True)),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now_add=True)),
                ('organization', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='orguser', to='StratFitOrganization.organization')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='org_user', to='Subscriber.user')),
            ],
        ),
        migrations.CreateModel(
            name='goals',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('level', models.IntegerField(blank=True, default=0, null=True)),
                ('purpose', models.CharField(max_length=255, null=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='Subscriber.user')),
            ],
        ),
        migrations.CreateModel(
            name='FitnessProfile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('trainingLevel', models.IntegerField(default=2)),
                ('gender', models.SmallIntegerField(blank=True, choices=[(1, 'Male'), (2, 'Female')], null=True)),
                ('dob', models.DateField(null=True)),
                ('height', models.FloatField(blank=True, null=True)),
                ('heightUnit', models.CharField(max_length=25, null=True)),
                ('weight', models.FloatField(blank=True, null=True)),
                ('weightUnit', models.CharField(max_length=25, null=True)),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('updatedDate', models.DateTimeField(auto_now=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='Subscriber.user')),
            ],
        ),
        migrations.CreateModel(
            name='CampaignDetails',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
                ('campaign', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='StratFitOrganization.campainurls')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='camp_user', to='Subscriber.user')),
            ],
        ),
        migrations.CreateModel(
            name='AccountDetails',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.SmallIntegerField(default=0)),
                ('default', models.BooleanField(default=False)),
                ('bankName', models.CharField(max_length=144)),
                ('accountHolderName', models.CharField(max_length=155)),
                ('accountNumber', models.CharField(max_length=50)),
                ('ifscCode', models.CharField(max_length=50)),
                ('swiftCode', models.CharField(max_length=50, null=True)),
                ('idProof', models.CharField(max_length=255)),
                ('bankAdress', models.CharField(max_length=255, null=True)),
                ('country', models.IntegerField(blank=True, null=True)),
                ('state', models.CharField(max_length=255, null=True)),
                ('city', models.CharField(max_length=255, null=True)),
                ('zipcode', models.CharField(max_length=255, null=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='Subscriber.user')),
            ],
        ),
    ]
