import base64
import json
from datetime import date
from random import choice
from dateutil.relativedelta import relativedelta
from django.contrib.auth.hashers import make_password
from django.core.mail import EmailMultiAlternatives
from django.db import connection
from django.db.models import Q
from django.forms import model_to_dict
from django.http import HttpResponse
from django.http import JsonResponse
from django.shortcuts import render

# Create your views here.
from django.template.loader import render_to_string
from django.views.decorators.cache import never_cache
try: # for pip >= 10
    from pip._internal.req.req_install import logger
except ImportError: # for pip <= 9.0.3
    from pip.req.req_install import logger

from rest_framework.decorators import api_view, authentication_classes
from Celebrity.models import CelebrityPlansLikes
#from Celebrity.models import CelebrityPlansReviews

from Plan.models import Plan, SelectedAbilities, PlanGoals, PlanCountry, GymCountry
from Plan.views import celeblikes
from Plan.views import celebreviewList
from StratFit.settings import PAGING_ROWS, S3URL
from Subscriber.Authentication import SessionAuthentication, IsAuthenticated, StartFitSessionUtil
from Subscriber.models import User, UserAddress, OrganizationSocialProfile
from StratFitOrganization.models import Organization, OrganizationAdress
from Userplan.models import UserPlan, Gymuserplans, UserSets
from Subscriber.views import exceptionMail
from payment.models import OrderDetail
from utility.models import PartnerType, Country,PriceMapping,PriceConversion
from utility.views import officeMail
import requests


@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def createGym(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    data = json.loads(request.body.decode('utf-8'))
    req=data
    url="startorg/creategym/"
    try:
        print(data)
        if username != None:
            gymName1 = " ".join(data['gymName'].split())
            existingDetails = Organization.objects.filter(gymName = gymName1).values('id')
            if 'id' in data:
                print('+++++++++update+++++++++')
                gym = Organization.objects.get(pk = data['id'])
                gym.gymName = gymName1
                gym.aboutGym = data['aboutGym']
                gym.gymType = data['gymType']
                gym.num_of_users = data['num_of_users']
                gym.num_of_trainers = data['num_of_trainers']
                gym.fitbaseid=data['fitbaseid']
                gym.save()
                gymAdress = OrganizationAdress.objects.get(pk = data['orgAdid'])
                gymAdress.country = data['country']
                gymAdress.state = data['state']
                gymAdress.town = data['city']
                gymAdress.address = data['address']
                gymAdress.location = data['location']
                gymAdress.save()
                return JsonResponse({"success":True,"message": "Gym information updated successfully"})
            else:
                print('+++++++++create+++++++++')
                if existingDetails.exists():
                    return JsonResponse({"success": False, "message": "Organization already exists"})
                gymDetails = Organization.objects.create(
                    gymName = gymName1,
                    createdBy = user,
                    modifiedBy = user,
                    gymType = data['gymType']
                )
                if 'aboutGym' in data and data['aboutGym'] !='':
                     gymDetails.aboutGym = data['aboutGym']
                else:
                    gymDetails.aboutGym = None
                if 'phone' in data and data['phone'] !='':
                     gymDetails.phone = data['phone']
                else:
                    gymDetails.phone = None
                if 'weburl' in data and data['weburl'] !='':
                     gymDetails.webUrl = data['weburl']
                else:
                    gymDetails.webUrl = None
                if 'num_of_users' in data and data['num_of_users'] !='':
                    gymDetails.num_of_users = data['num_of_users']
                else:
                    gymDetails.num_of_users = None
                if 'num_of_trainers' in data and data['num_of_trainers'] !='':
                    gymDetails.num_of_trainers = data['num_of_trainers']
                else:
                    gymDetails.num_of_trainers = None
                if 'socialMediaDetails' in data and data['socialMediaDetails'] !='':
                    gymDetails.socialMediaDetails = data['socialMediaDetails']
                else:
                    gymDetails.socialMediaDetails = None
                gymDetails.save()
                orgAdress = OrganizationAdress.objects.create(
                    organization_id = gymDetails.id,
                    createdBy=user,
                    modifiedBy=user
                )
                if 'address' in data and data['address'] !='':
                    orgAdress.address = data['address']
                else:
                    orgAdress.address = None
                if 'city' in data and data['city'] !='':
                    orgAdress.town = data['city']
                else:
                    gymDetails.town = None
                if 'latitutde' in data and data['latitutde'] !='':
                    orgAdress.latitutde = data['latitutde']
                else:
                    orgAdress.latitutde = None
                if 'longitude' in data and data['longitude'] !='':
                    orgAdress.longitude = data['longitude']
                else:
                    orgAdress.longitude = None
                if 'location' in data and data['location'] !='':
                    orgAdress.location = data['location']
                else:
                    orgAdress.location = None
                if 'country' in data and data['country'] !='':
                    orgAdress.country = data['country']
                else:
                    orgAdress.location = None
                if 'state' in data and data['state'] !='':
                    orgAdress.state = data['state']
                else:
                    orgAdress.state = None
                orgAdress.save()
                return JsonResponse({"success":True,"message":"Gym Created Successfully"})
        else:
            return JsonResponse({"success":False,"message":"user logged out"})
    except Exception as e:
        logger.error("error")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def createUser(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    userInfo = json.loads(request.body.decode('utf-8'))
    req=userInfo
    url="startorg/createuser/"
    try:
        if username != None:
            orgId = username['organization']
            userType = username['userType']
            print(userInfo)
            if 'editid' in userInfo:
                if 'email' in userInfo['upuser'] and userInfo['upuser']['email'] != '':
                    userExists = User.objects.filter(email=userInfo['upuser']['email'])
                    if userExists.exists():
                        return JsonResponse({"success": True, "message": "Email Exists "})
                userInformation = User.objects.get(pk=userInfo['editid'])
                if userType == 6:
                    if 'usertype' in userInfo['upuser'] and userInfo['upuser']['usertype']!= '':
                        userInformation.userType = userInfo['upuser']['usertype']
                    if 'useradd' in userInfo['upuser'] and userInfo['upuser']['useradd']!= '':
                        userInformation.organizationAddress_id = userInfo['upuser']['useradd']
                userInformation.first_name = userInfo['upuser']['fName']
                userInformation.last_name = userInfo['upuser']['lName']
                userInformation.phone = userInfo['upuser']['phone']
                #if 'password' in userInfo and userInfo['upuser']['password'] != '' and userInfo['upuser']['password'] != None:
                #    userInformation.password = make_password(userInfo['upuser']['password'])
                userInformation.is_active = 1
                userInformation.save()
                return JsonResponse({"success": True, "message": "User Updated successfully "})

            if 'userUnqId' in userInfo:
                if 'planid' in userInfo and userInfo['planid'] !='' and userInfo['planid'] != None:
                    existinguserplan = Gymuserplans.objects.filter(user_id = userInfo['userUnqId'])
                    if existinguserplan.exists():
                        updateuserplan = Gymuserplans.objects.get(user_id = userInfo['userUnqId'])
                        updateuserplan.plan_id = userInfo['planid']
                        updateuserplan.save()
                        return JsonResponse({"success": True, "message": "Program assigned successfully"})
                    else:
                        createuserplan = Gymuserplans.objects.create(
                            user_id = userInfo['userUnqId'],
                            plan_id = userInfo['planid'],
                        )
                        createuserplan.save()
                        return JsonResponse({"success": True, "message": "Program assigned successfully"})
            else:
                try:
                    existingusers = User.objects.filter(email = userInfo['email'])
                    if existingusers.exists():
                        return JsonResponse({"success":False,"message":"Email Already Exists"})
                    else:
                        userInformation = User.objects.create(
                            createdBy_id = user,
                            modifiedBy_id = user,
                            first_name = userInfo['first_name'],
                            email = userInfo['email'],
                            username = userInfo['email'],
                            #password = make_password(userInfo['pword']),
                            is_active = 0,
                            organization_id = orgId
                        )
                        if userType ==6:
                            if 'usertype' in userInfo and userInfo['usertype']!='':
                                userInformation.userType = userInfo['usertype']
                            if 'useradd' in userInfo and userInfo['useradd']!='':
                                userInformation.organizationAddress_id = userInfo['useradd']
                        elif userType ==9:
                            useradd = User.objects.get(id=user)
                            userInformation.userType = 7
                            userInformation.organizationAddress_id = useradd.organizationAddress_id
                        else:
                            userInformation.userType = 7
                        if 'last_name' in userInfo and userInfo['last_name'] !='':
                            userInformation.last_name = userInfo['last_name']
                        else:
                            userInformation.last_name =None
                        if 'phone' in userInfo and userInfo['phone'] !='':
                            userInformation.phone = userInfo['phone']
                        else:
                            userInformation.phone =None
                        userInformation.save()
                        orgname = Organization.objects.get(id = userInformation.organization_id)
                        instanceSub = User.objects.get(email=userInformation.email)
                        randomCode = ''.join(choice('0123456789ABCDEF') for i in range(6))
                        # print(randomCode)
                        secret_code_plain = instanceSub.email + '#' + str(randomCode)
                        secret_code_encode = base64.b64encode(secret_code_plain.encode('ascii'))
                        # print(secret_code_encode)
                        validateLink = request.META['HTTP_HOST']
                        link = "http://" + validateLink + "/#/accountvalidate/" + secret_code_encode.decode("utf-8")
                        subject = "Set Password"
                        to_email = instanceSub.email
                        ctx = {
                            'first_name': instanceSub.first_name,
                            'link': link,
                            'gymName': orgname.gymName,
                            'rand': str(randomCode)
                        }
                        message = render_to_string('gymuserverification.html', ctx)
                        officeMail(subject, message, to_email)
                        '''msg = EmailMultiAlternatives(subject, message, from_email, [to_email])
                        msg.attach_alternative(message, "text/html")
                        msg.send()'''
                        instanceSub.secretCode = secret_code_encode
                        instanceSub.otp = str(randomCode)
                        instanceSub.save()
                except Exception as e:
                    return JsonResponse(str(e),safe = False)

                if 'plan' in userInfo and userInfo['plan'] !='' and userInfo['plan'] != None:
                    existinguserplan = Gymuserplans.objects.filter(user_id=userInformation.id)
                    print("came HEre")
                    try:
                        if existinguserplan.exists():
                            updateuserplan = Gymuserplans.objects.get(user_id = userInformation.id)
                            updateuserplan.plan_id = userInfo['plan']
                        else:
                            createuserplan = Gymuserplans.objects.create(
                                user_id = userInformation.id,
                                plan_id = userInfo['plan'],
                            )
                            createuserplan.save()
                    except Exception as e:
                        exceptionMail(user, req, url, str(e))
                        return JsonResponse(str(e),safe=False)
            return JsonResponse({"success":True,"message":"<p>User Created Successfully.</p><br> <p>Activation mail sent to the given mail Id.</br></p><br>  <p>* User will be activated after the user activates his/her account from the email sent.</br></p> "})
        else:
            return JsonResponse({"success":False,"message":"user logged out"})
    except Exception as e:
        logger.error("error")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def assignPlanstoUsers(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user=username['id']
    pInfo = json.loads(request.body.decode('utf-8'))
    req=pInfo
    url="startorg/assignplanstousers/"
    try:
        if username!=None:
            print(pInfo)
            plan_id = pInfo['plan_id']
            for dt in pInfo['selectedUsers']:
                userid = dt['id']
                existinguserplan = Gymuserplans.objects.filter(user_id = userid).values('id')
                if existinguserplan.exists():
                    updateuserplan = Gymuserplans.objects.get(user_id = userid)
                    updateuserplan.plan_id = plan_id
                    updateuserplan.save()
                else:
                    createuserplan = Gymuserplans.objects.create(
                        user_id = userid,
                        plan_id = plan_id,
                    )
                    createuserplan.save()
            return JsonResponse({"success": True, "message": "Program assigned successfully"})
        else:
            return JsonResponse({"success":False,"message":"user logged out"})
    except Exception as e:
        logger.error("error")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg": str(e)})

'''@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def checkUserPlanStatus(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        if username!=None:
            pInfo = json.loads(request.body.decode('utf-8'))
            #print(pInfo)
            existingStatus = False
            dataArr = []
            userArr = []
            userRange = len(pInfo['gympdata'])
            for i in range(userRange):
                print(i)
                userplanstatus = UserPlan.objects.filter(user_id = pInfo['gympdata'][i]['id']).values('id','plan_id','user_id')
                if userplanstatus.exists():
                    existingStatus = True
                    for dt in userplanstatus:
                        dataObj = dict(dt)
                        dataArr.append(dataObj)
                        updateStatus = UserPlan.objects.get(pk = dataObj['id'])
                        updateStatus.status = 2
                else:
                    user_id = pInfo['gympdata'][i]['id']
                    userValues = {"existingStatus":False,"user_id":user_id}
                    userArr.append(userValues)
            return JsonResponse({"success": True, "existingStatus":existingStatus,"existingData":dataArr,"newusers":userArr})
        else:
            return JsonResponse({"success":False,"message":"user logged out"})
    except Exception as e:
        logger.error("error")
        return JsonResponse({"msg": str(e)})'''

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def userDetails(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    req="GET"
    url="startorg/userDetails/"
    try:
        orgId = username['organization']
        print(request.body,"12345678")
        if username!=None:
            pInfo = json.loads(request.body.decode('utf-8'))
            if 'rows' in pInfo and pInfo['rows'] != '':
                rows = int(pInfo['rows'])
                print(rows)
            else:
                rows = PAGING_ROWS
            if 'page' in pInfo and pInfo['page'] != '':
                page = int(pInfo['page'])
                print(page)
            else:
                page = 1
            offset = (page - 1) * rows
            tot = page * rows
            if username['userType'] ==9:
                users = User.objects.filter(organization_id=orgId, is_active=1,organizationAddress_id = username['organizationAddress']).values('id', 'username', 'email','first_name', 'middle_name','last_name', 'phone','is_active', 'createdBy','userType','organizationAddress_id').order_by('-id').exclude(userType=9)
            else:
                users = User.objects.filter(organization_id =orgId,is_active =1).values('id','username','email','first_name','middle_name','last_name','phone','is_active','createdBy','userType','organizationAddress_id').order_by('-id').exclude(userType =6)
            dataArr = list()
            total = len(users)
            data = users[offset:tot]
            for dt in data:
                dataObj =dict(dt)
                dataObj['payments'] = False
                uplans = UserPlan.objects.select_related('Plan__id').filter(user_id =dataObj['id']).values('status','plan_id__planName','nextRenewalDate')
                if uplans.exists():
                    for upl in uplans:
                        explans = dict(upl)
                        oneweek = explans['nextRenewalDate'] - relativedelta(days=7)
                        beforeoneweek = (oneweek.strftime("%Y-%m-%d"))
                        todaydate = date.today().strftime("%Y-%m-%d")
                        if todaydate >= beforeoneweek:
                            dataObj['payments'] = True
                        else:
                            dataObj['payments'] = False
                        if explans['status'] == 1 or explans['status'] == 3:
                            dataObj['upexists'] = explans['plan_id__planName']
                            dataObj['renewalDate'] = explans['nextRenewalDate'].strftime("%Y-%m-%d")
                        else:
                            dataObj['upexists'] = ""
                            dataObj['renewalDate'] = ""
                else:
                    dataObj['upexists'] = ""
                    dataObj['renewalDate'] = ""
                planDetails = Gymuserplans.objects.select_related('Plan__id').filter(user_id = dataObj['id']).values('id','plan_id','plan_id__planName','plan_id__price','plan_id__proposedState','plan_id__royalty','user_id','plan_id__iosPrice','plan_id__iosStatus')
                if planDetails.exists():
                    for val in planDetails:
                        value = dict(val)
                        dataObj['existingPlanid'] = value['id']
                        dataObj['planprice'] = value['plan_id__price']
                        dataObj['iosPrice'] = value['plan_id__iosPrice']
                        dataObj['iosStatus'] = value['plan_id__iosStatus']
                        dataObj['existingPlanName'] = value['plan_id__planName']
                        dataObj['proposedState'] = value['plan_id__proposedState']
                        dataObj['royalty'] = value['plan_id__royalty']
                else:
                    dataObj['existingPlanid'] = ''
                    dataObj['planprice'] = ''
                    dataObj['iosPrice'] =''
                    dataObj['iosStatus'] =''
                    dataObj['existingPlanName'] = ''
                    dataObj['proposedState'] = ''
                    dataObj['royalty'] = ''
                userssetDetails = UserSets.objects.filter(user_id = dataObj['id']).values('id')
                if userssetDetails.exists():
                    dataObj['userWorkout'] = True
                else:
                    dataObj['userWorkout'] = False
                paymentvalues = OrderDetail.objects.filter(forUser_id = dataObj['id']).values('totalAmount')
                if paymentvalues.exists():
                    dataObj['paymentMade'] = "Paid"
                else:
                    dataObj['paymentMade'] = "Free"
                dataArr.append(dataObj)
            return JsonResponse({"rows":dataArr,"total":total})
        else:
            return JsonResponse({"success": False, "message": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def paymentDetails(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    req="GET"
    url="startorg/paymentDetails/"
    try:
        orgId = username['organization']
        if username!=None:
            if 'rows' in request.POST and request.POST['rows'] != '':
                rows = int(request.POST['rows'])
            else:
                rows = PAGING_ROWS
            if 'page' in request.POST and request.POST['page'] != '':
                page = int(request.POST['page'])
            else:
                page = 1
            offset = (page - 1) * rows
            tot = page * rows
            users = User.objects.filter(organization_id =orgId,is_active =1).values('id','username','email','first_name','middle_name','last_name','phone','is_active').order_by('-id').exclude(userType = 6)
            dataArr = list()
            total = len(users)
            data = users[offset:tot]
            for dt in data:
                dataObj =dict(dt)
                dataObj['payments'] = False
                userPlans = UserPlan.objects.filter(user_id = dataObj['id']).values('id','nextRenewalDate','status')
                if userPlans.exists():
                    for uplan in userPlans:
                        uplans = dict(uplan)
                        dataObj['renewal'] = str(uplans['nextRenewalDate'])[:-14]
                        oneweek = uplans['nextRenewalDate'] - relativedelta(days=7)
                        beforeoneweek = (oneweek.strftime("%Y-%m-%d"))
                        todaydate = date.today().strftime("%Y-%m-%d")
                        if todaydate >= beforeoneweek:
                            dataObj['payments'] = True
                        else:
                            dataObj['payments'] = False
                        if uplans['status'] == 1:
                            dataObj['renewalDate'] = uplans['nextRenewalDate'].strftime("%Y-%m-%d")
                        else:
                            dataObj['renewalDate'] = ""
                else:
                    dataObj['renewalDate'] = ""
                    dataObj['renewal'] = "Plan Transition"
                paymentusers = OrderDetail.objects.filter(forUser_id = dataObj['id']).values('id')
                if paymentusers.exists():
                    dataObj['freeusers'] = False
                else:
                    dataObj['freeusers'] = True
                planDetails = Gymuserplans.objects.select_related('Plan__id','User__id').filter(user_id = dataObj['id']).values('id','plan_id','plan_id__planName','plan_id__price','plan_id__proposedState','plan_id__royalty','plan_id__originalPlanner_id__first_name','plan_id__originalPlanId__price','plan_id__iosPrice','plan_id__iosStatus')
                if planDetails.exists():
                    for val in planDetails:
                        value = dict(val)
                        dataObj['existingPlanid'] = value['plan_id']
                        dataObj['planprice'] = value['plan_id__price']
                        dataObj['iosPrice'] = value['plan_id__iosPrice']
                        dataObj['iosStatus'] = value['plan_id__iosStatus']
                        dataObj['originalPlanprice'] = value['plan_id__originalPlanId__price']
                        dataObj['existingPlanName'] = value['plan_id__planName']
                        dataObj['proposedState'] = value['plan_id__proposedState']
                        dataObj['royalty'] = value['plan_id__royalty']
                        dataObj['coachName'] = value['plan_id__originalPlanner_id__first_name']
                        dataArr.append(dataObj)
            return JsonResponse({"rows":dataArr,"total":total})
        else:
            return JsonResponse({"success": False, "message": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def gymDetails(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    if username != None:
        user = username['id']
    else:
        user = 0
    try:
        data = json.loads(request.body.decode('utf-8'))
        if 'userid' in data and data['userid'] != '':
            userCurrency = User.objects.get(id=data['userid'])
        elif username!=None:
            userCurrency = User.objects.get(id=user)
        else:
            userCurrency = User.objects.get(id=6)
        gymvalues = Organization.objects.filter(gymName = data['OrgName'],status=1).values('gymName','id','num_of_users','num_of_trainers','aboutGym','status','logo','coverImage','webUrl','phone','gymType').order_by('-id').exclude(id=3)
        dataArr = list()
        SocialMediaArr = []
        PlanArr = []
        currencyValues = PriceConversion.objects.get(id=1)
        inrValue = currencyValues.inrValue
        for dt in gymvalues:
            dataObj = dict(dt)
            address = []
            partnerType = PartnerType.objects.get(id = dataObj['gymType'])
            partnerCode = partnerType.partnerTypeCode
            orgAdd = OrganizationAdress.objects.filter(organization_id = dataObj['id']).values('id','state','country','latitutde','longitude','location','phone','address').order_by('-id')
            for org in orgAdd:
                orgObj = dict(org)
                orgCountry = orgObj['country']
                countryVal1 = Country.objects.filter(id=orgCountry).values()
                for cntry in countryVal1:
                    cntryObj = dict(cntry)
                    orgObj['countryName'] = cntryObj['name']
                address.append(orgObj)
                dataObj['orgAddr'] = address
            countryVal = Country.objects.get(id=orgCountry)
            orgState = orgObj['state']
            countryName = countryVal.name
            print(countryName,"sfsf")
            idVal = dataObj['id']
            dataObj['plans'] = []
            dataObj['gymID'] = str(countryName[:2].upper()) + str(orgState[:2].upper()) + str(partnerCode) + "#000" +str(idVal)
            if dataObj['logo'] == '' or dataObj['logo'] == None:
                dataObj['logo1'] = "http://stratfit.net/assets/images/logo.png"
            else:
                dataObj['logo1'] = S3URL + dataObj['logo']
            if dataObj['coverImage'] == '' or dataObj['coverImage'] == None:
                dataObj['cover1'] = "http://stratfit.net/assets/images/SF1.jpg"
            else:
                dataObj['cover1'] = S3URL + dataObj['coverImage']

            userDetails = User.objects.filter(organization_id=dataObj['id'],is_active = 1).values('id').exclude(userType = 6)
            num_of_users = len(userDetails)
            dataObj['num_of_Database_users'] = num_of_users
            socialDetails = OrganizationSocialProfile.objects.filter(organization_id=dataObj['id']).values('socailName','id','organization_id','socialUrl')
            if 'deviceType' in data and data['deviceType'] == 'ios':
                gymPlans = Plan.objects.select_related('User__id','Organization__id').filter(createdBy_id__organization_id=dataObj['id'],planStatus = 1,iosStatus = 1,activationStatus=1).values('id','planName', 'planDescription', 'price','ability', 'createdBy_id__avatar','createdBy_id','createdBy_id__first_name','createdBy_id__last_name','planGoal__goalName', 'duration_weeks','programType_id__programTypeName','planPhoto','licencePolicy','originalPlanner_id__first_name','originalPlanner_id__last_name','originalPlanner_id','iosPrice','iosStatus','planLogo','indianPrice','indianIosPrice').order_by('programType_id','planName')
            else:
                gymPlans = Plan.objects.select_related('User__id','Organization__id').filter(createdBy_id__organization_id=dataObj['id'],planStatus = 1,activationStatus=1).values('id','planName', 'planDescription', 'price','ability', 'createdBy_id__avatar','createdBy_id','createdBy_id__first_name','createdBy_id__last_name','planGoal__goalName', 'duration_weeks','programType_id__programTypeName','planPhoto','licencePolicy','originalPlanner_id__first_name','originalPlanner_id__last_name','originalPlanner_id','iosPrice','iosStatus','planLogo','indianPrice','indianIosPrice').order_by('programType_id','planName')
            username = {}
            username['userCountry'] = 190
            IndianPlanArr = []
            if gymPlans.exists():
                india = False
                for plan in gymPlans:
                    plans = dict(plan)

                    secret_code_plain = plans['planName'] + '#' + str(plans['id'])
                    secret_code_encode = base64.b64encode(secret_code_plain.encode('ascii'))
                    encodedVal = str(secret_code_encode).split("'")
                    plans['encodedurl'] = encodedVal[1]

                    clelebLikes = celeblikes(plans['id'])
                    celebReviews = celebreviewList(plans['id'])
                    plans['planlikes'] = clelebLikes
                    plans['planreviews'] = celebReviews
                    # print(dataObj['planreviews'],"here")

                    plalikescount = CelebrityPlansLikes.objects.filter(plan_id=plans['id'], status=1).count()
                    reviewscount = CelebrityPlansLikes.objects.filter(plan_id=plans['id']).exclude(reviews__isnull=True).exclude(reviews__exact='').count()
                    plans['planlikesCount'] = plalikescount
                    plans['reviewsCount'] = reviewscount

                    plans['celeblikedPlan'] = 0
                    plans['celebreviewPlan'] = 0
                    plans['reviews'] = ''

                    # if username['userType'] == 8:
                    if 'userid' in data and data['userid'] != None and data['userid'] != "":
                        celebplanlikes = CelebrityPlansLikes.objects.filter(plan_id=plans['id'], user_id=data['userid'],status=1).values()
                        if celebplanlikes.exists():
                            plans['celeblikedPlan'] = 1
                        celebplanreviews = CelebrityPlansLikes.objects.filter(plan_id=plans['id'],user_id=data['userid']).values()
                        if celebplanreviews.exists():
                            plans['celebreviewPlan'] = 1
                            for celbdt in celebplanreviews:
                                celbObj = dict(celbdt)
                                if celbObj['reviews'] != '' and celbObj['reviews'] != None:
                                    plans['reviews'] = celbObj['reviews']

                    if 'userid' in data and data['userid'] !='':
                        countryID = UserAddress.objects.select_related('User__id').filter(country=88,user_id=data['userid']).values()
                        if countryID.exists():
                            for con in countryID:
                                conObj = dict(con)
                                username['userCountry'] = conObj['country']
                            india = True
                    indianPlans = PlanCountry.objects.filter(plan_id = plans['id']).values()
                    for inp in indianPlans:
                        inpObj = dict(inp)
                        if inpObj['country_id'] == 88:
                            plans['coachName'] = plans['createdBy_id__first_name']+" "+plans['createdBy_id__last_name']
                            plans['planPrice'] = plans['price']
                            if 'deviceType' in data and data['deviceType'] =='ios':
                                if userCurrency.currencyType == "INR":
                                    #highestPrice = Plan.objects.filter(activationStatus=1 , planStatus=1).all().aggregate(Max('iosPrice'))['iosPrice__max']
                                    if username['userCountry'] == 88:
                                        plans['price'] = plans['indianIosPrice']
                                        plans['planPrice'] = plans['price']
                                    else:
                                        plans['price'] = plans['iosPrice']
                                    if int(plans['price']) == 0:
                                        plans['price'] = "Free"
                                else:
                                    #highestPriceVal = Plan.objects.filter(activationStatus=1 , planStatus=1).all().aggregate(Max('iosPrice'))['iosPrice__max']
                                    #highestVal = PriceMapping.objects.get(inr=highestPriceVal)
                                    #highestPrice = highestVal.usd
                                    if username['userCountry'] == 88:
                                        usdValue = PriceMapping.objects.values().filter(inr=plans['indianIosPrice'])
                                    else:
                                        usdValue = PriceMapping.objects.values().filter(inr=plans['iosPrice'])
                                    for usd in usdValue:
                                        usdObj = dict(usd)
                                        dollarVal = usdObj['usd']
                                    plans['price'] = dollarVal
                                    if int(plans['price']) == 0:
                                        plans['price'] = "Free"
                            else:
                                if int(plans['price']) == 0:
                                    plans['price'] = "Free"
                                else:
                                    if userCurrency.currencyType == "INR":
                                        if username['userCountry'] == 88:
                                            plans['price'] = round((plans['indianPrice']) * float(inrValue))
                                            plans['planPrice'] = plans['price']
                                        else:
                                            plans['price'] = round((plans['price']) * float(inrValue))
                                            plans['planPrice'] = plans['price']
                                    else:
                                        if username['userCountry'] == 88:
                                            plans['price'] = plans['indianPrice']
                                            plans['planPrice'] = plans['price']
                                        else:
                                            plans['price'] = plans['price']
                                    if float(plans['price']) == 0:
                                        plans['price'] = "Free"
                            planPurposesVal = PlanGoals.objects.select_related('PlanPurposes').filter(plan_id=plans['id']).values('planGoal_id__GoalName')
                            purposes = ''
                            for val in planPurposesVal:
                                valObj = dict(val)
                                purposes += ", " + valObj['planGoal_id__GoalName']
                            if purposes != '':
                                planGoals = purposes[1:]
                            else:
                                planGoals = ""
                            plans['planDescription'] = plans['planDescription'] + "<br><br><font><b>Purposes:</b> " + str(planGoals) + "</font>"
                            if plans['licencePolicy'] == "3" or plans['licencePolicy'] == "White-Label":
                                partnerName = User.objects.get(id=plans['createdBy_id'])
                                plans['planDescription'] = str(plans['planDescription']) + "<br><h6>Copyright &copy; 2017 " + str(str(partnerName.first_name) + " " + str(partnerName.last_name)) + ". All rights reserved.</h6>"
                            else:
                                coachName = User.objects.get(id=plans['originalPlanner_id'])
                                plans['planDescription'] = str(plans['planDescription']) + "<br><h6>Copyright &copy; 2017 " + str(str(coachName.first_name) + " " + str(coachName.last_name)) + ". All rights reserved.</h6>"
    
                            planAbilityVal = SelectedAbilities.objects.select_related('PlanAbilities').filter(plan_id=plans['id']).values('ability_id__ability')
                            abilitieslists = ''
                            for val in planAbilityVal:
                                valObj = dict(val)
                                abilitieslists += ", " + valObj['ability_id__ability']
                            if abilitieslists != '':
                                planAbilities = abilitieslists[1:]
                            else:
                                planAbilities = ""
                            plans['planType'] = plans['programType_id__programTypeName']
                            plans['planGoal'] = plans['planGoal__goalName']
                            plans['planPurpose'] = planAbilities
                            plans['plan_goals'] = planGoals
                            plans['coachId'] = plans['createdBy_id']
                            downloadUsers = UserPlan.objects.filter(plan_id=dataObj['id']).values('user_id').distinct().count()
                            plans['planUsers'] = downloadUsers
                            if plans['licencePolicy'] == "Co-Brand":
                                plans['oriCoachName'] = str(plans['originalPlanner_id__first_name'])+" "+str(plans['originalPlanner_id__last_name'])
                            if plans['planPhoto'] is not None:
                                plans['planPhoto'] = S3URL + plans['planPhoto']
                            if plans['planLogo'] is not None:
                                plans['planLogo'] = S3URL + plans['planLogo']
                            if plans['programType_id__programTypeName'] == "STARTER":
                                plans['planType'] = 'Beginner'
                                plans['ptype'] = 'S'
                            elif plans['programType_id__programTypeName'] == "INTERMEDIATE":
                                plans['planType'] = 'Intermediate'
                                plans['ptype'] = 'I'
                            elif plans['programType_id__programTypeName'] == "ADVANCED":
                                plans['planType'] = 'Advanced'
                                plans['ptype'] = 'A'
                            IndianPlanArr.append(plans)
                        else:
                            plans['coachName'] = plans['createdBy_id__first_name']+" "+plans['createdBy_id__last_name']
                            plans['planPrice'] = plans['price']
                            if 'deviceType' in data and data['deviceType'] =='ios':
                                if userCurrency.currencyType == "INR":
                                    #highestPrice = Plan.objects.filter(activationStatus=1 , planStatus=1).all().aggregate(Max('iosPrice'))['iosPrice__max']
                                    if username['userCountry'] == 88:
                                        plans['price'] = plans['indianIosPrice']
                                    else:
                                        plans['price'] = plans['iosPrice']
                                    if int(plans['price']) == 0:
                                        plans['price'] = "Free"
                                else:
                                    #highestPriceVal = Plan.objects.filter(activationStatus=1 , planStatus=1).all().aggregate(Max('iosPrice'))['iosPrice__max']
                                    #highestVal = PriceMapping.objects.get(inr=highestPriceVal)
                                    #highestPrice = highestVal.usd
                                    if username['userCountry'] == 88:
                                        usdValue = PriceMapping.objects.values().filter(inr=plans['indianIosPrice'])
                                    else:
                                        usdValue = PriceMapping.objects.values().filter(inr=plans['iosPrice'])
                                    for usd in usdValue:
                                        usdObj = dict(usd)
                                        dollarVal = usdObj['usd']
                                    plans['price'] = dollarVal
                                    if int(plans['price']) == 0:
                                        plans['price'] = "Free"
                            else:
                                if int(plans['price']) == 0:
                                    plans['price'] = "Free"
                                else:
                                    if userCurrency.currencyType == "INR":
                                        if username['userCountry'] == 88:
                                            plans['price'] = round((plans['indianPrice']) * float(inrValue))
                                        else:
                                            plans['price'] = round((plans['price']) * float(inrValue))
                                    else:
                                        if username['userCountry'] == 88:
                                            plans['price'] = plans['indianPrice']
                                        else:
                                            plans['price'] = plans['price']
                                    if float(plans['price']) == 0:
                                        plans['price'] = "Free"
                            planPurposesVal = PlanGoals.objects.select_related('PlanPurposes').filter(plan_id=plans['id']).values('planGoal_id__GoalName')
                            purposes = ''
                            for val in planPurposesVal:
                                valObj = dict(val)
                                purposes += ", " + valObj['planGoal_id__GoalName']
                            if purposes != '':
                                planGoals = purposes[1:]
                            else:
                                planGoals = ""
                            plans['planDescription'] = plans['planDescription'] + "<br><br><font><b>Purposes:</b> " + str(planGoals) + "</font>"
                            if plans['licencePolicy'] == "3" or plans['licencePolicy'] == "White-Label":
                                partnerName = User.objects.get(id=plans['createdBy_id'])
                                plans['planDescription'] = str(plans['planDescription']) + "<br><h6>Copyright &copy; 2017 " + str(str(partnerName.first_name) + " " + str(partnerName.last_name)) + ". All rights reserved.</h6>"
                            else:
                                coachName = User.objects.get(id=plans['originalPlanner_id'])
                                plans['planDescription'] = str(plans['planDescription']) + "<br><h6>Copyright &copy; 2017 " + str(str(coachName.first_name) + " " + str(coachName.last_name)) + ". All rights reserved.</h6>"
    
                            planAbilityVal = SelectedAbilities.objects.select_related('PlanAbilities').filter(plan_id=plans['id']).values('ability_id__ability')
                            abilitieslists = ''
                            for val in planAbilityVal:
                                valObj = dict(val)
                                abilitieslists += ", " + valObj['ability_id__ability']
                            if abilitieslists != '':
                                planAbilities = abilitieslists[1:]
                            else:
                                planAbilities = ""
                            plans['planType'] = plans['programType_id__programTypeName']
                            plans['planGoal'] = plans['planGoal__goalName']
                            plans['planPurpose'] = planAbilities
                            plans['plan_goals'] = planGoals
                            plans['coachId'] = plans['createdBy_id']
                            downloadUsers = UserPlan.objects.filter(plan_id=dataObj['id']).values('user_id').distinct().count()
                            plans['planUsers'] = downloadUsers
                            if plans['licencePolicy'] == "Co-Brand":
                                plans['oriCoachName'] = str(plans['originalPlanner_id__first_name'])+" "+str(plans['originalPlanner_id__last_name'])
                            if plans['planPhoto'] is not None:
                                plans['planPhoto'] =  plans['planPhoto']
                            if plans['planLogo'] is not None:
                                plans['planLogo'] =  plans['planLogo']
                            if plans['programType_id__programTypeName'] == "STARTER":
                                plans['planType'] = 'Beginner'
                                plans['ptype'] = 'S'
                            elif plans['programType_id__programTypeName'] == "INTERMEDIATE":
                                plans['planType'] = 'Intermediate'
                                plans['ptype'] = 'I'
                            elif plans['programType_id__programTypeName'] == "ADVANCED":
                                plans['planType'] = 'Advanced'
                                plans['ptype'] = 'A'
                            PlanArr.append(plans)
                    if india == True:
                        #print(IndianPlanArr,'------8')
                        dataObj['plans'] = IndianPlanArr
                    else:
                        dataObj['plans'] = PlanArr
            else:
                dataObj['plans'] = []
            if socialDetails.exists():
                for data in socialDetails:
                    values = dict(data)
                    SocialMediaArr.append(values)
                dataObj['social'] = SocialMediaArr
            else:
                dataObj['social'] = []
            if 'userid' in data and data['userid']!='':
                userCurrency = User.objects.get(id=data['userid'])
                dataObj['luctype'] = userCurrency.currencyType
            dataArr.append(dataObj)
        return HttpResponse(json.dumps(dataArr))
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})


@never_cache
def gymDetails1(request):
    try:
        gymvalues = Organization.objects.values('gymName','id','num_of_users','num_of_trainers','aboutGym','status').filter(status=1)
        dataArr = list()
        for dt in gymvalues:
            dataObj = dict(dt)
            dataArr.append(dataObj)
        return HttpResponse(json.dumps(dataArr))
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def gymValues(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    req="GET"
    url = "startorg/gymValues/"
    try:
        if 'rows' in request.POST and request.POST['rows'] != '':
            rows = int(request.POST['rows'])
        else:
            rows = PAGING_ROWS
        if 'page' in request.POST and request.POST['page'] != '':
            page = int(request.POST['page'])
        else:
            page = 1
        offset = (page - 1) * rows
        tot = page * rows
        gymvalues = OrganizationAdress.objects.select_related('Organization__id').values('organization_id__gymType','organization_id__coverImage','organization_id__logo','organization_id__gymName','organization_id__id','organization_id__num_of_users','organization_id__fitbaseid','organization_id__num_of_trainers','organization_id__aboutGym','organization_id__status','country','state','town','address','phone','organization_id__gymType','country','state','town','location','id').order_by('-id')
        total = len(gymvalues)
        data = gymvalues[offset:tot]
        dataArr = list()
        for dt in data:
            dataObj = dict(dt)
            dataArr.append(dataObj)
        return JsonResponse({"rows": dataArr, "total": total})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})

def gymSearch(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        gymData = json.loads(request.body.decode('utf-8'))
        print(gymData)
        if 'rows' in gymData and gymData['rows'] != '':
            rows = int(gymData['rows'])
        else:
            rows = PAGING_ROWS
        if 'page' in gymData and gymData['page'] != '':
            page = int(gymData['page'])
        else:
            page = 1
        offset = (page - 1) * rows
        tot = page * rows

        if 'gyminfo' in gymData !='':
            gymvalues =  OrganizationAdress.objects.select_related('Organization__id').values('organization_id__gymName','organization_id__id','organization_id__num_of_users','organization_id__num_of_trainers','organization_id__aboutGym','organization_id__status','country','state','town','address','phone','organization_id__gymType','country','state','town','location','id').order_by('-id')
            if 'gymname' in gymData['gyminfo'] and gymData['gyminfo']['gymname'] !='':
                gymvalues = gymvalues.filter(organization_id__gymName__istartswith = gymData['gyminfo']['gymname'])
            if 'no_trainers' in gymData['gyminfo'] and gymData['gyminfo']['no_trainers'] !='':
                gymvalues = gymvalues.filter(organization_id__num_of_trainers__icontains = gymData['gyminfo']['no_trainers'])
            if 'no_users' in gymData['gyminfo'] and gymData['gyminfo']['no_users'] !='':
                gymvalues = gymvalues.filter(organization_id__num_of_users__icontains = gymData['gyminfo']['no_users'])
        else:
            gymvalues = OrganizationAdress.objects.select_related('Organization__id').values('organization_id__gymName','organization_id__id','organization_id__num_of_users','organization_id__num_of_trainers','organization_id__aboutGym','organization_id__status','country', 'state', 'town','address', 'phone','organization_id__gymType','country', 'state', 'town','location', 'id').order_by('-id')
        total = len(gymvalues)
        gymdata = gymvalues[offset:tot]
        dataArr = list()
        for dt in gymdata:
            dataObj = dict(dt)
            dataArr.append(dataObj)
        return JsonResponse({"rows": dataArr, "total": total})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def userplanDetails(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    print(username['id'])
    req="GET"
    url="startorg/userplanDetails/"
    try:
        if username != None:
            planValues = Plan.objects.values('id','planName','price','proposedState','iosPrice','iosStatus').filter(createdBy_id = user,planStatus=1,activationStatus=1)
            dataArr = list()
            for dt in planValues:
                dataObj = dict(dt)
                dataArr.append(dataObj)
            proposedplans = Plan.objects.values('id','planName','price','proposedState','iosPrice','iosStatus').filter(createdBy_id = user,planStatus=1,proposedState=1,activationStatus=1)
            proposedplansArr = list()
            for dt in proposedplans:
                dataObj = dict(dt)
                proposedplansArr.append(dataObj)
            return JsonResponse({"success": True,"ownplans":dataArr,"proposedplans":proposedplansArr})
        else:
            return JsonResponse({"success":False,"message":"User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def gymplanDetails(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    req="GET"
    url="startorg/gymplanDetails/"
    try:
        print(username['id'],"1234567u")
        if username != None:
            gymplans = Plan.objects.select_related('User').filter(originalPlanner_id__organization_id=2).values('planName','id')
            print(gymplans)
            if gymplans.exists():
                dataArr = list()
                for dt in gymplans:
                    dataObj = dict(dt)
                    dataArr.append(dataObj)
                return HttpResponse(json.dumps(dataArr))
            else:
                return HttpResponse("No Plans Available")
        else:
            return JsonResponse({"success": False, "message": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def gymProfile(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    data = json.loads(request.body.decode('utf-8'))
    req=data
    url="startorg/gymProfile/"
    try:
        print(username['id'])
        gymsuperUser = False
        if username != None:
            if username['userType'] == 6:
                gymsuperUser = True
            gymvalues = Organization.objects.filter(id = data['id']).values('gymName','id','num_of_users','num_of_trainers','aboutGym','phone','webUrl','logo','coverImage')
            dataArr = list()
            for dt in gymvalues:
                dataObj = dict(dt)
                dataObj['gymsuperUser'] = gymsuperUser
                address = []
                gymAddress = OrganizationAdress.objects.filter(organization_id = dataObj['id']).values('country','state','town','address','latitutde','longitude','location','phone','createdBy','id')
                userAddrress = User.objects.get(id=username['id'])
                ordAdressId = userAddrress.organizationAddress_id
                dataObj['ordAdressId'] = ordAdressId
                for add in gymAddress:
                    addObj = dict(add)
                    address.append(addObj)
                    dataObj['address'] = address
                dataArr.append(dataObj)
            return HttpResponse(json.dumps(dataArr))
        else:
            return JsonResponse({"success": False, "message": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def updategymdetails(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    data = json.loads(request.body.decode('utf-8'))
    req=data
    url="startorg/updategymdetails/"
    try:
        print(username['id'])
        print(data)
        if username != None:
            gymvalues = Organization.objects.get(pk = data['id'])
            gymvalues.gymName = data['name']
            gymvalues.aboutGym = data['about']
            gymvalues.num_of_users = data['num_of_users']
            gymvalues.num_of_trainers = data['num_of_trainers']
            if data['weburl'] !=None:
                if "http://" in data['weburl']:
                    gymvalues.webUrl = data['weburl']
                else:
                    gymvalues.webUrl = "http://"+data['weburl']
            else:
                gymvalues.webUrl = None
            gymvalues.phone = data['phone']
            gymvalues.save()
            return JsonResponse({"success":True,"message":"Gym profile updated successfully"})
        else:
            return JsonResponse({"success": False, "message": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def socialmediainfo(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user=username[id]
    userid = username['id']
    socInfo = json.loads(request.body.decode('utf-8'))
    req=socInfo
    url="startorg/socialmediainfo/"
    try:
        orgId = username['organization']
        if username!=None:
            print(socInfo,"1234567")
            rangeData = len(socInfo['socialinf'])
            for i in range(rangeData):
                if 'id' in socInfo['socialinf'][i]:
                    id = socInfo['socialinf'][i]['id']
                    print(id,'----------------')
                    socialtype = socInfo['socialinf'][i]['socailName']
                    if 'http://' in  socInfo['socialinf'][i]['socialUrl']:
                        socialUrl = socInfo['socialinf'][i]['socialUrl']
                    else:
                        socialUrl = "http://"+socInfo['socialinf'][i]['socialUrl']
                    #socialUrl = socInfo['socialinf'][i]['socialUrl']
                    dupsocailinf = OrganizationSocialProfile.objects.get(pk =id)
                    print('-----update social')
                    dupsocailinf.socailName = socialtype
                    dupsocailinf.socialUrl = socialUrl
                    dupsocailinf.save()
                elif 'id' not in socInfo['socialinf'][i]:
                    print('-----create social01')
                    socialtype = socInfo['socialinf'][i]['socailName']
                    if 'http://' in  socInfo['socialinf'][i]['socialUrl']:
                        socialurl = socInfo['socialinf'][i]['socialUrl']
                    else:
                        socialurl = "http://"+socInfo['socialinf'][i]['socialUrl']
                    #socialurl = socInfo['socialinf'][i]['socialUrl']
                    socailinf = OrganizationSocialProfile(
                        organization_id = orgId,
                        user_id = userid
                    )
                    socailinf.socailName = socialtype
                    socailinf.socialUrl = socialurl
                    socailinf.save()
            return JsonResponse({"success": True, "message": "User Social Information Saved Successfully "})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getorgsocialmediainfo(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        user = stratsessionutil.get_user_insession(request)
        userid = user['id']
        orgId = user['organization']
        if user != None:
            orgsocialinf = OrganizationSocialProfile.objects.values('id','user_id','organization_id','socailName','socialUrl').filter(organization_id = orgId)
            orgsocialArr =[]
            for sdt in orgsocialinf:
                socailObj = dict(sdt)
                orgsocialArr.append(socailObj)
            return JsonResponse({"success":True,"socialinfo":orgsocialArr})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def uploadlogo(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    data = json.loads(request.body.decode('utf-8'))
    req=data
    url="startorg/uploadlogo/"
    try:
        orgId = username['organization']
        if username != None:
            print(orgId,user,"in Here")
            picUpload = Organization.objects.get(id = orgId)
            picUpload.logo = data['image']
            picUpload.save()
            print(picUpload.logo)
            return JsonResponse({"success":True,"message":"Image Uploaded Successfully"})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def uploadCover(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    data = json.loads(request.body.decode('utf-8'))
    req=data
    url="startorg/uploadCover/"
    try:
        orgId = username['organization']
        if username != None:
            print("in Here")
            picUpload = Organization.objects.get(id = orgId)
            picUpload.coverImage = data['image']
            picUpload.save()
            print(picUpload.coverImage)
            return JsonResponse({"success":True,"message":"Image Uploaded Successfully"})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg":str(e)})


def gymLogo(request):
    user = "NULL"
    data = json.loads(request.body.decode('utf-8'))
    req = data
    url = "startorg/gymLogo/"
    try:
        gymplans = Organization.objects.filter(id=data['OrgId']).values('logo','id')
        print(gymplans)
        if gymplans.exists():
            dataArr = list()
            for dt in gymplans:
                dataObj = dict(dt)
                dataArr.append(dataObj)
            return HttpResponse(json.dumps(dataArr))
        else:
            return HttpResponse("No Images Available")
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg": str(e)})


def gymcover(request):
    user = "NULL"
    data = json.loads(request.body.decode('utf-8'))
    req = data
    url = "startorg/gymcover/"
    try:
        gymplans = Organization.objects.filter(id=data['OrgId']).values('coverImage','id')
        print(gymplans)
        if gymplans.exists():
            dataArr = list()
            for dt in gymplans:
                dataObj = dict(dt)
                dataArr.append(dataObj)
            return HttpResponse(json.dumps(dataArr))
        else:
            return HttpResponse("No Images Available")
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg": str(e)})

def gymrequests(request):
    userInfo = json.loads(request.body.decode('utf-8'))
    req=userInfo
    url = "startorg/gymrequests/"
    try:
        print(userInfo)
        existingUsers = User.objects.filter(email = userInfo['email']).values('userType','organization_id','is_active')
        orgVal = Organization.objects.get(gymName = userInfo['organization'])
        orgId = orgVal.id
        for val in existingUsers:
            values = dict(val)
            if values['is_active'] == 0:
                return JsonResponse({"success":False,"message":"Request Already Sent"})
            if values['is_active'] == 1:
                return JsonResponse({"success":True,"message":"User already exists"})
        userInformation = User.objects.create(
            createdBy_id = '',
            modifiedBy_id = '',
            userType = userInfo['userType'],
            first_name = userInfo['first_name'],
            email = userInfo['email'],
            username = userInfo['email'],
            password = make_password(userInfo['pword']),
            organization_id = orgId,
            is_active = 0
        )
        if 'last_name' in userInfo and userInfo['last_name'] !='':
            userInformation.last_name = userInfo['last_name']
        else:
            userInformation.last_name =None
        if 'phone' in userInfo and userInfo['phone'] !='':
            userInformation.phone = userInfo['phone']
        else:
            userInformation.phone =None
        userInformation.save()
        return JsonResponse({"success":True,"message":"Request sent to the Gym"})
    except Exception as e:
        logger.error("error")
        exceptionMail("1", req, url, str(e))
        return JsonResponse({"msg": str(e)})


@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def gymRequestsDetails(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    req="GET"
    url="startorg/gymRequestsDetails/"
    try:
        orgId = username['organization']
        if username!=None:
            if 'rows' in request.POST and request.POST['rows'] != '':
                rows = int(request.POST['rows'])
            else:
                rows = PAGING_ROWS
            if 'page' in request.POST and request.POST['page'] != '':
                page = int(request.POST['page'])
            else:
                page = 1
            offset = (page - 1) * rows
            tot = page * rows
            users = User.objects.filter(organization_id =orgId,is_active = 0,userType = 7,createdBy_id = None).values('id','username','email','first_name','middle_name','last_name','phone','is_active','createdBy_id')
            dataArr = list()
            total = len(users)
            data = users[offset:tot]
            for dt in data:
                dataObj =dict(dt)

                dataArr.append(dataObj)
            return JsonResponse({"rows":dataArr,"total":total})
        else:
            return JsonResponse({"success": False, "message": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def acceptrequests(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    data = json.loads(request.body.decode('utf-8'))
    req=data
    url="startorg/acceptrequests/"
    try:
        orgId = username['organization']
        if username!=None:
            rangeData = len(data['selectedUsers'])
            for i in range(rangeData):
                print(data['selectedUsers'][i]['id'])
                acceptingRequests = User.objects.get(id = data['selectedUsers'][i]['id'])
                acceptingRequests.is_active = 1
                acceptingRequests.createdBy_id = user
                acceptingRequests.save()
            print(data['selectedUsers'][0]['id'])
            return JsonResponse({"success":True,"message":"Request accepted successfully"})
        else:
            return JsonResponse({"success": False, "message": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def gymLists(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    #data = json.loads(request.body.decode('utf-8'))
    req="GET"
    url="startorg/acceptrequests/"
    try:
        if username!=None:
            dataArr = []
            indiaGyms = []
            otherGyms = []
            indianGyms = GymCountry.objects.filter(country_id = 88).values()
            if indianGyms.exists():
                for val in indianGyms:
                    valObj = dict(val)
                    indiaGyms.append(valObj['gym_id'])
            otherGymValues = GymCountry.objects.filter(~Q(country_id=88)).values()
            if otherGymValues.exists():
                for val1 in otherGymValues:
                    valObj1 = dict(val1)
                    otherGyms.append(valObj1['gym_id'])
            india = False
            countryID = UserAddress.objects.select_related('User__id').filter(country=88, user_id=user).values()
            if countryID.exists():
                for con in countryID:
                    conObj = dict(con)
                    username['userCountry'] = conObj['country']
                india = True
            if india == True:
                gymval = Organization.objects.values().exclude(id = 1).filter(status=1,id__in = indiaGyms)
            else:
                gymval = Organization.objects.values().exclude(id=1).filter(status=1, id__in=otherGyms)
            for gym in gymval:
                gymObj = dict(gym)
                if gymObj['logo'] =='' or gymObj['logo'] == None:
                    gymObj['logo1'] = "http://stratfit.net/assets/images/logo.png"
                else:
                    gymObj['logo1'] = S3URL+gymObj['logo']
                if gymObj['coverImage'] =='' or gymObj['coverImage'] == None:
                    gymObj['cover1'] = "http://stratfit.net/assets/images/SF1.jpg"
                else:
                    gymObj['cover1'] = S3URL+gymObj['coverImage']
                dataArr.append(gymObj)
            return JsonResponse({"success":True,"message":"Gym Details","gymValues":dataArr})
        else:
            return JsonResponse({"success": False, "message": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def gymAddressEdit(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    data = json.loads(request.body.decode('utf-8'))
    req=data
    url="startorg/gymAddressEdit/"
    try:
        print(data)
        if username != None:
            if 'id' in data:
                print('+++++++++update+++++++++')
                gymAdress = OrganizationAdress.objects.get(pk = data['id'])
                gymAdress.country = data['country']
                gymAdress.state = data['state']
                gymAdress.address = data['address']
                gymAdress.town = data['town']
                gymAdress.location = data['location']
                gymAdress.latitutde = data['latitutde']
                gymAdress.phone = data['phone']
                gymAdress.longitude = data['longitude']
                gymAdress.status = data['status']
                gymAdress.save()
                return JsonResponse({"success":True,"message": "Gym Address updated successfully"})
            else:
                print('+++++++++create+++++++++')
                orgAdress = OrganizationAdress.objects.create(
                    organization_id = data['orgId'],
                    createdBy=user,
                    modifiedBy=user,
                    status = data['status']
                )
                if 'town' in data and data['town'] !='':
                    orgAdress.town = data['town']
                else:
                    gymDetails.town = None
                if 'address' in data and data['address'] !='':
                    orgAdress.address = data['address']
                else:
                    gymDetails.address = None
                if 'latitutde' in data and data['latitutde'] !='':
                    orgAdress.latitutde = data['latitutde']
                else:
                    gymDetails.latitutde = None
                if 'longitude' in data and data['longitude'] !='':
                    orgAdress.longitude = data['longitude']
                else:
                    gymDetails.longitude = None
                if 'location' in data and data['location'] !='':
                    orgAdress.location = data['location']
                else:
                    orgAdress.location = None
                if 'country' in data and data['country'] !='':
                    orgAdress.country = data['country']
                else:
                    orgAdress.location = None
                if 'state' in data and data['state'] !='':
                    orgAdress.state = data['state']
                else:
                    orgAdress.state = None
                orgAdress.save()
                return JsonResponse({"success":True,"message":"Gym Address added succesfully"})
        else:
            return JsonResponse({"success":False,"message":"user logged out"})
    except Exception as e:
        logger.error("error")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg": str(e)})
@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getGymAddress(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    data = json.loads(request.body.decode('utf-8'))
    req=data
    url="startorg/creategym/"
    try:
        print(data)
        if username != None:
            orgAdressInf =  OrganizationAdress.objects.filter(id=data['id']).values('country','state','address','location','latitutde','longitude','town','phone','id','status')
            for org in orgAdressInf:
                orgObj = dict(org)
            return JsonResponse({"success":True,"details":orgObj})
    except Exception as e:
        logger.error("error")
        exceptionMail(user, req, url, str(e))
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getAddressValues(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    url="startorg/creategym/"
    try:
        if username != None:
            orgAddArr = []
            orgAdressInf =  OrganizationAdress.objects.filter(organization_id=username['organization']).values('country','state','address','location','latitutde','longitude','town','phone','id','status')
            for org in orgAdressInf:
                orgObj = dict(org)
                orgAddArr.append(orgObj)
            return JsonResponse({"success":True,"details":orgAddArr})
    except Exception as e:
        logger.error("error")
        return JsonResponse({"msg": str(e)})


@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def generateKey(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    user = username['id']
    data = json.loads(request.body.decode('utf-8'))
    req=data
    url="startorg/creategymtoken/"
    import string
    import random
    try:
        num=json.loads(request.body.decode('utf-8'))
        print(data)
        if username != None:
            N=4
            num=0
            res = 'FIT#'+''.join(random.choices(string.ascii_uppercase +string.digits, k = N))
            return JsonResponse({"success":True,"details":res})
        else:
            returnJsonResponse({"success":False,"message":"user logged out"})
    except Exception as e:
        logger.error("error")
        return JsonResponse({"msg": str(e)})    

          
           
  
  