from django.db import models

# Create your models here.
#from Subscriber.models import User
#import utility
#from utility.models import Country

class Organization(models.Model):
    gymName = models.CharField(max_length=255)
    aboutGym = models.TextField(null=True)
    num_of_users = models.IntegerField(null=True)
    num_of_trainers = models.IntegerField(null=True)
    status = models.SmallIntegerField(default=1)
    logo = models.CharField(max_length=255,null=True)
    coverImage = models.CharField(max_length=255,null=True)
    webUrl = models.TextField(null=True)
    phone = models.CharField(max_length=255,null=True)
    gymType = models.IntegerField(default=0)
    fitbaseid=models.CharField(max_length=255,null=True,default=0)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)
    createdBy = models.IntegerField(default=0)
    modifiedBy = models.IntegerField(default=0)

class OrganizationAdress(models.Model):
    organization = models.ForeignKey(Organization, on_delete=models.CASCADE)
    country = models.IntegerField(default=0)
    state = models.CharField(max_length=100,null=True)
    town = models.CharField(max_length=100,null=True)
    address = models.CharField(max_length=255, null=True)
    latitutde = models.CharField(max_length=255, null=True)
    longitude = models.CharField(max_length=255, null=True)
    location = models.CharField(max_length=255, null=True)
    phone = models.CharField(max_length=255, null=True)
    status = models.SmallIntegerField(default=1)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)
    createdBy = models.IntegerField(default=0)
    modifiedBy = models.IntegerField(default=0)

class CampainUrls(models.Model):
    campaignSource = models.CharField(max_length=200,null=True)
    campaignMedium = models.CharField(max_length=200,null=True)
    campaignName = models.CharField(max_length=200,null=True)
    campaignTerm = models.CharField(max_length=200,null=True)
    campaignUrl = models.TextField(null=True)
    campaignShortUrl = models.CharField(max_length=200,null=True)