"""StratFit URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/1.9/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  re_path(r'^$', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  re_path(r'^$', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.conf.urls import url, include
    2. Add a URL to urlpatterns:  re_path(r'^blog/', include('blog.urls'))
"""
from django.urls import re_path,include
from django.contrib import admin
from Subscriber import urls as subscriberurls
from Userplan import urls as userplanurls
from utility import urls as utilityurls
from Plan import urls as planurls
from partner import urls as partnerurls
from stratadmin import urls as straturls
from StratFitOrganization import urls as startorgurls
from payment import urls as paymenturls
from Celebrity import urls as celebrityurls
from campaign import urls as campaignurls
from Company import urls as companyurls
from Program import urls as programurls
from UserProgram import urls as userprogramurls
from cms import urls as cmsurls
from Nutrition import urls as Nutritionurls
from DexaReport import urls as Dexareporturls
urlpatterns = [
    re_path(r'^admin/', admin.site.urls),
    re_path(r'^services/stratservices/subscriber/',include((subscriberurls, 'Subscriber'),namespace='subscriberurls')),
    re_path(r'^services/stratservices/userplan/',include((userplanurls, 'Userplan'),namespace='userplanurls')),
    re_path(r'^services/stratservices/userprogram/', include((userprogramurls, 'UserProgram'), namespace='userprogramurls')),
    re_path(r'^services/stratservices/plan/',include((planurls, 'Plan'),namespace='planurls')),
    re_path(r'^services/stratservices/utility/',include((utilityurls, 'utility'),namespace='utility')),
    re_path(r'^services/stratservices/partner/',include((partnerurls, 'partner'),namespace='partner')),
    re_path(r'^services/stratservices/stratadmin/',include((straturls, 'stratadmin'),namespace='utility')),
    re_path(r'^services/stratservices/startorg/',include((startorgurls, 'StratFitOrganization'),namespace='utility')),
    re_path(r'^services/stratservices/payment/',include((paymenturls, 'payment'),namespace='paymenturls')),
    re_path(r'^services/stratservices/celebrity/',include((celebrityurls, 'Celebrity'),namespace='celebrityurls')),
    re_path(r'^services/stratservices/campaign/',include((campaignurls, 'campaign'),namespace='campaignurls')),
    re_path(r'^services/stratservices/company/',include((companyurls, 'Company'),namespace='companyurls')),
    re_path(r'^services/stratservices/program/', include((programurls, 'Program'), namespace='programurls')),
    re_path(r'^services/stratservices/cms/',include((cmsurls, 'cms'),namespace='cmsurls')),
	re_path(r'^services/stratservices/Nutrition/', include((Nutritionurls, 'Nutrition'), namespace='nutritionurls')),
	re_path(r'^services/stratservices/Dexareport/', include((Dexareporturls, 'DexaReport'), namespace='dexareporturls')),
]
