"""
Django settings for StratFit project.

Generated by 'django-admin startproject' using Django 1.9.4.

For more information on this file, see
https://docs.djangoproject.com/en/1.9/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/1.9/ref/settings/
"""

import os

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
import static
BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
LOG_DIR = BASE_DIR + "/logs"
GEOIP_PATH = BASE_DIR + "/GeoIPs"
STATICDIR = BASE_DIR + "/static"


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/1.9/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = 'rjyd7uuyif(07-^*ig@5o@o&y89wtqgh*pfxqn*&v4azco=g&u'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = ['*']
CACHES = {
    'default': {
        'BACKEND': 'django.core.cache.backends.memcached.PyMemcacheCache',
        'LOCATION': '127.0.0.1:11211',
    }
}


# Application definition

INSTALLED_APPS = [
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django_memcached',
    'django.contrib.staticfiles',
    'corsheaders',
    'StratFit',
    'utility',
    'Subscriber',
    'Plan',
    'Userplan',
    'UserProgram',
    'partner',
    'stratadmin',
    'StratFitOrganization',
    'payment',
    'Celebrity',
    'campaign',
    'Company',
	'Program',
    'cms',
    'DexaReport',
    #'rest_framework',
    'Nutrition',
    'social_django',
    'social.apps.django_app.default',
]
MEDIA_ROOT = '/var/media/'
MEDIA_URL = BASE_DIR+'/static/'
#MEDIA_URL = 'http://media.example.com/'

S3URL = 'https://stratfitmedia.s3.amazonaws.com/stratfitmedia/'

PAYPAL_MODE='sandbox'   # sandbox or live
PAYPAL_CLIENT_ID='EBWKjlELKMYqRNQ6sYvFo64FtaRLRR5BdHEESmha49TM'
PAYPAL_CLIENT_SECRET='EO422dn3gQLgDbuwqTjzrFgFtaRLRR5BdHEESmha49TM'
END_URL = 'https://api-3t.sandbox.paypal.com/nvp'
PAYPAL_URL = 'https://www.sandbox.paypal.com/webscr&cmd=_express-checkout&token='

SOCIAL_AUTH_USER_MODEL = 'Subscriber.User'
SOCIAL_AUTH_FACEBOOK_KEY = '328928090815589'
SOCIAL_AUTH_FACEBOOK_SECRET = '39554ed05a76b742a3e97c989dbf742c'
SOCIAL_AUTH_FACEBOOK_SCOPE = ['email']
SOCIAL_AUTH_FACEBOOK_PROFILE_EXTRA_PARAMS = { 
    'fields': 'id, name, email, age_range'
}

SOCIAL_AUTH_GOOGLE_OAUTH2_KEY = '798608632942-p2un0isrhgcbdaaqtf2pbf68mo4ouk4b.apps.googleusercontent.com'
SOCIAL_AUTH_GOOGLE_OAUTH2_SECRET = '8SKPINfLfT9HxmQPFCOMwtva'
SOCIAL_AUTH_GOOGLE_OAUTH2_USE_DEPRECATED_API = True
SOCIAL_AUTH_GOOGLE_PLUS_USE_DEPRECATED_API = True

SOCIAL_AUTH_TWITTER_KEY = 'e1bswlsd4PPYaxsD7jjp0iI88'
SOCIAL_AUTH_TWITTER_SECRET = 'SSIL6ksUATesKgKiaovQKNZuWqnIfCbb4UpjXmzi2T1d7Ykdgc'

SOCIAL_AUTH_INSTAGRAM_KEY = 'cc5e2f684f4f47a3b4f9f310eaae4def'
SOCIAL_AUTH_INSTAGRAM_SECRET = '9bf6a79ad2d94d4599b86a0506412814'

SOCIAL_AUTH_LINKEDIN_KEY = '78szla210ed4th'
SOCIAL_AUTH_LINKEDIN_SECRET = '4IRqwcB4Is3SeNua'

SOCIAL_AUTH_PINTEREST_KEY = '4860071258747840745'
SOCIAL_AUTH_PINTEREST_SECRET = '6eb16bb54d6008fce0c910442486966e04baa4efb4f055a896848e6398191aa1'

# Add email to requested authorizations.
SOCIAL_AUTH_LINKEDIN_OAUTH2_SCOPE = ['r_basicprofile', 'r_emailaddress']
# Add the fields so they will be requested from linkedin.
SOCIAL_AUTH_LINKEDIN_OAUTH2_FIELD_SELECTORS = ['email-address', 'headline', 'industry']
# Arrange to add the fields to UserSocialAuth.extra_data
SOCIAL_AUTH_LINKEDIN_OAUTH2_EXTRA_DATA = [('id', 'id'),
                                   ('firstName', 'first_name'),
                                   ('lastName', 'last_name'),
                                   ('emailAddress', 'email_address'),
                                   ('headline', 'headline'),
                                   ('industry', 'industry')]

SOCIAL_AUTH_APPLE_ID_CLIENT = 'net.stratfit.user'      # Your client_id com.application.your, aka "Service ID"
SOCIAL_AUTH_APPLE_ID_TEAM = '4XN7XNEN38'               # Your Team ID, ie K2232113
SOCIAL_AUTH_APPLE_ID_KEY = 'C3HDD5KSKK'                # Your Key ID, ie Y2P99J3N81K
SOCIAL_AUTH_APPLE_ID_SECRET = """
-----BEGIN PRIVATE KEY-----
MIGTAgEAMBMGByqGSM49AgEGCCqGSM49AwEHBHkwdwIBAQQgfsG2v3+rEm72p11/
9ZGpB9F3YFj/CPCtllXCrVU4riWgCgYIKoZIzj0DAQehRANCAAT2DFQm8e++hNnr
VHL1W7Xn46jRXc2tgP0cjO0VuA/yNu0ggLWzvpi/HmddfYBEKkUti6CZNr8e9GIs
R7AAF4BE
-----END PRIVATE KEY-----"""

SOCIAL_AUTH_APPLE_ID_SCOPE = ['email', 'name']
SOCIAL_AUTH_APPLE_ID_EMAIL_AS_USERNAME = True   # If you want to use email as username

DEFAULT_AUTO_FIELD='django.db.models.AutoField'


# Add email to requested authorizations.
SOCIAL_AUTH_LINKEDIN_OAUTH2_SCOPE = ['r_basicprofile', 'r_emailaddress']
# Add the fields so they will be requested from linkedin.
SOCIAL_AUTH_LINKEDIN_OAUTH2_FIELD_SELECTORS = ['email-address', 'headline', 'industry']
# Arrange to add the fields to UserSocialAuth.extra_data
SOCIAL_AUTH_LINKEDIN_OAUTH2_EXTRA_DATA = [('id', 'id'),
                                   ('firstName', 'first_name'),
                                   ('lastName', 'last_name'),
                                   ('emailAddress', 'email_address'),
                                   ('headline', 'headline'),
                                   ('industry', 'industry')]


AUTHENTICATION_BACKENDS = (
    'django.contrib.auth.backends.ModelBackend',
    'social_core.backends.apple.AppleIdAuth',
    'social_core.backends.facebook.FacebookAppOAuth2',
    'social_core.backends.facebook.FacebookOAuth2',
    'social_core.backends.google.GoogleOAuth2',
    
  )

MIDDLEWARE = [
    #'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    #'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
    'corsheaders.middleware.CorsMiddleware',
    'django.middleware.cache.CacheMiddleware',
]

SOCIAL_AUTH_PIPELINE = (
    'social_core.pipeline.social_auth.social_details',
    'social_core.pipeline.social_auth.social_uid',
    'social_core.pipeline.social_auth.auth_allowed',
    'social_core.pipeline.social_auth.social_user',
    'social_core.pipeline.user.get_username',
    'Subscriber.pipeline.associate_by_email',
    'social_core.pipeline.user.create_user',
    'social_core.pipeline.social_auth.associate_user',
    'social_core.pipeline.social_auth.load_extra_data',
    'social_core.pipeline.user.user_details',
    'Subscriber.pipeline.save_profile',
)

CORS_ORIGIN_ALLOW_ALL = True

CORS_ORIGIN_WHITELIST = ()

CORS_ORIGIN_REGEX_WHITELIST = ()

CORS_URLS_REGEX = '^.*$'

CORS_ALLOW_METHODS = (
        'GET',
        'POST',
        'PUT',
        'PATCH',
        'DELETE',
        'OPTIONS'
    )

CORS_ALLOW_HEADERS = (
        'x-requested-with',
        'content-type',
        'accept',
        'origin',
        'authorization',
        'x-csrftoken'
    )
CORS_EXPOSE_HEADERS = ()
CORS_PREFLIGHT_MAX_AGE = 86400
CORS_ALLOW_CREDENTIALS = False
CORS_REPLACE_HTTPS_REFERER = False

#CACHE_BACKEND = 'memcached://172.31.22.75:11211/'
CACHE_BACKEND = 'memcached://127.0.0.1:11211/'

CACHES = {
    'default': {
        'BACKEND': 'django.core.cache.backends.memcached.PyMemcacheCache',
        'LOCATION': '127.0.0.1:11211',
    }
}

SESSION_VALIDITY = 2592000

ROOT_URLCONF = 'StratFit.urls'

PAYMENT_FAIL_URL = "http://localhost:9001/#/fail"

PAYMENT_SUCCESS_URL = "http://localhost:9001/#/success"

PAGING_ROWS = 100

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [BASE_DIR+'/StratFit/template/'],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'StratFit.wsgi.application'


# Database
# https://docs.djangoproject.com/en/1.9/ref/settings/#databases

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.mysql',
        'NAME': 'stratfitdb',
        'USER': 'harshi',
        'PASSWORD': 'harshi',
        'HOST': 'localhost',   # Or an IP Address that your DB is hosted on
        'PORT': '3306',
        'OPTIONS': {
            "init_command": "SET foreign_key_checks = 0;",
        }
    }
}


# Password validation
# https://docs.djangoproject.com/en/1.9/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]

PASSWORD_HASHERS = (
        'django.contrib.auth.hashers.PBKDF2PasswordHasher',
        'django.contrib.auth.hashers.PBKDF2SHA1PasswordHasher',
        'django.contrib.auth.hashers.BCryptPasswordHasher',
        'django.contrib.auth.hashers.SHA1PasswordHasher',
        'django.contrib.auth.hashers.MD5PasswordHasher',
        'django.contrib.auth.hashers.CryptPasswordHasher',
)


# Internationalization
# https://docs.djangoproject.com/en/1.9/topics/i18n/

#EMAIL_BACKEND = 'django.core.mail.backends.console.EmailBackend'


EMAIL_BACKEND = 'django.core.mail.backends.smtp.EmailBackend'


'''EMAIL_USE_TLS = True
EMAIL_HOST = 'smtp.zoho.com'
EMAIL_HOST_USER = 'admin@stratfit.co'
EMAIL_HOST_PASSWORD = 'admin123'
EMAIL_PORT = 587
EMAIL_USE_SSL = False'''

#EMAIL_BACKEND = 'django_smtp_ssl.SSLEmailBackend'
EMAIL_HOST = 'email-smtp.ap-southeast-2.amazonaws.com'
EMAIL_PORT = 587
EMAIL_HOST_USER = 'AKIA2TV3VESEHBHYMSSV'
EMAIL_HOST_PASSWORD = 'BDY4RlB6QCooY8Jyx3QgrsXW4G9plNFg8X1Q/BRXYzfI'
EMAIL_USE_TLS = True

'''#EMAIL_USE_TLS = True
EMAIL_HOST = 'outlook-namnorth.office365.com'
EMAIL_HOST_USER = 'admin@stratfit.in'
EMAIL_HOST_PASSWORD = 'Admin@123'
EMAIL_PORT = 587
EMAIL_USE_TLS = True'''

#FROM_EMAIL = "admin@stratfit.in"

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'UTC'

USE_I18N = True

USE_L10N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/1.9/howto/static-files/

STATIC_URL = '/static/'

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'verbose': {
            'format': '%(levelname)s %(asctime)s %(module)s %(process)d %(thread)d %(message)s'
        },
        'simple': {
            'format': '%(levelname)s %(message)s'
        },
    },
    'handlers': {
        'null': {
            'level': 'DEBUG',
            'class': 'logging.NullHandler',
        },
        'console': {
            'level': 'DEBUG',
            'class': 'logging.StreamHandler',
            'formatter': 'simple'
        },
        'debug-file': {
            'level': 'DEBUG',
            'class':'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'stratfit-debug.log'),
            'maxBytes': 1024 * 1024 * 15,  # 15MB
            'backupCount': 10,
        },
        'info-file': {
            'level': 'INFO',
            'class':'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'stratfit-info.log'),
            'maxBytes': 1024 * 1024 * 15,  # 15MB
            'backupCount': 10,
        },
        'error-file': {
            'level':'ERROR',
            'class':'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'stratfit-error.log'),
            'maxBytes': 1024 * 1024 * 15,  # 15MB
            'backupCount': 10,
        },
    },
    'loggers': {
        'django': {
            'handlers': ['null'],
            'propagate': True,
            'level': 'INFO',
        },
        'django.request': {
            'handlers': ['error-file'],
            'level': 'ERROR',
            'propagate': False,
        },
        'moboo.custom': {
            'handlers': ['console', 'info-file', 'error-file'],
            'level': 'INFO',
        }
    }
}
