
import base64
from StratFit import settings
from StratFit.settings import S3URL, PAGING_ROWS
#from django.shortcuts import render
# Create your views here.
from django.shortcuts import render
#from rest_framework.renderers import JSONRenderer
from rest_framework.views import APIView
from rest_framework.response import Response
from django.core.cache import caches, cache
from django.forms.models import model_to_dict
from django.utils import timezone
from UserProgram.models import UserPlan, UserTestPlan, UserActions
from django.db import connection
from django.core.exceptions import ValidationError
from utility.models import Goals, ProgramType, Videos, PlanPurposes, PlanAbilities, PriceMapping, \
    PriceConversion, Country, \
    TmaxLookup, AppVersion, AdvExercises, NewExercise
from rest_framework.decorators import api_view, authentication_classes, permission_classes
from rest_framework.response import Response
from django.views.decorators.cache import never_cache
from Subscriber.views import dictfetchall
from django.db.models import Max, Min, Avg, Q, F, Count
from Celebrity.models import CelebrityPlansLikes, CelebrityUploads
from Subscriber.models import User, FitnessProfile, trainerProfile, Userfollow, UserAddress, goals
from Subscriber.serializers import AuthResponseSerializer
from Subscriber.Authentication import StartFitAuthentication, SessionAuthentication, StartFitSessionUtil, AuthResponse, \
    IsAuthenticated
from partner.models import PlanMonetization    
from Program.models import PlanRating
from django.core.mail import EmailMessage
import json
try: # for pip >= 10
    from pip._internal.req.req_install import logger
except ImportError: # for pip <= 9.0.3
    from pip.req.req_install import logger
# Create your views here.
from rest_framework.generics import (
    ListAPIView,
    ListCreateAPIView,
    RetrieveAPIView,
    RetrieveUpdateDestroyAPIView,
    RetrieveDestroyAPIView
)
#from rest_framework.permissions import IsAuthenticated
from .models import Plan, Plan_level, Plan_Purpose, \
   Plan_Period, Plan_Mesocycle, Plan_Microcycles, Plan_Days, \
   Plan_Sessions, Plan_Activity,Plan_Round, Plan_Actions, DraftedPlan, PlanGoals, SelectedAbilities, PlanShortUrls, PlanCountry, CoachCountry, PlanComments,PlanVideos,PlanExComments,PlanExTmax,MetabolicValues,CategoryLevel,GymCountry
from Program.utilities import *
from django.http import JsonResponse
from rest_framework import status
import string
import random
from django.forms.models import model_to_dict
def num_and_alpha(strlength=36):
    lettersanddigit=string.ascii_letters+string.digits
    return ''.join(random.choice(lettersanddigit)for i in range(strlength))

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def ExercisesView(request) :
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        user = username['id']
        if username != None:
            try:
                planId = json.loads(request.body.decode('utf-8'))
                jsonDetails = DraftedPlan.objects.select_related('User__id', 'Plan__id').filter(createdBy_id=user,
                                                                                                planId_id=planId[
                                                                                                    'plan_id']).values(
                    'planJson', 'status', 'planId_id__planStatus', 'id')
                if jsonDetails.exists():
                    for dt in jsonDetails:
                        dataObj = dict(dt)
                        print(dataObj)
                        if dataObj['planId_id__planStatus'] == 1 and dataObj['status'] == 1:
                            dataObj['status'] = 1
                        else:
                            dataObj['status'] = 0
                        draftId = dataObj['id']
                else:
                    dataObj = {'success': False}
                    return JsonResponse(dataObj)
                resp={}
                planDetails = json.loads(dataObj['planJson'])
                planInfo = planDetails['PlanInfo']
                planId = planInfo['id']
                data=planDetails['planstructure']
                print(data)
                def num_and_alpha(strlength=36):
                    lettersanddigit=string.ascii_letters+string.digits
                    return ''.join(random.choice(lettersanddigit)for i in range(strlength))

                resp["Success"]=True
                #print(data)
                rootnode=-1
                root=[]
                for i, d in enumerate(data) :
                    if d.get('parent', None) == 'root' :
                        #print("root found in.. ", d, " at index.. ", i)
                        rootnode=i
                        root.append(Node(d))
                stillmorenodespresent = True
                curr_nodes=root
                current_level=1
                while stillmorenodespresent :
                    # Find out the children of current_level
                    next_level=[]
                    for i,n in enumerate(curr_nodes) :
                        current_level_childs=[]
                        
                        cs = find_children(n,data)
                        n.children=cs
                        next_level=next_level+n.children
                    current_level = next_level[:]  
                    if current_level :
                        stillmorenodespresent = True
                        curr_nodes=current_level[:]
                    else :
                        stillmorenodespresent = False
                #resp["Message"]="Tree Constructed .. Inserts not done yet.."
                for rootnode in root[:]:

                    numofmesocycles=0
                    for n in rootnode.children: 
                        Meso_data=n
                        numofmesocycles = numofmesocycles+len(rootnode.children)
                        numberofmicrocycles=0
                        for n1 in n.children :
                            Micro_data=n1
                            Period=rootnode

                    period=Plan_Period.objects.create(plan_id_id=planId,period_name=rootnode.data['name'],status=1,num_of_mesocycles=numofmesocycles,num_of_microcycles=len(n.children),pdc_id=rootnode.data['id'],parent_id=rootnode.data['parent'],created_By_id=6,modified_By_id=6)
                    period.save()
                    
                    # Completed PERIOD
                    for n in rootnode.children:
                    
                        Meso=Plan_Mesocycle.objects.create(plan_id_id=planId,period_id_id=period.id,mesocycles_name=n.data['name'],num_of_microcycles=len(n.children),status=1,created_By_id=6,modified_By_id=6,pdc_id=n.data['id'],parent_id=n.data['parent'])
                        Meso.save()
                        gh=Plan.objects.get(id=planId)
                        print("Meso",Meso.num_of_microcycles)
                        gh.duration_weeks=Meso.num_of_microcycles
                        gh.save()
                        
                        #Completed MESO

                        
                        for n1 in n.children :
                            
                            Micro=Plan_Microcycles.objects.create(plan_id_id=planId,period_id_id=period.id,meso_id_id=Meso.id,micro_name=Micro_data.data['name'],status=1,num_of_days=len(n1.children),total_load=0,created_By_id=6,modified_By_id=6,pdc_id=n1.data['id'],parent_id=n1.data['parent'])
                            Micro.save()
                            print("n2 will be days..")
                            for n2 in n1.children :
                                
                                for n3 in n2.children:
                                    session=n3
                                Days=Plan_Days.objects.create(plan_id_id=planId,period_id_id=period.id,meso_id_id=Meso.id,micro_id_id=Micro.id,day_name=n2.data['name'],status=1,num_of_sessions=len(n2.children),total_load=0,rest_time=0,created_By_id=6,modified_By_id=6,pdc_id=n2.data['id'],parent_id=n2.data['parent'])
                                Days.save()
                                
                                # Completed Days!!
                                # n3 will be sessions
                                for n3 in n2.children:
                                    Sessions=Plan_Sessions.objects.create(plan_id_id=planId,period_id_id=period.id,meso_id_id=Meso.id,micro_id_id=Micro.id,day_id_id=Days.id,session_name=n3.data['name'],status=1,total_load=0,rest_time=0,num_of_exercises=len(n3.children),created_By_id=6,modified_By_id=6,pdc_id=n3.data['id'],parent_id=n3.data['parent'])
                                    Sessions.save()
                                    print("n4  is Activity")
                                    
                                    
                                    for n4 in n3.children:
                                        Activity=Plan_Activity.objects.create(plan_id_id=planId,period_id_id=period.id,meso_id_id=Meso.id,micro_id_id=Micro.id,day_id_id=Days.id,session_id_id=Sessions.id,status=1,Activity_name=n4.data['name'],Activity_type=n4.data['details']['folderName'],total_load=0,rest_time=0,warm_up=0,created_By_id=6,modified_By_id=6,pdc_id=n4.data['id'],parent_id=n4.data['parent'])
                                        Activity.save()
                                        print(n4.data['details']['folderName'],"sghddddddddddda")
                                        if (n4.data['details']['folderName']=="Simple"):
                                            
                                            for actionnode in n4.children :
                                                Rounds=Plan_Round.objects.create(plan_id_id=planId,period_id_id=period.id,meso_id_id=Meso.id,micro_id_id=Micro.id,day_id_id=Days.id,session_id_id=Sessions.id,activity_id_id=Activity.id,round_name='round',description="Round exercises",round_type=n4.data['details']['folderName'],status=1,num_of_actions=len(n4.children),total_load=0,rest_time=0,created_By_id=6,modified_By_id=6,pdc_id=num_and_alpha(),parent_id=actionnode.data['parent'])
                                                Rounds.save()
                                                
                                                if 'exerciseName' or 'exercise' in actionnode.data['details']:
                                                    print('dchccccccccccccscgsdcsdj',actionnode.data['details'])
                                                    if 'exercise' in actionnode.data['details']:
                                                        #exId=actionnode.data['details']['exerciseName']
                                                        print("dhsjdgjshdgksgsjdgjsvcjhvsvcjsv")
                                                        if 'speedPotency' in actionnode.data['details']:
                                                            speedPotency=actionnode.data['details']
                                                        else:
                                                            speedPotency=0  
                                                        if 'speedStrengthPotency' in actionnode.data['details']:
                                                            Speedstrength=actionnode.data['details']
                                                        else:
                                                            Speedstrength=0
                                                        print(Speedstrength,"djggggggggggggggggggggggggggggggggggggggggggggggggggggggfdddddddddddd")              
                                                        Actions=Plan_Actions.objects.create(plan_id_id=planId,period_id_id=period.id,meso_id_id=Meso.id,micro_id_id=Micro.id,day_id_id=Days.id,session_id_id=Sessions.id,activity_id_id=Activity.id,round_id_id=Rounds.id,exercise_id_id=actionnode.data['details']['exercise'],selected_RPE=actionnode.data['details']['selectedRPE'],num_of_sets=actionnode.data['details']['num_of_sets'],min_reps=0,max_reps=99,prescribed_reps=actionnode.data['details']['num_of_reps'],all_out=0,intensity=actionnode.data['details']['intensity'],intensity_range=1,calculated_ability=0,intensity_level=0,extra_ability=0,hypertrophy_potency=actionnode.data['details']['hypertrophyPotency'],lactate_generate_potency=actionnode.data['details']['lactateGenerationPotency'],strength_speed_potency=actionnode.data['details']['strengthSpeedPotency'],speed_potency=speedPotency,speed_strength_potency=Speedstrength,maxstrength_potency=actionnode.data['details']['maxStrengthPotency'],strength_potency_zone=0,strength_endurance_potency=0,instruction='',rest_time=0,created_By_id=6,modified_By_id=6,pdc_id=actionnode.data['id'],parent_id=Rounds.pdc_id)
                                                        print("hfkhfffffffffffffffffffffffffffffkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkllllllllllllllllllllllllllllllllllllllllllllllllllll")
                                                    if 'exerciseName' in actionnode.data['details']:
                                                        print(actionnode.data['details']['exerciseName'],"kjsdgsaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaggg")
                                                        if 'speedPotency' in actionnode.data['details']:
                                                            speedPotency=actionnode.data['details']
                                                        else:
                                                            speedPotency=0  
                                                        if 'speedStrengthPotency' in actionnode.data['details']:
                                                            Speedstrength=actionnode.data['details']
                                                        else:
                                                            Speedstrength=0
                                                        print(Speedstrength,"djggggggggggggggggggggggggggggggggggggggggggggggggggggggfdddddddddddd")              
                                                        Actions=Plan_Actions.objects.create(plan_id_id=planId,period_id_id=period.id,meso_id_id=Meso.id,micro_id_id=Micro.id,day_id_id=Days.id,session_id_id=Sessions.id,activity_id_id=Activity.id,round_id_id=Rounds.id,exercise_id_id=actionnode.data['details']['exerciseName'],selected_RPE=actionnode.data['details']['selectedRPE'],num_of_sets=actionnode.data['details']['num_of_sets'],min_reps=0,max_reps=99,prescribed_reps=actionnode.data['details']['num_of_reps'],all_out=0,intensity=actionnode.data['details']['intensity'],intensity_range=1,calculated_ability=0,intensity_level=0,extra_ability=0,hypertrophy_potency=actionnode.data['details']['hypertrophyPotency'],lactate_generate_potency=actionnode.data['details']['lactateGenerationPotency'],strength_speed_potency=actionnode.data['details']['strengthSpeedPotency'],speed_potency=speedPotency,speed_strength_potency=Speedstrength,maxstrength_potency=actionnode.data['details']['maxStrengthPotency'],strength_potency_zone=0,strength_endurance_potency=0,instruction='',rest_time=0,created_By_id=6,modified_By_id=6,pdc_id=actionnode.data['id'],parent_id=Rounds.pdc_id)
                                                        
                                                if 'type' in actionnode.data['details'] and actionnode.data['details']['type']=='warmup':
                                                    
                                                    for action in n4.children :
                                         
                                                        if 'exerciseName' or 'exercise' in action.data['details']:
                                                            
                                                            if 'exerciseName' in action.data['details']:
                                                                exId=action.data['details']['exerciseName']
                                                            if 'exercise' in action.data['details']:
                                                                exId=action.data['details']['exercise'] 
                                                           
                                                    Action=Plan_Actions.objects.create(plan_id_id=planId,period_id_id=period.id,meso_id_id=Meso.id,micro_id_id=Micro.id,day_id_id=Days.id,session_id_id=Sessions.id,activity_id_id=Activity.id,round_id_id=Rounds.id,exercise_id_id=exId,num_of_sets=0,min_reps=0,max_reps=99,prescribed_reps=actionnode.data['details']['num_of_reps'],all_out=0,intensity=actionnode.data['details']['intensity'],intensity_range=1,calculated_ability=0,intensity_level=0,extra_ability=0,hypertrophy_potency=0,lactate_generate_potency=0,strength_speed_potency=0,speed_potency=0,speed_strength_potency=0,maxstrength_potency=0,strength_potency_zone=0,action_type="warmup",strength_endurance_potency=0,instruction='',rest_time=0,created_By_id=6,modified_By_id=6,pdc_id=actionnode.data['id'],parent_id=Rounds.pdc_id)
                                                    print("hjkjffffffffgfhskfjsfsj") 
                                                
                                        if (n4.data['details']['folderName']=="Complex"):
                                            for n5 in n4.children:
                                                print("Complex Round")
                                                print(n5)
                                                Rounds=Plan_Round.objects.create(plan_id_id=planId,period_id_id=period.id,meso_id_id=Meso.id,micro_id_id=Micro.id,day_id_id=Days.id,session_id_id=Sessions.id,activity_id_id=Activity.id,round_name=n5.data['name'],description="Round exercises",round_type=n5.data['details']['folderName'],status=1,num_of_actions=len(n4.children),total_load=0,rest_time=0,created_By_id=6,modified_By_id=6,pdc_id=n5.data['id'],parent_id=n5.data['parent'])
                                                print("hi Round")
                                                Rounds.save()
                                                for actionnode in n5.children:
                                                    print(actionnode)
                                                    if 'exerciseName' in actionnode.data['details']:
                                                        print("Exercise Exists")
                                                        Actions=Plan_Actions.objects.create(plan_id_id=planId,period_id_id=period.id,meso_id_id=Meso.id,micro_id_id=Micro.id,day_id_id=Days.id,session_id_id=Sessions.id,activity_id_id=Activity.id,round_id_id=Rounds.id,exercise_id_id=actionnode.data['details']['exerciseName'],num_of_sets=actionnode.data['details']['num_of_sets'],min_reps=0,max_reps=99,prescribed_reps=actionnode.data['details']['num_of_reps'],all_out=0,intensity=actionnode.data['details']['intensity'],intensity_range=1,calculated_ability=0,intensity_level=0,extra_ability=0,hypertrophy_potency=0,lactate_generate_potency=0,strength_speed_potency=0,speed_potency=0,speed_strength_potency=0,maxstrength_potency=0,strength_potency_zone=0,strength_endurance_potency=0,selected_RPE=0,instruction='',rest_time=0,created_By_id=6,modified_By_id=6,pdc_id=actionnode.data['id'],parent_id=Rounds.pdc_id)
                                                    else:
                                                        print("Exercise not Exists");
                                                        for checknode in n5.children:
                                                            if 'exerciseName' in checknode.data['details']:
                                                                exerciseId = checknode.data['details']['exerciseName']
                                                                break
                                                        print("exerciseId", exerciseId);
                                                        Actions=Plan_Actions.objects.create(plan_id_id=planId,period_id_id=period.id,meso_id_id=Meso.id,micro_id_id=Micro.id,day_id_id=Days.id,session_id_id=Sessions.id,activity_id_id=Activity.id,round_id_id=Rounds.id,exercise_id_id=exerciseId,num_of_sets=1,min_reps=0,max_reps=99,prescribed_reps=actionnode.data['details']['num_of_reps'],all_out=0,intensity=actionnode.data['details']['intensity'],intensity_range=1,calculated_ability=0,intensity_level=0,extra_ability=0,hypertrophy_potency=0,lactate_generate_potency=0,strength_speed_potency=0,speed_potency=0,speed_strength_potency=0,maxstrength_potency=0,strength_potency_zone=0,strength_endurance_potency=0,selected_RPE=0,instruction='',rest_time=0,created_By_id=6,modified_By_id=6,pdc_id=actionnode.data['id'],parent_id=Rounds.pdc_id, action_type="warmup")
                print("gdssssssssssssssshf")
                planCountry1 = PlanCountry.objects.create(
                    plan_id=planId,
                    country_id=88
                )
                planCountry1.save()
                planCountry2 = PlanCountry.objects.create(
                    plan_id=planId,
                    country_id=190
                )
                planCountry2.save()

                planInf = Plan.objects.get(pk=planId)
                planInf.planStatus = True
                planInf.save()                                    

                updateDraft = DraftedPlan.objects.get(pk=draftId)
                updateDraft.status = 1
                updateDraft.save()                            
                
                
                
                resp['message']="Data stored successfully"                                 
                return Response(resp)
            except Exception as e:
                e="please enter valid id"
                resp['message']=e
        else:
            return JsonResponse({"success": False, "message": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@never_cache
def PlanView(request):
    data=request.data
    vid=data['id']
    try:
        if(vid):
            user1=UserPlan.objects.get(id=vid)
            planid=user1.plan_id
            plan_details=Plan.objects.filter(id=planid).values('id','name','description','status','num_of_periods','num_of_microcycles','activation_status','cover_img','thumb_img')
            period_Arr=[]
            meso_Arr=[]
            micro_Arr=[]
            days_Arr=[]
            session_Arr=[]
            activity_Arr=[]
            actions_Arr=[]
            plan_Arr=[]
            plan_dict={}
            resp={}
            for data in plan_details:
                plan_data=dict(data)
                period_details=Plan_Period.objects.filter(plan_id=plan_data['id']).values('id','plan_id','period_name','status','description','num_of_mesocycles','num_of_microcycles')
                print(plan_data)
                for data1 in period_details[::]:
                    period_data=data1
                    meso_details=Plan_Mesocycle.objects.filter(period_id=period_data['id']).values('id','plan_id','period_id','mesocycles_name','description','num_of_microcycles','status')


                    for data2 in meso_details[::]:
                        meso_data=data2
                        micro_details=Plan_Microcycles.objects.filter(meso_id=meso_data['id']).values('id','plan_id','period_id','meso_id','micro_name','description','status','num_of_days','total_load')

                        for data3 in micro_details[::]:
                            micro_data=data3
                            days_details=Plan_Days.objects.filter(micro_id=micro_data['id']).values('id','plan_id','period_id','meso_id','micro_id','day_name','description','status','num_of_sessions','total_load','rest_time')

                            for data4 in days_details[::]:
                                day_data=data4
                                session_details=Plan_Sessions.objects.filter(day_id=day_data['id']).values('id','plan_id','period_id','meso_id','micro_id','day_id','session_name','description','status','num_of_exercises','total_load','rest_time')

                                for data5 in session_details[::]:
                                    session_data=data5
                                    activity_details=Plan_Activity.objects.filter(session_id=session_data['id']).values('id','plan_id','period_id','meso_id','micro_id','day_id','session_id','Activity_name','description','status','num_of_actions','total_load','rest_time','warm_up')

                                    for data6 in activity_details[::]:
                                        activity_data=data6
                                        action_details=Plan_Actions.objects.filter(activity_id=activity_data['id']).values('id','plan_id','period_id','meso_id','micro_id','day_id','session_id','activity_id','exercise_id','intensity_range','num_of_sets','min_reps','max_reps','prescribed_reps','all_out','intensity','instruction','rest_time','calculated_ability','intensity_level','extra_ability','hypertrophy_potency','lactate_generate_potency','strength_speed_potency','strength_potency_zone','strength_endurance_potency')

                                        for data7 in action_details[::]:
                                            action_data=data7
                                            actions_Arr.append(action_data)

                                        act_dict={"ActivityInfo":activity_data,"ActionInfo":actions_Arr}
                                        activity_Arr.append(act_dict)
                                        actions_Arr=[]
                                    #activity_Arr.append(act_dict)
                                    session_dict={"SessionInfo":session_data,"ActivityList":activity_Arr}
                                    session_Arr.append(session_dict)
                                    activity_Arr=[]
                                days_dict={"DaysInfo":day_data,"SessionList":session_Arr}
                                days_Arr.append(days_dict)
                                session_Arr=[]
                            micro_dict={"MicroInfo":micro_data,"DaysList":days_Arr}
                            micro_Arr.append(micro_dict)
                            days_Arr=[]

                        meso_dict={"MesoInfo":meso_data,"MicroList":micro_Arr}
                        meso_Arr.append(meso_dict)
                        micro_Arr=[]
                    period_dict={"PeriodInfo":period_data,"MesoList":meso_Arr}
                    period_Arr.append(period_dict)
                    meso_Arr=[]
                plan_dict={"planInfo":plan_data,"PeriodList":period_Arr}

                plan_Arr.append(plan_dict)
                period_Arr=[]



            resp["message"] =plan_dict



        else:
            resp['message']="please subscribe a plan"


    except Exception as e:
        e="please enter valid id"
        resp['success']=False
        resp['message']=e


    return Response(resp)

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def Plan_Details(request):
    data= request.data
    resp={}
    stratsessionutil = StartFitSessionUtil()
    planDetails={}
    planId=data['id']
    info={}
    lookuptable_key=planId
    cachesession=cache.get(lookuptable_key)
    userPlanActions = []
    #cachesession=[]
    try:
        username = stratsessionutil.get_user_insession(request)
        user = username['id']
        if username != None:
            try:
                vid=data['id']
                if cachesession :
                    if planId: 
                        print("session token: ", lookuptable_key, "exists in cache")
                        userPlanActions = []
                        info=cachesession
                        planDetails=info[planId]
                    
                else:
                    if planId: 
                        
                        vid=data['id']
                        plan=[]
                        userPlanActions = []

                        perioddata=Plan_Period.objects.filter(plan_id=vid).values()
                        for i in perioddata[::]:
                            i["depthlevel"]=0
                            plan.append(i)
                        mesodata=Plan_Mesocycle.objects.filter(plan_id=vid).values()
                        for i in mesodata[::]:
                            i["depthlevel"]=1
                            plan.append(i)
                        microdata=Plan_Microcycles.objects.filter(plan_id=vid).values()
                        for i in microdata[::]:
                            i["depthlevel"]=2
                            plan.append(i)
                        daydata=Plan_Days.objects.filter(plan_id=vid).values()
                        for i in daydata[::]:
                            i["depthlevel"]=3
                            plan.append(i)
                        sessiondata=Plan_Sessions.objects.filter(plan_id=vid).values()
                        for i in sessiondata[::]:
                            i["depthlevel"]=4
                            plan.append(i)
                        activitydata=Plan_Activity.objects.filter(plan_id=vid).values()
                        for i in activitydata[::]:
                            i["depthlevel"]=5
                            plan.append(i)
                        rounddata=Plan_Round.objects.filter(plan_id=vid).values()
                        for i in rounddata[::]:
                            i["depthlevel"]=6
                            plan.append(i)
                        actiondata=Plan_Actions.objects.filter(plan_id=vid).values()
                        for i in actiondata[::]:
                            i["depthlevel"]=7
                            plan.append(i)
                            
                        planDetails['plan']=plan
                        planDetails['id']=planId
                        info[planDetails['id']]=planDetails
                        lookuptable_key=planDetails['id'] 
                        cache.set(lookuptable_key,info)
                        
                userplanDetails = UserPlan.objects.filter(user_id=user, status=1, plan_id=vid).values('plan_id', 'id', 'status')
               
                if userplanDetails.exists():
                    print("Userplan exists")
                    for data in userplanDetails:
                        dt = dict(data)
                        print(dt)
                        userProgramId = dt['id']
                        userProgramActions = UserActions.objects.select_related('Plan_Actions__id').filter(userplan_id = userProgramId).values('height', 'totalReps', 'sessionStatus','advTime', 'createdDate', 'actionStatus', 'planaction_id', 'userplan_id', 'actionIntensity', 'actionWorkWeight', 'speed', 'actionSkip', 'plan_id', 'actionTmax', 'user_id', 'advDistance', 'id', 'exercise_id', 'actionDate', 'planaction_id__day_id_id', 'planaction_id__activity_id_id', 'planaction_id__round_id_id', 'planaction_id__session_id_id')
                        if userProgramActions.exists():
                            print("userProgramActions exists")
                            for uadata in userProgramActions:
                                udt = dict(uadata)
                                userPlanActions.append(udt)   
                        else:
                            print("userProgramActions not exists")
                            userPlanActions = []
                else:
                    print("does not exist")
                    planids = None
                    print("What can I do")
                return JsonResponse({"success": True, "planStructure":planDetails['plan'], "planCompleted":userPlanActions})
            except Exception as e:
                e="please enter valid id"
                resp['message']=e
        else:
            return JsonResponse({"success": False, "message": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})


def ExerciseList(request):
    data=request.data
    resp={}
    try:


        vid=data['id']
        actions=Plan_Actions.objects.filter(plan_id=vid).values()
        exercises_id=[]

        resp={}
        for i in actions[::]:
            exercises_id.append(i['exercise_id_id'])
        def duplicate_remove(exercises_id):
            exercise_id=[]
            for num in exercises_id:
                if num not in exercise_id:
                    exercise_id.append(num)
            return exercise_id
        for i in duplicate_remove(exercises_id):
            exercises=NewExercise.objects.filter(id=i).values()
            resp['message']=exercises


    except Exception as e:
        e="plese enter valid id"
        resp['message']=e
    return Response(resp)


@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def savePlanJson(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        info = json.loads(request.body.decode('utf-8'))
        user = username['id']
        if username != None:
            planJson = json.loads(request.body.decode('utf-8'))
            if 'id' in planJson['plan']['PlanInfo']:
                updateJson = DraftedPlan.objects.filter(planId_id=planJson['plan']['PlanInfo']['id'],
                                                        createdBy_id=user).values('id', 'planId_id')
                print(updateJson)
                if updateJson.exists():
                    for dt in updateJson:
                        dataObj = dict(dt)
                    update = DraftedPlan.objects.get(pk=dataObj['id'])
                    update.planJson = json.dumps(planJson['plan'])
                    update.createdBy_id = user
                    update.modifiedBy_id = user
                    update.save()
                    draftId = update.id
                else:
                    print(planJson['plan']['PlanInfo'])
                    createJson = DraftedPlan.objects.create(
                        planJson=json.dumps(planJson['plan']),
                        planId_id=planJson['plan']['PlanInfo']['id'],
                        createdBy_id=user,
                        modifiedBy_id=user
                    )
                    createJson.save()
                    draftId = createJson.id
            return JsonResponse({"success": True, "message": "Draft Saved Successfully", "draftId": draftId})
        else:
            return JsonResponse({"success": False, "message": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})



@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def publishToDraft(request):
    stratsessionutil = StartFitSessionUtil()
    planid= json.loads(request.body.decode('utf-8'))
    try:
        username = stratsessionutil.get_user_insession(request)
        if username != None:
            program=Plan.objects.filter(id=planid['id']).values()
            print(program[0]['planStatus'],"ggggggggggggggggggggggggggggggggggggggggggggg")
            if program.exists():
                if program[0]['planStatus']==1:
                    plan=Plan_Actions.objects.filter(plan_id_id=planid['id']).delete()
                    rounds=Plan_Round.objects.filter(plan_id_id=planid['id']).delete()
                    activity=Plan_Activity.objects.filter(plan_id_id=planid['id']).delete()
                    session=Plan_Sessions.objects.filter(plan_id_id=planid['id']).delete() 
                    day= Plan_Days.objects.filter(plan_id_id=planid['id']).delete()
                    micro=Plan_Microcycles.objects.filter(plan_id_id=planid['id']).delete()
                    meso= Plan_Mesocycle.objects.filter(plan_id_id=planid['id']).delete()
                    period=Plan_Period.objects.filter(plan_id_id=planid['id']).delete()
                    Program=Plan.objects.get(id=planid['id'])
                    Program.planStatus=0
                    Program.save() 
                else:  
                    plan=Plan_Actions.objects.filter(plan_id_id=planid['id']).delete()
                    rounds=Plan_Round.objects.filter(plan_id_id=planid['id']).delete()
                    activity=Plan_Activity.objects.filter(plan_id_id=planid['id']).delete()
                    session=Plan_Sessions.objects.filter(plan_id_id=planid['id']).delete() 
                    day= Plan_Days.objects.filter(plan_id_id=planid['id']).delete()
                    micro=Plan_Microcycles.objects.filter(plan_id_id=planid['id']).delete()
                    meso= Plan_Mesocycle.objects.filter(plan_id_id=planid['id']).delete()
                    period=Plan_Period.objects.filter(plan_id_id=planid['id']).delete()
                    plan=Plan.objects.get(id=planid['id'])
                    plan.planStatus=0
                    plan.save()
                Draft=DraftedPlan.objects.filter(planId=planid['id'])
                if Draft.exists():
                    Draftmode=DraftedPlan.objects.get(planId=planid['id'])
                    Draftmode.status=0
                    Draftmode.save()
                return JsonResponse({"success":True,"message":"Plan changed to Daftmode successfully"})    
            else:
                return JsonResponse({"success":False,"message":"There is no plan with this planId"})                
        else:
            return JsonResponse({"success": False, "message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def deletePlan(request):
    stratsessionutil = StartFitSessionUtil()
    planInfo= json.loads(request.body.decode('utf-8'))
    try:
        username = stratsessionutil.get_user_insession(request)
        if username != None:
            if planInfo['id'] != None:
                act=Plan_Actions.objects.filter(plan_id_id=planInfo['id']).delete()
                rounds=Plan_Round.objects.filter(plan_id_id=planInfo['id']).delete()
                activity=Plan_Activity.objects.filter(plan_id_id=planInfo['id']).delete()
                session=Plan_Sessions.objects.filter(plan_id_id=planInfo['id']).delete() 
                day= Plan_Days.objects.filter(plan_id_id=planInfo['id']).delete()
                micro=Plan_Microcycles.objects.filter(plan_id_id=planInfo['id']).delete()
                meso= Plan_Mesocycle.objects.filter(plan_id_id=planInfo['id']).delete()
                period=Plan_Period.objects.filter(plan_id_id=planInfo['id']).delete()
                plan=Plan.objects.filter(id=planInfo['id']).delete()
                draft=DraftedPlan.objects.filter(planId=planInfo['id']).delete()
                return JsonResponse({"success":True,"message":"Your Program Deleted Successfully"})
            else:
                return JsonResponse({"success":False,"message":"There is no plan with this planId"})    
        else:
            return JsonResponse({"success": False, "message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})
  








@api_view(['GET', 'POST'])
@never_cache
def programStats(request):
    
    coaches = User.objects.filter(userType=3).values('id')
    coach=[]
    for dt in coaches:
        coachval=dict(dt)
        coach.append(coachval['id'])
    print(coach)
    fullplans=Plan.objects.all().filter(planStatus=1,createdBy_id__in=coach)
    
    print(fullplans)
    array1=[]
    array2=[]
    array3=[]
    coach1=[]
    coach2=[]
    coach3=[]
    listofcoachs=[]
    level={}
    print(fullplans,"fffffffffffffffffffffffff")
    def duplicate_remove(originalplanner):
                    original=[]
                    for num in originalplanner:
                        if num not in original:
                            original.append(num)
                    return original
    listofcoachs1=[]
    listofcoachs2=[]                
    for dt in fullplans:
        plans=model_to_dict(dt)
        print(plans,"fggggggggggggggggggggggggg")
        if plans['programType'] == 1:
            array1.append(plans['programType'])
            coach1.append(plans['createdBy'])
            listofcoachs=duplicate_remove(coach1)
        if plans['programType']==2:
            array2.append(plans['programType'])
            coach2.append(plans['createdBy'])
            listofcoachs1=duplicate_remove(coach2)
              
        if plans['programType']==3:
            array3.append(plans['programType'])
            coach3.append(plans['createdBy'])
            listofcoachs2=duplicate_remove(coach3)
    level['type1']=len(array1)
    level['coach1']=len(listofcoachs)
    level['type2']=len(array2)
    level['coach2']=len(listofcoachs1)
    level['type3']=len(array3)
    level['coach3']=len(listofcoachs2)      
    return JsonResponse({"success":True,"Beginner":level['type1'],"BeginnerCoach":level['coach1'],"Intermediate":level['type2'],"IntermediateCoach":level['coach2'],"Advanced":level['type3'],"AdvancedCoach":level['coach3']})








@api_view(['GET', 'POST'])
@never_cache
def deleteCache(request):
    info=json.loads(request.body.decode('utf-8'))
    cachesession=cache.get(info['key'])
    if cachesession !=None:

        cache.delete(info['key'])
        return JsonResponse({"success":True,"message":"Cache was deleted Successfully"})
    else:
        return JsonResponse({"success":False,"message":"please enter valid key"})


@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getDraftJson(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        info = json.loads(request.body.decode('utf-8'))
        user = username['id']
        if username != None:
            planId = json.loads(request.body.decode('utf-8'))
            jsonDetails = DraftedPlan.objects.select_related('User__id', 'Plan__id').filter(createdBy_id=user,
                                                                                            planId_id=planId[
                                                                                                'plan_id']).values(
                'planJson', 'status', 'planId_id__planStatus')
            if jsonDetails.exists():
                for dt in jsonDetails:
                    dataObj = dict(dt)
                    if dataObj['planId_id__planStatus'] == 1 and dataObj['status'] == 1:
                        dataObj['status'] = 1
                    else:
                        dataObj['status'] = 0
            else:
                dataObj = {'success': False}
            return JsonResponse(dataObj)
        else:
            return JsonResponse({"success": False, "message": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})

@api_view(['GET','POST'])
@never_cache
def getprogramPlans(request):
    resp={}
    plans=Plan.objects.filter(createdBy_id = 6).values()
    programplan=[]
    for i in plans:
        #dataObj = dict(i)
        programplan.append(i)
    resp['success']=True
    resp['programs']=programplan
    return Response(resp)

def celeblikes(planId):
    likeArr = []
    celeblikesVal = CelebrityPlansLikes.objects.select_related('User__id').filter(plan_id=planId, status=1).values('id',
                                                                                                                   'user_id',
                                                                                                                   'user_id__first_name',
                                                                                                                   'user_id__last_name',
                                                                                                                   'user_id__avatar')
    if celeblikesVal.exists():
        for val in celeblikesVal:
            valObj = dict(val)
            
            valObj['celebName'] = valObj['user_id__first_name'] + " " + valObj['user_id__last_name']
            likeArr.append(valObj)
        return likeArr

def celebreviewList(planId):
    reviewArr = []
    celeblikesVal = CelebrityPlansLikes.objects.select_related('User__id').filter(plan_id=planId).values('id',
                                                                                                         'user_id',
                                                                                                         'user_id__first_name',
                                                                                                         'user_id__last_name',
                                                                                                         'reviews',
                                                                                                         'user_id__avatar').exclude(
        reviews__isnull=True).exclude(reviews__exact='')
    if celeblikesVal.exists():
        for val in celeblikesVal:
            valObj = dict(val)
            
            valObj['celebName'] = valObj['user_id__first_name'] + " " + valObj['user_id__last_name']
            reviewArr.append(valObj)
        return reviewArr

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def filterSql2(request):
    print("hi")
    stratsessionutil = StartFitSessionUtil()
    filterSql={}
    lookuptable_key="FilterSQLv2"
    cachesession=cache.get(lookuptable_key)
    if cachesession :
        print("session token: ", lookuptable_key, "exists in cache")
        filterSql=cachesession
        try:
            username = stratsessionutil.get_user_insession(request)
            print(username)
            if username != None:
                return JsonResponse({"success": True, "filterValues": filterSql['plan'], "luctype": filterSql['luctype'],"dollarHighest": filterSql['dollarHighest'],"parentGoals":filterSql['parentGoals']})
            else:
                return JsonResponse({"success": False,"message":"User has logged out"})        
        except Exception as e:
            logger.exception("something wrong")
            return JsonResponse({"msg": str(e)})
    else:
        print("session token: ", lookuptable_key, "does NOT exists in cache")
        username = stratsessionutil.get_user_insession(request)
        if username != None:
            currencyType = 'INR'
            currencyValues = PriceConversion.objects.get(id=1)
            inrValue = currencyValues.inrValue
            #print(currencyType, "currencyType")
            coachInfo = json.loads(request.body.decode('utf-8'))
            print(coachInfo)
            planArr = []
            x = connection.cursor()
            coaches = False
            programtypeval = False
            abilityVal = False
            goalVal = False
            coachPriceVal = False
            userid = username['id']
            userCurrency = User.objects.get(id=userid)
            filterQuery = "SELECT Program_plan.*, Program_plan.goals as planGoal__goalName, utility_programtype.programTypeName as planType,Subscriber_user.first_name as createdBy_id__first_name,Subscriber_user.last_name as createdBy_id__last_name,Program_plan.goals as planGoal,Program_plan.price as planPrice,Program_plan.originalPlanner_id as originalPlanner,Program_plan.createdBy_id as createdBy,utility_programtype.programTypeName as programType__programTypeName,Subscriber_user.avatar as createdBy_id__avatar,Subscriber_user.id as coachId FROM Program_plan left join utility_programtype on Program_plan.programType_id = utility_programtype.id left join Subscriber_user on Program_plan.createdBy_id = Subscriber_user.id left join Program_selectedabilities on Program_plan.id = Program_selectedabilities.plan_id left join Program_plangoals on Program_plan.id = Program_plangoals.plan_id left join Program_plancountry on Program_plan.id = Program_plancountry.plan_id"
            print(filterQuery)
            if ('coachVal' in coachInfo and coachInfo['coachVal'] != '' and coachInfo['coachVal'] != '0') or (
                    'planVal' in coachInfo and coachInfo['planVal'] != '' and coachInfo['planVal'] != '0'):
                if coachInfo['coachVal'] == "1" and coachInfo['planVal'] == "1":
                    coaches = True
                    
                    filterQuery += " where (Subscriber_user.first_name like '%" + coachInfo[
                        'searchString'] + "%' or Program_plan.planName like '%" + coachInfo[
                                        'searchString'] + "%' or Subscriber_user.last_name like '%" + coachInfo[
                                        'searchString'] + "%')"
                elif coachInfo['coachVal'] == "1" and coachInfo['planVal'] == "0":
                    coaches = True
                    print("inHere1")
                    filterQuery += " where (Subscriber_user.first_name like '%" + coachInfo[
                        'searchString'] + "%' or Subscriber_user.last_name like '%" + coachInfo['searchString'] + "%')"
                elif coachInfo['coachVal'] == "0" and coachInfo['planVal'] == "1":
                    coaches = True
                    print("inHere2")
                    filterQuery += " where (Program_plan.name like '%" + coachInfo['searchString'] + "%') "
            else:
                if ('searchString' in coachInfo and coachInfo['searchString'] != ''):
                    coaches = True
                    filterQuery += " where (Subscriber_user.first_name like '%" + coachInfo[
                        'searchString'] + "%' or Program_plan.name like '%" + coachInfo[
                                        'searchString'] + "%' or Subscriber_user.last_name like '%" + coachInfo[
                                        'searchString'] + "%')"

            if 'programType' in coachInfo and coachInfo['programType'] != '':
                programtypeval = True
                programTypes = coachInfo['programType'].split(",")
                if coaches == True:
                    filterQuery += " and ("
                else:
                    filterQuery += " where ("
                tempText = ''
                for val in programTypes:
                    tempText += " Program_plan.programType_id = " + val + " or "
                if tempText != '':
                    filterQuery += tempText[:-3] + ")"
            if 'abilities' in coachInfo and coachInfo['abilities'] != '':
                print("inHEre3")
                abilityVal = True
                if programtypeval == True or coaches == True:
                    filterQuery += " and ("
                else:
                    filterQuery += " where ("
                selectedabilities = coachInfo['abilities'].split(",")
                tempText1 = ''
                for val1 in selectedabilities:
                    tempText1 += " Program_selectedabilities.ability_id = " + val1 + " or "
                if tempText1 != '':
                    filterQuery += tempText1[:-3] + ")"

                '''filterQuery += " Program_plan.ability =" +coachInfo['abilities']+ ")"'''
            
            
            if 'goals' in coachInfo and coachInfo['goals'] != '':
                print("inHEre5")
                goalVal = True
                if abilityVal == True or programtypeval == True or coaches == True:
                    filterQuery += " and ("
                else:
                    filterQuery += " where ("
                selectedgoals = coachInfo['goals'].split(",")
                tempText2 = ''
                for val1 in selectedgoals:
                    tempText2 += " Program_plangoals.planGoal_id = " + val1 + " or "
                if tempText2 != '':
                    filterQuery += tempText2[:-3] + ")"
            
                
            if 'price' in coachInfo and coachInfo['price'] != '':
                coachPrice = coachInfo['price'].split(",")
                coachPriceVal = True
                if abilityVal == True or goalVal == True or programtypeval == True or coaches == True:
                    filterQuery += " and"
                else:
                    filterQuery += " where"
                if 'deviceType' in coachInfo and coachInfo['deviceType'] == 'ios':
                    if userCurrency.currencyType == "INR":
                        if username['userCountry'] == 88:
                            filterQuery += " (Program_plan.indianIosPrice BETWEEN " + coachPrice[0] + " AND " + coachPrice[
                                1] + ")"
                        else:
                            filterQuery += " (Program_plan.iosPrice BETWEEN " + coachPrice[0] + " AND " + coachPrice[
                                1] + ")"
                    else:
                        maxINRPriceMapValue = \
                        PriceMapping.objects.filter(usd__range=[coachPrice[0], coachPrice[1]]).all().aggregate(
                            Max('inr'))['inr__max']
                        minINRPriceMapValue = \
                        PriceMapping.objects.filter(usd__range=[coachPrice[0], coachPrice[1]]).all().aggregate(
                            Min('inr'))['inr__min']
                        print(maxINRPriceMapValue)
                        print(minINRPriceMapValue)
                        for price in priceMapValues:
                            priceObj = dict(price)
                        if username['userCountry'] == 88:
                            filterQuery += " (Program_plan.indianIosPrice BETWEEN " + str(
                                minINRPriceMapValue) + " AND " + str(maxINRPriceMapValue) + ")"
                        else:
                            filterQuery += " (Program_plan.iosPrice BETWEEN " + str(minINRPriceMapValue) + " AND " + str(
                                maxINRPriceMapValue) + ")"


                else:
                    if username['userCountry'] == 88:
                        filterQuery += " (Program_plan.indianPrice BETWEEN " + coachPrice[0] + " AND " + coachPrice[
                            1] + ")"
                    else:
                        filterQuery += " (Program_plan.price BETWEEN " + coachPrice[0] + " AND " + coachPrice[1] + ")" 
            if abilityVal == True or goalVal == True or programtypeval == True or coaches == True or coachPriceVal == True:
                filterQuery += " and"
            else:
                filterQuery += " where"

            india = False
            countryID = UserAddress.objects.select_related('User__id').filter(country=88, user_id=userid).values()
            if countryID.exists():
                india = True
            if india == True:
                filterQuery += " Program_plancountry.country_id = 88 and "
            else:
                filterQuery += " Program_plancountry.country_id != 88 and "
            
            if 'deviceType' in coachInfo and coachInfo['deviceType'] == 'ios':
                '''
                if abilityVal == True or programtypeval == True or coaches == True or goalVal == True:
                    filterQuery += " and ("
                else:
                    filterQuery += " where ("
                '''    
                if 'packageName' in coachInfo and coachInfo['packageName'] == 'apolloLife':
                    filterQuery += " Program_plan.createdBy_id != 165 AND Program_plan.createdBy_id != 47 AND "
                filterQuery += " Program_plan.id is not null and activationStatus=1 and planStatus=1 GROUP BY Program_selectedabilities.plan_id,Program_plangoals.plan_id ORDER BY Program_plan.programType_id,Program_plan.planName ASC"
            else:
                '''
                if abilityVal == True or programtypeval == True or coaches == True or goalVal == True:
                    filterQuery += " and ("
                else:
                    filterQuery += " where ("
                '''    
                if 'packageName' in coachInfo and coachInfo['packageName'] == 'apolloLife':
                    filterQuery += " Program_plan.createdBy_id != 165 AND Program_plan.createdBy_id != 47 AND "
                print("here    in else")
                filterQuery += " Program_plan.id is not null and activationStatus=1 and planStatus=1 GROUP BY Program_plan.id,Program_selectedabilities.plan_id,Program_plangoals.plan_id ORDER BY Program_plan.programType_id,Program_plan.planName ASC"
            
            
            x.execute(filterQuery)
            resultQuery = dictfetchall(x)
            print("here in 252")
            
            # highestPrice= Plan.objects.filter(activation_status=1, status=1).all().aggregate(Max('price'))['price__max']
            highestPrice_dollar = Plan.objects.filter(activationStatus=1, planStatus=1).all().aggregate(Max('price'))[
                'price__max']
            arrgoals=[]
            clelebLikeArr = []
            celebreviewArr = []
            parentGoals1 = ''
            array=[]
            originalplanner=[]
            partner=[]
            arr=[]
            
            if resultQuery:
                for dt in resultQuery:
                    
                    dataObj = dict(dt)
                    arr.append(dataObj['id'])
                    originalplanner.append(dataObj['originalPlanner'])
                    partner.append(dataObj['createdBy_id'])
                    
                    
                        
                def duplicate_remove(originalplanner):
                    original=[]
                    for num in originalplanner:
                        if num not in original:
                            original.append(num)
                    return original
                array=duplicate_remove(arr)
                print(array)
                planner=User.objects.filter(id__in=duplicate_remove(originalplanner)).values()
                Partner=User.objects.filter(id__in=duplicate_remove(partner)).values()
                
                
                planlikes={}
                plalikescount = CelebrityPlansLikes.objects.filter(plan_id__in=array,status=1).values('plan_id').annotate(total=Count('user_id'))
                
                for i in plalikescount:
                    print(i['total'],"here counts")
                    planlikes[i['plan_id']]=i['total']
                '''
                celeblikesVal = CelebrityPlansLikes.objects.select_related('User__id').filter(plan_id__in=array, status=1).values('plan_id','id',
                                                                                                                        'user_id',
                                                                                                                        'user_id__first_name',
                                                                                                                        'user_id__last_name',
                                                                                                                        'user_id__avatar')
                    
                video={}
                planVideos=[]
                planvideos=PlanVideos.objects.filter(plan_id__in=array).values()
                for j in array:
                    for i in planvideos:
                        if j==i['plan_id']:
                            planVideos.append(i['video'])
                            video[i['plan_id']]=planVideos[0]
                    planVideos=[]
                '''
                planAbilityVals = SelectedAbilities.objects.select_related('PlanAbilities').filter(plan_id__in=array).values('ability_id__ability','plan_id')
                
                planPurposesVals = PlanGoals.objects.select_related('PlanPurposes').filter(plan_id__in=array).values('planGoal_id__GoalName','planGoal_id','plan_id')
                
                
                purposes={}

                ability={}    
                purpose=[]
                a=[]
                for j in array:
                    for i in planAbilityVals:
                    
                        if j==i['plan_id']:
                            a.append(i['ability_id__ability'])
                            #print(', '.join(a))
                            ability[i['plan_id']] = a
                    a=[]
                    for i in planPurposesVals:
                        if j==i['plan_id']:
                            purpose.append(i['planGoal_id__GoalName'])
                            purposes[i['plan_id']]=purpose
                    purpose=[]        
                
                ratingObj = PlanRating.objects.filter(plan__in=array).values()
                totalRate = 0
                userCount = 1
                for rt in ratingObj:
                    rateObj=dict(rt)
                    
                    if type(rateObj['rating']) != float:  
                        Rating=0
                    else:
                        Rating=rateObj['rating'] 
                          
                    totalRate=totalRate+Rating
                    userCount=userCount+1
                rating=totalRate/userCount
                exercises = Plan_Actions.objects.select_related('NewExercise').filter(plan_id__in=array).values('exercise_id', 'exercise_id__exerciseName', 'exercise_id__exerciseDesc', 'exercise_id__video','exercise_id__thumb_image','exercise_id__cover_image','exercise_id__equipment','plan_id').distinct() 
                exerview={}
                exer=[]
                for j in array:
                    for i in exercises:
                        if j==i['plan_id']:

                            exer.append(i)
                            exerview[i['plan_id']]=exer
                    exer=[]    

                downloadUsersp = UserPlan.objects.filter(plan_id__in=array).values('plan_id','user_id').annotate(total=Count('user_id'))
                
                dictarr=[]
                dictionary={}
                for j in array:
                    for i in downloadUsersp:
                            
                        if j==i['plan_id']:
                                
                            dictarr.append(i['total'])
                            num=len(dictarr)
                            dictionary[i['plan_id']]=num
                            num=[]
                    dictarr=[]
            
                for dt in resultQuery:
                 
                    dataObj = dict(dt)
                    sum=0
                    weeks={}
                    meso=Plan_Mesocycle.objects.values().filter(plan_id_id=dataObj['id'])
                    if meso.exists():
                        
                        for hg in meso:
                            micros=dict(hg)
                            sum=sum+micros['num_of_microcycles']
                            weeks['microcycles']=sum

                        dataObj['duration_weeks'] =weeks['microcycles']
                    secret_code_plain = dataObj['planName'] + '#' + str(dataObj['id'])
                    secret_code_encode = base64.b64encode(secret_code_plain.encode('ascii'))
                    encodedVal = str(secret_code_encode).split("'")
                    dataObj['encodedurl'] = encodedVal[1]
                    likearr=[]
                    dataObj['coachName'] = str(dataObj['createdBy_id__first_name'])  + " " + str(dataObj['createdBy_id__last_name'])
                    dataObj['createdBy_id__first_name'] = str(dataObj['createdBy_id__first_name']) + " " + str(dataObj['createdBy_id__last_name'])
                                        
                    for num in dictionary:
                        if dataObj['id'] in dictionary:

                            if dataObj['id']==num:
                                dataObj['planusers']=dictionary[num]
                        else:
                            dataObj['planusers']=0 
                    
                    planVideos=PlanVideos.objects.filter(plan_id=dataObj['id']).values('video')
                    if planVideos.exists():
                        for dt in planVideos:
                            videos=dict(dt)
                            dataObj['videos'] =dt['video'] 
                    else:
                        dataObj['videos']=" "    
         
                    
                    if dataObj['planType'] == "STARTER":
                        dataObj['planType'] = "Beginner"
                        dataObj['ptype'] = 'S'
                    elif dataObj['planType'] == "INTERMEDIATE":
                        dataObj['planType'] = "Intermediate"
                        dataObj['ptype'] = 'I'
                    elif dataObj['planType'] == "ADVANCED":
                        dataObj['planType'] = "Advanced"
                        dataObj['ptype'] = 'A'
                      
                    
                    dataObj['planCompetency'] = "0"    
                    
                    
                    for i in planner:
                        j=dict(i)
                        
                        if j['id']==dataObj['originalPlanner']:
                            
                            dataObj['oricoachName']=str(j['first_name'])+" "+str(j['last_name'])
                            dataObj['planDescription'] = dataObj['planDescription']
                    coachdetails= ""
                    if dataObj['licencePolicy'] == "3" or dataObj['licencePolicy'] == "White-Label":
                        for i in Partner:
                            j=dict(i)
                            print(j['first_name'])
                            if j['id']==dataObj['createdBy_id']:
                                
                                dataObj['planDescription'] = str(
                                dataObj['planDescription']) + "<br><h6>Copyright &copy; 2017 " + str(
                                str(j['first_name']) + " " + str(
                                j['last_name'])) + ". All rights reserved.</h6>"

                    else:
                        
                        #coachName = User.objects.get(id=dataObj['originalPlanner'])
                        coachdetails =  "<br><h6>Copyright &copy; 2017 " + dataObj['oricoachName'] + ". All rights reserved.</h6>"
                    '''        
                    downloadUsers = UserPlan.objects.filter(plan_id=dataObj['id']).values('user_id').distinct().count()
                    dataObj['downloadUsers']=downloadUsers
                    '''
                    goalsArr = dataObj['goals'].split(",")
                    planParentGoals = PlanPurposes.objects.filter(id__in=goalsArr).values(
                        'parentGoalName_id').distinct()
                    
                    parentGoals = []
                    for val in planParentGoals:
                        valObj = dict(val)
                        parentGoals.append(valObj['parentGoalName_id'])
                        parentGoals1 += "," + str(valObj['parentGoalName_id'])
        
                
                    dataObj['celeblikedPlan'] = 0
                    dataObj['celebreviewPlan'] = 0
                    dataObj['reviews'] = ''
                    dataObj['reviewsCount']=0
                    dataObj['price']='Free'
                    
                    Exercise=[]
                    for dt in exerview:
                        #j=dict(dt)
                        print(dt)
                        if dataObj['id'] in exerview:
                            if dataObj['id']==dt:
                                Exercise.append(exerview[dt])
                                #print(Exercise)
                                dataObj['exercises']=Exercise[0]  
                        else:
                            dataObj['exercises']=0
                    

                    for i in planlikes : 
                        if dataObj['id'] ==i:
                            print(i, planlikes[i]) 
                            dataObj['planlikesCount']=planlikes[i]
                    
                    
                    for i in ability:
                        if dataObj['id'] == i:
                            print(i,ability[i])
                            a=', '.join(ability[i])
                            dataObj['ability']=a
                            dataObj['ability1']=a
                            dataObj['planPurpose']=a
                            #dataObj['planDescription']=dataObj['planDescription']+"<br><br><font><b>"+"Abilities:</b>" + a + "font<b>"

                    for i in purposes:
                        if dataObj['id']== i:
                            print(i,purposes[i])
                            a=', '.join(purposes[i])
                            dataObj['PlanPurposes']=a
                            dataObj['plan_goals']=a
                            dataObj['plan_goals1']=a
                            #dataObj['planDescription']=dataObj['planDescription']+"Purposes:</b>" + a  +"</font><br><h6>"+coachdetails
                    if dataObj['others']!=None:        
                        dataObj['PlanPurposes']+= ","+dataObj['others']        
                    
                    totalRate = 0
                    userCount = 1
                    
                    for rt in ratingObj:
                    
                        rateObj=dict(rt)
                        if rateObj['plan_id'] == dataObj['id']:
                            if type(rateObj['rating']) != float:
                                Rating=0
                            else:
                                Rating=rateObj['rating']    
                            totalRate=totalRate+Rating
                            userCount=userCount+1
                    rating=totalRate/userCount       
                    dataObj['Planrating']=rating       
                    

                    dataObj['parentGoal'] = parentGoals
                    planArr.append(dataObj)
                if parentGoals1 != '':
                        parentGoals1 = parentGoals1[1:]
                        PrntGlArr = parentGoals1.split(",")
                        ParentGoals = PlanPurposes.objects.filter(id__in=PrntGlArr).values('id','GoalName').distinct()
                        parGoals = []
                        for val in ParentGoals:
                            valObj = dict(val)
                            parGoals.append({"id":valObj['id'],"name":valObj['GoalName']})
                else:
                        planGoals1 = ""  
            else:
                planArr=[]
                parGoals=[] 
            filterSql['plan']=planArr
            filterSql['luctype']=userCurrency.currencyType
            filterSql['dollarHighest']=highestPrice_dollar
            filterSql['parentGoals']=parGoals      
            cache.set(lookuptable_key,filterSql)
            print("fgffffffffffffffffffffffgggggggggg")
            
            return JsonResponse({"success": True, "filterValues": filterSql['plan'], "luctype": filterSql['luctype'],"dollarHighest": filterSql['dollarHighest'],"parentGoals":filterSql['parentGoals']})
        else:
            return JsonResponse({"success": False,"message":"User has logged out"})        
                                 
    #return JsonResponse({"success": True, "filterValues": filterSql['plan'], "luctype": filterSql['luctype'],"dollarHighest": filterSql['dollarHighest'],"parentGoals":filterSql['parentGoals']})
        
            
    

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def filterSql1(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        print(username)
        if username != None:
            currencyType = username['currencyType']
            currencyValues = PriceConversion.objects.get(id=1)
            inrValue = currencyValues.inrValue
            print(currencyType, "currencyType")
            coachInfo = json.loads(request.body.decode('utf-8'))
            planArr = []
            x = connection.cursor()
            coaches = False
            programtypeval = False
            abilityVal = False
            goalVal = False
            coachPriceVal = False
            userid = username['id']
            userCurrency = User.objects.get(id=userid)
            filterQuery = "SELECT Program_plan.*, Program_plan.goals as planGoal__goalName, utility_programtype.programTypeName as planType,Subscriber_user.first_name as createdBy_id__first_name,Subscriber_user.last_name as createdBy_id__last_name,Program_plan.goals as planGoal,Program_plan.price as planPrice,Program_plan.originalPlanner_id as originalPlanner,Program_plan.createdBy_id as createdBy,utility_programtype.programTypeName as programType__programTypeName,Subscriber_user.avatar as createdBy_id__avatar,Subscriber_user.id as coachId FROM Program_plan left join utility_programtype on Program_plan.programType_id = utility_programtype.id left join Subscriber_user on Program_plan.createdBy_id = Subscriber_user.id left join Plan_selectedabilities on Program_plan.id = Plan_selectedabilities.plan_id left join Program_plangoals on Program_plan.id = Program_plangoals.plan_id left join Program_plancountry on Program_plan.id = Program_plancountry.plan_id"
            if ('coachVal' in coachInfo and coachInfo['coachVal'] != '' and coachInfo['coachVal'] != '0') or (
                    'planVal' in coachInfo and coachInfo['planVal'] != '' and coachInfo['planVal'] != '0'):
                if coachInfo['coachVal'] == "1" and coachInfo['planVal'] == "1":
                    coaches = True
                    print("in Here")
                    filterQuery += " where (Subscriber_user.first_name like '%" + coachInfo[
                        'searchString'] + "%' or Program_plan.planName like '%" + coachInfo[
                                       'searchString'] + "%' or Subscriber_user.last_name like '%" + coachInfo[
                                       'searchString'] + "%')"
                elif coachInfo['coachVal'] == "1" and coachInfo['planVal'] == "0":
                    coaches = True
                    print("inHere1")
                    filterQuery += " where (Subscriber_user.first_name like '%" + coachInfo[
                        'searchString'] + "%' or Subscriber_user.last_name like '%" + coachInfo['searchString'] + "%')"
                elif coachInfo['coachVal'] == "0" and coachInfo['planVal'] == "1":
                    coaches = True
                    print("inHere2")
                    filterQuery += " where (Program_plan.planName like '%" + coachInfo['searchString'] + "%') "
            else:
                if ('searchString' in coachInfo and coachInfo['searchString'] != ''):
                    coaches = True
                    print("in Here")
                    filterQuery += " where (Subscriber_user.first_name like '%" + coachInfo[
                        'searchString'] + "%' or Program_plan.planName like '%" + coachInfo[
                                       'searchString'] + "%' or Subscriber_user.last_name like '%" + coachInfo[
                                       'searchString'] + "%')"
            if 'programType' in coachInfo and coachInfo['programType'] != '':
                programtypeval = True
                programTypes = coachInfo['programType'].split(",")
                if coaches == True:
                    filterQuery += " and ("
                else:
                    filterQuery += " where ("
                tempText = ''
                for val in programTypes:
                    tempText += " Program_plan.programType_id = " + val + " or "
                if tempText != '':
                    filterQuery += tempText[:-3] + ")"
            if 'abilities' in coachInfo and coachInfo['abilities'] != '':
                print("inHEre3")
                abilityVal = True
                if programtypeval == True or coaches == True:
                    filterQuery += " and ("
                else:
                    filterQuery += " where ("
                selectedabilities = coachInfo['abilities'].split(",")
                tempText1 = ''
                for val1 in selectedabilities:
                    tempText1 += " Plan_selectedabilities.ability_id = " + val1 + " or "
                if tempText1 != '':
                    filterQuery += tempText1[:-3] + ")"

                '''filterQuery += " Program_plan.ability =" +coachInfo['abilities']+ ")"'''
            print(filterQuery, "--------------------------")
            if 'goals' in coachInfo and coachInfo['goals'] != '':
                print("inHEre5")
                goalVal = True
                if abilityVal == True or programtypeval == True or coaches == True:
                    filterQuery += " and ("
                else:
                    filterQuery += " where ("
                selectedgoals = coachInfo['goals'].split(",")
                tempText2 = ''
                for val1 in selectedgoals:
                    tempText2 += " Program_plangoals.planGoal_id = " + val1 + " or "
                if tempText2 != '':
                    filterQuery += tempText2[:-3] + ")"
            if 'price' in coachInfo and coachInfo['price'] != '':
                coachPrice = coachInfo['price'].split(",")
                coachPriceVal = True
                if abilityVal == True or goalVal == True or programtypeval == True or coaches == True:
                    filterQuery += " and"
                else:
                    filterQuery += " where"
                if 'deviceType' in coachInfo and coachInfo['deviceType'] == 'ios':
                    if userCurrency.currencyType == "INR":
                        if username['userCountry'] == 88:
                            filterQuery += " (Program_plan.indianIosPrice BETWEEN " + coachPrice[0] + " AND " + coachPrice[
                                1] + ")"
                        else:
                            filterQuery += " (Program_plan.iosPrice BETWEEN " + coachPrice[0] + " AND " + coachPrice[
                                1] + ")"
                    else:
                        maxINRPriceMapValue = \
                        PriceMapping.objects.filter(usd__range=[coachPrice[0], coachPrice[1]]).all().aggregate(
                            Max('inr'))['inr__max']
                        minINRPriceMapValue = \
                        PriceMapping.objects.filter(usd__range=[coachPrice[0], coachPrice[1]]).all().aggregate(
                            Min('inr'))['inr__min']
                        print(maxINRPriceMapValue)
                        print(minINRPriceMapValue)
                        '''for price in priceMapValues:
                            priceObj = dict(price)'''
                        if username['userCountry'] == 88:
                            filterQuery += " (Program_plan.indianIosPrice BETWEEN " + str(
                                minINRPriceMapValue) + " AND " + str(maxINRPriceMapValue) + ")"
                        else:
                            filterQuery += " (Program_plan.iosPrice BETWEEN " + str(minINRPriceMapValue) + " AND " + str(
                                maxINRPriceMapValue) + ")"


                else:
                    if username['userCountry'] == 88:
                        filterQuery += " (Program_plan.indianPrice BETWEEN " + coachPrice[0] + " AND " + coachPrice[
                            1] + ")"
                    else:
                        filterQuery += " (Program_plan.price BETWEEN " + coachPrice[0] + " AND " + coachPrice[1] + ")"
            if abilityVal == True or goalVal == True or programtypeval == True or coaches == True or coachPriceVal == True:
                filterQuery += " and"
            else:
                filterQuery += " where"

            india = False
            countryID = UserAddress.objects.select_related('User__id').filter(country=88, user_id=userid).values()
            if countryID.exists():
                india = True
            if india == True:
                filterQuery += " Program_plancountry.country_id = 88 and "
            else:
                filterQuery += " Program_plancountry.country_id != 88 and "

            if 'deviceType' in coachInfo and coachInfo['deviceType'] == 'ios':
                if 'packageName' in coachInfo and coachInfo['packageName'] == 'apolloLife':
                    filterQuery += " Program_plan.createdBy_id != 165 AND Program_plan.createdBy_id != 47 AND "
                filterQuery += " Program_plan.id is not null and activationStatus=1 and planStatus=1  GROUP BY Plan_selectedabilities.plan_id,Program_plangoals.plan_id ORDER BY Program_plan.programType_id,Program_plan.planName ASC"
            else:
                if 'packageName' in coachInfo and coachInfo['packageName'] == 'apolloLife':
                    filterQuery += " Program_plan.createdBy_id != 165 AND Program_plan.createdBy_id != 47 AND "
                filterQuery += " Program_plan.id is not null and activationStatus=1 and planStatus=1 GROUP BY Program_plan.id, Plan_selectedabilities.plan_id,Program_plangoals.plan_id ORDER BY Program_plan.programType_id,Program_plan.planName ASC"
            print(filterQuery, "--------------------------")
            x.execute(filterQuery)
            resultQuery = dictfetchall(x)
            # highestPrice= Plan.objects.filter(activationStatus=1, planStatus=1).all().aggregate(Max('price'))['price__max']
            highestPrice_dollar = Plan.objects.filter(activationStatus=1, planStatus=1).all().aggregate(Max('price'))[
                'price__max']
            '''if userCurrency.currencyType == "INR":
                if username['userCountry'] == 88:
                    highestPriceVal = PlanCountry.objects.select_related('Plan').filter(plan_id__activationStatus=1,
                                                                                        plan_id__planStatus=1,
                                                                                        country_id=88).all().aggregate(
                        Max('plan_id__indianPrice'))['plan_id__indianPrice__max']
                    highestPrice = round(highestPriceVal * float(inrValue))
                else:
                    highestPriceVal = PlanCountry.objects.select_related('Plan').filter(plan_id__activationStatus=1,
                                                                                        plan_id__planStatus=1,
                                                                                        country_id=88).all().aggregate(
                        Max('plan_id__price'))['plan_id__price__max']
                    highestPrice = round(highestPriceVal * float(inrValue))
            else:
                if username['userCountry'] == 88:
                    highestPriceVal = PlanCountry.objects.select_related('Plan').filter(plan_id__activationStatus=1,
                                                                                        plan_id__planStatus=1,
                                                                                        country_id=88).all().aggregate(
                        Max('plan_id__indianPrice'))['plan_id__indianPrice__max']
                    highestPrice = round(highestPriceVal)
                else:
                    highestPriceVal = PlanCountry.objects.select_related('Plan').filter(plan_id__activationStatus=1,
                                                                                        plan_id__planStatus=1,
                                                                                        country_id=88).all().aggregate(
                        Max('plan_id__price'))['plan_id__price__max']
                    highestPrice = round(highestPriceVal)'''
            clelebLikeArr = []
            celebreviewArr = []
            parentGoals1 = ''
            for dt in resultQuery:
                dataObj = dict(dt)

                planurls = PlanShortUrls.objects.filter(plan_id=dataObj['id']).values()
                if planurls.exists():
                    for val in planurls:
                        valObj = dict(val)
                        urlVal = valObj['longUrl'].split('/')
                        urlVal1 = urlVal[6].split('=')
                        urlVal2 = urlVal1[1].split('&')
                        dataObj[urlVal2[0]] = valObj['shortUrl']

                plalikescount = CelebrityPlansLikes.objects.filter(plan_id=dataObj['id'], status=1).count()
                reviewscount = CelebrityPlansLikes.objects.filter(plan_id=dataObj['id']).exclude(
                    reviews__isnull=True).exclude(reviews__exact='').count()
                dataObj['planlikesCount'] = plalikescount
                dataObj['reviewsCount'] = reviewscount

                clelebLikes = celeblikes(dataObj['id'])
                celebReviews = celebreviewList(dataObj['id'])
                dataObj['planlikes'] = clelebLikes
                dataObj['planreviews'] = celebReviews
                # print(dataObj['planreviews'],"here")

                dataObj['celeblikedPlan'] = 0
                dataObj['celebreviewPlan'] = 0
                dataObj['reviews'] = ''
                # if username['userType'] == 8:
                celebplanlikes = CelebrityPlansLikes.objects.filter(plan_id=dataObj['id'], user_id=username['id'],
                                                                    status=1).values()
                if celebplanlikes.exists():
                    dataObj['celeblikedPlan'] = 1
                celebplanreviews = CelebrityPlansLikes.objects.filter(plan_id=dataObj['id'],
                                                                      user_id=username['id']).values()
                if celebplanreviews.exists():
                    for celbdt in celebplanreviews:
                        celbObj = dict(celbdt)
                        if celbObj['reviews'] != '' and celbObj['reviews'] != None:
                            dataObj['reviews'] = celbObj['reviews']
                            dataObj['celebreviewPlan'] = 1

                secret_code_plain = dataObj['planName'] + '#' + str(dataObj['id'])
                secret_code_encode = base64.b64encode(secret_code_plain.encode('ascii'))
                encodedVal = str(secret_code_encode).split("'")
                dataObj['encodedurl'] = encodedVal[1]

                dataObj['coachName'] = dataObj['createdBy_id__first_name'] + " " + dataObj['createdBy_id__last_name']
                dataObj['createdBy_id__first_name'] = dataObj['createdBy_id__first_name'] + " " + dataObj[
                    'createdBy_id__last_name']
                # print(dataObj)
                # print(postDetail12['rates']['INR'])
                if 'deviceType' in coachInfo and coachInfo['deviceType'] == 'ios':
                    if userCurrency.currencyType == "INR":
                        if username['userCountry'] == 88:
                            highestPrice = \
                            PlanCountry.objects.select_related('Plan').filter(plan_id__activationStatus=1,
                                                                              plan_id__planStatus=1,
                                                                              country_id=88).all().aggregate(
                                Max('plan_id__indianIosPrice'))['plan_id__indianIosPrice__max']
                            dataObj['price'] = dataObj['indianIosPrice']
                            dataObj['planPrice'] = dataObj['price']
                        else:
                            highestPrice = \
                            PlanCountry.objects.select_related('Plan').filter(plan_id__activationStatus=1,
                                                                              plan_id__planStatus=1).filter(
                                ~Q(country_id=88)).all().aggregate(Max('plan_id__iosPrice'))['plan_id__iosPrice__max']
                            dataObj['price'] = dataObj['iosPrice']
                            dataObj['planPrice'] = dataObj['price']
                        if int(dataObj['price']) == 0:
                            dataObj['price'] = "Free"
                    else:
                        if username['userCountry'] == 88:
                            highestPriceVal = \
                            PlanCountry.objects.select_related('Plan').filter(plan_id__activationStatus=1,
                                                                              plan_id__planStatus=1,
                                                                              country_id=88).all().aggregate(
                                Max('plan_id__indianIosPrice'))['plan_id__indianIosPrice__max']
                            print(highestPriceVal)
                            highestVal = PriceMapping.objects.get(inr=highestPriceVal)
                            highestPrice = highestVal.usd
                            usdValue = PriceMapping.objects.values().filter(inr=dataObj['indianIosPrice'])
                        else:
                            highestPriceVal = \
                            PlanCountry.objects.select_related('Plan').filter(plan_id__activationStatus=1,
                                                                              plan_id__planStatus=1).filter(
                                ~Q(country_id=88)).all().aggregate(Max('plan_id__iosPrice'))['plan_id__iosPrice__max']
                            highestVal = PriceMapping.objects.get(inr=highestPriceVal)
                            highestPrice = highestVal.usd
                            usdValue = PriceMapping.objects.values().filter(inr=dataObj['iosPrice'])
                        for usd in usdValue:
                            usdObj = dict(usd)
                            dollarVal = usdObj['usd']
                        dataObj['price'] = dollarVal
                        if float(dataObj['price']) == 0:
                            dataObj['price'] = "Free"
                else:
                    if int(dataObj['price']) == 0:
                        dataObj['price'] = "Free"
                    else:
                        if userCurrency.currencyType == "INR":
                            if username['userCountry'] == 88:
                                highestPriceVal = \
                                PlanCountry.objects.select_related('Plan').filter(plan_id__activationStatus=1,
                                                                                  plan_id__planStatus=1,
                                                                                  country_id=88).all().aggregate(
                                    Max('plan_id__indianPrice'))['plan_id__indianPrice__max']
                                highestPrice = round(highestPriceVal * inrValue)
                                dataObj['price'] = round((dataObj['indianPrice']) * float(inrValue))
                                dataObj['planPrice'] = dataObj['price']
                            else:
                                highestPriceVal = \
                                PlanCountry.objects.select_related('Plan').filter(plan_id__activationStatus=1,
                                                                                  plan_id__planStatus=1).filter(
                                    ~Q(country_id=88)).all().aggregate(Max('plan_id__price'))['plan_id__price__max']
                                highestPrice = round(highestPriceVal * inrValue)
                                dataObj['price'] = round((dataObj['price']) * float(inrValue))
                                dataObj['planPrice'] = dataObj['price']
                        else:
                            if username['userCountry'] == 88:
                                highestPrice = \
                                PlanCountry.objects.select_related('Plan').filter(plan_id__activationStatus=1,
                                                                                  plan_id__planStatus=1,
                                                                                  country_id=88).all().aggregate(
                                    Max('plan_id__indianPrice'))['plan_id__indianPrice__max']
                                dataObj['price'] = dataObj['indianPrice']
                                dataObj['planPrice'] = dataObj['price']
                            else:
                                highestPrice = \
                                PlanCountry.objects.select_related('Plan').filter(plan_id__activationStatus=1,
                                                                                  plan_id__planStatus=1).filter(
                                    ~Q(country_id=88)).all().aggregate(Max('plan_id__price'))['plan_id__price__max']
                                dataObj['price'] = dataObj['price']
                                dataObj['planPrice'] = dataObj['price']
                        if float(dataObj['price']) == 0:
                            dataObj['price'] = "Free"
                            # dataObj['iosPrice'] = round(float(dataObj['iosPrice'])*float(inrValue))
                # if dataObj['originalPlanner'] == dataObj['createdBy_id']:
                if dataObj['planType'] == "STARTER":
                    dataObj['planType'] = "Beginner"
                    dataObj['ptype'] = 'S'
                elif dataObj['planType'] == "INTERMEDIATE":
                    dataObj['planType'] = "Intermediate"
                    dataObj['ptype'] = 'I'
                elif dataObj['planType'] == "ADVANCED":
                    dataObj['planType'] = "Advanced"
                    dataObj['ptype'] = 'A'
                
                coachName1 = User.objects.get(id=dataObj['originalPlanner'])
                dataObj['oriCoachName'] = str(coachName1.first_name) + " " + str(coachName1.last_name)
                planAbilityVal = SelectedAbilities.objects.select_related('PlanAbilities').filter(
                    plan_id=dataObj['id']).values(
                    'ability_id__ability')
                abilities = ''
                abilities1 = ''
                for val in planAbilityVal:
                    valObj = dict(val)
                    abilities += ", " + valObj['ability_id__ability']
                    abilities1 += ", " + valObj['ability_id__ability']
                if abilities != '':
                    planAbilities = abilities[1:]
                    planAbilities1 = abilities[1:]
                else:
                    planAbilities = ""
                    planAbilities1 = ""

                planPurposesVal = PlanGoals.objects.select_related('PlanPurposes').filter(plan_id=dataObj['id']).values(
                    'planGoal_id__GoalName')
                purposes = ''
                purposes1 = ''
                for val in planPurposesVal:
                    valObj = dict(val)
                    purposes += ", " + valObj['planGoal_id__GoalName']
                    purposes1 += ", " + valObj['planGoal_id__GoalName']
                if purposes != '':
                    planGoals = purposes[1:]
                    planGoals1 = purposes[1:]
                else:
                    planGoals = ""
                    planGoals1 = ""
                goalsArr = dataObj['goals'].split(",")
                planParentGoals = PlanPurposes.objects.filter(id__in=goalsArr).values(
                    'parentGoalName_id').distinct()
                parentGoals = []
                for val in planParentGoals:
                    valObj = dict(val)
                    parentGoals.append(valObj['parentGoalName_id'])
                    parentGoals1 += "," + str(valObj['parentGoalName_id'])
                '''if len(planGoals) > 30:
                    planGoals = planGoals[:30]
                    planGoals += "..."
                if len(planAbilities) > 31:
                    if planAbilities[31] == ",":
                        planAbilities = planAbilities[:30]
                    else:
                        planAbilities = planAbilities[:31]
                        planAbilities = planAbilities.split(",")
                        planAbilities = planAbilities[0] + "..."'''
                dataObj['planDescription'] = dataObj['planDescription'] + "<br><br><font><b>Abilities:</b> " + str(
                    planAbilities1) + "</font>" + "<br><br><font><b>Purposes:</b> " + str(planGoals) + "</font>"
                if dataObj['licencePolicy'] == "3" or dataObj['licencePolicy'] == "White-Label":
                    partnerName = User.objects.get(id=dataObj['createdBy_id'])
                    dataObj['planDescription'] = str(
                        dataObj['planDescription']) + "<br><h6>Copyright &copy; 2017 " + str(
                        str(partnerName.first_name) + " " + str(
                            partnerName.last_name)) + ". All rights reserved.</h6>"
                else:
                    coachName = User.objects.get(id=dataObj['originalPlanner'])
                    dataObj['planDescription'] = str(
                        dataObj['planDescription']) + "<br><h6>Copyright &copy; 2017 " + str(
                        str(coachName.first_name) + " " + str(coachName.last_name)) + ". All rights reserved.</h6>"
                downloadUsers = UserPlan.objects.filter(plan_id=dataObj['id']).values('user_id').distinct().count()
                ratingObj = PlanRating.objects.filter(plan=dataObj['id']).values()
                totalRate = 0
                userCount = 1
                for rt in ratingObj:
                    rateObj = dict(rt)
                    totalRate = totalRate + rateObj['rating']
                    userCount = userCount + 1
                rating = totalRate / userCount
                exercisesObj = Plan_Actions.objects.select_related('Exercise').filter(plan_id=dataObj['id']).values('exercise_id', 'exercise_id__exerciseName', 'exercise_id__exerciseDesc','exercise_id__video','exercise_id__thumb_image','exercise_id__cover_image', 'exercise_id__equipment').distinct()
                planExs = []
                for ex in exercisesObj:
                    exObj = dict(ex)
                    planExs.append(exObj)
                dataObj['PlanRating'] = rating
                dataObj['planPurpose'] = planAbilities
                dataObj['ability'] = planAbilities
                dataObj['ability1'] = planAbilities1
                dataObj['plan_goals'] = planGoals
                dataObj['plan_goals1'] = planGoals1
                dataObj['planCompetency'] = "0"
                dataObj['planUsers'] = downloadUsers
                dataObj['exercises'] = planExs
                dataObj['parentGoal'] = parentGoals
                planArr.append(dataObj)
            parGoals = []
            if parentGoals1 != '':
                parentGoals1 = parentGoals1[1:]
                PrntGlArr = parentGoals1.split(",")
                ParentGoals = PlanPurposes.objects.filter(id__in=PrntGlArr).values('id','GoalName').distinct()
                for val in ParentGoals:
                    valObj = dict(val)
                    parGoals.append({"id":valObj['id'],"name":valObj['GoalName']})
            else:
                planGoals1 = ""
            return JsonResponse({"success": True, "filterValues": planArr, "luctype": userCurrency.currencyType, "dollarHighest": highestPrice_dollar, "parentGoals":parGoals})
        else:
            return JsonResponse({"success": False, "message": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})


@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getplaninfo(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        info = json.loads(request.body.decode('utf-8'))
        user = username['id']
        if username != None:
            if 'advancedPlan' in info and info['advancedPlan'] == 1:
                plandata = Plan.objects.values('id', 'planName', 'planStatus', 'programType_id', 'activationStatus',
                                               'planDescription', 'planPhoto', 'planLogo', 'price', 'indianPrice',
                                               'indianIosPrice', 'iosPrice').filter(planStatus=1, createdBy_id=user)
            else:
                plandata = Plan.objects.values('id', 'planName', 'planStatus', 'programType_id', 'activationStatus',
                                               'planDescription', 'planPhoto', 'planLogo', 'price', 'indianPrice',
                                               'indianIosPrice', 'iosPrice').filter(planStatus=1, createdBy_id=user)
            planArr = []
            for data in plandata:
                planObj = dict(data)
                planurls = PlanShortUrls.objects.filter(plan_id=planObj['id']).values()
                if planurls.exists():
                    for val in planurls:
                        valObj = dict(val)
                        urlVal = valObj['longUrl'].split('/')
                        urlVal1 = urlVal[6].split('=')
                        urlVal2 = urlVal1[1].split('&')
                        planObj[urlVal2[0]] = valObj['shortUrl']
                draftedPlandetails = DraftedPlan.objects.filter(planId=planObj['id'], createdBy_id=user).filter(
                    status=1).values('id')
                if draftedPlandetails.exists():
                    planArr.append(planObj)
            if 'advancedPlan' in info and info['advancedPlan'] == 1:
                plandetail = Plan.objects.values('id', 'planName', 'planStatus', 'programType_id','planPhoto','planLogo').filter(planStatus=0,
                                                                                                          createdBy_id=user)
            else:
                plandetail = Plan.objects.values('id', 'planName', 'planStatus', 'programType_id','planPhoto','planLogo').filter(planStatus=0,
                                                                                                          createdBy_id=user)
            print(plandetail.query)
            inactiveplanArr = []
            for data in plandetail:
                planObj = dict(data)
                draftedPlandetails1 = DraftedPlan.objects.filter(planId_id=planObj['id'], createdBy_id=user).values('id')
                print(draftedPlandetails1.query)
                if draftedPlandetails1.exists():
                    drafted1 = DraftedPlan.objects.filter(planId=planObj['id'], createdBy_id=user).filter(
                        status=0).values('id')
                    print(drafted1.query)
                    if drafted1.exists():
                        inactiveplanArr.append(planObj)
                else:
                    inactiveplanArr.append(planObj)
            if 'advancedPlan' in info and info['advancedPlan'] == 1:
                plandetail1 = Plan.objects.values('id', 'planName', 'planStatus', 'programType_id').filter(planStatus=0,
                                                                                                           createdBy_id=user,
                                                                                                           advPlan=1)
            else:
                plandetail1 = Plan.objects.values('id', 'planName', 'planStatus', 'programType_id').filter(planStatus=0,
                                                                                                           createdBy_id=user,
                                                                                                           advPlan=0)
            reviewPrograms = []
            for data in plandetail1:
                planObj = dict(data)
                planObj['reviews'] = ''
                planObj['reviewStatus'] = 0
                draftedPlandetails2 = DraftedPlan.objects.filter(planId=planObj['id'], createdBy_id=user).filter(
                    status=1).values('id')
                if draftedPlandetails2.exists():
                    reviews = PlanComments.objects.filter(plan_id=planObj['id']).values().last()
                    if reviews:
                        if reviews['status'] == 1:
                            planObj['reviewStatus'] = 1
                        planObj['reviews'] = reviews['reiviewComments']
                    else:
                        planObj['reviews'] = ''
                    reviewPrograms.append(planObj)
            return JsonResponse(
                {"activeplan": planArr, "inactiveplan": inactiveplanArr, "reviewPrograms": reviewPrograms})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def createPlan(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        user = username['id']
        if username != None:
            planInfo = json.loads(request.body.decode('utf-8'))
            if 'id' in planInfo['plan'] and planInfo['plan']['id'] != '':
                print('------------Update Plan---------')
                planId = planInfo['plan']['id']
                updatePlan = Plan.objects.get(pk=planId)
                updatePlan.programType_id = planInfo['plan']['program']
                updatePlan.planName = planInfo['plan']['planName']
                planDes = planInfo['plan']['description']
                if '<br><h6>Copyright' in planDes:
                    head, sep, tail = planDes.partition('<br><h6>Copyright')
                else:
                    head = planDes
                print(head, "planDescriptions")
                updatePlan.planDescription = head
                updatePlan.planGoal_id = 1
                updatePlan.price = planInfo['plan']['price']
                updatePlan.ability = planInfo['plan']['ability']
                if 'others' in planInfo['plan'] and planInfo['plan']['others'] !='':
                    updatePlan.others = planInfo['plan']['others']
                if 'videos' in planInfo['plan'] and planInfo['plan']['videos']!='':
                    planvideo=PlanVideos.objects.filter(plan_id=planId).values()
                    if planvideo.exists():
                        videos=PlanVideos.objects.filter(plan_id=planInfo['plan']['id']).latest('id')
                    
                        if videos:
                            Video=PlanVideos.objects.filter(id=videos.id).update(video=planInfo['plan']['videos'])
                        
                       
                    else:
                        Video=PlanVideos.objects.create(plan_id=planId,createdBy_id=user,modifiedBy_id=user,video=planInfo['plan']['videos'])
                        Video.save()

                if planInfo['plan']['ability'] != "":
                    planabilities = planInfo['plan']['ability'].split(",")
                    updateAbilities = SelectedAbilities.objects.filter(plan_id=planId).values()
                    if updateAbilities.exists():
                        deleteAbilities = SelectedAbilities.objects.filter(plan_id=planId).delete()
                    for val in planabilities:
                        createabilitites = SelectedAbilities.objects.create(
                            ability_id=val,
                            plan_id=planId,
                            createdBy_id=user,
                            modifiedBy_id=user
                        )
                        createabilitites.save()
                updatePlan.goals = planInfo['plan']['goals']
                
                if planInfo['plan']['goals'] != "":
                    plangoals = planInfo['plan']['goals'].split(",")
                    updateGoals = PlanGoals.objects.filter(plan_id=planId).values()
                    if updateGoals.exists():
                        deleteGoals = PlanGoals.objects.filter(plan_id=planId).delete()
                    for val1 in plangoals:
                        saveGoals = PlanGoals.objects.create(
                            planGoal_id=val1,
                            plan_id=planId,
                            createdBy_id=user,
                            modifiedBy_id=user
                        )
                        saveGoals.save()

                if 'licencePolicy' in planInfo['plan'] and planInfo['plan']['licencePolicy'] == 'White-Label':
                    updatePlan.licencePolicy = 'White-Label'
                updatePlan.num_of_sessions = planInfo['plan']['session']
                updatePlan.goals = planInfo['plan']['goals']
                updatePlan.createdBy_id = user
                updatePlan.modifiedBy_id = user
                if 'advancePlan' in planInfo['plan'] and planInfo['plan']['advancePlan'] != '':
                    updatePlan.advPlan = planInfo['plan']['advancePlan']
                if 'planPhoto' in planInfo['plan'] and planInfo['plan']['planPhoto'] != '':
                    updatePlan.planPhoto = planInfo['plan']['planPhoto']
                if 'planLogo' in planInfo['plan'] and planInfo['plan']['planLogo'] != '':
                    updatePlan.planLogo = planInfo['plan']['planLogo']
                updatePlan.save()
                if 'directsell' in planInfo['plan'] and planInfo['plan']['directsell'] == True:
                    direcsellExists = PlanMonetization.objects.filter(plan_id_id=planId, license_id=1).values('id')
                    if direcsellExists.exists():
                        print("Direct Selling already Exists")
                    else:
                        license = 1
                        planinfo = PlanMonetization.objects.create(
                            plan_id_id=planId,
                            planType='Direct Selling',
                            license_id=license,
                            royalty='',
                            coach_id_id=user,
                            templateContent='N/A',
                        )
                        planinfo.save()

                if 'cobrand' in planInfo['plan'] and planInfo['plan']['cobrand'] == True and 'cbroyalty1' in planInfo[
                    'plan'] and planInfo['plan']['cbroyalty1'] != '':
                    coBrandExists = PlanMonetization.objects.filter(plan_id_id=planId, license_id=2).values('id')
                    if coBrandExists.exists():
                        license = 2
                        royalty = planInfo['plan']['cbroyalty1']
                        for coB in coBrandExists:
                            coBObj = dict(coB)
                            coBId = coBObj['id']
                        planinfo = PlanMonetization.objects.get(id=coBId)
                        planinfo.plan_id_id = planId
                        planinfo.planType = 'Co-Brand'
                        planinfo.license_id = license
                        planinfo.royalty = royalty
                        planinfo.coach_id_id = user
                        planinfo.save()
                        print("Co-Brand Selling already Exists")
                    else:
                        license = 2
                        royalty = planInfo['plan']['cbroyalty1']
                        if 'template' in planInfo['plan'] and planInfo['plan']['template'] == 'Template 1':
                            tempcontent = "My brand at top, Partner brand at bottom"
                        elif 'template' in planInfo['plan'] and planInfo['plan']['template'] == 'Template 2':
                            tempcontent = "My brand and Partner equal (to left, to right)"
                        elif 'template' in planInfo['plan'] and planInfo['plan']['template'] == 'Template 3':
                            tempcontent = "Partner brand at top, My brand at bottom"

                        planinfo = PlanMonetization.objects.create(
                            plan_id_id=planId,
                            planType='Co-Brand',
                            license_id=license,
                            royalty=royalty,
                            coach_id_id=user,
                        )
                        if 'template' in planInfo['plan'] and planInfo['plan']['template'] != '':
                            planinfo.template = planInfo['plan']['template']
                            planinfo.templateContent = tempcontent
                        else:
                            planinfo.template = None
                            planinfo.templateContent = None
                        planinfo.save()
                else:
                    coBrandValues = PlanMonetization.objects.filter(plan_id_id=planId, license_id=2).values('id')
                    for coB in coBrandValues:
                        coBObj = dict(coB)
                        deleteCobId = coBObj['id']
                        deleteCobrand = PlanMonetization.objects.get(id=deleteCobId)
                        deleteCobrand.delete()

                if 'whitelab' in planInfo['plan'] and planInfo['plan']['whitelab'] == True and 'whlabroyalty1' in \
                        planInfo['plan'] and planInfo['plan']['whlabroyalty1'] != '':
                    whitelabelExists = PlanMonetization.objects.filter(plan_id_id=planId, license_id=3).values('id')
                    if whitelabelExists.exists():
                        license = 3
                        royalty = planInfo['plan']['whlabroyalty1']
                        for coB in whitelabelExists:
                            coBObj = dict(coB)
                            coBId = coBObj['id']
                        planinfo = PlanMonetization.objects.get(id=coBId)
                        planinfo.plan_id_id = planId
                        planinfo.planType = 'White-Label'
                        planinfo.license_id = license
                        planinfo.royalty = royalty
                        planinfo.coach_id_id = user
                        planinfo.save()
                        print("White-Label Selling already Exists")
                    else:
                        license = 3
                        royalty = planInfo['plan']['whlabroyalty1']
                        planinfo = PlanMonetization.objects.create(
                            plan_id_id=planId,
                            planType='White-Label',
                            license_id=license,
                            royalty=royalty,
                            coach_id_id=user,
                            templateContent='N/A',
                        )
                        planinfo.save()
                else:
                    whitelabValues = PlanMonetization.objects.filter(plan_id_id=planId, license_id=3).values('id')
                    for wB in whitelabValues:
                        wBObj = dict(wB)
                        deletewbId = wBObj['id']
                        deletewbrand = PlanMonetization.objects.get(id=deletewbId)
                        deletewbrand.delete()
                return JsonResponse(
                    {"success": True, "message": "Program Details Updated Successfully", "planId": updatePlan.id,
                     "planTypeId": updatePlan.programType_id})
            else:
                planDetails = Plan.objects.filter(planName=planInfo['plan']['planName'])
                if planDetails.exists():
                    return JsonResponse({"success": False, "message": "Program Name Already exists"})
                plan = Plan.objects.create(
                    programType_id=planInfo['plan']['program'],
                    planName=planInfo['plan']['planName'],
                    planDescription=planInfo['plan']['description'],
                    planGoal_id=1,
                    price=planInfo['plan']['price'],
                    # planStatus = planInfo['plan']['status'],
                    ability=planInfo['plan']['ability'],
                    num_of_sessions=planInfo['plan']['session'],
                    goals=planInfo['plan']['goals'],
                    originalPlanner_id=user,
                    createdBy_id=user,
                    modifiedBy_id=user,
                    # planStatus = planInfo['plan']['status'],
                    # licencePolicy = planInfo['plan']['licencePolicy'],
                )
                if 'others' in planInfo['plan'] and planInfo['plan']['others'] !='':
                    plan.others = planInfo['plan']['others']
                if 'advancePlan' in planInfo['plan'] and planInfo['plan']['advancePlan'] != '':
                    plan.advPlan = planInfo['plan']['advancePlan']
                if 'planPhoto' in planInfo['plan'] and planInfo['plan']['planPhoto'] != '':
                    plan.planPhoto = planInfo['plan']['planPhoto']
                if 'planLogo' in planInfo['plan'] and planInfo['plan']['planLogo'] != '':
                    plan.planLogo = planInfo['plan']['planLogo']
                    print('++++ img path save +++++')
                plan.save()
                createJson = DraftedPlan.objects.create(
                    planJson='',
                    planId_id=plan.id,
                    createdBy_id=user,
                    modifiedBy_id=user
                )
                createJson.save()
                if 'videos' in planInfo['plan'] and planInfo['plan']['videos']!='':
                    videos=PlanVideos.objects.create(plan_id=plan.id,video=planInfo['plan']['videos'],
                        createdBy_id=user,
                        modifiedBy_id=user
                    )
                    videos.save()
                if 'goals' in planInfo['plan'] and planInfo['plan']['goals'] != '':
                    purposes = planInfo['plan']['goals'].split(",")
                    for val1 in purposes:
                        saveGoals = PlanGoals.objects.create(
                            planGoal_id=val1,
                            plan_id=plan.id,
                            createdBy_id=user,
                            modifiedBy_id=user
                        )
                        saveGoals.save()
                if 'ability' in planInfo['plan'] and planInfo['plan']['ability'] != '':
                    abilities = planInfo['plan']['ability'].split(",")
                    for val in abilities:
                        saveAbility = SelectedAbilities.objects.create(
                            ability_id=val,
                            plan_id=plan.id,
                            createdBy_id=user,
                            modifiedBy_id=user
                        )
                        saveAbility.save()
                planId = plan.id
                print(planId, '===planId=====')
                playTypeId = plan.programType_id
                oriplan = Plan.objects.get(pk=planId)
                oriplan.originalPlanId_id = planId
                oriplan.save()

                if 'directsell' in planInfo['plan'] and planInfo['plan']['directsell'] == True:
                    license = 1
                    planinfo = PlanMonetization.objects.create(
                        plan_id_id=planId,
                        planType='Direct Selling',
                        license_id=license,
                        royalty='',
                        coach_id_id=user,
                        templateContent='N/A',
                    )
                    planinfo.save()

                if 'cobrand' in planInfo['plan'] and planInfo['plan']['cobrand'] == True and 'cbroyalty1' in planInfo[
                    'plan'] and planInfo['plan']['cbroyalty1'] != '':
                    license = 2
                    royalty = planInfo['plan']['cbroyalty1']
                    if 'template' in planInfo['plan'] and planInfo['plan']['template'] == 'Template 1':
                        tempcontent = "My brand at top, Partner brand at bottom"
                    elif 'template' in planInfo['plan'] and planInfo['plan']['template'] == 'Template 2':
                        tempcontent = "My brand and Partner equal (to left, to right)"
                    elif 'template' in planInfo['plan'] and planInfo['plan']['template'] == 'Template 3':
                        tempcontent = "Partner brand at top, My brand at bottom"

                    planinfo = PlanMonetization.objects.create(
                        plan_id_id=planId,
                        planType='Co-Brand',
                        license_id=license,
                        royalty=royalty,
                        coach_id_id=user,
                    )
                    if 'template' in planInfo['plan'] and planInfo['plan']['template'] != '':
                        planinfo.template = planInfo['plan']['template']
                        planinfo.templateContent = tempcontent
                    else:
                        planinfo.template = None
                        planinfo.templateContent = None
                    planinfo.save()

                if 'whitelab' in planInfo['plan'] and planInfo['plan']['whitelab'] == True and 'whlabroyalty1' in \
                        planInfo['plan'] and planInfo['plan']['whlabroyalty1'] != '':
                    license = 3
                    royalty = planInfo['plan']['whlabroyalty1']
                    planinfo = PlanMonetization.objects.create(
                        plan_id_id=planId,
                        planType='White-Label',
                        license_id=license,
                        royalty=royalty,
                        coach_id_id=user,
                        templateContent='N/A',
                    )
                    planinfo.save()
            return JsonResponse({"success": True, "message": "Program Details Saved Successfully", "planId": planId,
                                 "planTypeId": playTypeId})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})




@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def viewPlan_by_id(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    if username != None:
        india = False
        countryID = UserAddress.objects.select_related('User__id').filter(country=88, user_id=username['id']).values()
        if countryID.exists():
            for con in countryID:
                conObj = dict(con)
                username['userCountry'] = conObj['country']
            india = True
    else:
        india = False
        g = GeoIP()
        ip = request.META.get('REMOTE_ADDR', None)
        if ip:
            country = g.country(ip)['country_name']
        else:
            country = 'India'  # default city
        countryName = Country.objects.get(name=country)
        countryId = countryName.id
        if countryId == 88:
            india = True
    planInfo = json.loads(request.body.decode('utf-8'))
    codeDecode = base64.b64decode(planInfo['plan_id']).decode("ascii")
    codeDecodeSplit = codeDecode.split('#', 1)
    planDetails = Plan.objects.values().filter(id=codeDecodeSplit[1])
    totalusercount = 0
    total=0  
    arr={} 
    if planDetails.exists():
            
        for dt in planDetails:
            sum=0
            weeks={}
            dataPlanObj = dict(dt)
            meso=Plan_Mesocycle.objects.values().filter(plan_id_id=dataPlanObj['id'])
            if meso.exists():
                for hg in meso:
                    micros=dict(hg)
                    sum=sum+micros['num_of_microcycles']
                    weeks['microcycles']=sum 
                dataPlanObj['duration_weeks']=weeks['microcycles']
            videos=PlanVideos.objects.filter(plan_id=dataPlanObj['id']).values()
            if videos.exists():
                for dt in videos:
                    val=dict(dt)
                dataPlanObj['videos'] =val['video']   
            planurls = PlanShortUrls.objects.filter(plan_id=dataPlanObj['id']).values()
            if planurls.exists():
                for val in planurls:
                    valObj = dict(val)
                    urlVal = valObj['longUrl'].split('/')
                    urlVal1 = urlVal[6].split('=')
                    urlVal2 = urlVal1[1].split('&')
                    dataPlanObj[urlVal2[0]] = valObj['shortUrl']
            if india == True:
                dataPlanObj['price'] = dataPlanObj['indianPrice']
            if dataPlanObj['price'] == 0:
                dataPlanObj['price'] = "Free"
            planAbilityVal = SelectedAbilities.objects.select_related('PlanAbilities').filter(
                plan_id=dataPlanObj['id']).values('ability_id__ability')
            abilitieslists = ''
            for val in planAbilityVal:
                valObj = dict(val)
                abilitieslists += ", " + valObj['ability_id__ability']
            if abilitieslists != '':
                planAbilities = abilitieslists[1:]
            else:
                planAbilities = ""
            planPurposesVal = PlanGoals.objects.select_related('PlanPurposes').filter(plan_id=dataPlanObj['id']).values(
                'planGoal_id__GoalName')
            purposes = ''
            for val in planPurposesVal:
                valObj = dict(val)
                purposes += ", " + valObj['planGoal_id__GoalName']
            if dataPlanObj['others']!=None:
                purposes += "," +dataPlanObj['others']        
            if purposes != '':
                planGoals = purposes[1:]
            else:
                planGoals = ""
            coachValues = User.objects.get(id=dataPlanObj['createdBy_id'])
            coachName = coachValues.first_name + " " + coachValues.last_name
            dataPlanObj['coachName'] = coachName
            dataPlanObj['coachAvatar'] = coachValues.avatar
            dataPlanObj['coachCover'] = coachValues.userCover
            if dataPlanObj['originalPlanner_id'] != dataPlanObj['createdBy_id']:
                coachVal = User.objects.get(id=dataPlanObj['originalPlanner_id'])
                coachName = coachVal.first_name + " " + coachVal.last_name
                dataPlanObj['oriCoachName'] = coachName
            dataPlanObj['planDescription'] = dataPlanObj['planDescription'] + "<br><br><font><b>Abilities:</b> " + str(
                planAbilities) + "</font>" + "<br><br><font><b>Purposes:</b> " + str(planGoals) + "</font>"
            if dataPlanObj['licencePolicy'] == "3" or dataPlanObj['licencePolicy'] == "White-Label":
                partnerName = User.objects.get(id=dataPlanObj['createdBy_id'])
                dataPlanObj['planDescription'] = str(
                    dataPlanObj['planDescription']) + "<br><h6>Copyright &copy; 2017 " + str(
                    str(partnerName.first_name) + " " + str(partnerName.last_name)) + ". All rights reserved.</h6>"
            else:
                if dataPlanObj['originalPlanner_id'] != dataPlanObj['createdBy_id']:
                    coachVal = User.objects.get(id=dataPlanObj['originalPlanner_id'])
                    coachName = coachVal.first_name + " " + coachVal.last_name
                    dataPlanObj['oriCoachName'] = coachName
                coachName = User.objects.get(id=dataPlanObj['originalPlanner_id'])
                dataPlanObj['planDescription'] = str(
                    dataPlanObj['planDescription']) + "<br><h6>Copyright &copy; 2017 " + str(
                    str(coachName.first_name) + " " + str(coachName.last_name)) + ". All rights reserved.</h6>"
            downloadUsers = UserPlan.objects.filter(plan_id=dataPlanObj['id']).values('user_id').distinct().count()
            ratingObj = PlanRating.objects.filter(plan=dataPlanObj['id']).values()
            totalRate = 0
            userCount = 1
            for rt in ratingObj:
                rateObj = dict(rt)
                totalRate = totalRate + rateObj['rating']
                userCount = userCount + 1
            rating = totalRate / userCount
            # planCoaches.append(dataObj['createdBy_id'])
            dataPlanObj['planPurpose'] = planAbilities
            dataPlanObj['plan_goals'] = planGoals
            # dataPlanObj['planType'] = dataPlanObj['programType__programTypeName']
            dataPlanObj['planCompetency'] = "0"
            dataPlanObj['planUsers'] = downloadUsers
            totalusercount = totalusercount + int(downloadUsers)
            dataPlanObj['PlanRating'] = rating
            dataPlanObj['coachId'] = dataPlanObj['createdBy_id']
            # dataPlanObj['planGoal'] = dataPlanObj['planGoal__goalName']
            dataPlanObj['planLevel'] = dataPlanObj['programType_id']
            exercisesObj = Plan_Actions.objects.select_related('NewExercise').filter(plan_id=dataPlanObj['id']).values('exercise_id', 'exercise_id__exerciseName', 'exercise_id__exerciseDesc','exercise_id__video','exercise_id__thumb_image','exercise_id__cover_image', 'exercise_id__equipment',).distinct()
            planExs = []
            for ex in exercisesObj:
                exObj = dict(ex)
                planExs.append(exObj)
            if dataPlanObj['planLevel'] == 1:
                dataPlanObj['ptype'] = 'S'
                dataPlanObj['planType'] = "Beginner"
            elif dataPlanObj['planLevel'] == 2:
                dataPlanObj['planType'] = "Intermediate"
                dataPlanObj['ptype'] = 'I'
            elif dataPlanObj['planLevel'] == 3:
                dataPlanObj['planType'] = "Advanced"
                dataPlanObj['ptype'] = 'A'

            dataPlanObj['planDuration'] = dataPlanObj['duration_weeks']
            dataPlanObj['coachId'] = dataPlanObj['createdBy_id']
            dataPlanObj['exercises'] = planExs
            draftedDetails = DraftedPlan.objects.filter(planId_id=dataPlanObj['id']).values()
            if draftedDetails.exists():
                for df in draftedDetails:
                    dfObj = dict(df)
                    dataPlanDict = {"PlanInfo": dataPlanObj, "PlanJson": dfObj['planJson']}
            else:
                dataPlanDict = {"PlanInfo": dataPlanObj, "PlanJson": ""}
        # print(dataPlanDict)
        return JsonResponse({"plan": dataPlanDict, "success": True, "india": india})
    else:
        return JsonResponse({"success": False})


def uploadphoto(request):
    print(request.FILES['myfile'].name, "-------name--------")

    planId = request.session['plan_id']
    print(planId, "--------------jdjs-----------")
    planpic = Plan.objects.get(id=planId)
    # userphoto.avatar = request.FILES['myfile'].name
    planpic.planPhoto = request.FILES['myfile']
    planpic.save()
    return JsonResponse({"success": True})


@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def planDetails(request):
    # user = request.session['user_id']
    # print(user)
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        user = username['id']
        if username != None:
            planDetails = Plan.objects.select_related('Goals__id', 'ProgramType__id', 'User__id').filter(
                planStatus=1).values('id', 'planName', 'planGoal__goalName', 'planDescription',
                                     'programType__programTypeName', 'ability', 'createdBy_id__avatar', 'createdBy_id',
                                     'duration_weeks', 'planLogo', 'licencePolicy', 'originalPlanner_id').order_by(
                'planName', 'planPhoto')
            userplanDetails = UserPlan.objects.filter(user_id=user, status=1).values('plan_id', 'id', 'status')
            if userplanDetails.exists():
                for data in userplanDetails:
                    dt = dict(data)
                    if dt['licencePolicy'] == "3" or dt['licencePolicy'] == "White-Label":
                        partnerName = User.objects.get(id=dt['createdBy_id'])
                        dt['planDescription'] = str(dt['planDescription']) + "<br><h6>Copyright &copy; 2017 " + str(
                            str(partnerName.first_name) + " " + str(
                                partnerName.last_name)) + ". All rights reserved.</h6>"
                    else:
                        coachName = User.objects.get(id=dt['originalPlanner_id'])
                        dt['planDescription'] = str(dt['planDescription']) + "<br><h6>Copyright &copy; 2017 " + str(
                            str(coachName.first_name) + " " + str(coachName.last_name)) + ". All rights reserved.</h6>"
                    if dt['status'] == 2:
                        planids = ''
                    else:
                        planids = dt['plan_id']
            else:
                planids = None
            # videodetails = PlanVideos.objects.select_related('Plan__id').values('plan__id', 'videoLink')
            dataArr = []
            dataArr1 = []
            # print(planDetails)
            for dt in planDetails:
                # print(dt)
                dataObj = dict(dt)
                dataArr.append(dataObj)
            # print(dataArr)
            '''for dt in videodetails:
                print(dt)
                dataObj = dict(dt)
                dataArr1.append(dataObj)
            print(dataArr1)'''
            return JsonResponse({"success": True, "details": dataArr, "videosLinks": dataArr1, "ActivePlan": planids})
        else:
            return JsonResponse({"success": False, "message": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})


@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def individualPlanDetails(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        planInfo = json.loads(request.body.decode('utf-8'))
        if username != None:
            planDetails = Plan.objects.select_related('Goals__id', 'ProgramType__id').filter(pk=planInfo['id']).values(
                'id', 'planName', 'planGoal__goalName', 'planDescription', 'programType__programTypeName',
                'licencePolicy', 'originalPlanner_id', 'createdBy_id')
            # dataArr = []
            for dt in planDetails:
                dataObj = dict(dt)
                if dataObj['licencePolicy'] == "3" or dataObj['licencePolicy'] == "White-Label":
                    partnerName = User.objects.get(id=dataObj['createdBy_id'])
                    dataObj['planDescription'] = str(
                        dataObj['planDescription']) + "<br><h6>Copyright &copy; 2017 " + str(
                        str(partnerName.first_name) + " " + str(partnerName.last_name)) + ". All rights reserved.</h6>"
                else:
                    coachName = User.objects.get(id=dataObj['originalPlanner_id'])
                    dataObj['planDescription'] = str(
                        dataObj['planDescription']) + "<br><h6>Copyright &copy; 2017 " + str(
                        str(coachName.first_name) + " " + str(coachName.last_name)) + ". All rights reserved.</h6>"
                # dataArr.append(dataObj)
            # print(dataArr)
            return JsonResponse({"success": True, "details": dataObj})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})


@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def planLists(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        if username != None:
            userid = username['id']
            planDetails = Plan.objects.select_related('Goals__id', 'ProgramType__id', 'User__id').filter(planStatus=1,
                                                                                                         activationStatus=1).values(
                'id', 'planName', 'planPhoto', 'price', 'planGoal__goalName', 'planDescription',
                'programType__programTypeName', 'programType__id', 'duration_weeks', 'createdBy_id', 'ability',
                'createdBy_id__avatar', 'createdBy_id__first_name', 'originalPlanner', 'planLogo', 'licencePolicy',
                'originalPlanner_id', 'createdBy', 'iosPrice', 'iosStatus')
            planArr = []
            planCoaches = []
            for dt in planDetails:
                dataObj = dict(dt)
                # print(dataObj)
                secret_code_plain = dataObj['planName'] + '#' + str(dataObj['id'])
                secret_code_encode = base64.b64encode(secret_code_plain.encode('ascii'))
                encodedVal = str(secret_code_encode).split("'")
                dataObj['encodedurl'] = encodedVal[1]
                if dataObj['licencePolicy'] == "3" or dataObj['licencePolicy'] == "White-Label":
                    partnerName = User.objects.get(id=dataObj['createdBy_id'])
                    dataObj['planDescription'] = str(
                        dataObj['planDescription']) + "<br><h6>Copyright &copy; 2017 " + str(
                        str(partnerName.first_name) + " " + str(partnerName.last_name)) + ". All rights reserved.</h6>"
                else:
                    coachName = User.objects.get(id=dataObj['originalPlanner_id'])
                    dataObj['planDescription'] = str(
                        dataObj['planDescription']) + "<br><h6>Copyright &copy; 2017 " + str(
                        str(coachName.first_name) + " " + str(coachName.last_name)) + ". All rights reserved.</h6>"

                planAbilityVal = SelectedAbilities.objects.select_related('PlanAbilities').filter(
                    plan_id=dataObj['id']).values('ability_id__ability')
                abilities = ''
                for val in planAbilityVal:
                    valObj = dict(val)
                    abilities += ", " + valObj['ability_id__ability']
                if abilities != '':
                    planAbilities = abilities[1:]
                else:
                    planAbilities = ""
                planPurposesVal = PlanGoals.objects.select_related('PlanPurposes').filter(
                    plan_id=dataObj['id']).values('planGoal_id__GoalName')
                purposes = ''
                for val in planPurposesVal:
                    valObj = dict(val)
                    purposes += ", " + valObj['planGoal_id__GoalName'] + " "
                if purposes != '':
                    planGoals = purposes[1:]
                else:
                    planGoals = ""
                downloadUsers = UserPlan.objects.filter(plan_id=dataObj['id']).values('user_id').distinct().count()
                ratingObj = PlanRating.objects.filter(plan=dataObj['id']).values()
                totalRate = 0
                userCount = 1
                for rt in ratingObj:
                    rateObj = dict(rt)
                    totalRate = totalRate + rateObj['rating']
                    userCount = userCount + 1
                rating = totalRate / userCount
                planCoaches.append(dataObj['createdBy'])
                dataObj['ability'] = planAbilities
                dataObj['planGoal__goalName'] = planGoals
                dataObj['planPurpose'] = dataObj['ability']
                dataObj['planType'] = dataObj['programType__programTypeName']
                dataObj['planCompetency'] = "0"
                dataObj['planPrice'] = dataObj['price']
                dataObj['planUsers'] = downloadUsers
                dataObj['PlanRating'] = rating
                dataObj['coachId'] = dataObj['createdBy']
                dataObj['planGoal'] = dataObj['planGoal__goalName']
                dataObj['planLevel'] = dataObj['programType__id']
                if dataObj['planType'] == "STARTER":
                    dataObj['ptype'] = 'S'
                    dataObj['planType'] = "BEGINNER"
                elif dataObj['planType'] == "INTERMEDIATE":
                    dataObj['ptype'] = 'I'
                elif dataObj['planType'] == "ADVANCED":
                    dataObj['ptype'] = 'A'

                
                dataObj['planDuration'] = dataObj['duration_weeks']
                dataObj['coachId'] = dataObj['createdBy']
                """draftedPlans = DraftedPlan.objects.filter(planId_id = dataObj['id'],status = 1).values('planId_id','planJson','protocolJson')
                if draftedPlans.exists():
                    for df in draftedPlans:
                        draftData = dict(df)
                        #dataObj['planJson'] = draftData['planJson']
                        #dataObj['planJson'] = json.loads(draftData['planJson'].replace("'", '"'))
                        dataObj['planJson'] = json.loads(draftData['planJson'].replace("'", "\'"))
                        #dataObj['protocolJson'] = draftData['protocolJson']
                else:
                    dataObj['planJson'] = ''
                    #dataObj['protocolJson'] = '' """
                # if dataObj['createdBy'] == dataObj['originalPlanner']:
                planArr.append(dataObj)
            planVideos = PlanVideos.objects.select_related('Videos__id').values('video__videoLink', 'plan_id')
            planVideoArr = []
            for video in planVideos:
                videos = dict(video)
                videos['videolink'] = 'QR77PiSkDgA'
                planVideoArr.append(videos)
            coachDetails = User.objects.filter(id__in=planCoaches).values()
            coachArr = []
            for coach in coachDetails:
                coach_id = dict(coach)
                followCnt = Userfollow.objects.filter(followerUser_id=coach_id['id'], status=1).count()
                coach_id['followers'] = followCnt
                trainers = trainerProfile.objects.filter(user_id=coach_id['id']).values()
                for tr in trainers:
                    trainer = dict(tr)
                if coach_id['avatar'] is not None:
                    coach_id['coachThumbnail'] = ''
                else:
                    coach_id['coachThumbnail'] = ''
                coach_id['coachId'] = coach['id']
                coach_id['coachName'] = coach['first_name'] + ' ' + coach['last_name']
                coachPlansArr = []
                plans = Plan.objects.filter(createdBy_id=coach_id['id']).values('id')
                for pl in plans:
                    coachPlans = dict(pl)
                    coachPlansArr.append(coachPlans['id'])
                coach_id['coachPlans'] = coachPlansArr
                userAddress = UserAddress.objects.filter(user_id=coach_id['id']).values()
                if userAddress.exists():
                    for ua in userAddress:
                        uAddr = dict(ua)
                        if uAddr['country'] == 88:
                            coach_id['coachLocation'] = 'India'
                        else:
                            coach_id['coachLocation'] = 'International'
                else:
                    coach_id['coachLocation'] = 'India'
                coachArr.append(coach_id)
                userCurrency = User.objects.get(id=userid)
            return JsonResponse({"success": True, "details": planArr, "Videos": planVideoArr, "allCoaches": coachArr,
                                 "luctype": userCurrency.currencyType})
        else:
            return JsonResponse({"success": False, "message": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def changeIds(request):
    stratsessionutil = StartFitSessionUtil()
    user = stratsessionutil.get_user_insession(request)
    try:
        if user != None:
            planInfo = json.loads(request.body.decode('utf-8'))
            plan=Plan.objects.all().filter(createdBy_id=planInfo['id'],modifiedBy_id=planInfo['orgId']).values()
            array=[]
            for dt in plan:
                planIds=dict(dt)
                array.append(planIds['id'])   
            plan=Plan.objects.filter(id__in=array).update(modifiedBy_id=planInfo['id'],originalPlanner_id=planInfo['id'])
            act=Plan_Actions.objects.filter(plan_id_id__in=array).update(modified_By_id=planInfo['id'],created_By_id=planInfo['id'])
            rounds=Plan_Round.objects.filter(plan_id_id__in=array).update(modified_By_id=planInfo['id'],created_By_id=planInfo['id'])
            activity=Plan_Activity.objects.filter(plan_id_id__in=array).update(modified_By_id=planInfo['id'],created_By_id=planInfo['id'])
            session=Plan_Sessions.objects.filter(plan_id_id__in=array).update(modified_By_id=planInfo['id'],created_By_id=planInfo['id'])
            day= Plan_Days.objects.filter(plan_id_id__in=array).update(modified_By_id=planInfo['id'],created_By_id=planInfo['id'])
            micro=Plan_Microcycles.objects.filter(plan_id_id__in=array).update(modified_By_id=planInfo['id'],created_By_id=planInfo['id'])
            meso= Plan_Mesocycle.objects.filter(plan_id_id__in=array).update(modified_By_id=planInfo['id'],created_By_id=planInfo['id'])
            period=Plan_Period.objects.filter(plan_id_id__in=array).update(modified_By_id=planInfo['id'],created_By_id=planInfo['id'])  
            return JsonResponse({"success":True,"message":"plan details successfully changed"})
        else:
            return JsonResponse({"success": False, "message": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})


@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def checkInSeason(request):
    stratsessionutil = StartFitSessionUtil()
    user = stratsessionutil.get_user_insession(request)
    try:
        if user != None:
            planInfo = json.loads(request.body.decode('utf-8'))
            season = Plan_Period.objects.filter(plan_id=planInfo['planid']).values('plan_id', 'num_of_mesocycles',
                                                                                   'duration_weeks', 'id', 'periodName')
            for dt in season:
                print(dt)
                seasonObj = dict(dt)
                if seasonObj['periodName'] == "In-Season":
                    microcycleCount = Plan_Microcycles.objects.select_related('PlanMesocylce', 'Plan', 'Plan_Period').filter(
                        mesocycle_id__period_id__plan_id=planInfo['planid']).count()
                    print(microcycleCount)
                    return JsonResponse({"success": True, "message": "In-Season", "mcCount": microcycleCount})
            return JsonResponse({"success": False})
        else:
            return JsonResponse({"success": False, "message": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})


@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def individualuserplans1(request):
    stratsessionutil = StartFitSessionUtil()
    CoachID = json.loads(request.body.decode('utf-8'))
    
    individualuserplan={} 
    
    COACH={}
    
    lookuptable_key=CoachID['coachid']
    cachesession=cache.get(lookuptable_key)
    
    #cachesession=[]
    if cachesession :
        
        COACH=cachesession
        
        if CoachID['coachid']:
            try:    
                individualuserplan=COACH[CoachID['coachid']]
                
                print(individualuserplan['luctype'],"gfrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrr")
                
                username = stratsessionutil.get_user_insession(request)
                if username!=None:
                    
                    return JsonResponse({"success": True, "details": individualuserplan['planArr'], "allCoaches":individualuserplan['coachArr'] ,
                                        "totalcount": individualuserplan['totalusercount'], "luctype":individualuserplan['luctype'] ,
                                        
                                        "is_active":individualuserplan['is_active'] , 
                                        "avatar":individualuserplan['avatar'] ,  
                                        "currencyType": individualuserplan['currencyType'],
                                        
                                        "coverImage":individualuserplan['userCover'], 
                                        "generalWarmup": [
                            {"Name": "Hip Circles", "Reps": 5, "ExTime": "Not Applicable", "Direction": "Both",
                            "Equipment": "Not Applicable"},
                            {"Name": "Knee Circles", "Reps": 10, "ExTime": "Not Applicable", "Direction": "Both",
                            "Equipment": "Not Applicable"},
                            {"Name": "Standing lower back release", "Reps": 10, "ExTime": "Not Applicable",
                            "Direction": "Not Applicable", "Equipment": "Not Applicable"},
                            {"Name": "Roll overs", "Reps": 10, "ExTime": "Not Applicable", "Direction": "Not Applicable",
                            "Equipment": "Not Applicable"},
                            {"Name": "Fire Hydrant Circles", "Reps": 10, "ExTime": "Not Applicable",
                            "Direction": "Each leg / Direction", "Equipment": "Not Applicable"},
                            {"Name": "Foam Rolling - Back", "Reps": 8, "ExTime": "Not Applicable",
                            "Direction": "Not Applicable", "Equipment": "Foam Roller"},
                            {"Name": "IT Band", "Reps": 8, "ExTime": "Not Applicable", "Direction": "Each leg",
                            "Equipment": "Foam Roller"},
                            {"Name": "Adductors", "Reps": 8, "ExTime": "Not Applicable", "Direction": "Each leg",
                            "Equipment": "Foam Roller"},
                            {"Name": "Ball Rolling (Cricket / Baseball)", "Reps": 0, "ExTime": "30", "Direction": "Each side",
                            "Equipment": "Cricket / Baseball"},
                            {"Name": "Arm Swings - Over under", "Reps": 10, "ExTime": "Not Applicable",
                            "Direction": "Not Applicable", "Equipment": "Not Applicable"}],
                                        "Cooldown": [{"name": "FLoor Quadraceps Stretch"}, {"name": "Floor Glute Stretch"},
                                                    {"name": "Neck, Back, and Hamstring Stretch"},
                                                    {"name": "Classic Hamstring Stretch"},
                                                    {"name": "Shoulders and Biceps Stretch"}, {"name": "Lower Back Stretch"},
                                                    {"name": "Frog Stretch"}, {"name": "Cat Stretch"},
                                                    {"name": "Triceps and Lat Reach Stretch"}], "exerciseWarmup": {
                            "strength": [{"Sets": 1, "Reps": 10, "intensity": 50}, {"Sets": 1, "Reps": 6, "intensity": 60},
                                        {"Sets": 1, "Reps": 4, "intensity": 70}, {"Sets": 1, "Reps": 3, "intensity": 80},
                                        {"Sets": 1, "Reps": 1, "intensity": 90}],
                            "explosive": [{"Sets": 1, "Reps": 5, "intensity": 50}, {"Sets": 1, "Reps": 5, "intensity": 50},
                                        {"Sets": 1, "Reps": 3, "intensity": 60}, {"Sets": 1, "Reps": 3, "intensity": 60},
                                        {"Sets": 1, "Reps": 3, "intensity": 70}, {"Sets": 1, "Reps": 1, "intensity": 80},
                                        {"Sets": 1, "Reps": 1, "intensity": 90}]}})
                else:
                    return JsonResponse({"message":"User has been logged out"})
            except Exception as e:
                logger.exception("something wrong")
                return JsonResponse({"msg": str(e)})  
        else:
            return JsonResponse({"message":"User has been logged out"})


    else:
        if CoachID['coachid']:
            try:
                username = stratsessionutil.get_user_insession(request)
                coachInfo = json.loads(request.body.decode('utf-8'))
                #print(coachInfo)
                if username != None:
                    userid = username['id']
                    userCurrency = User.objects.get(id=userid)
                    currencyValues = PriceConversion.objects.get(id=1)
                    inrValue = currencyValues.inrValue
                    indianPlanArr = []
                    otherPlanArr = []
                    india = False
                    countryID = UserAddress.objects.select_related('User__id').filter(country=88, user_id=userid).values()
                    if countryID.exists():
                        for con in countryID:
                            conObj = dict(con)
                            username['userCountry'] = conObj['country']
                        india = True
                    indianPlans = PlanCountry.objects.filter(country_id=88).values()
                    for inp in indianPlans:
                        inpObj = dict(inp)
                        indianPlanArr.append(inpObj['plan_id'])
                    otherPlans = PlanCountry.objects.filter(~Q(country_id=88)).values()
                    for otp in otherPlans:
                        otpObj = dict(otp)
                        otherPlanArr.append(otpObj['plan_id'])
                    if india == True:
                        if 'coachid' in coachInfo and coachInfo['coachid'] != '':
                            if 'deviceType' in coachInfo and coachInfo['deviceType'] == 'ios':
                                planDetails = Plan.objects.select_related('Goals__id', 'ProgramType__id', 'User__id').values(
                                    'id', 'planName', 'planPhoto', 'price', 'planGoal__goalName', 'planDescription',
                                    'programType__programTypeName', 'programType__id', 'duration_weeks', 'createdBy_id',
                                    'ability', 'createdBy_id__avatar', 'createdBy_id__first_name', 'createdBy_id__last_name',
                                    'planStatus', 'planLogo', 'originalPlanner_id', 'licencePolicy', 'iosPrice', 'iosStatus',
                                    'indianIosPrice', 'indianPrice', 'createdBy_id__userCover', 'num_of_sessions').filter(
                                    createdBy=coachInfo['coachid'], planStatus=1, activationStatus=1,
                                    id__in=indianPlanArr).order_by('programType_id', 'planName')
                            else:
                                planDetails = Plan.objects.select_related('Goals__id', 'ProgramType__id', 'User__id').values(
                                    'id', 'planName', 'planPhoto', 'price', 'planGoal__goalName', 'planDescription',
                                    'programType__programTypeName', 'programType__id', 'duration_weeks', 'createdBy_id',
                                    'ability', 'createdBy_id__avatar', 'createdBy_id__first_name', 'createdBy_id__last_name',
                                    'planStatus', 'planLogo', 'originalPlanner_id', 'licencePolicy', 'iosPrice', 'iosStatus',
                                    'indianIosPrice', 'indianPrice', 'createdBy_id__userCover', 'num_of_sessions').filter(
                                    createdBy=coachInfo['coachid'], planStatus=1, activationStatus=1,
                                    id__in=indianPlanArr).order_by('programType_id', 'planName')
                        elif 'pname' in coachInfo and coachInfo['pname'] != '':
                            if 'deviceType' in coachInfo and coachInfo['deviceType'] == 'ios':
                                planDetails = Plan.objects.select_related('Goals__id', 'ProgramType__id', 'User__id').values(
                                    'id', 'planName', 'planPhoto', 'price', 'planGoal__goalName', 'planDescription',
                                    'programType__programTypeName', 'programType__id', 'duration_weeks', 'createdBy_id',
                                    'ability', 'createdBy_id__avatar', 'createdBy_id__first_name', 'createdBy_id__last_name',
                                    'planStatus', 'planLogo', 'originalPlanner_id', 'licencePolicy', 'iosPrice', 'iosStatus',
                                    'indianIosPrice', 'indianPrice', 'createdBy_id__userCover', 'num_of_sessions').filter(
                                    planName__icontains=coachInfo['pname'], planStatus=1, activationStatus=1,
                                    id__in=indianPlanArr).order_by('programType_id', 'planName')
                            else:
                                planDetails = Plan.objects.select_related('Goals__id', 'ProgramType__id', 'User__id').values(
                                    'id', 'planName', 'planPhoto', 'price', 'planGoal__goalName', 'planDescription',
                                    'programType__programTypeName', 'programType__id', 'duration_weeks', 'createdBy_id',
                                    'ability', 'createdBy_id__avatar', 'createdBy_id__first_name', 'createdBy_id__last_name',
                                    'planStatus', 'planLogo', 'originalPlanner_id', 'licencePolicy', 'iosPrice', 'iosStatus',
                                    'indianIosPrice', 'indianPrice', 'createdBy_id__userCover', 'num_of_sessions').filter(
                                    planName__icontains=coachInfo['pname'], planStatus=1, activationStatus=1,
                                    id__in=indianPlanArr).order_by('programType_id', 'planName')
                        elif 'planid' in coachInfo and coachInfo['planid'] != '':
                            getCoachObj = Plan.objects.filter(id=coachInfo['planid']).values()
                            for co in getCoachObj:
                                coachObj = dict(co)
                                #print(coachObj)
                                coachID = coachObj['createdBy_id']
                            if 'deviceType' in coachInfo and coachInfo['deviceType'] == 'ios':
                                planDetails = Plan.objects.select_related('Goals__id', 'ProgramType__id', 'User__id').values(
                                    'id', 'planName', 'planPhoto', 'price', 'planGoal__goalName', 'planDescription',
                                    'programType__programTypeName', 'programType__id', 'duration_weeks', 'createdBy_id',
                                    'ability', 'createdBy_id__avatar', 'createdBy_id__first_name', 'createdBy_id__last_name',
                                    'planStatus', 'planLogo', 'originalPlanner_id', 'licencePolicy', 'iosPrice', 'iosStatus',
                                    'indianIosPrice', 'indianPrice', 'createdBy_id__userCover', 'num_of_sessions').filter(createdBy=coachID,
                                                                                                    planStatus=1,
                                                                                                    activationStatus=1,
                                                                                                    id__in=indianPlanArr).order_by(
                                    'programType_id', 'planName')
                            else:
                                planDetails = Plan.objects.select_related('Goals__id', 'ProgramType__id', 'User__id').values(
                                    'id', 'planName', 'planPhoto', 'price', 'planGoal__goalName', 'planDescription',
                                    'programType__programTypeName', 'programType__id', 'duration_weeks', 'createdBy_id',
                                    'ability', 'createdBy_id__avatar', 'createdBy_id__first_name', 'createdBy_id__last_name',
                                    'planStatus', 'planLogo', 'originalPlanner_id', 'licencePolicy', 'iosPrice', 'iosStatus',
                                    'indianIosPrice', 'indianPrice', 'createdBy_id__userCover', 'num_of_sessions').filter(createdBy=coachID,
                                                                                                    planStatus=1,
                                                                                                    activationStatus=1,
                                                                                                    id__in=indianPlanArr).order_by(
                                    'programType_id', 'planName')
                    else:

                        if 'coachid' in coachInfo and coachInfo['coachid'] != '':
                            if 'deviceType' in coachInfo and coachInfo['deviceType'] == 'ios':
                                planDetails = Plan.objects.select_related('Goals__id', 'ProgramType__id', 'User__id').values(
                                    'id', 'planName', 'planPhoto', 'price', 'planGoal__goalName', 'planDescription',
                                    'programType__programTypeName', 'programType__id', 'duration_weeks', 'createdBy_id',
                                    'ability', 'createdBy_id__avatar', 'createdBy_id__first_name', 'createdBy_id__last_name',
                                    'planStatus', 'planLogo', 'originalPlanner_id', 'licencePolicy', 'iosPrice', 'iosStatus',
                                    'indianIosPrice', 'indianPrice', 'createdBy_id__userCover', 'num_of_sessions').filter(
                                    createdBy=coachInfo['coachid'], planStatus=1, activationStatus=1,
                                    id__in=otherPlanArr).order_by('programType_id', 'planName')
                            else:
                                planDetails = Plan.objects.select_related('Goals__id', 'ProgramType__id', 'User__id').values(
                                    'id', 'planName', 'planPhoto', 'price', 'planGoal__goalName', 'planDescription',
                                    'programType__programTypeName', 'programType__id', 'duration_weeks', 'createdBy_id',
                                    'ability', 'createdBy_id__avatar', 'createdBy_id__first_name', 'createdBy_id__last_name',
                                    'planStatus', 'planLogo', 'originalPlanner_id', 'licencePolicy', 'iosPrice', 'iosStatus',
                                    'indianIosPrice', 'indianPrice', 'createdBy_id__userCover', 'num_of_sessions').filter(
                                    createdBy=coachInfo['coachid'], planStatus=1, activationStatus=1,
                                    id__in=otherPlanArr).order_by('programType_id', 'planName')
                        elif 'pname' in coachInfo and coachInfo['pname'] != '':
                            if 'deviceType' in coachInfo and coachInfo['deviceType'] == 'ios':
                                planDetails = Plan.objects.select_related('Goals__id', 'ProgramType__id', 'User__id').values(
                                    'id', 'planName', 'planPhoto', 'price', 'planGoal__goalName', 'planDescription',
                                    'programType__programTypeName', 'programType__id', 'duration_weeks', 'createdBy_id',
                                    'ability', 'createdBy_id__avatar', 'createdBy_id__first_name', 'createdBy_id__last_name',
                                    'planStatus', 'planLogo', 'originalPlanner_id', 'licencePolicy', 'iosPrice', 'iosStatus',
                                    'indianIosPrice', 'indianPrice', 'createdBy_id__userCover', 'num_of_sessions').filter(
                                    planName__icontains=coachInfo['pname'], planStatus=1, activationStatus=1,
                                    id__in=otherPlanArr).order_by('programType_id', 'planName')
                            else:
                                planDetails = Plan.objects.select_related('Goals__id', 'ProgramType__id', 'User__id').values(
                                    'id', 'planName', 'planPhoto', 'price', 'planGoal__goalName', 'planDescription',
                                    'programType__programTypeName', 'programType__id', 'duration_weeks', 'createdBy_id',
                                    'ability', 'createdBy_id__avatar', 'createdBy_id__first_name', 'createdBy_id__last_name',
                                    'planStatus', 'planLogo', 'originalPlanner_id', 'licencePolicy', 'iosPrice', 'iosStatus',
                                    'indianIosPrice', 'indianPrice', 'createdBy_id__userCover', 'num_of_sessions').filter(
                                    planName__icontains=coachInfo['pname'], planStatus=1, activationStatus=1,
                                    id__in=otherPlanArr).order_by('programType_id', 'planName')
                        elif 'planid' in coachInfo and coachInfo['planid'] != '':
                            getCoachObj = Plan.objects.filter(id=coachInfo['planid']).values()
                            for co in getCoachObj:
                                coachObj = dict(co)
                                #print(coachObj)
                                coachID = coachObj['createdBy_id']
                            if 'deviceType' in coachInfo and coachInfo['deviceType'] == 'ios':
                                planDetails = Plan.objects.select_related('Goals__id', 'ProgramType__id', 'User__id').values(
                                    'id', 'planName', 'planPhoto', 'price', 'planGoal__goalName', 'planDescription',
                                    'programType__programTypeName', 'programType__id', 'duration_weeks', 'createdBy_id',
                                    'ability', 'createdBy_id__avatar', 'createdBy_id__first_name', 'createdBy_id__last_name',
                                    'planStatus', 'planLogo', 'originalPlanner_id', 'licencePolicy', 'iosPrice', 'iosStatus',
                                    'indianIosPrice', 'indianPrice', 'createdBy_id__userCover', 'num_of_sessions').filter(createdBy=coachID,
                                                                                                    planStatus=1,
                                                                                                    activationStatus=1,
                                                                                                    id__in=otherPlanArr).order_by(
                                    'programType_id', 'planName')
                            else:
                                planDetails = Plan.objects.select_related('Goals__id', 'ProgramType__id', 'User__id').values(
                                    'id', 'planName', 'planPhoto', 'price', 'planGoal__goalName', 'planDescription',
                                    'programType__programTypeName', 'programType__id', 'duration_weeks', 'createdBy_id',
                                    'ability', 'createdBy_id__avatar', 'createdBy_id__first_name', 'createdBy_id__last_name',
                                    'planStatus', 'planLogo', 'originalPlanner_id', 'licencePolicy', 'iosPrice', 'iosStatus',
                                    'indianIosPrice', 'indianPrice', 'createdBy_id__userCover', 'num_of_sessions').filter(createdBy=coachID,
                                                                                                    planStatus=1,
                                                                                                    activationStatus=1,
                                                                                                    id__in=otherPlanArr).order_by(
                                    'programType_id', 'planName')
                    planArr = []
                    planValArr = []
                    planCoaches = []
                    totalusercount = 0
                    '''
                    updetails = UserPlan.objects.filter(user=userid).filter(status__in=[1, 3]).values('status', 'plan_id',
                                                                                                    'nextRenewalDate')
                    if updetails.exists():
                        for dt in updetails:
                            planObj = dict(dt)
                            planObj['nextRenewalDate'] = planObj['nextRenewalDate'].strftime("%Y-%m-%d")
                            planValArr.append(planObj)
                    '''        
                    originalPlanner=[]
                    array=[]
                    arrays=[]   
                    #print("plannindividualuserplans")  
                    if planDetails.exists():       
                        for dt in planDetails:
                            dataObj = dict(dt)
                            #print("dataobj")
                            array.append(dataObj['id'])
                            arrays.append(dataObj['createdBy_id'])
                            originalPlanner.append(dataObj['originalPlanner_id'])
                        #planurls = PlanShortUrls.objects.filter(plan_id__in=array).values()
                        trainerDetails = trainerProfile.objects.filter(user_id__in=arrays).values()
                        '''
                        celeblikesVal = CelebrityPlansLikes.objects.select_related('User__id').filter(plan_id__in=array, status=1).values('plan_id','id',
                                                                                                                            'user_id',
                                                                                                                            'user_id__first_name',
                                                                                                                            'user_id__last_name',
                                                                                                                            'user_id__avatar')
                        '''
                        reviewslikes=CelebrityPlansLikes.objects.select_related('User__id').filter(plan_id__in=array).values('plan_id','id','user_id','user_id__first_name','user_id__last_name','reviews','user_id__avatar').exclude(reviews__isnull=True).exclude(reviews__exact='') 
                        planlikescount = CelebrityPlansLikes.objects.filter(plan_id__in=array,status=1).values('plan_id').annotate(total=Count('user_id'))
                        celebplanlikes = CelebrityPlansLikes.objects.filter(plan_id__in=array, user_id=username['id'],status=1).values()
                        celeb={}
                        Celeb=[]
                        for i in celebplanlikes:
                            celeb[i['plan_id']]=i['id']
                            Celeb.append(i['plan_id'])
                                                                                
                        planlikes={}
                        a=[]
                        for i in planlikescount:
                            
                            planlikes[i['plan_id']]=i['total']
                            a.append(i['plan_id'])

                        reviewcount=CelebrityPlansLikes.objects.filter(plan_id__in=array).exclude(reviews__isnull=True).exclude(reviews__exact='').annotate(total=Count('user_id'))
                        
                        review={}
                        b=[]
                        for i in reviewcount:
                            review[i['plan_id']]=i['total']
                            b.append(i['plan_id'])
                        '''   
                        video={}
                        planVideos=[]
                        planvideos=PlanVideos.objects.filter(plan_id__in=array).latest('id')
                        Ids=[]
                        Ids.append(planvideos.id)
                        program=PlanVideos.objects.filter(id__in=Ids).values()
                        for j in array:
                            for i in program:
                                if j==i['plan_id']:
                                    planVideos.append(i['video'])
                                    video[i['plan_id']]=planVideos[0]
                                    
                            planVideos=[]
                        '''       
                        planAbilityVals = SelectedAbilities.objects.select_related('PlanAbilities').filter(
                                plan_id__in=array).values('ability_id__ability','plan_id')
                        
                        Goals={}
                        ability={} 
                        abb=[]
                        purpose=[]
                        planPurposesVals = PlanGoals.objects.select_related('PlanPurposes').filter(plan_id__in=array).values(
                                'planGoal_id__GoalName','plan_id')
                        
                            
                        for j in array:
                            for i in planAbilityVals:
                            
                                if j==i['plan_id']:
                                    abb.append(i['ability_id__ability'])
                                    #print(', '.join(a))
                                    ability[i['plan_id']] = abb
                                    
                            abb=[]
                        for j in array:      
                            for i in planPurposesVals:
                                if j==i['plan_id']:
                                    purpose.append(i['planGoal_id__GoalName'])
                                    Goals[i['plan_id']]=purpose
                                    
                            purpose=[]

                            
                        RatingObj = PlanRating.objects.filter(plan__in=array).values()
                        Rating=[]
                        RatingPercent={}
                        c=[]
                        for j in array:
                            for hg in RatingObj:
                                if j==hg['plan_id']:
                                    if type(hg['rating']) != float:
                                        rate=0
                                    else:
                                        rate=hg['rating']    
                                    Rating.append(rate)
                                    RatingPercent[hg['plan_id']]=Rating
                                    c.append(hg['plan_id'])
                            Rating=[]        

                        exercisesObj = Plan_Actions.objects.select_related('NewExercise').filter(plan_id__in=array).values('exercise_id', 'exercise_id__exerciseName', 'exercise_id__exerciseDesc','exercise_id__video','exercise_id__thumb_image','exercise_id__cover_image', 'exercise_id__equipment','plan_id').distinct()
                        #print(exercisesObj,"exerciseObj")
                        exer=[]
                        exercise={}
                        for j in array:

                            for i in exercisesObj:
                                if j==i['plan_id']:

                                    exer.append(i)
                                    exercise['exercise']=exer
                        
                        downloadUsersp = UserPlan.objects.filter(plan_id__in=array).values('plan_id','user_id').annotate(total=Count('user_id'))
                        #print(downloadUsersp.query)
                        dictarr=[]
                        dictionary={}
                        for j in array:
                            for i in downloadUsersp:
                                
                                if j==i['plan_id']:
                                    
                                    dictarr.append(i['total'])
                                    num=len(dictarr)
                                    dictionary[i['plan_id']]=num
                                    num=[]
                            dictarr=[]
                        partnerName = User.objects.get(id=arrays[0]) 
                        coachVal = User.objects.get(id=originalPlanner[0])
                        coachName=coachVal
                        for dt in planDetails:
                    
                            dataObj = dict(dt)
                            
                            array.append(dataObj['id'])
                            arrays.append(dataObj['createdBy_id'])
                            
                            '''
                            if planurls.exists():
                                for val in planurls:
                                    valObj = dict(val)
                                    
                                    urlVal = valObj['longUrl'].split('/')
                                    urlVal1 = urlVal[6].split('=')
                                    urlVal2 = urlVal1[1].split('&')
                                    dataObj[urlVal2[0]] = valObj['shortUrl']
                            '''        
                            secret_code_plain = dataObj['planName'] + '#' + str(dataObj['id'])
                            secret_code_encode = base64.b64encode(secret_code_plain.encode('ascii'))
                            encodedVal = str(secret_code_encode).split("'")
                            #print(encodedVal)
                            dataObj['encodedurl'] = encodedVal[1]
                            
                            #trainerDetails = trainerProfile.objects.filter(user_id=dataObj['createdBy_id']).values()
                            if trainerDetails.exists():
                                for tr in trainerDetails:
                                    trObj = dict(tr)
                                dataObj['aboutTrainer'] = trObj['aboutTrainer']
                            else:
                                dataObj['aboutTrainer'] = "Trainer Content Unavailable"
                            
                            # print(dataObj)
                            
                            exerc={}
                            for i in ability:
                                
                                if dataObj['id'] == i:
                                    #print(i,ability[i])
                                    abb=', '.join(ability[i])
                                    dataObj['ability']=abb
                                    planAbilities=dataObj['ability'] 
                            if exercisesObj.exists():

                                Df=[]
                                for i in exercise['exercise']:
                                    if dataObj['id']==i['plan_id']:
                                        Df.append(i)
                                        exerc['plan_id']=i
                                        dataObj['exercises']=Df
                            else:
                                dataObj['exercise']=[]            
                            for num in dictionary:
                                if dataObj['id']==num:
                                    dataObj['planUsers']=dictionary[num]
                                    totalusercount = totalusercount + int(dictionary[num])
                        
                            if dataObj['id'] in a:
                                for i in planlikes:
                                    if dataObj['id']==i:
                                        dataObj['planlikesCount']=planlikes[i]
                            else:
                                dataObj['planlikesCount']=0
                            if dataObj['id'] in b:
                                for i in review:
                                    if dataObj['id']==i:
                                        dataObj['reviewsCount']= review[i]  
                            else:
                                dataObj['reviewsCount']=0 


                            totalRate=0
                            userCount=1 
                            jh=[]              
                            if dataObj['id'] in c:
                                jh.append(RatingPercent)
                                for i in jh:
                                    for j in i[dataObj['id']]:
                                        totalRate=totalRate+j
                                        userCount=userCount+1
                                rating=totalRate/userCount
                                dataObj['PlanRating']=rating 
                            else:
                                dataObj['PlanRating']=0      



                            
                            dataObj['celebreviewPlan'] = 0
                            dataObj['reviews'] = ''
                            if dataObj['id'] in Celeb:
                                for i in celeb:
                                    if dataObj['id']==i:
                                        dataObj['celeblikedplan']=1
                            else:
                                dataObj['celeblikedplan']=0 
                                
                            '''            
                            for i in video:
                                if dataObj['id'] == i:
                                    dataObj['video']=video[i]
                                    
                                else:
                                    dataObj['video']=" "            
                                        
                            '''

                            dataObj['celebreviewPlan']=0
                            dataObj['coachName'] = dataObj['createdBy_id__first_name'] + " " + dataObj['createdBy_id__last_name']
                            dataObj['createdBy_id__first_name'] = dataObj['createdBy_id__first_name'] + " " + dataObj[
                                'createdBy_id__last_name']
                            dataObj['planPrice'] = dataObj['price']
                            likearr=[]
                            reviewarr=[]
                            '''
                            for j in array:
                                for dt in celeblikesVal:
                                    if dataObj['id']==dt['plan_id']:
                                        
                                        
                                        dt['celebName']=dt['user_id__first_name']+" "+dt['user_id__last_name']    
                                        likearr.append(dt)
                                        dataObj['planlikes']=likearr
                                likearr=[]
                            '''    
                            for j in array:  
                                for dt in reviewslikes:
                                    
                                        if dataObj['id'] == dt['plan_id']:
                                            dt['celebName']=dt['user_id__first_name']+" "+dt['user_id__last_name']
                                            reviewarr.append(dt)
                                            dataObj['planreviews']=reviewarr
                                        
                                reviewarr=[] 
                                dataObj['planreviews']='null'          
                                
                            if 'deviceType' in coachInfo and coachInfo['deviceType'] == 'ios':
                                if userCurrency.currencyType == "INR":
                                    highestPrice = \
                                    Plan.objects.filter(activationStatus=1, planStatus=1).all().aggregate(Max('iosPrice'))[
                                        'iosPrice__max']
                                    if username['userCountry'] == 88:
                                        dataObj['price'] = dataObj['indianIosPrice']
                                        dataObj['planPrice'] = dataObj['price']
                                    else:
                                        dataObj['price'] = dataObj['iosPrice']
                                    if int(dataObj['price']) == 0:
                                        dataObj['price'] = "Free"
                                else:
                                    highestPriceVal = \
                                    Plan.objects.filter(activationStatus=1, planStatus=1).all().aggregate(Max('iosPrice'))[
                                        'iosPrice__max']
                                    highestVal = PriceMapping.objects.get(inr=highestPriceVal)
                                    highestPrice = highestVal.usd
                                    if username['userCountry'] == 88:
                                        usdValue = PriceMapping.objects.values().filter(inr=dataObj['indianIosPrice'])
                                    else:
                                        usdValue = PriceMapping.objects.values().filter(inr=dataObj['iosPrice'])
                                    for usd in usdValue:
                                        usdObj = dict(usd)
                                        dollarVal = usdObj['usd']
                                    dataObj['price'] = dollarVal
                                    if int(dataObj['price']) == 0:
                                        dataObj['price'] = "Free"
                            else:
                                if int(dataObj['price']) == 0:
                                    dataObj['price'] = "Free"
                                else:
                                    if userCurrency.currencyType == "INR":
                                        if username['userCountry'] == 88:
                                            dataObj['price'] = round((dataObj['indianPrice']) * float(inrValue))
                                            dataObj['planPrice'] = dataObj['price']
                                        else:
                                            dataObj['price'] = round((dataObj['price']) * float(inrValue))
                                            dataObj['planPrice'] = dataObj['price']
                                    else:
                                        if username['userCountry'] == 88:
                                            dataObj['price'] = dataObj['indianPrice']
                                            dataObj['planPrice'] = dataObj['price']
                                        else:
                                            dataObj['price'] = dataObj['price']
                                            dataObj['planPrice'] = dataObj['price']
                                    if float(dataObj['price']) == 0:
                                        dataObj['price'] = "Free"
                                    
                            for i in ability:
                                
                                if dataObj['id'] == i:
                                    
                                    abb=', '.join(ability[i])
                                    dataObj['ability']=abb
                                    
                                    planAbilities=dataObj['ability'] 
                                    dataObj['planPurpose']=dataObj['ability']
                            
                            for i in Goals:
                                
                                if dataObj['id'] == i:
                                    
                                    purpose=', '.join(Goals[i])
                                    dataObj['plan_goals']=purpose
                                    planGoals=dataObj['plan_goals']    
                            
                            if dataObj['originalPlanner_id'] != dataObj['createdBy_id']:
                                coachVal = User.objects.get(id=dataObj['originalPlanner_id'])
                                coachName = coachVal.first_name
                                dataObj['oriCoachName'] = coachName
                            dataObj['planDescription'] = dataObj['planDescription'] + "<br><br><font><b>Abilities:</b> " +abb + "</font>" + "<br><br><font><b>Purposes:</b> " + purpose + "</font>"
                            if dataObj['licencePolicy'] == "3" or dataObj['licencePolicy'] == "White-Label":
                                #partnerName = User.objects.get(id=dataObj['createdBy_id'])
                                
                                dataObj['planDescription'] = str(
                                    dataObj['planDescription']) + "<br><h6>Copyright &copy; 2017 " + str(
                                    str(partnerName.first_name) + " " + str(partnerName.last_name)) + ". All rights reserved.</h6>"
                            else:
                                if dataObj['originalPlanner_id'] != dataObj['createdBy_id']:
                                    #coachVal = User.objects.get(id=dataObj['originalPlanner_id'])
                                    coachName = coachVal.first_name + " " + coachVal.last_name
                                    dataObj['oriCoachName'] = coachName
                                #coachName = User.objects.get(id=dataObj['originalPlanner_id'])
                                dataObj['planDescription'] = str(
                                    dataObj['planDescription']) + "<br><h6>Copyright &copy; 2017 " + str(
                                    coachName) + ". All rights reserved.</h6>"
                            
                            planCoaches.append(dataObj['createdBy_id'])
                            #dataObj['planPurpose'] = planAbilities
                            #dataObj['plan_goals'] = planGoals
                            dataObj['planType'] = dataObj['programType__programTypeName']
                            dataObj['planCompetency'] = "0"
                            #dataObj['planUsers'] = downloadUsers
                            #totalusercount = totalusercount + int(downloadUsers)
                            #dataObj['PlanRating'] = rating
                            dataObj['coachId'] = dataObj['createdBy_id']
                            dataObj['planGoal'] = dataObj['planGoal__goalName']
                            dataObj['planLevel'] = dataObj['programType__id']

                            if dataObj['planType'] == "STARTER":
                                dataObj['ptype'] = 'S'
                                dataObj['planType'] = "Beginner"
                            elif dataObj['planType'] == "INTERMEDIATE":
                                dataObj['planType'] = "Intermediate"
                                dataObj['ptype'] = 'I'
                            elif dataObj['planType'] == "ADVANCED":
                                dataObj['planType'] = "Advanced"
                                dataObj['ptype'] = 'A'
                            
                            planVideos=PlanVideos.objects.filter(plan_id=dataObj['id']).values('video')
                            if planVideos.exists():
                                for dt in planVideos:
                                    videos=dict(dt)
                                    dataObj['videos'] =dt['video'] 
                            else:
                                dataObj['videos']=" "   
                                
                            '''
                                if videos != None:
                                    Video=PlanVideos.objects.get(id=videosid)
                                    print("gggggggggggggggggggggggggggg")
                                    dataObj['video']=Video.video
                                else:
                                    dataObj['video']=" "
                                '''    
                            dataObj['planDuration'] = dataObj['duration_weeks']
                            dataObj['coachId'] = dataObj['createdBy_id']
                            
                            individualuserplan['Id']=dataObj['coachId']
                            planArr.append(dataObj)
                        
                    else:
                        planArr=[]
                    
                    coachDetails = User.objects.filter(id__in=planCoaches).values()
                    
                    coachArr = []
                    for coach in coachDetails:
                        coach_id = dict(coach)
                        followCnt = Userfollow.objects.filter(followerUser_id=coach_id['id'], status=1).count()
                        coach_id['followers'] = followCnt
                        trainers = trainerProfile.objects.filter(user_id=coach_id['id']).values()
                        
                        for tr in trainers:
                            trainer = dict(tr)
                        if coach_id['userCover'] is not None:
                            coach_id['coachThumbnail'] = coach_id['userCover']
                            coach_id['userCover']= coach_id['userCover']
                        else:
                            coach_id['coachThumbnail'] = ''
                        coach_id['coachId'] = coach['id']
                        coach_id['coachName'] = coach['first_name'] + ' ' + coach['last_name']
                        coachPlansArr = []
                        plans = Plan.objects.filter(createdBy_id=coach_id['id']).values('id')
                        
                        for pl in plans:
                            coachPlans = dict(pl)
                            coachPlansArr.append(coachPlans['id'])
                        coach_id['coachPlans'] = coachPlansArr
                        userAddress = UserAddress.objects.filter(user_id=coach_id['id']).values()
                        if userAddress.exists():
                            for ua in userAddress:
                                uAddr = dict(ua)
                                if uAddr['country'] == 83:
                                    coach_id['coachLocation'] = 'India'
                                else:
                                    coach_id['coachLocation'] = 'International'
                        else:
                            coach_id['coachLocation'] = 'India'
                        coachArr.append(coach_id)
                    '''
                    fitProQuerySet = FitnessProfile.objects.select_related('User__id').filter(user_id=userid).values('gender',
                                                                                                                    'dob',
                                                                                                                    'height',
                                                                                                                    'heightUnit',
                                                                                                                    'weight',
                                                                                                                    'weightUnit',
                                                                                                                    'user_id__id',
                                                                                                                    'user_id__email',
                                                                                                                    'user_id__first_name',
                                                                                                                    'trainingLevel')
                    isProfileSet = False
                    dataGoalObj = {}
                    dataFitObj = {}
                    dataTmaxObj = {}
                    tmaxArr = []
                    isPlanSet = False
                    isTmaxSet = False
                    isFreeTrail = True
                    if fitProQuerySet.exists():
                        isProfileSet = True
                        for dt in fitProQuerySet:
                            dataFitObj = dict(dt)
                            if dataFitObj['dob'] != None:
                                dataFitObj['dob1'] = dataFitObj['dob']
                                dataFitObj['dob'] = dataFitObj['dob'].strftime("%Y/%m/%d")
                    goalDetails = goals.objects.filter(user=userid).values()
                    isGoalSet = False
                    if goalDetails.exists():
                        isGoalSet = True
                        for dt in goalDetails:
                            print(dt)
                            dataGoalObj = dict(dt)
                    tmaxDetails = UserTestPlan.objects.filter(user=userid).values('createdDate', 'exerciseId_id',
                                                                                'exerciseId_id__exerciseName', 'exerciseName',
                                                                                'id', 'plan_id', 'tmax', 'updateTmax',
                                                                                'updateType', 'updatedDate', 'user_id',
                                                                                'userplan_id', 'workWeight',
                                                                                'workoutTestDate')
                    if tmaxDetails.exists():
                        isTmaxSet = True
                        for dt in tmaxDetails:
                            print(dt)
                            dataTmaxObj = dict(dt)
                            tmaxArr.append(dataTmaxObj)
                    PlanDetails = UserPlan.objects.filter(user=userid).filter(status__in=[1, 3]).values()
                    if PlanDetails.exists():
                        isFreeTrail = False
                        isPlanSet = True'''

                    androidversion = AppVersion.objects.get(id=1)
                    iosversion = AppVersion.objects.get(id=2)
                    orgId = User.objects.get(pk=userid)
                    
                    #print(individualuserplan['Id'],"dggggggggggggggggggggggggggggggggggggggggggggggg")
                    individualuserplan['planArr']=planArr
                    individualuserplan['coachArr']=coachArr
                    individualuserplan['totalusercount']=totalusercount
                    individualuserplan['luctype']= userCurrency.currencyType
                    individualuserplan['currencyType']=userCurrency.currencyType
                    individualuserplan['is_active']=username['is_active']
                    
                    individualuserplan['avatar']=username['avatar']
                    individualuserplan['userCover']=username['userCover']
                    COACH[individualuserplan['Id']]=individualuserplan
                    
                    lookuptable_key=individualuserplan['Id']
                    cache.set(lookuptable_key,COACH)
                    
                
                    
                            
                    return JsonResponse({"success": True, "details": individualuserplan['planArr'], "allCoaches":individualuserplan['coachArr'] ,
                                        "totalcount": individualuserplan['totalusercount'], "luctype":individualuserplan['luctype'] ,
                                        

                                        "is_active":individualuserplan['is_active'] , 
                                        "avatar":individualuserplan['avatar']  , 
                                            "currencyType": individualuserplan['currencyType'],
                                        
                                        "coverImage": individualuserplan['userCover'], "generalWarmup": [
                            {"Name": "Hip Circles", "Reps": 5, "ExTime": "Not Applicable", "Direction": "Both",
                            "Equipment": "Not Applicable"},
                            {"Name": "Knee Circles", "Reps": 10, "ExTime": "Not Applicable", "Direction": "Both",
                            "Equipment": "Not Applicable"},
                            {"Name": "Standing lower back release", "Reps": 10, "ExTime": "Not Applicable",
                            "Direction": "Not Applicable", "Equipment": "Not Applicable"},
                            {"Name": "Roll overs", "Reps": 10, "ExTime": "Not Applicable", "Direction": "Not Applicable",
                            "Equipment": "Not Applicable"},
                            {"Name": "Fire Hydrant Circles", "Reps": 10, "ExTime": "Not Applicable",
                            "Direction": "Each leg / Direction", "Equipment": "Not Applicable"},
                            {"Name": "Foam Rolling - Back", "Reps": 8, "ExTime": "Not Applicable",
                            "Direction": "Not Applicable", "Equipment": "Foam Roller"},
                            {"Name": "IT Band", "Reps": 8, "ExTime": "Not Applicable", "Direction": "Each leg",
                            "Equipment": "Foam Roller"},
                            {"Name": "Adductors", "Reps": 8, "ExTime": "Not Applicable", "Direction": "Each leg",
                            "Equipment": "Foam Roller"},
                            {"Name": "Ball Rolling (Cricket / Baseball)", "Reps": 0, "ExTime": "30", "Direction": "Each side",
                            "Equipment": "Cricket / Baseball"},
                            {"Name": "Arm Swings - Over under", "Reps": 10, "ExTime": "Not Applicable",
                            "Direction": "Not Applicable", "Equipment": "Not Applicable"}],
                                        "Cooldown": [{"name": "FLoor Quadraceps Stretch"}, {"name": "Floor Glute Stretch"},
                                                    {"name": "Neck, Back, and Hamstring Stretch"},
                                                    {"name": "Classic Hamstring Stretch"},
                                                    {"name": "Shoulders and Biceps Stretch"}, {"name": "Lower Back Stretch"},
                                                    {"name": "Frog Stretch"}, {"name": "Cat Stretch"},
                                                    {"name": "Triceps and Lat Reach Stretch"}], "exerciseWarmup": {
                            "strength": [{"Sets": 1, "Reps": 10, "intensity": 50}, {"Sets": 1, "Reps": 6, "intensity": 60},
                                        {"Sets": 1, "Reps": 4, "intensity": 70}, {"Sets": 1, "Reps": 3, "intensity": 80},
                                        {"Sets": 1, "Reps": 1, "intensity": 90}],
                            "explosive": [{"Sets": 1, "Reps": 5, "intensity": 50}, {"Sets": 1, "Reps": 5, "intensity": 50},
                                        {"Sets": 1, "Reps": 3, "intensity": 60}, {"Sets": 1, "Reps": 3, "intensity": 60},
                                        {"Sets": 1, "Reps": 3, "intensity": 70}, {"Sets": 1, "Reps": 1, "intensity": 80},
                                        {"Sets": 1, "Reps": 1, "intensity": 90}]}})
            
                else:
                    return JsonResponse({"success": False, "message": "User logged out"})  
            except Exception as e:
                    logger.exception("something wrong")
                    return JsonResponse({"msg": str(e)})        
            

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def individualuserplans(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        coachInfo = json.loads(request.body.decode('utf-8'))
        print(coachInfo)
        if username != None:
            userid = username['id']
            userCurrency = User.objects.get(id=userid)
            currencyValues = PriceConversion.objects.get(id=1)
            inrValue = currencyValues.inrValue
            indianPlanArr = []
            otherPlanArr = []
            india = False
            countryID = UserAddress.objects.select_related('User__id').filter(country=88, user_id=userid).values()
            if countryID.exists():
                for con in countryID:
                    conObj = dict(con)
                    username['userCountry'] = conObj['country']
                india = True
            indianPlans = PlanCountry.objects.filter(country_id=88).values()
            for inp in indianPlans:
                inpObj = dict(inp)
                indianPlanArr.append(inpObj['plan_id'])
            otherPlans = PlanCountry.objects.filter(~Q(country_id=88)).values()
            for otp in otherPlans:
                otpObj = dict(otp)
                otherPlanArr.append(otpObj['plan_id'])
            if india == True:
                if 'coachid' in coachInfo and coachInfo['coachid'] != '':
                    if 'deviceType' in coachInfo and coachInfo['deviceType'] == 'ios':
                        planDetails = Plan.objects.select_related('Goals__id', 'ProgramType__id', 'User__id').values(
                            'id', 'planName', 'planPhoto', 'price', 'planGoal__goalName', 'planDescription',
                            'programType__programTypeName', 'programType__id', 'duration_weeks', 'createdBy_id',
                            'ability', 'createdBy_id__avatar', 'createdBy_id__first_name', 'createdBy_id__last_name',
                            'planStatus', 'planLogo', 'originalPlanner_id', 'licencePolicy', 'iosPrice', 'iosStatus',
                            'indianIosPrice', 'indianPrice', 'createdBy_id__userCover', 'num_of_sessions').filter(
                            createdBy=coachInfo['coachid'], planStatus=1, activationStatus=1, 
                            id__in=indianPlanArr).order_by('programType_id', 'planName')
                    else:
                        planDetails = Plan.objects.select_related('Goals__id', 'ProgramType__id', 'User__id').values(
                            'id', 'planName', 'planPhoto', 'price', 'planGoal__goalName', 'planDescription',
                            'programType__programTypeName', 'programType__id', 'duration_weeks', 'createdBy_id',
                            'ability', 'createdBy_id__avatar', 'createdBy_id__first_name', 'createdBy_id__last_name',
                            'planStatus', 'planLogo', 'originalPlanner_id', 'licencePolicy', 'iosPrice', 'iosStatus',
                            'indianIosPrice', 'indianPrice', 'createdBy_id__userCover', 'num_of_sessions').filter(
                            createdBy=coachInfo['coachid'], planStatus=1, activationStatus=1,
                            id__in=indianPlanArr).order_by('programType_id', 'planName')
                elif 'pname' in coachInfo and coachInfo['pname'] != '':
                    if 'deviceType' in coachInfo and coachInfo['deviceType'] == 'ios':
                        planDetails = Plan.objects.select_related('Goals__id', 'ProgramType__id', 'User__id').values(
                            'id', 'planName', 'planPhoto', 'price', 'planGoal__goalName', 'planDescription',
                            'programType__programTypeName', 'programType__id', 'duration_weeks', 'createdBy_id',
                            'ability', 'createdBy_id__avatar', 'createdBy_id__first_name', 'createdBy_id__last_name',
                            'planStatus', 'planLogo', 'originalPlanner_id', 'licencePolicy', 'iosPrice', 'iosStatus',
                            'indianIosPrice', 'indianPrice', 'createdBy_id__userCover', 'num_of_sessions').filter(
                            planName__icontains=coachInfo['pname'], planStatus=1, activationStatus=1, 
                            id__in=indianPlanArr).order_by('programType_id', 'planName')
                    else:
                        planDetails = Plan.objects.select_related('Goals__id', 'ProgramType__id', 'User__id').values(
                            'id', 'planName', 'planPhoto', 'price', 'planGoal__goalName', 'planDescription',
                            'programType__programTypeName', 'programType__id', 'duration_weeks', 'createdBy_id',
                            'ability', 'createdBy_id__avatar', 'createdBy_id__first_name', 'createdBy_id__last_name',
                            'planStatus', 'planLogo', 'originalPlanner_id', 'licencePolicy', 'iosPrice', 'iosStatus',
                            'indianIosPrice', 'indianPrice', 'createdBy_id__userCover', 'num_of_sessions').filter(
                            planName__icontains=coachInfo['pname'], planStatus=1, activationStatus=1,
                            id__in=indianPlanArr).order_by('programType_id', 'planName')
                elif 'planid' in coachInfo and coachInfo['planid'] != '':
                    getCoachObj = Plan.objects.filter(id=coachInfo['planid']).values()
                    for co in getCoachObj:
                        coachObj = dict(co)
                        print(coachObj)
                        coachID = coachObj['createdBy_id']
                    if 'deviceType' in coachInfo and coachInfo['deviceType'] == 'ios':
                        planDetails = Plan.objects.select_related('Goals__id', 'ProgramType__id', 'User__id').values(
                            'id', 'planName', 'planPhoto', 'price', 'planGoal__goalName', 'planDescription',
                            'programType__programTypeName', 'programType__id', 'duration_weeks', 'createdBy_id',
                            'ability', 'createdBy_id__avatar', 'createdBy_id__first_name', 'createdBy_id__last_name',
                            'planStatus', 'planLogo', 'originalPlanner_id', 'licencePolicy', 'iosPrice', 'iosStatus',
                            'indianIosPrice', 'indianPrice', 'createdBy_id__userCover', 'num_of_sessions').filter(createdBy=coachID,
                                                                                               planStatus=1,
                                                                                               activationStatus=1,
                                                                                               
                                                                                               id__in=indianPlanArr).order_by(
                            'programType_id', 'planName')
                    else:
                        planDetails = Plan.objects.select_related('Goals__id', 'ProgramType__id', 'User__id').values(
                            'id', 'planName', 'planPhoto', 'price', 'planGoal__goalName', 'planDescription',
                            'programType__programTypeName', 'programType__id', 'duration_weeks', 'createdBy_id',
                            'ability', 'createdBy_id__avatar', 'createdBy_id__first_name', 'createdBy_id__last_name',
                            'planStatus', 'planLogo', 'originalPlanner_id', 'licencePolicy', 'iosPrice', 'iosStatus',
                            'indianIosPrice', 'indianPrice', 'createdBy_id__userCover', 'num_of_sessions').filter(createdBy=coachID,
                                                                                               planStatus=1,
                                                                                               activationStatus=1,
                                                                                               id__in=indianPlanArr).order_by(
                            'programType_id', 'planName')
            else:

                if 'coachid' in coachInfo and coachInfo['coachid'] != '':
                    if 'deviceType' in coachInfo and coachInfo['deviceType'] == 'ios':
                        planDetails = Plan.objects.select_related('Goals__id', 'ProgramType__id', 'User__id').values(
                            'id', 'planName', 'planPhoto', 'price', 'planGoal__goalName', 'planDescription',
                            'programType__programTypeName', 'programType__id', 'duration_weeks', 'createdBy_id',
                            'ability', 'createdBy_id__avatar', 'createdBy_id__first_name', 'createdBy_id__last_name',
                            'planStatus', 'planLogo', 'originalPlanner_id', 'licencePolicy', 'iosPrice', 'iosStatus',
                            'indianIosPrice', 'indianPrice', 'createdBy_id__userCover', 'num_of_sessions').filter(
                            createdBy=coachInfo['coachid'], planStatus=1, activationStatus=1, 
                            id__in=otherPlanArr).order_by('programType_id', 'planName')
                    else:
                        planDetails = Plan.objects.select_related('Goals__id', 'ProgramType__id', 'User__id').values(
                            'id', 'planName', 'planPhoto', 'price', 'planGoal__goalName', 'planDescription',
                            'programType__programTypeName', 'programType__id', 'duration_weeks', 'createdBy_id',
                            'ability', 'createdBy_id__avatar', 'createdBy_id__first_name', 'createdBy_id__last_name',
                            'planStatus', 'planLogo', 'originalPlanner_id', 'licencePolicy', 'iosPrice', 'iosStatus',
                            'indianIosPrice', 'indianPrice', 'createdBy_id__userCover', 'num_of_sessions').filter(
                            createdBy=coachInfo['coachid'], planStatus=1, activationStatus=1,
                            id__in=otherPlanArr).order_by('programType_id', 'planName')
                elif 'pname' in coachInfo and coachInfo['pname'] != '':
                    if 'deviceType' in coachInfo and coachInfo['deviceType'] == 'ios':
                        planDetails = Plan.objects.select_related('Goals__id', 'ProgramType__id', 'User__id').values(
                            'id', 'planName', 'planPhoto', 'price', 'planGoal__goalName', 'planDescription',
                            'programType__programTypeName', 'programType__id', 'duration_weeks', 'createdBy_id',
                            'ability', 'createdBy_id__avatar', 'createdBy_id__first_name', 'createdBy_id__last_name',
                            'planStatus', 'planLogo', 'originalPlanner_id', 'licencePolicy', 'iosPrice', 'iosStatus',
                            'indianIosPrice', 'indianPrice', 'createdBy_id__userCover', 'num_of_sessions').filter(
                            planName__icontains=coachInfo['pname'], planStatus=1, activationStatus=1, 
                            id__in=otherPlanArr).order_by('programType_id', 'planName')
                    else:
                        planDetails = Plan.objects.select_related('Goals__id', 'ProgramType__id', 'User__id').values(
                            'id', 'planName', 'planPhoto', 'price', 'planGoal__goalName', 'planDescription',
                            'programType__programTypeName', 'programType__id', 'duration_weeks', 'createdBy_id',
                            'ability', 'createdBy_id__avatar', 'createdBy_id__first_name', 'createdBy_id__last_name',
                            'planStatus', 'planLogo', 'originalPlanner_id', 'licencePolicy', 'iosPrice', 'iosStatus',
                            'indianIosPrice', 'indianPrice', 'createdBy_id__userCover', 'num_of_sessions').filter(
                            planName__icontains=coachInfo['pname'], planStatus=1, activationStatus=1,
                            id__in=otherPlanArr).order_by('programType_id', 'planName')
                elif 'planid' in coachInfo and coachInfo['planid'] != '':
                    getCoachObj = Plan.objects.filter(id=coachInfo['planid']).values()
                    for co in getCoachObj:
                        coachObj = dict(co)
                        print(coachObj)
                        coachID = coachObj['createdBy_id']
                    if 'deviceType' in coachInfo and coachInfo['deviceType'] == 'ios':
                        planDetails = Plan.objects.select_related('Goals__id', 'ProgramType__id', 'User__id').values(
                            'id', 'planName', 'planPhoto', 'price', 'planGoal__goalName', 'planDescription',
                            'programType__programTypeName', 'programType__id', 'duration_weeks', 'createdBy_id',
                            'ability', 'createdBy_id__avatar', 'createdBy_id__first_name', 'createdBy_id__last_name',
                            'planStatus', 'planLogo', 'originalPlanner_id', 'licencePolicy', 'iosPrice', 'iosStatus',
                            'indianIosPrice', 'indianPrice', 'createdBy_id__userCover', 'num_of_sessions').filter(createdBy=coachID,
                                                                                               planStatus=1,
                                                                                               activationStatus=1,
                                                                                               id__in=otherPlanArr).order_by(
                            'programType_id', 'planName')
                    else:
                        planDetails = Plan.objects.select_related('Goals__id', 'ProgramType__id', 'User__id').values(
                            'id', 'planName', 'planPhoto', 'price', 'planGoal__goalName', 'planDescription',
                            'programType__programTypeName', 'programType__id', 'duration_weeks', 'createdBy_id',
                            'ability', 'createdBy_id__avatar', 'createdBy_id__first_name', 'createdBy_id__last_name',
                            'planStatus', 'planLogo', 'originalPlanner_id', 'licencePolicy', 'iosPrice', 'iosStatus',
                            'indianIosPrice', 'indianPrice', 'createdBy_id__userCover', 'num_of_sessions').filter(createdBy=coachID,
                                                                                               planStatus=1,
                                                                                               activationStatus=1,
                                                                                               id__in=otherPlanArr).order_by(
                            'programType_id', 'planName')
            planArr = []
            planValArr = []
            planCoaches = []
            totalusercount = 0
            updetails = UserPlan.objects.filter(user=userid).filter(status__in=[1, 3]).values('status', 'plan_id',
                                                                                              'nextRenewalDate')
            if updetails.exists():
                for dt in updetails:
                    planObj = dict(dt)
                    planObj['nextRenewalDate'] = planObj['nextRenewalDate'].strftime("%Y-%m-%d")
                    planValArr.append(planObj)
            array=[]
            arrays=[]        
            for dt in planDetails:
                dataObj = dict(dt)
                print(dataObj['id'],"dataObj{'id'}")
                array.append(dataObj['id'])
                arrays.append(dataObj['createdBy_id'])
                
                planurls = PlanShortUrls.objects.filter(plan_id=dataObj['id']).values()
                if planurls.exists():
                    for val in planurls:
                        valObj = dict(val)
                        urlVal = valObj['longUrl'].split('/')
                        urlVal1 = urlVal[6].split('=')
                        urlVal2 = urlVal1[1].split('&')
                        dataObj[urlVal2[0]] = valObj['shortUrl']
                secret_code_plain = dataObj['planName'] + '#' + str(dataObj['id'])
                secret_code_encode = base64.b64encode(secret_code_plain.encode('ascii'))
                encodedVal = str(secret_code_encode).split("'")
                dataObj['encodedurl'] = encodedVal[1]

                trainerDetails = trainerProfile.objects.filter(user_id=dataObj['createdBy_id']).values()
                if trainerDetails.exists():
                    for tr in trainerDetails:
                        trObj = dict(tr)
                    dataObj['aboutTrainer'] = trObj['aboutTrainer']
                else:
                    dataObj['aboutTrainer'] = "Trainer Content Unavailable"

                # print(dataObj)

                clelebLikes = celeblikes(dataObj['id'])
                celebReviews = celebreviewList(dataObj['id'])
                dataObj['planlikes'] = clelebLikes
                dataObj['planreviews'] = celebReviews
                # print(dataObj['planreviews'],"here")

                plalikescount = CelebrityPlansLikes.objects.filter(plan_id=dataObj['id'], status=1).count()
                reviewscount = CelebrityPlansLikes.objects.filter(plan_id=dataObj['id']).exclude(
                    reviews__isnull=True).exclude(reviews__exact='').count()
                dataObj['planlikesCount'] = plalikescount
                dataObj['reviewsCount'] = reviewscount

                dataObj['celeblikedPlan'] = 0
                dataObj['celebreviewPlan'] = 0
                dataObj['reviews'] = ''

                # if username['userType'] == 8:
                celebplanlikes = CelebrityPlansLikes.objects.filter(plan_id=dataObj['id'], user_id=username['id'],
                                                                    status=1).values()
                print(celebplanlikes,"Here celebplanlikes")                                                    
                if celebplanlikes.exists():
                    dataObj['celeblikedPlan'] = 1
                celebplanreviews = CelebrityPlansLikes.objects.filter(plan_id=dataObj['id'],
                                                                      user_id=username['id']).values()
                print(celebplanreviews,"celebplanreviews")                                                      
                if celebplanreviews.exists():
                    for celbdt in celebplanreviews:
                        celbObj = dict(celbdt)
                        if celbObj['reviews'] != '' and celbObj['reviews'] != None:
                            dataObj['reviews'] = celbObj['reviews']
                            dataObj['celebreviewPlan'] = 1

                dataObj['coachName'] = dataObj['createdBy_id__first_name'] + " " + dataObj['createdBy_id__last_name']
                dataObj['createdBy_id__first_name'] = dataObj['createdBy_id__first_name'] + " " + dataObj[
                    'createdBy_id__last_name']
                dataObj['planPrice'] = dataObj['price']
                if 'deviceType' in coachInfo and coachInfo['deviceType'] == 'ios':
                    if userCurrency.currencyType == "INR":
                        highestPrice = \
                        Plan.objects.filter(activationStatus=1, planStatus=1).all().aggregate(Max('iosPrice'))[
                            'iosPrice__max']
                        if username['userCountry'] == 88:
                            dataObj['price'] = dataObj['indianIosPrice']
                            dataObj['planPrice'] = dataObj['price']
                        else:
                            dataObj['price'] = dataObj['iosPrice']
                        if int(dataObj['price']) == 0:
                            dataObj['price'] = "Free"
                    else:
                        highestPriceVal = \
                        Plan.objects.filter(activationStatus=1, planStatus=1).all().aggregate(Max('iosPrice'))[
                            'iosPrice__max']
                        highestVal = PriceMapping.objects.get(inr=highestPriceVal)
                        highestPrice = highestVal.usd
                        if username['userCountry'] == 88:
                            usdValue = PriceMapping.objects.values().filter(inr=dataObj['indianIosPrice'])
                        else:
                            usdValue = PriceMapping.objects.values().filter(inr=dataObj['iosPrice'])
                        for usd in usdValue:
                            usdObj = dict(usd)
                            dollarVal = usdObj['usd']
                        dataObj['price'] = dollarVal
                        if int(dataObj['price']) == 0:
                            dataObj['price'] = "Free"
                else:
                    if int(dataObj['price']) == 0:
                        dataObj['price'] = "Free"
                    else:
                        if userCurrency.currencyType == "INR":
                            if username['userCountry'] == 88:
                                dataObj['price'] = round((dataObj['indianPrice']) * float(inrValue))
                                dataObj['planPrice'] = dataObj['price']
                            else:
                                dataObj['price'] = round((dataObj['price']) * float(inrValue))
                                dataObj['planPrice'] = dataObj['price']
                        else:
                            if username['userCountry'] == 88:
                                dataObj['price'] = dataObj['indianPrice']
                                dataObj['planPrice'] = dataObj['price']
                            else:
                                dataObj['price'] = dataObj['price']
                                dataObj['planPrice'] = dataObj['price']
                        if float(dataObj['price']) == 0:
                            dataObj['price'] = "Free"
                planAbilityVal = SelectedAbilities.objects.select_related('PlanAbilities').filter(
                    plan_id=dataObj['id']).values('ability_id__ability')
                abilitieslists = ''
                for val in planAbilityVal:
                    valObj = dict(val)
                    abilitieslists += ", " + valObj['ability_id__ability']
                if abilitieslists != '':
                    planAbilities = abilitieslists[1:]
                else:
                    planAbilities = ""
                planPurposesVal = PlanGoals.objects.select_related('PlanPurposes').filter(plan_id=dataObj['id']).values(
                    'planGoal_id__GoalName')
                purposes = ''
                for val in planPurposesVal:
                    valObj = dict(val)
                    purposes += ", " + valObj['planGoal_id__GoalName']
                if purposes != '':
                    planGoals = purposes[1:]
                else:
                    planGoals = ""
                if dataObj['originalPlanner_id'] != dataObj['createdBy_id']:
                    coachVal = User.objects.get(id=dataObj['originalPlanner_id'])
                    coachName = coachVal.first_name
                    dataObj['oriCoachName'] = coachName
                dataObj['planDescription'] = dataObj['planDescription'] + "<br><br><font><b>Abilities:</b> " + str(
                    planAbilities) + "</font>" + "<br><br><font><b>Purposes:</b> " + str(planGoals) + "</font>"
                if dataObj['licencePolicy'] == "3" or dataObj['licencePolicy'] == "White-Label":
                    partnerName = User.objects.get(id=dataObj['createdBy_id'])
                    dataObj['planDescription'] = str(
                        dataObj['planDescription']) + "<br><h6>Copyright &copy; 2017 " + str(
                        str(partnerName.first_name) + " " + str(partnerName.last_name)) + ". All rights reserved.</h6>"
                else:
                    if dataObj['originalPlanner_id'] != dataObj['createdBy_id']:
                        coachVal = User.objects.get(id=dataObj['originalPlanner_id'])
                        coachName = coachVal.first_name + " " + coachVal.last_name
                        dataObj['oriCoachName'] = coachName
                    coachName = User.objects.get(id=dataObj['originalPlanner_id'])
                    dataObj['planDescription'] = str(
                        dataObj['planDescription']) + "<br><h6>Copyright &copy; 2017 " + str(
                        str(coachName.first_name) + " " + str(coachName.last_name)) + ". All rights reserved.</h6>"
                downloadUsers = UserPlan.objects.filter(plan_id=dataObj['id']).values('user_id').distinct().count()
                ratingObj = PlanRating.objects.filter(plan=dataObj['id']).values()
                totalRate = 0
                userCount = 1
                for rt in ratingObj:
                    rateObj = dict(rt)
                    totalRate = totalRate + rateObj['rating']
                    userCount = userCount + 1
                rating = totalRate / userCount
                planCoaches.append(dataObj['createdBy_id'])
                dataObj['planPurpose'] = planAbilities
                dataObj['plan_goals'] = planGoals
                dataObj['planType'] = dataObj['programType__programTypeName']
                dataObj['planCompetency'] = "0"
                dataObj['planUsers'] = downloadUsers
                totalusercount = totalusercount + int(downloadUsers)
                dataObj['PlanRating'] = rating
                dataObj['coachId'] = dataObj['createdBy_id']
                dataObj['planGoal'] = dataObj['planGoal__goalName']
                dataObj['planLevel'] = dataObj['programType__id']

                if dataObj['planType'] == "STARTER":
                    dataObj['ptype'] = 'S'
                    dataObj['planType'] = "Beginner"
                elif dataObj['planType'] == "INTERMEDIATE":
                    dataObj['planType'] = "Intermediate"
                    dataObj['ptype'] = 'I'
                elif dataObj['planType'] == "ADVANCED":
                    dataObj['planType'] = "Advanced"
                    dataObj['ptype'] = 'A'

                
                dataObj['planDuration'] = dataObj['duration_weeks']
                dataObj['coachId'] = dataObj['createdBy_id']
                exercisesObj = Plan_Actions.objects.select_related('NewExercise').filter(plan_id=dataObj['id']).values('exercise_id', 'exercise_id__exerciseName', 'exercise_id__exerciseDesc', 'exercise_id__equipment').distinct()
                planExs = []
                for ex in exercisesObj:
                    exObj = dict(ex)
                    planExs.append(exObj)
                dataObj['exercises'] = planExs
                """draftedPlans = DraftedPlan.objects.filter(planId_id = dataObj['id'],status = 1).values('planId_id','planJson','protocolJson')
                if draftedPlans.exists():
                    for df in draftedPlans:
                        draftData = dict(df)
                        #dataObj['planJson'] = draftData['planJson']
                        dataObj['planJson'] = json.loads(draftData['planJson'].replace("'", '"'))
                        #dataObj['protocolJson'] = draftData['protocolJson']
                else:
                    dataObj['planJson'] = ''
                    #dataObj['protocolJson'] = '' """
                planArr.append(dataObj)
            #planVideos = PlanVideos.objects.select_related('Videos__id').values('video__videoLink', 'plan_id')
            planVideoArr = []
            '''for video in planVideos:
                videos = dict(video)
                videos['videolink'] = 'QR77PiSkDgA'
                planVideoArr.append(videos)'''
            coachDetails = User.objects.filter(id__in=planCoaches).values()
            coachArr = []
            for coach in coachDetails:
                coach_id = dict(coach)
                followCnt = Userfollow.objects.filter(followerUser_id=coach_id['id'], status=1).count()
                coach_id['followers'] = followCnt
                trainers = trainerProfile.objects.filter(user_id=coach_id['id']).values()
                for tr in trainers:
                    trainer = dict(tr)
                if coach_id['userCover'] is not None:
                    coach_id['coachThumbnail'] = coach_id['userCover']
                else:
                    coach_id['coachThumbnail'] = ''
                coach_id['coachId'] = coach['id']
                coach_id['coachName'] = coach['first_name'] + ' ' + coach['last_name']
                coachPlansArr = []
                plans = Plan.objects.filter(createdBy_id=coach_id['id']).values('id')
                for pl in plans:
                    coachPlans = dict(pl)
                    coachPlansArr.append(coachPlans['id'])
                coach_id['coachPlans'] = coachPlansArr
                userAddress = UserAddress.objects.filter(user_id=coach_id['id']).values()
                if userAddress.exists():
                    for ua in userAddress:
                        uAddr = dict(ua)
                        if uAddr['country'] == 83:
                            coach_id['coachLocation'] = 'India'
                        else:
                            coach_id['coachLocation'] = 'International'
                else:
                    coach_id['coachLocation'] = 'India'
                coachArr.append(coach_id)
            print(coachArr)
            fitProQuerySet = FitnessProfile.objects.select_related('User__id').filter(user_id=userid).values('gender',
                                                                                                             'dob',
                                                                                                             'height',
                                                                                                             'heightUnit',
                                                                                                             'weight',
                                                                                                             'weightUnit',
                                                                                                             'user_id__id',
                                                                                                             'user_id__email',
                                                                                                             'user_id__first_name',
                                                                                                             'trainingLevel')
            isProfileSet = False
            dataGoalObj = {}
            dataFitObj = {}
            dataTmaxObj = {}
            tmaxArr = []
            isPlanSet = False
            isTmaxSet = False
            isFreeTrail = True
            if fitProQuerySet.exists():
                isProfileSet = True
                for dt in fitProQuerySet:
                    dataFitObj = dict(dt)
                    if dataFitObj['dob'] != None:
                        dataFitObj['dob1'] = dataFitObj['dob']
                        dataFitObj['dob'] = dataFitObj['dob'].strftime("%Y/%m/%d")
            goalDetails = goals.objects.filter(user=userid).values()
            isGoalSet = False
            if goalDetails.exists():
                isGoalSet = True
                for dt in goalDetails:
                    print(dt)
                    dataGoalObj = dict(dt)
            tmaxDetails = UserTestPlan.objects.filter(user=userid).values('createdDate', 'exerciseId_id',
                                                                          'exerciseId_id__exerciseName', 'exerciseName',
                                                                          'id', 'plan_id', 'tmax', 'updateTmax',
                                                                          'updateType', 'updatedDate', 'user_id',
                                                                          'userplan_id', 'workWeight',
                                                                          'workoutTestDate')
            if tmaxDetails.exists():
                isTmaxSet = True
                for dt in tmaxDetails:
                    print(dt)
                    dataTmaxObj = dict(dt)
                    tmaxArr.append(dataTmaxObj)
            PlanDetails = UserPlan.objects.filter(user=userid).filter(status__in=[1, 3]).values()
            if PlanDetails.exists():
                isFreeTrail = False
                isPlanSet = True
            androidversion = AppVersion.objects.get(id=1)
            iosversion = AppVersion.objects.get(id=2)
            orgId = User.objects.get(pk=userid)
            return JsonResponse({"success": True, "details": planArr, "Videos": planVideoArr, "allCoaches": coachArr,
                                 "totalcount": totalusercount, "luctype": userCurrency.currencyType,
                                 "userType": userCurrency.userType, "userId": userCurrency.id, "plans": planValArr,
                                 "profile": dataFitObj, "goals": dataGoalObj, "tmax": tmaxArr,
                                 "isProfileSet": isProfileSet, "isGoalSet": isGoalSet, "isPlanSet": isPlanSet,
                                 "isTmaxSet": isTmaxSet, "code": username['sessiontoken'],
                                 "sessiontoken": username['sessiontoken'], "userDetails": username['email'],
                                 "username": username['first_name'], "fname": username['first_name'],
                                 "lname": username['last_name'], "is_superuser": username['is_superuser'],
                                 "is_active": username['is_active'], "user_id": username['id'],
                                 "avatar": username['avatar'], "otp": username['otp'], "isFreeTrail": isFreeTrail,
                                 "phone": username['phone'], "currencyType": username['currencyType'],
                                 "email": username['email'], "phonecode": username['phoneCode'],
                                 "coverImage": username['userCover'], "androidVersion": androidversion.version,
                                 "iosVersion": iosversion.version, "generalWarmup": [
                    {"Name": "Hip Circles", "Reps": 5, "ExTime": "Not Applicable", "Direction": "Both",
                     "Equipment": "Not Applicable"},
                    {"Name": "Knee Circles", "Reps": 10, "ExTime": "Not Applicable", "Direction": "Both",
                     "Equipment": "Not Applicable"},
                    {"Name": "Standing lower back release", "Reps": 10, "ExTime": "Not Applicable",
                     "Direction": "Not Applicable", "Equipment": "Not Applicable"},
                    {"Name": "Roll overs", "Reps": 10, "ExTime": "Not Applicable", "Direction": "Not Applicable",
                     "Equipment": "Not Applicable"},
                    {"Name": "Fire Hydrant Circles", "Reps": 10, "ExTime": "Not Applicable",
                     "Direction": "Each leg / Direction", "Equipment": "Not Applicable"},
                    {"Name": "Foam Rolling - Back", "Reps": 8, "ExTime": "Not Applicable",
                     "Direction": "Not Applicable", "Equipment": "Foam Roller"},
                    {"Name": "IT Band", "Reps": 8, "ExTime": "Not Applicable", "Direction": "Each leg",
                     "Equipment": "Foam Roller"},
                    {"Name": "Adductors", "Reps": 8, "ExTime": "Not Applicable", "Direction": "Each leg",
                     "Equipment": "Foam Roller"},
                    {"Name": "Ball Rolling (Cricket / Baseball)", "Reps": 0, "ExTime": "30", "Direction": "Each side",
                     "Equipment": "Cricket / Baseball"},
                    {"Name": "Arm Swings - Over under", "Reps": 10, "ExTime": "Not Applicable",
                     "Direction": "Not Applicable", "Equipment": "Not Applicable"}],
                                 "Cooldown": [{"name": "FLoor Quadraceps Stretch"}, {"name": "Floor Glute Stretch"},
                                              {"name": "Neck, Back, and Hamstring Stretch"},
                                              {"name": "Classic Hamstring Stretch"},
                                              {"name": "Shoulders and Biceps Stretch"}, {"name": "Lower Back Stretch"},
                                              {"name": "Frog Stretch"}, {"name": "Cat Stretch"},
                                              {"name": "Triceps and Lat Reach Stretch"}], "exerciseWarmup": {
                    "strength": [{"Sets": 1, "Reps": 10, "intensity": 50}, {"Sets": 1, "Reps": 6, "intensity": 60},
                                 {"Sets": 1, "Reps": 4, "intensity": 70}, {"Sets": 1, "Reps": 3, "intensity": 80},
                                 {"Sets": 1, "Reps": 1, "intensity": 90}],
                    "explosive": [{"Sets": 1, "Reps": 5, "intensity": 50}, {"Sets": 1, "Reps": 5, "intensity": 50},
                                  {"Sets": 1, "Reps": 3, "intensity": 60}, {"Sets": 1, "Reps": 3, "intensity": 60},
                                  {"Sets": 1, "Reps": 3, "intensity": 70}, {"Sets": 1, "Reps": 1, "intensity": 80},
                                  {"Sets": 1, "Reps": 1, "intensity": 90}]}})
        else:
            return JsonResponse({"success": False, "message": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})



@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def viewPlan(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        planInfo = json.loads(request.body.decode('utf-8'))
        if username != None:
            planDetails = Plan.objects.values().filter(id=planInfo['plan_id'])
            dataPeriodArr = []
            dataMesoArr = []
            dataMicroArr = []
            dataSessArr = []
            dataExArr = []
            dataSetArr = []
            exercisesList = []
            dataPlanDict = {}
            count = 0
            for dt in planDetails:
                dataPlanObj = dict(dt)
                planAbilityVal = SelectedAbilities.objects.select_related('PlanAbilities').filter(plan_id=dataPlanObj['id']).values('ability_id__ability')
                abilitieslists = ''
                for val in planAbilityVal:
                    valObj = dict(val)
                    abilitieslists += ", " + valObj['ability_id__ability']
                if abilitieslists != '':
                    planAbilities = abilitieslists[1:]
                else:
                    planAbilities = ""
                planPurposesVal = PlanGoals.objects.select_related('PlanPurposes').filter(plan_id=dataPlanObj['id']).values(
                    'planGoal_id__GoalName')
                purposes = ''
                for val in planPurposesVal:
                    valObj = dict(val)
                    purposes += ", " + valObj['planGoal_id__GoalName']
                if purposes != '':
                    planGoals = purposes[1:]
                else:
                    planGoals = ""
                dataPlanObj['goals'] = planGoals
                dataPlanObj['ability'] = planAbilities
                periodCount = -1
                # dataPlanObj['plan_name'] = "plan"+str(count+1)
                periodDetails = Plan_Period.objects.filter(plan_id=dataPlanObj['id']).values('plan_id',
                                                                                             'num_of_mesocycles',
                                                                                             'duration_weeks', 'id',
                                                                                             'periodName')
                for dt1 in periodDetails:
                    mesoCount = -1
                    dataPeriodObj = dict(dt1)
                    count = count + 1
                    periodCount = periodCount + 1
                    dataPeriodObj['path'] = str(periodCount)
                    # dataPeriodObj['period_name'] = "Period"+str(count+1)
                    mesocycleDetails = Plan_Mesocycle.objects.filter(period_id=dataPeriodObj['id']).values(
                        'num_of_microcycles', 'duration_weeks', 'id', 'period_id')
                    for dt2 in mesocycleDetails:
                        microCount = -1
                        dataMesoObj = dict(dt2)
                        count = count + 1
                        mesoCount = mesoCount + 1
                        dataMesoObj['meso_name'] = "MesoCycle" + str(mesoCount + 1)
                        dataMesoObj['path'] = str(periodCount) + "-" + str(mesoCount)
                        microcycleDetails = Plan_Microcycles.objects.filter(mesocycle_id=dataMesoObj['id']).values(
                            'no_of_sessions', 'totalInol', 'id', 'mesocycle_id', 'dayOff')
                        for dt3 in microcycleDetails:
                            sessionCount = -1
                            dataMicroObj = dict(dt3)
                            count = count + 1
                            microCount = microCount + 1
                            dataMicroObj['path'] = str(periodCount) + "-" + str(mesoCount) + "-" + str(microCount)
                            dataMicroObj['micro_name'] = "MicroCycle" + str(microCount + 1)
                            sessionDetails = Plan_Sessions.objects.filter(microcycle_id=dataMicroObj['id']).values(
                                'no_of_excersices', 'totalInol', 'id', 'microcycle_id', 'restTime', 'repeat')
                            for dt4 in sessionDetails:
                                excersiceCount = -1
                                dataSessObj = dict(dt4)
                                count = count + 1
                                sessionCount = sessionCount + 1
                                dataSessObj['path'] = str(periodCount) + "-" + str(mesoCount) + "-" + str(
                                    microCount) + "-" + str(sessionCount)
                                dataSessObj['sess_name'] = "Session" + str(sessionCount + 1)
                                excersiceDetails = NewExcercise.objects.select_related('Exercise__id').filter(
                                    session_id=dataSessObj['id']).values('exerciseName__exerciseName', 'num_of_sets',
                                                                         'totalInol', 'id', 'session_id', 'restTime',
                                                                         'intensity', 'exerciseName_id',
                                                                         'transitExercise_id', 'transitLevel',
                                                                         'advExercise')
                                for dt5 in excersiceDetails:
                                    setCount = -1
                                    dataExObj = dict(dt5)
                                    count = count + 1
                                    exercisesList.append(dataExObj['exerciseName_id'])
                                    if dataExObj['transitExercise_id'] is not None and dataExObj[
                                        'transitExercise_id'] != '' and dataExObj['transitExercise_id'] != 'NULL':
                                        exercisesList.append(dataExObj['transitExercise_id'])
                                    excersiceCount = excersiceCount + 1
                                    dataExObj['path'] = str(periodCount) + "-" + str(mesoCount) + "-" + str(
                                        microCount) + "-" + str(sessionCount) + "-" + str(excersiceCount)
                                    dataExObj['Ex_name'] = dataExObj['exerciseName__exerciseName']
                                    setDetails = PlanSets.objects.filter(excercise_id=dataExObj['id']).values(
                                        'num_of_reps', 'totalInol', 'id', 'excercise', 'restTime', 'advExercise')
                                    for dt6 in setDetails:
                                        dataObj = dict(dt6)
                                        count = count + 1
                                        setCount = setCount + 1
                                        dataObj['path'] = str(periodCount) + "-" + str(mesoCount) + "-" + str(
                                            microCount) + "-" + str(sessionCount) + "-" + str(
                                            excersiceCount) + "-" + str(setCount)
                                        dataObj['set_name'] = "set" + str(setCount + 1)
                                        dataSetArr.append(dataObj)
                                    dataExDict = {"ExerciseInfo": dataExObj, "setDetails": dataSetArr}
                                    dataExArr.append(dataExDict)
                                    dataSetArr = []
                                dataSessDict = {"SessionInfo": dataSessObj, "exerciseDetails": dataExArr}
                                dataSessArr.append(dataSessDict)
                                dataExArr = []
                            dataMicroDict = {"MicrocycleInfo": dataMicroObj, "SessionDetails": dataSessArr}
                            dataMicroArr.append(dataMicroDict)
                            dataSessArr = []
                        dataMesoDict = {"MesocycleInfo": dataMesoObj, "MicrocycleDetails": dataMicroArr}
                        dataMesoArr.append(dataMesoDict)
                        dataMicroArr = []
                    dataPeriodDict = {"PeriodInfo": dataPeriodObj, "MesocycleDetails": dataMesoArr}
                    dataPeriodArr.append(dataPeriodDict)
                    dataMesoArr = []
                allExecDetails = NewExercise.objects.filter(id__in=exercisesList).values()
                PlanExercises = []
                for dt7 in allExecDetails:
                    dataExObj = dict(dt7)
                    PlanExercises.append(dataExObj)
                dataPlanDict = {"PlanInfo": dataPlanObj, "Exercises": PlanExercises, "PeriodDetails": dataPeriodArr}
            # print(dataPlanDict)
            return JsonResponse({"plan": dataPlanDict})
        else:
            return JsonResponse({"success": False, "message": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})

def getPlanArr(request, planID):
    planDetails = Plan.objects.values('num_of_periods', 'duration_weeks', 'id', 'planName').filter(id=planID)
    dataPeriodArr = []
    dataMesoArr = []
    dataMicroArr = []
    dataSessArr = []
    dataExArr = []
    dataSetArr = []
    exercisesList = []
    lastMesoSess = {}
    lastMicroSess = {}
    dataPlanDict = {}
    dataSessObj = None
    count = 0
    for dt in planDetails:
        dataPlanObj = dict(dt)
        periodCount = -1
        # dataPlanObj['plan_name'] = "plan"+str(count+1)
        periodDetails = Plan_Period.objects.filter(plan_id=dataPlanObj['id']).values('plan_id', 'num_of_mesocycles',
                                                                                     'duration_weeks', 'id',
                                                                                     'periodName')
        for dt1 in periodDetails:
            mesoCount = -1
            dataPeriodObj = dict(dt1)
            count = count + 1
            periodCount = periodCount + 1
            dataPeriodObj['path'] = str(periodCount)
            # dataPeriodObj['period_name'] = "Period"+str(count+1)
            mesocycleDetails = Plan_Mesocycle.objects.filter(period_id=dataPeriodObj['id']).values('num_of_microcycles',
                                                                                                  'duration_weeks',
                                                                                                  'id', 'period_id')
            for dt2 in mesocycleDetails:
                microCount = -1
                dataMesoObj = dict(dt2)
                count = count + 1
                mesoCount = mesoCount + 1
                dataMesoObj['meso_name'] = "MesoCycle" + str(mesoCount + 1)
                dataMesoObj['path'] = str(periodCount) + "-" + str(mesoCount)
                if dataSessObj is not None:
                    lastMesoSess[dataSessObj['id']] = dataSessObj
                microcycleDetails = Plan_Microcycles.objects.filter(mesocycle_id=dataMesoObj['id']).values('no_of_sessions',
                                                                                                     'totalInol', 'id',
                                                                                                     'mesocycle_id',
                                                                                                     'dayOff')
                for dt3 in microcycleDetails:
                    sessionCount = -1
                    dataMicroObj = dict(dt3)
                    count = count + 1
                    microCount = microCount + 1
                    dataMicroObj['path'] = str(periodCount) + "-" + str(mesoCount) + "-" + str(microCount)
                    dataMicroObj['micro_name'] = "MicroCycle" + str(microCount + 1)
                    if dataSessObj is not None:
                        lastMicroSess[dataSessObj['id']] = dataSessObj
                    sessionDetails = Plan_Sessions.objects.filter(microcycle_id=dataMicroObj['id']).values(
                        'no_of_excersices', 'totalInol', 'id', 'microcycle_id', 'restTime', 'repeat')
                    for dt4 in sessionDetails:
                        excersiceCount = -1
                        dataSessObj = dict(dt4)
                        count = count + 1
                        sessionCount = sessionCount + 1
                        dataSessObj['path'] = str(periodCount) + "-" + str(mesoCount) + "-" + str(
                            microCount) + "-" + str(sessionCount)
                        dataSessObj['sess_name'] = "Session" + str(sessionCount + 1)
                        excersiceDetails = PlanExcercise.objects.select_related('Exercise__id').filter(
                            session_id=dataSessObj['id']).values('exerciseName__exerciseName', 'num_of_sets',
                                                                 'totalInol', 'id', 'session_id', 'restTime',
                                                                 'intensity', 'exerciseName_id', 'transitExercise_id',
                                                                 'transitLevel')
                        for dt5 in excersiceDetails:
                            setCount = -1
                            dataExObj = dict(dt5)
                            count = count + 1
                            exercisesList.append(dataExObj['exerciseName_id'])
                            if dataExObj['transitExercise_id'] is not None and dataExObj['transitExercise_id'] != '' and \
                                    dataExObj['transitExercise_id'] != 'NULL':
                                exercisesList.append(dataExObj['transitExercise_id'])
                            excersiceCount = excersiceCount + 1
                            dataExObj['path'] = str(periodCount) + "-" + str(mesoCount) + "-" + str(
                                microCount) + "-" + str(sessionCount) + "-" + str(excersiceCount)
                            dataExObj['Ex_name'] = dataExObj['exerciseName__exerciseName']
                            setDetails = PlanSets.objects.filter(excercise_id=dataExObj['id']).values('num_of_reps',
                                                                                                      'totalInol', 'id',
                                                                                                      'excercise',
                                                                                                      'restTime')
                            for dt6 in setDetails:
                                dataObj = dict(dt6)
                                count = count + 1
                                setCount = setCount + 1
                                dataObj['path'] = str(periodCount) + "-" + str(mesoCount) + "-" + str(
                                    microCount) + "-" + str(sessionCount) + "-" + str(excersiceCount) + "-" + str(
                                    setCount)
                                dataObj['set_name'] = "set" + str(setCount + 1)
                                dataSetArr.append(dataObj)
                            dataExDict = {"ExerciseInfo": dataExObj, "setDetails": dataSetArr}
                            dataExArr.append(dataExDict)
                            dataSetArr = []
                        dataSessDict = {"SessionInfo": dataSessObj, "exerciseDetails": dataExArr}
                        dataSessArr.append(dataSessDict)
                        dataExArr = []
                    dataMicroDict = {"MicrocycleInfo": dataMicroObj, "SessionDetails": dataSessArr}
                    dataMicroArr.append(dataMicroDict)
                    dataSessArr = []
                dataMesoDict = {"MesocycleInfo": dataMesoObj, "MicrocycleDetails": dataMicroArr}
                dataMesoArr.append(dataMesoDict)
                dataMicroArr = []
            dataPeriodDict = {"PeriodInfo": dataPeriodObj, "MesocycleDetails": dataMesoArr}
            dataPeriodArr.append(dataPeriodDict)
            dataMesoArr = []
        allExecDetails = NewExercise.objects.filter(id__in=exercisesList).values('exerciseStatus', 'exerciseName', 'id',
                                                                              'equipment', 'derivedFormula',
                                                                              'workFormula', 'derivedFrom',
                                                                              'exerciseDesc', 
                                                                              'video_id__videoLink')
        PlanExercises = []
        lastMesoSess[dataSessObj['id']] = dataSessObj
        lastMicroSess[dataSessObj['id']] = dataSessObj
        for dt7 in allExecDetails:
            dataExObj = dict(dt7)
            PlanExercises.append(dataExObj)
        dataPlanDict = {"lastMeso": lastMesoSess, "lastMicro": lastMicroSess}
    # print(dataPlanDict)
    return dataPlanDict


@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def createJson(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        userID = username['id']
        # planInfo = json.loads(request.body.decode('utf-8'))
        PlanDetails = UserPlan.objects.filter(user=userID).filter(status=1).values()
        if PlanDetails.exists():
            for dt in PlanDetails:
                planInfo = dict(dt)
            if username != None:
                planDetails = Plan.objects.values('num_of_periods', 'duration_weeks', 'id', 'planName', 'planPhoto',
                                                  'planLogo').filter(id=planInfo['plan_id'])
                dataPeriodArr = []
                dataMesoArr = []
                dataMicroArr = []
                dataSessArr = []
                dataExArr = []
                dataSetArr = []
                exercisesList = []
                dataPlanDict = {}
                count = 0
                lastSetIDs = lastSetIds(request, planInfo['plan_id'])
                print(lastSetIDs)
                protocolDetails = Plan_Actions.objects.filter(plan_id=planInfo['plan_id']).values('plan_id',
                                                                                                  'protocol_id',
                                                                                                  'values',
                                                                                                  'exercise_id')
                protocolJSON = []
                sessionCount = -1
                if protocolDetails.exists():
                    for dt12 in protocolDetails:
                        dataObj = dict(dt12)
                        dataObj["values"] = json.loads(dataObj["values"].replace("'", '"'))
                        protocolJSON.append(dataObj)
                for dt in planDetails:
                    dataPlanObj = dict(dt)
                    
                    dataPlanObj['genWarmupVideo'] = 'ztxEOSIcMc4'
                    dataPlanObj['cooldownVideo'] = '2esZzqjO5Cc'
                    periodCount = -1
                    # dataPlanObj['plan_name'] = "plan"+str(count+1)
                    periodDetails = Plan_Period.objects.filter(plan_id=dataPlanObj['id']).values('plan_id',
                                                                                                 'num_of_mesocycles',
                                                                                                 'duration_weeks', 'id',
                                                                                                 'periodName').order_by(
                        'id')

                    for dt1 in periodDetails:
                        mesoCount = -1
                        dataPeriodObj = dict(dt1)
                        count = count + 1
                        periodCount = periodCount + 1
                        dataPeriodObj['path'] = str(periodCount)
                        # dataPeriodObj['period_name'] = "Period"+str(count+1)
                        mesocycleDetails = Plan_Mesocycle.objects.filter(period_id=dataPeriodObj['id']).values(
                            'num_of_microcycles', 'duration_weeks', 'id', 'period_id').order_by('id')
                        for dt2 in mesocycleDetails:
                            microCount = -1
                            dataMesoObj = dict(dt2)
                            count = count + 1
                            mesoCount = mesoCount + 1
                            dataMesoObj['meso_name'] = "MesoCycle" + str(mesoCount + 1)
                            dataMesoObj['path'] = str(periodCount) + "-" + str(mesoCount)
                            microcycleDetails = Plan_Microcycles.objects.filter(mesocycle_id=dataMesoObj['id']).values(
                                'no_of_sessions', 'totalInol', 'id', 'mesocycle_id', 'dayOff').order_by('id')
                            for dt3 in microcycleDetails:

                                dataMicroObj = dict(dt3)
                                count = count + 1
                                microCount = microCount + 1
                                dataMicroObj['path'] = str(periodCount) + "-" + str(mesoCount) + "-" + str(microCount)
                                dataMicroObj['micro_name'] = "MicroCycle" + str(microCount + 1)
                                sessionDetails = Plan_Sessions.objects.filter(microcycle_id=dataMicroObj['id']).values(
                                    'no_of_excersices', 'totalInol', 'id', 'microcycle_id', 'restTime',
                                    'repeat').order_by('id')
                                for dt4 in sessionDetails:
                                    excersiceCount = -1
                                    dataSessObj = dict(dt4)
                                    count = count + 1
                                    sessionCount = sessionCount + 1
                                    dataSessObj['path'] = str(periodCount) + "-" + str(mesoCount) + "-" + str(
                                        microCount) + "-" + str(sessionCount)
                                    dataSessObj['sess_name'] = "Session " + str(sessionCount + 1)
                                    excersiceDetails = PlanExcercise.objects.select_related('Exercise__id').filter(
                                        session_id=dataSessObj['id']).values('exerciseName__exerciseName',
                                                                             'num_of_sets', 'totalInol', 'id',
                                                                             'session_id', 'restTime', 'intensity',
                                                                             'intensityRange', 'exerciseName_id',
                                                                             'transitExercise_id', 'transitLevel',
                                                                             'warmup', 'warmupType').order_by('id')
                                    for dt5 in excersiceDetails:
                                        setCount = -1
                                        dataExObj = dict(dt5)
                                        count = count + 1
                                        exercisesList.append(dataExObj['exerciseName_id'])
                                        if dataExObj['transitExercise_id'] is not None and dataExObj[
                                            'transitExercise_id'] != '' and dataExObj['transitExercise_id'] != 'NULL':
                                            exercisesList.append(dataExObj['transitExercise_id'])
                                        excersiceCount = excersiceCount + 1
                                        dataExObj['path'] = str(periodCount) + "-" + str(mesoCount) + "-" + str(
                                            microCount) + "-" + str(sessionCount) + "-" + str(excersiceCount)
                                        dataExObj['Ex_name'] = dataExObj['exerciseName__exerciseName']
                                        setDetails = PlanSets.objects.filter(excercise_id=dataExObj['id']).values(
                                            'num_of_reps', 'repsRange', 'repsRangeAbs', 'totalInol', 'id', 'excercise',
                                            'restTime', 'allOutStat').order_by('id')
                                        for dt6 in setDetails:
                                            dataObj = dict(dt6)
                                            count = count + 1
                                            setCount = setCount + 1
                                            dataObj['path'] = str(periodCount) + "-" + str(mesoCount) + "-" + str(
                                                microCount) + "-" + str(sessionCount) + "-" + str(
                                                excersiceCount) + "-" + str(setCount)
                                            dataObj['set_name'] = "set" + str(setCount + 1)
                                            if dataObj['id'] in lastSetIDs['macroSets']:
                                                dataObj['allout'] = True
                                                dataObj['3'] = 1
                                                dataObj['desigProtocolID'] = 0
                                            elif dataObj['id'] in lastSetIDs['microSets']:
                                                dataObj['allout'] = True
                                                dataObj['4'] = 1
                                                dataObj['desigProtocolID'] = 0
                                            else:
                                                dataObj['allout'] = False
                                                dataObj['desigProtocolID'] = 0
                                            setProtocol = Plan_Actions.objects.filter(
                                                plan_id=planInfo['plan_id']).filter(protocol_id__in=[8]).values()
                                            if dataObj['allOutStat'] == 1:
                                                dataObj['allout'] = True
                                            if setProtocol.exists():
                                                for dt in setProtocol:
                                                    datasetObj = dict(dt)
                                                    print(datasetObj)
                                                    setProtocolID = datasetObj['protocol_id']
                                                dataObj['protoccolID'] = setProtocolID
                                            dataSetArr.append(dataObj)
                                        exerProtocol = Plan_Actions.objects.filter(plan_id=planInfo['plan_id']).filter(
                                            protocol_id__in=[9]).values()
                                        exerProtocolJSON = {}
                                        if exerProtocol.exists():
                                            for dt in exerProtocol:
                                                protoExerObj = dict(dt)
                                                exerProtocolID = protoExerObj['protocol_id']
                                            exerProtocolJSON = {"protoccolID": exerProtocolID}
                                            dataExObj['protoccolID'] = exerProtocolID
                                        dataExDict = {"ExerciseInfo": dataExObj, "protocol": exerProtocolJSON,
                                                      "setDetails": dataSetArr}
                                        dataExArr.append(dataExDict)
                                        dataSetArr = []
                                    sessProtocol = Plan_Actions.objects.filter(plan_id=planInfo['plan_id']).filter(
                                        protocol_id__in=[6]).values()
                                    sessProtocolJSON = {}
                                    if sessProtocol.exists():
                                        for dt in sessProtocol:
                                            protosessObj = dict(dt)
                                            sessProtocolID = protosessObj['protocol_id']
                                        sessProtocolJSON = {"protoccolID": sessProtocolID}
                                        dataSessObj['protoccolID'] = sessProtocolID
                                    dataSessDict = {"SessionInfo": dataSessObj, "protocol": sessProtocolJSON,
                                                    "exerciseDetails": dataExArr}
                                    dataSessArr.append(dataSessDict)
                                    dataExArr = []
                                microProtocol = Plan_Actions.objects.filter(plan_id=planInfo['plan_id']).filter(
                                    protocol_id__in=[2, 4]).values()
                                microProtocolJSON = {}
                                if microProtocol.exists():
                                    for dt in microProtocol:
                                        protoMicroObj = dict(dt)
                                        microProtocolID = protoMicroObj['protocol_id']
                                    microProtocolJSON = {"protoccolID": microProtocolID}
                                    dataMicroObj['protoccolID'] = microProtocolID
                                dataMicroDict = {"MicrocycleInfo": dataMicroObj, "protocol": microProtocolJSON,
                                                 "SessionDetails": dataSessArr}
                                dataMicroArr.append(dataMicroDict)
                                dataSessArr = []
                            mesoProtocol = Plan_Actions.objects.filter(plan_id=planInfo['plan_id']).filter(
                                protocol_id__in=[1, 3]).values()
                            mesoProtocolJSON = {}
                            if mesoProtocol.exists():
                                for dt in mesoProtocol:
                                    protoMesoObj = dict(dt)
                                    mesoProtocolID = protoMesoObj['protocol_id']
                                mesoProtocolJSON = {"protoccolID": mesoProtocolID}
                                dataMesoObj['protoccolID'] = mesoProtocolID
                            dataMesoDict = {"MesocycleInfo": dataMesoObj, "protocol": mesoProtocolJSON,
                                            "MicrocycleDetails": dataMicroArr}
                            dataMesoArr.append(dataMesoDict)
                            dataMicroArr = []
                        dataPeriodDict = {"PeriodInfo": dataPeriodObj, "MesocycleDetails": dataMesoArr}
                        dataPeriodArr.append(dataPeriodDict)
                        dataMesoArr = []
                    allExecDetails = NewExercise.objects.filter(id__in=exercisesList).values()
                    PlanExercises = []
                    for dt7 in allExecDetails:
                        dataExObj = dict(dt7)
                        PlanExercises.append(dataExObj)
                    dataPlanDict = {"PlanInfo": dataPlanObj, "Exercises": PlanExercises, "Protocols": protocolJSON,
                                    "PeriodDetails": dataPeriodArr, "generalWarmup": [
                            {"Name": "Hip Circles", "Reps": 5, "ExTime": "Not Applicable", "Direction": "Both",
                             "Equipment": "Not Applicable"},
                            {"Name": "Knee Circles", "Reps": 10, "ExTime": "Not Applicable", "Direction": "Both",
                             "Equipment": "Not Applicable"},
                            {"Name": "Standing lower back release", "Reps": 10, "ExTime": "Not Applicable",
                             "Direction": "Not Applicable", "Equipment": "Not Applicable"},
                            {"Name": "Roll overs", "Reps": 10, "ExTime": "Not Applicable",
                             "Direction": "Not Applicable", "Equipment": "Not Applicable"},
                            {"Name": "Fire Hydrant Circles", "Reps": 10, "ExTime": "Not Applicable",
                             "Direction": "Each leg / Direction", "Equipment": "Not Applicable"},
                            {"Name": "Foam Rolling - Back", "Reps": 8, "ExTime": "Not Applicable",
                             "Direction": "Not Applicable", "Equipment": "Foam Roller"},
                            {"Name": "IT Band", "Reps": 8, "ExTime": "Not Applicable", "Direction": "Each leg",
                             "Equipment": "Foam Roller"},
                            {"Name": "Adductors", "Reps": 8, "ExTime": "Not Applicable", "Direction": "Each leg",
                             "Equipment": "Foam Roller"},
                            {"Name": "Ball Rolling (Cricket / Baseball)", "Reps": 0, "ExTime": "30",
                             "Direction": "Each side", "Equipment": "Cricket / Baseball"},
                            {"Name": "Arm Swings - Over under", "Reps": 10, "ExTime": "Not Applicable",
                             "Direction": "Not Applicable", "Equipment": "Not Applicable"}],
                                    "Cooldown": [{"name": "FLoor Quadraceps Stretch"}, {"name": "Floor Glute Stretch"},
                                                 {"name": "Neck, Back, and Hamstring Stretch"},
                                                 {"name": "Classic Hamstring Stretch"},
                                                 {"name": "Shoulders and Biceps Stretch"},
                                                 {"name": "Lower Back Stretch"}, {"name": "Frog Stretch"},
                                                 {"name": "Cat Stretch"}, {"name": "Triceps and Lat Reach Stretch"}],
                                    "exerciseWarmup": {"strength": [{"Sets": 1, "Reps": 10, "intensity": 50},
                                                                    {"Sets": 1, "Reps": 6, "intensity": 60},
                                                                    {"Sets": 1, "Reps": 4, "intensity": 70},
                                                                    {"Sets": 1, "Reps": 3, "intensity": 80},
                                                                    {"Sets": 1, "Reps": 1, "intensity": 90}],
                                                       "explosive": [{"Sets": 1, "Reps": 5, "intensity": 50},
                                                                     {"Sets": 1, "Reps": 5, "intensity": 50},
                                                                     {"Sets": 1, "Reps": 3, "intensity": 60},
                                                                     {"Sets": 1, "Reps": 3, "intensity": 60},
                                                                     {"Sets": 1, "Reps": 3, "intensity": 70},
                                                                     {"Sets": 1, "Reps": 1, "intensity": 80},
                                                                     {"Sets": 1, "Reps": 1, "intensity": 90}]}}
                # print(dataPlanDict)
                return JsonResponse({"plan": dataPlanDict})
            else:
                return JsonResponse({"success": False, "message": "No Plan Subscribed"})
        else:
            return JsonResponse({"success": False, "message": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})

def lastSetIds(request, planID):
    macroSets = {}
    microSets = {}
    protocolDetails = Plan_Actions.objects.filter(plan_id=planID, protocol_id__in=[3, 4, 5]).values('plan_id',
                                                                                                    'protocol_id',
                                                                                                    'values',
                                                                                                    'exercise_id')
    protocolJSON = []
    if protocolDetails.exists():
        PlanArray = getPlanArr(request, planID)
        print(PlanArray)
        # return JsonResponse(PlanArray)
        for dt in protocolDetails:
            dataObj = dict(dt)
            exerciseID = dataObj['exercise_id']
            protocolID = dataObj['protocol_id']
            print(exerciseID)
            if protocolID == 3 or protocolID == 5:
                for sessObj in PlanArray['lastMeso']:
                    print(sessObj)
                    lastExerDetails = PlanExcercise.objects.filter(exerciseName_id=int(exerciseID),
                                                                   session_id=sessObj).values().last()
                    print(lastExerDetails)
                    if lastExerDetails is not None:
                        lastSetDetails = PlanSets.objects.filter(excercise_id=lastExerDetails['id']).values().last()
                        if lastSetDetails is not None:
                            macroSets[lastSetDetails['id']] = 1
            if protocolID == 4:
                for sessObj in PlanArray['lastMicro']:
                    print(sessObj)
                    lastExerDetails = PlanExcercise.objects.filter(exerciseName_id=int(exerciseID),
                                                                   session_id=sessObj).values().last()
                    print(lastExerDetails)
                    if lastExerDetails is not None:
                        lastSetDetails = PlanSets.objects.filter(excercise_id=lastExerDetails['id']).values().last()
                        print(lastSetDetails)
                        if lastSetDetails is not None:
                            microSets[lastSetDetails['id']] = 1
    return {"macroSets": macroSets, "microSets": microSets}

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def createPlanRating(request):
    # user = request.session['user_id']
    # print(user)
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        user = username['id']
        if username != None:
            planInfo = json.loads(request.body.decode('utf-8'))
            if 'get_rating' in planInfo and planInfo['get_rating'] == 1:
                print('------------1')
                planrate = PlanRating.objects.filter(user_id=planInfo['user_id'], plan_id=planInfo['plan_id']).values()
                if planrate.exists():
                    for dt in planrate:
                        rateObj = dict(dt)
                    return JsonResponse({"success": True, "rating": rateObj['rating']})
                else:
                    return JsonResponse({"success": True, "rating": 0})
            else:
                planDetails = PlanRating.objects.filter(user_id=planInfo['user_id'], plan_id=planInfo['plan_id'])
                if planDetails.exists():
                    plan = PlanRating.objects.get(user_id=planInfo['user_id'], plan_id=planInfo['plan_id'])
                    print(type(planInfo['rating'])) 
                    if type(planInfo['rating']) != int:  
                        return JsonResponse({"success":False,"message":"Please provide valid rating"})
                    else:
                        rating=planInfo['rating']   
                    plan.plan_id = planInfo['plan_id']
                    plan.user_id = planInfo['user_id']
                    plan.rating=rating
                    plan.save()
                    return JsonResponse({"success": True, "message": "Thanks for the rating"})
                else:
                    rating = PlanRating.objects.create(
                        plan_id=planInfo['plan_id'],
                        user_id=planInfo['user_id'],
                        rating=planInfo['rating']
                    )
                    rating.save()
                    return JsonResponse({"success": True, "message": "Thanks for the rating"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})
@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def deletePlanRating(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        user = username['id']
        if username != None:
            planInfo = json.loads(request.body.decode('utf-8'))
            planDetails = PlanRating.objects.filter(user_id=planInfo['user_id'], plan_id=planInfo['plan_id']).delete()
            return JsonResponse({"success":True,"message":"plan rating successfully deleted"})
        else:
            return JsonResponse({"success":False,"message":"user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})        


@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getPlanDetails(request):
    # user = request.session['user_id']
    # print(user)
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        user = username['id']
        print(user)
        if username != None:
            planInfo = json.loads(request.body.decode('utf-8'))
            planDetails = Plan.objects.filter(id=planInfo['id']).values('planName', 'id', 'num_of_sessions')
            for dt in planDetails:
                dataObj = dict(dt)
            return JsonResponse({"success": True, "message": "Program Details Saved Successfully", "PlanInfo": dataObj})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getProgramType(request):
    # user = request.session['user_id']
    # print(user)
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        user = username['id']
        # print(user)
        if username != None:
            plan = ProgramType.objects.filter(programTypeStatus=1).values('programTypeName', 'id')
            goals = Goals.objects.values('goalName', 'goalStatus', 'parentGoal', 'id')
            dataArr = []
            goalArr = []
            for dt in plan:
                data = dict(dt)
                dataArr.append(data)
            for val in goals:
                values = dict(val)
                goalArr.append(values)
            return JsonResponse({"success": True, "Details": dataArr, "goalDetails": goalArr})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def createPlanBuild(request):
    # user = request.session['user_id']
    # print(user)
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        # user = username['id']
        planBuildInfo = json.loads(request.body.decode('utf-8'))
        urls = []
        
        # planInfo = planBuildInfo['plan']['PlanInfo']
        # periodInfo = planBuildInfo['plan']['PeriodDetails']
        if username != None:
            planIosStatus = Plan.objects.get(id=planBuildInfo['plan_id'])
            if planIosStatus.iosStatus == 0:
                return JsonResponse({"success": False, "message": "Please update the prices and iOS Status"})
            else:
                if 'createdBy' in planBuildInfo and planBuildInfo['createdBy'] != None:
                    user = planBuildInfo['createdBy']
                    if user == 7362 or user == 7721 or user == "7362" or user == "7721":
                        return JsonResponse({"success": False, "message": "This is a dummy coach or gym id"})
                    else:
                        draftJson = DraftedPlan.objects.filter(planId_id=planBuildInfo['plan_id'],
                                                               createdBy_id=user).values('id', 'planId_id',
                                                                                         'protocolJson', 'planJson')
                else:
                    user = username['id']
                    if user == 7362 or user == 7721 or user == "7362" or user == "7721":
                        return JsonResponse({"success": False, "message": "This is a dummy coach or gym id"})
                    else:
                        draftJson = DraftedPlan.objects.filter(planId_id=planBuildInfo['plan_id'],
                                                               createdBy_id=user).values('id', 'planId_id',
                                                                                         'protocolJson', 'planJson')
                instanceSub = User.objects.get(id=user)
                for dt in draftJson:
                    dataObj = dict(dt)
                draftId = dataObj['id']
                planjson = dataObj['planJson'].replace("'", '"')
                planjson = dataObj['planJson'].replace("'", "\'")
                publishplanjson = json.loads(planjson)
                protocols = dataObj['protocolJson'].replace("'", '"')
                protocolInfo = json.loads(protocols)
                # print(protocolInfo['progression'])
                progressProtocol = protocolInfo['progression']
                regressionProtocol = protocolInfo['regression']
                skipprotocol = protocolInfo['skip']

                # print(publishplanjson['PeriodDetails'],"here into Publishing all the Details")
                periodInfo = publishplanjson['PeriodDetails']
                inSeasonPeriod = False
                for dp in periodInfo:
                    periodArr = dp['PeriodInfo']
                    if (periodArr['periodName'] == 'Specific' or periodArr['periodName'] == 'In-Season'):
                        inSeasonPeriod = True
                        break
                if inSeasonPeriod == True:
                    for dt in periodInfo:
                        periodVal = dt['PeriodInfo']
                        createperiod = Plan_Period.objects.create(
                            plan_id=planBuildInfo['plan_id'],
                            periodName=periodVal['periodName'],
                            status=1,
                            num_of_mesocycles=periodVal['num_of_mesocycles'],
                            duration_weeks=periodVal['duration_weeks'],
                            createdBy_id=user,
                            modifiedBy_id=user
                        )
                        createperiod.save()
                        periodId = createperiod.id
                        mesoDetails = dt['MesocycleDetails']
                        for meso in mesoDetails:
                            mesoVal = meso['MesocycleInfo']
                            createmeso = Plan_Mesocycle.objects.create(
                                period_id=periodId,
                                status=1,
                                num_of_microcycles=mesoVal['num_of_microcycles'],
                                duration_weeks=mesoVal['duration_weeks'],
                                createdBy_id=user,
                                modifiedBy_id=user
                            )
                            createmeso.save()
                            mesoId = createmeso.id
                            microDetails = meso['MicrocycleDetails']
                            print(len(microDetails), "23456543456")
                            for micro in microDetails:
                                microVal = micro['MicrocycleInfo']
                                createMicro = Plan_Microcycles.objects.create(
                                    mesocycle_id=mesoId,
                                    status=1,
                                    no_of_sessions=microVal['no_of_sessions'],
                                    totalInol=microVal['totalInol'],
                                    # dayOff = microVal['dayOff'],
                                    createdBy_id=user,
                                    modifiedBy_id=user
                                )
                                createMicro.save()
                                microId = createMicro.id
                                sessionDetails = micro['SessionDetails']
                                for sess in sessionDetails:
                                    sessVal = sess['SessionInfo']
                                    createsess = Plan_Sessions.objects.create(
                                        microcycle_id=microId,
                                        status=1,
                                        no_of_excersices=sessVal['no_of_excersices'],
                                        restTime=sessVal['restTime'],
                                        totalInol=sessVal['totalInol'],
                                        createdBy_id=user,
                                        modifiedBy_id=user
                                    )
                                    createsess.save()
                                    sessId = createsess.id
                                    exdetails = sess['exerciseDetails']
                                    for ex in exdetails:
                                        exVal = ex['ExerciseInfo']
                                        createex = PlanExcercise.objects.create(
                                            exerciseName_id=exVal['ex_id'],
                                            session_id=sessId,
                                            status=1,
                                            num_of_sets=exVal['num_of_sets'],
                                            num_of_reps=exVal['num_of_reps'],
                                            extra_set=exVal['extra_set'],
                                            totalInol=exVal['totalInol'],
                                            intensity=exVal['intensity'],
                                            warmup=exVal['warmup'],
                                            warmupType=exVal['warmupType'],
                                            createdBy_id=user,
                                            modifiedBy_id=user
                                        )
                                        if 'num_of_reps' in exVal and exVal['advExercise'] == True:
                                            createex.num_of_reps = exVal['num_of_reps']
                                        if 'exRestTime' in exVal:
                                            createex.restTime = exVal['exRestTime']
                                        if 'instructions' in exVal:
                                            print("coming Here", exVal['instructions'])
                                            createex.specificInstruction = exVal['instructions']
                                        if 'ability' in exVal:
                                            createex.ability = exVal['ability']
                                        if 'advExercise' in exVal and exVal['advExercise'] != None:
                                            createex.advExercise = exVal['advExercise']
                                        if 'advTime' in exVal and exVal['advTime'] != None:
                                            createex.exTime = exVal['advTime']
                                        if 'advWeight' in exVal and exVal['advWeight'] != None:
                                            createex.exWeight = exVal['advWeight']
                                        if 'advDistance' in exVal and exVal['advDistance'] != None:
                                            createex.exDistance = exVal['advDistance']
                                        if 'advSpeed' in exVal and exVal['advSpeed'] != None:
                                            createex.speed = exVal['advSpeed']
                                        if 'advHeight' in exVal and exVal['advHeight'] != None:
                                            createex.height = exVal['advHeight']
                                        createex.save()
                                        exId = createex.id
                                        if 'baseDistance' in exVal and exVal['baseDistance'] != None:
                                            planextmaxDet = PlanExTmax.objects.filter(plan_id=planBuildInfo['plan_id'],
                                                                                      exercise_id=exVal['ex_id'])
                                            if planextmaxDet.exists():
                                                print("already Exists")
                                            else:
                                                createPlanEXTmax = PlanExTmax.objects.create(
                                                    exercise_id=exVal['ex_id'],
                                                    plan_id=planBuildInfo['plan_id'],
                                                    baseDistance=exVal['baseDistance'],
                                                    baseReps=exVal['baseReps'],
                                                    baseTime=exVal['baseTime'],
                                                    baseWeight=exVal['baseWeight'],
                                                    # tamxContent = exVal['advBaseExTmaxMsg']
                                                )
                                                createPlanEXTmax.save()
                                        # setDetails = ex['setDetails']
                                        setData = exVal['num_of_sets']
                                        if exVal['extra_set'] > 0:
                                            setData = exVal['num_of_sets']
                                        print(exVal['extra_set'])
                                        print(set, "here I Come")
                                        for i in range(0, setData):
                                            createset = PlanSets.objects.create(
                                                excercise_id=exId,
                                                status=1,
                                                num_of_reps=exVal['num_of_reps'],
                                                totalInol=exVal['totalInol'],
                                                createdBy_id=user,
                                                modifiedBy_id=user
                                            )
                                            if 'restTime' in exVal:
                                                createset.restTime = exVal['restTime']
                                            if 'advExercise' in exVal and exVal['advExercise'] != None:
                                                createset.advExercise = exVal['advExercise']
                                            if 'advTime' in exVal and exVal['advTime'] != None:
                                                createset.exTime = exVal['advTime']
                                            if 'advWeight' in exVal and exVal['advWeight'] != None:
                                                createset.exWeight = exVal['advWeight']
                                            if 'advDistance' in exVal and exVal['advDistance'] != None:
                                                createset.exDistance = exVal['advDistance']
                                            createset.save()
                                        if exVal['extra_set'] == 0:
                                            if 'allOutStat' in exVal:
                                                createset.allOutStat = exVal['allOutStat']
                                        createset.save()
                                        if exVal['extra_set'] > 0:
                                            createset = PlanSets.objects.create(
                                                excercise_id=exId,
                                                status=1,
                                                num_of_reps=exVal['extra_set'],
                                                totalInol=exVal['totalInol'],
                                                createdBy_id=user,
                                                modifiedBy_id=user
                                            )
                                            if 'restTime' in exVal:
                                                createset.restTime = exVal['restTime']
                                            if 'advExercise' in exVal and exVal['advExercise'] != None:
                                                createset.advExercise = exVal['advExercise']
                                            if 'advTime' in exVal and exVal['advTime'] != None:
                                                createset.exTime = exVal['advTime']
                                            if 'advWeight' in exVal and exVal['advWeight'] != None:
                                                createset.exWeight = exVal['advWeight']
                                            if 'advDistance' in exVal and exVal['advDistance'] != None:
                                                createset.exDistance = exVal['advDistance']
                                            if 'allOutStat' in exVal:
                                                createset.allOutStat = exVal['allOutStat']
                                            createset.save()
                                        setId = createset.id
                                        print("details Saved Successfully")
                else:
                    for dt in periodInfo:
                        periodVal = dt['PeriodInfo']
                        createperiod = Plan_Period.objects.create(
                            plan_id=planBuildInfo['plan_id'],
                            periodName=periodVal['periodName'],
                            status=1,
                            num_of_mesocycles=periodVal['num_of_mesocycles'],
                            duration_weeks=periodVal['duration_weeks'],
                            createdBy_id=user,
                            modifiedBy_id=user
                        )
                        createperiod.save()
                        periodId = createperiod.id
                        mesoDetails = dt['MesocycleDetails']
                        for meso in mesoDetails:
                            mesoVal = meso['MesocycleInfo']
                            createmeso = Plan_Mesocycle.objects.create(
                                period_id=periodId,
                                status=1,
                                num_of_microcycles=mesoVal['num_of_microcycles'],
                                duration_weeks=mesoVal['duration_weeks'],
                                createdBy_id=user,
                                modifiedBy_id=user
                            )
                            createmeso.save()
                            mesoId = createmeso.id
                            microDetails = meso['MicrocycleDetails']
                            print(len(microDetails), "23456543456")
                            if (len(microDetails) % 2) == 0:
                                print("even Number of Microcylcles")
                                # if "repeat" in microVal and microVal['repeat'] == 1:
                                for num in range(0, 2):
                                    for micro in microDetails:
                                        microVal = micro['MicrocycleInfo']
                                        createMicro = Plan_Microcycles.objects.create(
                                            mesocycle_id=mesoId,
                                            status=1,
                                            no_of_sessions=microVal['no_of_sessions'],
                                            totalInol=microVal['totalInol'],
                                            # dayOff = microVal['dayOff'],
                                            createdBy_id=user,
                                            modifiedBy_id=user
                                        )
                                        createMicro.save()
                                        microId = createMicro.id
                                        sessionDetails = micro['SessionDetails']
                                        for sess in sessionDetails:
                                            sessVal = sess['SessionInfo']
                                            createsess = Plan_Sessions.objects.create(
                                                microcycle_id=microId,
                                                status=1,
                                                no_of_excersices=sessVal['no_of_excersices'],
                                                restTime=sessVal['restTime'],
                                                totalInol=sessVal['totalInol'],
                                                createdBy_id=user,
                                                modifiedBy_id=user
                                            )
                                            createsess.save()
                                            sessId = createsess.id
                                            exdetails = sess['exerciseDetails']
                                            for ex in exdetails:
                                                exVal = ex['ExerciseInfo']
                                                createex = PlanExcercise.objects.create(
                                                    exerciseName_id=exVal['ex_id'],
                                                    session_id=sessId,
                                                    status=1,
                                                    num_of_sets=exVal['num_of_sets'],
                                                    num_of_reps=exVal['num_of_reps'],
                                                    extra_set=exVal['extra_set'],
                                                    totalInol=exVal['totalInol'],
                                                    intensity=exVal['intensity'],
                                                    warmup=exVal['warmup'],
                                                    warmupType=exVal['warmupType'],
                                                    createdBy_id=user,
                                                    modifiedBy_id=user
                                                )
                                                if 'num_of_reps' in exVal and exVal['advExercise'] == True:
                                                    createex.num_of_reps = exVal['num_of_reps']
                                                if 'exRestTime' in exVal:
                                                    createex.restTime = exVal['exRestTime']
                                                if 'instructions' in exVal:
                                                    print("coming Here", exVal['instructions'])
                                                    createex.specificInstruction = exVal['instructions']
                                                if 'ability' in exVal:
                                                    createex.ability = exVal['ability']
                                                if 'advExercise' in exVal and exVal['advExercise'] != None:
                                                    createex.advExercise = exVal['advExercise']
                                                if 'advTime' in exVal and exVal['advTime'] != None:
                                                    createex.exTime = exVal['advTime']
                                                if 'advWeight' in exVal and exVal['advWeight'] != None:
                                                    createex.exWeight = exVal['advWeight']
                                                if 'advDistance' in exVal and exVal['advDistance'] != None:
                                                    createex.exDistance = exVal['advDistance']
                                                if 'advSpeed' in exVal and exVal['advSpeed'] != None:
                                                    createex.speed = exVal['advSpeed']
                                                if 'advHeight' in exVal and exVal['advHeight'] != None:
                                                    createex.height = exVal['advHeight']
                                                if 'instructions' in exVal:
                                                    print("coming Here", exVal['instructions'])
                                                    createex.specificInstruction = exVal['instructions']
                                                if 'ability' in exVal:
                                                    createex.ability = exVal['ability']
                                                createex.save()
                                                exId = createex.id
                                                if 'baseDistance' in exVal and exVal['baseDistance'] != None:
                                                    planextmaxDet = PlanExTmax.objects.filter(
                                                        plan_id=planBuildInfo['plan_id'], exercise_id=exVal['ex_id'])
                                                    if planextmaxDet.exists():
                                                        print("already Exists")
                                                    else:
                                                        createPlanEXTmax = PlanExTmax.objects.create(
                                                            exercise_id=exVal['ex_id'],
                                                            plan_id=planBuildInfo['plan_id'],
                                                            baseDistance=exVal['baseDistance'],
                                                            baseReps=exVal['baseReps'],
                                                            baseTime=exVal['baseTime'],
                                                            baseWeight=exVal['baseWeight'],
                                                            # tamxContent = exVal['advBaseExTmaxMsg']
                                                        )
                                                        createPlanEXTmax.save()
                                                # setDetails = ex['setDetails']
                                                setData = exVal['num_of_sets']
                                                if exVal['extra_set'] > 0:
                                                    setData = exVal['num_of_sets']
                                                print(exVal['extra_set'])
                                                print(set, "here I Come")
                                                for i in range(0, setData):
                                                    createset = PlanSets.objects.create(
                                                        excercise_id=exId,
                                                        status=1,
                                                        num_of_reps=exVal['num_of_reps'],
                                                        totalInol=exVal['totalInol'],
                                                        createdBy_id=user,
                                                        modifiedBy_id=user
                                                    )
                                                    if 'restTime' in exVal:
                                                        createset.restTime = exVal['restTime']
                                                    if 'advExercise' in exVal and exVal['advExercise'] != None:
                                                        createset.advExercise = exVal['advExercise']
                                                    if 'advTime' in exVal and exVal['advTime'] != None:
                                                        createset.exTime = exVal['advTime']
                                                    if 'advWeight' in exVal and exVal['advWeight'] != None:
                                                        createset.exWeight = exVal['advWeight']
                                                    if 'advDistance' in exVal and exVal['advDistance'] != None:
                                                        createset.exDistance = exVal['advDistance']
                                                    createset.save()
                                                if exVal['extra_set'] == 0:
                                                    if 'allOutStat' in exVal:
                                                        createset.allOutStat = exVal['allOutStat']
                                                createset.save()
                                                if exVal['extra_set'] > 0:
                                                    createset = PlanSets.objects.create(
                                                        excercise_id=exId,
                                                        status=1,
                                                        num_of_reps=exVal['extra_set'],
                                                        totalInol=exVal['totalInol'],
                                                        createdBy_id=user,
                                                        modifiedBy_id=user
                                                    )
                                                    if 'restTime' in exVal:
                                                        createset.restTime = exVal['restTime']
                                                    if 'advExercise' in exVal and exVal['advExercise'] != None:
                                                        createset.advExercise = exVal['advExercise']
                                                    if 'advTime' in exVal and exVal['advTime'] != None:
                                                        createset.exTime = exVal['advTime']
                                                    if 'advWeight' in exVal and exVal['advWeight'] != None:
                                                        createset.exWeight = exVal['advWeight']
                                                    if 'advDistance' in exVal and exVal['advDistance'] != None:
                                                        createset.exDistance = exVal['advDistance']
                                                    if 'allOutStat' in exVal:
                                                        createset.allOutStat = exVal['allOutStat']
                                                    createset.save()
                                                setId = createset.id
                                                print("details Saved Successfully")
                            else:
                                for num in range(0, 4):
                                    for micro in microDetails:
                                        microVal = micro['MicrocycleInfo']
                                        print("odd number of microcyles")
                                        # for num in range(0, 4):
                                        createMicro = Plan_Microcycles.objects.create(
                                            mesocycle_id=mesoId,
                                            status=1,
                                            no_of_sessions=microVal['no_of_sessions'],
                                            totalInol=microVal['totalInol'],
                                            # dayOff = microVal['dayOff'],
                                            createdBy_id=user,
                                            modifiedBy_id=user
                                        )
                                        createMicro.save()
                                        microId = createMicro.id
                                        sessionDetails = micro['SessionDetails']
                                        for sess in sessionDetails:
                                            sessVal = sess['SessionInfo']
                                            createsess = Plan_Sessions.objects.create(
                                                microcycle_id=microId,
                                                status=1,
                                                no_of_excersices=sessVal['no_of_excersices'],
                                                restTime=sessVal['restTime'],
                                                totalInol=sessVal['totalInol'],
                                                createdBy_id=user,
                                                modifiedBy_id=user
                                            )
                                            createsess.save()
                                            sessId = createsess.id
                                            exdetails = sess['exerciseDetails']
                                            for ex in exdetails:
                                                exVal = ex['ExerciseInfo']
                                                createex = PlanExcercise.objects.create(
                                                    exerciseName_id=exVal['ex_id'],
                                                    session_id=sessId,
                                                    status=1,
                                                    num_of_sets=exVal['num_of_sets'],
                                                    num_of_reps=exVal['num_of_reps'],
                                                    extra_set=exVal['extra_set'],
                                                    totalInol=exVal['totalInol'],
                                                    intensity=exVal['intensity'],
                                                    warmup=exVal['warmup'],
                                                    warmupType=exVal['warmupType'],
                                                    createdBy_id=user,
                                                    modifiedBy_id=user
                                                )
                                                if 'num_of_reps' in exVal and exVal['advExercise'] == True:
                                                    createex.num_of_reps = exVal['num_of_reps']
                                                if 'exRestTime' in exVal:
                                                    createex.restTime = exVal['exRestTime']
                                                if 'instructions' in exVal:
                                                    print("coming Here", exVal['instructions'])
                                                    createex.specificInstruction = exVal['instructions']
                                                if 'ability' in exVal:
                                                    createex.ability = exVal['ability']
                                                if 'advExercise' in exVal and exVal['advExercise'] != None:
                                                    createex.advExercise = exVal['advExercise']
                                                if 'advTime' in exVal and exVal['advTime'] != None:
                                                    createex.exTime = exVal['advTime']
                                                if 'advWeight' in exVal and exVal['advWeight'] != None:
                                                    createex.exWeight = exVal['advWeight']
                                                if 'advDistance' in exVal and exVal['advDistance'] != None:
                                                    createex.exDistance = exVal['advDistance']
                                                if 'advSpeed' in exVal and exVal['advSpeed'] != None:
                                                    createex.speed = exVal['advSpeed']
                                                if 'advHeight' in exVal and exVal['advHeight'] != None:
                                                    createex.height = exVal['advHeight']
                                                if 'restTime' in exVal:
                                                    createex.restTime = exVal['restTime']
                                                if 'instructions' in exVal:
                                                    print("coming Here", exVal['instructions'])
                                                    createex.specificInstruction = exVal['instructions']
                                                if 'ability' in exVal:
                                                    createex.ability = exVal['ability']
                                                createex.save()
                                                exId = createex.id
                                                if 'baseDistance' in exVal and exVal['baseDistance'] != None:
                                                    planextmaxDet = PlanExTmax.objects.filter(
                                                        plan_id=planBuildInfo['plan_id'], exercise_id=exVal['ex_id'])
                                                    if planextmaxDet.exists():
                                                        print("already Exists")
                                                    else:
                                                        createPlanEXTmax = PlanExTmax.objects.create(
                                                            exercise_id=exVal['ex_id'],
                                                            plan_id=planBuildInfo['plan_id'],
                                                            baseDistance=exVal['baseDistance'],
                                                            baseReps=exVal['baseReps'],
                                                            baseTime=exVal['baseTime'],
                                                            baseWeight=exVal['baseWeight'],
                                                            # tamxContent = exVal['advBaseExTmaxMsg']
                                                        )
                                                        createPlanEXTmax.save()
                                                # setDetails = ex['setDetails']
                                                setData = exVal['num_of_sets']
                                                if exVal['extra_set'] > 0:
                                                    setData = exVal['num_of_sets']
                                                print(exVal['extra_set'])
                                                print(set, "here I Come")
                                                for i in range(0, setData):
                                                    createset = PlanSets.objects.create(
                                                        excercise_id=exId,
                                                        status=1,
                                                        num_of_reps=exVal['num_of_reps'],
                                                        totalInol=exVal['totalInol'],
                                                        createdBy_id=user,
                                                        modifiedBy_id=user
                                                    )
                                                    if 'restTime' in exVal:
                                                        createset.restTime = exVal['restTime']
                                                    if 'advExercise' in exVal and exVal['advExercise'] != None:
                                                        createset.advExercise = exVal['advExercise']
                                                    if 'advTime' in exVal and exVal['advTime'] != None:
                                                        createset.exTime = exVal['advTime']
                                                    if 'advWeight' in exVal and exVal['advWeight'] != None:
                                                        createset.exWeight = exVal['advWeight']
                                                    if 'advDistance' in exVal and exVal['advDistance'] != None:
                                                        createset.exDistance = exVal['advDistance']
                                                    createset.save()
                                                if exVal['extra_set'] == 0:
                                                    if 'allOutStat' in exVal:
                                                        createset.allOutStat = exVal['allOutStat']
                                                createset.save()
                                                if exVal['extra_set'] > 0:
                                                    createset = PlanSets.objects.create(
                                                        excercise_id=exId,
                                                        status=1,
                                                        num_of_reps=exVal['extra_set'],
                                                        totalInol=exVal['totalInol'],
                                                        createdBy_id=user,
                                                        modifiedBy_id=user
                                                    )
                                                    if 'restTime' in exVal:
                                                        createset.restTime = exVal['restTime']
                                                    if 'advExercise' in exVal and exVal['advExercise'] != None:
                                                        createset.advExercise = exVal['advExercise']
                                                    if 'advTime' in exVal and exVal['advTime'] != None:
                                                        createset.exTime = exVal['advTime']
                                                    if 'advWeight' in exVal and exVal['advWeight'] != None:
                                                        createset.exWeight = exVal['advWeight']
                                                    if 'advDistance' in exVal and exVal['advDistance'] != None:
                                                        createset.exDistance = exVal['advDistance']
                                                    if 'allOutStat' in exVal:
                                                        createset.allOutStat = exVal['allOutStat']
                                                    createset.save()
                                                setId = createset.id
                                                print("details Saved Successfully")
                for protoId in progressProtocol:
                    # print(protoId['tmax'])
                    createProtocol = Plan_Actions.objects.create(
                        protocol_id=protoId['protocol_id'],
                        plan_id=planBuildInfo['plan_id'],
                        exercise_id=protoId['ex_id'],
                        values=protoId['tmax'],
                        createdBy_id=user,
                        modifiedBy_id=user
                    )
                    createProtocol.save()
                for protoId in regressionProtocol:
                    # print(protoId['tmax'])
                    createProtocol = Plan_Actions.objects.create(
                        protocol_id=protoId['protocol_id'],
                        plan_id=planBuildInfo['plan_id'],
                        exercise_id=protoId['ex_id'],
                        values=protoId['tmax'],
                        createdBy_id=user,
                        modifiedBy_id=user
                    )

                    createProtocol.save()
                for protoId in skipprotocol:
                    createProtocol = Plan_Actions.objects.create(
                        protocol_id=protoId['protocol_id'],
                        plan_id=planBuildInfo['plan_id'],
                        exercise_id=protoId['ex_id'],
                        values=protoId['tmax'],
                        createdBy_id=user,
                        modifiedBy_id=user
                    )
                    createProtocol.save()

                planCountry1 = PlanCountry.objects.create(
                    plan_id=planBuildInfo['plan_id'],
                    country_id=88
                )
                planCountry1.save()
                planCountry2 = PlanCountry.objects.create(
                    plan_id=planBuildInfo['plan_id'],
                    country_id=190
                )
                planCountry2.save()

                countOfPeriods = Plan_Period.objects.filter(plan_id=planBuildInfo['plan_id']).values('id')
                countOfMicrocycles = Plan_Microcycles.objects.select_related('PlanMesocycle__id', 'PlanPeriods__id',
                                                                       'Plan__id').filter(
                    mesocycle_id__period_id__plan_id__id=planBuildInfo['plan_id']).values('id')
                num_of_periods = len(countOfPeriods)
                # print(num_of_periods,"this Came Here2")
                num_of_microcycles = len(countOfMicrocycles)
                # print(num_of_microcycles,"this Came Here")
                if num_of_microcycles == 1:
                    num_of_microcycles = 4
                planInf = Plan.objects.get(pk=planBuildInfo['plan_id'])
                planInf.planStatus = True
                planInf.duration_weeks = num_of_microcycles
                planInf.num_of_periods = num_of_periods
                planInf.save()

                updatePlanPeriod = Plan_Period.objects.filter(plan_id=planBuildInfo['plan_id']).values('id')
                for per in updatePlanPeriod:
                    perObj = dict(per)
                    updatePeriod = Plan_Period.objects.get(pk=perObj['id'])
                    updatePeriod.duration_weeks = planInf.duration_weeks
                    updatePeriod.save()

                planname = planInf.planName
                planId = planInf.id

                secret_code_plain = planname + '#' + str(planId)
                secret_code_encode = base64.b64encode(secret_code_plain.encode('ascii'))
                encodedVal = str(secret_code_encode).split("'")
                encodeUrl = encodedVal[1]

                utm_source = "Facebook"
                utm_source1 = "Twitter"
                utm_source2 = "Instagram"

                utm_name = planname

                url = "http://stratfit.net/#/planprofile/" + str(encodeUrl)
                url1 = url + "/" + "utm_source=" + utm_source + "&utm_medium=Link&utm_term=Organic&utm_name=" + utm_name
                url2 = url + "/" + "utm_source=" + utm_source1 + "&utm_medium=Link&utm_term=Organic&utm_name=" + utm_name
                url3 = url + "/" + "utm_source=" + utm_source2 + "&utm_medium=Link&utm_term=Organic&utm_name=" + utm_name

                urls.append({"url": url1, "planId": planId})
                urls.append({"url": url2, "planId": planId})
                urls.append({"url": url3, "planId": planId})
                if len(urls) > 1:
                    for ul in urls:
                        urlVal = ul['url']
                        planVal = ul['planId']
                        post_url = 'https://www.googleapis.com/urlshortener/v1/url?key={}'.format(
                            "AIzaSyAXaSWj7trNg8Pq3PdBiOSHirnjcZlIZSo")
                        payload = {'longUrl': urlVal}
                        headers = {'content-type': 'application/json'}
                        r = requests.post(post_url, data=json.dumps(payload), headers=headers)
                        result = r.json()
                        print(r.text)
                        checkShortUrls = PlanShortUrls.objects.filter(shortUrl=result['id'])
                        if checkShortUrls.exists():
                            print("exists")
                        else:
                            createShortUrls = PlanShortUrls.objects.create(
                                plan_id=planVal,
                                shortUrl=result['id'],
                                longUrl=urlVal
                            )
                            createShortUrls.save()
                updateDraft = DraftedPlan.objects.get(pk=draftId)
                updateDraft.status = 1
                updateDraft.save()
                # print('================',planname,'=================')
                subject = "Plan published!"
                to_email = instanceSub.email
                ctx = {
                    'first_name': instanceSub.first_name,
                    'plan_name': planname
                }
                message = render_to_string('publishplan.html', ctx)
                officeMail(subject, message, to_email)
                return JsonResponse({"success": True, "message": "Program Published Successfully"})
        else:
            return JsonResponse({"success": False, "message": "User LoggedOut"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})

def getExerciseDetails(request):
    # stratsessionutil = StartFitSessionUtil()
    planId = json.loads(request.body.decode('utf-8'))
    try:
        # username = stratsessionutil.get_user_insession(request)
        # user = username['id']
        # print(user)
        # if username != None:
        exObj = set()
        dataArr = []
        jsonDetails = DraftedPlan.objects.filter(planId_id=planId['plan_id']).values('planJson')
        if jsonDetails.exists():
            for va in jsonDetails:
                dataObj1 = dict(va)
            # print(dataObj["planJson"])
            jsonObj = dataObj1["planJson"].replace("'", "\'")
            test = json.loads(jsonObj)
            for v in test['PeriodDetails']:
                for m in v['MesocycleDetails']:
                    for mi in m['MicrocycleDetails']:
                        for se in mi['SessionDetails']:
                            for ex in se['exerciseDetails']:
                                print(ex['ExerciseInfo']['ex_id'])
                                exObj.add(ex['ExerciseInfo']['ex_id'])
            # for val in exObj:
            exTypeDetails = NewExercise.objects.filter(id__in=exObj).values('exerciseName', 'exerciseDesc',
                                                                         'equipment', 'id', 'accessLevel').order_by(
                'id')
            for dt in exTypeDetails:
                dataObj = dict(dt)
                if dataObj['exAbilities'] !="Skill":
                    dataArr.append({"exName": dataObj['exerciseName'], "exCode": dataObj['exerciseCode'], "id": dataObj['id'], "exDesc": dataObj['exerciseDesc'],"exEquip": dataObj['equipment'],"accessLevel":dataObj['accessLevel']})
        return JsonResponse(dataArr, safe=False)
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})



@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def saveprotocolJson(request):
    stratsessionutil = StartFitSessionUtil()
    planJson = json.loads(request.body.decode('utf-8'))
    try:
        username = stratsessionutil.get_user_insession(request)
        user = username['id']
        print(user)
        if username != None:
            updateJson = DraftedPlan.objects.filter(planId_id=planJson['plan_id'], createdBy_id=user).values('id',
                                                                                                             'planId_id',
                                                                                                             'protocolJson')
            if updateJson.exists():
                for dt in updateJson:
                    dataObj = dict(dt)
                if dataObj['protocolJson'] == None or dataObj['protocolJson'] == '':
                    protoJson = planJson['protocols']
                else:
                    protocol = dataObj['protocolJson'].replace("'", '"')
                    protoJson = json.loads(protocol)
                    # print(protocol,"printing the Protocols")
                    if 'regression' in planJson['protocols']:
                        protoJson['regression'] = planJson['protocols']['regression']
                    elif 'progression' in planJson['protocols']:
                        protoJson['progression'] = planJson['protocols']['progression']
                    elif 'skip' in planJson['protocols']:
                        protoJson['skip'] = planJson['protocols']['skip']
                    elif 'transition' in planJson['protocols']:
                        protoJson['transition'] = planJson['protocols']['transition']
                    else:
                        protoJson = planJson['protocols']
                update = DraftedPlan.objects.get(pk=dataObj['id'])
                update.protocolJson = json.dumps(protoJson)
                print("in Here TO Update")
                update.createdBy_id = user
                update.modifiedBy_id = user
                update.save()
                draftId = update.id
            return JsonResponse({"success": True, "message": "Draft Saved Successfully", "draftId": draftId})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})



@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getprotocolJson(request):
    stratsessionutil = StartFitSessionUtil()
    planId = json.loads(request.body.decode('utf-8'))
    try:
        username = stratsessionutil.get_user_insession(request)
        if username != None:
            if 'createdBy' in planId and planId['createdBy'] != '' and planId['createdBy'] != None:
                user = planId['createdBy']
            else:
                user = username['id']
            jsonDetails = DraftedPlan.objects.select_related('User__id', 'Plan__id').filter(createdBy_id=user,
                                                                                            planId_id=planId[
                                                                                                'plan_id']).values(
                'planJson', 'protocolJson', 'status', 'planId_id__planStatus')
            if jsonDetails.exists():
                for dt in jsonDetails:
                    dataObj = dict(dt)
                    if dataObj['planId_id__planStatus'] == 1 and dataObj['status'] == 1:
                        dataObj['status'] = 1
                    else:
                        dataObj['status'] = 0
            else:
                dataObj = {'success': False}
            return JsonResponse(dataObj)
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})                

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def deletedraftedplan(request):
    stratsessionutil = StartFitSessionUtil()
    draftid = json.loads(request.body.decode('utf-8'))
    try:
        username = stratsessionutil.get_user_insession(request)
        user = username['id']
        print(user)
        if username != None:
            draftdata = DraftedPlan.objects.get(pk=draftid['id'])
            draftdata.status = 0
            draftdata.modifiedBy_id = user
            draftdata.save()
            return JsonResponse({"success": True, "message": "Program deleted successfully"})
        else:
            return JsonResponse({"success": False, "message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})    

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getTransitExId(request):
    stratsessionutil = StartFitSessionUtil()
    planId = json.loads(request.body.decode('utf-8'))
    try:
        username = stratsessionutil.get_user_insession(request)
        user = username['id']
        # print(user)
        if username != None:
            jsonDetails = DraftedPlan.objects.filter(createdBy_id=user, planId_id=planId['plan_id']).values('planJson')
            planDetails = Plan.objects.filter(id=planId['plan_id']).values('programType')
            for data in planDetails:
                planValues = dict(data)
            print(planValues)
            lablledEx = []
            unlabelledEx = []
            if planValues['programType'] == 1:
                if jsonDetails.exists():
                    for dt in jsonDetails:
                        dataObj = dict(dt)
                        planjson = dataObj['planJson'].replace("'", '"')
                publishplanjson = json.loads(planjson)
                periodInfo = publishplanjson['PeriodDetails']
                for dt in periodInfo:
                    mesoDetails = dt['MesocycleDetails']
                    for meso in mesoDetails:
                        microDetails = meso['MicrocycleDetails']
                        for micro in microDetails:
                            sessionDetails = micro['SessionDetails']
                            for sess in sessionDetails:
                                exdetails = sess['exerciseDetails']
                                for ex in exdetails:
                                    exVal = ex['ExerciseInfo']
                                    if '0-0-0-0' in exVal['path']:
                                        labelledExcercises = exVal['Ex_name']
                                        labelledExid = exVal['ex_id']
                                        lablledEx.append({"exname": labelledExcercises, "exid": labelledExid})
                                    else:
                                        unlabelledExer = exVal['Ex_name']
                                        unlabelledexid = exVal['ex_id']
                                        unlabelledEx.append({"exname": unlabelledExer, "exid": unlabelledexid})

                print("------", lablledEx, "-----")
                print("------", unlabelledEx, "-----")
                output = []
                output1 = []
                for item in lablledEx:
                    if item in unlabelledEx:
                        unlabelledEx.remove(item)
                otherExercises = unlabelledEx
                for x in otherExercises:
                    if x not in output:
                        output.append(x)
                for x1 in lablledEx:
                    if x1 not in output1:
                        output1.append(x1)
                print(output, "XXXXXXXXXXXXXXXXXXXXXXXXXX")
            else:
                return JsonResponse({"success": False, "message": "not a rapid progression Plan"})
        else:
            return JsonResponse({"success": False, "message": "User Logged Out"})
        return JsonResponse({"labelled": output1, "unlabbeld": output})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})



@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def saveRuleJson(request):
    stratsessionutil = StartFitSessionUtil()
    planJson = json.loads(request.body.decode('utf-8'))
    try:
        username = stratsessionutil.get_user_insession(request)
        user = username['id']
        print(user)
        if username != None:
            if 'plan_id' in planJson:
                updateJson = DraftedPlan.objects.filter(planId_id=planJson['plan_id'], createdBy_id=user).values('id',
                                                                                                                 'planId_id')
                # print(updateJson)
                if updateJson.exists():
                    for dt in updateJson:
                        dataObj = dict(dt)
                    update = DraftedPlan.objects.get(pk=dataObj['id'])
                    update.protocolJson = json.dumps(planJson['rules'])
                    print(planJson['rules'])
                    update.createdBy_id = user
                    update.modifiedBy_id = user
                    update.save()
                    return JsonResponse({"success": True, "message": "record Inserted Successfully"})
                else:
                    createRule = DraftedPlan.objects.create(
                        planId_id=planJson['plan_id'],
                        createdBy_id=user,
                        modifiedBy_id=user,
                        protocolJson=json.dumps(planJson['rules'])
                    )
                    createRule.save()
                    return JsonResponse({"success": True, "message": "record Inserted Successfully"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})


@never_cache
def planJson(request):
    try:
        data = json.loads(request.body.decode('utf-8'))
        userplanDetails = UserPlan.objects.filter(user_id=data['id'], status=1).values('id', 'plan_id')
        for val in userplanDetails:
            plan_id = val['plan_id']
            userplan_id = val['id']
        offset1 = data['end']
        print(offset1)
        offset2 = data['start']
        print(offset2)
        info = UserSets.objects.filter(plan_id=plan_id).select_related('id', 'UserExercise__id', 'Exercise',
                                                                       'PlanSets').values(
            'setNumber', 'userexercise__exerciseId__exerciseName', 'totalReps',
            'userexercise__exerciseWorkWeight', 'planset__num_of_reps')
        list = []
        for dt in info:
            plandetails = dict(dt)
            plandetails['numOfReps'] = plandetails['planset__num_of_reps']
            plandetails['setName'] = plandetails['setNumber']
            plandetails['repsDone'] = plandetails['totalReps']
            plandetails['exerciseName'] = plandetails['userexercise__exerciseId__exerciseName']
            plandetails['workWeight'] = plandetails['userexercise__exerciseWorkWeight']
            list.append(plandetails)
        last_two = Plan_Sessions.objects.values('id').order_by('-id')[int(offset2):int(offset1)]
        last_two_in_ascending_order = reversed(last_two)
        # print(last_two)
        arr = []
        for dt1 in last_two_in_ascending_order:
            details = dict(dt1)
            userSetDetails = UserSets.objects.select_related('id', 'UserExercise__id', 'Exercise', 'PlanSets').filter(
                planset__excercise__session__id=details['id']).values('setNumber',
                                                                      'userexercise__exerciseId__exerciseName',
                                                                      'totalReps', 'userexercise__exerciseWorkWeight',
                                                                      'planset__num_of_reps')
            for val in userSetDetails:
                values = dict(val)
                print(values, "--------")
                arr.append(values)
            # arr.append(details)
            # print(arr)
        return JsonResponse({"plan": list, "offset": arr, "userplanId": userplan_id, "activePlanId": activePlan_id})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def planInfo(request):
    # user = request.session['user_id']
    # print(user)
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        user = username['id']
        print(user)
        if username != None:
            planInfo = json.loads(request.body.decode('utf-8'))
            protocoldetails = DraftedPlan.objects.select_related('User__id','Plan__id').filter(createdBy_id = user,planId_id = planInfo['id']).values('planJson','protocolJson','status','planId_id__planStatus')
            if protocoldetails.exists():
                for dt in protocoldetails:
                    dataObj1 = dict(dt)
                    if dataObj1['protocolJson'] != None and dataObj1['protocolJson'] != '':
                        protocolExists = True
                    else:
                        protocolExists = False
            else:
                protocolExists = False
            planVideos=PlanVideos.objects.filter(plan_id=planInfo['id']).values('video')    
            planDetails = PlanMonetization.objects.select_related('Plan__id').filter(plan_id=planInfo['id']).values(
                'plan_id__planName', 'id', 'plan_id__num_of_sessions', 'planType', 'license_id', 'royalty', 'template',
                'templateContent', 'coach_id', 'coupon')
            planvalues = Plan.objects.filter(id=planInfo['id']).values('id', 'num_of_sessions', 'royalty', 'goals',
                                                                       'licencePolicy', 'planPhoto', 'originalPlanner',
                                                                       'originalPlanId', 'price', 'programType_id',
                                                                       'ability', 'planStatus', 'planDescription',
                                                                       'planName', 'planLogo', 'createdBy_id',
                                                                       'iosPrice', 'iosStatus','others')
            dataArr = []
            goals = PlanGoals.objects.filter(plan_id=planInfo['id']).values()
            abilities = SelectedAbilities.objects.filter(plan_id=planInfo['id']).values()
            planAbilityVal = SelectedAbilities.objects.select_related('PlanAbilities').filter(
                plan_id=planInfo['id']).values('ability_id__ability')
            goalString = ""
            abilityString = ""
            for dt in planvalues:
                dataObj = dict(dt)
                if dataObj['licencePolicy'] == "3" or dataObj['licencePolicy'] == "White-Label":
                    partnerName = User.objects.get(id=dataObj['createdBy_id'])
                else:
                    coachName = User.objects.get(id=dt['originalPlanner'])
                    dataObj['planDescription'] = str(
                        dataObj['planDescription']) + "<br><h6>Copyright &copy; 2017 " + str(
                        str(coachName.first_name) + " " + str(coachName.last_name)) + ". All rights reserved.</h6>"
                dataObj['program'] = dataObj['programType_id']
                dataObj['description'] = dataObj['planDescription']
                dataObj['session'] = dataObj['num_of_sessions']
                # dataObj['goal'] = dataObj['goals']
                # dataObj['planMonetizationValues'] = dataArr
            for goal in goals:
                goalObj = dict(goal)
                goalString += "," + str(goalObj['planGoal_id'])
            if goalString != "":
                dataObj['goals'] = goalString[1:]

            for ability in abilities:
                abilityObj = dict(ability)
                abilityString += "," + str(abilityObj['ability_id'])
            if abilityString != "":
                dataObj['ability'] = abilityString[1:]

            abilitiesNames = ''
            for val in planAbilityVal:
                valObj = dict(val)
                abilitiesNames += ", " + valObj['ability_id__ability']
            if abilitiesNames != '':
                dataObj['abilitiesNames'] = abilitiesNames[1:]
            else:
                dataObj['abilitiesNames'] = ""
            for dt in planVideos:
                videos=dict(dt)
                dataObj['videos'] =dt['video'] 
                print("fvgdhj",dt['video'])  
            print(planVideos,"gggggggggggggggg")
            for val in planDetails:
                values = dict(val)
                if values['license_id'] == '1':
                    dataObj['directsell'] = values['license_id']
                elif values['license_id'] == '2':
                    dataObj['cobrand'] = values['license_id']
                    dataObj['cbroyalty1'] = values['royalty']
                    dataObj['template'] = values['template']
                elif values['license_id'] == '3':
                    dataObj['whitelab'] = values['license_id']
                    dataObj['whlabroyalty1'] = values['royalty']
                dataArr.append(values)
            return JsonResponse({"success": True, "message": "Program Details Saved Successfully", "PlanInfo": dataObj,"protocolExists":protocolExists})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def checkTrainer(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        user = username['id']
        print(user)
        if username != None:
            trainerCheck = trainerProfile.objects.filter(user_id=user, status=1).values('id')
            if trainerCheck.exists():
                trainerCheck = True
            else:
                return JsonResponse({"success": False, "status": 1})
            userProfileCheck = User.objects.filter(id=user).values('avatar')
            for dt in userProfileCheck:
                dataObj = dict(dt)
                print(dataObj['avatar'])
                if dataObj['avatar'] != None:
                    profileCheck = True
                else:
                    return JsonResponse({"success": False, "status": 2})
            if trainerCheck == True and profileCheck == True:
                return JsonResponse({"success": True, "status": 3})
        else:
            return JsonResponse({"success": False, "message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def coachList(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        user = username['id']
        print(user)
        if username != None:
            # planInfo = json.loads(request.body.decode('utf-8'))
            coachArr = []
            coaches = User.objects.filter(userType=3).values('id', 'first_name', 'avatar')
            for coach in coaches:
                coacheVal = dict(coach)
                coacheVal['coachId'] = coacheVal['id']
                coacheVal['coachName'] = coacheVal['first_name']
                if coacheVal['avatar'] is None:
                    coacheVal['avatar'] = 'http://stratfit.net/assets/images/user1.png'
                    coacheVal['createdBy_id__avatar1'] = 'http://stratfit.net/assets/images/user1.png'
                else:
                    coacheVal['createdBy_id__avatar1'] = coacheVal['avatar']
                    coacheVal['createdBy_id__avatar'] = coacheVal['avatar']
                    coacheVal['avatar'] = coacheVal['avatar']
                planDetails = Plan.objects.filter(createdBy_id=coacheVal['id']).values()
                if planDetails.exists():
                    coacheVal['noOfPlans'] = len(planDetails)
                else:
                    coacheVal['noOfPlans'] = len(planDetails)
                coachArr.append(coacheVal)
            return JsonResponse({"success": True, "coachesList": coachArr})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})
@api_view(['GET','POST'])
@authentication_classes((SessionAuthentication,IsAuthenticated))
@never_cache
def PlanSubscribers(request):
    stratsessionutil=StartFitSessionUtil()
    try:
        
        username = stratsessionutil.get_user_insession(request)
        user=username['id']
        PlanListArr=[]
        Arr=[]
        user=[]
        subscribers=[]
        if username != None:
            Info=json.loads(request.body.decode('utf-8'))
            planInfo=Plan.objects.filter(createdBy_id=Info['coachId'],planStatus=1).values('planName','id','planStatus')
            if planInfo.exists():
                for dt in planInfo:
                    plan=dict(dt)
                    PlanListArr.append(plan)
                    Arr.append(plan['id'])
                for i in Arr[::]:    
                    userplanDetails = UserPlan.objects.select_related('User__id','Plan__id').filter(plan_id=i).values('plan_id__planName','plan_id' ,'id', 'status','user_id','user_id__first_name','startDate','nextRenewalDate','freetrail','renewalDate')
                    for dt in userplanDetails:
                        userplan=dict(dt)
                        user.append(userplan)
                       
                subscribers.append(user)
                    
            return JsonResponse({"success": True, "publishedplansList":PlanListArr,"subscribers":subscribers })  
        else:
            return JsonResponse({"success":False,"message":"User Logged out"})    

    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})        
  
@api_view(['GET','POST'])
@authentication_classes((SessionAuthentication,IsAuthenticated))
@never_cache
def Web_PlanDetails(request):
    stratsessionutil=StartFitSessionUtil()
    try:
        username=stratsessionutil.get_user_insession(request)
        user=username['id']
        PlanActions=[]
        planStatus=[]
        if username != None:
            details=json.loads(request.body.decode('utf-8'))
            plan=[]
            perioddata=Plan_Period.objects.filter(plan_id=details['plan_id']).values()
            for i in perioddata[::]:
                i["depthlevel"]=0
                plan.append(i)
            mesodata=Plan_Mesocycle.objects.filter(plan_id=details['plan_id']).values()
            for i in mesodata[::]:
                i["depthlevel"]=1
                plan.append(i)
            microdata=Plan_Microcycles.objects.filter(plan_id=details['plan_id']).values()
            for i in microdata[::]:
                i["depthlevel"]=2
                plan.append(i)
            daydata=Plan_Days.objects.filter(plan_id=details['plan_id']).values()
            for i in daydata[::]:
                i["depthlevel"]=3
                plan.append(i)
            sessiondata=Plan_Sessions.objects.filter(plan_id=details['plan_id']).values()
            for i in sessiondata[::]:
                i["depthlevel"]=4
                plan.append(i)
            activitydata=Plan_Activity.objects.filter(plan_id=details['plan_id']).values()
            for i in activitydata[::]:
                i["depthlevel"]=5
                plan.append(i)
            rounddata=Plan_Round.objects.filter(plan_id=details['plan_id']).values()
            for i in rounddata[::]:
                i["depthlevel"]=6
                plan.append(i)
            actiondata=Plan_Actions.objects.filter(plan_id=details['plan_id']).values()
            for i in actiondata[::]:
                i["depthlevel"]=7
                plan.append(i)
            info = UserPlan.objects.filter(user_id=details['id'], status=1, plan_id=details['plan_id']).values('plan_id', 'id', 'status')
            if info.exists():
                for dt in info:
                    planInfo=dict(dt)
                    progId = planInfo['id']
                    Actions = UserActions.objects.select_related('Plan_Actions__id').filter(userplan_id=progId).values('height', 'totalReps', 'sessionStatus', 'advTime', 'createdDate', 'actionStatus', 'planaction_id', 'userplan_id', 'actionIntensity', 'actionWorkWeight', 'speed', 'actionSkip', 'plan_id', 'actionTmax', 'user_id', 'advDistance', 'id', 'exercise_id', 'actionDate', 'planaction_id__day_id_id', 'planaction_id__activity_id_id', 'planaction_id__round_id_id', 'planaction_id__session_id_id')
                    if Actions.exists():
                        for dt in Actions:
                            actions=dict(dt)
                            PlanActions.append(actions)
                
            return JsonResponse({"success":True,"PlanStatus":PlanActions,"CompletePlan":plan})  
        else:
            return JsonResponse({"success":False,"message":"User Logged out"})    
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})              
                                



@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def coachPlansList(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        user = username['id']
        print(user)
        planListArr = []
        if username != None:
            planInfo = json.loads(request.body.decode('utf-8'))
            planDetails = Plan.objects.select_related('User__id', 'ProgramType').filter(
                createdBy_id=planInfo['coachId']).values('createdBy_id__first_name', 'id', 'planName',
                                                         'createdBy_id__avatar', 'duration_weeks', 'price',
                                                         'programType__programTypeName', 'iosPrice', 'iosStatus')
            if planDetails.exists():
                for plan in planDetails:
                    planVal = dict(plan)
                    planVal['planId'] = planVal['id']
                    if planVal['createdBy_id__avatar'] is None:
                        planVal['avatar'] = 'http://stratfit.net/assets/images/user1.png'
                    else:
                        planVal['avatar'] =planVal['createdBy_id__avatar']
                    planVal['duration'] = planVal['duration_weeks']
                    planVal['level'] = planVal['programType__programTypeName']
                    userplans = UserPlan.objects.filter(plan_id=planVal['id']).values()
                    if userplans.exists():
                        planVal['noOfUsers'] = len(userplans)
                    else:
                        planVal['noOfUsers'] = 0
                    planListArr.append(planVal)
        return JsonResponse({"success": True, "plansList": planListArr})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})
@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def deActivatePlan(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        user = username['id']
        print(user)
        if username != None:
            planInfo = json.loads(request.body.decode('utf-8'))
            # print("came Herw")
            if planInfo['status'] == 0:
                message = "Plan Deactivated"
            else:
                message = "Plan Activated"
            deactiveplan = Plan.objects.get(pk=planInfo['plan_id'])
            deactiveplan.activationStatus = planInfo['status']
            deactiveplan.save()
            return JsonResponse({"success": True, "message": message})
        else:
            return JsonResponse({"success": False, "message": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})        

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def ionicgetcoachs(request):
    stratsessionutil = StartFitSessionUtil()
    coach={}
    lookuptable_key="getcoach"
    cachesession=cache.get(lookuptable_key)
    if cachesession :
        print("session token: ", lookuptable_key, "exists in cache")
        coach=cachesession
        try:
            username = stratsessionutil.get_user_insession(request)
            user = username['id']
            if username != None:
                return JsonResponse({"success": True, "coachesList": coach['coachs'][0],"dollarHighest":coach['dollar'] })
            else:
                return JsonResponse({"success":False,"message":"user logged out"})                            
        except Exception as e:
            logger.exception("something wrong")
            return JsonResponse({"msg": str(e)})
    else:
        username = stratsessionutil.get_user_insession(request)
        user = username['id']
        currencyValues = PriceConversion.objects.get(id=1)
        inrValue = currencyValues.inrValue
        userCurrency = User.objects.get(id=user)
        coachArr = []
        # downloadcount = 0
        indianPlanArr = []
        otherPlanArr = []
        inCoaches = []
        otCoaches = []
        india = False
        ''''
        countryID = UserAddress.objects.select_related('User__id').filter(country=88, user_id=user).values()
        if countryID.exists():
            for con in countryID:
                conObj = dict(con)
                username['userCountry'] = conObj['country']
            india = True
        indianCoaches = CoachCountry.objects.filter(country_id=88).values()
        print(indianCoaches,"gggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggg")
        if indianCoaches.exists():
            for val in indianCoaches:
                valObj = dict(val)
                inCoaches.append(valObj['coach_id'])
        otherCoachValues = CoachCountry.objects.filter(~Q(country_id=88)).values()
        if otherCoachValues.exists():
            for val1 in otherCoachValues:
                valObj1 = dict(val1)
                otCoaches.append(valObj1['coach_id'])
               
        indianPlans = PlanCountry.objects.filter(country_id=88).values()
        for inp in indianPlans:
            inpObj = dict(inp)
            indianPlanArr.append(inpObj['plan_id'])
        otherPlans = PlanCountry.objects.filter(~Q(country_id=88)).values()
        for otp in otherPlans:
            otpObj = dict(otp)
            otherPlanArr.append(otpObj['plan_id'])
        '''   
        if request.method == 'GET':
            cData = {}
        elif request.method == 'POST':
            cData = json.loads(request.body.decode('utf-8'))
        if india == True:
            coaches = User.objects.filter(userType=3).values('id', 'first_name', 'last_name',
                                                                                'avatar')
        else:
            coaches = User.objects.filter(userType=3).values('id', 'first_name', 'last_name',
                                                                                'avatar')

        coachs=[]                                                                      
        for coach in coaches:
            downloadcount = 0
            coacheVal = dict(coach)
            coachs.append(coacheVal['id'])
            
            coacheVal['coachId'] = coacheVal['id']
            coacheVal['coachName'] = coacheVal['first_name'] + ' ' + coacheVal['last_name']
            coacheVal['createdBy_id__first_name'] = coacheVal['first_name'] + ' ' + coacheVal['last_name']
            if coacheVal['avatar'] is None:
                coacheVal['avatar'] = 'http://stratfit.net/assets/images/user1.png'
                coacheVal['createdBy_id__avatar1'] = 'http://stratfit.net/assets/images/user1.png'
                coacheVal['createdBy_id__avatar']= 'http://stratfit.net/assets/images/user1.png'
            else:
                coacheVal['createdBy_id__avatar1'] =  coacheVal['avatar']
                coacheVal['createdBy_id__avatar'] = coacheVal['avatar']
                coacheVal['avatar'] =  coacheVal['avatar']
            if india == True:
                if 'deviceType' in cData and cData['deviceType'] == 'ios':
                    planDetails = Plan.objects.filter(createdBy_id=coacheVal['id'], planStatus=1,
                                                        activationStatus=1
                                                        ).values()
                else:
                    planDetails = Plan.objects.filter(createdBy_id=coacheVal['id'], planStatus=1,
                                                        activationStatus=1).values()
            else:
                if 'deviceType' in cData and cData['deviceType'] == 'ios':
                    planDetails = Plan.objects.filter(createdBy_id=coacheVal['id'], planStatus=1,
                                                        activationStatus=1).values()
                else:
                    planDetails = Plan.objects.filter(createdBy_id=coacheVal['id'], planStatus=1,
                                                        activationStatus=1).values()
            if planDetails.exists():
                planid=[]
                plancreatedBy=[]
                planids=[]
                for dt in planDetails:
                    planObj = dict(dt)
                    print(planObj['createdBy_id'])
                    print(planObj['id'],"getcochs")
                    plancreatedBy.append(planObj['createdBy_id'])
                    planid.append(planObj['id'])
                    
                    
                    for ids in coachs:
                        
                            
                            if ids in plancreatedBy :
                                planids.append(planObj['id'])
                                
                downloadUsersp = UserPlan.objects.filter(plan_id__in=planids).values('plan_id','user_id').annotate(total=Count('user_id')) 
                for dt in planDetails:
                    planObj = dict(dt)    
                    dictarr=[]
                    dictionary={}
                    a=[]
                    d={}
                    for j in planids:
                        for i in downloadUsersp:
                            a.append(i['total'])
                            number=len(a)
                            d['number']=number
                            
                        a=[]    
                            
                    df={}   
                    for j in planids:
                        for i in downloadUsersp:
                                
                            if j==i['plan_id']:
                                    
                                dictarr.append(i['total'])
                                num=len(dictarr)
                                dictionary[i['plan_id']]=num
                                num=[]
                        dictarr=[]

                    print(dictionary,"dictionary")
                    for num in dictionary:
                        if planObj['id'] in dictionary:

                            if planObj['id']==num:
                                coacheVal['downloaduserscount']=d['number']
                        else:
                            coacheVal['downloaduserscount']=0   
                                
                               
                    if coacheVal['coachId'] == planObj['createdBy_id']:
                        downloadusers = UserPlan.objects.filter(plan_id=planObj['id']).values(
                            'user_id').distinct().count()
                            
                        print(downloadusers,planObj['id'],"downloadusers")    
                        downloadcount = downloadcount + downloadusers
                        print(downloadcount,"downloadcount")
                        coacheVal['downloaduserscount'] = downloadcount
                    coacheVal['noOfPlans'] = len(planDetails)
                coachArr.append(coacheVal)
        '''
        if userCurrency.currencyType == "INR":
            if username['userCountry'] == 88:
                highestPriceVal = PlanCountry.objects.select_related('Plan').filter(plan_id__activationStatus=1,
                                                                                    plan_id__planStatus=1,
                                                                                    country_id=88).all().aggregate(
                    Max('plan_id__indianPrice'))['plan_id__indianPrice__max']
                highestPrice = round(highestPriceVal * inrValue)
            else:
                highestPriceVal = PlanCountry.objects.select_related('Plan').filter(plan_id__activationStatus=1,
                                                                                    plan_id__planStatus=1).filter(
                    ~Q(country_id=88)).all().aggregate(Max('plan_id__price'))['plan_id__price__max']
                highestPrice = round(highestPriceVal * inrValue)
        else:
            if username['userCountry'] == 88:
                highestPriceVal = PlanCountry.objects.select_related('Plan').filter(plan_id__activationStatus=1,
                                                                                    plan_id__planStatus=1,
                                                                                    country_id=88).all().aggregate(
                    Max('plan_id__indianPrice'))['plan_id__indianPrice__max']
                highestPrice = highestPriceVal
            else:
                highestPriceVal = PlanCountry.objects.select_related('Plan').filter(plan_id__activationStatus=1,
                                                                                    plan_id__planStatus=1).filter(
                    ~Q(country_id=88)).all().aggregate(Max('plan_id__price'))['plan_id__price__max']
                highestPrice = highestPriceVal'''
        highestPrice_dollar = Plan.objects.filter(activationStatus=1, planStatus=1).all().aggregate(Max('price'))[
            'price__max']
        coach['coachs']=coachArr,
        coach['dollar']=highestPrice_dollar
        cache.set(lookuptable_key,coach) 
        try:
            username = stratsessionutil.get_user_insession(request)
            user = username['id']
            if username != None:
                return JsonResponse({"success": True, "coachesList":coach['coachs'][0],"dollarHighest":coach['dollar'] })

            else:
                return JsonResponse({"success":False,"message":"user logged out"})                            
        except Exception as e:
            logger.exception("something wrong")
            return JsonResponse({"msg": str(e)})
        





@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getExInstructions(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        if username != None:
            exData = json.loads(request.body.decode('utf-8'))
            # print("came Herw")
            exInfo = NewExercise.objects.get(exerciseName=exData['exName'])
            instructions = exInfo.exerciseDesc
            return JsonResponse({"success": True, "Instructions": instructions})
        else:
            return JsonResponse({"success": False, "message": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})

@never_cache
def insertPlanPurposes(request):
    planPurposes = Plan.objects.values()
    purposes = PlanPurposes.objects.values()
    for val in planPurposes:
        valObj = dict(val)
        if valObj['goals'] != '' or valObj['goals'] != None:
            purposesVal = valObj['goals'].split(",")
            for dt in purposes:
                dataObj = dict(dt)
                for val1 in purposesVal:
                    if val1 == dataObj['GoalName']:
                        print(
                        "this Came Here For Testing", "-------", val1, "-----", dataObj['GoalName'], "PlanId------>",
                        valObj['id'])
                        existingPurposes = PlanGoals.objects.filter(planGoal_id=dataObj['id'], plan_id=valObj['id'])
                        if existingPurposes.exists():
                            print("Existing Goals")
                        else:
                            createPlanPurposes = PlanGoals.objects.create(
                                planGoal_id=dataObj['id'],
                                plan_id=valObj['id'],
                                createdBy_id=6,
                                modifiedBy_id=6
                            )
                            createPlanPurposes.save()
    return JsonResponse({"success": True, "message": "records inserted successfully"})

@never_cache
def insertPlanAbilities(request):
    planPurposes = Plan.objects.values()
    abilities = PlanAbilities.objects.values()
    for val in planPurposes:
        valObj = dict(val)
        if valObj['ability'] != '' or valObj['ability'] != None:
            abilityVal = valObj['ability'].split(",")
            for dt in abilities:
                dataObj = dict(dt)
                for val1 in abilityVal:
                    if val1 == dataObj['ability']:
                        print(
                        "this Came Here For Testing", "-------", val1, "-----", dataObj['ability'], "PlanId------>",
                        valObj['id'])
                        existingAbilities = SelectedAbilities.objects.filter(ability_id=dataObj['id'],
                                                                             plan_id=valObj['id'])
                        if existingAbilities.exists():
                            print("Existing Abilities")
                        else:
                            createPlanAbilities = SelectedAbilities.objects.create(
                                ability_id=dataObj['id'],
                                plan_id=valObj['id'],
                                createdBy_id=6,
                                modifiedBy_id=6
                            )
                            createPlanAbilities.save()
    return JsonResponse({"success": True, "message": "records inserted successfully"})




@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def sendForReview(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        data = json.loads(request.body.decode('utf-8'))
        if username != None:
            print("here")
            updatedraftedPlan = DraftedPlan.objects.get(planId=data['plan_id'])
            updatedraftedPlan.status = True
            updatedraftedPlan.save()
            reviewdComments = PlanComments.objects.filter(plan_id=data['plan_id']).values().last()
            if reviewdComments:
                updateStatus = PlanComments.objects.get(id=reviewdComments['id'])
                updateStatus.status = 0
                updateStatus.save()
            return JsonResponse({"success": True, "message": "Review Submitted Successfully"})
        else:
            return JsonResponse({"success": False, "message": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})


@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def programsTobeReviewed(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        if username != None:
            if username['userType'] == 1 and username['is_superuser'] == 1:

                if 'rows' in request.POST and request.POST['rows'] != '':
                    rows = int(request.POST['rows'])
                else:
                    rows = PAGING_ROWS
                if 'page' in request.POST and request.POST['page'] != '':
                    page = int(request.POST['page'])
                else:
                    page = 1
                offset = (page - 1) * rows
                tot = page * rows

                programs = DraftedPlan.objects.select_related('Plan__id', 'User').filter(status=1,
                                                                                         planId__planStatus=0).values(
                    'planId__planStatus', 'status', 'planId_id__planName', 'planId_id__price', 'planId_id',
                    'planId_id__planDescription', 'planId_id__createdBy_id', 'planId_id__originalPlanner_id',
                    'planId_id__originalPlanId_id', 'planId_id__licencePolicy',
                    'planId_id__originalPlanner_id__first_name', 'planId_id__originalPlanner_id__last_name',
                    'planId_id__advPlan')
                reviewPrograms = []
                total = len(programs)
                if programs.exists():
                    data = programs[offset:tot]
                    for val in data:
                        proObj = dict(val)
                        proObj['liscenceStatus'] = 0
                        proObj['coachName'] = proObj['planId_id__originalPlanner_id__first_name'] + " " + proObj[
                            'planId_id__originalPlanner_id__last_name']
                        if proObj['planId_id__originalPlanner_id'] != proObj['planId_id__createdBy_id']:
                            proObj['licencePolicy'] = proObj['planId_id__licencePolicy']
                            proObj['liscenceStatus'] = 1
                        else:
                            proObj['licencePolicy'] = "Direct Selling"
                        procomments = PlanComments.objects.filter(plan_id=proObj['planId_id']).values().last()
                        if procomments:
                            proObj['reiviewStatus'] = procomments['status']
                            proObj['review'] = procomments['reiviewComments']
                        else:
                            proObj['reiviewStatus'] = 0
                            proObj['review'] = ''
                        reviewPrograms.append(proObj)
                return JsonResponse({"success": True, "rows": reviewPrograms, "total": total})
            else:
                return JsonResponse({"success": False, "message": "Invalid User"})
        else:
            return JsonResponse({"success": False, "message": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})


@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def createPlanComments(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        data = json.loads(request.body.decode('utf-8'))
        if username != None:
            print("x")
            createplancom = PlanComments.objects.create(
                plan_id=data['plan_id'],
                reiviewComments=data['comments'],
                status=1
            )
            createplancom.save()
            return JsonResponse({"success": True, "message": "Comments Saved Successfully"})
        else:
            return JsonResponse({"success": False, "message": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def createEXComments(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        data = json.loads(request.body.decode('utf-8'))
        if username != None:
            print("x")
            if 'status' in data and data['status'] == 2:
                createplancom = PlanExComments.objects.create(
                    Exercise_id=data['ex_id'],
                    reiviewComments=data['comments'],
                    status=1
                )
                createplancom.save()
                exstatus = NewExercise.objects.get(id=data['ex_id'])
                exstatus.exerciseStatus = data['status']
                exstatus.save()
                return JsonResponse({"success": True, "message": "Comments Saved Successfully"})
            else:
                exstatus = NewExercise.objects.get(id=data['ex_id'])
                exstatus.exerciseStatus = data['status']

                exstatus.save()
                return JsonResponse({"success": True, "message": "Exercise activated successfuly"})
        else:
            return JsonResponse({"success": False, "message": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})


@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def reviewsofplan(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        data = json.loads(request.body.decode('utf-8'))
        if username != None:
            print("x")
            comments = PlanComments.objects.filter(plan_id=data['plan_id']).values().last()
            return JsonResponse({"success": True, "message": comments['reiviewComments']})
        else:
            return JsonResponse({"success": False, "message": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})


@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getPlanPrices(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        if username != None:
            arr = []
            planDetails = DraftedPlan.objects.select_related('Plan__id', 'User__id').filter(status=1,
                                                                                            planId__planStatus=0).values(
                'planId__id', 'planId__price', 'planId__indianPrice', 'planId__indianIosPrice', 'planId__iosPrice',
                'planId__planStatus', 'planId__iosStatus', 'planId__planName', 'planId__planLogo',
                'planId__programType_id', 'planId__planPhoto', 'createdBy__avatar', 'createdBy__first_name',
                'createdBy__last_name', 'planId__planDescription')
            for val in planDetails:
                valObj = dict(val)
                print(valObj['planId__iosPrice'])
                if valObj['planId__iosPrice'] != 0:
                    iosPriceval = PriceMapping.objects.get(inr=valObj['planId__iosPrice'])
                    if iosPriceval:
                        valObj['planId__iosPrice'] = iosPriceval.usd
                if valObj['planId__indianIosPrice'] != 0:
                    indianiosPriceval = PriceMapping.objects.get(inr=valObj['planId__indianIosPrice'])
                    if indianiosPriceval:
                        valObj['planId__indianIosPrice'] = indianiosPriceval.usd
                    else:
                        valObj['planId__indianIosPrice'] = 0
                arr.append(valObj)
            return JsonResponse({"success": True, "details": arr})
        else:
            return JsonResponse({"success": False, "message": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})




@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def updatePlanPrices(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        if username != None:
            data = json.loads(request.body.decode('utf-8'))
            planDetails = Plan.objects.get(id=data['planId__id'])
            # planDetails.iosPrice = data['iosPrice']
            iosPriceval = PriceMapping.objects.get(usd=data['planId__iosPrice'])
            if iosPriceval:
                planDetails.iosPrice = iosPriceval.inr
            else:
                planDetails.iosPrice = 0
            indianiosPriceval = PriceMapping.objects.get(usd=data['planId__indianIosPrice'])
            if indianiosPriceval:
                planDetails.indianIosPrice = indianiosPriceval.inr
            else:
                planDetails.indianIosPrice = 0
            # inrvalue = PriceConversion.objects.get(id=1)
            # planDetails.indianIosPrice = data['planId__indianIosPrice']*inrvalue.inrValue
            planDetails.indianPrice = data['planId__indianPrice']
            planDetails.iosStatus = data['planId__iosStatus']
            planDetails.save()
            return JsonResponse({"success": True, "message": "Plan details updated successfully"})
        else:
            return JsonResponse({"success": False, "message": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})


@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getPublishedPlanPrices(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        if username != None:
            arr = []
            planDetails = DraftedPlan.objects.select_related('Plan__id', 'User__id').filter(status=1,
                                                                                            planId__planStatus=1).values(
                'planId__id', 'planId__price', 'planId__indianPrice', 'planId__indianIosPrice', 'planId__iosPrice',
                'planId__planStatus', 'planId__iosStatus', 'planId__planName', 'planId__planLogo',
                'planId__programType_id', 'planId__planPhoto', 'createdBy__avatar', 'createdBy__first_name',
                'createdBy__last_name', 'planId__planDescription')
            for val in planDetails:
                valObj = dict(val)
                print(valObj['planId__iosPrice'])
                if valObj['planId__iosPrice'] != 0:
                    iosPriceval = PriceMapping.objects.get(inr=valObj['planId__iosPrice'])
                    if iosPriceval:
                        valObj['planId__iosPrice'] = iosPriceval.usd
                if valObj['planId__indianIosPrice'] != 0:
                    indianiosPriceval = PriceMapping.objects.get(inr=valObj['planId__indianIosPrice'])
                    if indianiosPriceval:
                        valObj['planId__indianIosPrice'] = indianiosPriceval.usd
                    else:
                        valObj['planId__indianIosPrice'] = 0
                arr.append(valObj)
            return JsonResponse({"success": True, "details": arr})
        else:
            return JsonResponse({"success": False, "message": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})


def store(request):
    india = False
    currencyValues = PriceConversion.objects.get(id=1)
    inrValue = currencyValues.inrValue
    x = connection.cursor()
    planArr = []
    query = "SELECT Program_plan.*, Program_plan.goals as planGoal__goalName, utility_programtype.programTypeName as planType,Subscriber_user.first_name as createdBy_id__first_name,Subscriber_user.last_name as createdBy_id__last_name,Program_plan.goals as planGoal,Program_plan.price as planPrice,Program_plan.originalPlanner_id as originalPlanner,Program_plan.createdBy_id as createdBy,utility_programtype.programTypeName as programType__programTypeName,Subscriber_user.avatar as createdBy_id__avatar,Subscriber_user.id as coachId FROM Program_plan left join utility_programtype on Program_plan.programType_id = utility_programtype.id left join Subscriber_user on Program_plan.createdBy_id = Subscriber_user.id left join Program_selectedabilities on Program_plan.id = Program_selectedabilities.plan_id left join Program_plangoals on Program_plan.id = Program_plangoals.plan_id left join Program_plancountry on Program_plan.id = Program_plancountry.plan_id "
    '''
    g = GeoIP2()
    ip = request.META.get('REMOTE_ADDR', None)
    if ip:
        country = g.country(ip)['country_name']
    else:
        country = 'India'  # default city
    '''
    country = 'India'    
    countryName = Country.objects.get(name=country)
    countryId = countryName.id
    if countryId == 88:
        india = True
    if india == True:
        query += " where Program_plancountry.country_id = 88 and "
    else:
        query += " where Program_plancountry.country_id != 88 and "
    query += " Program_plan.id is not null and activationStatus=1 and planStatus=1  GROUP BY Program_selectedabilities.plan_id,Program_plangoals.plan_id ORDER BY Program_plan.programType_id,Program_plan.planName ASC"
    x.execute(query)
    resultQuery = dictfetchall(x)
    for dt in resultQuery:
        dataObj = dict(dt)
        secret_code_plain = dataObj['planName'] + '#' + str(dataObj['id'])
        secret_code_encode = base64.b64encode(secret_code_plain.encode('ascii'))
        encodedVal = str(secret_code_encode).split("'")
        dataObj['encodedurl'] = encodedVal[1]

        dataObj['coachName'] = dataObj['createdBy_id__first_name'] + " " + dataObj['createdBy_id__last_name']
        dataObj['createdBy_id__first_name'] = dataObj['createdBy_id__first_name'] + " " + dataObj[
            'createdBy_id__last_name']
        if int(dataObj['price']) == 0:
            dataObj['price'] = "Free"
        else:
            if india == True:
                dataObj['price'] = round((dataObj['indianPrice']) * float(inrValue))
                dataObj['planPrice'] = dataObj['price']

            else:
                dataObj['planPrice'] = dataObj['price']
                # dataObj['iosPrice'] = round(float(dataObj['iosPrice'])*float(inrValue))
        # if dataObj['originalPlanner'] == dataObj['createdBy_id']:
        if dataObj['planType'] == "STARTER":
            dataObj['planType'] = "Beginner"
            dataObj['ptype'] = 'S'
        elif dataObj['planType'] == "INTERMEDIATE":
            dataObj['ptype'] = 'I'
        elif dataObj['planType'] == "ADVANCED":
            dataObj['ptype'] = 'A'
        coachName1 = User.objects.get(id=dataObj['originalPlanner'])
        dataObj['oriCoachName'] = str(coachName1.first_name) + " " + str(coachName1.last_name)
        planAbilityVal = SelectedAbilities.objects.select_related('PlanAbilities').filter(plan_id=dataObj['id']).values(
            'ability_id__ability')
        abilities = ''
        abilities1 = ''
        for val in planAbilityVal:
            valObj = dict(val)
            abilities += ", " + valObj['ability_id__ability']
            abilities1 += ", " + valObj['ability_id__ability']
        if abilities != '':
            planAbilities = abilities[1:]
            planAbilities1 = abilities[1:]
        else:
            planAbilities = ""
            planAbilities1 = ""

        planPurposesVal = PlanGoals.objects.select_related('PlanPurposes').filter(plan_id=dataObj['id']).values(
            'planGoal_id__GoalName')
        purposes = ''
        purposes1 = ''
        for val in planPurposesVal:
            valObj = dict(val)
            purposes += ", " + valObj['planGoal_id__GoalName']
            purposes1 += ", " + valObj['planGoal_id__GoalName']
        if purposes != '':
            planGoals = purposes[1:]
            planGoals1 = purposes[1:]
        else:
            planGoals = ""
            planGoals1 = ""
        '''if len(planGoals) > 30:
            planGoals = planGoals[:27]
            planGoals += "..."
        if len(planAbilities) > 33:
            if planAbilities[31] == ",":
                planAbilities = planAbilities[:30]
            else:
                planAbilities = planAbilities[:31]
                planAbilities = planAbilities.split(",")
                if len(planAbilities) > 1:
                    planAbilities = planAbilities[0] + planAbilities[1] + "..."
                else:
                    planAbilities = planAbilities[0] + "..."'''
        dataObj['planDescription'] = dataObj['planDescription'] + "<br><br><font><b>Abilities:</b> " + str(
            planAbilities1) + "</font>" + "<br><br><font><b>Purposes:</b> " + str(planGoals) + "</font>"
        if dataObj['licencePolicy'] == "3" or dataObj['licencePolicy'] == "White-Label":
            partnerName = User.objects.get(id=dataObj['createdBy_id'])
            dataObj['planDescription'] = str(dataObj['planDescription']) + "<br><h6>Copyright &copy; 2017 " + str(
                str(partnerName.first_name) + " " + str(partnerName.last_name)) + ". All rights reserved.</h6>"
        else:
            coachName = User.objects.get(id=dataObj['originalPlanner'])
            dataObj['planDescription'] = str(dataObj['planDescription']) + "<br><h6>Copyright &copy; 2017 " + str(
                str(coachName.first_name) + " " + str(coachName.last_name)) + ". All rights reserved.</h6>"
        downloadUsers = UserPlan.objects.filter(plan_id=dataObj['id']).values('user_id').distinct().count()
        ratingObj = PlanRating.objects.filter(plan=dataObj['id']).values()
        totalRate = 0
        userCount = 1
        for rt in ratingObj:
            rateObj = dict(rt)
            totalRate = totalRate + rateObj['rating']
            userCount = userCount + 1
        rating = totalRate / userCount
        dataObj['PlanRating'] = rating
        dataObj['planPurpose'] = planAbilities
        dataObj['ability'] = planAbilities
        dataObj['ability1'] = planAbilities1
        dataObj['plan_goals'] = planGoals
        dataObj['plan_goals1'] = planGoals1
        dataObj['planCompetency'] = "0"
        dataObj['planUsers'] = downloadUsers
        planArr.append(dataObj)
    return JsonResponse({"success": True, "filterValues": planArr, "india": india})


def coachPlans(request):
    india = False
    currencyValues = PriceConversion.objects.get(id=1)
    inrValue = currencyValues.inrValue
    indianPlanArr = []
    otherPlanArr = []
    coachInfo = json.loads(request.body.decode('utf-8'))
    g = GeoIP2()
    ip = request.META.get('REMOTE_ADDR', None)
    if ip:
        country = g.country(ip)['country_name']
    else:
        country = 'India'  # default city
    countryName = Country.objects.get(name=country)
    countryId = countryName.id
    if countryId == 88:
        india = True
    indianPlans = PlanCountry.objects.filter(country_id=88).values()
    for inp in indianPlans:
        inpObj = dict(inp)
        indianPlanArr.append(inpObj['plan_id'])
    otherPlans = PlanCountry.objects.filter(~Q(country_id=88)).values()
    for otp in otherPlans:
        otpObj = dict(otp)
        otherPlanArr.append(otpObj['plan_id'])
    if india == True:
        planDetails = Plan.objects.select_related('Goals__id', 'ProgramType__id', 'User__id').values('id', 'planName',
                                                                                                     'planPhoto',
                                                                                                     'price',
                                                                                                     'planGoal__goalName',
                                                                                                     'planDescription',
                                                                                                     'programType__programTypeName',
                                                                                                     'programType__id',
                                                                                                     'duration_weeks',
                                                                                                     'createdBy_id',
                                                                                                     'ability',
                                                                                                     'createdBy_id__avatar',
                                                                                                     'createdBy_id__first_name',
                                                                                                     'createdBy_id__last_name',
                                                                                                     'planStatus',
                                                                                                     'planLogo',
                                                                                                     'originalPlanner_id',
                                                                                                     'licencePolicy',
                                                                                                     'iosPrice',
                                                                                                     'iosStatus',
                                                                                                     'indianIosPrice',
                                                                                                     'indianPrice',
                                                                                                     'createdBy_id__userCover').filter(
            createdBy=coachInfo['coachid'], planStatus=1, activationStatus=1,
            id__in=indianPlanArr).order_by('programType_id', 'planName')
    else:
        planDetails = Plan.objects.select_related('Goals__id', 'ProgramType__id', 'User__id').values('id', 'planName',
                                                                                                     'planPhoto',
                                                                                                     'price',
                                                                                                     'planGoal__goalName',
                                                                                                     'planDescription',
                                                                                                     'programType__programTypeName',
                                                                                                     'programType__id',
                                                                                                     'duration_weeks',
                                                                                                     'createdBy_id',
                                                                                                     'ability',
                                                                                                     'createdBy_id__avatar',
                                                                                                     'createdBy_id__first_name',
                                                                                                     'createdBy_id__last_name',
                                                                                                     'planStatus',
                                                                                                     'planLogo',
                                                                                                     'originalPlanner_id',
                                                                                                     'licencePolicy',
                                                                                                     'iosPrice',
                                                                                                     'iosStatus',
                                                                                                     'indianIosPrice',
                                                                                                     'indianPrice',
                                                                                                     'createdBy_id__userCover').filter(
            createdBy=coachInfo['coachid'], planStatus=1, activationStatus=1, 
            id__in=otherPlanArr).order_by('programType_id', 'planName')
    planArr = []
    planValArr = []
    planCoaches = []
    totalusercount = 0
    for dt in planDetails:
        dataObj = dict(dt)

        secret_code_plain = dataObj['planName'] + '#' + str(dataObj['id'])
        secret_code_encode = base64.b64encode(secret_code_plain.encode('ascii'))
        encodedVal = str(secret_code_encode).split("'")
        dataObj['encodedurl'] = encodedVal[1]

        trainerDetails = trainerProfile.objects.filter(user_id=dataObj['createdBy_id']).values()
        if trainerDetails.exists():
            for tr in trainerDetails:
                trObj = dict(tr)
            dataObj['aboutTrainer'] = trObj['aboutTrainer']
        else:
            dataObj['aboutTrainer'] = "Trainer Content Unavailable"

        dataObj['coachName'] = dataObj['createdBy_id__first_name'] + " " + dataObj['createdBy_id__last_name']
        dataObj['planPrice'] = dataObj['price']
        if int(dataObj['price']) == 0:
            dataObj['price'] = "Free"
        else:
            if india == True:
                dataObj['price'] = round((dataObj['indianPrice']) * float(inrValue))
                dataObj['planPrice'] = dataObj['price']
        planAbilityVal = SelectedAbilities.objects.select_related('PlanAbilities').filter(plan_id=dataObj['id']).values(
            'ability_id__ability')
        abilitieslists = ''
        for val in planAbilityVal:
            valObj = dict(val)
            abilitieslists += ", " + valObj['ability_id__ability']
        if abilitieslists != '':
            planAbilities = abilitieslists[1:]
        else:
            planAbilities = ""
        planPurposesVal = PlanGoals.objects.select_related('PlanPurposes').filter(plan_id=dataObj['id']).values(
            'planGoal_id__GoalName')
        purposes = ''
        for val in planPurposesVal:
            valObj = dict(val)
            purposes += ", " + valObj['planGoal_id__GoalName']
        if purposes != '':
            planGoals = purposes[1:]
        else:
            planGoals = ""
        if dataObj['originalPlanner_id'] != dataObj['createdBy_id']:
            coachVal = User.objects.get(id=dataObj['originalPlanner_id'])
            coachName = coachVal.first_name
            dataObj['oriCoachName'] = coachName
        dataObj['planDescription'] = dataObj['planDescription'] + "<br><br><font><b>Abilities:</b> " + str(
            planAbilities) + "</font>" + "<br><br><font><b>Purposes:</b> " + str(planGoals) + "</font>"
        if dataObj['licencePolicy'] == "3" or dataObj['licencePolicy'] == "White-Label":
            partnerName = User.objects.get(id=dataObj['createdBy_id'])
            dataObj['planDescription'] = str(dataObj['planDescription']) + "<br><h6>Copyright &copy; 2017 " + str(
                str(partnerName.first_name) + " " + str(partnerName.last_name)) + ". All rights reserved.</h6>"
        else:
            if dataObj['originalPlanner_id'] != dataObj['createdBy_id']:
                coachVal = User.objects.get(id=dataObj['originalPlanner_id'])
                coachName = coachVal.first_name + " " + coachVal.last_name
                dataObj['oriCoachName'] = coachName
            coachName = User.objects.get(id=dataObj['originalPlanner_id'])
            dataObj['planDescription'] = str(dataObj['planDescription']) + "<br><h6>Copyright &copy; 2017 " + str(
                str(coachName.first_name) + " " + str(coachName.last_name)) + ". All rights reserved.</h6>"
        downloadUsers = UserPlan.objects.filter(plan_id=dataObj['id']).values('user_id').distinct().count()
        ratingObj = PlanRating.objects.filter(plan=dataObj['id']).values()
        totalRate = 0
        userCount = 1
        for rt in ratingObj:
            rateObj = dict(rt)
            totalRate = totalRate + rateObj['rating']
            userCount = userCount + 1
        rating = totalRate / userCount
        planCoaches.append(dataObj['createdBy_id'])
        dataObj['planPurpose'] = planAbilities
        dataObj['plan_goals'] = planGoals
        dataObj['planType'] = dataObj['programType__programTypeName']
        dataObj['planCompetency'] = "0"
        dataObj['planUsers'] = downloadUsers
        totalusercount = totalusercount + int(downloadUsers)
        dataObj['PlanRating'] = rating
        dataObj['coachId'] = dataObj['createdBy_id']
        dataObj['planGoal'] = dataObj['planGoal__goalName']
        dataObj['planLevel'] = dataObj['programType__id']

        if dataObj['planType'] == "STARTER":
            dataObj['ptype'] = 'S'
            dataObj['planType'] = "BEGINNER"
        elif dataObj['planType'] == "INTERMEDIATE":
            dataObj['ptype'] = 'I'
        elif dataObj['planType'] == "ADVANCED":
            dataObj['ptype'] = 'A'

        
        dataObj['planDuration'] = dataObj['duration_weeks']
        dataObj['coachId'] = dataObj['createdBy_id']
        planArr.append(dataObj)
    planVideos = PlanVideos.objects.select_related('Videos__id').values('video__videoLink', 'plan_id')
    planVideoArr = []
    for video in planVideos:
        videos = dict(video)
        videos['videolink'] = 'QR77PiSkDgA'
        planVideoArr.append(videos)
    coachDetails = User.objects.filter(id__in=planCoaches).values()
    coachArr = []
    for coach in coachDetails:
        coach_id = dict(coach)
        followCnt = Userfollow.objects.filter(followerUser_id=coach_id['id'], status=1).count()
        coach_id['followers'] = followCnt
        trainers = trainerProfile.objects.filter(user_id=coach_id['id']).values()
        for tr in trainers:
            trainer = dict(tr)
        if coach_id['userCover'] is not None:
            coach_id['coachThumbnail'] = coach_id['userCover']
        else:
            coach_id['coachThumbnail'] = ''
        coach_id['coachId'] = coach['id']
        coach_id['coachName'] = coach['first_name'] + ' ' + coach['last_name']
        coachPlansArr = []
        plans = Plan.objects.filter(createdBy_id=coach_id['id']).values('id')
        for pl in plans:
            coachPlans = dict(pl)
            coachPlansArr.append(coachPlans['id'])
        coach_id['coachPlans'] = coachPlansArr
        userAddress = UserAddress.objects.filter(user_id=coach_id['id']).values()
        if userAddress.exists():
            for ua in userAddress:
                uAddr = dict(ua)
                if uAddr['country'] == 83:
                    coach_id['coachLocation'] = 'India'
                else:
                    coach_id['coachLocation'] = 'International'
        else:
            coach_id['coachLocation'] = 'India'
        coachArr.append(coach_id)
    return JsonResponse({"success": True, "details": planArr, "Videos": planVideoArr, "allCoaches": coachArr,
                         "totalcount": totalusercount, "plans": planValArr, "india": india})

def goo_shorten_url(request):
    urls = []
    # url = "http://stratfit.net/#/planprofile/MyB4IDMgSU5URVJNRURJQVRFIzY0/utm_source=Twitter&utm_medium=Link&utm_term=Organic&utm_name=3 X 3 INTERMEDIATE-2"
    planVal = Plan.objects.filter(planStatus=1).values()
    for val in planVal:
        dataObj = dict(val)
        planId = dataObj['id']
        planName = dataObj['planName']

        secret_code_plain = dataObj['planName'] + '#' + str(dataObj['id'])
        secret_code_encode = base64.b64encode(secret_code_plain.encode('ascii'))
        encodedVal = str(secret_code_encode).split("'")
        dataObj['encodedurl'] = encodedVal[1]

        utm_source = "Facebook"
        utm_source1 = "Twitter"
        utm_source2 = "Instagram"

        utm_name = planName

        url = "http://stratfit.net/#/planprofile/" + str(dataObj['encodedurl'])
        url1 = url + "/" + "utm_source=" + utm_source + "&utm_medium=Link&utm_term=Organic&utm_name=" + utm_name
        url2 = url + "/" + "utm_source=" + utm_source1 + "&utm_medium=Link&utm_term=Organic&utm_name=" + utm_name
        url3 = url + "/" + "utm_source=" + utm_source2 + "&utm_medium=Link&utm_term=Organic&utm_name=" + utm_name

        urls.append({"url": url1, "planId": planId})
        urls.append({"url": url2, "planId": planId})
        urls.append({"url": url3, "planId": planId})

    if len(urls) > 1:
        for ul in urls:
            urlVal = ul['url']
            planVal = ul['planId']
            post_url = 'https://www.googleapis.com/urlshortener/v1/url?key={}'.format(
                "AIzaSyAXaSWj7trNg8Pq3PdBiOSHirnjcZlIZSo")
            payload = {'longUrl': urlVal}
            headers = {'content-type': 'application/json'}
            r = requests.post(post_url, data=json.dumps(payload), headers=headers)
            result = r.json()
            print(r.text)
            checkShortUrls = PlanShortUrls.objects.filter(shortUrl=result['id'])
            if checkShortUrls.exists():
                print("exists")
            else:
                createShortUrls = PlanShortUrls.objects.create(
                    plan_id=planVal,
                    shortUrl=result['id'],
                    longUrl=urlVal
                )
                createShortUrls.save()
        return JsonResponse({"success": True, "details": "Results Inserted Successfully"})
    else:
        return JsonResponse({"success": False, "details": "Empty Set"})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def filter_ability(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        # print(username)
        if username != None:
            currencyType = username['currencyType']
            currencyValues = PriceConversion.objects.get(id=1)
            inrValue = currencyValues.inrValue
            requestJson = json.loads(request.body.decode('utf-8'))
            abilities = []
            planArr = []
            x = connection.cursor()
            userid = username['id']
            userCurrency = User.objects.get(id=userid)
            query = "SELECT Plan_plan.*, Plan_plan.goals as planGoal__goalName, utility_programtype.programTypeName as planType,Subscriber_user.first_name as createdBy_id__first_name,Subscriber_user.last_name as createdBy_id__last_name,Plan_plan.goals as planGoal,Plan_plan.price as planPrice,Plan_plan.originalPlanner_id as originalPlanner,Plan_plan.createdBy_id as createdBy,utility_programtype.programTypeName as programType__programTypeName,Subscriber_user.avatar as createdBy_id__avatar,Subscriber_user.id as coachId FROM Plan_plan left join utility_programtype on Plan_plan.programType_id = utility_programtype.id left join Subscriber_user on Plan_plan.createdBy_id = Subscriber_user.id left join Plan_selectedabilities on Plan_plan.id = Plan_selectedabilities.plan_id left join Plan_plangoals on Plan_plan.id = Plan_plangoals.plan_id left join Plan_plancountry on Plan_plan.id = Plan_plancountry.plan_id "
            if username['userCountry'] == 88:
                query += " where Plan_plancountry.country_id = 88 and "
            else:
                query += " where Plan_plancountry.country_id != 88 and "
            if requestJson['categoryLevel'] == "1":
                query += " Plan_plan.id is not null and activationStatus=1 and planStatus=1  and Plan_plan.programType_id = 1 GROUP BY Plan_plan.id, Plan_selectedabilities.plan_id,Plan_plangoals.plan_id ORDER BY Plan_plan.programType_id,Plan_plan.planName ASC"
            else:
                categories = CategoryLevel.objects.filter(category=requestJson['categoryLevel']).values()
                for val in categories:
                    valObj = dict(val)
                    abilities.append(str(valObj['mappedAbility_id']))
                query += " Plan_plan.id is not null and activationStatus=1 and planStatus=1  and Plan_selectedabilities.ability_id in ( " + ','.join(
                    abilities) + " ) GROUP BY Plan_plan.id, Plan_selectedabilities.plan_id,Plan_plangoals.plan_id ORDER BY Plan_plan.programType_id,Plan_plan.planName ASC"
            print(query, "--------------------------SG")
            x.execute(query)
            resultQuery = dictfetchall(x)
            # highestPrice= Plan.objects.filter(activationStatus=1, planStatus=1).all().aggregate(Max('price'))['price__max']
            highestPrice_dollar = Plan.objects.filter(activationStatus=1, planStatus=1).all().aggregate(Max('price'))[
                'price__max']
            if userCurrency.currencyType == "INR":
                if username['userCountry'] == 88:
                    highestPriceVal = PlanCountry.objects.select_related('Plan').filter(plan_id__activationStatus=1,
                                                                                        plan_id__planStatus=1,
                                                                                        country_id=88).all().aggregate(
                        Max('plan_id__indianPrice'))['plan_id__indianPrice__max']
                    highestPrice = round(highestPriceVal * float(inrValue))
                else:
                    highestPriceVal = PlanCountry.objects.select_related('Plan').filter(plan_id__activationStatus=1,
                                                                                        plan_id__planStatus=1,
                                                                                        country_id=88).all().aggregate(
                        Max('plan_id__price'))['plan_id__price__max']
                    highestPrice = round(highestPriceVal * float(inrValue))
            else:
                if username['userCountry'] == 88:
                    highestPriceVal = PlanCountry.objects.select_related('Plan').filter(plan_id__activationStatus=1,
                                                                                        plan_id__planStatus=1,
                                                                                        country_id=88).all().aggregate(
                        Max('plan_id__indianPrice'))['plan_id__indianPrice__max']
                    highestPrice = round(highestPriceVal)
                else:
                    highestPriceVal = PlanCountry.objects.select_related('Plan').filter(plan_id__activationStatus=1,
                                                                                        plan_id__planStatus=1,
                                                                                        country_id=88).all().aggregate(
                        Max('plan_id__price'))['plan_id__price__max']
                    highestPrice = round(highestPriceVal)
            clelebLikeArr = []
            celebreviewArr = []
            for dt in resultQuery:
                dataObj = dict(dt)

                planurls = PlanShortUrls.objects.filter(plan_id=dataObj['id']).values()
                if planurls.exists():
                    for val in planurls:
                        valObj = dict(val)
                        urlVal = valObj['longUrl'].split('/')
                        urlVal1 = urlVal[6].split('=')
                        urlVal2 = urlVal1[1].split('&')
                        dataObj[urlVal2[0]] = valObj['shortUrl']

                plalikescount = CelebrityPlansLikes.objects.filter(plan_id=dataObj['id'], status=1).count()
                reviewscount = CelebrityPlansLikes.objects.filter(plan_id=dataObj['id']).exclude(
                    reviews__isnull=True).exclude(reviews__exact='').count()
                dataObj['planlikesCount'] = plalikescount
                dataObj['reviewsCount'] = reviewscount

                #clelebLikes = celeblikes(dataObj['id'])
                #celebReviews = celebreviewList(dataObj['id'])
                #dataObj['planlikes'] = clelebLikes
                #dataObj['planreviews'] = celebReviews
                # print(dataObj['planreviews'],"here")

                dataObj['celeblikedPlan'] = 0
                dataObj['celebreviewPlan'] = 0
                dataObj['reviews'] = ''
                # if username['userType'] == 8:
                #celebplanlikes = CelebrityPlansLikes.objects.filter(plan_id=dataObj['id'], user_id=username['id'],status=1).values()
                #if celebplanlikes.exists():
                #    dataObj['celeblikedPlan'] = 1
                #celebplanreviews = CelebrityPlansLikes.objects.filter(plan_id=dataObj['id'],user_id=username['id']).values()
                #if celebplanreviews.exists():
                #    for celbdt in celebplanreviews:
                #        celbObj = dict(celbdt)
                #        if celbObj['reviews'] != '' and celbObj['reviews'] != None:
                #            dataObj['reviews'] = celbObj['reviews']
                #            dataObj['celebreviewPlan'] = 1

                secret_code_plain = dataObj['planName'] + '#' + str(dataObj['id'])
                secret_code_encode = base64.b64encode(secret_code_plain.encode('ascii'))
                encodedVal = str(secret_code_encode).split("'")
                dataObj['encodedurl'] = encodedVal[1]

                dataObj['coachName'] = dataObj['createdBy_id__first_name'] + " " + dataObj['createdBy_id__last_name']
                dataObj['createdBy_id__first_name'] = dataObj['createdBy_id__first_name'] + " " + dataObj[
                    'createdBy_id__last_name']
                if 'deviceType' in requestJson and requestJson['deviceType'] == 'ios':
                    if userCurrency.currencyType == "INR":
                        if username['userCountry'] == 88:
                            highestPrice = \
                            PlanCountry.objects.select_related('Plan').filter(plan_id__activationStatus=1,
                                                                              plan_id__planStatus=1,
                                                                              country_id=88).all().aggregate(
                                Max('plan_id__indianIosPrice'))['plan_id__indianIosPrice__max']
                            dataObj['price'] = dataObj['indianIosPrice']
                            dataObj['planPrice'] = dataObj['price']
                        else:
                            highestPrice = \
                            PlanCountry.objects.select_related('Plan').filter(plan_id__activationStatus=1,
                                                                              plan_id__planStatus=1).filter(
                                ~Q(country_id=88)).all().aggregate(Max('plan_id__iosPrice'))['plan_id__iosPrice__max']
                            dataObj['price'] = dataObj['iosPrice']
                            dataObj['planPrice'] = dataObj['price']
                        if int(dataObj['price']) == 0:
                            dataObj['price'] = "Free"
                    else:
                        if username['userCountry'] == 88:
                            highestPriceVal = \
                            PlanCountry.objects.select_related('Plan').filter(plan_id__activationStatus=1,
                                                                              plan_id__planStatus=1,
                                                                              country_id=88).all().aggregate(
                                Max('plan_id__indianIosPrice'))['plan_id__indianIosPrice__max']
                            print(highestPriceVal)
                            highestVal = PriceMapping.objects.get(inr=highestPriceVal)
                            highestPrice = highestVal.usd
                            usdValue = PriceMapping.objects.values().filter(inr=dataObj['indianIosPrice'])
                        else:
                            highestPriceVal = \
                            PlanCountry.objects.select_related('Plan').filter(plan_id__activationStatus=1,
                                                                              plan_id__planStatus=1).filter(
                                ~Q(country_id=88)).all().aggregate(Max('plan_id__iosPrice'))['plan_id__iosPrice__max']
                            highestVal = PriceMapping.objects.get(inr=highestPriceVal)
                            highestPrice = highestVal.usd
                            usdValue = PriceMapping.objects.values().filter(inr=dataObj['iosPrice'])
                        for usd in usdValue:
                            usdObj = dict(usd)
                            dollarVal = usdObj['usd']
                        dataObj['price'] = dollarVal
                        if float(dataObj['price']) == 0:
                            dataObj['price'] = "Free"
                else:
                    if int(dataObj['price']) == 0:
                        dataObj['price'] = "Free"
                    else:
                        if userCurrency.currencyType == "INR":
                            if username['userCountry'] == 88:
                                highestPriceVal = \
                                PlanCountry.objects.select_related('Plan').filter(plan_id__activationStatus=1,
                                                                                  plan_id__planStatus=1,
                                                                                  country_id=88).all().aggregate(
                                    Max('plan_id__indianPrice'))['plan_id__indianPrice__max']
                                highestPrice = round(highestPriceVal * inrValue)
                                dataObj['price'] = round((dataObj['indianPrice']) * float(inrValue))
                                dataObj['planPrice'] = dataObj['price']
                            else:
                                highestPriceVal = \
                                PlanCountry.objects.select_related('Plan').filter(plan_id__activationStatus=1,
                                                                                  plan_id__planStatus=1).filter(
                                    ~Q(country_id=88)).all().aggregate(Max('plan_id__price'))['plan_id__price__max']
                                highestPrice = round(highestPriceVal * inrValue)
                                dataObj['price'] = round((dataObj['price']) * float(inrValue))
                                dataObj['planPrice'] = dataObj['price']
                        else:
                            if username['userCountry'] == 88:
                                highestPrice = \
                                PlanCountry.objects.select_related('Plan').filter(plan_id__activationStatus=1,
                                                                                  plan_id__planStatus=1,
                                                                                  country_id=88).all().aggregate(
                                    Max('plan_id__indianPrice'))['plan_id__indianPrice__max']
                                dataObj['price'] = dataObj['indianPrice']
                                dataObj['planPrice'] = dataObj['price']
                            else:
                                highestPrice = \
                                PlanCountry.objects.select_related('Plan').filter(plan_id__activationStatus=1,
                                                                                  plan_id__planStatus=1).filter(
                                    ~Q(country_id=88)).all().aggregate(Max('plan_id__price'))['plan_id__price__max']
                                dataObj['price'] = dataObj['price']
                                dataObj['planPrice'] = dataObj['price']
                        if float(dataObj['price']) == 0:
                            dataObj['price'] = "Free"
                            # dataObj['iosPrice'] = round(float(dataObj['iosPrice'])*float(inrValue))
                if dataObj['planType'] == "STARTER":
                    dataObj['planType'] = "Beginner"
                    dataObj['ptype'] = 'S'
                elif dataObj['planType'] == "INTERMEDIATE":
                    dataObj['planType'] = "Intermediate"
                    dataObj['ptype'] = 'I'
                elif dataObj['planType'] == "ADVANCED":
                    dataObj['planType'] = "Advanced"
                    dataObj['ptype'] = 'A'
                
                coachName1 = User.objects.get(id=dataObj['originalPlanner'])
                dataObj['oriCoachName'] = str(coachName1.first_name) + " " + str(coachName1.last_name)
                planAbilityVal = SelectedAbilities.objects.select_related('PlanAbilities').filter(
                    plan_id=dataObj['id']).values(
                    'ability_id__ability')
                abilities = ''
                abilities1 = ''
                for val in planAbilityVal:
                    valObj = dict(val)
                    abilities += ", " + valObj['ability_id__ability']
                    abilities1 += ", " + valObj['ability_id__ability']
                if abilities != '':
                    planAbilities = abilities[1:]
                    planAbilities1 = abilities[1:]
                else:
                    planAbilities = ""
                    planAbilities1 = ""

                planPurposesVal = PlanGoals.objects.select_related('PlanPurposes').filter(plan_id=dataObj['id']).values(
                    'planGoal_id__GoalName')
                print(planPurposesVal,"jjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjj")    
                purposes = ''
                purposes1 = ''
                for val in planPurposesVal:
                    valObj = dict(val)
                    purposes += ", " + valObj['planGoal_id__GoalName']
                    purposes1 += ", " + valObj['planGoal_id__GoalName']
                if purposes != '':
                    planGoals = purposes[1:]
                    planGoals1 = purposes[1:]
                else:
                    planGoals = ""
                    planGoals1 = ""
                if len(planGoals) > 30:
                    planGoals = planGoals[:30]
                    planGoals += "..."
                if len(planAbilities) > 31:
                    if planAbilities[31] == ",":
                        planAbilities = planAbilities[:30]
                    else:
                        planAbilities = planAbilities[:31]
                        planAbilities = planAbilities.split(",")
                        planAbilities = planAbilities[0] + "..."
                dataObj['planDescription'] = dataObj['planDescription'] + "<br><br><font><b>Abilities:</b> " + str(
                    planAbilities1) + "</font>" + "<br><br><font><b>Purposes:</b> " + str(planGoals) + "</font>"
                if dataObj['licencePolicy'] == "3" or dataObj['licencePolicy'] == "White-Label":
                    partnerName = User.objects.get(id=dataObj['createdBy_id'])
                    dataObj['planDescription'] = str(
                        dataObj['planDescription']) + "<br><h6>Copyright &copy; 2017 " + str(
                        str(partnerName.first_name) + " " + str(
                            partnerName.last_name)) + ". All rights reserved.</h6>"
                else:
                    coachName = User.objects.get(id=dataObj['originalPlanner'])
                    dataObj['planDescription'] = str(
                        dataObj['planDescription']) + "<br><h6>Copyright &copy; 2017 " + str(
                        str(coachName.first_name) + " " + str(coachName.last_name)) + ". All rights reserved.</h6>"
                downloadUsers = UserPlan.objects.filter(plan_id=dataObj['id']).values('user_id').distinct().count()
                ratingObj = PlanRating.objects.filter(plan=dataObj['id']).values()
                totalRate = 0
                userCount = 1
                for rt in ratingObj:
                    rateObj = dict(rt)
                    totalRate = totalRate + rateObj['rating']
                    userCount = userCount + 1
                rating = totalRate / userCount
                dataObj['PlanRating'] = rating
                dataObj['planPurpose'] = planAbilities
                dataObj['ability'] = planAbilities
                dataObj['ability1'] = planAbilities1
                dataObj['plan_goals'] = planGoals
                dataObj['plan_goals1'] = planGoals1
                dataObj['planCompetency'] = "0"
                dataObj['planUsers'] = downloadUsers
                planArr.append(dataObj)
            return JsonResponse({"success": True, "filterValues": planArr, "luctype": userCurrency.currencyType,
                                 "highPrice": highestPrice, "dollarHighest": highestPrice_dollar})
        else:
            return JsonResponse({"success": False, "message": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})

def loadCategoryFilter(request):
    abilitiesArr = []
    mairArr = {}
    planArr = []
    categories = [1, 2, 3, 4, 5, 6]
    country = [88, 190]
    deviceTypeArr = ["ios", "android"]
    x = connection.cursor()
    for cat in categories:
        categories = CategoryLevel.objects.filter(category=cat).values()
        for val in categories:
            valObj = dict(val)
            abilitiesArr.append(str(valObj['mappedAbility_id']))
        for ct in country:
            for devT in deviceTypeArr:
                query = " SELECT Plan_plan.*, Plan_plan.goals as planGoal__goalName, utility_programtype.programTypeName as planType,Subscriber_user.first_name as createdBy_id__first_name,Subscriber_user.last_name as createdBy_id__last_name,Plan_plan.goals as planGoal,Plan_plan.price as planPrice,Plan_plan.originalPlanner_id as originalPlanner,Plan_plan.createdBy_id as createdBy,utility_programtype.programTypeName as programType__programTypeName,Subscriber_user.avatar as createdBy_id__avatar,Subscriber_user.id as coachId FROM Plan_plan left join utility_programtype on Plan_plan.programType_id = utility_programtype.id left join Subscriber_user on Plan_plan.createdBy_id = Subscriber_user.id left join Plan_selectedabilities on Plan_plan.id = Plan_selectedabilities.plan_id left join Plan_plangoals on Plan_plan.id = Plan_plangoals.plan_id left join Plan_plancountry on Plan_plan.id = Plan_plancountry.plan_id  where Plan_plancountry.country_id = " + str(
                    ct) + " and "
                if cat == "1":
                    query += " Plan_plan.id is not null and activationStatus=1 and planStatus=1  and Plan_plan.programType_id = 1 GROUP BY Plan_selectedabilities.plan_id,Plan_plangoals.plan_id ORDER BY Plan_plan.programType_id,Plan_plan.planName ASC"
                elif abilitiesArr == []:
                    query += " Plan_plan.id is not null and activationStatus=1 and planStatus=1  and Plan_selectedabilities.ability_id = 0 GROUP BY Plan_selectedabilities.plan_id,Plan_plangoals.plan_id ORDER BY Plan_plan.programType_id,Plan_plan.planName ASC"
                else:
                    query += " Plan_plan.id is not null and activationStatus=1 and planStatus=1  and Plan_selectedabilities.ability_id in ( " + ','.join(
                        abilitiesArr) + " ) GROUP BY Plan_selectedabilities.plan_id,Plan_plangoals.plan_id ORDER BY Plan_plan.programType_id,Plan_plan.planName ASC"
                x.execute(query)
                resultQuery = dictfetchall(x)
                # highestPrice= Plan.objects.filter(activationStatus=1, planStatus=1).all().aggregate(Max('price'))['price__max']
                highestPrice_dollar = \
                Plan.objects.filter(activationStatus=1, planStatus=1).all().aggregate(Max('price'))['price__max']
                if ct == 88:
                    highestPriceVal = PlanCountry.objects.select_related('Plan').filter(plan_id__activationStatus=1,
                                                                                        plan_id__planStatus=1,
                                                                                        country_id=88).all().aggregate(
                        Max('plan_id__indianPrice'))['plan_id__indianPrice__max']
                    highestPrice = round(highestPriceVal)
                else:
                    highestPriceVal = PlanCountry.objects.select_related('Plan').filter(plan_id__activationStatus=1,
                                                                                        plan_id__planStatus=1,
                                                                                        country_id=88).all().aggregate(
                        Max('plan_id__price'))['plan_id__price__max']
                    highestPrice = round(highestPriceVal)
                clelebLikeArr = []
                celebreviewArr = []
                for dt in resultQuery:
                    dataObj = dict(dt)

                    planurls = PlanShortUrls.objects.filter(plan_id=dataObj['id']).values()
                    if planurls.exists():
                        for val in planurls:
                            valObj = dict(val)
                            urlVal = valObj['longUrl'].split('/')
                            urlVal1 = urlVal[6].split('=')
                            urlVal2 = urlVal1[1].split('&')
                            dataObj[urlVal2[0]] = valObj['shortUrl']

                    plalikescount = CelebrityPlansLikes.objects.filter(plan_id=dataObj['id'], status=1).count()
                    reviewscount = CelebrityPlansLikes.objects.filter(plan_id=dataObj['id']).exclude(
                        reviews__isnull=True).exclude(reviews__exact='').count()
                    dataObj['planlikesCount'] = plalikescount
                    dataObj['reviewsCount'] = reviewscount

                    clelebLikes = celeblikes(dataObj['id'])
                    celebReviews = celebreviewList(dataObj['id'])
                    dataObj['planlikes'] = clelebLikes
                    dataObj['planreviews'] = celebReviews
                    # print(dataObj['planreviews'],"here")

                    dataObj['celeblikedPlan'] = 0
                    dataObj['celebreviewPlan'] = 0
                    dataObj['reviews'] = ''
                    # if username['userType'] == 8:
                    '''celebplanlikes = CelebrityPlansLikes.objects.filter(plan_id=dataObj['id'], user_id=username['id'],
                                                                        status=1).values()
                    if celebplanlikes.exists():
                        dataObj['celeblikedPlan'] = 1
                    celebplanreviews = CelebrityPlansLikes.objects.filter(plan_id=dataObj['id'], user_id=username['id']).values()
                    if celebplanreviews.exists():
                        for celbdt in celebplanreviews:
                            celbObj = dict(celbdt)
                            if celbObj['reviews'] != '' and celbObj['reviews'] != None:
                                dataObj['reviews'] = celbObj['reviews']
                                dataObj['celebreviewPlan'] = 1'''

                    secret_code_plain = dataObj['planName'] + '#' + str(dataObj['id'])
                    secret_code_encode = base64.b64encode(secret_code_plain.encode('ascii'))
                    encodedVal = str(secret_code_encode).split("'")
                    dataObj['encodedurl'] = encodedVal[1]

                    dataObj['coachName'] = dataObj['createdBy_id__first_name'] + " " + dataObj[
                        'createdBy_id__last_name']
                    dataObj['createdBy_id__first_name'] = dataObj['createdBy_id__first_name'] + " " + dataObj[
                        'createdBy_id__last_name']
                    if devT == 'ios':
                        if ct == 88:
                            highestPriceVal = \
                            PlanCountry.objects.select_related('Plan').filter(plan_id__activationStatus=1,
                                                                              plan_id__planStatus=1,
                                                                              country_id=88).all().aggregate(
                                Max('plan_id__indianIosPrice'))['plan_id__indianIosPrice__max']
                            print(highestPriceVal)
                            highestVal = PriceMapping.objects.get(inr=highestPriceVal)
                            highestPrice = highestVal.usd
                            usdValue = PriceMapping.objects.values().filter(inr=dataObj['indianIosPrice'])
                        else:
                            highestPriceVal = \
                            PlanCountry.objects.select_related('Plan').filter(plan_id__activationStatus=1,
                                                                              plan_id__planStatus=1).filter(
                                ~Q(country_id=88)).all().aggregate(Max('plan_id__iosPrice'))['plan_id__iosPrice__max']
                            highestVal = PriceMapping.objects.get(inr=highestPriceVal)
                            highestPrice = highestVal.usd
                            usdValue = PriceMapping.objects.values().filter(inr=dataObj['iosPrice'])
                        for usd in usdValue:
                            usdObj = dict(usd)
                            dollarVal = usdObj['usd']
                        dataObj['price'] = dollarVal
                        if float(dataObj['price']) == 0:
                            dataObj['price'] = "Free"
                    else:
                        if int(dataObj['price']) == 0:
                            dataObj['price'] = "Free"
                        else:
                            if ct == 88:
                                highestPrice = \
                                PlanCountry.objects.select_related('Plan').filter(plan_id__activationStatus=1,
                                                                                  plan_id__planStatus=1,
                                                                                  country_id=88).all().aggregate(
                                    Max('plan_id__indianPrice'))['plan_id__indianPrice__max']
                                dataObj['price'] = dataObj['indianPrice']
                                dataObj['planPrice'] = dataObj['price']
                            else:
                                highestPrice = \
                                PlanCountry.objects.select_related('Plan').filter(plan_id__activationStatus=1,
                                                                                  plan_id__planStatus=1).filter(
                                    ~Q(country_id=88)).all().aggregate(Max('plan_id__price'))['plan_id__price__max']
                                dataObj['price'] = dataObj['price']
                                dataObj['planPrice'] = dataObj['price']
                            if float(dataObj['price']) == 0:
                                dataObj['price'] = "Free"
                                # dataObj['iosPrice'] = round(float(dataObj['iosPrice'])*float(inrValue))
                    if dataObj['planType'] == "STARTER":
                        dataObj['planType'] = "Beginner"
                        dataObj['ptype'] = 'S'
                    elif dataObj['planType'] == "INTERMEDIATE":
                        dataObj['planType'] = "Intermediate"
                        dataObj['ptype'] = 'I'
                    elif dataObj['planType'] == "ADVANCED":
                        dataObj['planType'] = "Advanced"
                        dataObj['ptype'] = 'A'
                    
                    coachName1 = User.objects.get(id=dataObj['originalPlanner'])
                    dataObj['oriCoachName'] = str(coachName1.first_name) + " " + str(coachName1.last_name)
                    planAbilityVal = SelectedAbilities.objects.select_related('PlanAbilities').filter(
                        plan_id=dataObj['id']).values(
                        'ability_id__ability')
                    abilities = ''
                    abilities1 = ''
                    for val in planAbilityVal:
                        valObj = dict(val)
                        abilities += ", " + valObj['ability_id__ability']
                        abilities1 += ", " + valObj['ability_id__ability']
                    if abilities != '':
                        planAbilities = abilities[1:]
                        planAbilities1 = abilities[1:]
                    else:
                        planAbilities = ""
                        planAbilities1 = ""

                    planPurposesVal = PlanGoals.objects.select_related('PlanPurposes').filter(
                        plan_id=dataObj['id']).values('planGoal_id__GoalName')
                    purposes = ''
                    purposes1 = ''
                    for val in planPurposesVal:
                        valObj = dict(val)
                        purposes += ", " + valObj['planGoal_id__GoalName']
                        purposes1 += ", " + valObj['planGoal_id__GoalName']
                    if purposes != '':
                        planGoals = purposes[1:]
                        planGoals1 = purposes[1:]
                    else:
                        planGoals = ""
                        planGoals1 = ""
                    if len(planGoals) > 30:
                        planGoals = planGoals[:30]
                        planGoals += "..."
                    if len(planAbilities) > 31:
                        if planAbilities[31] == ",":
                            planAbilities = planAbilities[:30]
                        else:
                            planAbilities = planAbilities[:31]
                            planAbilities = planAbilities.split(",")
                            planAbilities = planAbilities[0] + "..."
                    dataObj['planDescription'] = dataObj[
                                                     'planDescription'] + "<br><br><font><b>Abilities:</b> " + str(
                        planAbilities1) + "</font>" + "<br><br><font><b>Purposes:</b> " + str(planGoals) + "</font>"
                    if dataObj['licencePolicy'] == "3" or dataObj['licencePolicy'] == "White-Label":
                        partnerName = User.objects.get(id=dataObj['createdBy_id'])
                        dataObj['planDescription'] = str(
                            dataObj['planDescription']) + "<br><h6>Copyright &copy; 2017 " + str(
                            str(partnerName.first_name) + " " + str(
                                partnerName.last_name)) + ". All rights reserved.</h6>"
                    else:
                        coachName = User.objects.get(id=dataObj['originalPlanner'])
                        dataObj['planDescription'] = str(
                            dataObj['planDescription']) + "<br><h6>Copyright &copy; 2017 " + str(
                            str(coachName.first_name) + " " + str(
                                coachName.last_name)) + ". All rights reserved.</h6>"
                    downloadUsers = UserPlan.objects.filter(plan_id=dataObj['id']).values(
                        'user_id').distinct().count()
                    ratingObj = PlanRating.objects.filter(plan=dataObj['id']).values()
                    totalRate = 0
                    userCount = 1
                    for rt in ratingObj:
                        rateObj = dict(rt)
                        totalRate = totalRate + rateObj['rating']
                        userCount = userCount + 1
                    rating = totalRate / userCount
                    dataObj['PlanRating'] = rating
                    dataObj['planPurpose'] = planAbilities
                    dataObj['ability'] = planAbilities
                    dataObj['ability1'] = planAbilities1
                    dataObj['plan_goals'] = planGoals
                    dataObj['plan_goals1'] = planGoals1
                    dataObj['planCompetency'] = "0"
                    dataObj['planUsers'] = downloadUsers
                    catName = str(cat) + "_" + str(ct) + "_" + devT
                    mairArr[catName] = dataObj
                    mairArr['highPrice'] = highestPrice
                    mairArr['dollarHighest'] = highestPrice_dollar
                planArr.append(mairArr)
    return JsonResponse({"success": True, "filterValues": mairArr})





@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def exerciseTobeReviewed(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        if username != None:
            x = connection.cursor()
            if username['userType'] == 1 and username['is_superuser'] == 1:

                if 'rows' in request.POST and request.POST['rows'] != '':
                    rows = int(request.POST['rows'])
                else:
                    rows = PAGING_ROWS
                if 'page' in request.POST and request.POST['page'] != '':
                    page = int(request.POST['page'])
                else:
                    page = 1
                offset = (page - 1) * rows
                tot = page * rows

                # programs = Exercise.objects.select_related('Videos').filter(accessLevel = 1).values('exerciseName','exerciseCode','exerciseStatus','exerciseDesc','equipment','video','video_id__videoLink','derivedFrom','derivedFormula','workFormula','exerciseType','olympicLift','olympicParent','olympicFormula','preExInstructions','postExInstructions','accessLevel','weightExists','distanceExists','timeExists','repsExists','exAbilities','setInstructions','createdBy','id')
                query = "SELECT *,utility_exercise.id AS exID,utility_videos.videoLink AS video_id__videoLink,utility_videos.youtubeUrl AS video_id__youtubeUrl FROM `utility_exercise` LEFT JOIN `utility_advexercises` ON utility_advexercises.exercise_id = utility_exercise.id LEFT JOIN `utility_videos` ON utility_exercise.video_id = utility_videos.id WHERE utility_exercise.accessLevel =1 AND utility_exercise.id IS NOT NULL"
                x.execute(query)
                programs = dictfetchall(x)
                reviewPrograms = []
                total = len(programs)
                if programs:
                    data = programs[offset:tot]
                    for val in data:
                        metValuesArr = []
                        proObj = dict(val)
                        metaValues = MetabolicValues.objects.filter(exercise_id=proObj['exID']).values()
                        if metaValues.exists():
                            for metVal in metaValues:
                                metaObj = dict(metVal)
                                metValuesArr.append(metaObj)
                        proObj['metValues'] = metValuesArr
                        if proObj['video_id__youtubeUrl'] == 1:
                            if proObj['video_id__videoLink'] != '' and proObj['video_id__videoLink'] != None:
                                proObj['video_id__videoLink'] = "https://www.youtube.com/watch?v=" + proObj[
                                    'video_id__videoLink']
                        else:
                            if proObj['video_id__videoLink'] != '' and proObj['video_id__videoLink'] != None:
                                proObj['video_id__videoLink'] = "https://s3.amazonaws.com/stratfitmedia" + proObj[
                                    'video_id__videoLink']
                        reviewPrograms.append(proObj)
                return JsonResponse({"success": True, "rows": reviewPrograms, "total": total})
            else:
                return JsonResponse({"success": False, "message": "Invalid User"})
        else:
            return JsonResponse({"success": False, "message": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})
@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getuserExDetails(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    try:
        if username != '':
            user = username['id']
            exArr = []
            exValues = []
            userExDetails = UserExercise.objects.filter(user_id=user).values('exerciseId').distinct()
            for ex in userExDetails:
                exObj = dict(ex)
                exArr.append(exObj['exerciseId'])
            exDetails = NewExercise.objects.filter(id__in=exArr).values('id', 'exerciseName')
            for val in exDetails:
                valObj = dict(val)
                exValues.append(valObj)
            return JsonResponse({"success": True, "details": exValues})
        else:
            return JsonResponse({"success": False, "message": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})


@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getuserPlans(request):
    stratsessionutil = StartFitSessionUtil()
    username = stratsessionutil.get_user_insession(request)
    try:
        if username != '':
            user = username['id']
            exArr = []
            exValues = []
            userExDetails = UserExercise.objects.filter(user_id=user).values('plan').distinct()
            for ex in userExDetails:
                exObj = dict(ex)
                exArr.append(exObj['plan'])
            exDetails = Plan.objects.filter(id__in=exArr).values('id', 'planName')
            for val in exDetails:
                valObj = dict(val)
                exValues.append(valObj)
            return JsonResponse({"success": True, "details": exValues})
        else:
            return JsonResponse({"success": False, "message": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})



@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getDraftedExs(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        user = username['id']
        if username != None:
            plandata = NewExercise.objects.select_related('Videos').filter(createdBy_id=user).values('exerciseName',
                                                                                                  'exerciseStatus',
                                                                                                  'id', 'exerciseDesc',
                                                                                                  'equipment',
                                                                                                  'video_id__videoLink',
                                                                                                  'exerciseType',
                                                                                                  'exIcon',
                                                                                                  'preExInstructions',
                                                                                                  'postExInstructions',
                                                                                                  'accessLevel',
                                                                                                  'weightExists',
                                                                                                  'distanceExists',
                                                                                                  'timeExists',
                                                                                                  'repsExists',
                                                                                                  'exAbilities',
                                                                                                  'setInstructions',
                                                                                                  'heightExists',
                                                                                                  'speedExists',
                                                                                                  'timeShortest',
                                                                                                  'derivedFrom',
                                                                                                  'derivedFormula',"video_id__youtubeUrl")
            ActiveExArr = []
            InActiveExArr = []
            RejectedExArr = []
            for data in plandata:
                exObj = dict(data)
                exObj['exID'] = exObj['id']
                advExercises = AdvExercises.objects.filter(exercise_id=exObj['id']).values()
                for adv in advExercises:
                    advObj = dict(adv)
                    exObj['extracoloumns'] = advObj
                    exObj['tmaxReps'] = advObj['tmaxReps']
                    exObj['tmaxWeight'] = advObj['tmaxWeight']
                    exObj['tmaxDistance'] = advObj['tmaxDistance']
                    exObj['tmaxTime'] = advObj['tmaxTime']
                    exObj['tmaxSpeed'] = advObj['tmaxSpeed']
                    exObj['tmaxHeight'] = advObj['tmaxHeight']
                    if exObj['video_id__youtubeUrl'] == 1:
                        if exObj['video_id__videoLink'] !='' and exObj['video_id__videoLink'] !=None:
                            exObj['video_id__videoLink'] = "https://www.youtube.com/watch?v="+exObj['video_id__videoLink']
                    else:
                        if exObj['video_id__videoLink'] !='' and exObj['video_id__videoLink'] !=None:
                            exObj['video_id__videoLink'] = "https://s3.amazonaws.com/stratfitmedia"+exObj['video_id__videoLink']
                if exObj['exerciseStatus'] == 1:
                    ActiveExArr.append(exObj)
                if exObj['exerciseStatus'] == 0:
                    InActiveExArr.append(exObj)
                if exObj['exerciseStatus'] == 2:
                    RejectedExArr.append(exObj)
            return JsonResponse(
                {"activeplan": ActiveExArr, "inactiveplan": InActiveExArr, "reviewPrograms": RejectedExArr})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})


@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def plancopy(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        data = json.loads(request.body.decode('utf-8'))
        user = username['id']
        if username != None:
            plandetails = Plan.objects.get(id=data['plan_id'])
            if plandetails.copyPlan_id != None and plandetails.copyPlan_id != '':
                existingplan = Plan.objects.get(id=plandetails.copyPlan_id)
                if existingplan.planStatus == 0:
                    return JsonResponse({"success": False, "message": "Copied plan not published yet."})
                else:
                    print("New plan copy")
            planCopy = Plan.objects.create(
                programType_id=plandetails.programType_id,
                planName=plandetails.planName,
                planDescription=plandetails.planDescription,
                planStatus=0,
                planGoal=plandetails.planGoal,
                price=plandetails.price,
                ability=plandetails.ability,
                num_of_periods=plandetails.num_of_periods,
                num_of_sessions=plandetails.num_of_sessions,
                goals=plandetails.goals,
                licencePolicy=plandetails.licencePolicy,
                duration_weeks=plandetails.duration_weeks,
                planPhoto=plandetails.planPhoto,
                originalPlanner_id=user,
                royalty=plandetails.royalty,
                proposedState=plandetails.proposedState,
                activationStatus=plandetails.activationStatus,
                planLogo=plandetails.planLogo,
                iosPrice=plandetails.iosPrice,
                indianPrice=plandetails.indianPrice,
                indianIosPrice=plandetails.indianIosPrice,
                iosStatus=plandetails.iosStatus,
                advPlan=plandetails.advPlan,
                createdBy_id=user,
                modifiedBy_id=user
            )
            planCopy.save()
            planCopy.originalPlanId_id = planCopy.id
            plandetails.copyPlan_id = planCopy.id
            plandetails.save()
            plangoals = PlanGoals.objects.filter(plan_id=plandetails.id).values()
            for val in plangoals:
                valObj = dict(val)
                goalscopy = PlanGoals.objects.create(
                    planGoal_id=valObj['planGoal_id'],
                    plan_id=planCopy.id,
                    createdBy_id=user,
                    modifiedBy_id=user
                )
                goalscopy.save()
            planAbilites = SelectedAbilities.objects.filter(plan_id=plandetails.id).values()
            for obj in planAbilites:
                dictVal = dict(obj)
                abilitiescopy = SelectedAbilities.objects.create(
                    ability_id=dictVal['ability_id'],
                    plan_id=planCopy.id,
                    createdBy_id=user,
                    modifiedBy_id=user

                )
                abilitiescopy.save()
            draftedPlanDetails = DraftedPlan.objects.filter(planId_id=plandetails.id).values().last()
            draftplancopy = DraftedPlan.objects.create(
                planId_id=planCopy.id,
                planJson=draftedPlanDetails['planJson'],
                protocolJson=draftedPlanDetails['protocolJson'],
                status=0,
                createdBy_id=user,
                modifiedBy_id=user

            )
            draftplancopy.save()

            planMonetization = PlanMonetization.objects.create(
                plan_id_id=planCopy.id,
                planType='Direct Selling',
                license_id=1,
                royalty='',
                coach_id_id=user,
                templateContent='N/A',
            )
            planMonetization.save()
            return JsonResponse({"success": True, "message": "Plan copied."})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})



@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getAllAdvEx(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)

        if username != None:
            arr = []
            advExDetails = AdvExercises.objects.select_related('Exercise', 'Videos').filter(exercise_id__accessLevel=1,
                                                                                            exercise_id__exerciseStatus=1,
                                                                                            parentExercise_id__isnull=True).values(
                'exercise_id__exerciseName', 'exercise_id', 'exercise_id__weightExists', 'exercise_id__distanceExists',
                'exercise_id__timeExists', 'exercise_id__repsExists', 'exercise_id__speedExists',
                'exercise_id__heightExists', 'maxWeight', 'maxReps', 'maxTime', 'maxDistance', 'maxSpeed', 'maxHeight',
                'tmaxReps', 'tmaxWeight', 'tmaxDistance', 'tmaxTime', 'tmaxSpeed', 'tmaxHeight', 'tmaxTestInst',
                'exercise_id__video_id__videoLink')
            for val in advExDetails:
                valObj = dict(val)
                arr.append(valObj)
            return JsonResponse({"success": True, "details": arr})
        else:
            return JsonResponse({"success": False, "message": "User logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})
@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache  
def getAllPlans(request):
    data=request.data
    vid=data['id']
    resp={}
    plan_info={}
    program_info=[]
    plan_details={}
    plan1={}
    if vid:
        plan=Plan.objects.filter(createdBy_id=vid).values()
        for data1 in plan[::]:
            program=ProgramType.objects.filter(id=data1['programType_id']).values()
            
            for data2 in program[::]:
    
                plan_info={"planName":data1['planName'],"planStatus":data1['planStatus'],"planGoal_id":data1['planGoal_id'],"price":data1['price'],"ability":data1['ability'],"num_of_sessions":data1['num_of_sessions'],"goals":data1['goals'],"activationStatus":data1['activationStatus'],"indianPrice":data1['indianPrice'],"indianIosPrice":data1['indianIosPrice'],"iosStatus":data1['iosStatus'],"advPlan":data1['advPlan'],"programType_id":data1['programType_id'],"programTypeName":data2['programTypeName']}
                program_info.append(plan_info)
            
            plan_details={"plan_info":program_info}
        resp['message']=plan_details
    else:
        resp['message']="This email id not have any plans"
    return Response(resp)    
