from django.db import models
from utility.models import TrainingLevel,PlanPurposes,NewExercise,ProgramType,Goals,PlanAbilities,Country,Videos,protocols
from Subscriber.models import User
from StratFitOrganization.models import Organization
# Create your models here.
class Plan(models.Model):
    programType = models.ForeignKey(ProgramType,related_name='planp',on_delete=models.CASCADE)
    planName = models.CharField(max_length=250, blank=False)
    planDescription = models.TextField(blank=True, null=True)
    planStatus = models.BooleanField(default=False)
    planGoal = models.ForeignKey(Goals,related_name='planG',on_delete=models.CASCADE, blank=True, null = True)
    publishDate = models.DateTimeField(blank=True, null = True)
    price = models.IntegerField(blank=True,null=True)
    ability = models.TextField(blank=True,null=True)
    num_of_periods = models.IntegerField(default=0)
    num_of_sessions = models.IntegerField(default=0)
    goals = models.TextField(null=True,blank=True)
    others=models.TextField(null=True,blank=True)
    licencePolicy = models.CharField(max_length=100,null=True,blank=True)
    duration_weeks = models.IntegerField(null=True,blank=True)
    planPhoto = models.CharField(max_length=255,null=True,blank=True)
    originalPlanId = models.ForeignKey('self', related_name='slefid',on_delete=models.CASCADE,blank=True,null=True)
    originalPlanner = models.ForeignKey(User, related_name='originalplanner',on_delete=models.CASCADE )
    royalty = models.CharField(max_length=100,blank=True, null=True)
    proposedState = models.IntegerField(default=0)
    activationStatus = models.BooleanField(default=True)
    planLogo = models.CharField(max_length=255,null=True,blank=True)
    iosPrice = models.IntegerField(default=0)
    indianPrice = models.FloatField(default=0)
    indianIosPrice = models.FloatField(default=0)
    iosStatus = models.IntegerField(default=0)
    advPlan  = models.IntegerField(default=0)
    createdBy = models.ForeignKey(User, related_name='plancreator',on_delete=models.CASCADE)
    modifiedBy = models.ForeignKey(User, related_name='planmodifier',on_delete=models.CASCADE)
    createdDate = models.DateTimeField(auto_now_add=True)
    updatedDate = models.DateTimeField(auto_now=True)
    copyPlan = models.ForeignKey('self', related_name='slefplanId',on_delete=models.CASCADE,null=True)

class PlanVideos(models.Model):
    video = models.CharField(null=True,blank=True,max_length=100)
    plan = models.ForeignKey(Plan,null=True,related_name='plVideo',on_delete=models.CASCADE)
    createdBy = models.ForeignKey(User, related_name='plavideo',on_delete=models.CASCADE)
    modifiedBy = models.ForeignKey(User, related_name='plavideoMod',on_delete=models.CASCADE)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class PlanRating(models.Model):
    plan = models.ForeignKey(Plan,related_name='plrat',on_delete=models.CASCADE)
    user = models.ForeignKey(User, related_name='plarating',on_delete=models.CASCADE)
    rating = models.FloatField(null=True,blank=True)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDare  = models.DateTimeField(auto_now=True)


class PlanGoals(models.Model):
    planGoal = models.ForeignKey(PlanPurposes, related_name='planGoal',on_delete=models.CASCADE)
    plan = models.ForeignKey(Plan,related_name='planscrby',on_delete=models.CASCADE)
    createdBy = models.ForeignKey(User, related_name='planGoal',on_delete=models.CASCADE )
    modifiedBy = models.ForeignKey(User, related_name='modGoal',on_delete=models.CASCADE)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class SelectedAbilities(models.Model):
    ability = models.ForeignKey(PlanAbilities, related_name='pAblpr',on_delete=models.CASCADE)
    plan = models.ForeignKey(Plan, on_delete=models.CASCADE)
    createdBy = models.ForeignKey(User, related_name='pApr', on_delete=models.CASCADE)
    modifiedBy = models.ForeignKey(User, related_name='mAppr', on_delete=models.CASCADE)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class Plan_level(models.Model):
    plan_id=models.ForeignKey(Plan,related_name='pllcrplby',on_delete=models.CASCADE)
    training_level_id=models.ForeignKey(TrainingLevel,related_name='crby', on_delete=models.CASCADE)
    
    created_By = models.ForeignKey(User,  related_name='pllcrrby',on_delete=models.CASCADE)
    modified_By = models.ForeignKey(User,  related_name='pllmpdby',on_delete=models.CASCADE)
    created_Date = models.DateTimeField(auto_now_add=True)
    modified_Date = models.DateTimeField(auto_now=True)

class Plan_Purpose(models.Model):
    plan_id=models.ForeignKey(Plan,related_name='plpcrdby',on_delete=models.CASCADE)
    purpose_id=models.ForeignKey(PlanPurposes,related_name='plpcrrdby',on_delete=models.CASCADE)
    created_By = models.ForeignKey(User,  related_name='plpcrdby',on_delete=models.CASCADE)
    modified_By = models.ForeignKey(User,  related_name='plpmodby',on_delete=models.CASCADE)
    created_Date = models.DateTimeField(auto_now_add=True)
    modified_Date = models.DateTimeField(auto_now=True)
class Plan_Period(models.Model):
    plan_id=models.ForeignKey(Plan,related_name='plperdcreatedby',on_delete=models.CASCADE)
    period_name=models.CharField(max_length=40)
    status=models.BooleanField(default=False)
    description=models.TextField()
    pdc_id=models.CharField(max_length=100,default=1)
    parent_id=models.CharField(max_length=100,default=2)
    num_of_mesocycles=models.IntegerField()
    num_of_microcycles=models.IntegerField()
    created_By = models.ForeignKey(User,  related_name='plperdcrtby',on_delete=models.CASCADE)
    modified_By = models.ForeignKey(User,  related_name='plperdmdfiedby',on_delete=models.CASCADE)
    created_Date = models.DateTimeField(auto_now_add=True)
    modified_Date = models.DateTimeField(auto_now=True)

class Plan_Mesocycle(models.Model):
    plan_id=models.ForeignKey(Plan,related_name='plmesocrby',on_delete=models.CASCADE)
    period_id=models.ForeignKey(Plan_Period,related_name='plmesoby',on_delete=models.CASCADE)
    mesocycles_name=models.CharField(max_length=100)
    description=models.TextField()
    num_of_microcycles=models.IntegerField()
    pdc_id=models.CharField(max_length=100,default=1)
    parent_id=models.CharField(max_length=100,default=2)
    status=models.BooleanField(default=False)
    created_By = models.ForeignKey(User,  related_name='plmesolby',on_delete=models.CASCADE)
    modified_By = models.ForeignKey(User,  related_name='plmesoplby',on_delete=models.CASCADE)
    created_Date = models.DateTimeField(auto_now_add=True)
    modified_Date = models.DateTimeField(auto_now=True)
class Plan_Microcycles(models.Model):
    plan_id=models.ForeignKey(Plan,related_name='plmicreatby',on_delete=models.CASCADE)
    period_id=models.ForeignKey(Plan_Period,related_name='plmimyplby',on_delete=models.CASCADE)
    meso_id=models.ForeignKey(Plan_Mesocycle,related_name='plmimymsby',on_delete=models.CASCADE)
    micro_name=models.CharField(max_length=100)
    description=models.TextField()
    pdc_id=models.CharField(max_length=100,default=1)
    parent_id=models.CharField(max_length=100,default=2)
    status=models.BooleanField(default=False)
    num_of_days=models.IntegerField()
    total_load=models.FloatField()
    created_By = models.ForeignKey(User,  related_name='plmicrmcby',on_delete=models.CASCADE)
    modified_By = models.ForeignKey(User,  related_name='plmimdmcby',on_delete=models.CASCADE)
    created_Date = models.DateTimeField(auto_now_add=True)
    modified_Date = models.DateTimeField(auto_now=True)

class Plan_Days(models.Model):
    plan_id=models.ForeignKey(Plan,related_name='pldcrby',on_delete=models.CASCADE)
    period_id=models.ForeignKey(Plan_Period,related_name='pldby',on_delete=models.CASCADE)
    meso_id=models.ForeignKey(Plan_Mesocycle,related_name='pldmsby',on_delete=models.CASCADE)
    micro_id=models.ForeignKey(Plan_Microcycles,related_name='pldmiby',on_delete=models.CASCADE)
    day_name=models.CharField(max_length=40)
    description=models.TextField()
    status=models.BooleanField(default=False)
    pdc_id=models.CharField(max_length=100,default=1)
    parent_id=models.CharField(max_length=100,default=2)
    num_of_sessions=models.IntegerField()
    total_load=models.FloatField()
    rest_time=models.FloatField()
    created_By = models.ForeignKey(User,  related_name='pldcrby',on_delete=models.CASCADE)
    modified_By = models.ForeignKey(User,  related_name='pldmdby',on_delete=models.CASCADE)
    created_Date = models.DateTimeField(auto_now_add=True)
    modified_Date = models.DateTimeField(auto_now=True)
class Plan_Sessions(models.Model):
    plan_id=models.ForeignKey(Plan,related_name='plscrby',on_delete=models.CASCADE)
    period_id=models.ForeignKey(Plan_Period,related_name='plsby',on_delete=models.CASCADE)
    meso_id=models.ForeignKey(Plan_Mesocycle,related_name='plsmsby',on_delete=models.CASCADE)
    micro_id=models.ForeignKey(Plan_Microcycles,related_name='plsmiby',on_delete=models.CASCADE)
    day_id=models.ForeignKey(Plan_Days,related_name='plspdby',on_delete=models.CASCADE)
    session_name=models.CharField(max_length=100)
    description=models.TextField()
    pdc_id=models.CharField(max_length=100,default=1)
    parent_id=models.CharField(max_length=100,default=2)
    status=models.BooleanField(default=False)
    num_of_exercises=models.IntegerField()
    total_load=models.FloatField()
    rest_time=models.FloatField()
    created_By = models.ForeignKey(User,  related_name='plscrby',on_delete=models.CASCADE)
    modified_By = models.ForeignKey(User,  related_name='plsmdby',on_delete=models.CASCADE)
    created_Date = models.DateTimeField(auto_now_add=True)
    modified_Date = models.DateTimeField(auto_now=True)
class Plan_Activity(models.Model):
    plan_id=models.ForeignKey(Plan,related_name='plactcrby',on_delete=models.CASCADE)
    period_id=models.ForeignKey(Plan_Period,related_name='plactby',on_delete=models.CASCADE)
    meso_id=models.ForeignKey(Plan_Mesocycle,related_name='plactmsby',on_delete=models.CASCADE)
    micro_id=models.ForeignKey(Plan_Microcycles,related_name='plactmiby',on_delete=models.CASCADE)
    day_id=models.ForeignKey(Plan_Days,related_name='plactpdby',on_delete=models.CASCADE)
    session_id=models.ForeignKey(Plan_Sessions,related_name='plactpsby',on_delete=models.CASCADE)
    Activity_name=models.CharField(max_length=100)
    Activity_type=models.CharField(max_length=100,blank=True)
    pdc_id=models.CharField(max_length=100,default=1)
    parent_id=models.CharField(max_length=100,default=2)
    description=models.TextField()
    status=models.BooleanField(default=False)
    total_load=models.FloatField()
    rest_time=models.FloatField()
    warm_up=models.BooleanField(default=False)
    created_By = models.ForeignKey(User,  related_name='plactcrby',on_delete=models.CASCADE)
    modified_By = models.ForeignKey(User,  related_name='plactmdby',on_delete=models.CASCADE)
    created_Date = models.DateTimeField(auto_now_add=True)
    modified_Date = models.DateTimeField(auto_now=True)

class Plan_Round(models.Model):
    plan_id        = models.ForeignKey(Plan,related_name='plan_round_crby',on_delete=models.CASCADE)
    period_id      = models.ForeignKey(Plan_Period,related_name='plan_round_by',on_delete=models.CASCADE)
    meso_id        = models.ForeignKey(Plan_Mesocycle,related_name='plan_round_mesoby',on_delete=models.CASCADE)
    micro_id       = models.ForeignKey(Plan_Microcycles,related_name='plan_round_miby',on_delete=models.CASCADE)
    day_id         = models.ForeignKey(Plan_Days,related_name='plan_round_dayby',on_delete=models.CASCADE)
    session_id     = models.ForeignKey(Plan_Sessions,related_name='plan_round_sessionby',on_delete=models.CASCADE)
    activity_id    = models.ForeignKey(Plan_Activity,related_name='plan_round_act_by',on_delete=models.CASCADE)
    round_name     = models.CharField(max_length=100)
    pdc_id=models.CharField(max_length=100,default=1)
    parent_id=models.CharField(max_length=100,default=2)
    description    = models.TextField()
    round_type     = models.CharField(max_length=100,blank=True)
    status         = models.BooleanField(default=False)
    num_of_actions = models.IntegerField()
    total_load     = models.FloatField()
    rest_time      = models.FloatField()
    created_By     = models.ForeignKey(User,related_name='plarcrby',on_delete=models.CASCADE)
    modified_By    = models.ForeignKey(User,related_name='plarmdby',on_delete=models.CASCADE)
    created_Date   = models.DateTimeField(auto_now_add=True)
    modified_Date  = models.DateTimeField(auto_now=True)


class Plan_Actions(models.Model):
    plan_id    =models.ForeignKey(Plan,related_name='placrby',on_delete=models.CASCADE)
    period_id  =models.ForeignKey(Plan_Period,related_name='plaby',on_delete=models.CASCADE)
    meso_id    =models.ForeignKey(Plan_Mesocycle,related_name='plamsby',on_delete=models.CASCADE)
    micro_id   =models.ForeignKey(Plan_Microcycles,related_name='plamiby',on_delete=models.CASCADE)
    day_id     =models.ForeignKey(Plan_Days,related_name='plamiby',on_delete=models.CASCADE)
    session_id =models.ForeignKey(Plan_Sessions,related_name='plamiby',on_delete=models.CASCADE)
    activity_id=models.ForeignKey(Plan_Activity,related_name='plamiby',on_delete=models.CASCADE)
    round_id   =models.ForeignKey(Plan_Round,related_name='plamiby',on_delete=models.CASCADE)
    exercise_id=models.ForeignKey(NewExercise,related_name='plamiby',on_delete=models.CASCADE)
    pdc_id=models.CharField(max_length=100,default=1)
    parent_id=models.CharField(max_length=100,default=2)
    action_type = models.CharField(max_length=100,default="MainSet")
    intensity_range=models.FloatField()
    num_of_sets=models.IntegerField()
    min_reps=models.IntegerField()
    max_reps=models.IntegerField()
    prescribed_reps=models.IntegerField()
    all_out=models.BooleanField()
    intensity=models.IntegerField()
    instruction=models.TextField()
    rest_time=models.FloatField()
    calculated_ability=models.CharField(max_length=100)
    intensity_level=models.CharField(max_length=100)
    extra_ability=models.CharField(max_length=100)
    hypertrophy_potency=models.FloatField()
    lactate_generate_potency=models.FloatField()
    strength_speed_potency=models.FloatField()
    speed_potency=models.FloatField(default=0)
    speed_strength_potency=models.FloatField(default=0)
    maxstrength_potency=models.FloatField(default=0)
    selected_RPE=models.IntegerField(default=0)
    strength_potency_zone=models.CharField(max_length=100)
    strength_endurance_potency=models.FloatField()
    created_By =  models.ForeignKey(User, related_name='placrby',on_delete=models.CASCADE)
    modified_By = models.ForeignKey(User, related_name='plamdby',on_delete=models.CASCADE)
    created_Date = models.DateTimeField(auto_now_add=True)
    modified_Date = models.DateTimeField(auto_now=True)

class PlanProtocol(models.Model):
    protocol = models.ForeignKey(protocols,related_name='planproto',on_delete=models.CASCADE)
    plan = models.ForeignKey(Plan,related_name='planprotos',on_delete=models.CASCADE)
    exercise = models.ForeignKey(NewExercise,related_name='planexercise',on_delete=models.CASCADE, null=True, blank=True)
    mesocycle = models.ForeignKey(Plan_Mesocycle,related_name='planprotomeso',on_delete=models.CASCADE, null=True, blank=True)
    microcycle = models.ForeignKey(Plan_Microcycles,related_name='planprotomicro',on_delete=models.CASCADE, null=True, blank=True)
    day = models.ForeignKey(Plan_Days,related_name='plandaysprotocol',on_delete=models.CASCADE, null=True, blank=True)
    values = models.TextField()
    createdBy = models.ForeignKey(User, related_name='planpcrbyproto',on_delete=models.CASCADE)
    modifiedBy = models.ForeignKey(User, related_name='modppcrbyproto',on_delete=models.CASCADE)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class DraftedPlan(models.Model):
    planId = models.OneToOneField(Plan,related_name='plansjson',on_delete=models.CASCADE)
    planJson = models.TextField(blank=True,null=True)
    protocolJson = models.TextField(blank=True,null=True)
    status = models.BooleanField(default=False)
    createdBy = models.ForeignKey(User, related_name='dftcrt', on_delete=models.CASCADE)
    modifiedBy = models.ForeignKey(User, related_name='dftMod', on_delete=models.CASCADE)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)


class PlanCountry(models.Model):
    plan = models.ForeignKey(Plan,related_name='plaCountrycrby',on_delete=models.CASCADE)
    country = models.ForeignKey(Country,related_name='plaCountrycontry',on_delete=models.CASCADE)

class PlanComments(models.Model):
    plan = models.ForeignKey(Plan,related_name='placomment',on_delete=models.CASCADE)
    reiviewComments = models.TextField()
    status = models.IntegerField(default=0)

class PlanShortUrls(models.Model):
    plan = models.ForeignKey(Plan,related_name='planSurls',on_delete=models.CASCADE)
    shortUrl = models.CharField(max_length=100)
    longUrl = models.TextField()

class GymCountry(models.Model):
    gym = models.ForeignKey(Organization,related_name='planOrg',on_delete=models.CASCADE)
    country = models.ForeignKey(Country,related_name='planCou',on_delete=models.CASCADE)

class CoachCountry(models.Model):
    coach = models.ForeignKey(User,related_name='planCoach',on_delete=models.CASCADE)
    country = models.ForeignKey(Country,related_name='planCountry',on_delete=models.CASCADE)

class CategoryLevel(models.Model):
    category = models.IntegerField()
    mappedAbility = models.ForeignKey(PlanAbilities,related_name='planCategory',on_delete=models.CASCADE)

class PlanExComments(models.Model):
    Exercise = models.ForeignKey(NewExercise,related_name='plancomment',on_delete=models.CASCADE)
    reiviewComments = models.TextField()
    status = models.IntegerField(default=0)

class MetabolicValues(models.Model):
    exercise = models.ForeignKey(NewExercise,related_name='planmeta',on_delete=models.CASCADE)
    parameter = models.TextField(null=True)
    minValue = models.FloatField(null=True)
    maxValue = models.FloatField(null=True)
    metaValue = models.FloatField(null=True)

class PlanExTmax(models.Model):
    exercise = models.ForeignKey(NewExercise,related_name='plan',on_delete=models.CASCADE)
    plan = models.ForeignKey(Plan,related_name='plan',on_delete=models.CASCADE)
    baseDistance = models.BooleanField(null=True)
    baseReps = models.BooleanField(null=True)
    baseTime = models.BooleanField(null=True)
    baseWeight = models.BooleanField(null=True)
    tamxContent = models.TextField(null=True)


