# Generated by Django 4.1.5 on 2023-04-08 12:39

from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='CategoryLevel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('category', models.IntegerField()),
            ],
        ),
        migrations.CreateModel(
            name='CoachCountry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
        ),
        migrations.CreateModel(
            name='DraftedPlan',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('planJson', models.TextField(blank=True, null=True)),
                ('protocolJson', models.TextField(blank=True, null=True)),
                ('status', models.BooleanField(default=False)),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='GymCountry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
        ),
        migrations.CreateModel(
            name='MetabolicValues',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('parameter', models.TextField(null=True)),
                ('minValue', models.FloatField(null=True)),
                ('maxValue', models.FloatField(null=True)),
                ('metaValue', models.FloatField(null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Plan',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('planName', models.CharField(max_length=250)),
                ('planDescription', models.TextField(blank=True, null=True)),
                ('planStatus', models.BooleanField(default=False)),
                ('publishDate', models.DateTimeField(blank=True, null=True)),
                ('price', models.IntegerField(blank=True, null=True)),
                ('ability', models.TextField(blank=True, null=True)),
                ('num_of_periods', models.IntegerField(default=0)),
                ('num_of_sessions', models.IntegerField(default=0)),
                ('goals', models.TextField(blank=True, null=True)),
                ('others', models.TextField(blank=True, null=True)),
                ('licencePolicy', models.CharField(blank=True, max_length=100, null=True)),
                ('duration_weeks', models.IntegerField(blank=True, null=True)),
                ('planPhoto', models.CharField(blank=True, max_length=255, null=True)),
                ('royalty', models.CharField(blank=True, max_length=100, null=True)),
                ('proposedState', models.IntegerField(default=0)),
                ('activationStatus', models.BooleanField(default=True)),
                ('planLogo', models.CharField(blank=True, max_length=255, null=True)),
                ('iosPrice', models.IntegerField(default=0)),
                ('indianPrice', models.FloatField(default=0)),
                ('indianIosPrice', models.FloatField(default=0)),
                ('iosStatus', models.IntegerField(default=0)),
                ('advPlan', models.IntegerField(default=0)),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('updatedDate', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='Plan_Actions',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('pdc_id', models.CharField(default=1, max_length=100)),
                ('parent_id', models.CharField(default=2, max_length=100)),
                ('action_type', models.CharField(default='MainSet', max_length=100)),
                ('intensity_range', models.FloatField()),
                ('num_of_sets', models.IntegerField()),
                ('min_reps', models.IntegerField()),
                ('max_reps', models.IntegerField()),
                ('prescribed_reps', models.IntegerField()),
                ('all_out', models.BooleanField()),
                ('intensity', models.IntegerField()),
                ('instruction', models.TextField()),
                ('rest_time', models.FloatField()),
                ('calculated_ability', models.CharField(max_length=100)),
                ('intensity_level', models.CharField(max_length=100)),
                ('extra_ability', models.CharField(max_length=100)),
                ('hypertrophy_potency', models.FloatField()),
                ('lactate_generate_potency', models.FloatField()),
                ('strength_speed_potency', models.FloatField()),
                ('speed_potency', models.FloatField(default=0)),
                ('speed_strength_potency', models.FloatField(default=0)),
                ('maxstrength_potency', models.FloatField(default=0)),
                ('selected_RPE', models.IntegerField(default=0)),
                ('strength_potency_zone', models.CharField(max_length=100)),
                ('strength_endurance_potency', models.FloatField()),
                ('created_Date', models.DateTimeField(auto_now_add=True)),
                ('modified_Date', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='Plan_Activity',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('Activity_name', models.CharField(max_length=100)),
                ('Activity_type', models.CharField(blank=True, max_length=100)),
                ('pdc_id', models.CharField(default=1, max_length=100)),
                ('parent_id', models.CharField(default=2, max_length=100)),
                ('description', models.TextField()),
                ('status', models.BooleanField(default=False)),
                ('total_load', models.FloatField()),
                ('rest_time', models.FloatField()),
                ('warm_up', models.BooleanField(default=False)),
                ('created_Date', models.DateTimeField(auto_now_add=True)),
                ('modified_Date', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='Plan_Days',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('day_name', models.CharField(max_length=40)),
                ('description', models.TextField()),
                ('status', models.BooleanField(default=False)),
                ('pdc_id', models.CharField(default=1, max_length=100)),
                ('parent_id', models.CharField(default=2, max_length=100)),
                ('num_of_sessions', models.IntegerField()),
                ('total_load', models.FloatField()),
                ('rest_time', models.FloatField()),
                ('created_Date', models.DateTimeField(auto_now_add=True)),
                ('modified_Date', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='Plan_level',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_Date', models.DateTimeField(auto_now_add=True)),
                ('modified_Date', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='Plan_Mesocycle',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mesocycles_name', models.CharField(max_length=100)),
                ('description', models.TextField()),
                ('num_of_microcycles', models.IntegerField()),
                ('pdc_id', models.CharField(default=1, max_length=100)),
                ('parent_id', models.CharField(default=2, max_length=100)),
                ('status', models.BooleanField(default=False)),
                ('created_Date', models.DateTimeField(auto_now_add=True)),
                ('modified_Date', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='Plan_Microcycles',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('micro_name', models.CharField(max_length=100)),
                ('description', models.TextField()),
                ('pdc_id', models.CharField(default=1, max_length=100)),
                ('parent_id', models.CharField(default=2, max_length=100)),
                ('status', models.BooleanField(default=False)),
                ('num_of_days', models.IntegerField()),
                ('total_load', models.FloatField()),
                ('created_Date', models.DateTimeField(auto_now_add=True)),
                ('modified_Date', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='Plan_Period',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('period_name', models.CharField(max_length=40)),
                ('status', models.BooleanField(default=False)),
                ('description', models.TextField()),
                ('pdc_id', models.CharField(default=1, max_length=100)),
                ('parent_id', models.CharField(default=2, max_length=100)),
                ('num_of_mesocycles', models.IntegerField()),
                ('num_of_microcycles', models.IntegerField()),
                ('created_Date', models.DateTimeField(auto_now_add=True)),
                ('modified_Date', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='Plan_Purpose',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_Date', models.DateTimeField(auto_now_add=True)),
                ('modified_Date', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='Plan_Round',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('round_name', models.CharField(max_length=100)),
                ('pdc_id', models.CharField(default=1, max_length=100)),
                ('parent_id', models.CharField(default=2, max_length=100)),
                ('description', models.TextField()),
                ('round_type', models.CharField(blank=True, max_length=100)),
                ('status', models.BooleanField(default=False)),
                ('num_of_actions', models.IntegerField()),
                ('total_load', models.FloatField()),
                ('rest_time', models.FloatField()),
                ('created_Date', models.DateTimeField(auto_now_add=True)),
                ('modified_Date', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='Plan_Sessions',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('session_name', models.CharField(max_length=100)),
                ('description', models.TextField()),
                ('pdc_id', models.CharField(default=1, max_length=100)),
                ('parent_id', models.CharField(default=2, max_length=100)),
                ('status', models.BooleanField(default=False)),
                ('num_of_exercises', models.IntegerField()),
                ('total_load', models.FloatField()),
                ('rest_time', models.FloatField()),
                ('created_Date', models.DateTimeField(auto_now_add=True)),
                ('modified_Date', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='PlanComments',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('reiviewComments', models.TextField()),
                ('status', models.IntegerField(default=0)),
            ],
        ),
        migrations.CreateModel(
            name='PlanCountry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
        ),
        migrations.CreateModel(
            name='PlanExComments',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('reiviewComments', models.TextField()),
                ('status', models.IntegerField(default=0)),
            ],
        ),
        migrations.CreateModel(
            name='PlanExTmax',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('baseDistance', models.BooleanField(null=True)),
                ('baseReps', models.BooleanField(null=True)),
                ('baseTime', models.BooleanField(null=True)),
                ('baseWeight', models.BooleanField(null=True)),
                ('tamxContent', models.TextField(null=True)),
            ],
        ),
        migrations.CreateModel(
            name='PlanGoals',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='PlanProtocol',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('values', models.TextField()),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='PlanRating',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('rating', models.FloatField(blank=True, null=True)),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDare', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='PlanShortUrls',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('shortUrl', models.CharField(max_length=100)),
                ('longUrl', models.TextField()),
            ],
        ),
        migrations.CreateModel(
            name='PlanVideos',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('video', models.CharField(blank=True, max_length=100, null=True)),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='SelectedAbilities',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
            ],
        ),
    ]
