from django.db import models

# Create your models here.
from StratFitOrganization.models import Organization
from Subscriber.models import User
from utility.models import ProgramType, Videos, Goals, protocols,Exercise, PlanPurposes, PlanAbilities, Country


class Plan(models.Model):
    programType = models.ForeignKey(ProgramType, on_delete=models.CASCADE)
    planName = models.CharField(max_length=250, blank=False)
    planDescription = models.TextField(blank=True, null=True)
    planStatus = models.BooleanField(default=False)
    planGoal = models.ForeignKey(Goals, blank=True, null = True, on_delete=models.CASCADE)
    publishDate = models.DateTimeField(blank=True, null = True)
    price = models.IntegerField(blank=True,null=True)
    ability = models.TextField(blank=True,null=True)
    num_of_periods = models.IntegerField(default=0)
    num_of_sessions = models.IntegerField(default=0)
    goals = models.TextField(null=True,blank=True)
    licencePolicy = models.CharField(max_length=100,null=True,blank=True)
    duration_weeks = models.IntegerField(null=True,blank=True)
    planPhoto = models.CharField(max_length=255,null=True,blank=True)
    originalPlanId = models.ForeignKey('self', related_name='slef_id',blank=True,null=True, on_delete=models.CASCADE)
    originalPlanner = models.ForeignKey(User, related_name='original_planner', on_delete=models.CASCADE )
    royalty = models.CharField(max_length=100,blank=True, null=True)
    proposedState = models.IntegerField(default=0)
    activationStatus = models.BooleanField(default=True)
    planLogo = models.CharField(max_length=255,null=True,blank=True)
    iosPrice = models.IntegerField(default=0)
    indianPrice = models.FloatField(default=0)
    indianIosPrice = models.FloatField(default=0)
    iosStatus = models.IntegerField(default=0)
    advPlan  = models.IntegerField(default=0)
    createdBy = models.ForeignKey(User, related_name='pl_creator', on_delete=models.CASCADE)
    modifiedBy = models.ForeignKey(User, related_name='pl_modifier', on_delete=models.CASCADE)
    createdDate = models.DateTimeField(auto_now_add=True)
    updatedDate = models.DateTimeField(auto_now=True)
    copyPlan = models.ForeignKey('self', related_name='slef_planId',null=True, on_delete=models.CASCADE)

class PlanVideos(models.Model):
    video = models.ForeignKey(Videos,null=True,blank=True, on_delete=models.CASCADE)
    plan = models.ForeignKey(Plan,null=True, on_delete=models.CASCADE)
    createdBy = models.ForeignKey(User, related_name='plvideo', on_delete=models.CASCADE)
    modifiedBy = models.ForeignKey(User, related_name='plvideoMod', on_delete=models.CASCADE)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class PlanPeriods(models.Model):
    plan = models.ForeignKey(Plan, on_delete=models.CASCADE)
    periodName = models.CharField(max_length=200,null=True,blank=True)
    status = models.BooleanField(default=True)
    description = models.TextField(null=True,blank=True)
    num_of_mesocycles = models.IntegerField( default=0)
    duration_weeks = models.IntegerField(null=True,blank=True)
    createdBy = models.ForeignKey(User, related_name='pperiod', on_delete=models.CASCADE)
    modifiedBy = models.ForeignKey(User, related_name='ppMod', on_delete=models.CASCADE)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class PlanMesocycle(models.Model):
    period = models.ForeignKey(PlanPeriods, on_delete=models.CASCADE)
    status = models.BooleanField(default=True)
    num_of_microcycles = models.IntegerField(default=0)
    duration_weeks = models.IntegerField(null=True,blank=True)
    createdBy = models.ForeignKey(User, related_name='pmmeso1', on_delete=models.CASCADE)
    modifiedBy = models.ForeignKey(User, related_name='pmmod1', on_delete=models.CASCADE)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class Microcycle(models.Model):
    mesocycle = models.ForeignKey(PlanMesocycle, on_delete=models.CASCADE)
    status = models.BooleanField(default=True)
    no_of_sessions = models.IntegerField(default=0)
    totalInol = models.FloatField(null=True,blank=True)
    dayOff = models.CharField(max_length=200,null=True,blank=True)
    createdBy = models.ForeignKey(User, related_name='mic', on_delete=models.CASCADE)
    modifiedBy = models.ForeignKey(User, related_name='modmic', on_delete=models.CASCADE)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class PlanSession(models.Model):
    microcycle = models.ForeignKey(Microcycle, on_delete=models.CASCADE)
    status = models.BooleanField(default=True)
    no_of_excersices = models.IntegerField(default=0)
    restTime = models.IntegerField(null=True,blank=True)
    totalInol = models.FloatField(null=True,blank=True)
    repeat = models.BooleanField(null=True, default=False)
    createdBy = models.ForeignKey(User, related_name='pls', on_delete=models.CASCADE)
    modifiedBy = models.ForeignKey(User, related_name='modpls', on_delete=models.CASCADE)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class PlanExcercise(models.Model):
    exerciseName = models.ForeignKey(Exercise,null=True,related_name='Ex', on_delete=models.CASCADE)
    session = models.ForeignKey(PlanSession, on_delete=models.CASCADE)
    status = models.BooleanField(default=True)
    num_of_sets = models.IntegerField(null=True,blank=True)
    num_of_reps = models.IntegerField(default=1)
    extra_set = models.IntegerField(default=0)
    totalInol = models.FloatField(null=True,blank=True)
    intensity = models.IntegerField(null=True,blank=True)
    intensityRange = models.IntegerField(default=0)
    restTime = models.FloatField(null=True,blank=True)
    warmup = models.SmallIntegerField(default=0)
    warmupType = models.CharField(max_length=20,blank=True,null=True)
    specificInstruction = models.TextField(null=True,blank=True)
    ability = models.CharField(max_length=250,null=True,blank=True)
    transitExercise = models.ForeignKey(Exercise,null=True,blank=True,related_name='TransEx', on_delete=models.CASCADE)
    transitLevel = models.CharField(max_length=100, null=True, blank=True)
    advExercise = models.BooleanField(default=False)
    exWeight = models.IntegerField(null=True)
    exDistance = models.IntegerField(null=True)
    exTime = models.FloatField(null=True)
    speed = models.FloatField(null=True,blank=True)
    height = models.FloatField(null=True,blank=True)
    createdBy = models.ForeignKey(User, related_name='pe', on_delete=models.CASCADE)
    modifiedBy = models.ForeignKey(User, related_name='modpe', on_delete=models.CASCADE)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class PlanSets(models.Model):
    excercise = models.ForeignKey(PlanExcercise, on_delete=models.CASCADE)
    #complexExercise = models.ForeignKey(Exercise,null=True,related_name='setEx')
    status = models.BooleanField(default=True)
    num_of_reps = models.IntegerField(default=1)
    repsRange = models.IntegerField(default=0)
    repsRangeAbs = models.BooleanField(null=True, blank=True, default=1)
    totalInol = models.FloatField(null=True,blank=True)
    #complexIntensity = models.IntegerField(null=True, blank=True)
    allOutStat = models.SmallIntegerField(default=0)
    restTime = models.FloatField(null=True,blank=True)
    advExercise = models.BooleanField(default=False)
    exWeight = models.IntegerField(null=True)
    exDistance = models.IntegerField(null=True)
    exTime = models.FloatField(null=True)
    speed = models.FloatField(null=True,blank=True)
    height = models.FloatField(null=True,blank=True)
    createdBy = models.ForeignKey(User, related_name='ps', on_delete=models.CASCADE)
    modifiedBy = models.ForeignKey(User, related_name='modps', on_delete=models.CASCADE)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class PlanRating(models.Model):
    plan = models.ForeignKey(Plan, on_delete=models.CASCADE)
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    rating = models.FloatField(null=True,blank=True)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDare  = models.DateTimeField(auto_now=True)

class PlanProtocol(models.Model):
    protocol = models.ForeignKey(protocols, on_delete=models.CASCADE)
    plan = models.ForeignKey(Plan, on_delete=models.CASCADE)
    exercise = models.ForeignKey(Exercise, null=True, blank=True, on_delete=models.CASCADE)
    mesocycle = models.ForeignKey(PlanMesocycle, null=True, blank=True, on_delete=models.CASCADE)
    microcycle = models.ForeignKey(Microcycle, null=True, blank=True, on_delete=models.CASCADE)
    userexercise = models.ForeignKey(PlanExcercise, null=True, blank=True, on_delete=models.CASCADE)
    set = models.ForeignKey(PlanSets, null=True, blank=True, on_delete=models.CASCADE)
    values = models.TextField()
    createdBy = models.ForeignKey(User, related_name='pp', on_delete=models.CASCADE)
    modifiedBy = models.ForeignKey(User, related_name='modpp', on_delete=models.CASCADE)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class PlanGoals(models.Model):
    planGoal = models.ForeignKey(PlanPurposes, on_delete=models.CASCADE)
    plan = models.ForeignKey(Plan, on_delete=models.CASCADE)
    createdBy = models.ForeignKey(User, related_name='pG', on_delete=models.CASCADE)
    modifiedBy = models.ForeignKey(User, related_name='mG', on_delete=models.CASCADE)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class SelectedAbilities(models.Model):
    ability = models.ForeignKey(PlanAbilities, on_delete=models.CASCADE)
    plan = models.ForeignKey(Plan, on_delete=models.CASCADE)
    createdBy = models.ForeignKey(User, related_name='pA', on_delete=models.CASCADE)
    modifiedBy = models.ForeignKey(User, related_name='mAp', on_delete=models.CASCADE)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class DraftedPlan(models.Model):
    planId = models.OneToOneField(Plan, on_delete=models.CASCADE)
    planJson = models.TextField(blank=True,null=True)
    protocolJson = models.TextField(blank=True,null=True)
    status = models.BooleanField(default=False)
    createdBy = models.ForeignKey(User, related_name='pbj', on_delete=models.CASCADE)
    modifiedBy = models.ForeignKey(User, related_name='pbjMod', on_delete=models.CASCADE)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class PlanCountry(models.Model):
    plan = models.ForeignKey(Plan, on_delete=models.CASCADE)
    country = models.ForeignKey(Country, on_delete=models.CASCADE)

class PlanComments(models.Model):
    plan = models.ForeignKey(Plan, on_delete=models.CASCADE)
    reiviewComments = models.TextField()
    status = models.IntegerField(default=0)

class PlanShortUrls(models.Model):
    plan = models.ForeignKey(Plan, on_delete=models.CASCADE)
    shortUrl = models.CharField(max_length=100)
    longUrl = models.TextField()

class GymCountry(models.Model):
    gym = models.ForeignKey(Organization, on_delete=models.CASCADE)
    country = models.ForeignKey(Country, on_delete=models.CASCADE)

class CoachCountry(models.Model):
    coach = models.ForeignKey(User, on_delete=models.CASCADE)
    country = models.ForeignKey(Country, on_delete=models.CASCADE)

class CategoryLevel(models.Model):
    category = models.IntegerField()
    mappedAbility = models.ForeignKey(PlanAbilities, on_delete=models.CASCADE)

class PlanExComments(models.Model):
    Exercise = models.ForeignKey(Exercise, on_delete=models.CASCADE)
    reiviewComments = models.TextField()
    status = models.IntegerField(default=0)

class MetabolicValues(models.Model):
    exercise = models.ForeignKey(Exercise, on_delete=models.CASCADE)
    parameter = models.TextField(null=True)
    minValue = models.FloatField(null=True)
    maxValue = models.FloatField(null=True)
    metaValue = models.FloatField(null=True)

class PlanExTmax(models.Model):
    exercise = models.ForeignKey(Exercise, on_delete=models.CASCADE)
    plan = models.ForeignKey(Plan, on_delete=models.CASCADE)
    baseDistance = models.BooleanField(null=True)
    baseReps = models.BooleanField(null=True)
    baseTime = models.BooleanField(null=True)
    baseWeight = models.BooleanField(null=True)
    tamxContent = models.TextField(null=True)