# Generated by Django 4.1.5 on 2023-04-08 12:39

from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='CategoryLevel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('category', models.IntegerField()),
            ],
        ),
        migrations.CreateModel(
            name='CoachCountry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
        ),
        migrations.CreateModel(
            name='DraftedPlan',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('planJson', models.TextField(blank=True, null=True)),
                ('protocolJson', models.TextField(blank=True, null=True)),
                ('status', models.BooleanField(default=False)),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='GymCountry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
        ),
        migrations.CreateModel(
            name='MetabolicValues',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('parameter', models.TextField(null=True)),
                ('minValue', models.FloatField(null=True)),
                ('maxValue', models.FloatField(null=True)),
                ('metaValue', models.FloatField(null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Microcycle',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.BooleanField(default=True)),
                ('no_of_sessions', models.IntegerField(default=0)),
                ('totalInol', models.FloatField(blank=True, null=True)),
                ('dayOff', models.CharField(blank=True, max_length=200, null=True)),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='Plan',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('planName', models.CharField(max_length=250)),
                ('planDescription', models.TextField(blank=True, null=True)),
                ('planStatus', models.BooleanField(default=False)),
                ('publishDate', models.DateTimeField(blank=True, null=True)),
                ('price', models.IntegerField(blank=True, null=True)),
                ('ability', models.TextField(blank=True, null=True)),
                ('num_of_periods', models.IntegerField(default=0)),
                ('num_of_sessions', models.IntegerField(default=0)),
                ('goals', models.TextField(blank=True, null=True)),
                ('licencePolicy', models.CharField(blank=True, max_length=100, null=True)),
                ('duration_weeks', models.IntegerField(blank=True, null=True)),
                ('planPhoto', models.CharField(blank=True, max_length=255, null=True)),
                ('royalty', models.CharField(blank=True, max_length=100, null=True)),
                ('proposedState', models.IntegerField(default=0)),
                ('activationStatus', models.BooleanField(default=True)),
                ('planLogo', models.CharField(blank=True, max_length=255, null=True)),
                ('iosPrice', models.IntegerField(default=0)),
                ('indianPrice', models.FloatField(default=0)),
                ('indianIosPrice', models.FloatField(default=0)),
                ('iosStatus', models.IntegerField(default=0)),
                ('advPlan', models.IntegerField(default=0)),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('updatedDate', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='PlanComments',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('reiviewComments', models.TextField()),
                ('status', models.IntegerField(default=0)),
            ],
        ),
        migrations.CreateModel(
            name='PlanCountry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
        ),
        migrations.CreateModel(
            name='PlanExcercise',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.BooleanField(default=True)),
                ('num_of_sets', models.IntegerField(blank=True, null=True)),
                ('num_of_reps', models.IntegerField(default=1)),
                ('extra_set', models.IntegerField(default=0)),
                ('totalInol', models.FloatField(blank=True, null=True)),
                ('intensity', models.IntegerField(blank=True, null=True)),
                ('intensityRange', models.IntegerField(default=0)),
                ('restTime', models.FloatField(blank=True, null=True)),
                ('warmup', models.SmallIntegerField(default=0)),
                ('warmupType', models.CharField(blank=True, max_length=20, null=True)),
                ('specificInstruction', models.TextField(blank=True, null=True)),
                ('ability', models.CharField(blank=True, max_length=250, null=True)),
                ('transitLevel', models.CharField(blank=True, max_length=100, null=True)),
                ('advExercise', models.BooleanField(default=False)),
                ('exWeight', models.IntegerField(null=True)),
                ('exDistance', models.IntegerField(null=True)),
                ('exTime', models.FloatField(null=True)),
                ('speed', models.FloatField(blank=True, null=True)),
                ('height', models.FloatField(blank=True, null=True)),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='PlanExComments',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('reiviewComments', models.TextField()),
                ('status', models.IntegerField(default=0)),
            ],
        ),
        migrations.CreateModel(
            name='PlanExTmax',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('baseDistance', models.BooleanField(null=True)),
                ('baseReps', models.BooleanField(null=True)),
                ('baseTime', models.BooleanField(null=True)),
                ('baseWeight', models.BooleanField(null=True)),
                ('tamxContent', models.TextField(null=True)),
            ],
        ),
        migrations.CreateModel(
            name='PlanGoals',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='PlanMesocycle',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.BooleanField(default=True)),
                ('num_of_microcycles', models.IntegerField(default=0)),
                ('duration_weeks', models.IntegerField(blank=True, null=True)),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='PlanPeriods',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('periodName', models.CharField(blank=True, max_length=200, null=True)),
                ('status', models.BooleanField(default=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('num_of_mesocycles', models.IntegerField(default=0)),
                ('duration_weeks', models.IntegerField(blank=True, null=True)),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='PlanProtocol',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('values', models.TextField()),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='PlanRating',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('rating', models.FloatField(blank=True, null=True)),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDare', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='PlanSession',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.BooleanField(default=True)),
                ('no_of_excersices', models.IntegerField(default=0)),
                ('restTime', models.IntegerField(blank=True, null=True)),
                ('totalInol', models.FloatField(blank=True, null=True)),
                ('repeat', models.BooleanField(default=False, null=True)),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='PlanSets',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.BooleanField(default=True)),
                ('num_of_reps', models.IntegerField(default=1)),
                ('repsRange', models.IntegerField(default=0)),
                ('repsRangeAbs', models.BooleanField(blank=True, default=1, null=True)),
                ('totalInol', models.FloatField(blank=True, null=True)),
                ('allOutStat', models.SmallIntegerField(default=0)),
                ('restTime', models.FloatField(blank=True, null=True)),
                ('advExercise', models.BooleanField(default=False)),
                ('exWeight', models.IntegerField(null=True)),
                ('exDistance', models.IntegerField(null=True)),
                ('exTime', models.FloatField(null=True)),
                ('speed', models.FloatField(blank=True, null=True)),
                ('height', models.FloatField(blank=True, null=True)),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='PlanShortUrls',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('shortUrl', models.CharField(max_length=100)),
                ('longUrl', models.TextField()),
            ],
        ),
        migrations.CreateModel(
            name='PlanVideos',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='SelectedAbilities',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
            ],
        ),
    ]
