from django.shortcuts import render
from Nutrition.models import Food_info,userDiet_info,HealthInfo,BMIInfo,DietSchedule,userDietPlan,Dietlog,Diet
# Create your views here.
from django.db import IntegrityError, connection
from StratFit import settings
from rest_framework.views import APIView
from rest_framework.response import Response
from django.views.decorators.cache import never_cache
import json
from django.forms.models import model_to_dict
from Subscriber.models import User
from rest_framework.decorators import api_view, authentication_classes
try: # for pip >= 10
    from pip._internal.req.req_install import logger
except ImportError: # for pip <= 9.0.3
    from pip.req.req_install import logger
import csv,io
from datetime import datetime
from smart_open import smart_open
from io import StringIO
import numpy as np
from django.http import HttpResponse
from django.http import JsonResponse
import pandas as pd
from django.db import transaction
from Subscriber.Authentication import StartFitAuthentication, SessionAuthentication, StartFitSessionUtil, AuthResponse, \
    IsAuthenticated

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache

def load_Food(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        nutrient = stratsessionutil.get_user_insession(request)
        if nutrient!= None:
            response = HttpResponse(content_type='text/csv')
            response['Content-Disposition'] = 'attachment; filename="food.csv"'
            if request.method == "GET":
                return render(request)
            csv_file = request.FILES['food'] 
            car = csv_file.read().decode('UTF-8')
            
            io_string = io.StringIO(car)
            next(io_string)
            
            for column in csv.reader(io_string,delimiter=','):
                print(column[0],"fggggggggggujew")
                

                obj,created=Food_info.objects.update_or_create(
                    Food=str(column[0]),
                    
                    defaults={'Food':str(column[0]),'Quantity':str(column[1]),
                    'Calories':str(column[2]),
                    'Carbohydrates':str(column[3]),
                    'Protein':str(column[4]),
                    'Fat':str(column[5]),
                    'Fibre':str(column[6]),
                    'unit':str(column[1])})
                print(obj,created)
        
            return JsonResponse({"success":True,"message":"food loaded successfully"})
        else:
            return JsonResponse({"success":False,"message":"User logged out"})    
    except Exception as e:
        logger.error("error")
        return JsonResponse({"msg": str(e),"success":False})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def Delete_Food(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        nutrient = stratsessionutil.get_user_insession(request)
        if nutrient!= None:
            #food=Food_info.objects.all().delete()
            cursor = connection.cursor()
            cursor.execute("TRUNCATE TABLE `nutrition_food_info`")
            return JsonResponse({"success":True,"message":"food deleted successfully"})
        else:
            return JsonResponse({"success":False,"message":"User logged out"})    
    except Exception as e:
        logger.error("error")
        return JsonResponse({"msg": str(e),"success":False})        


@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def removeFood(request):
    stratsessionutil=StartFitSessionUtil()
    try:
        nutrient=stratsessionutil.get_user_insession(request)
        foodinfo=json.loads(request.body.decode('utf-8'))
        if nutrient!=None:
            food=Food_info.objects.filter(Food=foodinfo['name']).delete()
            return JsonResponse({"message":"Food deleted successfully","success":True})
        else:
            return JsonResponse({"message":"User logged out","success":False})
    except Exception as e:
        logger.error("error")
        return JsonResponse({"msg": str(e),"success":False})         
            

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def addFood(request):
    stratsessionutil=StartFitSessionUtil()
    try:
        nutrient=stratsessionutil.get_user_insession(request)
        foodinfo=json.loads(request.body.decode('utf-8'))
        if nutrient!=None:
            if 'id' in foodinfo and foodinfo['id']!=None:
                Food=Food_info.objects.filter(id=foodinfo['id'])
                num=foodinfo['id']
                if Food.exists():
                    print("jjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjj")
                    food =Food_info.objects.get(id=num)
                    print(":;;;;;;;;;")
                    if 'food' in foodinfo :
                        food.Food=foodinfo['food']
                    if 'Quantity' in foodinfo:
                        food.Quantity=foodinfo['Quantity']
                        food.unit=foodinfo['Quantity']
                    if 'Calories' in foodinfo:
                        food.Calories=foodinfo['Calories']
                    if 'Carbohydrates' in foodinfo:
                        food.Carbohydrates =foodinfo['Carbohydrates']
                    if 'Protein' in foodinfo:
                        food.Protein=foodinfo['Protein']
                    if 'Fat' in foodinfo: 
                        food.Fat=foodinfo['Fat']
                    if 'Fibre' in foodinfo:
                        food.Fibre=foodinfo['Fibre']   
                    food.save() 
            else:
                '''
                query = request.GET.get('q','')
                #The empty string handles an empty "request"
                if query:
                    queryset = (Q(text__icontains=query))
                    results = Food_info.objects.filter(queryset).distinct()
                '''    
                food=Food_info.objects.filter(Food=foodinfo['food'])
                if food.exists():
                    
                    return JsonResponse({"success":True,"message":"Food name already exists please give the Id"})
                else:
                    
                    food=Food_info.objects.create(Food=foodinfo['food'])
                    food.save()
                    if 'Quantity' in foodinfo:
                        food.Quantity=foodinfo['Quantity']
                        food.unit=foodinfo['Quantity']
                    if 'Calories' in foodinfo:
                        food.Calories=foodinfo['Calories']
                    if 'Carbohydrates' in foodinfo:
                        food.Carbohydrates =foodinfo['Carbohydrates']
                    if 'Protein' in foodinfo:
                        food.Protein=foodinfo['Protein']
                    if 'Fat' in foodinfo: 
                        food.Fat=foodinfo['Fat']
                    if 'Fibre' in foodinfo:
                        food.Fibre=foodinfo['Fibre']
                    food.save()
            return JsonResponse({"success":True,"message":"food saved successfully"})
        else:
            return JsonResponse({"success":False,"message":"User logged out"})    
    except Exception as e:
        logger.error("error")
        return JsonResponse({"msg": str(e),"success":False})
@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def fetch_food(request):
    print("dvgggggggggggggggggggggg")
    
    stratsessionutil = StartFitSessionUtil()
    try:
        nutrient = stratsessionutil.get_user_insession(request)

        if nutrient!= None:
            array=[]
            Diet={}
            
            foodinfo=json.loads(request.body.decode('utf-8'))
            if 'name' in foodinfo :
                foodload=Food_info.objects.filter(Food__icontains=foodinfo['name'])
            else:
                foodload=Food_info.objects.all()    
        
            if 'rows' in foodinfo and 'rows' != '' and 'page' in foodinfo and 'page' != '':
                rows = int(foodinfo['rows'])
                page=int(foodinfo['page'])
                offset = (page - 1) * rows
                tot = page * rows   
                food = foodload[offset:tot] 
            else:
                food = foodload
            
               
            total = len(foodload)
            
            for dt in food:
                print("herererer")
                diet=model_to_dict(dt)
                diet['Food']=diet['Food'].capitalize()
                print(diet['Food'])
                id=diet['id']
                name=diet['Food']
                fat= diet['Fat']
                print(name,fat)
                calories=diet['Calories']
                carbs=diet['Carbohydrates']
                protein=diet['Protein']
                carbPercent=0
                proteinPercent=0
                print(protein,"gggggggggggggggggggggggggggg")
                if type(protein) == str or type(carbs) == str  or type(fat) ==str or type(calories) == str:
                # {id:1,name:'Apple',calories:72,fat:0.23,carbs:19.06,protien:0.36, fatPercent:3,carbPercent:95,protienPercent:2}

                    Diet['id']=diet['id']
                    Diet['name']=diet['Food']
                    if type(protein) ==  str :
                        Diet['protein']=diet['Protein']
                    else:
                        Diet['protein']=float(diet['Protein'])   
                    if type(carbs) == str  :
                        Diet['carbs']=diet['Carbohydrates']
                    else:
                        Diet['carbs']=float(diet['Carbohydrates'])
                    if type(fat) == str:
                        Diet['fat']=diet['Fat']
                    else:
                        Diet['fat']=float(diet['Fat'])
                    if type(calories) == str:
                        Diet['calories'] = diet['Calories']
                    else:
                        Diet['calories'] = float(diet['Calories'])                
                    fatpercent=0 
                    carbPercent=0
                    proteinPercent=0
                    diet['fatPercent'] = fatpercent
                    diet['carbPercent'] = 0
                    diet['proteinPercent'] = 0
                    Diet['fatPercent']=float(diet['fatPercent'])
                    Diet['carbPercent']=float(diet['carbPercent'])
                    Diet['proteinPercent']=float(diet['proteinPercent'])
                    Diet['units']=diet['Quantity']
                    array.append(Diet)
                    Diet={}
                else:
                    
                    Diet['id']=diet['id']
                    Diet['name']=diet['Food']
                    Diet['calories'] = float(diet['Calories'])
                    Diet['protein']=float(diet['Protein'])
                    Diet['fat']=float(diet['Fat'])
                    Diet['carbs']=float(diet['Carbohydrates'])
                
                    print(diet['Food'])
                    Fat=float(fat)
                    Carbs=float(carbs)
                    Protein=float(protein)
                    
                    fatpercent = (Fat/(Fat+Carbs+Protein))*100
                    carbPercent=(Carbs/(Carbs+Fat+Protein))*100
                    proteinpercent=(Protein/(Carbs+Fat+Protein))*100
                    g = float("{:.2f}".format(fatpercent))
                    h= float("{:.2f}".format(carbPercent))
                    b=float("{:.2f}".format(proteinpercent))
                    print("gddddddgdgdgdgdg")
                    Diet['fatPercent']=float(g)
                    Diet['carbPercent']=float(h)
                    Diet['proteinPercent']=float(b)
                    Diet['units']=diet['Qunatity']
                    array.append(Diet)
                    Diet={}
                #array.append(Diet)
            
            
            
            return JsonResponse({"success":True,"message" :array,"total":total})
        else:
            return JsonResponse({"success":False,"message":"User logged out"})    
    except Exception as e:
        logger.error("error")
        return JsonResponse({"msg": str(e),"success":False})



@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache  
def foodsearch(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        nutrient = stratsessionutil.get_user_insession(request)
        if nutrient!= None:
            foodinfo=json.loads(request.body.decode('utf-8'))
            array=[]
            c=[]
            food=foodinfo['name']
            foodload=Food_info.objects.filter(Food__icontains=food)
            c.append(foodload)
            print(c,"jjjjjjjjjj")
            for i in c:
                for dt in i:
                    diet=model_to_dict(dt)
                    array.append(diet)
            return JsonResponse({"success":True,"message":array})  
        else:    
            return JsonResponse({"succses":False,"message":"user logged out"})  
    except Exception as e:
            logger.exception("something wrong")
            return JsonResponse({"msg": str(e)})



@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache          
def DietDetails(request):
    stratsessionutil = StartFitSessionUtil()
    print("Iam hi")
    try:
            
        nutrient = stratsessionutil.get_user_insession(request)
        print("hereeeeeeeeeeee")
        info = json.loads(request.body.decode('utf-8'))
        num = nutrient['id']
        print(num)
        array=[]
        Dietdetails={}
        if nutrient != None:
            diet_timings=userDiet_info.objects.filter(user=num)
            hthinfo=HealthInfo.objects.filter(user=num)
            if diet_timings.exists():
         
                diet_schedule=userDiet_info.objects.get(user=num)
                if diet_schedule:
                    if 'On_waking_up' in info:
                        diet_schedule.On_waking_up = info['On_waking_up']
                        Dietdetails['On_waking_up']=diet_schedule.On_waking_up
                        
                    if 'On_waking_time' in info:
                        diet_schedule.On_waking_time = info['On_waking_time']
                        Dietdetails['On_waking_time']=diet_schedule.On_waking_time    
                    if 'BreakFast' in info:     
                        diet_schedule.BreakFast = info['BreakFast']
                        Dietdetails['BreakFast']=diet_schedule.BreakFast
                    if 'BreakFast_time' in info:     
                        diet_schedule.BreakFast_time = info['BreakFast_time']
                        Dietdetails['BreakFast_time']=diet_schedule.BreakFast_time
                            
                    if 'Mid_morning' in info:   
                        diet_schedule.Mid_morning = info['Mid_morning']
                        Dietdetails['Mid_morning']=diet_schedule.Mid_morning
                    if 'Mid_morn_time' in info:   
                        diet_schedule.Mid_morn_time = info['Mid_morn_time']
                        Dietdetails['Mid_morn_time']=diet_schedule.Mid_morn_time    
                       
                    if 'Lunch' in info:    
                        diet_schedule.Lunch = info['Lunch']
                        Dietdetails['Lunch']=diet_schedule.Lunch
                    if 'Lunch_time' in info:    
                        diet_schedule.Lunch_time = info['Lunch_time']
                        Dietdetails['Lunch_time']=diet_schedule.Lunch_time    
                    if 'Evening_snack' in info:    
                        diet_schedule.Evening_snack = info['Evening_snack']
                        Dietdetails['Evening_snack']=diet_schedule.Evening_snack
                    if 'Evening_snack_time' in info:    
                        diet_schedule.Evening_snack_time = info['Evening_snack_time']
                        Dietdetails['Evening_snack_time']=diet_schedule.Evening_snack_time    
                    if 'Dinner' in info:    
                        diet_schedule.Dinner = info['Dinner']
                        Dietdetails['Dinner']=diet_schedule.Dinner   
                    if 'Dinner_time' in info:    
                        diet_schedule.Dinner = info['Dinner_time']
                        Dietdetails['Dinner_time']=diet_schedule.Dinner_time    

                    if 'Bed_Time' in info:    
                        diet_schedule.Bed_Time = info['Bed_Time']
                        Dietdetails['Bed_Time']=diet_schedule.Bed_Time
                    if 'Bed_Time_Food' in info:    
                        diet_schedule.Bed_Time_Food = info['Bed_Time_Food']
                        Dietdetails['Bed_Time_Food']=diet_schedule.Bed_Time_Food
                            
                    diet_schedule.save()
                    
                    
            else:
                print("elseeee")
                diet_schedule = userDiet_info.objects.create(user_id=num,
                                                    createdBy_id=num,
                                                    modifiedBy_id=num)
                diet_schedule.save()                                    
                if 'On_waking_up' in info:
                    diet_schedule.On_waking_up = info['On_waking_up']
                    Dietdetails['On_waking_up']=diet_schedule.On_waking_up
                    
                if 'On_waking_time' in info:
                    diet_schedule.On_waking_time = info['On_waking_time']
                    Dietdetails['On_waking_time']=diet_schedule.On_waking_time    
                if 'BreakFast' in info:     
                    diet_schedule.BreakFast = info['BreakFast']
                    Dietdetails['BreakFast']=diet_schedule.BreakFast
                if 'BreakFast_time' in info:     
                    diet_schedule.BreakFast_time = info['BreakFast_time']
                    Dietdetails['BreakFast_time']=diet_schedule.BreakFast_time
                        
                if 'Mid_morning' in info:   
                    diet_schedule.Mid_morning = info['Mid_morning']
                    Dietdetails['Mid_morning']=diet_schedule.Mid_morning
                if 'Mid_morn_time' in info:   
                    diet_schedule.Mid_morn_time = info['Mid_morn_time']
                    Dietdetails['Mid_morn_time']=diet_schedule.Mid_morn_time    
                    
                if 'Lunch' in info:    
                    diet_schedule.Lunch = info['Lunch']
                    Dietdetails['Lunch']=diet_schedule.Lunch
                if 'Lunch_time' in info:    
                    diet_schedule.Lunch_time = info['Lunch_time']
                    Dietdetails['Lunch_time']=diet_schedule.Lunch_time    
                if 'Evening_snack' in info:    
                    diet_schedule.Evening_snack = info['Evening_snack']
                    Dietdetails['Evening_snack']=diet_schedule.Evening_snack
                if 'Evening_snack_time' in info:    
                    diet_schedule.Evening_snack_time = info['Evening_snack_time']
                    Dietdetails['Evening_snack_time']=diet_schedule.Evening_snack_time    
                if 'Dinner' in info:    
                    diet_schedule.Dinner = info['Dinner']
                    Dietdetails['Dinner']=diet_schedule.Dinner   
                if 'Dinner_time' in info:    
                    diet_schedule.Dinner = info['Dinner_time']
                    Dietdetails['Dinner_time']=diet_schedule.Dinner_time    

                if 'Bed_Time' in info:    
                    diet_schedule.Bed_Time = info['Bed_Time']
                    Dietdetails['Bed_Time']=diet_schedule.Bed_Time
                if 'Bed_Time_Food' in info:    
                    diet_schedule.Bed_Time_Food = info['Bed_Time_Food']
                    Dietdetails['Bed_Time_Food']=diet_schedule.Bed_Time_Food
                        
                diet_schedule.save()

            Dietdetails['On_waking_up']=diet_schedule.On_waking_up
            Dietdetails['On_waking_time']=diet_schedule.On_waking_time
            Dietdetails['BreakFast']=diet_schedule.BreakFast
            Dietdetails['BreakFast_time']=diet_schedule.BreakFast_time
            Dietdetails['Mid_morning']=diet_schedule.Mid_morning
            Dietdetails['Mid_morn_time']=diet_schedule.Mid_morn_time
            Dietdetails['Lunch']=diet_schedule.Lunch
            Dietdetails['Lunch_time']=diet_schedule.Lunch_time
            Dietdetails['Evening_snack']=diet_schedule.Evening_snack
            Dietdetails['Evening_snack_time']=diet_schedule.Evening_snack_time
            Dietdetails['Dinner']=diet_schedule.Dinner
            Dietdetails['Dinner_time']=diet_schedule.Dinner_time
            Dietdetails['Bed_Time']=diet_schedule.Bed_Time
            Dietdetails['Bed_Time_Food']=diet_schedule.Bed_Time_Food
                                        
            if hthinfo.exists():

                hea=HealthInfo.objects.get(user=num)
                if  hea:
                    if 'occupation' in info:
                        hea.occupation = info['occupation']
                        Dietdetails['occupation']=hea.occupation
                    if 'Allergies' in info:
                        hea.Allergies = info['Allergies']
                        print(type(info['Allergies']))
                        Dietdetails['Allergies']=hea.Allergies
                    if 'Signs_And_Symptoms' in info:    
                        hea.Signs_And_Symptoms = info['Signs_And_Symptoms']
                        Dietdetails['Signs_And_Symptoms']=hea.Signs_And_Symptoms
                    if 'Menstrual_cycle' in info:    
                        hea.Menstrual_cycle = info['Menstrual_cycle']
                        Dietdetails['Menstrual_cycle']=hea.Menstrual_cycle
                    if 'Family_History' in info:    
                        hea.Family_History = info['Family_History']
                        Dietdetails['Family_History']=hea.Family_History
                    if 'Medical_conditions' in info:    
                        hea.Medical_conditions= info['Medical_conditions']
                        Dietdetails['Medical_conditions']=hea.Medical_conditions
                    if 'Medications' in info:    
                        hea.Medications = info['Medications']
                        Dietdetails['Medications']=hea.Medications
                    if 'Dietary_recall' in info:    
                        hea.Dietary_recall = info['Dietary_recall']
                        Dietdetails['Dietary_recall']=hea.Dietary_recall    
                    if 'weekday_wakeup' in info:    
                        hea.weekday_wakeup = info['weekday_wakeup']
                        Dietdetails['weekday_wakeup']=hea.weekday_wakeup
                    if 'weekday_bedtime' in info:    
                        hea.weekday_bedtime = info['weekday_bedtime']
                        Dietdetails['weekday_bedtime']=hea.weekday_bedtime
                    if 'weekend_wakeup' in info:    
                        hea.weekend_wakeup = info['weekend_wakeup']
                        Dietdetails['weekend_wakeup']=hea.weekend_wakeup
                    if 'weekend_bedtime' in info:    
                        hea.weekend_bedtime = info['weekend_bedtime']
                        Dietdetails['weekend_bedtime']=hea.weekend_bedtime
                    if 'work_timings_from' in info:    
                        hea.work_timings_from = info['work_timings_from']
                        Dietdetails['work_timings_from']=hea.work_timings_from
                    if 'work_timings_to' in info:    
                        hea.work_timings_to = info['work_timings_to']
                        Dietdetails['work_timings_to']=hea.work_timings_to
                    if 'Socail_habits_alcohol' in info:    
                        hea.Socail_habits_alcohol = info['Socail_habits_alcohol']
                        Dietdetails['Socail_habits_alcohol']=hea.Socail_habits_alcohol
                    if 'Socail_habits_Smoking' in info:    
                        hea.Socail_habits_Smoking = info['Socail_habits_Smoking']
                        Dietdetails['Socail_habits_Smoking']=hea.Socail_habits_Smoking
                    if 'Food_habits' in info:    
                        hea.Food_habits = info['Food_habits']
                        Dietdetails['Food_habits']=hea.Food_habits
                    if 'Food_Dislikes' in info:    
                        hea.Food_Dislikes = info['Food_Dislikes']
                        Dietdetails['Food_Dislikes']=hea.Food_Dislikes                      
                    if 'workout_timings' in info:    
                        hea.workout_timings = info['workout_timings']
                        Dietdetails['workout_timings']=hea.workout_timings
                      

                     
                    hea.save()
                      
            else:
                hea = HealthInfo.objects.create(user_id=num,
                                            createdBy_id= num,
                                            modifiedBy_id=num)
                hea.save()                            
                if 'occupation' in info:
                        hea.occupation = info['occupation']
                        Dietdetails['occupation']=hea.occupation
                if 'Allergies' in info:
                    hea.Allergies = info['Allergies']
                    print(type(info['Allergies']))
                    Dietdetails['Allergies']=hea.Allergies
                if 'Signs_And_Symptoms' in info:    
                    hea.Signs_And_Symptoms = info['Signs_And_Symptoms']
                    Dietdetails['Signs_And_Symptoms']=hea.Signs_And_Symptoms
                if 'Menstrual_cycle' in info:    
                    hea.Menstrual_cycle = info['Menstrual_cycle']
                    Dietdetails['Menstrual_cycle']=hea.Menstrual_cycle
                if 'Family_History' in info:    
                    hea.Family_History = info['Family_History']
                    Dietdetails['Family_History']=hea.Family_History
                if 'Medical_conditions' in info:    
                    hea.Medical_conditions= info['Medical_conditions']
                    Dietdetails['Medical_conditions']=hea.Medical_conditions
                if 'Medications' in info:    
                    hea.Medications = info['Medications']
                    Dietdetails['Medications']=hea.Medications
                if 'Dietary_recall' in info:    
                    hea.Dietary_recall = info['Dietary_recall']
                    Dietdetails['Dietary_recall']=hea.Dietary_recall    
                if 'weekday_wakeup' in info:    
                    hea.weekday_wakeup = info['weekday_wakeup']
                    Dietdetails['weekday_wakeup']=hea.weekday_wakeup
                if 'weekday_bedtime' in info:    
                    hea.weekday_bedtime = info['weekday_bedtime']
                    Dietdetails['weekday_bedtime']=hea.weekday_bedtime
                if 'weekend_wakeup' in info:    
                    hea.weekend_wakeup = info['weekend_wakeup']
                    Dietdetails['weekend_wakeup']=hea.weekend_wakeup
                if 'weekend_bedtime' in info:    
                    hea.weekend_bedtime = info['weekend_bedtime']
                    Dietdetails['weekend_bedtime']=hea.weekend_bedtime
                if 'work_timings_from' in info:    
                    hea.work_timings_from = info['work_timings_from']
                    Dietdetails['work_timings_from']=hea.work_timings_from
                if 'work_timings_to' in info:    
                    hea.work_timings_to = info['work_timings_to']
                    Dietdetails['work_timings_to']=hea.work_timings_to
                if 'Socail_habits_alcohol' in info:    
                    hea.Socail_habits_alcohol = info['Socail_habits_alcohol']
                    Dietdetails['Socail_habits_alcohol']=hea.Socail_habits_alcohol
                if 'Socail_habits_Smoking' in info:    
                    hea.Socail_habits_Smoking = info['Socail_habits_Smoking']
                    Dietdetails['Socail_habits_Smoking']=hea.Socail_habits_Smoking
                if 'Food_habits' in info:    
                    hea.Food_habits = info['Food_habits']
                    Dietdetails['Food_habits']=hea.Food_habits
                if 'Food_Dislikes' in info:    
                    hea.Food_Dislikes = info['Food_Dislikes']
                    Dietdetails['Food_Dislikes']=hea.Food_Dislikes                      
                if 'workout_timings' in info:    
                    hea.workout_timings = info['workout_timings']
                    Dietdetails['workout_timings']=hea.workout_timings
            
                hea.save()
                
            Dietdetails['occupation']=hea.occupation
            Dietdetails['Allergies']=hea.Allergies
            Dietdetails['SignsAndSymptoms']=hea.Signs_And_Symptoms
            Dietdetails['Menstrualcycle']=hea.Menstrual_cycle
            Dietdetails['FamilyHistory']=hea.Family_History
            Dietdetails['Medicalconditions']=hea.Medical_conditions
            Dietdetails['Medications']=hea.Medications
            Dietdetails['Dietary_recall']=hea.Dietary_recall
            Dietdetails['workout_timings']=hea.workout_timings
            Dietdetails['Food_Dislikes']=hea.Food_Dislikes
            Dietdetails['Food_habits']=hea.Food_habits
            Dietdetails['weekday_wakeup']=hea.weekday_wakeup
            Dietdetails['weekday_bedtime']=hea.weekday_bedtime
            Dietdetails['weekend_wakeup']=hea.weekend_wakeup 
            Dietdetails['weekend_bedtime']=hea.weekend_bedtime
            Dietdetails['work_timings_from']=hea.work_timings_from
            Dietdetails['work_timings_to']=hea.work_timings_to
            Dietdetails['Socail_habits_alcohol']=hea.Socail_habits_alcohol
            Dietdetails['Socail_habits_Smoking']=hea.Socail_habits_Smoking                         
                
            bminfo= BMIInfo.objects.filter(user= num)   
            if bminfo.exists():    
                bmi=BMIInfo.objects.get(user=num)

                if bmi:
                    if 'bmi' in info:
                        bmi.BMI = info['bmi']
                        print(type(info['bmi']))
                        Dietdetails['bmi']=bmi.BMI
                    if 'bodyfatpercnt' in info:    
                        bmi.Fat_percentage = info['bodyfatpercnt']
                        Dietdetails['bodyfatpercnt']=bmi.Fat_percentage
                    if 'water_intake_perday' in info:    
                        bmi.water_intake_perday= info['water_intake_perday']
                        print(type(info['water_intake_perday']))
                        Dietdetails['water_intake_perday']=bmi.water_intake_perday
                    
                    bmi.save()
                    
            else:
                bmi = BMIInfo.objects.create(user_id=num,
                                            createdBy_id= num,
                                            modifiedBy_id=num)
                bmi.save()                            
                if 'bmi' in info:
                    bmi.BMI = info['bmi']
                    print(type(info['bmi']))
                    Dietdetails['bmi']=bmi.BMI
                if 'bodyfatpercnt' in info:    
                    bmi.Fat_percentage = info['bodyfatpercnt']
                    Dietdetails['bodyfatpercnt']=bmi.Fat_percentage
                if 'water_intake_perday' in info:    
                    bmi.water_intake_perday= info['water_intake_perday']
                    print(type(info['water_intake_perday']))
                    Dietdetails['water_intake_perday']=bmi.water_intake_perday
                
                bmi.save()
                #bmiinfo.save()
                #bmi=model_to_dict(bmiinfo)
            Dietdetails['bmi']=bmi.BMI
            Dietdetails['bodyfatpercnt']=bmi.Fat_percentage
            Dietdetails['water_intake_perday']=bmi.water_intake_perday
                
            return JsonResponse({"success":True,"message":"Data stored successfully","email":nutrient['email'],"name":nutrient['first_name'],"Dietdetails":Dietdetails})    
        else:    
            return JsonResponse({"succses":False,"message":"user logged out"})  
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getDietdetails(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        print("here")
        nutrient=stratsessionutil.get_user_insession(request)
        array=[]
        Details={}
        if nutrient!= None:
            info = json.loads(request.body.decode('utf-8'))
            subscriber=User.objects.filter(email=info['email']).values()
            print(subscriber[0]['id'],"jjjjjjjjjjjjjjjjj")
            diet=userDiet_info.objects.filter(createdBy_id=subscriber[0]['id']).values()
            for frk in diet:
                Details['On_waking_up']=frk['On_waking_up']
                Details['BreakFast']=frk['BreakFast']
                Details['Mid_morning']=frk['Mid_morning']

                Details['Lunch']=frk['Lunch']
                Details['Evening_snack']=frk['Evening_snack']
                Details['Dinner']=frk['Dinner']
                Details['Mid_morn_time']=frk['Mid_morn_time']
                Details['Lunch_time']=frk['Lunch_time']
                Details['Evening_snack_time']=frk['Evening_snack_time']
                Details['On_waking_time']=frk['On_waking_time']
                Details['BreakFast_time']=frk['BreakFast_time']
                Details['Bed_Time']=frk['Bed_Time']
                Details['Bed_Time_Food']=frk['Bed_Time_Food']
                Details['Dinner_time']=frk['Dinner_time']

                

            health=HealthInfo.objects.filter(createdBy_id=subscriber[0]['id']).values()
            for frk in health:
                Details['occupation'] =frk['occupation']
                Details['Allergies'] = frk['Allergies']
                Details['Signs_And_Symptoms'] = frk['Signs_And_Symptoms']
                Details['Menstrual_cycle']=frk['Menstrual_cycle']
                Details['Family_History']=frk['Family_History']
                Details['Medical_conditions']=frk['Medical_conditions']
                Details['Medications']=frk['Medications']
                Details['Dietary_recall']=frk['Dietary_recall']
                Details['weekday_wakeup'] =frk['weekday_wakeup']
                Details['weekday_bedtime'] =frk['weekday_bedtime']
                Details['work_timings_from'] =frk['work_timings_from']
                Details['work_timings_to'] =frk['work_timings_to']
                Details['weekend_wakeup'] =frk['weekend_wakeup']
                Details['weekend_bedtime'] =frk['weekend_bedtime']
                Details['Socail_habits_alcohol'] =frk['Socail_habits_alcohol']
                Details['Socail_habits_Smoking'] =frk['Socail_habits_Smoking']
                Details['Food_habits'] =frk['Food_habits']
                Details['Food_Dislikes'] =frk['Food_Dislikes'] 
                   
              
            bmi= BMIInfo.objects.filter(createdBy_id=subscriber[0]['id']).values()
            for frk in bmi:
                Details['bmi']=frk['BMI']
                Details['bodyfatpercnt']=frk['Fat_percentage']
                Details['water_intake_perday'] =frk['water_intake_perday']
            #array.append(Details)    
            print(diet,health,bmi)
            DietSchedule=[]
            schedule={}
            dietplan= Diet.objects.filter(user_id=subscriber[0]['id']).values()
            
            for frk in dietplan:
                schedule['user'] = frk['user_id']
                schedule['Food'] = frk['FoodJson']
                schedule['Foodid']=frk['id']
                DietSchedule.append(schedule)
                Details['DietSchedule']=DietSchedule
                schedule={}
            array.append(Details) 
            #dietlog= Dietlog.objects.select_related('User__id','Food_info__food','userDietPlan__user_id').filter(user_id=subscriber[0]['id']).values('food__Food','food__Quantity','food__Calories','food__Carbohydrates','food__Protein','food__Fat','food__Fibre','food__unit')
            #for frk in dietlog:
                #schedule['']
            return JsonResponse({"success":True,"message":array})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})



@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def DietPlanner(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        nutrient = stratsessionutil.get_user_insession(request)
        info=json.loads(request.body.decode('utf-8'))
        print(info['email'])
        array=[]
        food={}
        DietDetails={}
        if nutrient!= None:
            
            subscriber=User.objects.filter(email=info['email']).values()
            id=subscriber[0]['id']
            Diet=info['info']
            DietDetails['user'] =subscriber[0]['id']
            DietDetails['email']=subscriber[0]['email']
            freak=DietSchedule.objects.filter(user_id=subscriber[0]['id']).values() 
            food_details={}  
            Food=[] 
            if freak.exists():
                
                for i in Diet:
                    
                    diet=DietSchedule.objects.filter(id=i['id']).update(Day_index=i['Day_index'],Timing=i['Timing'],Food_Type=i['Food_Type'],Food_name=i['Food'])
                   
            else:
                objs=[
                    DietSchedule(
                        Day_index=i['Day_index'],
                        Timing=i['Timing'],
                        Food_Type=i['Food_Type'],
                        Food_name=i['Food'],
                        user_id=id
                    )
                    for i in Diet
                    
                ]
                msg = DietSchedule.objects.bulk_create(objs)
            DietPlan=DietSchedule.objects.filter(user_id=id).values('id','Food_name','Day_index','Timing','Food_Type')
            diet_num=[]
            Diet_id=[]
            for dt in DietPlan:
                print(dt['id'],dt['Food_name'])
                food[dt['id']]=dt['Food_name']
                array.append(dt['Food_name'])
                food_details['diet_id']=dt['id']
                food_details['Foodname']=dt['Food_name']
                food_details['Dayindex']=dt['Day_index']
                food_details['Timing']=dt['Timing']
                food_details['FoodType']=dt['Food_Type']   
                Food.append(food_details)
                food_details={} 
                Diet_id.append(dt['id'])
            print(Diet_id)    
            DietDetails['food_details']=Food    
            foodnames=Food_info.objects.filter(Food__in=array).values('id','Food','Quantity','Calories','Carbohydrates','Protein','Fat','Fibre','unit')
            food_id=[]
            DietPlan={}
            for i in foodnames:
                name=i['Food'].capitalize()
                for j in food:
                    print(j,"hi")
                    j_name=food[j].capitalize()
                    if name==j_name:
                        DietPlan['user_id']=id
                        DietPlan['diet_schedule_id']= j
                        DietPlan['food_id']=i['id']    
                        food_id.append(DietPlan)
                        DietPlan={}

                        
            userDiet=userDietPlan.objects.filter(Diet_id__in=Diet_id).values()
            if userDiet.exists():
                
                for i in food_id:
                    print("hereeeeeeeeeeee")
                    food_schedule=userDietPlan.objects.filter(user_id=i['user_id'],Diet_id=i['diet_schedule_id']).update(Food_id=i['food_id'])
            else:
                objs=[
                    userDietPlan(
                        user_id=i['user_id'],
                        Diet_id=i['diet_schedule_id'],
                        Food_id=i['food_id']

                    )
                    for i in food_id
                ]  
                food_schedule=userDietPlan.objects.bulk_create(objs)                                  
                
                                                 
            
            
            return JsonResponse({"success":True,"Diet":DietDetails})
        return JsonResponse({"success":False,"message":"False"})    
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})        



@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def Dietplan(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        nutrient = stratsessionutil.get_user_insession(request)
        info=json.loads(request.body.decode('utf-8'))
        DietSchedule={}
        DietInfo=[]
        Food=[]
        fooddetails={}
        if nutrient!= None:
            subscriber=User.objects.filter(email=info['email']).values()
            id=subscriber[0]['id']
            freakDiet=userDietPlan.objects.select_related('User__id').filter(user_id=id).values('Diet__id','Diet__Day_index','Diet__id','Diet__Timing','Diet__Food_Type','Diet__Food_name','Food__Food','Food__Quantity')
            print(freakDiet)
            for i in freakDiet:
                print(i['Diet__id'],"hhhhhhhhjjjjjjjjjjjjjjjjjjjjjjjjjj")
                DietSchedule['Dayindex']=i['Diet__Day_index']
                DietSchedule['Timing']=i['Diet__Timing']
                DietSchedule['Foodtype']=i['Diet__Food_Type']
                DietSchedule['Foodname']=i['Diet__Food_name']
                DietSchedule['Food']=i['Food__Food']
                DietSchedule['Quantity']=i['Food__Quantity']
                DietSchedule['diet_planid']=i['Diet__id']
                DietInfo.append(DietSchedule)
                DietSchedule={}
            #DietSchedule['Day_index']



            
            return JsonResponse({"success":True,"message":DietInfo})
        else:    
            return JsonResponse({"success":False,"message":"False"})    
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})        







                


 
             
@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def appDietdetails(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        print("here")
        nutrient=stratsessionutil.get_user_insession(request)
        
        array=[]
        Details={}
        if nutrient!= None:
            
            
            Details['email']=nutrient['email']
            diet=userDiet_info.objects.filter(createdBy_id=nutrient['id']).values()
         
            for frk in diet:
                Details['On_waking_up']=frk['On_waking_up']
                Details['BreakFast']=frk['BreakFast']
                Details['Mid_morning']=frk['Mid_morning']
                Details['Lunch']=frk['Lunch']
                Details['Evening_snack']=frk['Evening_snack']
                Details['Dinner']=frk['Dinner']
                Details['Mid_morn_time']=frk['Mid_morn_time']
                Details['Lunch_time']=frk['Lunch_time']
                Details['Evening_snack_time']=frk['Evening_snack_time']
                Details['On_waking_time']=frk['On_waking_time']
                Details['BreakFast_time']=frk['BreakFast_time']
                Details['Bed_Time']=frk['Bed_Time']
                Details['Bed_Time_Food']=frk['Bed_Time_Food']
                Details['Dinner_time']=frk['Dinner_time']
                Details['detailsid']=frk['id']
                

            health=HealthInfo.objects.filter(createdBy_id=nutrient['id']).values()
            for frk in health:
                Details['occupation'] =frk['occupation']
                Details['Allergies'] = frk['Allergies']
                Details['Signs_And_Symptoms'] = frk['Signs_And_Symptoms']
                Details['Menstrual_cycle']=frk['Menstrual_cycle']
                Details['Family_History']=frk['Family_History']
                Details['Medical_conditions']=frk['Medical_conditions']
                Details['Medications']=frk['Medications']
                Details['Dietary_recall']=frk['Dietary_recall']
                Details['weekday_wakeup'] =frk['weekday_wakeup']
                Details['weekday_bedtime'] =frk['weekday_bedtime']
                Details['work_timings_from'] =frk['work_timings_from']
                Details['work_timings_to'] =frk['work_timings_to']
                Details['weekend_wakeup'] =frk['weekend_wakeup']
                Details['weekend_bedtime'] =frk['weekend_bedtime']
                Details['Socail_habits_alcohol'] =frk['Socail_habits_alcohol']
                Details['Socail_habits_Smoking'] =frk['Socail_habits_Smoking']
                Details['Food_habits'] =frk['Food_habits']
                Details['Food_Dislikes'] =frk['Food_Dislikes'] 
                Details['healthid']=frk['id']   
              
            bmi= BMIInfo.objects.filter(createdBy_id=nutrient['id']).values()
            for frk in bmi:
                Details['bmi']=frk['BMI']
                Details['bodyfatpercnt']=frk['Fat_percentage']
                Details['water_intake_perday'] =frk['water_intake_perday']
                Details['bmiid']=frk['id']
            #array.append(Details)    
            print(diet,health,bmi)

            array.append(Details) 
            
            return JsonResponse({"success":True,"message":array})
        else:
            return JsonResponse({"success":False,"message":"False"})		
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})
            
@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def diet(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        print("here")
        nutrient=stratsessionutil.get_user_insession(request)
        id=nutrient['id']
        array=[]
        Details={}
        if nutrient!= None:
            freakDiet=userDietPlan.objects.select_related('User__id').filter(user_id=id).values('Diet__id','Diet__Day_index','Diet__id','Diet__Timing','Diet__Food_Type','Diet__Food_name','Food__Food','Food__Quantity')
            print(freakDiet)
            for i in freakDiet:
                print(i['Diet__id'],"hhhhhhhhjjjjjjjjjjjjjjjjjjjjjjjjjj")
                Details['Day_index']=i['Diet__Day_index']
                Details['Timing']=i['Diet__Timing']
                Details['Food_type']=i['Diet__Food_Type']
                Details['Foodname']=i['Diet__Food_name']
                Details['Food']=i['Food__Food']
                Details['Quantity']=i['Food__Quantity']
                Details['diet_planid']=i['Diet__id']
                array.append(Details)
                Details={}
            return JsonResponse({"success":True,"message":array})
        else:
            return JsonResponse({"success":False,"message":"False"})	

    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})


def dictfetchall(cursor):
    "Return all rows from a cursor as a dict"
    columns = [col[0] for col in cursor.description]
    return [
        dict(zip(columns, row))
        for row in cursor.fetchall()
    ]



@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def nutrientlist(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        print("here")
        nutrient=stratsessionutil.get_user_insession(request)
        id=nutrient['id']
        array=[]
        details={}
        
        g=connection.cursor()
        nut="SELECT *, Subscriber_user.id as user  FROM `Subscriber_user` right join Nutrition_bmiinfo on Subscriber_user.id = Nutrition_bmiinfo.user_id left join Nutrition_diet on Subscriber_user.id = Nutrition_diet.user_id ORDER BY Subscriber_user.id DESC"
        g.execute(nut)
        results=dictfetchall(g)
        print(g)
        for i in results:
            nutrichoice=dict(i)
            
            details['plan_id']=nutrichoice['id']
            details['email']=nutrichoice['email']
            details['id']=nutrichoice['user']
            details['name']=nutrichoice['first_name']
            details['fatpercentage']=nutrichoice['Fat_percentage']  
            details['bmi']=nutrichoice['BMI']
            if nutrichoice['FoodJson']!= None:
                object = json.loads(nutrichoice['FoodJson'])  
                list = object
                for gh in list:
                    for j in gh['diets']:
                        if j:
                            Status=1
                            print("hhhh")
                        else:
                            Status=2       
                            break    
                    if Status==2:
                        details['Status']=Status
                        break            
                    else:
                        details['Status']=1       
                array.append(details)
                details={}
            else:
                details['plan_id']=nutrichoice['id']
                details['email']=nutrichoice['email']
                details['id']=nutrichoice['user']
                details['name']=nutrichoice['first_name']
                details['fatpercentage']=nutrichoice['Fat_percentage']  
                details['bmi']=nutrichoice['BMI'] 
                Status=0
                details['Status']=Status
                array.append(details)
                details={}
        return JsonResponse({"success":True,"message":array})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})    


@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache  
def nutrisearch(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        nutrient = stratsessionutil.get_user_insession(request)
        if nutrient!= None:
            info=json.loads(request.body.decode('utf-8'))
            nutri={}
            array={}
            c=[]
            Array=[]
            details_array=[]
            Array=[]
            if 'name' in info and info['name']!= '':
                details=info['name']
                
                load=BMIInfo.objects.select_related('user').filter(user__first_name__icontains=details).values('user__first_name','user__email','BMI','Fat_percentage','water_intake_perday','user__id')
                if load:
                    for nms in load:

                        c.append(nms)
                        print(nms['user__id'])
                if load :
                    user=[]
                    
                    for i in c: 
                        user.append(i['user__id'])
                    for i in c: 
                        #user.append(i['user__id'])
                        array['name']=i['user__first_name']
                        array['email']=i['user__email']
                        array['BMI']=i['BMI']
                        array['Fatpercentage']=i['Fat_percentage']
                        array['water_intake_perday']=i['water_intake_perday'] 
                        array['user_id']=i['user__id'] 
                        details_array.append(array)  
                        array={} 
                    
                    for num in user:      
                        diet=Diet.objects.filter(user_id=num).values()
                        Diet_details=[]
                        if diet:   
                            for nutrichoice in diet:
                                array['plan_id']=nutrichoice['id']
                                if nutrichoice['FoodJson']!= None:
                                    object = json.loads(nutrichoice['FoodJson'])  
                                    list = object
                                    for gh in list:
                                        empty_array=np.array(gh['diets'])
                                        is_empty=empty_array.size
                                        if is_empty == True:
                                            Status=0
                                            array['Status']=Status
                                        else:    
                                            for j in gh['diets']:
                                                if j:
                                                    Status=1
                                                    print(j,"hhhh")
                                                else:
                                                    Status=2       
                                                    break    
                                            if Status==2:
                                                array['Status']=Status
                                                break            
                                            else:
                                                array['Status']=1       
                                    details_array.append(array)
                                    array={}
                        else:
                            array['Status']=0
                            array['plan_id']=0
                            details_array.append(array) 
                            array={}
                    for i in details_array:
                        nutri['name']=i['name']
                        nutri['email']=i['email']
                        nutri['BMI']=i['BMI']
                        nutri['Fatpercentage']=i['Fatpercentage']
                        nutri['water_intake_perday']=i['water_intake_perday']
                        nutri['id']=i['user_id']
                        nutri['plan_id']=i['plan_id']
                        nutri['Status']=i['Status']

                        return JsonResponse({"success":True,"message":nutri})
                                                    
                else:    
                    email=info['name']
                    mail=BMIInfo.objects.select_related('user').filter(user__email__icontains=email).values('user__first_name','user__email','BMI','Fat_percentage','water_intake_perday','user__id')       
                    user=[]
                    if mail:
                        for bems in mail:
                            c.append(bems)
                            user.append(bems['user__id'])
                            print(c)
                    for i in c: 
                        print(i['user__first_name'],"jjjjjjjjjjjjjjjjjjjjj")   
                        array['name']=i['user__first_name']
                        array['email']=i['user__email']
                        array['BMI']=i['BMI']
                        array['Fatpercentage']=i['Fat_percentage']
                        array['water_intake_perday']=i['water_intake_perday'] 
                        array['user_id']=i['user__id'] 
                        details_array.append(array)  
                        array={} 
                    diet=Diet.objects.filter(user_id=user[0]).values()
                    Diet_details=[]
                    if diet:
                        for nutrichoice in diet:
                            array['plan_id']=nutrichoice['id']
                            if nutrichoice['FoodJson']!= None:
                                object = json.loads(nutrichoice['FoodJson'])  
                                list = object
                                for gh in list:
                                    empty_array=np.array(gh['diets'])
                                    is_empty=empty_array.size
                                    print(is_empty)
                                    if is_empty== True:
                                        array['Status']=0
                                    else:    
                                        for j in gh['diets']:
                                            if j:
                                                Status=1
                                                print("hhhh")
                                            else:
                                                Status=2       
                                                break    
                                        if Status==2:
                                            array['Status']=Status
                                            break            
                                        else:
                                            array['Status']=1       
                                Diet_details.append(array)
                                array={}
                                
                            else:
                                array['plan_id']=nutrichoice['id']
                                Status=0
                                array['Status']=Status  
                                Diet_details.append(array)
                                array={} 
                    else:
                        array['Status']=0
                        array['plan_id']=0
                        Diet_details.append(array) 
                        array={}
                    nutri['name']=details_array[0]['name']
                    nutri['email']=details_array[0]['email']
                    nutri['BMI']=details_array[0]['BMI']
                    nutri['Fatpercentage']=details_array[0]['Fatpercentage']
                    nutri['water_intake_perday']=details_array[0]['water_intake_perday']
                    nutri['id']=details_array[0]['user_id']
                    nutri['plan_id']=Diet_details[0]['plan_id']
                    nutri['Status']=Diet_details[0]['Status']
                    Array.append(nutri)                     
            return JsonResponse({"success":True,"message":Array})  
        else:    
            return JsonResponse({"succses":False,"message":"user logged out"})  
    except Exception as e:
            logger.exception("something wrong")
            return JsonResponse({"msg": str(e)})
        





                                                    
@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def mealinfo(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        print("here")
        nutrient=stratsessionutil.get_user_insession(request)
        info=json.loads(request.body.decode('utf-8'))
        subscriber=User.objects.filter(email=info['email']).values()
        id=subscriber[0]['id']
        details={}
        array=[]
        if nutrient:
            
            diet=Diet.objects.filter(user_id=id)
            if diet.exists():
                food=Diet.objects.get(id=info['id'])
                food.FoodJson=json.dumps(info['info'])
                details['user_id']=food.user_id
                details['Food']=food.FoodJson
                details['email']=subscriber[0]['email']
                details['id']=food.id
                food.save()
                array.append(details)
                print("heteeeeeeeeeeee")
                return JsonResponse({"success":True,"message":"successfully updated the diet","Diet":array})
            else:        
            
                diet = Diet.objects.create(user_id=id,FoodJson = json.dumps(info['info']))   
                diet.save()
                details['id']=diet.id
                details['user_id']=diet.user_id
                details['Food']=diet.FoodJson
                details['email']=subscriber[0]['email']
                print(details)
                array.append(details)
                return JsonResponse({"success":True,"message":"successfully created the diet","Diet":array})
            
        else:
            return JsonResponse({"success":False,"message":"User logged out"})    
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getmealinfo(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        print("here")
        nutrient=stratsessionutil.get_user_insession(request)
        info=json.loads(request.body.decode('utf-8'))
        subscriber=User.objects.filter(email=info['email']).values()
        id=subscriber[0]['id']
        details={}
        array=[]
        if nutrient:
            Food=Diet.objects.filter(user_id=id).values()
            if Food.exists():
                for diet in Food:
                    food=dict(diet)
                    details['user_id']=food['user_id']
                    details['email']=subscriber[0]['email']
                    details['Food']=food['FoodJson']
                    details['id'] = food['id']
                    array.append(details)
            return JsonResponse({"success":True,"Diet":array})
        else:
            return JsonResponse({"success":False,"message":"User logged out"})    
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getmeal(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        print("here")
        nutrient=stratsessionutil.get_user_insession(request)
        id=nutrient['id']
        details={}
        array=[]
        if nutrient:
            Food=Diet.objects.filter(user_id=id).values()
            if Food.exists():
                for diet in Food:
                    food=dict(diet)
                    details['user_id']=food['user_id']
                    details['email']=nutrient['email']
                    details['Food']=food['FoodJson']
                    details['id']=food['id']
                object = json.loads(details['Food'])
                print(object[1]['diets'])  
                list = object
                for i in list:
                    print(i['diets'],"hhhhhhhhhhhhhhhhhhhhhhhhhhhhhh")
                    for data in i['diets']:

                        if data:
                            Status=1
                            
                        else:
                            Status=2       
                            break    
                    if Status==2:
                        details['Status']=Status
                        break            
                    else:
                        details['Status']=1       
                array.append(details) 
            else:
                Status=0
                details['Status']=Status
                array.append(details)
                return JsonResponse({"success":False,"Diet":array,"message":"you dont have a diet plan"})               
            return JsonResponse({"success":True,"Diet":array})
        else:
            return JsonResponse({"success":False,"message":"User logged out"})    
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def pandafood(request):
    import pandas as pd
    import numpy as np
    stratsessionutil = StartFitSessionUtil()
    try:
        nutrient=stratsessionutil.get_user_insession(request)
        id=nutrient['id']
        details={}
        array=[]
        dd={}
        if nutrient:
            info=json.loads(request.body.decode('utf-8'))
            print(info['food'])
            path=info['food']
            df = pd.read_csv(path)
            df.dropna(inplace = True)
            df = df.replace(np.nan, 0, regex=True)
            #Food         Quantity  Calories (kcal)  Carbohydrate (gms)  Protein (gms)  Fat (gms)  Fibre             Unit
            print(df.to_string())
            car_buffer = StringIO()

            df.to_csv(car_buffer,index=False)

            print (car_buffer.getvalue())
            
            io_string = io.StringIO(car_buffer.getvalue())
            next(io_string)
            
            for column in csv.reader(io_string,delimiter=','):
                print(column[0],"fggggggggggujew")
                
                obj,created=Food_info.objects.update_or_create(
                    Food=str(column[0]),
                    defaults={'Food':str(column[0]),'Quantity':str(column[1]),
                    'Calories':str(column[2]),
                    'Carbohydrates':str(column[3]),
                    'Protein':str(column[4]),
                    'Fat':str(column[5]),
                    'Fibre':str(column[6]),
                    'unit':str(column[1])})
                print(obj,created)  
            return JsonResponse({"success":True,"message":"food loaded successfully"})
        else:
            return JsonResponse({"success":False,"message":"User logged out"})    
    except Exception as e:
        logger.error("error")
        return JsonResponse({"msg": str(e),"success":False})


@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def Food_Timings(request):
    stratsessionutil = StartFitSessionUtil()
    info=json.loads(request.body.decode('utf-8'))
    print("gddgggggggggddgg")
    try:
        nutrient=stratsessionutil.get_user_insession(request)
        details={}
        array=[]
        Food={}
        if 'diet_time_id' in info and info['diet_time_id']!=None:
            diet= DietSchedule.objects.filter(id=info['diet_time_id']).values()
            if diet:
                Food=DietSchedule.objects.get(id=info['diet_time_id'])
                if 'food_type' in info and info['food_type']!= None:
                    Food.Food_Type=info['food_type']
                if 'day_index' in info and info['day_index']!= None:
                    Food.Day_index = info['Day_index']
                if 'timing' in info and info['timing']!= None:
                    Food.Timing = info['timing']
                if 'food_name' in info and info['food_name']!= None:
                    Food.Food_name=info['food_name']   
                Food.save()                
                details['id']=Food.id
                details['day_index']=Food.Day_index
                details['food_type']=Food.Food_Type
                details['food_name']=Food.Food_name
                details['timing']=Food.Timing
                array.append(details)
                return JsonResponse({"success":True,"details":array,"message":"Successfully updated"})
            else:
                return JsonResponse({"success":False,"message":"id doesn't exist"})    
        elif 'id' in info and info['id']!=None:
            nutri=info['id']
            diet=DietSchedule.objects.filter(user_id=nutri).filter(Food_Type=info['food_type']).filter(Day_index=info['day_index']).update(Timing=info['timing'])
            if diet:
                food=DietSchedule.objects.filter(user_id=nutri).values()
                print(nutri)
                if food: 
                    for i in food:
                        dg=dict(i)
                        if dg['Day_index']=="0":
                            print(dg['Food_Type'])
                            details['Day_index']=dg['Day_index']
                            details['Timing']=dg['Timing']
                            details['Food_Type']=dg['Food_Type']
                            details['Food_name']=dg['Food_name']
                            details['id']=dg['id']
                            array.append(details) 
                            Food['0']=array
                            
                            details={}
                    array=[]        
                    for i in food:
                        dg=dict(i)      
                        if dg['Day_index']=="1":    
                            details['Day_index']=dg['Day_index']
                            details['Timing']=dg['Timing']
                            details['Food_Type']=dg['Food_Type']
                            details['Food_name']=dg['Food_name']
                            details['id']=dg['id']
                            array.append(details)
                            Food['1']=array
                            details={}
                    array=[]        
                    for i in food:
                        dg=dict(i)               
                        if dg['Day_index']=="2": 
                            details['Day_index']=dg['Day_index']
                            details['Timing']=dg['Timing']
                            details['Food_Type']=dg['Food_Type']
                            details['Food_name']=dg['Food_name']
                            details['id']=dg['id']
                            array.append(details)
                            Food['2']=array
                            details={}
                    array=[]        
                    for i in food:
                        dg=dict(i)        
                        if dg['Day_index']=="3": 
                            details['Day_index']=dg['Day_index']
                            details['Timing']=dg['Timing']
                            details['Food_Type']=dg['Food_Type']
                            details['Food_name']=dg['Food_name']
                            details['id']=dg['id']
                            array.append(details)
                            Food['3']=array
                            details={}
                    array=[]        
                    for i in food:
                        dg=dict(i)             
                        if dg['Day_index']=="4": 
                            details['Day_index']=dg['Day_index']
                            details['Timing']=dg['Timing']
                            details['Food_Type']=dg['Food_Type']
                            details['Food_name']=dg['Food_name']
                            details['id']=dg['id']
                            array.append(details)
                            Food['4']=array
                            details={}
                    array=[]        
                    for i in food:
                        dg=dict(i)        
                        if dg['Day_index']=="5": 
                            details['Day_index']=dg['Day_index']
                            details['Timing']=dg['Timing']
                            details['Food_Type']=dg['Food_Type']
                            details['Food_name']=dg['Food_name']
                            details['id']=dg['id']
                            array.append(details)
                            Food['5']=array
                            details={}
                    array=[]        
                    for i in food:
                        dg=dict(i)                
                        if dg['Day_index']=="6": 
                            details['Day_index']=dg['Day_index']
                            details['Timing']=dg['Timing']
                            details['Food_Type']=dg['Food_Type']
                            details['Food_name']=dg['Food_name']
                            details['id']=dg['id']
                            array.append(details)                    
                            Food['6']=array
                            details={}
                    return JsonResponse ({"success":True,"details":Food,"message":"Successfully added"})
                else:
                    return JsonResponse({"success":False,"message":"id doesn't exist"})    
            else:
                diet=DietSchedule.objects.create(user_id=nutri)
                if 'day_index' in info and info['day_index']!=None:
                    diet.Day_index = info['day_index']
                if 'food_type' in info and info['food_type']!=None:
                    diet.Food_Type = info['food_type']
                if 'timing' in info and info['timing']!= None:
                    diet.Timing = info['timing']
                if 'food_name' in info and info['food_name']!= None:
                    diet.Food_name =info['food_name']
                diet.save()
                food=DietSchedule.objects.filter(user_id=nutri).values()
                if food: 
                    for i in food:
                        dg=dict(i)
                        if dg['Day_index']=="0":
                            print(dg['Food_Type'])
                            details['Day_index']=dg['Day_index']
                            details['Timing']=dg['Timing']
                            details['Food_Type']=dg['Food_Type']
                            details['Food_name']=dg['Food_name']
                            details['id']=dg['id']
                            array.append(details) 
                            Food['0']=array
                            
                            details={}
                    array=[]        
                    for i in food:
                        dg=dict(i)      
                        if dg['Day_index']=="1":    
                            details['Day_index']=dg['Day_index']
                            details['Timing']=dg['Timing']
                            details['Food_Type']=dg['Food_Type']
                            details['Food_name']=dg['Food_name']
                            details['id']=dg['id']
                            array.append(details)
                            Food['1']=array
                            details={}
                    array=[]        
                    for i in food:
                        dg=dict(i)               
                        if dg['Day_index']=="2": 
                            details['id']=dg['id']
                            details['Day_index']=dg['Day_index']
                            details['Timing']=dg['Timing']
                            details['Food_Type']=dg['Food_Type']
                            details['Food_name']=dg['Food_name']
                            array.append(details)
                            Food['2']=array
                            details={}
                    array=[]        
                    for i in food:
                        dg=dict(i)        
                        if dg['Day_index']=="3": 
                            details['Day_index']=dg['Day_index']
                            details['Timing']=dg['Timing']
                            details['Food_Type']=dg['Food_Type']
                            details['Food_name']=dg['Food_name']
                            details['id']=dg['id']
                            array.append(details)
                            Food['3']=array
                            details={}
                    array=[]        
                    for i in food:
                        dg=dict(i)             
                        if dg['Day_index']=="4": 
                            details['Day_index']=dg['Day_index']
                            details['Timing']=dg['Timing']
                            details['Food_Type']=dg['Food_Type']
                            details['Food_name']=dg['Food_name']
                            details['id']=dg['id']
                            array.append(details)
                            Food['4']=array
                            details={}
                    array=[]        
                    for i in food:
                        dg=dict(i)        
                        if dg['Day_index']=="5": 
                           
                            details['Day_index']=dg['Day_index']
                            details['Timing']=dg['Timing']
                            details['Food_Type']=dg['Food_Type']
                            details['Food_name']=dg['Food_name']
                            details['id']=dg['id']
                            array.append(details)
                            Food['5']=array
                            details={}
                    array=[]        
                    for i in food:
                        dg=dict(i)                
                        if dg['Day_index']=="6":   
                            details['id']=dg['id']
                            details['Day_index']=dg['Day_index']
                            details['Timing']=dg['Timing']
                            details['Food_Type']=dg['Food_Type']
                            details['Food_name']=dg['Food_name']
                            array.append(details)                    
                            Food['6']=array
                            details={}
                    return JsonResponse ({"success":True,"details":Food,"message":"Successfully added"})
                else:
                    return JsonResponse({"success":False,"message":"id doesn't exist","details":array})
        else:
            return JsonResponse({"success":False,"message":"please give the id","details":array})
    except Exception as e:
        logger.error("error")
        return JsonResponse({"msg": str(e),"success":False})
            
@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getFood_Timings(request):
    stratsessionutil = StartFitSessionUtil()
    info=json.loads(request.body.decode('utf-8'))
    print("gddgggggggggddgg")
    try:
        nutrient=stratsessionutil.get_user_insession(request)
        details={}
        food={}
        c=[]
        array=[]
        if nutrient:
            if 'id' in info and info['id']!=None:
                diet= DietSchedule.objects.filter(user_id=info['id']).values()
                if diet: 
                    for i in diet:
                        dg=dict(i)
                        if dg['Day_index']=="0": 
                            print(dg['Food_Type'])
                            details['Day_index']=dg['Day_index']
                            details['Timing']=dg['Timing']
                            details['id']=dg['id']
                            details['Food_Type']=dg['Food_Type']
                            details['Food_name']=dg['Food_name']
                            array.append(details) 
                            food['0']=array
                            details={}
                    array=[]        
                    for i in diet:
                        dg=dict(i)        
                        if dg['Day_index']=="1":   
                            details['Day_index']=dg['Day_index']
                            details['Timing']=dg['Timing']
                            details['id']=dg['id']
                            details['Food_Type']=dg['Food_Type']
                            details['Food_name']=dg['Food_name']
                            array.append(details)
                            food['1']=array
                            details={}
                    array=[]        
                    for i in diet:
                        dg=dict(i)               
                        if dg['Day_index']=="2": 
                            details['Day_index']=dg['Day_index']
                            details['Timing']=dg['Timing']
                            details['id']=dg['id']
                            details['Food_Type']=dg['Food_Type']
                            details['Food_name']=dg['Food_name']
                            array.append(details)
                            food['2']=array
                            details={}
                    array=[]        
                    for i in diet:
                        dg=dict(i)        
                        if dg['Day_index']=="3": 
                            details['Day_index']=dg['Day_index']
                            details['Timing']=dg['Timing']
                            details['id']=dg['id']
                            details['Food_Type']=dg['Food_Type']
                            details['Food_name']=dg['Food_name']
                            array.append(details)
                            food['3']=array
                            details={}
                    array=[]        
                    for i in diet:
                        dg=dict(i)             
                        if dg['Day_index']=="4": 
                            details['Day_index']=dg['Day_index']
                            details['Timing']=dg['Timing']
                            details['id']=dg['id']
                            details['Food_Type']=dg['Food_Type']
                            details['Food_name']=dg['Food_name']
                            array.append(details)
                            food['4']=array
                            details={}
                    array=[]        
                    for i in diet:
                        dg=dict(i)        
                        if dg['Day_index']=="5": 
                            details['Day_index']=dg['Day_index']
                            details['Timing']=dg['Timing']
                            details['id']=dg['id']
                            details['Food_Type']=dg['Food_Type']
                            details['Food_name']=dg['Food_name']
                            array.append(details)
                            food['5']=array
                            details={}
                    array=[]        
                    for i in diet:
                        dg=dict(i)                
                        if dg['Day_index']=="6": 
                            details['Day_index']=dg['Day_index']
                            details['Timing']=dg['Timing']
                            details['id']=dg['id']
                            details['Food_Type']=dg['Food_Type']
                            details['Food_name']=dg['Food_name']
                            array.append(details)                    
                            food['6']=array
                            details={}
                    return JsonResponse ({"success":True,"details":food,"message":"Successfully added"})
                else:
                    return JsonResponse({"success":False,"message":"user not exist","details":array})   
            else:
                return JsonResponse({"success":False,"message":"user logged out"})        
        else:
            return JsonResponse({"success":False,"message":"please give the id","details":array})
    except Exception as e:
        logger.error("error")
        return JsonResponse({"msg": str(e),"success":False})           



@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def deleteFood_Timings(request):
    stratsessionutil = StartFitSessionUtil()
    info=json.loads(request.body.decode('utf-8'))
    print("gddgggggggggddgg")
    try:
        nutrient=stratsessionutil.get_user_insession(request)
        if nutrient:
            if 'id' in info and info['id']!=None:
                diet= DietSchedule.objects.filter(id=info['id']).delete()
                return JsonResponse({"success":True,"message":"Deleted successfully"})
            else:
                return  JsonResponse({"success":False,"message":"Please give the id"})        
        else:
            return JsonResponse({"success":False,"message":"user logged out"})        
    except Exception as e:
        logger.error("error")
        return JsonResponse({"msg": str(e),"success":False})           
        