from django.db import models
from Subscriber.models import User
# Create your models here.

class Food_info(models.Model):
    Food= models.CharField(max_length=255,null=True,blank=True)
    Quantity = models.CharField(max_length=255,null = True,blank = True)
    Calories = models.CharField(max_length=255,null = True,blank = True)
    Carbohydrates = models.CharField(max_length=255,null = True,blank = True)
    Protein = models.CharField(max_length=255, null = True,blank = True)
    Fat = models.CharField(max_length=255,null = True,blank = True)
    Fibre =models.CharField(max_length=255,null= True,blank = True)
    unit=models.CharField(max_length=100,null = True, blank = True)
    

class userDiet_info(models.Model):
    user = models.ForeignKey(User,related_name='fooinfo',on_delete=models.CASCADE)
    On_waking_up=models.CharField(max_length=255,null=True,blank=True)
    On_waking_time=models.CharField(max_length=255,null=True,blank=True)
    BreakFast=models.CharField(max_length=255,null=True,blank=True)
    BreakFast_time=models.CharField(max_length=255,blank=True,null=True)
    Mid_morning=models.CharField(max_length=255,blank=True,null=True)
    Mid_morn_time=models.CharField(max_length=255,blank=True,null=True)
    Lunch=models.CharField(max_length=255,null=True,blank=True)
    Lunch_time=models.CharField(max_length=255,null=True,blank=True)
    Evening_snack=models.CharField(max_length=255,null=True,blank=True)
    Evening_snack_time=models.CharField(max_length=255,null=True,blank=True)
    Dinner=models.CharField(max_length=255,null=True,blank=True)
    Dinner_time=models.CharField(max_length=255,null=True,blank=True)
    Bed_Time=models.CharField(max_length=255,null=True,blank=True) 
    Bed_Time_Food=models.CharField(max_length=255,null=True,blank=True)
    createdBy = models.ForeignKey(User, related_name='foinfo',on_delete=models.CASCADE)
    modifiedBy = models.ForeignKey(User, related_name='fooin',on_delete=models.CASCADE)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)  

class HealthInfo(models.Model):
    user = models.ForeignKey(User,related_name='hlinf',on_delete=models.CASCADE)
    occupation=models.CharField(max_length=255,null =True,blank=True)
    Allergies=models.CharField(max_length=255,null=True,blank=True)
    Signs_And_Symptoms=models.CharField(max_length=255,null=True,blank=True)
    Menstrual_cycle=models.CharField(max_length=255,null=True,blank=True)
    Family_History=models.CharField(max_length=255,null=True,blank=True)
    Medical_conditions=models.CharField(max_length=255,null=True,blank=True)
    Medications=models.CharField(max_length=255,null=True,blank=True) 
    Dietary_recall=models.CharField(max_length=255,null=True,blank=True)
    work_timings_from=models.CharField(max_length=255,null=True,blank=True)
    work_timings_to=models.CharField(max_length=255,null=True,blank=True)
    Food_habits=models.CharField(max_length=255,null=True,blank=True)
    Food_Dislikes=models.CharField(max_length=255,null=True,blank=True)
    Socail_habits_alcohol=models.BooleanField(default=False)
    Socail_habits_Smoking=models.BooleanField(default=False)
    workout_timings=models.CharField(max_length=255,null=True,blank=True)
    weekday_wakeup=models.CharField(max_length=255,null=True,blank=True)
    weekday_bedtime=models.CharField(max_length=255,null=True,blank=True)
    weekend_wakeup=models.CharField(max_length=255,null=True,blank=True)
    weekend_bedtime=models.CharField(max_length=255,null=True,blank=True)
    createdBy = models.ForeignKey(User, related_name='hinfo',on_delete=models.CASCADE)
    modifiedBy = models.ForeignKey(User, related_name='heinfo',on_delete=models.CASCADE)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)  
         

class BMIInfo(models.Model):
    user = models.ForeignKey(User,related_name='bminf',on_delete=models.CASCADE)
    BMI=models.FloatField(blank=True,null=True)
    Fat_percentage=models.FloatField(blank=True,null=True)
    water_intake_perday=models.CharField(max_length=100,null=True,blank=True)
    createdBy = models.ForeignKey(User, related_name='bmus',on_delete=models.CASCADE)
    modifiedBy = models.ForeignKey(User, related_name='bmin',on_delete=models.CASCADE)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class DietSchedule(models.Model):
    user=models.ForeignKey(User,related_name='diplan',on_delete=models.CASCADE)
    Day_index=models.CharField(max_length=100,blank = True,null = True) 
    Timing=models.CharField(max_length=100,blank=True,null=True)
    Food_Type= models.CharField(max_length=100,blank=True,null=True)
    Food_name=models.CharField(max_length=100,blank=True,null=True)

class userDietPlan(models.Model):
    user=models.ForeignKey(User,related_name='diet',on_delete=models.CASCADE)
    Diet=models.ForeignKey(DietSchedule,related_name='dietplan',on_delete=models.CASCADE)
    Food=models.ForeignKey(Food_info,related_name='foodplan',on_delete=models.CASCADE)
  
class Dietlog(models.Model):
    user=models.ForeignKey(User,related_name='log',on_delete=models.CASCADE)
    food=models.ForeignKey(Food_info,related_name='foodlog',on_delete=models.CASCADE)
    userdiet=models.ForeignKey(userDietPlan,related_name='flog',on_delete=models.CASCADE)
    
class Diet(models.Model):
    user=models.ForeignKey(User,related_name='dietfreak',on_delete=models.CASCADE)
    FoodJson=models.TextField(blank=True,null=True)
    
