import json
from django.http import JsonResponse
from django.shortcuts import render
from django.template import RequestContext
from django.views.decorators.cache import never_cache
from rest_framework.decorators import api_view, authentication_classes
from rest_framework.response import Response

from Company.models import Company, CreateAdv, checkoutAdv, PriceClassification
from StratFit.settings import STATICDIR
from Subscriber.views import dictfetchall
from django.db import connection
# Create your views here.
from StratFit import settings
from Subscriber.Authentication import SessionAuthentication, StartFitAuthentication, StartFitSessionUtil, \
    IsAuthenticated
from Subscriber.models import User
from Userplan.models import UserPlan, UserSets, UserExercise
from campaign.models import CampaignFeed, CampaignLikes, CampaignComments, campaignImages, campaignVideos
try: # for pip >= 10
    from pip._internal.req.req_install import logger
except ImportError: # for pip <= 9.0.3
    from pip.req.req_install import logger
from datetime import datetime, timedelta, time

def userLogin(request):
    context = RequestContext(request)
    if request.method == 'POST':
        try:
            jsonD = json.loads(request.body.decode('utf-8'))
            jsonD['remote_ip'] = request.META.get('REMOTE_ADDR', None)
            if 'email' in jsonD:
                if 'skip' in jsonD and jsonD['skip'] == 1:
                    updateuser = User.objects.get(email=request['email'])
                    updateuser.is_active = 1
                    updateuser.save()
                stratauthentication = StartFitAuthentication()
                loginResponse = stratauthentication.authenticate(jsonD)
                userDataObj = loginResponse
                #print(userDataObj)
                try:
                    if userDataObj['result'] == 'False':
                        #print(userDataObj['message'],"1244")
                        if 'is_active' in userDataObj:
                            return JsonResponse({"success":False, "is_active":0, "message":userDataObj['message']})
                        else:
                            return JsonResponse({"success":False,"message":userDataObj['message']})
                    else:
                        queryset = User.objects.get(email=userDataObj['userDetails']['email'])
                        username = queryset.first_name
                        if queryset.email is not None:
                            request.session['loggedIn'] = True
                            request.session['email'] = queryset.email
                            request.session['user_id'] = queryset.id
                            request.session['first_name'] = queryset.first_name
                            request.session['is_superuser'] = queryset.is_superuser
                            return JsonResponse({"success":True,"message": "Logged In successfully","code":loginResponse['code'],"sessiontoken":loginResponse['sessiontoken'],"userDetails":userDataObj['userDetails']['email'],"username":username,"fname":queryset.first_name,"privacy":queryset.userPrivacy,"lname":queryset.last_name,"is_superuser":queryset.is_superuser,"is_active":queryset.is_active,"user_id":userDataObj['userDetails']['id'],"userType":queryset.userType,"orgId":queryset.organization_id,"avatar":queryset.avatar,"otp":queryset.otp,"phone":userDataObj['userDetails']['phone'],"currencyType":userDataObj['userDetails']['currencyType'],"email":queryset.email,"phonecode":userDataObj['userDetails']['phoneCode'],"coverImage":userDataObj['userDetails']['userCover']})
                except Exception as e:
                    return JsonResponse({"msg":str(e)})
            else:
                sessionAuthentication = SessionAuthentication()
                username = sessionAuthentication.authenticate(request)
                if username is not None:
                    loginResponse = '{"result":"success"}'
                else:
                    loginResponse = '{"result":"failure"}'
                return Response(loginResponse)
        except Exception as e:
            # logger.exception("fatal error")
            return JsonResponse({"msg":str(e)})
            #return JsonResponse({"success": False, "message": "Your account is disabled"})

def packageDetails(request):
    arr = [{"days":"100 Days","offer_price":7995,"price":9995},{"days":"3 Days","offer_price":0,"price":700},{"days":"7 Days","offer_price":1495,"price":1500},{"days":"15 Days","offer_price":2495,"price":2500},{"days":"Monthly","offer_price":4499,"price":5782},{"days":"Quartely","offer_price":7999,"price":9110},{"days":"Half Yearly","offer_price":9995,"price":14774},{"days":"Annual","offer_price":15999,"price":23836}]
    return JsonResponse({"details":arr})

def gymlists(request):
    arr = [{"title":"Adyar","image":"assets/images/circuit.jpg","address":"86, 1st Avenue, Indira Nagar, Opp. Corporation Bank, Adyar, Chennai, Tamil Nadu 600020","gymName":"Pink Fitness Adyar","lat":12.997384,"lng":80.251572},{"title":"Ameerpet","image":"assets/images/equipment.jpg","address":"7-1-71/H, Dharam Karam Road, Ameerpet, Near Challa Hospital, ShivBagh, Ameerpet, Hyderabad, Telangana 500016","gymName":"Pink Fitness Ameerpet","lat":17.4400383,"lng":78.4486785},{"title":"Anna Nagar","image":"assets/images/morning.jpg","address":"Q-90, 4th Main Rd, Anna Nagar West, Block Q, Anna Nagar, Chennai, Tamil Nadu 600040","gymName":"Pink Fitness Anna Nagar","lat":13.0904712,"lng":80.2148103},{"title":"Ashok Nagar","image":"assets/images/personal.jpg","address":"No-65/30, Next to Hotel Sangamam, 7th Avenue, Ashok Nagar, Chennai, Tamil Nadu 600083","gymName":"Pink Fitness Ashok Nagar","lat":13.0348258,"lng":80.2140834},{"title":"Avadi","image":"assets/images/pinkcover.jpg","address":" 50 & 50A, HVF Road, Bakthavachala Puram, Near Avadi Bus stand, Avadi, Chennai, Tamil Nadu 600054","gymName":"Pink Fitness Avadi","lat":13.1204712,"lng":80.1010853},{"title":"Besant Nagar","image":"assets/images/circuit.jpg","address":"3rd Floor, No. 25, Annai Velankanni Road, 7th Avenue, Besant Nagar, Above FAB India, Chennai, Tamil Nadu 600090","gymName":"Pink Fitness Besant Nagar","lat":12.995505,"lng":80.2674406},{"title":"Chromepet","image":"assets/images/equipment.jpg","address":"201 GST Road, Near Vasan Eye Care, Opp to Chrompet Railway Station, Chennai, Tamil Nadu 600044","gymName":"Pink Fitness Chromepet","lat":12.9373118,"lng":80.1367172},{"title":"Cross Cut Road","image":"assets/images/morning.jpg","address":"461, Crosscut Road, Behind Balaji Binny Showroom, Coimbatore, Tamil Nadu 641012","gymName":"Pink Fitness Crosscut Road","lat":11.0163174,"lng":76.957833},{"title":"Dindigul","image":"assets/images/personal.jpg","address":"Sree Tower, 46 - I/6, Indira Nagar, Nagal Nagar, Dindigul, Tamil Nadu 624003","gymName":"Pink Fitness Dindigul","lat":10.35447,"lng":77.9821724},{"title":"Gopalapuram","image":"assets/images/pinkcover.jpg","address":"22/8, Sadasivam Street, Opp. National Public School,, Gopalapuram, Chennai, Tamil Nadu 600086","gymName":"Pink Fitness Gopalapuram","lat":13.0482372,"lng":80.2556063},{"title":"Iyyappanthangal","image":"assets/images/circuit.jpg","address":"1&2 RTR Complex, 3rd Floor, Pushpa Nagar,, Mount Poonamallee High Road, Iyyappanthangal, Chennai, Tamil Nadu 600056","gymName":"Pink Fitness Iyyappanthangal","lat":13.0484485,"lng":80.2402853},{"title":"Jaya Nagar","image":"assets/images/equipment.jpg","address":"Near PN Rao Showroom 16/1-1,19th Cross, 3rd Block, Circle,, South End Circle, Jayanagar, Bengaluru, Karnataka 560011","gymName":"Pink Fitness Jaya Nagar","lat":12.9347037,"lng":77.5797478},{"title":"Karur","image":"assets/images/morning.jpg","address":"108A, 2nd Floor, Annamalai Complex, Kovai Road, Vaiyapuri Nagar, Tamil Nadu 639002","gymName":"Pink Fitness Karur","lat":10.9612953,"lng":78.0647343},{"title":"Kolathur","image":"assets/images/personal.jpg","address":"69, 17th Cross Street, Next to Hotel RS Bhavan, Senthil Nagar, Kolathur,, Chennai, Tamil Nadu 600099","gymName":"Pink Fitness Kolathur","lat":13.1187994,"lng":80.2054798},{"title":"Korattur","image":"assets/images/pinkcover.jpg","address":" L 18, East Avenue, Above Dominos, Korattur, Chennai, Tamil Nadu 600080","gymName":"Pink Fitness Korattur","lat":13.103618,"lng":80.2402853},{"title":"Kotturpuram","image":"assets/images/circuit.jpg","address":"4th Main, Kottur Gardens, above nilgiris, Chennai, Tamil Nadu 600085","gymName":"Pink Fitness Kotturpuram","lat":13.103781,"lng":80.1164982},{"title":"Madanadapuram","image":"assets/images/equipment.jpg","address":"5/264, First floor, Shanmuga Nagar, Madhanandhapuram, Porur, Chennai, Tamil Nadu 600125","gymName":"Pink Fitness Madanandapuram","lat":13.0166346,"lng":80.1619957},{"title":"Madurai","image":"assets/images/morning.jpg","address":"583, Anna Nagar 2nd East Main Road, Madurai, Tamil Nadu 625020","gymName":"Pink Fitness Madurai","lat":9.9212065,"lng":78.148068},{"title":"Nanganallur","image":"assets/images/personal.jpg","address":"35th Street, Thillai Ganga Nagar Subway, Nanganallur, Chennai, Tamil Nadu 600061","gymName":"Pink Fitness Nanganallur","lat":12.9913367,"lng":80.1924021},{"title":"Nolambur","image":"assets/images/pinkcover.jpg","address":"67/2, Mogappair West Main Road, Nolambur, Chennai, Tamil Nadu 600037","gymName":"Pink Fitness Nolambur","lat":13.0808544,"lng":80.1625002},{"title":"Nungambakkam","image":"assets/images/circuit.jpg","address":"37, College Rd, Chinmaya Nagar Stage 1, Nungambakkam, Chennai, Tamil Nadu 600034","gymName":"Pink Fitness Nungambakkam","lat":13.0673083,"lng":80.2502309},{"title":"Pallikaranai","image":"assets/images/equipment.jpg","address":"1st Main Road, Kamakoti Nagar Main Road, Kamakoti Nagar, Opp. Balaji Dental College, Pallikaranai, Chennai, Tamil Nadu 600100","gymName":"Pink Fitness Pallikaranai","lat":12.9421265,"lng":80.2085246},{"title":"Periyar Nagar","image":"assets/images/morning.jpg","address":"Old No. 36 / New No. 55, 70 Feet Road,, Above Nilgiris Supermarket, Periyar Nagar, Chennai, Tamil Nadu 600082","gymName":"Pink Fitness Periyar Nagar","lat":13.11388,"lng":80.227391},{"title":"Purasaiwakkam","image":"assets/images/personal.jpg","address":"92 A, Dr. Alagappa Chetty Road, Above Coffee Day, Purasaiwakkam, Chennai, Tamil Nadu 600084","gymName":"Pink Fitness Purasaiwakkam","lat":13.0820342,"lng":80.2546353},{"title":"RA Puram","image":"assets/images/pinkcover.jpg","address":"RA puram, Dev Apartments No. Abirami, 95, Saint Marys Road, Chennai, Tamil Nadu 600028","gymName":"Pink Fitness RA Puram","lat":13.029065,"lng":80.258557},{"title":"Ramapuram","image":"assets/images/circuit.jpg","address":"4/1, Srivatsa Street, Vivekananda Nagar, near Royala Nagar, Ramapuram, Chennai, Tamil Nadu 600089","gymName":"Pink Fitness Ramapuram","lat":13.0292323,"lng":80.1887287},{"title":"Sai Baba Colony","image":"assets/images/equipment.jpg","address":"Saibaba colony, NSR Road,Turya Building, 4th Floor, Bharathi Park 4th Street, Next to IAB Photo Studio, Coimbatore, Tamil Nadu 641011","gymName":"Pink Fitness Saibaba Colony","lat":11.0257103,"lng":76.9414294},{"title":"Saligramam","image":"assets/images/morning.jpg","address":"33/ Opp. SSR Pankajam Theatre,, 3/7, Arunachalam Road, Chennai, Tamil Nadu 600093","gymName":"Pink Fitness Saligramam","lat":13.052058,"lng":80.203904},{"title":"Selaiyur","image":"assets/images/personal.jpg","address":"87, Velachery Tambaram Main Road, Opp shell Petrol Bunk, Rajakilpakkam, Chennai, Tamil Nadu 600073","gymName":"Pink Fitness Selaiyur","lat":12.922872,"lng":80.151081},{"title":"Thiruvanmiyur","image":"assets/images/pinkcover.jpg","address":"Abishek Ramaniyam, Block 1, Basement, No.68, ECR, Thiruvanmiyur, Chennai, Tamil Nadu 600041","gymName":"Pink Fitness Thiruvanmiyur","lat":12.97609,"lng":80.258657},{"title":"Thoraipakkam","image":"assets/images/circuit.jpg","address":"No. 3/331, 3rd Floor, OMR Road, Opp. AKDR Golf Village, Thoraipakkam, Chennai, Tamil Nadu 600097","gymName":"Pink Fitness Thoraipakkam","lat":12.938279,"lng":80.235351},{"title":"Thudiyalur","image":"assets/images/equipment.jpg","address":"Thudiyalur HF-2, Subramaniya Layout, Opp. to Santham Apartment, Viswanathapuram Bus Stop, Thudiyalur, Coimbatore, Tamil Nadu 641034","gymName":"Pink Fitness Thudiyalur","lat":11.074449,"lng":76.940757},{"title":"Tirunelveli","image":"assets/images/morning.jpg","address":"1D/16, Above Hotel Nellai Saravana Bhava, Palayamkottai, Tirunelveli, Tamil Nadu 627002","gymName":"Pink Fitness Tirunelveli","lat":8.718666,"lng":77.733289},{"title":"T Nagar","image":"assets/images/personal.jpg","address":"Building No. 29, Dr. Nair Road, Opp. Grand Sweets,, Venkataraman Street, T.Nagar, Chennai, Tamil Nadu 600017","gymName":"Pink Fitness Tnagar","lat":13.0426742,"lng":80.2409506},{"title":"Trichy","image":"assets/images/pinkcover.jpg","address":"B 7 Ist Floor, Green's Avenue, Ist Cross North East Extension, Thillai Nagar, Tiruchirappalli, Tamil Nadu 620018","gymName":"Pink Fitness Trichy","lat":10.826259,"lng":78.686665},{"title":"Valasaravakkam","image":"assets/images/equipment.jpg","address":"5, First Floor, Arcot Road, Indira Nagar, Valasaravakkam, Above Titan Show Room, Chennai, Tamil Nadu 600087","gymName":"Pink Fitness Valasaravakkam","lat":13.04178,"lng":80.178957},{"title":"Velachery","image":"assets/images/pinkcover.jpg","address":"31, Near Sangeetha Hotel, Velachery Bypass Road, Chennai, Tamil Nadu 600042","gymName":"Pink Fitness Velachery","lat":12.990251,"lng":80.218848}]
    return JsonResponse({"details":arr})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def savecampaignpost(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        userid = username['id']
        postinfo = json.loads(request.body.decode('utf-8'))
        if username != None:
            if 'postid' in postinfo and postinfo['postid'] !='' and postinfo['postid'] !='null' and postinfo['postid'] !=None:
                cdata = CampaignFeed.objects.get(id = postinfo['postid'])
                if 'tagname' in postinfo and postinfo['tagname']:
                    cdata.tagName = postinfo['tagname']
                if 'message' in postinfo and postinfo['message'] != '':
                    cdata.feed = postinfo['message']
                if 'image' in postinfo:
                    cdata.imageUrl = postinfo['image']
                if 'video' in postinfo:
                    cdata.videoUrl = postinfo['video']
                cdata.save()
                return JsonResponse({"success": True, "message": "Post updated successfully"})
            else:
                cdata = CampaignFeed.objects.create(
                    user_id = userid,
                    company_id = 2
                )
                if 'tagname' in postinfo and postinfo['tagname'] != '':
                    cdata.tagName = postinfo['tagname']
                else:
                    cdata.tagName = 'wall'
                if 'message' in postinfo and postinfo['message'] != '':
                    cdata.feed = postinfo['message']
                if 'image' in postinfo and postinfo['image'] !='':
                    cdata.imageUrl = postinfo['image']
                if 'video' in postinfo and postinfo['video'] !='':
                    cdata.videoUrl = postinfo['video']
                cdata.save()
                return JsonResponse({"success":True,"message": "Post saved successfully"})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getPinkData(request):
    stratsessionutil = StartFitSessionUtil()
    postdata = json.loads(request.body.decode('utf-8'))
    arr = []
    rows = 10
    offset = (postdata['page'] - 1) * rows
    tot = postdata['page'] * rows
    if 'company' in postdata and postdata['company'] != None:
        if 'tagName' in postdata and postdata['tagName'] != None and postdata['tagName'] != "wall":
            getData = CampaignFeed.objects.filter(company_id=postdata['company'], status=1,tagName=postdata['tagName']).values().order_by('-id')[offset:tot]
            totalData = CampaignFeed.objects.filter(company_id=postdata['company'], status=1,tagName=postdata['tagName']).values().order_by('-id').count()
        else:
            getData = CampaignFeed.objects.filter(company_id=postdata['company'], status=1).values().order_by('-id')[offset:tot]
            totalData = CampaignFeed.objects.filter(company_id=postdata['company'], status=1).values().order_by('-id').count()
    else:
        if 'tagName' in postdata and postdata['tagName'] !=None and postdata['tagName'] !="wall":
            getData = CampaignFeed.objects.filter(company_id=2, status=1,tagName = postdata['tagName']).values().order_by('-id')[offset:tot]
            totalData = CampaignFeed.objects.filter(company_id=2, status=1,tagName = postdata['tagName']).values().order_by('-id').count()
        else:
            getData = CampaignFeed.objects.filter(company_id = 2,status=1).values().order_by('-id')[offset:tot]
            totalData = CampaignFeed.objects.filter(company_id=2, status=1).values().order_by('-id').count()

    for val in getData:
        valObj = dict(val)
        valObj['userLiked'] = False
        valObj['userComment'] = False
        valObj['userpost'] = False
        valObj['likeArr'] = []
        valObj['commentArr'] = []
        valObj['imageArr'] = []
        valObj['videoArr'] = []
        valObj['createdDate'] = valObj['createdDate'].strftime("%B %d %Y")
        userDetails = User.objects.get(id=valObj['user_id'])
        images = campaignImages.objects.filter(campaign_id = valObj['id']).values()
        if images.exists():
            for img in images:
                imgObj = dict(img)
                imgObj['imageUrl'] = 'https://s3.amazonaws.com/stratfitcelebritymedia/'+imgObj['imageUrl']
                valObj['imageArr'].append(imgObj)
        videos = campaignVideos.objects.filter(campaign_id = valObj['id']).values()
        if videos.exists():
            for vid in videos:
                vidObj = dict(vid)
                vidObj['videoUrl'] = 'https://s3.amazonaws.com/stratfitcelebritymedia/'+vidObj['videoUrl']
                valObj['videoArr'].append(vidObj)
        likes = CampaignLikes.objects.filter(campaignfeed_id = valObj['id']).values()
        if likes.exists():
            valObj['totalLikes'] = len(likes)
            for data in likes:
                dataObj = dict(data)
                userlikes = User.objects.get(id = dataObj['user_id'])
                valObj['likeArr'].append({"id":userlikes.id,"firstName":userlikes.first_name,"lname":userlikes.last_name,"avatar":settings.S3URL + str(userlikes.avatar)})
        else:
            valObj['totalLikes'] = 0
        comments = CampaignComments.objects.filter(campaignfeed_id = valObj['id']).values()
        if comments.exists():
            valObj['totalComments'] = len(comments)
            for x in comments:
                xObj = dict(x)
                usercomments = User.objects.get(id = xObj['user_id'])
                if usercomments.avatar !=None:
                    avatar = settings.S3URL + str(usercomments.avatar)
                else:
                    avatar = "http://stratfit.net/assets/images/user.png"
                valObj['commentArr'].append({"id":usercomments.id,"firstName":usercomments.first_name,"lname":usercomments.last_name,"avatar":avatar,"commentId":xObj['id'],"comments":xObj['comment']})
        else:
            valObj['totalComments'] = 0
        #print("no user","CAme Here")
        if request.META.get('HTTP_AUTHORIZATION') is not None:
            user = stratsessionutil.get_user_insession(request)
            #print(user,"CAme Here")
            userid = user['id']
            userpost = CampaignFeed.objects.filter(id=valObj['id'],user_id = userid)
            userLiked = CampaignLikes.objects.filter(user_id = userid,campaignfeed_id = valObj['id'])
            userCommented = CampaignComments.objects.filter(user_id=userid, campaignfeed_id=valObj['id'])
            if userpost.exists():
                valObj['userpost'] = True
            if userLiked.exists():
                valObj['userLiked'] = True
            if userCommented.exists():
                valObj['userComment'] = True
        valObj['firstName'] = userDetails.first_name
        valObj['lastName'] = userDetails.last_name
        if userDetails.avatar !=None:
            valObj['avatar'] = settings.S3URL + str(userDetails.avatar)
        else:
            valObj['avatar'] = ''
        if valObj['imageUrl'] is not None and valObj['imageUrl'] !='':
            valObj['imageUrl'] = "https://s3.amazonaws.com/stratfitcelebritymedia/" + valObj['imageUrl']
        if valObj['videoUrl'] is not None and valObj['videoUrl'] !='':
            valObj['videoUrl'] = "https://s3.amazonaws.com/stratfitcelebritymedia/" + valObj['videoUrl']
        arr.append(valObj)
    return JsonResponse({"success": True, "details": arr,"total":totalData})


@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getPinkData1(request):
    stratsessionutil = StartFitSessionUtil()
    postdata = json.loads(request.body.decode('utf-8'))
    arr = []
    finalArr = []
    advArr = []
    rows = 10
    offset = (postdata['page'] - 1) * rows
    tot = postdata['page'] * rows
    if 'company' in postdata and postdata['company'] != None:
        if 'tagName' in postdata and postdata['tagName'] != None and postdata['tagName'] != "wall":
            getData = CampaignFeed.objects.filter(company_id=postdata['company'], status=1,tagName=postdata['tagName']).values().order_by('-modifiedDate')[offset:tot]
            totalData = CampaignFeed.objects.filter(company_id=postdata['company'], status=1,tagName=postdata['tagName']).values().order_by('-id').count()
        else:
            getData = CampaignFeed.objects.filter(company_id=postdata['company'], status=1).values().order_by('-modifiedDate')[offset:tot]
            totalData = CampaignFeed.objects.filter(company_id=postdata['company'], status=1).values().order_by('-modifiedDate').count()
    else:
        if 'tagName' in postdata and postdata['tagName'] !=None and postdata['tagName'] !="wall":
            getData = CampaignFeed.objects.filter(company_id=2, status=1,tagName = postdata['tagName']).values().order_by('-modifiedDate')[offset:tot]
            totalData = CampaignFeed.objects.filter(company_id=2, status=1,tagName = postdata['tagName']).values().order_by('-modifiedDate').count()
        else:
            getData = CampaignFeed.objects.filter(company_id = 2,status=1).values().order_by('-modifiedDate')[offset:tot]
            totalData = CampaignFeed.objects.filter(company_id=2, status=1).values().order_by('-modifiedDate').count()

    for val in getData:
        valObj = dict(val)
        valObj['type'] = "Feed"
        valObj['userLiked'] = False
        valObj['userComment'] = False
        valObj['userpost'] = False
        valObj['likeArr'] = []
        valObj['commentArr'] = []
        valObj['imageArr'] = []
        valObj['videoArr'] = []
        valObj['createdDate'] = valObj['createdDate'].strftime("%B %d %Y")
        valObj['updatedDate'] = valObj['modifiedDate'].strftime("%Y-%m-%d")
        userDetails = User.objects.get(id=valObj['user_id'])
        images = campaignImages.objects.filter(campaign_id = valObj['id']).values()
        if images.exists():
            for img in images:
                imgObj = dict(img)
                imgObj['imageUrl'] = 'https://s3.amazonaws.com/stratfitcelebritymedia/'+imgObj['imageUrl']
                valObj['imageArr'].append(imgObj)
        videos = campaignVideos.objects.filter(campaign_id = valObj['id']).values()
        if videos.exists():
            for vid in videos:
                vidObj = dict(vid)
                vidObj['videoUrl'] = 'https://s3.amazonaws.com/stratfitcelebritymedia/'+vidObj['videoUrl']
                valObj['videoArr'].append(vidObj)
        likes = CampaignLikes.objects.filter(campaignfeed_id = valObj['id']).values()
        if likes.exists():
            valObj['totalLikes'] = len(likes)
            for data in likes:
                dataObj = dict(data)
                userlikes = User.objects.get(id = dataObj['user_id'])
                valObj['likeArr'].append({"id":userlikes.id,"firstName":userlikes.first_name,"lname":userlikes.last_name,"avatar":settings.S3URL + str(userlikes.avatar)})
        else:
            valObj['totalLikes'] = 0
        comments = CampaignComments.objects.filter(campaignfeed_id = valObj['id']).values()
        if comments.exists():
            valObj['totalComments'] = len(comments)
            for x in comments:
                xObj = dict(x)
                usercomments = User.objects.get(id = xObj['user_id'])
                if usercomments.avatar !=None:
                    avatar = settings.S3URL + str(usercomments.avatar)
                else:
                    avatar = "http://stratfit.net/assets/images/user.png"
                valObj['commentArr'].append({"id":usercomments.id,"firstName":usercomments.first_name,"lname":usercomments.last_name,"avatar":avatar,"commentId":xObj['id'],"comments":xObj['comment']})
        else:
            valObj['totalComments'] = 0
        #print("no user","CAme Here")
        if request.META.get('HTTP_AUTHORIZATION') is not None:
            user = stratsessionutil.get_user_insession(request)
            #print(user,"CAme Here")
            userid = user['id']
            userpost = CampaignFeed.objects.filter(id=valObj['id'],user_id = userid)
            userLiked = CampaignLikes.objects.filter(user_id = userid,campaignfeed_id = valObj['id'])
            userCommented = CampaignComments.objects.filter(user_id=userid, campaignfeed_id=valObj['id'])
            if userpost.exists():
                valObj['userpost'] = True
            if userLiked.exists():
                valObj['userLiked'] = True
            if userCommented.exists():
                valObj['userComment'] = True
        valObj['firstName'] = userDetails.first_name
        valObj['lastName'] = userDetails.last_name
        if userDetails.avatar !=None:
            valObj['avatar'] = settings.S3URL + str(userDetails.avatar)
        else:
            valObj['avatar'] = ''
        if valObj['imageUrl'] is not None and valObj['imageUrl'] !='':
            valObj['imageUrl'] = "https://s3.amazonaws.com/stratfitcelebritymedia/" + valObj['imageUrl']
        if valObj['videoUrl'] is not None and valObj['videoUrl'] !='':
            valObj['videoUrl'] = "https://s3.amazonaws.com/stratfitcelebritymedia/" + valObj['videoUrl']
        arr.append(valObj)
    if 'tagName' in postdata and postdata['tagName'] != None and postdata['tagName'] !="wall":
        advDetails = CreateAdv.objects.filter(advStatus = True,tagName = postdata['tagName']).order_by('-updatedDate').values()[offset:tot]
        totalData1 = CreateAdv.objects.filter(advStatus = True,tagName = postdata['tagName']).values().order_by('-updatedDate').count()
    else:
        advDetails = CreateAdv.objects.filter(advStatus=True).order_by('-updatedDate').values()[offset:tot]
        totalData1 = CreateAdv.objects.filter(advStatus = True).values().order_by('-updatedDate').count()
    if advDetails.exists():
        for obj in advDetails:
            objObj = dict(obj)
            objObj['advImage'] = "https://s3.amazonaws.com/stratfitmedia" + objObj['advImage']
            objObj ['createdDate'] = objObj ['createdDate'].strftime("%B %d %Y")
            objObj ['updatedDate'] = objObj ['updatedDate'].strftime("%Y-%m-%d")
            objObj['type'] = "Advertisement"
            advArr.append(objObj)
    finalArr = arr + advArr
    AcArr=[]
    totalData = totalData+totalData1 
    a = multikeysort(finalArr, ['-updatedDate'])
    for item in a:
        print(item,"sdvcsdcczc")
        AcArr.append(item)
    return JsonResponse({"success": True, "details": a,"total":totalData})

from operator import itemgetter as i
from functools import cmp_to_key

def multikeysort(items, columns):
    comparers = [
        ((i(col[1:].strip()), -1) if col.startswith('-') else (i(col.strip()), 1))
        for col in columns
    ]
    def comparer(left, right):
        comparer_iter = (
            cmp(fn(left), fn(right)) * mult
            for fn, mult in comparers
        )
        return next((result for result in comparer_iter if result), 0)
    return sorted(items, key=cmp_to_key(comparer))

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def deletecampaignpost(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        user = stratsessionutil.get_user_insession(request)
        postdata = json.loads(request.body.decode('utf-8'))
        #print(postdata)
        if user != None:
            if 'postid' in postdata:
                postid = postdata['postid']
                feed = CampaignFeed.objects.get(id = postid)
                feed.status = 0
                feed.save()
                return JsonResponse({"success":True,"message":"Post deleted successfully"})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def deletecomment(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        user = stratsessionutil.get_user_insession(request)
        cmtdata = json.loads(request.body.decode('utf-8'))
        #print(cmtdata)
        if user != None:
            if 'cid' in cmtdata:
                cid = cmtdata['cid']
                cmnt = CampaignComments.objects.get(id = cid)
                cmnt.delete()
                return JsonResponse({"success":True,"message":"comment deleted"})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def updatecomment(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        user = stratsessionutil.get_user_insession(request)
        editdata = json.loads(request.body.decode('utf-8'))
        if user != None:
            if 'cid' in editdata:
                cmnt = CampaignComments.objects.get(id = editdata['cid'])
                cmnt.comment = editdata['comment']
                cmnt.save()
                return JsonResponse({"success":True,"message":"comment updated"})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg":str(e)})

@never_cache
def vinodChannaUsers(request):
    arr = []
    x = connection.cursor()
    postdata = json.loads(request.body.decode('utf-8'))
    rows = 50
    offset = (postdata['page'] - 1) * rows
    tot = postdata['page'] * rows
    if 'company' in postdata and postdata['company'] != '':
        getplanUsers = "SELECT Subscriber_user.id AS uId,Subscriber_user.email AS uemail,Subscriber_user.first_name AS ufirstName,Subscriber_user.last_name AS ulastName, Subscriber_user.avatar AS uavatar,Subscriber_user.userCover AS ucover,Plan_plan.id AS planId, Plan_plan.price AS planPrice, Plan_plan.planPhoto AS planPhoto , Plan_plan.planName AS planName , Plan_plan.createdBy_id AS planCreatedBy ,Plan_plan.planLogo AS planLogo , Plan_plan.planDescription AS planDescription, Userplan_userplan.id AS userplanId FROM Userplan_userexercise LEFT JOIN Subscriber_user ON Subscriber_user.id = Userplan_userexercise.user_id LEFT JOIN Userplan_userplan ON Userplan_userplan.id = Userplan_userexercise.userplan_id LEFT JOIN Plan_plan ON Plan_plan.id = Userplan_userexercise.plan_id WHERE Userplan_userplan.status = 1 AND Plan_plan.createdBy_id = 8089 GROUP BY Subscriber_user.id "
    else:
        getplanUsers = "SELECT Subscriber_user.id AS uId,Subscriber_user.email AS uemail,Subscriber_user.first_name AS ufirstName,Subscriber_user.last_name AS ulastName, Subscriber_user.avatar AS uavatar,Subscriber_user.userCover AS ucover,Plan_plan.id AS planId, Plan_plan.price AS planPrice, Plan_plan.planPhoto AS planPhoto , Plan_plan.planName AS planName , Plan_plan.createdBy_id AS planCreatedBy ,Plan_plan.planLogo AS planLogo , Plan_plan.planDescription AS planDescription, Userplan_userplan.id AS userplanId FROM Userplan_userexercise LEFT JOIN Subscriber_user ON Subscriber_user.id = Userplan_userexercise.user_id LEFT JOIN Userplan_userplan ON Userplan_userplan.id = Userplan_userexercise.userplan_id LEFT JOIN Plan_plan ON Plan_plan.id = Userplan_userexercise.plan_id WHERE Userplan_userplan.status = 1 AND Plan_plan.createdBy_id = 8083 GROUP BY Subscriber_user.id "
    x.execute(getplanUsers)
    resultQuery = dictfetchall(x)
    total = len(resultQuery)
    result = resultQuery[offset:tot]
    for user in result:
        userObj = dict(user)
        if userObj['uavatar'] !=None:
            userObj['uavatar'] = settings.S3URL + str(userObj['uavatar'])
        else:
            userObj['uavatar'] = "http://stratfit.net/assets/images/user.png"

        if userObj['ucover'] !=None:
            userObj['ucover'] = settings.S3URL + str(userObj['ucover'])
        else:
            userObj['ucover'] = "http://stratfit.net/assets/images/user.png"

        if userObj['planLogo'] !=None:
            userObj['planLogo'] = settings.S3URL + str(userObj['planLogo'])
        else:
            userObj['planLogo'] = "http://stratfit.net/assets/images/user.png"
        if userObj['planPhoto'] !=None:
            userObj['planPhoto'] = settings.S3URL + str(userObj['planPhoto'])
        else:
            userObj['planPhoto'] = "https://s3.amazonaws.com/stratfitmedia/8083_userCover_494096.jpg"
        arr.append(userObj)
    return JsonResponse({"success": True, "details": arr,"total":total})


@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def savecampaignpostNew(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        userid = username['id']
        postinfo = json.loads(request.body.decode('utf-8'))
        if username != None:
            if 'postid' in postinfo and postinfo['postid'] !=None and postinfo['postid'] !='':
                cdata = CampaignFeed.objects.get(pk = postinfo['postid'])
                if 'tagname' in postinfo and postinfo['tagname'] != '':
                    cdata.tagName = postinfo['tagname']
                else:
                    cdata.tagName = 'wall'
                if 'message' in postinfo and postinfo['message'] != '':
                    cdata.feed = postinfo['message']
                cdata.save()
                if 'deletedImgArr' in postinfo and postinfo['deletedImgArr'] !='' and postinfo['deletedImgArr'] !=[]:
                    for delImg in postinfo['deletedImgArr']:
                        delImage = campaignImages.objects.get(id = delImg['id'])
                        delImage.delete()
                if 'image' in postinfo and postinfo['image'] !='' and postinfo['image'] !=[]:
                    for image in postinfo['image']:
                        createimages = campaignImages.objects.create(
                            imageUrl = image,
                            campaign_id = cdata.id
                        )
                        createimages.save()
                if 'videoArr' in postinfo and postinfo['videoArr'] !='' and postinfo['videoArr'] !=[]:
                    for video in postinfo['videoArr']:
                        createvideos = campaignVideos.objects.create(
                            videoUrl = video,
                            campaign_id = cdata.id
                        )
                        createvideos.save()
                return JsonResponse({"success":True,"message": "Post updated successfully"})
            else:
                cdata = CampaignFeed.objects.create(
                    user_id = userid
                )
                if 'company' in postinfo and postinfo['company'] != '':
                    cdata.company_id = postinfo['company']
                else:
                    cdata.company_id = 2
                if 'tagname' in postinfo and postinfo['tagname'] != '':
                    cdata.tagName = postinfo['tagname']
                else:
                    cdata.tagName = 'wall'
                if 'message' in postinfo and postinfo['message'] != '':
                    cdata.feed = postinfo['message']
                cdata.save()
                if 'imageArr' in postinfo and postinfo['imageArr'] !='' and postinfo['imageArr'] !=[]:
                    cdata.imageUrl = postinfo['imageArr'][0]
                    cdata.save()
                    for image in postinfo['imageArr']:
                        createimages = campaignImages.objects.create(
                            imageUrl = image,
                            campaign_id = cdata.id
                        )
                        createimages.save()
                if 'videoArr' in postinfo and postinfo['videoArr'] !='' and postinfo['videoArr'] !=[]:
                    cdata.videoUrl = postinfo['videoArr'][0]
                    cdata.save()
                    for video in postinfo['videoArr']:
                        createvideos = campaignVideos.objects.create(
                            videoUrl = video,
                            campaign_id = cdata.id
                        )
                        createvideos.save()
                return JsonResponse({"success":True,"message": "Post saved successfully"})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def savecomments(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        userid = username['id']
        cmmtsdata = json.loads(request.body.decode('utf-8'))
        #print(cmmtsdata)
        arr = []
        if username != None:
            cmnt = CampaignComments.objects.create(
                user_id = userid,
                campaignfeed_id = cmmtsdata['postfeedId'],
                comment = cmmtsdata['comment']
            )
            cmnt.save()
            usercomments = User.objects.get(id=userid)
            if usercomments.avatar != None and usercomments.avatar !='':
                usercomments.avatar = settings.S3URL + str(usercomments.avatar)
            else:
                usercomments.avatar = 'http://stratfit.net/assets/images/user.png'
            arr.append({"id": usercomments.id, "firstName": usercomments.first_name, "lname": usercomments.last_name, "avatar":usercomments.avatar , "commentId":cmnt.id,"comments": cmnt.comment})
            return JsonResponse({"success":True,"message":"comment saved","details":arr})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg":str(e)})
    
@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def savelikes(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        userid = username['id']
        cpdata = json.loads(request.body.decode('utf-8'))
        #print(cpdata)
        if username != None:
            existdata = CampaignLikes.objects.filter(user_id = userid ,campaignfeed_id = cpdata['likesdata']['id']).values('id')
            if existdata.exists():
                return JsonResponse({"success":False,"message":"Liked"})
            else:
                cdata = CampaignLikes.objects.create(
                    campaignfeed_id = cpdata['likesdata']['id'],
                    user_id = userid
                )
                cdata.save()
                return JsonResponse({"success":True,"message":"Liked"})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg":str(e)})

def equinoxJson(request):
    data = open(STATICDIR +'/equinox.json').read()  # opens the json file and saves the raw contents
    jsonData = json.loads(data)
    return JsonResponse({"details":jsonData})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getComapnies(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        arr = []
        if username != None:
            companyData = Company.objects.values()
            if companyData.exists():
                for val in companyData:
                    valObj = dict(val)
                    arr.append(valObj)
                return JsonResponse({"success":True,"details":arr})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def createAdv(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        arr = []
        reqdata = json.loads(request.body.decode('utf-8'))
        if username != None:
            if 'id' in reqdata and reqdata['id']!=None:
                companyData = CreateAdv.objects.get(pk= reqdata['id'])
                companyData.company_id = reqdata['company_id']
                companyData.createdById = username['id']
                companyData.updatedById = username['id']
                companyData.advStartDate = reqdata['advStartDate']
                companyData.advEndDate = reqdata['advEndDate']
                companyData.advName = reqdata['advName']
                companyData.tagName = reqdata['tagName']
                companyData.advTitle = reqdata['advTitle']
                companyData.advDescription = reqdata['advDescription']
                companyData.advImage = reqdata['advImage']
                companyData.advVideo = reqdata['advVideo']
                companyData.adLink = reqdata['adLink']
                companyData.save()
                return JsonResponse({"success": True, "message": "Advertisement Updated Successfully", "advId": companyData.id,"companyId": companyData.company_id})
            else:
                companyData = CreateAdv.objects.create(
                    company_id = reqdata['company_id'],
                    createdById = username['id'],
                    updatedById = username['id'],
                    advStartDate=reqdata['advStartDate'],
                    advEndDate=reqdata['advEndDate']
                )
                companyData.advName = reqdata['advName']
                companyData.tagName = reqdata['tagName']
                companyData.advTitle  = reqdata['advTitle']
                companyData.advDescription  = reqdata['advDescription']
                companyData.advImage  = reqdata['advImage']
                companyData.advVideo = reqdata['advVideo']
                companyData.adLink = reqdata['adLink']
                companyData.save()
                return JsonResponse({"success":True,"message":"Advertisement Created Successfully","advId":companyData.id,"companyId":companyData.company_id})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg":str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getAdvs(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        arr = []
        if username != None:
            advData = CreateAdv.objects.values().filter(createdById = username['id'])
            if advData.exists():
                for val in advData:
                    valObj = dict(val)
                    valObj['advStartDate'] = valObj['advStartDate']. strftime( "%Y-%m-%d")
                    valObj['advEndDate'] = valObj['advEndDate']. strftime( "%Y-%m-%d")
                    arr.append(valObj)
                return JsonResponse({"success": True, "details": arr})
            else:
                return JsonResponse({"success":False,"message":"No Advertisements available"})
        else:
            return JsonResponse({"success": False, "message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def createTransactions(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        arr = []
        reqdata = json.loads(request.body.decode('utf-8'))
        if username != None:
            createTras = checkoutAdv.objects.create(
                company_id = reqdata['CompanyId'],
                adv_id = reqdata['AdvId'],
                transaction_id = reqdata['transactionId'],
            )
            createTras.save()
            updateAdv = CreateAdv.objects.get(pk =reqdata['AdvId'])
            updateAdv.advStatus = 1
            updateAdv.save()
            return JsonResponse({"success":True,"message":"Payment Successful"})
        else:
            return JsonResponse({"success":False,"message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg":str(e)})

def getJson(request):
    jsonData = [{"title":"Dubai Collections","arr":[{"image":"http://www.shilpareddystudio.com/user_images/6808.jpg"},{"image":"http://www.shilpareddystudio.com/user_images/350953.jpg"},{"image":"http://www.shilpareddystudio.com/user_images/452842.jpg"},{"image":"http://www.shilpareddystudio.com/user_images/548395.jpg"},{"image":"http://www.shilpareddystudio.com/user_images/911045.jpg"},{"image":"http://www.shilpareddystudio.com/user_images/407009.jpg"},{"image":"http://www.shilpareddystudio.com/user_images/451302.jpg"},]},{"title":"Means Wear","arr":[{"image":"http://www.shilpareddystudio.com/user_images/896418.jpg"},{"image":"http://www.shilpareddystudio.com/user_images/978543.jpg"},{"image":"http://www.shilpareddystudio.com/user_images/852027.jpg"},{"image":"http://www.shilpareddystudio.com/user_images/526843.jpg"}]},{"title":"New York Collection","arr":[{"image":"http://www.shilpareddystudio.com/user_images/364335.jpg"},{"image":"http://www.shilpareddystudio.com/user_images/718007.jpg"},{"image":"http://www.shilpareddystudio.com/user_images/283950.jpg"},{"image":"http://www.shilpareddystudio.com/user_images/268537.jpg"},{"image":"http://www.shilpareddystudio.com/user_images/519695.jpg"},{"image":"http://www.shilpareddystudio.com/user_images/144853.jpg"},{"image":"http://www.shilpareddystudio.com/user_images/328657.jpg"},{"image":"http://www.shilpareddystudio.com/user_images/252914.jpg"}]},{"title":"Palatial Heirloom","arr":[{"image":"http://www.shilpareddystudio.com/user_images/494807.jpg"},{"image":"http://www.shilpareddystudio.com/user_images/780499.jpg"},{"image":"http://www.shilpareddystudio.com/user_images/131196.jpg"},{"image":"http://www.shilpareddystudio.com/user_images/307627.jpg"},{"image":"http://www.shilpareddystudio.com/user_images/683012.jpg"}]},{"title":"Sleepless Blue","arr":[{"image":"http://www.shilpareddystudio.com/user_images/429457.jpg"},{"image":"http://www.shilpareddystudio.com/user_images/168086.jpg"},{"image":"http://www.shilpareddystudio.com/user_images/948153.jpg"},{"image":"http://www.shilpareddystudio.com/user_images/641514.jpg"},{"image":"http://www.shilpareddystudio.com/user_images/244871.jpg"}]},{"title":"Suryothai","arr":[{"image":"http://www.shilpareddystudio.com/user_images/602168.jpg"},{"image":"http://www.shilpareddystudio.com/user_images/39667.jpg"},{"image":"http://www.shilpareddystudio.com/user_images/393513.jpg"},{"image":"http://www.shilpareddystudio.com/user_images/207965.jpg"},{"image":"http://www.shilpareddystudio.com/user_images/440662.jpg"}]}]
    return JsonResponse({"success":True,"details":jsonData})

def getJson1(request):
    jsonData = [{"title":"Collage","arr":[{"address":"153, Greams Road,<br>Thousand Lights West,<br>Thousand Lights,<br>Chennai,<br>Tamil Nadu - 600006.","lat":13.0604341,"lng":80.2537837}]},{"title":"Fuel","arr":[{"address":"539, Ground Floor,<br> Chowpatty View Building,<br>  Svp Road,<br>  Opera House,<br>  Mumbai - 400004.","lat":18.9560032,"lng":72.8134708}]},{"title":"Angasutra","arr":[{"address":"Plot no 8 & 9,<br>  Achyutha Cooperative Society,<br>  Road No 10,<br> Banjara Hills,<br>  Hyderabad,  Telangana - 500034.","lat":17.4158559,"lng":78.4396089}]},{"title":"Also","arr":[{"address":"Opp. Saptaparni,<br>  Rd Number 8,<br>  Banjara Hills,<br>  Hyderabad,  Telangana - 50003.","lat":17.4158895,"lng":78.4395836}]}]
    return JsonResponse({"success": True, "details": jsonData})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getAdvsApp(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        arr = []
        if username != None:
            advData = CreateAdv.objects.values().filter(advStatus = 1)
            if advData.exists():
                for val in advData:
                    valObj = dict(val)
                    valObj['advStartDate'] = valObj['advStartDate']. strftime( "%Y-%m-%d")
                    valObj['advEndDate'] = valObj['advEndDate']. strftime( "%Y-%m-%d")
                    arr.append(valObj)
                return JsonResponse({"success": True, "details": arr})
            else:
                return JsonResponse({"success":False,"message":"No Advertisements available"})
        else:
            return JsonResponse({"success": False, "message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def getPriceClassification(request):
    stratsessionutil = StartFitSessionUtil()
    try:
        username = stratsessionutil.get_user_insession(request)
        arr = []
        if username != None:
            PriceData = PriceClassification.objects.select_related('Company').values('createdById','company_id','company_id__companyName','price','adPeriod')
            if PriceData.exists():
                for val in PriceData:
                    valObj = dict(val)
                    if valObj['adPeriod'] == 1:
                        valObj['period'] = "Daily"
                    if valObj['adPeriod'] == 2:
                        valObj['period'] = "Weekly"
                    if valObj['adPeriod'] ==3:
                        valObj['period'] = "Monthly"
                    if valObj['adPeriod'] == 4:
                        valObj['period'] = "Quarterly"
                    if valObj['adPeriod'] == 5:
                        valObj['period'] = "Half Yearly"
                    if valObj['adPeriod'] == 6:
                        valObj['period'] = "Yearly"
                    arr.append(valObj)
            return JsonResponse({"success": True, "details": arr})
        else:
            return JsonResponse({"success": False, "message": "user logged out"})
    except Exception as e:
        logger.exception("something wrong")
        return JsonResponse({"msg": str(e)})

@api_view(['GET', 'POST'])
@authentication_classes((SessionAuthentication, IsAuthenticated))
@never_cache
def createPriceClassification(request):
        stratsessionutil = StartFitSessionUtil()
        try:
            username = stratsessionutil.get_user_insession(request)
            reqdata = json.loads(request.body.decode('utf-8'))
            if username != None:
                if 'id' in reqdata and reqdata['id'] != None:
                    PriceData = PriceClassification.objects.get(pk=reqdata['id'])
                    PriceData.price = reqdata['price']
                    PriceData.company_id = reqdata['company_id']
                    PriceData.createdById = username['id']
                    PriceData.updatedById = username['id']
                    PriceData.adPeriod = reqdata['adPeriod']
                    PriceData.save()
                    return JsonResponse({"success": True, "message": "PriceClassification Updated Successfully", "priId": PriceData.id})
                else:
                    PriceData = PriceClassification.objects.create(
                        price=reqdata['price'],
                        company_id=reqdata['company_id'],
                        createdById=username['id'],
                        updatedById=username['id'],
                        adPeriod=reqdata['adPeriod'],

                    )
                    PriceData.save()
                    return JsonResponse({"success": True, "message": "PriceClassification Created Successfully", "priId": PriceData.id})
            else:
                return JsonResponse({"success": False, "message": "user logged out"})
        except Exception as e:
            logger.exception("something wrong")
            return JsonResponse({"msg": str(e)})