from django.db import models
from Subscriber.models import User

# Create your models here.
class Company(models.Model):
    companyName = models.CharField(max_length=255)
    status = models.BooleanField(default=True)

class CreateAdv(models.Model):
    company = models.ForeignKey(Company, on_delete=models.CASCADE)
    advName = models.CharField(max_length=255)
    advTitle = models.CharField(max_length=255)
    advDescription = models.TextField(null=True)
    advImage = models.CharField(max_length=255,null=True)
    advVideo = models.CharField(max_length=255,null=True)
    advStartDate = models.DateTimeField()
    advEndDate = models.DateTimeField()
    createdById = models.IntegerField(null=True)
    updatedById = models.IntegerField(null=True)
    createdDate = models.DateTimeField(auto_now_add=True)
    updatedDate = models.DateTimeField(auto_now=True)
    advStatus = models.BooleanField(null=True)
    tagName = models.CharField(max_length=255,null=True)
    adLink = models.TextField(null=True)

class CreateCoupon(models.Model):
    advId = models.ForeignKey(CreateAdv, on_delete=models.CASCADE)
    couponCode = models.CharField(max_length=255)

class checkoutAdv(models.Model):
    company = models.ForeignKey(Company, on_delete=models.CASCADE)
    adv = models.ForeignKey(CreateAdv,null = True, on_delete=models.CASCADE)
    transaction_id = models.TextField(null = True)

class PriceClassification(models.Model):
    createdById = models.IntegerField(null=True)
    updatedById = models.IntegerField(null=True)
    company = models.ForeignKey(Company, on_delete=models.CASCADE)
    price = models.FloatField()
    DAILY = 1
    WEEKLY = 2
    MONTHLY = 3
    QUATERLY = 4
    HALFYEARLY = 5
    YEARLY = 6
    AD_PERIOD_CHOICES = (
        (DAILY, ('DAILY')),
        (WEEKLY, ('WEEKLY')),
        (MONTHLY, ('MONTHLY')),
        (QUATERLY, ('QUATERLY')),
        (HALFYEARLY, ('HALFYEARLY')),
        (YEARLY, ('YEARLY')),
    )
    adPeriod = models.SmallIntegerField(choices=AD_PERIOD_CHOICES,null=True,blank=True)