# Generated by Django 4.1.5 on 2023-04-08 12:39

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Company',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('companyName', models.CharField(max_length=255)),
                ('status', models.BooleanField(default=True)),
            ],
        ),
        migrations.CreateModel(
            name='CreateAdv',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('advName', models.CharField(max_length=255)),
                ('advTitle', models.CharField(max_length=255)),
                ('advDescription', models.TextField(null=True)),
                ('advImage', models.CharField(max_length=255, null=True)),
                ('advVideo', models.CharField(max_length=255, null=True)),
                ('advStartDate', models.DateTimeField()),
                ('advEndDate', models.DateTimeField()),
                ('createdById', models.IntegerField(null=True)),
                ('updatedById', models.IntegerField(null=True)),
                ('createdDate', models.DateTimeField(auto_now_add=True)),
                ('updatedDate', models.DateTimeField(auto_now=True)),
                ('advStatus', models.BooleanField(null=True)),
                ('tagName', models.CharField(max_length=255, null=True)),
                ('adLink', models.TextField(null=True)),
                ('company', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='Company.company')),
            ],
        ),
        migrations.CreateModel(
            name='PriceClassification',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('createdById', models.IntegerField(null=True)),
                ('updatedById', models.IntegerField(null=True)),
                ('price', models.FloatField()),
                ('adPeriod', models.SmallIntegerField(blank=True, choices=[(1, 'DAILY'), (2, 'WEEKLY'), (3, 'MONTHLY'), (4, 'QUATERLY'), (5, 'HALFYEARLY'), (6, 'YEARLY')], null=True)),
                ('company', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='Company.company')),
            ],
        ),
        migrations.CreateModel(
            name='CreateCoupon',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('couponCode', models.CharField(max_length=255)),
                ('advId', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='Company.createadv')),
            ],
        ),
        migrations.CreateModel(
            name='checkoutAdv',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('transaction_id', models.TextField(null=True)),
                ('adv', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='Company.createadv')),
                ('company', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='Company.company')),
            ],
        ),
    ]
