from django.db import models

# Create your models here.
from Plan.models import Plan
from Subscriber.models import User
from Userplan.models import UserPlan, UserSets, UserExercise


class CelebrityComments(models.Model):
    celebrityId=models.ForeignKey(User,null=True, blank=True, on_delete=models.CASCADE)
    createdBy = models.ForeignKey(User,null=True, blank=True,related_name="celebrity_cr", on_delete=models.CASCADE)
    planId = models.ForeignKey(UserPlan,null=True,blank=True, on_delete=models.CASCADE)
    comment = models.CharField(max_length=50, blank=False)
    userset_id = models.IntegerField(null=True)
    status = models.BooleanField(default=True)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class CelebrityLikes(models.Model):
    celebrityId = models.ForeignKey(User,null=True, blank=True, on_delete=models.CASCADE)
    set = models.ForeignKey(UserSets,null=True, on_delete=models.CASCADE)
    createdBy = models.ForeignKey(User,null=True, blank=True,related_name="celeb_like", on_delete=models.CASCADE)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)

class CelebrityUploads(models.Model):
    userexercise = models.ForeignKey(UserExercise, on_delete=models.CASCADE)
    userSet = models.ForeignKey(UserSets,null=True, on_delete=models.CASCADE)
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    imageUrl = models.TextField(null=True, blank=True)
    videoUrl = models.TextField(null=True, blank=True)
    text = models.TextField(null=True, blank=True)
    status = models.IntegerField(default=1)
    createdDate = models.DateTimeField(auto_now_add=True)
    modifiedDate = models.DateTimeField(auto_now=True)


class CelebrityDetails(models.Model):
    userid = models.ForeignKey(User,related_name='cele_user', on_delete=models.CASCADE)
    designation = models.CharField(max_length=255,null=True, blank=True)
    about = models.TextField(null=True, blank=True)
    favWorkout = models.TextField(null=True, blank=True)

class CelebrityPlansLikes(models.Model):
    plan = models.ForeignKey(Plan, related_name='cplan_id', on_delete=models.CASCADE)
    user = models.ForeignKey(User, related_name='celeplan_id', on_delete=models.CASCADE)
    reviews = models.TextField(null=True)
    status = models.IntegerField(default=1)
